/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RollbackToInstantTimeProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q4A\u0001E\t\u0001A!)\u0001\u0006\u0001C\u0001S!91\u0006\u0001b\u0001\n\u0013a\u0003B\u0002\u001c\u0001A\u0003%Q\u0006C\u00048\u0001\t\u0007I\u0011\u0002\u001d\t\r}\u0002\u0001\u0015!\u0003:\u0011\u0015\u0001\u0005\u0001\"\u0001-\u0011\u0015\t\u0005\u0001\"\u00019\u0011\u0015\u0011\u0005\u0001\"\u0011D\u0011\u0015I\u0006\u0001\"\u0011[\u000f\u0015q\u0016\u0003#\u0001`\r\u0015\u0001\u0012\u0003#\u0001a\u0011\u0015A3\u0002\"\u0001e\u0011\u001d)7B1A\u0005\u0002\u0019Daa\\\u0006!\u0002\u00139\u0007\"\u00029\f\t\u0003\t(A\b*pY2\u0014\u0017mY6U_&s7\u000f^1oiRKW.\u001a)s_\u000e,G-\u001e:f\u0015\t\u00112#\u0001\u0006qe>\u001cW\rZ;sKNT!\u0001F\u000b\u0002\u000f\r|W.\\1oI*\u0011acF\u0001\u0005QV$\u0017N\u0003\u0002\u00193\u0005\u00191/\u001d7\u000b\u0005iY\u0012!B:qCJ\\'B\u0001\u000f\u001e\u0003\u0019\t\u0007/Y2iK*\ta$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001C\u0015\u0002\"AI\u0012\u000e\u0003EI!\u0001J\t\u0003\u001b\t\u000b7/\u001a)s_\u000e,G-\u001e:f!\t\u0011c%\u0003\u0002(#\t\u0001\u0002K]8dK\u0012,(/\u001a\"vS2$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0002\"A\t\u0001\u0002\u0015A\u000b%+Q'F)\u0016\u00136+F\u0001.!\rq\u0013gM\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t)\u0011I\u001d:bsB\u0011!\u0005N\u0005\u0003kE\u0011!\u0003\u0015:pG\u0016$WO]3QCJ\fW.\u001a;fe\u0006Y\u0001+\u0011*B\u001b\u0016#VIU*!\u0003-yU\u000b\u0016)V)~#\u0016\fU#\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR!\u0001P\f\u0002\u000bQL\b/Z:\n\u0005yZ$AC*ueV\u001cG\u000fV=qK\u0006aq*\u0016+Q+R{F+\u0017)FA\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0002\u0015=,H\u000f];u)f\u0004X-\u0001\u0003dC2dGC\u0001#U!\r)U\n\u0015\b\u0003\r.s!a\u0012&\u000e\u0003!S!!S\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0014B\u0001'0\u0003\u001d\u0001\u0018mY6bO\u0016L!AT(\u0003\u0007M+\u0017O\u0003\u0002M_A\u0011\u0011KU\u0007\u0002/%\u00111k\u0006\u0002\u0004%><\b\"B+\t\u0001\u00041\u0016\u0001B1sON\u0004\"AI,\n\u0005a\u000b\"!\u0004)s_\u000e,G-\u001e:f\u0003J<7/A\u0003ck&dG-F\u0001\\!\t\u0011C,\u0003\u0002^#\tI\u0001K]8dK\u0012,(/Z\u0001\u001f%>dGNY1dWR{\u0017J\\:uC:$H+[7f!J|7-\u001a3ve\u0016\u0004\"AI\u0006\u0014\u0005-\t\u0007C\u0001\u0018c\u0013\t\u0019wF\u0001\u0004B]f\u0014VM\u001a\u000b\u0002?\u0006!a*Q'F+\u00059\u0007C\u00015m\u001d\tI'\u000e\u0005\u0002H_%\u00111nL\u0001\u0007!J,G-\u001a4\n\u00055t'AB*ue&twM\u0003\u0002l_\u0005)a*Q'FA\u00059!-^5mI\u0016\u0014X#\u0001:\u0011\u0007MTX%D\u0001u\u0015\t)h/\u0001\u0005gk:\u001cG/[8o\u0015\t9\b0\u0001\u0003vi&d'\"A=\u0002\t)\fg/Y\u0005\u0003wR\u0014\u0001bU;qa2LWM\u001d")
public class RollbackToInstantTimeProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(1, "instant_time", DataTypes.StringType, None$.MODULE$)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("rollback_result", DataTypes.BooleanType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return RollbackToInstantTimeProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RollbackToInstantTimeProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        Seq seq;
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        String instantTime = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get();
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        try (SparkRDDWriteClient client = null;){
            client = HoodieCLIUtils$.MODULE$.createHoodieWriteClient(this.sparkSession(), basePath, Predef$.MODULE$.Map().empty(), Option$.MODULE$.apply((Object)table));
            client.getConfig().setValue(HoodieWriteConfig.ROLLBACK_USING_MARKERS_ENABLE, "false");
            HoodieWriteConfig config = this.getWriteConfig(basePath);
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(config.getBasePath()).setLoadActiveTimelineOnLoad(false).setConsistencyGuardConfig(config.getConsistencyGuardConfig()).setLayoutVersion(Option.of((Object)new TimelineLayoutVersion(config.getTimelineLayoutVersion()))).build();
            HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
            HoodieTimeline completedTimeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
            boolean filteredTimeline = completedTimeline.containsInstant(instantTime);
            if (!filteredTimeline) {
                throw new HoodieException(new StringBuilder(29).append("Commit ").append(instantTime).append(" not found in Commits ").append(completedTimeline).toString());
            }
            boolean result = client.rollback(instantTime);
            this.spark().catalog().refreshTable(table);
            Row outputRow = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)result)}));
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{outputRow}));
        }
        return seq;
    }

    @Override
    public Procedure build() {
        return new RollbackToInstantTimeProcedure();
    }
}

