/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowCommitPartitionsProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001\u0002\n\u0014\u0001\tBQA\u000b\u0001\u0005\u0002-Bq!\f\u0001C\u0002\u0013%a\u0006\u0003\u00049\u0001\u0001\u0006Ia\f\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\t\u0005\u0001)A\u0005w!)!\t\u0001C\u0001]!)1\t\u0001C\u0001u!)A\t\u0001C!\u000b\")1\f\u0001C!9\")\u0001\r\u0001C\u0005C\")a\u0010\u0001C\u0005\u007f\u001e9\u0011QC\n\t\u0002\u0005]aA\u0002\n\u0014\u0011\u0003\tI\u0002\u0003\u0004+\u001b\u0011\u0005\u0011\u0011\u0005\u0005\n\u0003Gi!\u0019!C\u0001\u0003KA\u0001\"!\u000e\u000eA\u0003%\u0011q\u0005\u0005\b\u0003oiA\u0011AA\u001d\u0005u\u0019\u0006n\\<D_6l\u0017\u000e\u001e)beRLG/[8ogB\u0013xnY3ekJ,'B\u0001\u000b\u0016\u0003)\u0001(o\\2fIV\u0014Xm\u001d\u0006\u0003-]\tqaY8n[\u0006tGM\u0003\u0002\u00193\u0005!\u0001.\u001e3j\u0015\tQ2$A\u0002tc2T!\u0001H\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0002\u0001'\r\u00011e\n\t\u0003I\u0015j\u0011aE\u0005\u0003MM\u0011QBQ1tKB\u0013xnY3ekJ,\u0007C\u0001\u0013)\u0013\tI3C\u0001\tQe>\u001cW\rZ;sK\n+\u0018\u000e\u001c3fe\u00061A(\u001b8jiz\"\u0012\u0001\f\t\u0003I\u0001\t!\u0002U!S\u00036+E+\u0012*T+\u0005y\u0003c\u0001\u00194k5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014GA\u0003BeJ\f\u0017\u0010\u0005\u0002%m%\u0011qg\u0005\u0002\u0013!J|7-\u001a3ve\u0016\u0004\u0016M]1nKR,'/A\u0006Q\u0003J\u000bU*\u0012+F%N\u0003\u0013aC(V)B+Fk\u0018+Z!\u0016+\u0012a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0003}e\tQ\u0001^=qKNL!\u0001Q\u001f\u0003\u0015M#(/^2u)f\u0004X-\u0001\u0007P+R\u0003V\u000bV0U3B+\u0005%\u0001\u0006qCJ\fW.\u001a;feN\f!b\\;uaV$H+\u001f9f\u0003\u0011\u0019\u0017\r\u001c7\u0015\u0005\u00193\u0006cA$P%:\u0011\u0001*\u0014\b\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017\u0006\na\u0001\u0010:p_Rt\u0014\"\u0001\u001a\n\u00059\u000b\u0014a\u00029bG.\fw-Z\u0005\u0003!F\u00131aU3r\u0015\tq\u0015\u0007\u0005\u0002T)6\t\u0011$\u0003\u0002V3\t\u0019!k\\<\t\u000b]C\u0001\u0019\u0001-\u0002\t\u0005\u0014xm\u001d\t\u0003IeK!AW\n\u0003\u001bA\u0013xnY3ekJ,\u0017I]4t\u0003\u0015\u0011W/\u001b7e+\u0005i\u0006C\u0001\u0013_\u0013\ty6CA\u0005Qe>\u001cW\rZ;sK\u0006\u0019r-\u001a;D_6l\u0017\u000e\u001e$pe&s7\u000f^1oiR\u0019!\r\u001d;\u0011\u0007A\u001aW-\u0003\u0002ec\t1q\n\u001d;j_:\u0004\"A\u001a8\u000e\u0003\u001dT!\u0001[5\u0002\u0011QLW.\u001a7j]\u0016T!A[6\u0002\u000bQ\f'\r\\3\u000b\u00051l\u0017AB2p[6|gN\u0003\u0002\u0019;%\u0011qn\u001a\u0002\u000e\u0011>|G-[3J]N$\u0018M\u001c;\t\u000b!T\u0001\u0019A9\u0011\u0005\u0019\u0014\u0018BA:h\u00059Aun\u001c3jKRKW.\u001a7j]\u0016DQ!\u001e\u0006A\u0002Y\f1\"\u001b8ti\u0006tG\u000fV5nKB\u0011qo\u001f\b\u0003qf\u0004\"!S\u0019\n\u0005i\f\u0014A\u0002)sK\u0012,g-\u0003\u0002}{\n11\u000b\u001e:j]\u001eT!A_\u0019\u0002/\u001d,G\u000fS8pI&,7i\\7nSRlU\r^1eCR\fGCBA\u0001\u0003\u001f\t\t\u0002\u0005\u00031G\u0006\r\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%1.A\u0003n_\u0012,G.\u0003\u0003\u0002\u000e\u0005\u001d!\u0001\u0006%p_\u0012LWmQ8n[&$X*\u001a;bI\u0006$\u0018\rC\u0003i\u0017\u0001\u0007\u0011\u000f\u0003\u0004\u0002\u0014-\u0001\rAY\u0001\u000eQ>|G-[3J]N$\u0018M\u001c;\u0002;MCwn^\"p[6LG\u000fU1si&$\u0018n\u001c8t!J|7-\u001a3ve\u0016\u0004\"\u0001J\u0007\u0014\u00075\tY\u0002E\u00021\u0003;I1!a\b2\u0005\u0019\te.\u001f*fMR\u0011\u0011qC\u0001\u0005\u001d\u0006kU)\u0006\u0002\u0002(A!\u0011\u0011FA\u001a\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012\u0001\u00027b]\u001eT!!!\r\u0002\t)\fg/Y\u0005\u0004y\u0006-\u0012!\u0002(B\u001b\u0016\u0003\u0013a\u00022vS2$WM]\u000b\u0003\u0003w\u0001R!!\u0010\u0002H\u001dj!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\tMVt7\r^5p]*!\u0011QIA\u0018\u0003\u0011)H/\u001b7\n\t\u0005%\u0013q\b\u0002\t'V\u0004\b\u000f\\5fe\u0002")
public class ShowCommitPartitionsProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.required(2, "instant_time", DataTypes.StringType, None$.MODULE$)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("partition_path", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("total_files_added", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_files_updated", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_records_inserted", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_records_updated", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_bytes_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_errors", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowCommitPartitionsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowCommitPartitionsProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        String instantTime = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get();
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        Option<HoodieInstant> hoodieInstantOption = this.getCommitForInstant(timeline, instantTime);
        Option<HoodieCommitMetadata> commitMetadataOptional = this.getHoodieCommitMetadata(timeline, hoodieInstantOption);
        if (commitMetadataOptional.isEmpty()) {
            throw new HoodieException(new StringBuilder(30).append("Commit ").append(instantTime).append(" not found in Commits ").append(timeline).append(".").toString());
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)commitMetadataOptional.get();
        ArrayList rows = new ArrayList();
        JavaConversions$.MODULE$.deprecated$u0020asScalaSet(meta.getPartitionToWriteStats().entrySet()).foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ShowCommitPartitionsProcedure.$anonfun$call$1(hoodieInstantOption, rows, entry)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    @Override
    public Procedure build() {
        return new ShowCommitPartitionsProcedure();
    }

    private Option<HoodieInstant> getCommitForInstant(HoodieTimeline timeline, String instantTime) {
        List<Object> instants = Arrays.asList((Object[])new HoodieInstant[]{new HoodieInstant(false, "commit", instantTime), new HoodieInstant(false, "replacecommit", instantTime), new HoodieInstant(false, "deltacommit", instantTime)});
        Option hoodieInstant = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(instants).find((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)timeline.containsInstant(i)));
        return hoodieInstant;
    }

    private Option<HoodieCommitMetadata> getHoodieCommitMetadata(HoodieTimeline timeline, Option<HoodieInstant> hoodieInstant) {
        Option option;
        if (hoodieInstant.isDefined()) {
            String string = ((HoodieInstant)hoodieInstant.get()).getAction();
            String string2 = "replacecommit";
            option = !(string != null ? !string.equals(string2) : string2 != null) ? Option$.MODULE$.apply(HoodieReplaceCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails((HoodieInstant)hoodieInstant.get()).get()), HoodieReplaceCommitMetadata.class)) : Option$.MODULE$.apply(HoodieCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails((HoodieInstant)hoodieInstant.get()).get()), HoodieCommitMetadata.class));
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public static final /* synthetic */ void $anonfun$call$2(LongRef totalFilesAdded$1, LongRef totalFilesUpdated$1, LongRef totalRecordsUpdated$1, LongRef totalRecordsInserted$1, LongRef totalBytesWritten$1, LongRef totalWriteErrors$1, HoodieWriteStat stat) {
        String string = stat.getPrevCommit();
        String string2 = "null";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            ++totalFilesAdded$1.elem;
        } else {
            ++totalFilesUpdated$1.elem;
            totalRecordsUpdated$1.elem += stat.getNumUpdateWrites();
        }
        totalRecordsInserted$1.elem += stat.getNumInserts();
        totalBytesWritten$1.elem += stat.getTotalWriteBytes();
        totalWriteErrors$1.elem += stat.getTotalWriteErrors();
    }

    public static final /* synthetic */ boolean $anonfun$call$1(Option hoodieInstantOption$1, ArrayList rows$1, Map.Entry entry) {
        String action = ((HoodieInstant)hoodieInstantOption$1.get()).getAction();
        String path = (String)entry.getKey();
        List stats = (List)entry.getValue();
        LongRef totalFilesAdded = LongRef.create((long)0L);
        LongRef totalFilesUpdated = LongRef.create((long)0L);
        LongRef totalRecordsUpdated = LongRef.create((long)0L);
        LongRef totalRecordsInserted = LongRef.create((long)0L);
        LongRef totalBytesWritten = LongRef.create((long)0L);
        LongRef totalWriteErrors = LongRef.create((long)0L);
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(stats).foreach((Function1 & Serializable & scala.Serializable)stat -> {
            ShowCommitPartitionsProcedure.$anonfun$call$2(totalFilesAdded, totalFilesUpdated, totalRecordsUpdated, totalRecordsInserted, totalBytesWritten, totalWriteErrors, stat);
            return BoxedUnit.UNIT;
        });
        return rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, path, BoxesRunTime.boxToLong((long)totalFilesAdded.elem), BoxesRunTime.boxToLong((long)totalFilesUpdated.elem), BoxesRunTime.boxToLong((long)totalRecordsInserted.elem), BoxesRunTime.boxToLong((long)totalRecordsUpdated.elem), BoxesRunTime.boxToLong((long)totalBytesWritten.elem), BoxesRunTime.boxToLong((long)totalWriteErrors.elem)})));
    }
}

