/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ValidateHoodieSyncProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\tMa\u0001B\u000b\u0017\u0001\u0015BQa\r\u0001\u0005\u0002QBqA\u000e\u0001C\u0002\u0013%q\u0007\u0003\u0004B\u0001\u0001\u0006I\u0001\u000f\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0011\u0019Q\u0005\u0001)A\u0005\t\")1\n\u0001C!\u0019\")\u0001\u000b\u0001C!o!)\u0011\u000b\u0001C!\u0007\")!\u000b\u0001C!'\")\u0011\u000e\u0001C\u0001U\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002bBA\u0012\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003G\u0001A\u0011BAL\u0011\u001d\t9\f\u0001C\u0001\u0003s;q!!9\u0017\u0011\u0003\t\u0019O\u0002\u0004\u0016-!\u0005\u0011Q\u001d\u0005\u0007gA!\t!!<\t\u0013\u0005=\bC1A\u0005\u0002\u0005E\b\u0002CA\u007f!\u0001\u0006I!a=\t\u000f\u0005}\b\u0003\"\u0001\u0003\u0002\tYb+\u00197jI\u0006$X\rS8pI&,7+\u001f8d!J|7-\u001a3ve\u0016T!a\u0006\r\u0002\u0015A\u0014xnY3ekJ,7O\u0003\u0002\u001a5\u000591m\\7nC:$'BA\u000e\u001d\u0003\u0011AW\u000fZ5\u000b\u0005uq\u0012aA:rY*\u0011q\u0004I\u0001\u0006gB\f'o\u001b\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00011#&\f\t\u0003O!j\u0011AF\u0005\u0003SY\u0011QBQ1tKB\u0013xnY3ekJ,\u0007CA\u0014,\u0013\tacC\u0001\tQe>\u001cW\rZ;sK\n+\u0018\u000e\u001c3feB\u0011a&M\u0007\u0002_)\u0011\u0001GH\u0001\tS:$XM\u001d8bY&\u0011!g\f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tQ\u0007\u0005\u0002(\u0001\u0005Q\u0001+\u0011*B\u001b\u0016#VIU*\u0016\u0003a\u00022!\u000f\u001f?\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR$!B!se\u0006L\bCA\u0014@\u0013\t\u0001eC\u0001\nQe>\u001cW\rZ;sKB\u000b'/Y7fi\u0016\u0014\u0018a\u0003)B%\u0006kU\tV#S'\u0002\n1bT+U!V#v\fV-Q\u000bV\tA\t\u0005\u0002F\u00116\taI\u0003\u0002H9\u0005)A/\u001f9fg&\u0011\u0011J\u0012\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017\u0001D(V)B+Fk\u0018+Z!\u0016\u0003\u0013!\u00022vS2$W#A'\u0011\u0005\u001dr\u0015BA(\u0017\u0005%\u0001&o\\2fIV\u0014X-\u0001\u0006qCJ\fW.\u001a;feN\f!b\\;uaV$H+\u001f9f\u0003\u0011\u0019\u0017\r\u001c7\u0015\u0005Q#\u0007cA+^A:\u0011ak\u0017\b\u0003/jk\u0011\u0001\u0017\u0006\u00033\u0012\na\u0001\u0010:p_Rt\u0014\"A\u001e\n\u0005qS\u0014a\u00029bG.\fw-Z\u0005\u0003=~\u00131aU3r\u0015\ta&\b\u0005\u0002bE6\tA$\u0003\u0002d9\t\u0019!k\\<\t\u000b\u0015L\u0001\u0019\u00014\u0002\t\u0005\u0014xm\u001d\t\u0003O\u001dL!\u0001\u001b\f\u0003\u001bA\u0013xnY3ekJ,\u0017I]4t\u0003%9W\r^*ue&tw\rF\u0006lgz\fi!!\u0005\u0002\u001c\u0005}\u0001C\u00017q\u001d\tig\u000e\u0005\u0002Xu%\u0011qNO\u0001\u0007!J,G-\u001a4\n\u0005E\u0014(AB*ue&twM\u0003\u0002pu!)AO\u0003a\u0001k\u00061A/\u0019:hKR\u0004\"A\u001e?\u000e\u0003]T!\u0001_=\u0002\u000bQ\f'\r\\3\u000b\u0005i\\\u0018AB2p[6|gN\u0003\u0002\u001cA%\u0011Qp\u001e\u0002\u0016\u0011>|G-[3UC\ndW-T3uC\u000ec\u0017.\u001a8u\u0011\u0019y(\u00021\u0001\u0002\u0002\u0005qA/\u0019:hKR$\u0016.\\3mS:,\u0007\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001dq/\u0001\u0005uS6,G.\u001b8f\u0013\u0011\tY!!\u0002\u0003\u001d!{w\u000eZ5f)&lW\r\\5oK\"1\u0011q\u0002\u0006A\u0002U\faa]8ve\u000e,\u0007bBA\n\u0015\u0001\u0007\u0011QC\u0001\fg>,(oY3D_VtG\u000fE\u0002:\u0003/I1!!\u0007;\u0005\u0011auN\\4\t\u000f\u0005u!\u00021\u0001\u0002\u0016\u0005YA/\u0019:hKR\u001cu.\u001e8u\u0011\u0019\t\tC\u0003a\u0001W\u0006\u00112o\\;sG\u0016d\u0015\r^3ti\u000e{W.\\5u\u00031\u0019w.\u001e8u%\u0016\u001cwN\u001d3t)1\t)\"a\n\u0002,\u00055\u0012\u0011GA\u001b\u0011\u0019\tIc\u0003a\u0001W\u00069!\u000e\u001a2d+Jd\u0007BBA\b\u0017\u0001\u0007Q\u000f\u0003\u0004\u00020-\u0001\ra[\u0001\u0007I\nt\u0015-\\3\t\r\u0005M2\u00021\u0001l\u0003\u0011)8/\u001a:\t\r\u0005]2\u00021\u0001l\u0003\u0011\u0001\u0018m]:\u0015\u001d\u0005U\u00111HA\u001f\u0003\u007f\t\u0019%!\u0014\u0002P!1\u0011\u0011\u0006\u0007A\u0002-Da!a\u0004\r\u0001\u0004)\bBBA!\u0019\u0001\u00071.A\u0003te\u000e$%\rC\u0004\u0002F1\u0001\r!a\u0012\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0002:\u0003\u0013J1!a\u0013;\u0005\rIe\u000e\u001e\u0005\u0007\u0003ga\u0001\u0019A6\t\r\u0005]B\u00021\u0001lQ\u0015a\u00111KA4!\u0015I\u0014QKA-\u0013\r\t9F\u000f\u0002\u0007i\"\u0014xn^:\u0011\t\u0005m\u00131M\u0007\u0003\u0003;R1!HA0\u0015\t\t\t'\u0001\u0003kCZ\f\u0017\u0002BA3\u0003;\u0012AbU)M\u000bb\u001cW\r\u001d;j_:\fdAH6\u0002j\u0005U\u0015'C\u0012\u0002l\u0005M\u00141RA;+\u0011\ti'a\u001c\u0016\u0003-$q!!\u001d%\u0005\u0004\tYHA\u0001U\u0013\u0011\t)(a\u001e\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\tIHO\u0001\u0007i\"\u0014xn^:\u0012\t\u0005u\u00141\u0011\t\u0004s\u0005}\u0014bAAAu\t9aj\u001c;iS:<\u0007\u0003BAC\u0003\u000fs!!O.\n\u0007\u0005%uLA\u0005UQJ|w/\u00192mKFJ1%!$\u0002\u0010\u0006E\u0015\u0011\u0010\b\u0004s\u0005=\u0015bAA=uE*!%\u000f\u001e\u0002\u0014\n)1oY1mCF\u001aa%!\u0017\u0015!\u0005U\u0011\u0011TAN\u0003;\u000by*a)\u0002(\u0006%\u0006BBA\u0015\u001b\u0001\u00071\u000e\u0003\u0004\u0002\u00105\u0001\r!\u001e\u0005\u0007\u0003\u0003j\u0001\u0019A6\t\r\u0005\u0005V\u00021\u0001l\u00031\u0019H/\u0019:u\t\u0006$Xm\u0015;s\u0011\u0019\t)+\u0004a\u0001W\u0006QQM\u001c3ECR,7\u000b\u001e:\t\r\u0005MR\u00021\u0001l\u0011\u0019\t9$\u0004a\u0001W\"*Q\"a\u0015\u0002.F2ad[AX\u0003k\u000b\u0014bIA6\u0003g\n\t,!\u001e2\u0013\r\ni)a$\u00024\u0006e\u0014'\u0002\u0012:u\u0005M\u0015g\u0001\u0014\u0002Z\u0005y1m\\;oi:+wOU3d_J$7\u000f\u0006\u0004\u0002\u0016\u0005m\u0016Q\u0018\u0005\u0006i:\u0001\r!\u001e\u0005\b\u0003\u007fs\u0001\u0019AAa\u0003A\u0019w.\\7jiN$vnQ1uG\",\b\u000f\u0005\u0003V\u0003\u0007\\\u0017bAAc?\n!A*[:uQ\u0015q\u0011\u0011ZAl!\u0015I\u0014QKAf!\u0011\ti-a5\u000e\u0005\u0005='\u0002BAi\u0003?\n!![8\n\t\u0005U\u0017q\u001a\u0002\f\u0013>+\u0005pY3qi&|g.\r\u0004\u001fW\u0006e\u0017q\\\u0019\nG\u0005-\u00141OAn\u0003k\n\u0014bIAG\u0003\u001f\u000bi.!\u001f2\u000b\tJ$(a%2\u0007\u0019\nY-A\u000eWC2LG-\u0019;f\u0011>|G-[3Ts:\u001c\u0007K]8dK\u0012,(/\u001a\t\u0003OA\u00192\u0001EAt!\rI\u0014\u0011^\u0005\u0004\u0003WT$AB!osJ+g\r\u0006\u0002\u0002d\u0006!a*Q'F+\t\t\u0019\u0010\u0005\u0003\u0002v\u0006mXBAA|\u0015\u0011\tI0a\u0018\u0002\t1\fgnZ\u0005\u0004c\u0006]\u0018!\u0002(B\u001b\u0016\u0003\u0013a\u00022vS2$WM]\u000b\u0003\u0005\u0007\u0001RA!\u0002\u0003\u0010)j!Aa\u0002\u000b\t\t%!1B\u0001\tMVt7\r^5p]*!!QBA0\u0003\u0011)H/\u001b7\n\t\tE!q\u0001\u0002\t'V\u0004\b\u000f\\5fe\u0002")
public class ValidateHoodieSyncProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return ValidateHoodieSyncProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ValidateHoodieSyncProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public Procedure build() {
        return new ValidateHoodieSyncProcedure();
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> srcTable = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        Option<Object> dstTable = this.getArgValueOrDefault(args, this.PARAMETERS()[1]);
        String mode = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get();
        String hiveServerUrl = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[3]).get();
        String hivePass = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[4]).get();
        String srcDb = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[5]).get();
        String tgtDb = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[6]).get();
        Integer partitionCount = (Integer)this.getArgValueOrDefault(args, this.PARAMETERS()[7]).get();
        String hiveUser = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[8]).get();
        String srcBasePath = this.getBasePath(srcTable, (Option<Object>)Option$.MODULE$.empty());
        String dstBasePath = this.getBasePath(dstTable, (Option<Object>)Option$.MODULE$.empty());
        HoodieTableMetaClient srcMetaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(srcBasePath).build();
        HoodieTableMetaClient targetMetaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(dstBasePath).build();
        HoodieTimeline targetTimeline = targetMetaClient.getActiveTimeline().getCommitsTimeline();
        HoodieTimeline sourceTimeline = srcMetaClient.getActiveTimeline().getCommitsTimeline();
        long sourceCount = 0L;
        long targetCount = 0L;
        if ("complete".equals(mode)) {
            sourceCount = this.countRecords(hiveServerUrl, srcMetaClient, srcDb, hiveUser, hivePass);
            targetCount = this.countRecords(hiveServerUrl, targetMetaClient, tgtDb, hiveUser, hivePass);
        } else if ("latestPartitions".equals(mode)) {
            sourceCount = this.countRecords(hiveServerUrl, srcMetaClient, srcDb, Predef$.MODULE$.Integer2int(partitionCount), hiveUser, hivePass);
            targetCount = this.countRecords(hiveServerUrl, targetMetaClient, tgtDb, Predef$.MODULE$.Integer2int(partitionCount), hiveUser, hivePass);
        } else {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Unsupport mode ").append(mode).toString());
        }
        String targetLatestCommit = targetTimeline.getInstants().iterator().hasNext() ? ((HoodieInstant)targetTimeline.lastInstant().get()).getTimestamp() : "0";
        String sourceLatestCommit = sourceTimeline.getInstants().iterator().hasNext() ? ((HoodieInstant)sourceTimeline.lastInstant().get()).getTimestamp() : "0";
        return sourceLatestCommit != null && HoodieTimeline.compareTimestamps((String)targetLatestCommit, (BiPredicate)HoodieTimeline.GREATER_THAN, (String)sourceLatestCommit) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getString(targetMetaClient, targetTimeline, srcMetaClient, sourceCount, targetCount, sourceLatestCommit)}))})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getString(srcMetaClient, sourceTimeline, targetMetaClient, targetCount, sourceCount, targetLatestCommit)}))}));
    }

    public String getString(HoodieTableMetaClient target, HoodieTimeline targetTimeline, HoodieTableMetaClient source, long sourceCount, long targetCount, String sourceLatestCommit) {
        String string;
        List commitsToCatchup = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(targetTimeline.findInstantsAfter(sourceLatestCommit, Integer.MAX_VALUE).getInstantsAsStream().iterator()).asScala()).toList();
        if (commitsToCatchup.isEmpty()) {
            string = new StringBuilder(45).append("Count difference now is count(").append(target.getTableConfig().getTableName()).append(") - count(").append(source.getTableConfig().getTableName()).append(") == ").append(targetCount - sourceCount).toString();
        } else {
            long newInserts = this.countNewRecords(target, (List<String>)((List)commitsToCatchup.map((Function1 & Serializable & scala.Serializable)elem -> elem.getTimestamp(), List$.MODULE$.canBuildFrom())));
            string = new StringBuilder(66).append("Count difference now is count(").append(target.getTableConfig().getTableName()).append(") - count(").append(source.getTableConfig().getTableName()).append(") == ").append(targetCount - sourceCount).append(". Catach up count is ").append(newInserts).toString();
        }
        return string;
    }

    public long countRecords(String jdbcUrl, HoodieTableMetaClient source, String dbName, String user, String pass) {
        Connection conn = null;
        ResultSet rs = null;
        long count = -1L;
        try {
            conn = DriverManager.getConnection(jdbcUrl, user, pass);
            Statement stmt = conn.createStatement();
            stmt.execute("set hive.input.format=org.apache.hadoop.hive.ql.io.HiveInputFormat");
            stmt.execute("set hive.stats.autogather=false");
            rs = stmt.executeQuery(new StringBuilder(49).append("select count(`_hoodie_commit_time`) as cnt from ").append(dbName).append(".").append(source.getTableConfig().getTableName()).toString());
            if (rs.next()) {
                count = rs.getLong("cnt");
            }
            Predef$.MODULE$.println((Object)new StringBuilder(21).append("Total records in ").append(source.getTableConfig().getTableName()).append(" is ").append(count).toString());
        }
        finally {
            conn.close();
            if (rs != null) {
                rs.close();
            }
        }
        return count;
    }

    public long countRecords(String jdbcUrl, HoodieTableMetaClient source, String srcDb, int partitions, String user, String pass) throws SQLException {
        DateTime dateTime = DateTime.now();
        String endDateStr = ValidateHoodieSyncProcedure.getDate$1(dateTime);
        dateTime = dateTime.minusDays(partitions);
        String startDateStr = ValidateHoodieSyncProcedure.getDate$1(dateTime);
        Predef$.MODULE$.println((Object)new StringBuilder(25).append("Start date ").append(startDateStr).append(" and end date ").append(endDateStr).toString());
        return this.countRecords(jdbcUrl, source, srcDb, startDateStr, endDateStr, user, pass);
    }

    private long countRecords(String jdbcUrl, HoodieTableMetaClient source, String srcDb, String startDateStr, String endDateStr, String user, String pass) throws SQLException {
        long l;
        ResultSet rs = null;
        Connection conn = DriverManager.getConnection(jdbcUrl, user, pass);
        Statement stmt = conn.createStatement();
        try {
            stmt.execute("set hive.input.format=org.apache.hadoop.hive.ql.io.HiveInputFormat");
            stmt.execute("set hive.stats.autogather=false");
            rs = stmt.executeQuery(new StringBuilder(82).append("select count(`_hoodie_commit_time`) as cnt from ").append(srcDb).append(".").append(source.getTableConfig().getTableName()).append(" where datestr>'").append(startDateStr).append("' and datestr<='").append(endDateStr).append("'").toString());
            l = rs.next() ? rs.getLong("cnt") : -1L;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (conn != null) {
                conn.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return l;
    }

    public long countNewRecords(HoodieTableMetaClient target, List<String> commitsToCatchup) throws IOException {
        LongRef totalNew = LongRef.create((long)0L);
        HoodieTimeline timeline = target.reloadActiveTimeline().getCommitTimeline().filterCompletedInstants();
        commitsToCatchup.foreach((Function1 & Serializable & scala.Serializable)commit -> {
            ValidateHoodieSyncProcedure.$anonfun$countNewRecords$1(timeline, totalNew, commit);
            return BoxedUnit.UNIT;
        });
        return totalNew.elem;
    }

    private static final String getDate$1(DateTime dateTime) {
        return new StringBuilder(10).append(dateTime.getYear()).append("-").append(dateTime.getMonthOfYear()).append("%02d-").append(dateTime.getDayOfMonth()).append("%02d").toString();
    }

    public static final /* synthetic */ void $anonfun$countNewRecords$1(HoodieTimeline timeline$1, LongRef totalNew$1, String commit) {
        HoodieCommitMetadata c = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])timeline$1.getInstantDetails(new HoodieInstant(false, "commit", commit)).get()), HoodieCommitMetadata.class);
        totalNew$1.elem += c.fetchTotalRecordsWritten() - c.fetchTotalUpdateRecordsWritten();
    }

    public ValidateHoodieSyncProcedure() {
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "src_table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(1, "dst_table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(2, "mode", DataTypes.StringType, "complete"), ProcedureParameter$.MODULE$.required(3, "hive_server_url", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(4, "hive_pass", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(5, "src_db", DataTypes.StringType, "rawdata"), ProcedureParameter$.MODULE$.optional(6, "target_db", DataTypes.StringType, "dwh_hoodie"), ProcedureParameter$.MODULE$.optional(7, "partition_cnt", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)5)), ProcedureParameter$.MODULE$.optional(8, "hive_user", DataTypes.StringType, "")});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("result", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

