/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ValidateMetadataTableFilesProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001\u0002\t\u0012\u0001\u0001BQA\f\u0001\u0005\u0002=Bq!\r\u0001C\u0002\u0013%!\u0007\u0003\u0004=\u0001\u0001\u0006Ia\r\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019)\u0005\u0001)A\u0005\u007f!)a\t\u0001C\u0001e!)q\t\u0001C\u0001}!)\u0001\n\u0001C!\u0013\")q\f\u0001C!A\u001e)A-\u0005E\u0001K\u001a)\u0001#\u0005E\u0001M\")af\u0003C\u0001U\"91n\u0003b\u0001\n\u0003a\u0007BB;\fA\u0003%Q\u000eC\u0003w\u0017\u0011\u0005qOA\u0012WC2LG-\u0019;f\u001b\u0016$\u0018\rZ1uCR\u000b'\r\\3GS2,7\u000f\u0015:pG\u0016$WO]3\u000b\u0005I\u0019\u0012A\u00039s_\u000e,G-\u001e:fg*\u0011A#F\u0001\bG>lW.\u00198e\u0015\t1r#\u0001\u0003ik\u0012L'B\u0001\r\u001a\u0003\r\u0019\u0018\u000f\u001c\u0006\u00035m\tQa\u001d9be.T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\"K!\u0002\"AI\u0012\u000e\u0003EI!\u0001J\t\u0003\u001b\t\u000b7/\u001a)s_\u000e,G-\u001e:f!\t\u0011c%\u0003\u0002(#\t\u0001\u0002K]8dK\u0012,(/\u001a\"vS2$WM\u001d\t\u0003S1j\u0011A\u000b\u0006\u0003We\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003[)\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002aA\u0011!\u0005A\u0001\u000b!\u0006\u0013\u0016)T#U\u000bJ\u001bV#A\u001a\u0011\u0007Q:\u0014(D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0015\t%O]1z!\t\u0011#(\u0003\u0002<#\t\u0011\u0002K]8dK\u0012,(/\u001a)be\u0006lW\r^3s\u0003-\u0001\u0016IU!N\u000bR+%k\u0015\u0011\u0002\u0017=+F\u000bU+U?RK\u0006+R\u000b\u0002\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!iF\u0001\u0006if\u0004Xm]\u0005\u0003\t\u0006\u0013!b\u0015;sk\u000e$H+\u001f9f\u00031yU\u000b\u0016)V)~#\u0016\fU#!\u0003)\u0001\u0018M]1nKR,'o]\u0001\u000b_V$\b/\u001e;UsB,\u0017\u0001B2bY2$\"A\u0013.\u0011\u0007-\u001bfK\u0004\u0002M#:\u0011Q\nU\u0007\u0002\u001d*\u0011qjH\u0001\u0007yI|w\u000e\u001e \n\u0003YJ!AU\u001b\u0002\u000fA\f7m[1hK&\u0011A+\u0016\u0002\u0004'\u0016\f(B\u0001*6!\t9\u0006,D\u0001\u0018\u0013\tIvCA\u0002S_^DQa\u0017\u0005A\u0002q\u000bA!\u0019:hgB\u0011!%X\u0005\u0003=F\u0011Q\u0002\u0015:pG\u0016$WO]3Be\u001e\u001c\u0018!\u00022vS2$W#A1\u0011\u0005\t\u0012\u0017BA2\u0012\u0005%\u0001&o\\2fIV\u0014X-A\u0012WC2LG-\u0019;f\u001b\u0016$\u0018\rZ1uCR\u000b'\r\\3GS2,7\u000f\u0015:pG\u0016$WO]3\u0011\u0005\tZ1CA\u0006h!\t!\u0004.\u0003\u0002jk\t1\u0011I\\=SK\u001a$\u0012!Z\u0001\u0005\u001d\u0006kU)F\u0001n!\tq7/D\u0001p\u0015\t\u0001\u0018/\u0001\u0003mC:<'\"\u0001:\u0002\t)\fg/Y\u0005\u0003i>\u0014aa\u0015;sS:<\u0017!\u0002(B\u001b\u0016\u0003\u0013a\u00022vS2$WM]\u000b\u0002qB\u0019\u0011P`\u0013\u000e\u0003iT!a\u001f?\u0002\u0011\u0019,hn\u0019;j_:T!!`9\u0002\tU$\u0018\u000e\\\u0005\u0003\u007fj\u0014\u0001bU;qa2LWM\u001d")
public class ValidateMetadataTableFilesProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return ValidateMetadataTableFilesProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ValidateMetadataTableFilesProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> table = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        boolean verbose = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieBackedTableMetadata metadataReader = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieLocalEngineContext(metaClient.getHadoopConf()), config, basePath, "/tmp");
        if (!metadataReader.enabled()) {
            throw new HoodieException("Metadata Table not enabled/initialized.");
        }
        HoodieMetadataConfig fsConfig = HoodieMetadataConfig.newBuilder().enable(false).build();
        HoodieBackedTableMetadata fsMetaReader = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieLocalEngineContext(metaClient.getHadoopConf()), fsConfig, basePath, "/tmp");
        HoodieTimer timer = HoodieTimer.start();
        List metadataPartitions = metadataReader.getAllPartitionPaths();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Listing partitions Took ").append(timer.endTimer()).append(" ms").toString());
        List fsPartitions = fsMetaReader.getAllPartitionPaths();
        Collections.sort(fsPartitions);
        Collections.sort(metadataPartitions);
        HashSet allPartitions = new HashSet();
        allPartitions.addAll(fsPartitions);
        allPartitions.addAll(metadataPartitions);
        if (!((Object)fsPartitions).equals(metadataPartitions)) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "FS partition listing is not matching with metadata partition listing!");
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("All FS partitions: ").append(Arrays.toString(fsPartitions.toArray())).toString());
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("All Metadata partitions: ").append(Arrays.toString(metadataPartitions.toArray())).toString());
        }
        ArrayList rows = new ArrayList();
        JavaConversions$.MODULE$.deprecated$u0020asScalaSet(allPartitions).foreach((Function1 & Serializable & scala.Serializable)partition -> {
            ValidateMetadataTableFilesProcedure.$anonfun$call$5(this, metadataReader, basePath, fsMetaReader, verbose, rows, partition);
            return BoxedUnit.UNIT;
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    @Override
    public Procedure build() {
        return new ValidateMetadataTableFilesProcedure();
    }

    public static final /* synthetic */ void $anonfun$call$10(ValidateMetadataTableFilesProcedure $this, HashMap metadataFileStatusMap$1, Map.Entry entry) {
        block1: {
            block0: {
                if (metadataFileStatusMap$1.containsKey(entry.getKey())) break block0;
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("FS file not found in metadata ").append(entry.getKey()).toString());
                break block1;
            }
            if (((FileStatus)entry.getValue()).getLen() == ((FileStatus)metadataFileStatusMap$1.get(entry.getKey())).getLen()) break block1;
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append(" FS file size mismatch ").append(entry.getKey()).append(", size equality ").append(((FileStatus)entry.getValue()).getLen() == ((FileStatus)metadataFileStatusMap$1.get(entry.getKey())).getLen()).append(". FS size ").append(((FileStatus)entry.getValue()).getLen()).append(", metadata size ").append(((FileStatus)metadataFileStatusMap$1.get(entry.getKey())).getLen()).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$call$13(ValidateMetadataTableFilesProcedure $this, HashMap fileStatusMap$1, HashMap metadataFileStatusMap$1, Map.Entry entry) {
        block1: {
            block0: {
                if (fileStatusMap$1.containsKey(entry.getKey())) break block0;
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Metadata file not found in FS ").append(entry.getKey()).toString());
                break block1;
            }
            if (((FileStatus)entry.getValue()).getLen() == ((FileStatus)fileStatusMap$1.get(entry.getKey())).getLen()) break block1;
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append(" Metadata file size mismatch ").append(entry.getKey()).append(", size equality ").append(((FileStatus)entry.getValue()).getLen() == ((FileStatus)fileStatusMap$1.get(entry.getKey())).getLen()).append(". Metadata size ").append(((FileStatus)entry.getValue()).getLen()).append(", FS size ").append(((FileStatus)metadataFileStatusMap$1.get(entry.getKey())).getLen()).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$call$5(ValidateMetadataTableFilesProcedure $this, HoodieBackedTableMetadata metadataReader$1, String basePath$1, HoodieBackedTableMetadata fsMetaReader$1, boolean verbose$1, ArrayList rows$1, String partition) {
        HashMap fileStatusMap = new HashMap();
        HashMap metadataFileStatusMap = new HashMap();
        FileStatus[] metadataStatuses = metadataReader$1.getAllFilesInPartition(new Path(basePath$1, partition));
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Arrays.stream((Object[])metadataStatuses).iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> metadataFileStatusMap.put(entry.getPath().getName(), entry));
        FileStatus[] fsStatuses = fsMetaReader$1.getAllFilesInPartition(new Path(basePath$1, partition));
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Arrays.stream((Object[])fsStatuses).iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> fileStatusMap.put(entry.getPath().getName(), entry));
        HashSet allFiles = new HashSet();
        allFiles.addAll(fileStatusMap.keySet());
        allFiles.addAll(metadataFileStatusMap.keySet());
        JavaConversions$.MODULE$.deprecated$u0020asScalaSet(allFiles).foreach((Function1 & Serializable & scala.Serializable)file -> {
            long metadataFileLength;
            FileStatus fsFileStatus = (FileStatus)fileStatusMap.get(file);
            FileStatus metaFileStatus = (FileStatus)metadataFileStatusMap.get(file);
            boolean doesFsFileExists = fsFileStatus != null;
            boolean doesMetadataFileExists = metaFileStatus != null;
            long fsFileLength = doesFsFileExists ? fsFileStatus.getLen() : 0L;
            long l = metadataFileLength = doesMetadataFileExists ? metaFileStatus.getLen() : 0L;
            return verbose$1 ? BoxesRunTime.boxToBoolean((boolean)rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, file, BoxesRunTime.boxToBoolean((boolean)doesFsFileExists), BoxesRunTime.boxToBoolean((boolean)doesMetadataFileExists), BoxesRunTime.boxToLong((long)fsFileLength), BoxesRunTime.boxToLong((long)metadataFileLength)})))) : (doesFsFileExists != doesMetadataFileExists || fsFileLength != metadataFileLength ? BoxesRunTime.boxToBoolean((boolean)rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, file, BoxesRunTime.boxToBoolean((boolean)doesFsFileExists), BoxesRunTime.boxToBoolean((boolean)doesMetadataFileExists), BoxesRunTime.boxToLong((long)fsFileLength), BoxesRunTime.boxToLong((long)metadataFileLength)})))) : BoxedUnit.UNIT);
        });
        if (metadataStatuses.length != fsStatuses.length) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append(" FS and metadata files count not matching for ").append(partition).append(". FS files count ").append(fsStatuses.length).append(", metadata base files count ").append(metadataStatuses.length).toString());
        }
        JavaConversions$.MODULE$.deprecated$u0020asScalaSet(fileStatusMap.entrySet()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ValidateMetadataTableFilesProcedure.$anonfun$call$10($this, metadataFileStatusMap, entry);
            return BoxedUnit.UNIT;
        });
        JavaConversions$.MODULE$.deprecated$u0020asScalaSet(metadataFileStatusMap.entrySet()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ValidateMetadataTableFilesProcedure.$anonfun$call$13($this, fileStatusMap, metadataFileStatusMap, entry);
            return BoxedUnit.UNIT;
        });
    }

    public ValidateMetadataTableFilesProcedure() {
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "verbose", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false))});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_name", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("is_present_in_fs", DataTypes.BooleanType, true, Metadata$.MODULE$.empty()), new StructField("is_resent_in_metadata", DataTypes.BooleanType, true, Metadata$.MODULE$.empty()), new StructField("fs_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("metadata_size", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));
    }
}

