/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.HoodieFileIndex$;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.execution.datasources.FileStatusCache$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.HoodieProcedureUtils;
import org.apache.spark.sql.hudi.command.procedures.HoodieProcedureUtils$;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RunClusteringProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001\u0002\n\u0014\u0001\tBQ\u0001\u000f\u0001\u0005\u0002eBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004G\u0001\u0001\u0006I!\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003I\u0011\u0019y\u0005\u0001)A\u0005\u0013\")\u0001\u000b\u0001C\u0001y!)\u0011\u000b\u0001C\u0001\u0011\")!\u000b\u0001C!'\")\u0011\u000e\u0001C!U\")a\u000e\u0001C\u0001_\"9\u00111\u0002\u0001\u0005\n\u00055qaBA\u000e'!\u0005\u0011Q\u0004\u0004\u0007%MA\t!a\b\t\rajA\u0011AA\u0014\u0011%\tI#\u0004b\u0001\n\u0003\tY\u0003\u0003\u0005\u0002<5\u0001\u000b\u0011BA\u0017\u0011\u001d\ti$\u0004C\u0001\u0003\u007f\u0011aCU;o\u00072,8\u000f^3sS:<\u0007K]8dK\u0012,(/\u001a\u0006\u0003)U\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t1r#A\u0004d_6l\u0017M\u001c3\u000b\u0005aI\u0012\u0001\u00025vI&T!AG\u000e\u0002\u0007M\fHN\u0003\u0002\u001d;\u0005)1\u000f]1sW*\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u0012(UI\u0002\"\u0001J\u0013\u000e\u0003MI!AJ\n\u0003\u001b\t\u000b7/\u001a)s_\u000e,G-\u001e:f!\t!\u0003&\u0003\u0002*'\t\u0001\u0002K]8dK\u0012,(/\u001a\"vS2$WM\u001d\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011q&G\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0011\u0007\f\u0002\u0010!J,G-[2bi\u0016DU\r\u001c9feB\u00111GN\u0007\u0002i)\u0011QgG\u0001\tS:$XM\u001d8bY&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t!\b\u0005\u0002%\u0001\u0005Q\u0001+\u0011*B\u001b\u0016#VIU*\u0016\u0003u\u00022AP!D\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$!B!se\u0006L\bC\u0001\u0013E\u0013\t)5C\u0001\nQe>\u001cW\rZ;sKB\u000b'/Y7fi\u0016\u0014\u0018a\u0003)B%\u0006kU\tV#S'\u0002\n1bT+U!V#v\fV-Q\u000bV\t\u0011\n\u0005\u0002K\u001b6\t1J\u0003\u0002M3\u0005)A/\u001f9fg&\u0011aj\u0013\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017\u0001D(V)B+Fk\u0018+Z!\u0016\u0003\u0013A\u00039be\u0006lW\r^3sg\u0006Qq.\u001e;qkR$\u0016\u0010]3\u0002\t\r\fG\u000e\u001c\u000b\u0003)\u0012\u00042!V/a\u001d\t16L\u0004\u0002X56\t\u0001L\u0003\u0002ZC\u00051AH]8pizJ\u0011\u0001Q\u0005\u00039~\nq\u0001]1dW\u0006<W-\u0003\u0002_?\n\u00191+Z9\u000b\u0005q{\u0004CA1c\u001b\u0005I\u0012BA2\u001a\u0005\r\u0011vn\u001e\u0005\u0006K\"\u0001\rAZ\u0001\u0005CJ<7\u000f\u0005\u0002%O&\u0011\u0001n\u0005\u0002\u000e!J|7-\u001a3ve\u0016\f%oZ:\u0002\u000b\t,\u0018\u000e\u001c3\u0016\u0003-\u0004\"\u0001\n7\n\u00055\u001c\"!\u0003)s_\u000e,G-\u001e:f\u00039\u0001(/\u001e8f!\u0006\u0014H/\u001b;j_:$B\u0001\u001d=\u0002\bA\u0011\u0011/\u001e\b\u0003eN\u0004\"aV \n\u0005Q|\u0014A\u0002)sK\u0012,g-\u0003\u0002wo\n11\u000b\u001e:j]\u001eT!\u0001^ \t\u000beT\u0001\u0019\u0001>\u0002\u00155,G/Y\"mS\u0016tG\u000fE\u0002|\u0003\u0007i\u0011\u0001 \u0006\u0003{z\fQ\u0001^1cY\u0016T1a`A\u0001\u0003\u0019\u0019w.\\7p]*\u0011\u0001$H\u0005\u0004\u0003\u000ba(!\u0006%p_\u0012LW\rV1cY\u0016lU\r^1DY&,g\u000e\u001e\u0005\u0007\u0003\u0013Q\u0001\u0019\u00019\u0002\u0013A\u0014X\rZ5dCR,\u0017\u0001\u0006<bY&$\u0017\r^3Pe\u0012,'oQ8mk6t7\u000f\u0006\u0004\u0002\u0010\u0005U\u0011\u0011\u0004\t\u0004}\u0005E\u0011bAA\n\u007f\t!QK\\5u\u0011\u0019\t9b\u0003a\u0001a\u0006aqN\u001d3fe\u000e{G.^7og\")\u0011p\u0003a\u0001u\u00061\"+\u001e8DYV\u001cH/\u001a:j]\u001e\u0004&o\\2fIV\u0014X\r\u0005\u0002%\u001bM\u0019Q\"!\t\u0011\u0007y\n\u0019#C\u0002\u0002&}\u0012a!\u00118z%\u00164GCAA\u000f\u0003\u0011q\u0015)T#\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003si!!!\r\u000b\t\u0005M\u0012QG\u0001\u0005Y\u0006twM\u0003\u0002\u00028\u0005!!.\u0019<b\u0013\r1\u0018\u0011G\u0001\u0006\u001d\u0006kU\tI\u0001\bEVLG\u000eZ3s+\t\t\t\u0005E\u0003\u0002D\u00055s%\u0004\u0002\u0002F)!\u0011qIA%\u0003!1WO\\2uS>t'\u0002BA&\u0003k\tA!\u001e;jY&!\u0011qJA#\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\b")
public class RunClusteringProcedure
extends BaseProcedure
implements ProcedureBuilder,
PredicateHelper {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return RunClusteringProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RunClusteringProcedure$.MODULE$.NAME();
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        Seq seq;
        Seq pendingClusteringInstants;
        Tuple2<Seq<String>, HoodieProcedureUtils.Operation> tuple2;
        Option option;
        String string;
        Option option2;
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        Option<Object> tablePath = this.getArgValueOrDefault(args, this.PARAMETERS()[1]);
        Option<Object> predicate = this.getArgValueOrDefault(args, this.PARAMETERS()[2]);
        Option<Object> orderColumns = this.getArgValueOrDefault(args, this.PARAMETERS()[3]);
        boolean showInvolvedPartitions = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[4]).get());
        Option<Object> op = this.getArgValueOrDefault(args, this.PARAMETERS()[5]);
        Option<Object> orderStrategy = this.getArgValueOrDefault(args, this.PARAMETERS()[6]);
        Option<Object> options = this.getArgValueOrDefault(args, this.PARAMETERS()[7]);
        Option<Object> specificInstants = this.getArgValueOrDefault(args, this.PARAMETERS()[8]);
        Option<Object> parts = this.getArgValueOrDefault(args, this.PARAMETERS()[9]);
        String basePath = this.getBasePath(tableName, tablePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        Map confs = Predef$.MODULE$.Map().empty();
        Tuple2 tuple22 = new Tuple2(parts, predicate);
        if (tuple22 != null && (option2 = (Option)tuple22._2()) instanceof Some) {
            Some some = (Some)option2;
            Object p2 = some.value();
            string = this.prunePartition(metaClient, (String)p2);
        } else if (tuple22 != null && (option = (Option)tuple22._1()) instanceof Some) {
            Some some = (Some)option;
            Object o = some.value();
            string = (String)o;
        } else {
            string = null;
        }
        String selectedPartitions = string;
        if (selectedPartitions == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No partition selected");
        } else {
            if (selectedPartitions.isEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No partition matched");
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
            confs = confs.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.PLAN_PARTITION_FILTER_MODE_NAME.key()), (Object)"SELECTED_PARTITIONS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.PARTITION_SELECTED.key()), (Object)selectedPartitions)})));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Partition selected: ").append(selectedPartitions).toString());
        }
        Option<Object> option3 = orderColumns;
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            Object o = some.value();
            this.validateOrderColumns((String)o, metaClient);
            confs = confs.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key()), (Object)((String)o))})));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Order columns: ").append(o).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No order columns");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Option<Object> option4 = orderStrategy;
        if (option4 instanceof Some) {
            Some some = (Some)option4;
            Object o = some.value();
            HoodieClusteringConfig.LayoutOptimizationStrategy strategy = HoodieClusteringConfig.LayoutOptimizationStrategy.fromValue((String)((String)o));
            confs = confs.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.LAYOUT_OPTIMIZE_STRATEGY.key()), (Object)strategy.getValue())})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No order strategy");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Option<Object> option5 = options;
        if (option5 instanceof Some) {
            Some some = (Some)option5;
            Object p3 = some.value();
            confs = confs.$plus$plus((GenTraversableOnce)HoodieCLIUtils$.MODULE$.extractOptions((String)p3));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No options");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (metaClient.getTableConfig().isMetadataTableAvailable() && !confs.contains((Object)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key())) {
            confs = confs.$plus$plus((GenTraversableOnce)HoodieCLIUtils$.MODULE$.getLockOptions(basePath));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Auto config filesystem lock provider for metadata table");
        }
        if ((tuple2 = HoodieProcedureUtils$.MODULE$.filterPendingInstantsAndGetOperation((Seq<String>)(pendingClusteringInstants = (Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(ClusteringUtils.getAllPendingClusteringPlans((HoodieTableMetaClient)metaClient).iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> ((HoodieInstant)x$1.getLeft()).getTimestamp()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)f -> f, (Ordering)Ordering.String$.MODULE$)), specificInstants, op)) == null) {
            throw new MatchError(tuple2);
        }
        Seq filteredPendingClusteringInstants = (Seq)tuple2._1();
        HoodieProcedureUtils.Operation operation = (HoodieProcedureUtils.Operation)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)filteredPendingClusteringInstants, (Object)operation);
        Tuple2 tuple24 = tuple23;
        ObjectRef filteredPendingClusteringInstants2 = ObjectRef.create((Object)((Seq)tuple24._1()));
        HoodieProcedureUtils.Operation operation2 = (HoodieProcedureUtils.Operation)tuple24._2();
        ObjectRef client = ObjectRef.create(null);
        try {
            String instantTime;
            client.elem = HoodieCLIUtils$.MODULE$.createHoodieWriteClient(this.sparkSession(), basePath, confs, tableName);
            if (operation2.isSchedule() && ((SparkRDDWriteClient)client.elem).scheduleClusteringAtInstant(instantTime = HoodieActiveTimeline.createNewInstantTime(), org.apache.hudi.common.util.Option.empty())) {
                filteredPendingClusteringInstants2.elem = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{instantTime}));
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Clustering instants to run: ").append(((Seq)filteredPendingClusteringInstants$1.elem).mkString(",")).append(".").toString());
            if (operation2.isExecute()) {
                HoodieTimer timer = HoodieTimer.start();
                ((Seq)filteredPendingClusteringInstants2.elem).foreach((Function1 & Serializable & scala.Serializable)x$3 -> ((SparkRDDWriteClient)client$1.elem).cluster(x$3, true));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Finish clustering at instants: ").append(((Seq)filteredPendingClusteringInstants$1.elem).mkString(",")).append(",").append(" spend: ").append(timer.endTimer()).append("ms.").toString());
            }
            Seq clusteringInstants = (Seq)((SeqLike)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(metaClient.reloadActiveTimeline().getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)RunClusteringProcedure.$anonfun$call$14(filteredPendingClusteringInstants2, p))).toSeq().sortBy((Function1 & Serializable & scala.Serializable)f -> f.getTimestamp(), (Ordering)Ordering.String$.MODULE$)).reverse();
            Seq clusteringPlans = (Seq)clusteringInstants.map((Function1 & Serializable & scala.Serializable)instant -> ClusteringUtils.getClusteringPlan((HoodieTableMetaClient)metaClient, (HoodieInstant)instant), Seq$.MODULE$.canBuildFrom());
            seq = showInvolvedPartitions ? (Seq)clusteringPlans.map((Function1 & Serializable & scala.Serializable)p -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((HoodieInstant)((Pair)p.get()).getLeft()).getTimestamp(), BoxesRunTime.boxToInteger((int)((HoodieClusteringPlan)((Pair)p.get()).getRight()).getInputGroups().size()), ((HoodieInstant)((Pair)p.get()).getLeft()).getState().name(), HoodieCLIUtils$.MODULE$.extractPartitions((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(((HoodieClusteringPlan)((Pair)p.get()).getRight()).getInputGroups()).asScala())})), Seq$.MODULE$.canBuildFrom()) : (Seq)clusteringPlans.map((Function1 & Serializable & scala.Serializable)p -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((HoodieInstant)((Pair)p.get()).getLeft()).getTimestamp(), BoxesRunTime.boxToInteger((int)((HoodieClusteringPlan)((Pair)p.get()).getRight()).getInputGroups().size()), ((HoodieInstant)((Pair)p.get()).getLeft()).getState().name(), "*"})), Seq$.MODULE$.canBuildFrom());
        }
        finally {
            if ((SparkRDDWriteClient)client.elem != null) {
                ((SparkRDDWriteClient)client.elem).close();
            }
        }
        return seq;
    }

    @Override
    public Procedure build() {
        return new RunClusteringProcedure();
    }

    public String prunePartition(HoodieTableMetaClient metaClient, String predicate) {
        Map options = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key()), (Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)metaClient.getBasePath())}));
        HoodieFileIndex hoodieFileIndex = new HoodieFileIndex(this.sparkSession(), metaClient, (Option)None$.MODULE$, options, FileStatusCache$.MODULE$.getOrCreate(this.sparkSession()), HoodieFileIndex$.MODULE$.apply$default$6());
        TableSchemaResolver schemaResolver = new TableSchemaResolver(metaClient);
        StructType tableSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schemaResolver.getTableAvroSchema());
        Expression condition = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr(this.sparkSession(), predicate, tableSchema);
        String[] partitionColumns = (String[])metaClient.getTableConfig().getPartitionFields().orElse(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        Tuple2 tuple2 = HoodieCatalystExpressionUtils$.MODULE$.splitPartitionAndDataPredicates(this.sparkSession(), (Expression[])this.splitConjunctivePredicates(condition).toArray(ClassTag$.MODULE$.apply(Expression.class)), partitionColumns);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression[] partitionPredicates = (Expression[])tuple2._1();
        Expression[] dataPredicates = (Expression[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionPredicates, (Object)dataPredicates);
        Tuple2 tuple23 = tuple22;
        Expression[] partitionPredicates2 = (Expression[])tuple23._1();
        Expression[] dataPredicates2 = (Expression[])tuple23._2();
        ValidationUtils.checkArgument((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataPredicates2)).isEmpty(), (String)"Only partition predicates are allowed");
        Seq prunedPartitions = hoodieFileIndex.getPartitionPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])partitionPredicates2));
        return ((TraversableOnce)prunedPartitions.map((Function1 & Serializable & scala.Serializable)partitionPath -> partitionPath.getPath(), Seq$.MODULE$.canBuildFrom())).toSet().mkString(",");
    }

    private void validateOrderColumns(String orderColumns, HoodieTableMetaClient metaClient) {
        if (orderColumns == null) {
            throw new HoodieClusteringException("Order columns is null");
        }
        TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(metaClient);
        Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tableSchemaResolver.getTableAvroSchema(false).getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name().toLowerCase(), Buffer$.MODULE$.canBuildFrom());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])orderColumns.split(","))).foreach((Function1 & Serializable & scala.Serializable)col -> {
            RunClusteringProcedure.$anonfun$validateOrderColumns$2(fields, col);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$call$14(ObjectRef filteredPendingClusteringInstants$1, HoodieInstant p) {
        String string = p.getAction();
        String string2 = "replacecommit";
        return !(string != null ? !string.equals(string2) : string2 != null) && ((Seq)filteredPendingClusteringInstants$1.elem).contains((Object)p.getTimestamp());
    }

    public static final /* synthetic */ void $anonfun$validateOrderColumns$2(Buffer fields$1, String col) {
        if (!fields$1.contains((Object)col.toLowerCase())) {
            throw new HoodieClusteringException(new StringBuilder(23).append("Order column not exist:").append(col).toString());
        }
    }

    public RunClusteringProcedure() {
        AliasHelper.$init$((AliasHelper)this);
        Logging.$init$((Logging)this);
        PredicateHelper.$init$((PredicateHelper)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.optional(0, "table", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(1, "path", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(2, "predicate", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(3, "order", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(4, "show_involved_partition", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(5, "op", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(6, "order_strategy", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(7, "options", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(8, "instants", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(9, "selected_partitions", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4())});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("timestamp", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("input_group_size", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("state", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("involved_partitions", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

