/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.PublicAPIMethod;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;

@PublicAPIClass(maturity=ApiMaturityLevel.STABLE)
public class HoodieDataSourceHelpers {
    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    public static boolean hasNewCommits(FileSystem fs, String basePath, String commitTimestamp) {
        return HoodieDataSourceHelpers.listCommitsSince(fs, basePath, commitTimestamp).size() > 0;
    }

    public static boolean hasNewCommits(HoodieStorage storage, String basePath, String commitTimestamp) {
        return HoodieDataSourceHelpers.listCommitsSince(storage, basePath, commitTimestamp).size() > 0;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    public static List<String> listCommitsSince(FileSystem fs, String basePath, String instantTimestamp) {
        HoodieTimeline timeline = HoodieDataSourceHelpers.allCompletedCommitsCompactions(fs, basePath);
        return timeline.findInstantsAfter(instantTimestamp, Integer.MAX_VALUE).getInstantsAsStream().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
    }

    public static List<String> listCommitsSince(HoodieStorage storage, String basePath, String instantTimestamp) {
        HoodieTimeline timeline = HoodieDataSourceHelpers.allCompletedCommitsCompactions(storage, basePath);
        return timeline.findInstantsAfter(instantTimestamp, Integer.MAX_VALUE).getInstantsAsStream().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    public static String latestCommit(FileSystem fs, String basePath) {
        HoodieTimeline timeline = HoodieDataSourceHelpers.allCompletedCommitsCompactions(fs, basePath);
        return ((HoodieInstant)timeline.lastInstant().get()).getTimestamp();
    }

    public static String latestCommit(HoodieStorage storage, String basePath) {
        HoodieTimeline timeline = HoodieDataSourceHelpers.allCompletedCommitsCompactions(storage, basePath);
        return ((HoodieInstant)timeline.lastInstant().get()).getTimestamp();
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    public static HoodieTimeline allCompletedCommitsCompactions(FileSystem fs, String basePath) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)fs.getConf())).setBasePath(basePath).setLoadActiveTimelineOnLoad(true).build();
        if (metaClient.getTableType().equals((Object)HoodieTableType.MERGE_ON_READ)) {
            return metaClient.getActiveTimeline().getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"commit", "deltacommit", "replacecommit"})).filterCompletedInstants();
        }
        return metaClient.getCommitTimeline().filterCompletedInstants();
    }

    public static HoodieTimeline allCompletedCommitsCompactions(HoodieStorage storage, String basePath) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(storage.getConf().newInstance()).setBasePath(basePath).setLoadActiveTimelineOnLoad(true).build();
        if (metaClient.getTableType().equals((Object)HoodieTableType.MERGE_ON_READ)) {
            return metaClient.getActiveTimeline().getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"commit", "deltacommit", "replacecommit"})).filterCompletedInstants();
        }
        return metaClient.getCommitTimeline().filterCompletedInstants();
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    public static Option<HoodieClusteringPlan> getClusteringPlan(FileSystem fs, String basePath, String instantTime) {
        HoodieInstant hoodieInstant;
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)fs.getConf())).setBasePath(basePath).setLoadActiveTimelineOnLoad(true).build();
        Option clusteringPlan = ClusteringUtils.getClusteringPlan((HoodieTableMetaClient)metaClient, (HoodieInstant)(hoodieInstant = HoodieTimeline.getReplaceCommitRequestedInstant((String)instantTime)));
        if (clusteringPlan.isPresent()) {
            return Option.of((Object)((Pair)clusteringPlan.get()).getValue());
        }
        return Option.empty();
    }
}

