/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.secondary.index.SecondaryIndexManager;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.QualifiedTableName;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.hudi.command.DropIndexCommand$;
import org.apache.spark.sql.hudi.command.IndexBaseCommand;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u000f\u001f\u0001.B\u0001\"\u000f\u0001\u0003\u0016\u0004%\tA\u000f\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005w!AA\t\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005R\u0001\tE\t\u0015!\u0003G\u0011!\u0011\u0006A!f\u0001\n\u0003\u0019\u0006\u0002C,\u0001\u0005#\u0005\u000b\u0011\u0002+\t\u0011a\u0003!Q3A\u0005BeC\u0001\"\u001b\u0001\u0003\u0012\u0003\u0006IA\u0017\u0005\u0006U\u0002!\ta\u001b\u0005\u0006c\u0002!\tE\u001d\u0005\b{\u0002\t\t\u0011\"\u0001\u007f\u0011%\t9\u0001AI\u0001\n\u0003\tI\u0001C\u0005\u0002 \u0001\t\n\u0011\"\u0001\u0002\"!I\u0011Q\u0005\u0001\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003W\u0001\u0011\u0013!C\u0001\u0003[A\u0011\"!\r\u0001\u0003\u0003%\t%a\r\t\u0013\u0005\r\u0003!!A\u0005\u0002\u0005\u0015\u0003\"CA'\u0001\u0005\u0005I\u0011AA(\u0011%\tY\u0006AA\u0001\n\u0003\ni\u0006C\u0005\u0002l\u0001\t\t\u0011\"\u0001\u0002n!I\u0011\u0011\u000f\u0001\u0002\u0002\u0013\u0005\u00131O\u0004\n\u0003or\u0012\u0011!E\u0001\u0003s2\u0001\"\b\u0010\u0002\u0002#\u0005\u00111\u0010\u0005\u0007U^!\t!!#\t\u0013\u0005-u#!A\u0005F\u00055\u0005\"CAH/\u0005\u0005I\u0011QAI\u0011%\tYjFA\u0001\n\u0003\u000bi\nC\u0005\u00020^\t\t\u0011\"\u0003\u00022\n\u0001BI]8q\u0013:$W\r_\"p[6\fg\u000e\u001a\u0006\u0003?\u0001\nqaY8n[\u0006tGM\u0003\u0002\"E\u0005!\u0001.\u001e3j\u0015\t\u0019C%A\u0002tc2T!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\u0006\r\u001c\u0011\u00055rS\"\u0001\u0010\n\u0005=r\"\u0001E%oI\u0016D()Y:f\u0007>lW.\u00198e!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u001d\u0001&o\u001c3vGR\u0004\"!M\u001c\n\u0005a\u0012$\u0001D*fe&\fG.\u001b>bE2,\u0017!\u0002;bE2,W#A\u001e\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014aB2bi\u0006dwn\u001a\u0006\u0003\u0001\n\n\u0001bY1uC2L8\u000f^\u0005\u0003\u0005v\u0012AbQ1uC2|w\rV1cY\u0016\fa\u0001^1cY\u0016\u0004\u0013!C5oI\u0016Dh*Y7f+\u00051\u0005CA$O\u001d\tAE\n\u0005\u0002Je5\t!J\u0003\u0002LU\u00051AH]8pizJ!!\u0014\u001a\u0002\rA\u0013X\rZ3g\u0013\ty\u0005K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001bJ\n!\"\u001b8eKbt\u0015-\\3!\u0003EIwM\\8sK&3gj\u001c;Fq&\u001cHo]\u000b\u0002)B\u0011\u0011'V\u0005\u0003-J\u0012qAQ8pY\u0016\fg.\u0001\njO:|'/Z%g\u001d>$X\t_5tiN\u0004\u0013AB8viB,H/F\u0001[!\rY\u0006m\u0019\b\u00039zs!!S/\n\u0003MJ!a\u0018\u001a\u0002\u000fA\f7m[1hK&\u0011\u0011M\u0019\u0002\u0004'\u0016\f(BA03!\t!w-D\u0001f\u0015\t1w(A\u0006fqB\u0014Xm]:j_:\u001c\u0018B\u00015f\u0005%\tE\u000f\u001e:jEV$X-A\u0004pkR\u0004X\u000f\u001e\u0011\u0002\rqJg.\u001b;?)\u0015aWN\\8q!\ti\u0003\u0001C\u0003:\u0013\u0001\u00071\bC\u0003E\u0013\u0001\u0007a\tC\u0003S\u0013\u0001\u0007A\u000bC\u0003Y\u0013\u0001\u0007!,A\u0002sk:$\"a\u001d=\u0011\u0007m\u0003G\u000f\u0005\u0002vm6\t!%\u0003\u0002xE\t\u0019!k\\<\t\u000beT\u0001\u0019\u0001>\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005U\\\u0018B\u0001?#\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0019w\u000e]=\u0015\u00111|\u0018\u0011AA\u0002\u0003\u000bAq!O\u0006\u0011\u0002\u0003\u00071\bC\u0004E\u0017A\u0005\t\u0019\u0001$\t\u000fI[\u0001\u0013!a\u0001)\"9\u0001l\u0003I\u0001\u0002\u0004Q\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0017Q3aOA\u0007W\t\ty\u0001\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\u0013Ut7\r[3dW\u0016$'bAA\re\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00111\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003GQ3ARA\u0007\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!\u000b+\u0007Q\u000bi!\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005=\"f\u0001.\u0002\u000e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u000e\u0011\t\u0005]\u0012\u0011I\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005!A.\u00198h\u0015\t\ty$\u0001\u0003kCZ\f\u0017bA(\u0002:\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\t\t\u0004c\u0005%\u0013bAA&e\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011KA,!\r\t\u00141K\u0005\u0004\u0003+\u0012$aA!os\"I\u0011\u0011\f\n\u0002\u0002\u0003\u0007\u0011qI\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0003CBA1\u0003O\n\t&\u0004\u0002\u0002d)\u0019\u0011Q\r\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002j\u0005\r$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001VA8\u0011%\tI\u0006FA\u0001\u0002\u0004\t\t&\u0001\u0004fcV\fGn\u001d\u000b\u0004)\u0006U\u0004\"CA-+\u0005\u0005\t\u0019AA)\u0003A!%o\u001c9J]\u0012,\u0007pQ8n[\u0006tG\r\u0005\u0002./M!q#! 7!%\ty(!\"<\rRSF.\u0004\u0002\u0002\u0002*\u0019\u00111\u0011\u001a\u0002\u000fI,h\u000e^5nK&!\u0011qQAA\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u000b\u0003\u0003s\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003k\tQ!\u00199qYf$\u0012\u0002\\AJ\u0003+\u000b9*!'\t\u000beR\u0002\u0019A\u001e\t\u000b\u0011S\u0002\u0019\u0001$\t\u000bIS\u0002\u0019\u0001+\t\u000baS\u0002\u0019\u0001.\u0002\u000fUt\u0017\r\u001d9msR!\u0011qTAV!\u0015\t\u0014\u0011UAS\u0013\r\t\u0019K\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fE\n9k\u000f$U5&\u0019\u0011\u0011\u0016\u001a\u0003\rQ+\b\u000f\\35\u0011!\tikGA\u0001\u0002\u0004a\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\f\u0005\u0003\u00028\u0005U\u0016\u0002BA\\\u0003s\u0011aa\u00142kK\u000e$\b")
public class DropIndexCommand
extends IndexBaseCommand
implements scala.Serializable {
    private final CatalogTable table;
    private final String indexName;
    private final boolean ignoreIfNotExists;
    private final Seq<Attribute> output;

    public static Option<Tuple4<CatalogTable, String, Object, Seq<Attribute>>> unapply(DropIndexCommand dropIndexCommand) {
        return DropIndexCommand$.MODULE$.unapply(dropIndexCommand);
    }

    public static Function1<Tuple4<CatalogTable, String, Object, Seq<Attribute>>, DropIndexCommand> tupled() {
        return DropIndexCommand$.MODULE$.tupled();
    }

    public static Function1<CatalogTable, Function1<String, Function1<Object, Function1<Seq<Attribute>, DropIndexCommand>>>> curried() {
        return DropIndexCommand$.MODULE$.curried();
    }

    public CatalogTable table() {
        return this.table;
    }

    public String indexName() {
        return this.indexName;
    }

    public boolean ignoreIfNotExists() {
        return this.ignoreIfNotExists;
    }

    @Override
    public Seq<Attribute> output() {
        return this.output;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        TableIdentifier tableId = this.table().identifier();
        HoodieTableMetaClient metaClient = this.createHoodieTableMetaClient(tableId, sparkSession);
        SecondaryIndexManager.getInstance().drop(metaClient, this.indexName(), this.ignoreIfNotExists());
        QualifiedTableName qualifiedTableName = new QualifiedTableName((String)tableId.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> sparkSession.sessionState().catalog().getCurrentDatabase()), tableId.table());
        sparkSession.sessionState().catalog().invalidateCachedTable(qualifiedTableName);
        return (Seq)Seq$.MODULE$.empty();
    }

    public DropIndexCommand copy(CatalogTable table, String indexName, boolean ignoreIfNotExists, Seq<Attribute> output) {
        return new DropIndexCommand(table, indexName, ignoreIfNotExists, output);
    }

    public CatalogTable copy$default$1() {
        return this.table();
    }

    public String copy$default$2() {
        return this.indexName();
    }

    public boolean copy$default$3() {
        return this.ignoreIfNotExists();
    }

    public Seq<Attribute> copy$default$4() {
        return this.output();
    }

    public String productPrefix() {
        return "DropIndexCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.table();
                break;
            }
            case 1: {
                object = this.indexName();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreIfNotExists());
                break;
            }
            case 3: {
                object = this.output();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DropIndexCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DropIndexCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DropIndexCommand dropIndexCommand = (DropIndexCommand)((Object)x$1);
        CatalogTable catalogTable = this.table();
        CatalogTable catalogTable2 = dropIndexCommand.table();
        if (catalogTable == null) {
            if (catalogTable2 != null) {
                return false;
            }
        } else if (!catalogTable.equals(catalogTable2)) return false;
        String string = this.indexName();
        String string2 = dropIndexCommand.indexName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.ignoreIfNotExists() != dropIndexCommand.ignoreIfNotExists()) return false;
        Seq<Attribute> seq = this.output();
        Seq<Attribute> seq2 = dropIndexCommand.output();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!dropIndexCommand.canEqual((Object)this)) return false;
        return true;
    }

    public DropIndexCommand(CatalogTable table, String indexName, boolean ignoreIfNotExists, Seq<Attribute> output) {
        this.table = table;
        this.indexName = indexName;
        this.ignoreIfNotExists = ignoreIfNotExists;
        this.output = output;
    }
}

