/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001\u0002\n\u0014\u0001\tB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006c\u0001!\tA\r\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0011\u0019i\u0004\u0001)A\u0005o!9a\b\u0001b\u0001\n\u0013y\u0004B\u0002$\u0001A\u0003%\u0001\tC\u0004H\u0001\t\u0007I\u0011\u0002\u001c\t\r!\u0003\u0001\u0015!\u00038\u0011\u001dI\u0005A1A\u0005\n}BaA\u0013\u0001!\u0002\u0013\u0001\u0005\"B&\u0001\t\u0013a\u0005\"\u0002;\u0001\t\u0013)\bbBA\u0005\u0001\u0011%\u00111\u0002\u0005\u0007\u00037\u0001A\u0011\t\u001c\t\r\u0005u\u0001\u0001\"\u0011@\u0011\u001d\ty\u0002\u0001C!\u0003CAq!a\u0010\u0001\t\u0003\n\tEA\u000eTQ><h)\u001b7f'f\u001cH/Z7WS\u0016<\bK]8dK\u0012,(/\u001a\u0006\u0003)U\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t1r#A\u0004d_6l\u0017M\u001c3\u000b\u0005aI\u0012\u0001\u00025vI&T!AG\u000e\u0002\u0007M\fHN\u0003\u0002\u001d;\u0005)1\u000f]1sW*\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0007\u0001\u00192\u0001A\u0012(!\t!S%D\u0001\u0014\u0013\t13CA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003I!J!!K\n\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\u0018AC:i_^d\u0015\r^3tiB\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u00024iA\u0011A\u0005\u0001\u0005\u0006U\t\u0001\raK\u0001\u000f!\u0006\u0013\u0016)T#U\u000bJ\u001bv,\u0011'M+\u00059\u0004c\u0001\u00179u%\u0011\u0011(\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003ImJ!\u0001P\n\u0003%A\u0013xnY3ekJ,\u0007+\u0019:b[\u0016$XM]\u0001\u0010!\u0006\u0013\u0016)T#U\u000bJ\u001bv,\u0011'MA\u0005yq*\u0016+Q+R{F+\u0017)F?\u0006cE*F\u0001A!\t\tE)D\u0001C\u0015\t\u0019\u0015$A\u0003usB,7/\u0003\u0002F\u0005\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002!=+F\u000bU+U?RK\u0006+R0B\u00192\u0003\u0013!\u0005)B%\u0006kU\tV#S'~c\u0015\tV#T)\u0006\u0011\u0002+\u0011*B\u001b\u0016#VIU*`\u0019\u0006#Vi\u0015+!\u0003IyU\u000b\u0016)V)~#\u0016\fU#`\u0019\u0006#Vi\u0015+\u0002'=+F\u000bU+U?RK\u0006+R0M\u0003R+5\u000b\u0016\u0011\u0002'\t,\u0018\u000e\u001c3GS2,7+_:uK64\u0016.Z<\u0015\u000f5Cv\f\u001c8qeB\u0011aJV\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0005m&,wO\u0003\u0002S'\u0006)A/\u00192mK*\u0011A+V\u0001\u0007G>lWn\u001c8\u000b\u0005ai\u0012BA,P\u0005eAun\u001c3jKR\u000b'\r\\3GS2,7+_:uK64\u0016.Z<\t\u000bI[\u0001\u0019A-\u0011\u00071RF,\u0003\u0002\\[\t1q\n\u001d;j_:\u0004\"\u0001L/\n\u0005yk#aA!os\")\u0001m\u0003a\u0001C\u0006Iq\r\\8c%\u0016<W\r\u001f\t\u0003E&t!aY4\u0011\u0005\u0011lS\"A3\u000b\u0005\u0019\f\u0013A\u0002\u001fs_>$h(\u0003\u0002i[\u00051\u0001K]3eK\u001aL!A[6\u0003\rM#(/\u001b8h\u0015\tAW\u0006C\u0003n\u0017\u0001\u0007\u0011-\u0001\u0006nCbLen\u001d;b]RDQa\\\u0006A\u0002-\n\u0011#\u001b8dYV$W-T1y\u0013:\u001cH/\u00198u\u0011\u0015\t8\u00021\u0001,\u0003=Ign\u00197vI\u0016LeN\u001a7jO\"$\b\"B:\f\u0001\u0004Y\u0013!E3yG2,H-Z\"p[B\f7\r^5p]\u0006\t2\u000f[8x\u00032dg)\u001b7f'2L7-Z:\u0015\u0007Y\f)\u0001E\u0002xyzl\u0011\u0001\u001f\u0006\u0003sj\fA!\u001e;jY*\t10\u0001\u0003kCZ\f\u0017BA?y\u0005\u0011a\u0015n\u001d;\u0011\u0007}\f\t!D\u0001\u001a\u0013\r\t\u0019!\u0007\u0002\u0004%><\bBBA\u0004\u0019\u0001\u0007Q*\u0001\u0004ggZKWm^\u0001\u0015g\"|w\u000fT1uKN$h)\u001b7f'2L7-Z:\u0015\u0017Y\fi!a\u0004\u0002\u0012\u0005U\u0011q\u0003\u0005\u0007\u0003\u000fi\u0001\u0019A'\t\u000bIk\u0001\u0019A-\t\r\u0005MQ\u00021\u0001b\u0003%\u0001\u0018M\u001d;ji&|g\u000eC\u0003n\u001b\u0001\u0007\u0011\r\u0003\u0004\u0002\u001a5\u0001\raK\u0001\u0006[\u0016\u0014x-Z\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\u0018AC8viB,H\u000fV=qK\u0006!1-\u00197m)\u0011\t\u0019#!\u000e\u0011\u000b\u0005\u0015\u0012q\u0006@\u000f\t\u0005\u001d\u00121\u0006\b\u0004I\u0006%\u0012\"\u0001\u0018\n\u0007\u00055R&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00121\u0007\u0002\u0004'\u0016\f(bAA\u0017[!9\u0011q\u0007\tA\u0002\u0005e\u0012\u0001B1sON\u00042\u0001JA\u001e\u0013\r\tid\u0005\u0002\u000e!J|7-\u001a3ve\u0016\f%oZ:\u0002\u000b\t,\u0018\u000e\u001c3\u0016\u0005\u0005\r\u0003c\u0001\u0013\u0002F%\u0019\u0011qI\n\u0003\u0013A\u0013xnY3ekJ,\u0007")
public class ShowFileSystemViewProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final boolean showLatest;
    private final ProcedureParameter[] PARAMETERS_ALL;
    private final StructType OUTPUT_TYPE_ALL;
    private final ProcedureParameter[] PARAMETERS_LATEST;
    private final StructType OUTPUT_TYPE_LATEST;

    private ProcedureParameter[] PARAMETERS_ALL() {
        return this.PARAMETERS_ALL;
    }

    private StructType OUTPUT_TYPE_ALL() {
        return this.OUTPUT_TYPE_ALL;
    }

    private ProcedureParameter[] PARAMETERS_LATEST() {
        return this.PARAMETERS_LATEST;
    }

    private StructType OUTPUT_TYPE_LATEST() {
        return this.OUTPUT_TYPE_LATEST;
    }

    private HoodieTableFileSystemView buildFileSystemView(Option<Object> table, String globRegex, String maxInstant, boolean includeMaxInstant, boolean includeInflight, boolean excludeCompaction) {
        HoodieTimeline timeline;
        List list;
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        HoodieStorage storage = metaClient.getStorage();
        String string = globRegex;
        Object object = this.PARAMETERS_ALL()[6].default();
        if (!(string != null ? !string.equals(object) : object != null)) {
            list = FSUtils.getAllDataPathInfo((HoodieStorage)storage, (StoragePath)new StoragePath(basePath));
        } else {
            String globPath = String.format("%s/%s/*", basePath, globRegex);
            list = FSUtils.getGlobStatusExcludingMetaFolder((HoodieStorage)storage, (StoragePath)new StoragePath(globPath));
        }
        List statuses = list;
        Object object2 = timeline = excludeCompaction ? metaClient.getActiveTimeline().getCommitsTimeline() : metaClient.getActiveTimeline().getWriteTimeline();
        if (!includeInflight) {
            timeline = timeline.filterCompletedInstants();
        }
        Iterator instants = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(timeline.getInstants().iterator()).asScala();
        if (new StringOps(Predef$.MODULE$.augmentString(maxInstant)).nonEmpty()) {
            BiPredicate predicate = includeMaxInstant ? HoodieTimeline.GREATER_THAN_OR_EQUALS : HoodieTimeline.GREATER_THAN;
            instants = instants.filter((Function1 & Serializable & scala.Serializable)instant -> BoxesRunTime.boxToBoolean((boolean)predicate.test(maxInstant, instant.getTimestamp())));
        }
        Function<HoodieInstant, org.apache.hudi.common.util.Option<byte[]>> details = new Function<HoodieInstant, org.apache.hudi.common.util.Option<byte[]>>(null, metaClient){
            private final HoodieTableMetaClient metaClient$1;

            public <V> Function<V, org.apache.hudi.common.util.Option<byte[]>> compose(Function<? super V, ? extends HoodieInstant> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<HoodieInstant, V> andThen(Function<? super org.apache.hudi.common.util.Option<byte[]>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public org.apache.hudi.common.util.Option<byte[]> apply(HoodieInstant instant) {
                return this.metaClient$1.getActiveTimeline().getInstantDetails(instant);
            }
            {
                this.metaClient$1 = metaClient$1;
            }
        };
        HoodieDefaultTimeline filteredTimeline = new HoodieDefaultTimeline(new ArrayList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)instants.toList()).asJava()).stream(), (Function)details);
        return new HoodieTableFileSystemView(metaClient, (HoodieTimeline)filteredTimeline, statuses);
    }

    /*
     * WARNING - void declaration
     */
    private List<Row> showAllFileSlices(HoodieTableFileSystemView fsView) {
        void var2_2;
        ArrayList rows = new ArrayList();
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fsView.getAllFileGroups().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)fg -> {
            ShowFileSystemViewProcedure.$anonfun$showAllFileSlices$1(rows, fg);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    private List<Row> showLatestFileSlices(HoodieTableFileSystemView fsView, Option<Object> table, String partition, String maxInstant, boolean merge) {
        Stream fileSliceStream = null;
        if (!merge) {
            fileSliceStream = fsView.getLatestFileSlices(partition);
        } else {
            String string;
            if (maxInstant.isEmpty()) {
                String basePath = this.getBasePath(table, this.getBasePath$default$2());
                HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)this.jsc().hadoopConfiguration())).setBasePath(basePath).build();
                string = ((HoodieInstant)metaClient.getActiveTimeline().filterCompletedAndCompactionInstants().lastInstant().get()).getTimestamp();
            } else {
                string = maxInstant;
            }
            fileSliceStream = fsView.getLatestMergedFileSlicesBeforeOrOn(partition, string);
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fileSliceStream.iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)fs -> BoxesRunTime.boxToBoolean((boolean)ShowFileSystemViewProcedure.$anonfun$showLatestFileSlices$1(rows, partition, fs)));
        return rows;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.showLatest ? this.PARAMETERS_LATEST() : this.PARAMETERS_ALL();
    }

    @Override
    public StructType outputType() {
        return this.showLatest ? this.OUTPUT_TYPE_LATEST() : this.OUTPUT_TYPE_ALL();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        List<Row> list;
        super.checkArgs(this.parameters(), args);
        Option<Object> table = this.getArgValueOrDefault(args, this.parameters()[0]);
        String maxInstant = (String)this.getArgValueOrDefault(args, this.parameters()[1]).get();
        boolean includeMax = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.parameters()[2]).get());
        boolean includeInflight = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.parameters()[3]).get());
        boolean excludeCompaction = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.parameters()[4]).get());
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.parameters()[5]).get());
        if (!this.showLatest) {
            String globRegex = (String)this.getArgValueOrDefault(args, this.parameters()[6]).get();
            HoodieTableFileSystemView fsView = this.buildFileSystemView(table, globRegex, maxInstant, includeMax, includeInflight, excludeCompaction);
            list = this.showAllFileSlices(fsView);
        } else {
            String partitionPath = (String)this.getArgValueOrDefault(args, this.parameters()[6]).get();
            boolean merge = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.parameters()[7]).get());
            HoodieTableFileSystemView fsView = this.buildFileSystemView(table, partitionPath, maxInstant, includeMax, includeInflight, excludeCompaction);
            list = this.showLatestFileSlices(fsView, table, partitionPath, maxInstant, merge);
        }
        List<Row> rows = list;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    @Override
    public Procedure build() {
        return new ShowFileSystemViewProcedure(this.showLatest);
    }

    public static final /* synthetic */ boolean $anonfun$showAllFileSlices$2(HoodieFileGroup fg$1, List rows$1, FileSlice fs) {
        String fileId = fg$1.getFileGroupId().getFileId();
        String baseFilePath = "";
        long baseFileSize = 0L;
        if (fs.getBaseFile().isPresent()) {
            baseFilePath = ((BaseFile)fs.getBaseFile().get()).getPath();
            baseFileSize = ((BaseFile)fs.getBaseFile().get()).getFileSize();
        }
        long numLogFiles = fs.getLogFiles().count();
        long sumLogFileSize = BoxesRunTime.unboxToLong((Object)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getFileSize())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        String logFiles = fs.getLogFiles().collect(Collectors.toList()).toString();
        return rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fg$1.getPartitionPath(), fileId, fs.getBaseInstantTime(), baseFilePath, BoxesRunTime.boxToLong((long)baseFileSize), BoxesRunTime.boxToLong((long)numLogFiles), BoxesRunTime.boxToLong((long)sumLogFileSize), logFiles})));
    }

    public static final /* synthetic */ void $anonfun$showAllFileSlices$1(List rows$1, HoodieFileGroup fg) {
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fg.getAllFileSlices().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)fs -> BoxesRunTime.boxToBoolean((boolean)ShowFileSystemViewProcedure.$anonfun$showAllFileSlices$2(fg, rows$1, fs)));
    }

    public static final /* synthetic */ boolean $anonfun$showLatestFileSlices$3(FileSlice fs$1, HoodieLogFile logFile) {
        return logFile.getBaseCommitTime().equals(fs$1.getBaseInstantTime());
    }

    public static final /* synthetic */ boolean $anonfun$showLatestFileSlices$5(FileSlice fs$1, HoodieLogFile logFile) {
        return !logFile.getBaseCommitTime().equals(fs$1.getBaseInstantTime());
    }

    public static final /* synthetic */ boolean $anonfun$showLatestFileSlices$7(FileSlice fs$1, HoodieLogFile logFile) {
        return logFile.getBaseCommitTime().equals(fs$1.getBaseInstantTime());
    }

    public static final /* synthetic */ boolean $anonfun$showLatestFileSlices$8(FileSlice fs$1, HoodieLogFile logFile) {
        return !logFile.getBaseCommitTime().equals(fs$1.getBaseInstantTime());
    }

    public static final /* synthetic */ boolean $anonfun$showLatestFileSlices$1(List rows$2, String partition$1, FileSlice fs) {
        String fileId = fs.getFileId();
        String baseInstantTime = fs.getBaseInstantTime();
        String baseFilePath = "";
        long baseFileSize = 0L;
        if (fs.getBaseFile().isPresent()) {
            baseFilePath = ((BaseFile)fs.getBaseFile().get()).getPath();
            baseFileSize = ((BaseFile)fs.getBaseFile().get()).getFileSize();
        }
        long numLogFiles = fs.getLogFiles().count();
        long sumLogFileSize = BoxesRunTime.unboxToLong((Object)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getFileSize())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long logFilesScheduledForCompactionTotalSize = BoxesRunTime.unboxToLong((Object)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)logFile -> BoxesRunTime.boxToBoolean((boolean)ShowFileSystemViewProcedure.$anonfun$showLatestFileSlices$3(fs, logFile))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getFileSize())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long logFilesUnscheduledTotalSize = BoxesRunTime.unboxToLong((Object)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)logFile -> BoxesRunTime.boxToBoolean((boolean)ShowFileSystemViewProcedure.$anonfun$showLatestFileSlices$5(fs, logFile))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.getFileSize())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        double logSelectedForCompactionToBaseRatio = baseFileSize > 0L ? (double)logFilesScheduledForCompactionTotalSize / ((double)baseFileSize * 1.0) : -1.0;
        double logUnscheduledToBaseRatio = baseFileSize > 0L ? (double)logFilesUnscheduledTotalSize / ((double)baseFileSize * 1.0) : -1.0;
        String logFilesCommitTimeEqualInstantTime = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)logFile -> BoxesRunTime.boxToBoolean((boolean)ShowFileSystemViewProcedure.$anonfun$showLatestFileSlices$7(fs, logFile))).mkString("[", ",", "]");
        String logFilesCommitTimeNonEqualInstantTime = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)logFile -> BoxesRunTime.boxToBoolean((boolean)ShowFileSystemViewProcedure.$anonfun$showLatestFileSlices$8(fs, logFile))).mkString("[", ",", "]");
        return rows$2.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition$1, fileId, baseInstantTime, baseFilePath, BoxesRunTime.boxToLong((long)baseFileSize), BoxesRunTime.boxToLong((long)numLogFiles), BoxesRunTime.boxToLong((long)sumLogFileSize), BoxesRunTime.boxToLong((long)logFilesScheduledForCompactionTotalSize), BoxesRunTime.boxToLong((long)logFilesUnscheduledTotalSize), BoxesRunTime.boxToDouble((double)logSelectedForCompactionToBaseRatio), BoxesRunTime.boxToDouble((double)logUnscheduledToBaseRatio), logFilesCommitTimeEqualInstantTime, logFilesCommitTimeNonEqualInstantTime})));
    }

    public ShowFileSystemViewProcedure(boolean showLatest) {
        this.showLatest = showLatest;
        this.PARAMETERS_ALL = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "max_instant", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(2, "include_max", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(3, "include_in_flight", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(4, "exclude_compaction", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(5, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.optional(6, "path_regex", DataTypes.StringType, "*/*/*")});
        this.OUTPUT_TYPE_ALL = new StructType((StructField[])((Object[])new StructField[]{new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_id", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("base_instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("data_file", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("data_file_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_delta_files", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_delta_file_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("delta_files", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
        this.PARAMETERS_LATEST = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "max_instant", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(2, "include_max", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(3, "include_inflight", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(4, "exclude_compaction", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(5, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.required(6, "partition_path", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(7, "merge", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)true))});
        this.OUTPUT_TYPE_LATEST = new StructType((StructField[])((Object[])new StructField[]{new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_id", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("base_instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("data_file", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("data_file_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_delta_files", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_delta_file_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("delta_size_compaction_scheduled", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("delta_size_compaction_unscheduled", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("delta_to_base_radio_compaction_scheduled", DataTypes.DoubleType, true, Metadata$.MODULE$.empty()), new StructField("delta_to_base_radio_compaction_unscheduled", DataTypes.DoubleType, true, Metadata$.MODULE$.empty()), new StructField("delta_files_compaction_scheduled", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("delta_files_compaction_unscheduled", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

