/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowCommitsProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\r\u001b\u0001%B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\u0006q\u0001!\t!\u000f\u0005\ny\u0001\u0001\r\u00111A\u0005\u0002uB\u0011\"\u0011\u0001A\u0002\u0003\u0007I\u0011\u0001\"\t\u0013!\u0003\u0001\u0019!A!B\u0013q\u0004bB%\u0001\u0005\u0004%IA\u0013\u0005\u0007\u001d\u0002\u0001\u000b\u0011B&\t\u000f=\u0003!\u0019!C\u0005!\"1q\u000b\u0001Q\u0001\nECq\u0001\u0017\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004Z\u0001\u0001\u0006I!\u0015\u0005\u00065\u0002!\tA\u0013\u0005\u00067\u0002!\t\u0001\u0015\u0005\u00069\u0002!\t%\u0018\u0005\u0006g\u0002!\t\u0005\u001e\u0005\u0006q\u0002!I!\u001f\u0005\b\u0003/\u0001A\u0011BA\r\u0011\u001d\tY\u0004\u0001C\u0001\u0003{9q!a\u0011\u001b\u0011\u0003\t)E\u0002\u0004\u001a5!\u0005\u0011q\t\u0005\u0007qQ!\t!a\u0014\t\u0013\u0005ECC1A\u0005\u0002\u0005M\u0003\u0002CA1)\u0001\u0006I!!\u0016\t\u000f\u0005\rD\u0003\"\u0001\u0002f\t!2\u000b[8x\u0007>lW.\u001b;t!J|7-\u001a3ve\u0016T!a\u0007\u000f\u0002\u0015A\u0014xnY3ekJ,7O\u0003\u0002\u001e=\u000591m\\7nC:$'BA\u0010!\u0003\u0011AW\u000fZ5\u000b\u0005\u0005\u0012\u0013aA:rY*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Qc\u0006\u0005\u0002,Y5\t!$\u0003\u0002.5\ti!)Y:f!J|7-\u001a3ve\u0016\u0004\"aK\u0018\n\u0005AR\"\u0001\u0005)s_\u000e,G-\u001e:f\u0005VLG\u000eZ3s\u0003QIgn\u00197vI\u0016,\u0005\u0010\u001e:b\u001b\u0016$\u0018\rZ1uCB\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u0002;wA\u00111\u0006\u0001\u0005\u0006c\t\u0001\rAM\u0001\u0015g>\u0014HOQ=GS\u0016dG\rU1sC6,G/\u001a:\u0016\u0003y\u0002\"aK \n\u0005\u0001S\"A\u0005)s_\u000e,G-\u001e:f!\u0006\u0014\u0018-\\3uKJ\f\u0001d]8si\nKh)[3mIB\u000b'/Y7fi\u0016\u0014x\fJ3r)\t\u0019e\t\u0005\u00024\t&\u0011Q\t\u000e\u0002\u0005+:LG\u000fC\u0004H\t\u0005\u0005\t\u0019\u0001 \u0002\u0007a$\u0013'A\u000bt_J$()\u001f$jK2$\u0007+\u0019:b[\u0016$XM\u001d\u0011\u0002\u0015A\u000b%+Q'F)\u0016\u00136+F\u0001L!\r\u0019DJP\u0005\u0003\u001bR\u0012Q!\u0011:sCf\f1\u0002U!S\u00036+E+\u0012*TA\u0005Yq*\u0016+Q+R{F+\u0017)F+\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+!\u0003\u0015!\u0018\u0010]3t\u0013\t16K\u0001\u0006TiJ,8\r\u001e+za\u0016\fAbT+U!V#v\fV-Q\u000b\u0002\nA#T#U\u0003\u0012\u000bE+Q0P+R\u0003V\u000bV0U3B+\u0015!F'F)\u0006#\u0015\tV!`\u001fV#\u0006+\u0016+`)f\u0003V\tI\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\u0018AC8viB,H\u000fV=qK\u0006!1-\u00197m)\tqf\u000eE\u0002`O*t!\u0001Y3\u000f\u0005\u0005$W\"\u00012\u000b\u0005\rD\u0013A\u0002\u001fs_>$h(C\u00016\u0013\t1G'A\u0004qC\u000e\\\u0017mZ3\n\u0005!L'aA*fc*\u0011a\r\u000e\t\u0003W2l\u0011\u0001I\u0005\u0003[\u0002\u00121AU8x\u0011\u0015yg\u00021\u0001q\u0003\u0011\t'oZ:\u0011\u0005-\n\u0018B\u0001:\u001b\u00055\u0001&o\\2fIV\u0014X-\u0011:hg\u0006)!-^5mIV\tQ\u000f\u0005\u0002,m&\u0011qO\u0007\u0002\n!J|7-\u001a3ve\u0016\facZ3u\u0007>lW.\u001b;t/&$\b.T3uC\u0012\fG/\u0019\u000b\u0005=j\fi\u0001C\u0003|!\u0001\u0007A0\u0001\u0005uS6,G.\u001b8f!\ri\u0018\u0011B\u0007\u0002}*\u00111p \u0006\u0005\u0003\u0003\t\u0019!A\u0003uC\ndWM\u0003\u0003\u0002\u0006\u0005\u001d\u0011AB2p[6|gN\u0003\u0002 I%\u0019\u00111\u0002@\u0003+!{w\u000eZ5f\t\u00164\u0017-\u001e7u)&lW\r\\5oK\"9\u0011q\u0002\tA\u0002\u0005E\u0011!\u00027j[&$\bcA\u001a\u0002\u0014%\u0019\u0011Q\u0003\u001b\u0003\u0007%sG/\u0001\bhKR\u001cvN\u001d;D_6l\u0017\u000e^:\u0015\t\u0005m\u0011\u0011\b\t\bg\u0005u\u0011\u0011EA\u0019\u0013\r\ty\u0002\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000b\u0005\r\u0012Q\u00066\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\tA!\u001e;jY*\u0011\u00111F\u0001\u0005U\u00064\u0018-\u0003\u0003\u00020\u0005\u0015\"!C!se\u0006LH*[:u!\u0019\t\u0019#!\f\u00024A\u0019Q0!\u000e\n\u0007\u0005]bPA\u0007I_>$\u0017.Z%ogR\fg\u000e\u001e\u0005\u0006wF\u0001\r\u0001`\u0001\u000bO\u0016$8i\\7nSR\u001cH#\u00020\u0002@\u0005\u0005\u0003\"B>\u0013\u0001\u0004a\bbBA\b%\u0001\u0007\u0011\u0011C\u0001\u0015'\"|woQ8n[&$8\u000f\u0015:pG\u0016$WO]3\u0011\u0005-\"2c\u0001\u000b\u0002JA\u00191'a\u0013\n\u0007\u00055CG\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u000b\nAAT!N\u000bV\u0011\u0011Q\u000b\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)!\u00111LA\u0015\u0003\u0011a\u0017M\\4\n\t\u0005}\u0013\u0011\f\u0002\u0007'R\u0014\u0018N\\4\u0002\u000b9\u000bU*\u0012\u0011\u0002\u000f\t,\u0018\u000e\u001c3feV\u0011\u0011q\r\t\u0006\u0003S\nyGL\u0007\u0003\u0003WRA!!\u001c\u0002&\u0005Aa-\u001e8di&|g.\u0003\u0003\u0002r\u0005-$\u0001C*vaBd\u0017.\u001a:")
public class ShowCommitsProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final boolean includeExtraMetadata;
    private ProcedureParameter sortByFieldParameter;
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private final StructType METADATA_OUTPUT_TYPE;

    public static Supplier<ProcedureBuilder> builder() {
        return ShowCommitsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowCommitsProcedure$.MODULE$.NAME();
    }

    public ProcedureParameter sortByFieldParameter() {
        return this.sortByFieldParameter;
    }

    public void sortByFieldParameter_$eq(ProcedureParameter x$1) {
        this.sortByFieldParameter = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    private StructType METADATA_OUTPUT_TYPE() {
        return this.METADATA_OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.includeExtraMetadata ? this.METADATA_OUTPUT_TYPE() : this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        return this.includeExtraMetadata ? this.getCommitsWithMetadata((HoodieDefaultTimeline)activeTimeline, limit) : this.getCommits((HoodieDefaultTimeline)activeTimeline, limit);
    }

    @Override
    public Procedure build() {
        return new ShowCommitsProcedure(this.includeExtraMetadata);
    }

    private Seq<Row> getCommitsWithMetadata(HoodieDefaultTimeline timeline, int limit) {
        ArrayList arrayList;
        ArrayList newCommits;
        block3: {
            Tuple2<ArrayList<Row>, ArrayList<HoodieInstant>> tuple2;
            block2: {
                tuple2 = this.getSortCommits(timeline);
                if (tuple2 == null) break block2;
                ArrayList rows = (ArrayList)tuple2._1();
                newCommits = (ArrayList)tuple2._2();
                if (rows == null) break block2;
                arrayList = rows;
                if (newCommits != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        ArrayList arrayList2 = newCommits;
        Tuple2 tuple2 = new Tuple2((Object)arrayList, (Object)arrayList2);
        Tuple2 tuple22 = tuple2;
        ArrayList rows = (ArrayList)tuple22._1();
        ArrayList newCommits2 = (ArrayList)tuple22._2();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), newCommits2.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            HoodieInstant commit = (HoodieInstant)newCommits2.get(i);
            HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails(commit).get()), HoodieCommitMetadata.class);
            JavaConversions$.MODULE$.deprecated$u0020asScalaSet(commitMetadata.getPartitionToWriteStats().entrySet()).foreach((Function1 & Serializable & scala.Serializable)partitionWriteStat -> {
                ShowCommitsProcedure.$anonfun$getCommitsWithMetadata$2(rows, commit, partitionWriteStat);
                return BoxedUnit.UNIT;
            });
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    private Tuple2<ArrayList<Row>, ArrayList<HoodieInstant>> getSortCommits(HoodieDefaultTimeline timeline) {
        ArrayList rows = new ArrayList();
        List commits = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(timeline.getCommitsTimeline().filterCompletedInstants().getInstants().toArray())).map((Function1 & Serializable & scala.Serializable)instant -> (HoodieInstant)instant, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HoodieInstant.class))))).toList()).asJava();
        ArrayList newCommits = new ArrayList(commits);
        Collections.sort(newCommits, HoodieInstant.COMPARATOR.reversed());
        return new Tuple2(rows, newCommits);
    }

    public Seq<Row> getCommits(HoodieDefaultTimeline timeline, int limit) {
        ArrayList arrayList;
        ArrayList newCommits;
        block3: {
            Tuple2<ArrayList<Row>, ArrayList<HoodieInstant>> tuple2;
            block2: {
                tuple2 = this.getSortCommits(timeline);
                if (tuple2 == null) break block2;
                ArrayList rows = (ArrayList)tuple2._1();
                newCommits = (ArrayList)tuple2._2();
                if (rows == null) break block2;
                arrayList = rows;
                if (newCommits != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        ArrayList arrayList2 = newCommits;
        Tuple2 tuple2 = new Tuple2((Object)arrayList, (Object)arrayList2);
        Tuple2 tuple22 = tuple2;
        ArrayList rows = (ArrayList)tuple22._1();
        ArrayList newCommits2 = (ArrayList)tuple22._2();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), newCommits2.size()).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
            HoodieInstant commit = (HoodieInstant)newCommits2.get(i);
            HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails(commit).get()), HoodieCommitMetadata.class);
            return rows.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commit.getTimestamp(), commit.getCompletionTime(), commit.getAction(), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalBytesWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalFilesInsert()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalFilesUpdated()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalPartitionsWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalRecordsWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalUpdateRecordsWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalWriteErrors())})));
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    public static final /* synthetic */ void $anonfun$getCommitsWithMetadata$2(ArrayList rows$1, HoodieInstant commit$1, Map.Entry partitionWriteStat) {
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer((List)partitionWriteStat.getValue()).foreach((Function1 & Serializable & scala.Serializable)hoodieWriteStat -> BoxesRunTime.boxToBoolean((boolean)rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commit$1.getTimestamp(), commit$1.getCompletionTime(), commit$1.getAction(), hoodieWriteStat.getPartitionPath(), hoodieWriteStat.getFileId(), hoodieWriteStat.getPrevCommit(), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumWrites()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumInserts()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumDeletes()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumUpdateWrites()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalWriteErrors()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalLogBlocks()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalCorruptLogBlock()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalRollbackBlocks()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalLogRecords()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalUpdatedRecordsCompacted()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalWriteBytes())})))));
    }

    public ShowCommitsProcedure(boolean includeExtraMetadata) {
        this.includeExtraMetadata = includeExtraMetadata;
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10))});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("commit_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("state_transition_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("total_bytes_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_files_added", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_files_updated", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_partitions_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_records_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_update_records_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_errors", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));
        this.METADATA_OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("commit_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("state_transition_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_id", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("previous_commit", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("num_writes", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_inserts", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_deletes", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_update_writes", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_errors", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_log_blocks", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_corrupt_log_blocks", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_rollback_blocks", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_log_records", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_updated_records_compacted", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_bytes_written", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));
    }
}

