/*
 * Decompiled with CFR 0.152.
 */
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.MultiPartKeysValueExtractor;
import org.apache.hudi.hive.NonPartitionedExtractor;
import org.apache.hudi.hive.SlashEncodedDayPartitionValueExtractor;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieJavaGenerateApp {
    @Parameter(names={"--table-path", "-p"}, description="Path for Hoodie sample table")
    private String tablePath = "file:///tmp/hoodie/sample-table";
    @Parameter(names={"--table-name", "-n"}, description="Table name for Hoodie sample table")
    private String tableName = "hoodie_test";
    @Parameter(names={"--table-type", "-t"}, description="One of COPY_ON_WRITE or MERGE_ON_READ")
    private String tableType = HoodieTableType.COPY_ON_WRITE.name();
    @Parameter(names={"--hive-sync", "-hs"}, description="Enable syncing to hive")
    private Boolean enableHiveSync = false;
    @Parameter(names={"--hive-db", "-hd"}, description="Hive database")
    private String hiveDB = "default";
    @Parameter(names={"--hive-table", "-ht"}, description="Hive table")
    private String hiveTable = "hoodie_sample_test";
    @Parameter(names={"--hive-user", "-hu"}, description="Hive username")
    private String hiveUser = "hive";
    @Parameter(names={"--hive-password", "-hp"}, description="Hive password")
    private String hivePass = "hive";
    @Parameter(names={"--hive-url", "-hl"}, description="Hive JDBC URL")
    private String hiveJdbcUrl = "jdbc:hive2://localhost:10000";
    @Parameter(names={"--non-partitioned", "-np"}, description="Use non-partitioned Table")
    private Boolean nonPartitionedTable = false;
    @Parameter(names={"--use-multi-partition-keys", "-mp"}, description="Use Multiple Partition Keys")
    private Boolean useMultiPartitionKeys = false;
    @Parameter(names={"--commit-type", "-ct"}, description="How may commits will run")
    private String commitType = "overwrite";
    @Parameter(names={"--help", "-h"}, help=true)
    public Boolean help = false;
    private static final Logger LOG = LoggerFactory.getLogger(HoodieJavaGenerateApp.class);

    public static void main(String[] args) throws Exception {
        HoodieJavaGenerateApp cli = new HoodieJavaGenerateApp();
        JCommander cmd = new JCommander((Object)cli, null, args);
        if (cli.help.booleanValue()) {
            cmd.usage();
            System.exit(1);
        }
        try (SparkSession spark = cli.getOrCreateSparkSession();){
            cli.insert(spark);
        }
    }

    private SparkSession getOrCreateSparkSession() {
        SparkSession spark = SparkSession.builder().config(HoodieClientTestUtils.getSparkConfForTest((String)"Hoodie Spark APP")).getOrCreate();
        spark.sparkContext().setLogLevel("WARN");
        return spark;
    }

    private HoodieTestDataGenerator getDataGenerate() {
        if (this.nonPartitionedTable.booleanValue()) {
            return new HoodieTestDataGenerator(new String[]{""});
        }
        return new HoodieTestDataGenerator();
    }

    private DataFrameWriter<Row> updateHiveSyncConfig(DataFrameWriter<Row> writer) {
        if (this.enableHiveSync.booleanValue()) {
            LOG.info("Enabling Hive sync to " + this.hiveJdbcUrl);
            writer = writer.option(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), this.hiveTable).option(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), this.hiveDB).option(HiveSyncConfigHolder.HIVE_URL.key(), this.hiveJdbcUrl).option(HiveSyncConfigHolder.HIVE_USER.key(), this.hiveUser).option(HiveSyncConfigHolder.HIVE_PASS.key(), this.hivePass).option(HiveSyncConfigHolder.HIVE_SYNC_ENABLED.key(), "true");
            writer = this.nonPartitionedTable != false ? writer.option(HiveSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), NonPartitionedExtractor.class.getCanonicalName()).option(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), "") : (this.useMultiPartitionKeys != false ? writer.option(HiveSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "year,month,day").option(HiveSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), MultiPartKeysValueExtractor.class.getCanonicalName()) : writer.option(HiveSyncConfig.META_SYNC_PARTITION_FIELDS.key(), "dateStr").option(HiveSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), SlashEncodedDayPartitionValueExtractor.class.getCanonicalName()));
        }
        return writer;
    }

    private void insert(SparkSession spark) throws IOException {
        HoodieTestDataGenerator dataGen = this.getDataGenerate();
        JavaSparkContext jssc = new JavaSparkContext(spark.sparkContext());
        String instantTime = InProcessTimeGenerator.createNewInstantTime();
        ArrayList recordsSoFar = new ArrayList(dataGen.generateInserts(instantTime, Integer.valueOf(100)));
        List records1 = RawTripTestPayload.recordsToStrings(recordsSoFar);
        Dataset inputDF1 = spark.read().json(jssc.parallelize(records1, 2));
        DataFrameWriter writer = inputDF1.write().format("org.apache.hudi").option("hoodie.insert.shuffle.parallelism", "2").option("hoodie.upsert.shuffle.parallelism", "2").option(DataSourceWriteOptions.TABLE_TYPE().key(), this.tableType).option(DataSourceWriteOptions.OPERATION().key(), DataSourceWriteOptions.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "_row_key").option(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), "partition").option(DataSourceWriteOptions.PRECOMBINE_FIELD().key(), "timestamp").option(HoodieWriteConfig.TBL_NAME.key(), this.tableName).mode(this.commitType);
        this.updateHiveSyncConfig((DataFrameWriter<Row>)writer);
        writer.save(this.tablePath);
        FileSystem fs = FileSystem.get((Configuration)jssc.hadoopConfiguration());
        String commitInstantTime1 = HoodieDataSourceHelpers.latestCommit((FileSystem)fs, (String)this.tablePath);
        LOG.info("Commit at instant time :" + commitInstantTime1);
    }
}

