/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.hudi.ColumnStatsIndexSupport$;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.util.JavaScalaConverters;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import scala.collection.Seq;

public class ColumnStatsIndexHelper {
    public static Pair<Object, Object> fetchMinMaxValues(@Nonnull DataType colType, @Nonnull HoodieColumnRangeMetadata<Comparable> colMetadata) {
        if (colType instanceof IntegerType) {
            return Pair.of((Object)new Integer(colMetadata.getMinValue().toString()), (Object)new Integer(colMetadata.getMaxValue().toString()));
        }
        if (colType instanceof DoubleType) {
            return Pair.of((Object)new Double(colMetadata.getMinValue().toString()), (Object)new Double(colMetadata.getMaxValue().toString()));
        }
        if (colType instanceof StringType) {
            return Pair.of((Object)colMetadata.getMinValue().toString(), (Object)colMetadata.getMaxValue().toString());
        }
        if (colType instanceof DecimalType) {
            return Pair.of((Object)new BigDecimal(colMetadata.getMinValue().toString()), (Object)new BigDecimal(colMetadata.getMaxValue().toString()));
        }
        if (colType instanceof DateType) {
            return Pair.of((Object)Date.valueOf(colMetadata.getMinValue().toString()), (Object)Date.valueOf(colMetadata.getMaxValue().toString()));
        }
        if (colType instanceof LongType) {
            return Pair.of((Object)new Long(colMetadata.getMinValue().toString()), (Object)new Long(colMetadata.getMaxValue().toString()));
        }
        if (colType instanceof ShortType) {
            return Pair.of((Object)new Short(colMetadata.getMinValue().toString()), (Object)new Short(colMetadata.getMaxValue().toString()));
        }
        if (colType instanceof FloatType) {
            return Pair.of((Object)new Float(colMetadata.getMinValue().toString()), (Object)new Float(colMetadata.getMaxValue().toString()));
        }
        if (colType instanceof BinaryType) {
            return Pair.of((Object)((ByteBuffer)colMetadata.getMinValue()).array(), (Object)((ByteBuffer)colMetadata.getMaxValue()).array());
        }
        if (colType instanceof BooleanType) {
            return Pair.of((Object)Boolean.valueOf(colMetadata.getMinValue().toString()), (Object)Boolean.valueOf(colMetadata.getMaxValue().toString()));
        }
        if (colType instanceof ByteType) {
            return Pair.of((Object)Byte.valueOf(colMetadata.getMinValue().toString()), (Object)Byte.valueOf(colMetadata.getMaxValue().toString()));
        }
        throw new HoodieException(String.format("Not support type:  %s", colType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Dataset<Row> buildColumnStatsTableFor(@Nonnull SparkSession sparkSession, @Nonnull List<String> baseFilesPaths, @Nonnull List<StructField> orderedColumnSchemas) {
        List colMinMaxInfos;
        SparkContext sc = sparkSession.sparkContext();
        JavaSparkContext jsc = new JavaSparkContext(sc);
        List columnNames = orderedColumnSchemas.stream().map(StructField::name).collect(Collectors.toList());
        SerializableConfiguration serializableConfiguration = new SerializableConfiguration(sc.hadoopConfiguration());
        int numParallelism = baseFilesPaths.size() / 3 + 1;
        String previousJobDescription = sc.getLocalProperty("spark.job.description");
        try {
            jsc.setJobDescription("Listing parquet column statistics");
            colMinMaxInfos = jsc.parallelize(baseFilesPaths, numParallelism).mapPartitions((FlatMapFunction & Serializable)paths -> {
                ParquetUtils utils = new ParquetUtils();
                Iterable iterable = () -> paths;
                return StreamSupport.stream(iterable.spliterator(), false).flatMap(path -> {
                    HoodieHadoopStorage storage = new HoodieHadoopStorage(path, serializableConfiguration.value());
                    return utils.readColumnStatsFromMetadata((HoodieStorage)storage, new StoragePath(path), columnNames).stream();
                }).iterator();
            }).collect();
        }
        finally {
            jsc.setJobDescription(previousJobDescription);
        }
        Map<String, List<HoodieColumnRangeMetadata>> filePathToColumnMetadataMap = colMinMaxInfos.stream().collect(Collectors.groupingBy(HoodieColumnRangeMetadata::getFilePath));
        JavaRDD allMetaDataRDD = jsc.parallelize(new ArrayList<List<HoodieColumnRangeMetadata>>(filePathToColumnMetadataMap.values()), 1).map((Function & Serializable)fileColumnsMetadata -> {
            int colSize = fileColumnsMetadata.size();
            if (colSize == 0) {
                return null;
            }
            String filePath = ((HoodieColumnRangeMetadata)fileColumnsMetadata.get(0)).getFilePath();
            ArrayList<String> indexRow = new ArrayList<String>();
            indexRow.add(filePath);
            orderedColumnSchemas.forEach(colSchema -> {
                String colName = colSchema.name();
                HoodieColumnRangeMetadata colMetadata = fileColumnsMetadata.stream().filter(s -> s.getColumnName().trim().equalsIgnoreCase(colName)).findFirst().orElse(null);
                DataType colType = colSchema.dataType();
                if (colMetadata == null || colType == null) {
                    throw new HoodieException(String.format("Cannot collect min/max statistics for column (%s)", colSchema));
                }
                Pair<Object, Object> minMaxValue = ColumnStatsIndexHelper.fetchMinMaxValues(colType, (HoodieColumnRangeMetadata<Comparable>)colMetadata);
                indexRow.add((String)minMaxValue.getLeft());
                indexRow.add((String)minMaxValue.getRight());
                indexRow.add((String)colMetadata.getNullCount());
            });
            return Row$.MODULE$.apply(JavaScalaConverters.convertJavaListToScalaSeq(indexRow));
        }).filter(Objects::nonNull);
        StructType indexSchema = (StructType)ColumnStatsIndexSupport$.MODULE$.composeIndexSchema((Seq)JavaScalaConverters.convertJavaListToScalaSeq(columnNames), (Seq)JavaScalaConverters.convertJavaListToScalaList(columnNames), (StructType)StructType$.MODULE$.apply(orderedColumnSchemas))._1;
        return sparkSession.createDataFrame(allMetaDataRDD, indexSchema);
    }
}

