/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.ScalaAssertionSupport;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.testutils.PreCombineTestUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.GlobalDeleteKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.hudi.testutils.KeyGeneratorTestUtilities;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t=c\u0001B\u001a5\u0001mBQA\u0012\u0001\u0005\u0002\u001dCq!\u0013\u0001C\u0002\u0013\u0005!\n\u0003\u0004R\u0001\u0001\u0006Ia\u0013\u0005\b%\u0002\u0011\r\u0011\"\u0001T\u0011\u0019q\u0006\u0001)A\u0005)\"Iq\f\u0001a\u0001\u0002\u0004%\t\u0001\u0019\u0005\nO\u0002\u0001\r\u00111A\u0005\u0002!D\u0011B\u001c\u0001A\u0002\u0003\u0005\u000b\u0015B1\t\u0013=\u0004\u0001\u0019!a\u0001\n\u0003\u0001\b\"C;\u0001\u0001\u0004\u0005\r\u0011\"\u0001w\u0011%A\b\u00011A\u0001B\u0003&\u0011\u000fC\u0005z\u0001\u0001\u0007\t\u0019!C\u0001u\"Y\u00111\u0001\u0001A\u0002\u0003\u0007I\u0011AA\u0003\u0011)\tI\u0001\u0001a\u0001\u0002\u0003\u0006Ka\u001f\u0005\n\u0003\u0017\u0001!\u0019!C\u0001\u0003\u001bA\u0001\"a\b\u0001A\u0003%\u0011q\u0002\u0005\n\u0003C\u0001!\u0019!C\u0001\u0003\u001bA\u0001\"a\t\u0001A\u0003%\u0011q\u0002\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u0003Bq!a\u001d\u0001\t\u0003\t9\u0003C\u0004\u0002~\u0001!\t!a\n\u0007\r\u0005\u0005\u0005\u0001AAB\u0011)\t9j\u0006B\u0001B\u0003%\u00111\t\u0005\u0007\r^!\t!!'\t\u0013\u0005\u0005vC1A\u0005\u0002\u0005\r\u0006\u0002CAS/\u0001\u0006I!a\u0016\t\u0013\u0005\u001dvC1A\u0005\u0002\u0005\r\u0006\u0002CAU/\u0001\u0006I!a\u0016\t\u0013\u0005-vC1A\u0005\u0002\u0005\r\u0006\u0002CAW/\u0001\u0006I!a\u0016\t\u0013\u0005=vC1A\u0005\u0002\u0005\r\u0006\u0002CAY/\u0001\u0006I!a\u0016\t\u0017\u0005Mv\u00031AA\u0002\u0013\u0005\u0011Q\u0017\u0005\f\u0003{;\u0002\u0019!a\u0001\n\u0003\ty\fC\u0006\u0002D^\u0001\r\u0011!Q!\n\u0005]\u0006bCAc/\u0001\u0007\t\u0019!C\u0001\u0003\u000fD1\"a3\u0018\u0001\u0004\u0005\r\u0011\"\u0001\u0002N\"Y\u0011\u0011[\fA\u0002\u0003\u0005\u000b\u0015BAe\u0011\u001d\t\u0019n\u0006C!\u0003+Dq!a:\u0018\t\u0003\nI\u000fC\u0004\u0002h^!\t%a<\t\u000f\t\rq\u0003\"\u0011\u0003\u0006!9!1A\f\u0005B\t%\u0001b\u0002B\b\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0005'\u0001A\u0011AA\u0014\u0011\u001d\u00119\u0002\u0001C\u0001\u0003OAqAa\u0007\u0001\t\u0003\u0011i\u0002C\u0004\u0003H\u0001!\t!a\n\t\u000f\t-\u0003\u0001\"\u0001\u0002(\t1B+Z:u\t\u0006$\u0018mU8ve\u000e,G)\u001a4bk2$8O\u0003\u00026m\u0005!\u0001.\u001e3j\u0015\t9\u0004(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002s\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0010\"\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\r\u0005s\u0017PU3g!\t\u0019E)D\u00015\u0013\t)EGA\u000bTG\u0006d\u0017-Q:tKJ$\u0018n\u001c8TkB\u0004xN\u001d;\u0002\rqJg.\u001b;?)\u0005A\u0005CA\"\u0001\u0003\u0019\u00198\r[3nCV\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002Om\u0005!\u0011M\u001e:p\u0013\t\u0001VJ\u0001\u0004TG\",W.Y\u0001\bg\u000eDW-\\1!\u0003)\u0019HO];diRK\b/Z\u000b\u0002)B\u0011Q\u000bX\u0007\u0002-*\u0011q\u000bW\u0001\u0006if\u0004Xm\u001d\u0006\u00033j\u000b1a]9m\u0015\tYf'A\u0003ta\u0006\u00148.\u0003\u0002^-\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0017M$(/^2u)f\u0004X\rI\u0001\u000bE\u0006\u001cXMU3d_J$W#A1\u0011\u0005\t,W\"A2\u000b\u0005\u0011l\u0015aB4f]\u0016\u0014\u0018nY\u0005\u0003M\u000e\u0014QbR3oKJL7MU3d_J$\u0017A\u00042bg\u0016\u0014VmY8sI~#S-\u001d\u000b\u0003S2\u0004\"!\u00106\n\u0005-t$\u0001B+oSRDq!\\\u0004\u0002\u0002\u0003\u0007\u0011-A\u0002yIE\n1BY1tKJ+7m\u001c:eA\u00059!-Y:f%><X#A9\u0011\u0005I\u001cX\"\u0001-\n\u0005QD&a\u0001*po\u0006Y!-Y:f%><x\fJ3r)\tIw\u000fC\u0004n\u0015\u0005\u0005\t\u0019A9\u0002\u0011\t\f7/\u001a*po\u0002\n1\"\u001b8uKJt\u0017\r\u001c*poV\t1\u0010\u0005\u0002}\u007f6\tQP\u0003\u0002\u007f1\u0006A1-\u0019;bYf\u001cH/C\u0002\u0002\u0002u\u00141\"\u00138uKJt\u0017\r\u001c*po\u0006y\u0011N\u001c;fe:\fGNU8x?\u0012*\u0017\u000fF\u0002j\u0003\u000fAq!\\\u0007\u0002\u0002\u0003\u000710\u0001\u0007j]R,'O\\1m%><\b%\u0001\buKN$8\u000b\u001e:vGRt\u0015-\\3\u0016\u0005\u0005=\u0001\u0003BA\t\u00037i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u001a\u0005!!.\u0019<b\u0013\u0011\ti\"a\u0005\u0003\rM#(/\u001b8h\u0003=!Xm\u001d;TiJ,8\r\u001e(b[\u0016\u0004\u0013!\u0004;fgRt\u0015-\\3ta\u0006\u001cW-\u0001\buKN$h*Y7fgB\f7-\u001a\u0011\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0001jQ\r\u0019\u00121\u0006\t\u0005\u0003[\tY$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\r\t\u0007/\u001b\u0006\u0005\u0003k\t9$A\u0004kkBLG/\u001a:\u000b\u0007\u0005e\u0002(A\u0003kk:LG/\u0003\u0003\u0002>\u0005=\"A\u0003\"fM>\u0014X-R1dQ\u0006aq-\u001a;LKf\u001cuN\u001c4jORA\u00111IA*\u0003W\ny\u0007\u0005\u0003\u0002F\u0005=SBAA$\u0015\u0011\tI%a\u0013\u0002\r\r|gNZ5h\u0015\r\ti\u0005N\u0001\u0007G>lWn\u001c8\n\t\u0005E\u0013q\t\u0002\u0010)f\u0004X\r\u001a)s_B,'\u000f^5fg\"9\u0011Q\u000b\u000bA\u0002\u0005]\u0013A\u0005:fG>\u0014HmS3z\r&,G\u000e\u001a(b[\u0016\u0004B!!\u0017\u0002h9!\u00111LA2!\r\tiFP\u0007\u0003\u0003?R1!!\u0019;\u0003\u0019a$o\\8u}%\u0019\u0011Q\r \u0002\rA\u0013X\rZ3g\u0013\u0011\ti\"!\u001b\u000b\u0007\u0005\u0015d\bC\u0004\u0002nQ\u0001\r!a\u0016\u0002%A\f'\u000f^5uS>t\u0007+\u0019;i\r&,G\u000e\u001a\u0005\b\u0003c\"\u0002\u0019AA,\u0003UA\u0017N^3TifdW\rU1si&$\u0018n\u001c8j]\u001e\fa\u0003^3tiNKW\u000e\u001d7f\u0017\u0016Lx)\u001a8fe\u0006$xN\u001d\u0015\u0004+\u0005]\u0004\u0003BA\u0017\u0003sJA!a\u001f\u00020\t!A+Z:u\u0003!\"Xm\u001d;Vg\u0016\u0014H)\u001a4j]\u0016$7*Z=HK:,'/\u0019;pe^{'o[:XSRD'k\\<tQ\r1\u0012q\u000f\u0002\u0018+N,'\u000fR3gS:,GmS3z\u000f\u0016tWM]1u_J\u001cRaFAC\u0003#\u0003B!a\"\u0002\u000e6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017#\u0014AB6fs\u001e,g.\u0003\u0003\u0002\u0010\u0006%%\u0001D&fs\u001e+g.\u001a:bi>\u0014\b\u0003BAD\u0003'KA!!&\u0002\n\nQ2\u000b]1sW.+\u0017pR3oKJ\fGo\u001c:J]R,'OZ1dK\u0006)\u0001O]8qgR!\u00111TAP!\r\tijF\u0007\u0002\u0001!9\u0011qS\rA\u0002\u0005\r\u0013!\u0004:fG>\u0014HmS3z!J|\u0007/\u0006\u0002\u0002X\u0005q!/Z2pe\u0012\\U-\u001f)s_B\u0004\u0013!\u00059beRLG/[8o!\u0006$\b\u000e\u0015:pa\u0006\u0011\u0002/\u0019:uSRLwN\u001c)bi\"\u0004&o\u001c9!\u0003-\u0019FKU+D)~s\u0015)T#\u0002\u0019M#&+V\"U?:\u000bU*\u0012\u0011\u0002\u00139\u000bU*R*Q\u0003\u000e+\u0015A\u0003(B\u001b\u0016\u001b\u0006+Q\"FA\u0005Y1m\u001c8wKJ$XM\u001d$o+\t\t9\fE\u0003>\u0003s\u000b\u0018-C\u0002\u0002<z\u0012\u0011BR;oGRLwN\\\u0019\u0002\u001f\r|gN^3si\u0016\u0014hI\\0%KF$2![Aa\u0011!i7%!AA\u0002\u0005]\u0016\u0001D2p]Z,'\u000f^3s\r:\u0004\u0013aE5oi\u0016\u0014h.\u00197D_:4XM\u001d;fe\u001asWCAAe!\u0015i\u0014\u0011X>b\u0003]Ig\u000e^3s]\u0006d7i\u001c8wKJ$XM\u001d$o?\u0012*\u0017\u000fF\u0002j\u0003\u001fD\u0001\"\u001c\u0014\u0002\u0002\u0003\u0007\u0011\u0011Z\u0001\u0015S:$XM\u001d8bY\u000e{gN^3si\u0016\u0014hI\u001c\u0011\u0002\r\u001d,GoS3z)\u0011\t9.a9\u0011\t\u0005e\u0017q\\\u0007\u0003\u00037TA!!8\u0002L\u0005)Qn\u001c3fY&!\u0011\u0011]An\u0005%Aun\u001c3jK.+\u0017\u0010\u0003\u0004\u0002f\"\u0002\r!Y\u0001\u0007e\u0016\u001cwN\u001d3\u0002\u0019\u001d,GOU3d_J$7*Z=\u0015\t\u0005]\u00131\u001e\u0005\u0007\u0003[L\u0003\u0019A9\u0002\u0007I|w\u000f\u0006\u0004\u0002r\u0006}(\u0011\u0001\t\u0005\u0003g\fY0\u0004\u0002\u0002v*\u0019q+a>\u000b\u0007\u0005e(,\u0001\u0004v]N\fg-Z\u0005\u0005\u0003{\f)P\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001eDa!!<+\u0001\u0004Y\b\"B%+\u0001\u0004!\u0016\u0001E4fiB\u000b'\u000f^5uS>t\u0007+\u0019;i)\u0011\t9Fa\u0002\t\r\u000558\u00061\u0001r)\u0019\t\tPa\u0003\u0003\u000e!)\u0011\u0010\fa\u0001w\")!\u000b\fa\u0001)\u00069B/Z:u\u0007>l\u0007\u000f\\3y\u0017\u0016Lx)\u001a8fe\u0006$xN\u001d\u0015\u0004[\u0005]\u0014\u0001\b;fgR<En\u001c2bY\u0012+G.\u001a;f\u0017\u0016Lx)\u001a8fe\u0006$xN\u001d\u0015\u0004]\u0005]\u0014A\t;fgR|e/\u001a:xe&$XmV5uQ2\u000bG/Z:u\u0003Z\u0014x\u000eU1zY>\fG\rK\u00020\u0003o\n!\b^3ti>3XM]<sSR,w+\u001b;i\u0019\u0006$Xm\u001d;BmJ|\u0007+Y=m_\u0006$7i\\7cS:,\u0017I\u001c3HKR,\u0006\u000fZ1uKZ\u000bG.^3\u0015\u0007%\u0014y\u0002C\u0004\u0003\"A\u0002\r!a\u0016\u0002\u0007-,\u0017\u0010K\u00041\u0005K\u0011)Da\u000e\u0011\t\t\u001d\"\u0011G\u0007\u0003\u0005SQAAa\u000b\u0003.\u0005A\u0001O]8wS\u0012,'O\u0003\u0003\u00030\u0005M\u0012A\u00029be\u0006l7/\u0003\u0003\u00034\t%\"\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,GF\u0001B\u001dC\t\u0011Y$\u0001%pe\u001et\u0013\r]1dQ\u0016t\u0003.\u001e3j]\r|W.\\8o]Q,7\u000f^;uS2\u001ch\u0006\u0015:f\u0007>l'-\u001b8f)\u0016\u001cH/\u0016;jYN\u001c3m\u001c8gS\u001e,(/\u001a)sK\u000e{WNY5oK\"\u001a\u0001Ga\u0010\u0011\t\t\u0005#1I\u0007\u0003\u0005[IAA!\u0012\u0003.\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002mQ,7\u000f\u001e#fM\u0006,H\u000e\u001e%p_\u0012LWMU3d_J$\u0007+Y=m_\u0006$7i\\7cS:,\u0017I\u001c3HKR,\u0006\u000fZ1uKZ\u000bG.^3)\u0007E\n9(\u0001\u000fuKN$X)\u001c9us\"{w\u000eZ5f%\u0016\u001cwN\u001d3QCfdw.\u00193)\u0007I\n9\b")
public class TestDataSourceDefaults
implements ScalaAssertionSupport {
    private final Schema schema;
    private final StructType structType;
    private GenericRecord baseRecord;
    private Row baseRow;
    private InternalRow internalRow;
    private final String testStructName;
    private final String testNamespace;

    @Override
    public <T extends Throwable, R> T assertThrows(Class<T> expectedExceptionClass, Function0<R> f) {
        return (T)ScalaAssertionSupport.assertThrows$(this, expectedExceptionClass, f);
    }

    public Schema schema() {
        return this.schema;
    }

    public StructType structType() {
        return this.structType;
    }

    public GenericRecord baseRecord() {
        return this.baseRecord;
    }

    public void baseRecord_$eq(GenericRecord x$1) {
        this.baseRecord = x$1;
    }

    public Row baseRow() {
        return this.baseRow;
    }

    public void baseRow_$eq(Row x$1) {
        this.baseRow = x$1;
    }

    public InternalRow internalRow() {
        return this.internalRow;
    }

    public void internalRow_$eq(InternalRow x$1) {
        this.internalRow = x$1;
    }

    public String testStructName() {
        return this.testStructName;
    }

    public String testNamespace() {
        return this.testNamespace;
    }

    @BeforeEach
    public void initialize() {
        this.baseRecord_$eq(SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)1, (String)"001", (String)"f1"));
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
    }

    private TypedProperties getKeyConfig(String recordKeyFieldName, String partitionPathField, String hiveStylePartitioning) {
        TypedProperties props = new TypedProperties();
        props.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), recordKeyFieldName);
        props.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), partitionPathField);
        props.setProperty(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), hiveStylePartitioning);
        return props;
    }

    @Test
    public void testSimpleKeyGenerator() {
        SimpleKeyGenerator keyGen = new SimpleKeyGenerator(this.getKeyConfig("field1", "name", "false"));
        HoodieKey expectedKey = new HoodieKey("field1", "name1");
        Assertions.assertEquals((Object)expectedKey, (Object)keyGen.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey.getRecordKey(), (Object)keyGen.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey.getPartitionPath(), (Object)keyGen.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getRecordKey()), (Object)keyGen.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getPartitionPath()), (Object)keyGen.getPartitionPath(this.internalRow(), this.structType()));
        TypedProperties props = new TypedProperties();
        props.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1");
        this.assertThrows(IllegalArgumentException.class, (Function0 & Serializable & scala.Serializable)() -> new SimpleKeyGenerator(props));
        TypedProperties props2 = new TypedProperties();
        props2.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionField");
        this.assertThrows(IndexOutOfBoundsException.class, (Function0 & Serializable & scala.Serializable)() -> new SimpleKeyGenerator(props2).getRecordKey(this.baseRecord()));
        SimpleKeyGenerator keyGen2 = new SimpleKeyGenerator(this.getKeyConfig("testNestedRecord.userId", "testNestedRecord.isAdmin", "false"));
        Assertions.assertEquals((Object)new HoodieKey("UserId1@001", "false"), (Object)keyGen2.getKey(this.baseRecord()));
        SimpleKeyGenerator keyGen3 = new SimpleKeyGenerator(this.getKeyConfig("testNestedRecord.NotThere", "testNestedRecord.isAdmin", "false"));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen3.getKey(this.baseRecord()));
        SimpleKeyGenerator keyGen4 = new SimpleKeyGenerator(this.getKeyConfig("testNestedRecord.userId", "testNestedRecord.notThere", "false"));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen4.getPartitionPath(this.baseRow()));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen4.getPartitionPath(this.internalRow(), this.structType()));
        SimpleKeyGenerator keyGen5 = new SimpleKeyGenerator(this.getKeyConfig("field1", "name", "true"));
        Assertions.assertEquals((Object)"name=name1", (Object)keyGen5.getKey(this.baseRecord()).getPartitionPath());
        Assertions.assertEquals((Object)"name=name1", (Object)keyGen5.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)"name=name1"), (Object)keyGen5.getPartitionPath(this.internalRow(), this.structType()));
        SimpleKeyGenerator keyGen6 = new SimpleKeyGenerator(this.getKeyConfig("field1", "name", "false"));
        this.baseRecord().put("name", (Object)"");
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        Assertions.assertEquals((Object)"__HIVE_DEFAULT_PARTITION__", (Object)keyGen6.getKey(this.baseRecord()).getPartitionPath());
        Assertions.assertEquals((Object)"__HIVE_DEFAULT_PARTITION__", (Object)keyGen6.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)"__HIVE_DEFAULT_PARTITION__"), (Object)keyGen6.getPartitionPath(this.internalRow(), this.structType()));
        this.baseRecord().put("name", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        Assertions.assertEquals((Object)"__HIVE_DEFAULT_PARTITION__", (Object)keyGen6.getKey(this.baseRecord()).getPartitionPath());
        Assertions.assertEquals((Object)"__HIVE_DEFAULT_PARTITION__", (Object)keyGen6.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)"__HIVE_DEFAULT_PARTITION__"), (Object)keyGen6.getPartitionPath(this.internalRow(), this.structType()));
        TypedProperties props3 = new TypedProperties();
        props3.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1");
        props3.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "name");
        SimpleKeyGenerator keyGen7 = new SimpleKeyGenerator(props3);
        this.baseRecord().put("field1", (Object)"");
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen7.getKey(this.baseRecord()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen7.getRecordKey(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen7.getRecordKey(this.internalRow(), this.structType()));
        this.baseRecord().put("field1", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen7.getKey(this.baseRecord()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen7.getRecordKey(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen7.getRecordKey(this.internalRow(), this.structType()));
    }

    @Test
    public void testUserDefinedKeyGeneratorWorksWithRows() {
        UserDefinedKeyGenerator keyGen = new UserDefinedKeyGenerator(this.getKeyConfig("field1", "name", "false"));
        Assertions.assertEquals((Object)"field1", (Object)keyGen.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)"name1", (Object)keyGen.getPartitionPath(this.baseRow()));
    }

    @Test
    public void testComplexKeyGenerator() {
        ComplexKeyGenerator keyGen = new ComplexKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        HoodieKey expectedKey = new HoodieKey("field1:field1,name:name1", "field1/name1");
        Assertions.assertEquals((Object)expectedKey, (Object)keyGen.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey.getRecordKey(), (Object)keyGen.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey.getPartitionPath(), (Object)keyGen.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getRecordKey()), (Object)keyGen.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getPartitionPath()), (Object)keyGen.getPartitionPath(this.internalRow(), this.structType()));
        this.assertThrows(IllegalArgumentException.class, (Function0 & Serializable & scala.Serializable)() -> {
            TypedProperties props = new TypedProperties();
            props.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1");
            ComplexKeyGenerator keyGen = new ComplexKeyGenerator(props);
            keyGen.getKey(this.baseRecord());
            keyGen.getRecordKey(this.baseRow());
            return keyGen.getRecordKey(this.internalRow(), this.structType());
        });
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> {
            TypedProperties props = new TypedProperties();
            props.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionField");
            ComplexKeyGenerator keyGen = new ComplexKeyGenerator(props);
            keyGen.getKey(this.baseRecord());
            keyGen.getPartitionPath(this.baseRow());
            return keyGen.getPartitionPath(this.internalRow(), this.structType());
        });
        ComplexKeyGenerator keyGen2 = new ComplexKeyGenerator(this.getKeyConfig("testNestedRecord.userId,testNestedRecord.isAdmin", "testNestedRecord.userId,testNestedRecord.isAdmin", "false"));
        HoodieKey expectedKey2 = new HoodieKey("testNestedRecord.userId:UserId1@001,testNestedRecord.isAdmin:false", "UserId1@001/false");
        Assertions.assertEquals((Object)expectedKey2, (Object)keyGen2.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey2.getRecordKey(), (Object)keyGen2.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey2.getPartitionPath(), (Object)keyGen2.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey2.getRecordKey()), (Object)keyGen2.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey2.getPartitionPath()), (Object)keyGen2.getPartitionPath(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen3 = new ComplexKeyGenerator(this.getKeyConfig("testNestedRecord.NotThere", "testNestedRecord.isAdmin", "false"));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen3.getKey(this.baseRecord()));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen3.getRecordKey(this.baseRow()));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen3.getRecordKey(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen4 = new ComplexKeyGenerator(this.getKeyConfig("testNestedRecord.userId", "testNestedRecord.notThere", "false"));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen4.getPartitionPath(this.baseRow()));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen4.getPartitionPath(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen5 = new ComplexKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "true"));
        HoodieKey expectedKey3 = new HoodieKey("field1:field1,name:name1", "field1=field1/name=name1");
        Assertions.assertEquals((Object)expectedKey3, (Object)keyGen5.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey3.getRecordKey(), (Object)keyGen5.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey3.getPartitionPath(), (Object)keyGen5.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey3.getRecordKey()), (Object)keyGen5.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey3.getPartitionPath()), (Object)keyGen5.getPartitionPath(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen6 = new ComplexKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        this.baseRecord().put("name", (Object)"");
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        HoodieKey expectedKey4 = new HoodieKey("field1:field1,name:__empty__", "field1/__HIVE_DEFAULT_PARTITION__");
        Assertions.assertEquals((Object)expectedKey4, (Object)keyGen6.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey4.getRecordKey(), (Object)keyGen6.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey4.getPartitionPath(), (Object)keyGen6.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey4.getRecordKey()), (Object)keyGen6.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey4.getPartitionPath()), (Object)keyGen6.getPartitionPath(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen7 = new ComplexKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        this.baseRecord().put("name", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        HoodieKey expectedKey5 = new HoodieKey("field1:field1,name:__null__", "field1/__HIVE_DEFAULT_PARTITION__");
        Assertions.assertEquals((Object)expectedKey5, (Object)keyGen7.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey5.getRecordKey(), (Object)keyGen7.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey5.getPartitionPath(), (Object)keyGen7.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey5.getRecordKey()), (Object)keyGen7.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey5.getPartitionPath()), (Object)keyGen7.getPartitionPath(this.internalRow(), this.structType()));
        TypedProperties props = new TypedProperties();
        props.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1,name");
        props.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "field1,name");
        ComplexKeyGenerator keyGen8 = new ComplexKeyGenerator(props);
        this.baseRecord().put("name", (Object)"");
        this.baseRecord().put("field1", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen8.getKey(this.baseRecord()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen8.getRecordKey(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen8.getRecordKey(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen9 = new ComplexKeyGenerator(this.getKeyConfig("field1, name", "field1, name", "false"));
        this.baseRecord().put("name", (Object)"name1");
        this.baseRecord().put("field1", (Object)"field1");
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        HoodieKey expectedKey6 = new HoodieKey("field1:field1,name:name1", "field1/name1");
        Assertions.assertEquals((Object)expectedKey6, (Object)keyGen9.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey6.getRecordKey(), (Object)keyGen9.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey6.getPartitionPath(), (Object)keyGen9.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey6.getRecordKey()), (Object)keyGen9.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey6.getPartitionPath()), (Object)keyGen9.getPartitionPath(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen10 = new ComplexKeyGenerator(this.getKeyConfig("field1,", "field1,", "false"));
        HoodieKey expectedKey7 = new HoodieKey("field1", "field1");
        Assertions.assertEquals((Object)expectedKey7, (Object)keyGen10.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey7.getRecordKey(), (Object)keyGen10.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey7.getPartitionPath(), (Object)keyGen10.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey7.getRecordKey()), (Object)keyGen10.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey7.getPartitionPath()), (Object)keyGen10.getPartitionPath(this.internalRow(), this.structType()));
    }

    @Test
    public void testGlobalDeleteKeyGenerator() {
        GlobalDeleteKeyGenerator keyGen = new GlobalDeleteKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        HoodieKey expectedKey = new HoodieKey("field1:field1,name:name1", "");
        Assertions.assertEquals((Object)expectedKey, (Object)keyGen.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey.getRecordKey(), (Object)keyGen.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey.getPartitionPath(), (Object)keyGen.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getRecordKey()), (Object)keyGen.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getPartitionPath()), (Object)keyGen.getPartitionPath(this.internalRow(), this.structType()));
        TypedProperties props = new TypedProperties();
        props.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1,name");
        GlobalDeleteKeyGenerator keyGen2 = new GlobalDeleteKeyGenerator(props);
        HoodieKey expectedKey2 = new HoodieKey("field1:field1,name:name1", "");
        Assertions.assertEquals((Object)expectedKey2, (Object)keyGen2.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey2.getRecordKey(), (Object)keyGen2.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey2.getPartitionPath(), (Object)keyGen2.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey2.getRecordKey()), (Object)keyGen2.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey2.getPartitionPath()), (Object)keyGen2.getPartitionPath(this.internalRow(), this.structType()));
        this.baseRecord().put("name", (Object)"");
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        GlobalDeleteKeyGenerator keyGen3 = new GlobalDeleteKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        HoodieKey expectedKey3 = new HoodieKey("field1:field1,name:__empty__", "");
        Assertions.assertEquals((Object)expectedKey3.getRecordKey(), (Object)keyGen3.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey3.getPartitionPath(), (Object)keyGen3.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey3.getRecordKey()), (Object)keyGen3.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey3.getPartitionPath()), (Object)keyGen3.getPartitionPath(this.internalRow(), this.structType()));
        this.baseRecord().put("name", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        GlobalDeleteKeyGenerator keyGen4 = new GlobalDeleteKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        HoodieKey expectedKey4 = new HoodieKey("field1:field1,name:__null__", "");
        Assertions.assertEquals((Object)expectedKey4.getRecordKey(), (Object)keyGen4.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey4.getPartitionPath(), (Object)keyGen4.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey4.getRecordKey()), (Object)keyGen4.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey4.getPartitionPath()), (Object)keyGen4.getPartitionPath(this.internalRow(), this.structType()));
        TypedProperties props2 = new TypedProperties();
        props2.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionField");
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> new GlobalDeleteKeyGenerator(props2).getRecordKey(this.baseRecord()));
        GlobalDeleteKeyGenerator keyGen5 = new GlobalDeleteKeyGenerator(this.getKeyConfig("testNestedRecord.NotThere", "testNestedRecord.isAdmin", "false"));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen5.getKey(this.baseRecord()));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen5.getRecordKey(this.baseRow()));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen5.getRecordKey(this.internalRow(), this.structType()));
        TypedProperties props3 = new TypedProperties();
        props3.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1,name");
        GlobalDeleteKeyGenerator keyGen6 = new GlobalDeleteKeyGenerator(props3);
        this.baseRecord().put("name", (Object)"");
        this.baseRecord().put("field1", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen6.getKey(this.baseRecord()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen6.getRecordKey(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen6.getRecordKey(this.internalRow(), this.structType()));
    }

    @Test
    public void testOverwriteWithLatestAvroPayload() {
        OverwriteWithLatestAvroPayload overWritePayload1 = new OverwriteWithLatestAvroPayload(this.baseRecord(), (Comparable)Predef$.MODULE$.int2Integer(1));
        GenericRecord laterRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)2, (String)"001", (String)"f1");
        OverwriteWithLatestAvroPayload overWritePayload2 = new OverwriteWithLatestAvroPayload(laterRecord, (Comparable)Predef$.MODULE$.int2Integer(2));
        OverwriteWithLatestAvroPayload combinedPayload12 = overWritePayload1.preCombine(overWritePayload2);
        GenericRecord combinedGR12 = (GenericRecord)combinedPayload12.getInsertValue(this.schema()).get();
        Assertions.assertEquals((Object)"field1", (Object)combinedGR12.get("field1").toString());
        OverwriteWithLatestAvroPayload combinedPayload21 = overWritePayload2.preCombine(overWritePayload1);
        GenericRecord combinedGR21 = (GenericRecord)combinedPayload21.getInsertValue(this.schema()).get();
        Assertions.assertEquals((Object)"field2", (Object)combinedGR21.get("field1").toString());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.hudi.common.testutils.PreCombineTestUtils#configurePreCombine"})
    public void testOverwriteWithLatestAvroPayloadCombineAndGetUpdateValue(String key) {
        TypedProperties props = new TypedProperties();
        PreCombineTestUtils.setPreCombineConfig((Properties)props, (String)key, (String)"favoriteIntNumber");
        Object baseOrderingVal = this.baseRecord().get("favoriteIntNumber");
        Schema fieldSchema = this.baseRecord().getSchema().getField("favoriteIntNumber").schema();
        OverwriteWithLatestAvroPayload basePayload = new OverwriteWithLatestAvroPayload(this.baseRecord(), (Comparable)HoodieAvroUtils.convertValueForSpecificDataTypes((Schema)fieldSchema, (Object)baseOrderingVal, (boolean)false));
        GenericRecord laterRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)2, (String)"001", (String)"f1");
        Object laterOrderingVal = laterRecord.get("favoriteIntNumber");
        OverwriteWithLatestAvroPayload newerPayload = new OverwriteWithLatestAvroPayload(laterRecord, (Comparable)HoodieAvroUtils.convertValueForSpecificDataTypes((Schema)fieldSchema, (Object)laterOrderingVal, (boolean)false));
        OverwriteWithLatestAvroPayload preCombinedPayload = basePayload.preCombine(newerPayload);
        GenericRecord precombinedGR = (GenericRecord)preCombinedPayload.getInsertValue(this.schema()).get();
        Assertions.assertEquals((Object)"field1", (Object)precombinedGR.get("field1").toString());
    }

    @Test
    public void testDefaultHoodieRecordPayloadCombineAndGetUpdateValue() {
        Schema fieldSchema = this.baseRecord().getSchema().getField("favoriteIntNumber").schema();
        TypedProperties props = HoodiePayloadConfig.newBuilder().withPayloadOrderingField("favoriteIntNumber").build().getProps();
        GenericRecord laterRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)2, (String)"001", (String)"f1");
        Object laterOrderingVal = laterRecord.get("favoriteIntNumber");
        GenericRecord earlierRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)1, (String)"000", (String)"f1");
        Object earlierOrderingVal = earlierRecord.get("favoriteIntNumber");
        DefaultHoodieRecordPayload laterPayload = new DefaultHoodieRecordPayload(laterRecord, (Comparable)HoodieAvroUtils.convertValueForSpecificDataTypes((Schema)fieldSchema, (Object)laterOrderingVal, (boolean)false));
        DefaultHoodieRecordPayload earlierPayload = new DefaultHoodieRecordPayload(earlierRecord, (Comparable)HoodieAvroUtils.convertValueForSpecificDataTypes((Schema)fieldSchema, (Object)earlierOrderingVal, (boolean)false));
        OverwriteWithLatestAvroPayload preCombinedPayload = laterPayload.preCombine((OverwriteWithLatestAvroPayload)earlierPayload);
        GenericRecord precombinedGR = (GenericRecord)preCombinedPayload.getInsertValue(this.schema()).get();
        Assertions.assertEquals((Object)"field2", (Object)precombinedGR.get("field1").toString());
        Assertions.assertEquals((Object)laterOrderingVal, (Object)precombinedGR.get("favoriteIntNumber"));
        Option earlierWithLater = earlierPayload.combineAndGetUpdateValue((IndexedRecord)laterRecord, this.schema(), (Properties)props);
        GenericRecord earlierwithLaterGR = (GenericRecord)earlierWithLater.get();
        Assertions.assertEquals((Object)"field2", (Object)earlierwithLaterGR.get("field1").toString());
        Assertions.assertEquals((Object)laterOrderingVal, (Object)earlierwithLaterGR.get("favoriteIntNumber"));
        Option laterWithEarlier = laterPayload.combineAndGetUpdateValue((IndexedRecord)earlierRecord, this.schema(), (Properties)props);
        GenericRecord laterWithEarlierGR = (GenericRecord)laterWithEarlier.get();
        Assertions.assertEquals((Object)"field2", (Object)laterWithEarlierGR.get("field1").toString());
        Assertions.assertEquals((Object)laterOrderingVal, (Object)laterWithEarlierGR.get("favoriteIntNumber"));
    }

    @Test
    public void testEmptyHoodieRecordPayload() {
        EmptyHoodieRecordPayload emptyPayload1 = new EmptyHoodieRecordPayload(this.baseRecord(), (Comparable)Predef$.MODULE$.int2Integer(1));
        GenericRecord laterRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)2, (String)"001", (String)"f1");
        EmptyHoodieRecordPayload emptyPayload2 = new EmptyHoodieRecordPayload(laterRecord, (Comparable)Predef$.MODULE$.int2Integer(2));
        EmptyHoodieRecordPayload combinedPayload12 = emptyPayload1.preCombine(emptyPayload2);
        Option combined12 = combinedPayload12.getInsertValue(this.schema());
        Assertions.assertEquals((Object)Option.empty(), (Object)combined12);
    }

    public TestDataSourceDefaults() {
        ScalaAssertionSupport.$init$(this);
        this.schema = SchemaTestUtil.getComplexEvolvedSchema();
        this.structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(this.schema());
        this.testStructName = "testStructName";
        this.testNamespace = "testNamespace";
    }

    public class UserDefinedKeyGenerator
    extends KeyGenerator
    implements SparkKeyGeneratorInterface {
        private final String recordKeyProp;
        private final String partitionPathProp;
        private final String STRUCT_NAME;
        private final String NAMESPACE;
        private Function1<Row, GenericRecord> converterFn;
        private Function1<InternalRow, GenericRecord> internalConverterFn;

        public String recordKeyProp() {
            return this.recordKeyProp;
        }

        public String partitionPathProp() {
            return this.partitionPathProp;
        }

        public String STRUCT_NAME() {
            return this.STRUCT_NAME;
        }

        public String NAMESPACE() {
            return this.NAMESPACE;
        }

        public Function1<Row, GenericRecord> converterFn() {
            return this.converterFn;
        }

        public void converterFn_$eq(Function1<Row, GenericRecord> x$1) {
            this.converterFn = x$1;
        }

        public Function1<InternalRow, GenericRecord> internalConverterFn() {
            return this.internalConverterFn;
        }

        public void internalConverterFn_$eq(Function1<InternalRow, GenericRecord> x$1) {
            this.internalConverterFn = x$1;
        }

        public HoodieKey getKey(GenericRecord record) {
            return new HoodieKey(HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)this.recordKeyProp(), (boolean)true, (boolean)false), HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)this.partitionPathProp(), (boolean)true, (boolean)false));
        }

        public String getRecordKey(Row row) {
            if (this.converterFn() == null) {
                this.converterFn_$eq((Function1<Row, GenericRecord>)AvroConversionUtils$.MODULE$.createConverterToAvro(row.schema(), this.STRUCT_NAME(), this.NAMESPACE()));
            }
            GenericRecord genericRecord = (GenericRecord)this.converterFn().apply((Object)row);
            return this.getKey(genericRecord).getRecordKey();
        }

        public UTF8String getRecordKey(InternalRow row, StructType schema) {
            return null;
        }

        public String getPartitionPath(Row row) {
            if (this.converterFn() == null) {
                this.converterFn_$eq((Function1<Row, GenericRecord>)AvroConversionUtils$.MODULE$.createConverterToAvro(row.schema(), this.STRUCT_NAME(), this.NAMESPACE()));
            }
            GenericRecord genericRecord = (GenericRecord)this.converterFn().apply((Object)row);
            return this.getKey(genericRecord).getPartitionPath();
        }

        public UTF8String getPartitionPath(InternalRow internalRow, StructType structType) {
            return null;
        }

        public /* synthetic */ TestDataSourceDefaults org$apache$hudi$TestDataSourceDefaults$UserDefinedKeyGenerator$$$outer() {
            return TestDataSourceDefaults.this;
        }

        public UserDefinedKeyGenerator(TypedProperties props) {
            if (TestDataSourceDefaults.this == null) {
                throw null;
            }
            super(props);
            this.recordKeyProp = props.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key());
            this.partitionPathProp = props.getString(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key());
            this.STRUCT_NAME = "hoodieRowTopLevelField";
            this.NAMESPACE = "hoodieRow";
        }
    }
}

