/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.DefaultSparkRecordMerger;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieEmptyRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.collection.Seq;

class TestDefaultSparkRecordMerger {
    static final String RECORD_KEY_FIELD_NAME = "record_key";
    static final String PARTITION_PATH_FIELD_NAME = "partition_path";
    static final String INT_COLUMN_NAME = "int_column";
    static final String STRING_COLUMN_NAME = "string_column";
    static final String ANY_KEY = "any_key";
    static final String ANY_PARTITION = "any_partition";
    static final String ANY_NAME = "any_name";
    static final String ANY_NAMESPACE = "anh_namespace";
    public static final StructType SPARK_SCHEMA = new StructType(new StructField[]{new StructField(HoodieRecord.COMMIT_TIME_METADATA_FIELD, DataTypes.StringType, false, Metadata.empty()), new StructField(HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, DataTypes.StringType, false, Metadata.empty()), new StructField(HoodieRecord.RECORD_KEY_METADATA_FIELD, DataTypes.StringType, false, Metadata.empty()), new StructField(HoodieRecord.PARTITION_PATH_METADATA_FIELD, DataTypes.StringType, false, Metadata.empty()), new StructField(HoodieRecord.FILENAME_METADATA_FIELD, DataTypes.StringType, false, Metadata.empty()), new StructField("record_key", DataTypes.StringType, false, Metadata.empty()), new StructField("partition_path", DataTypes.StringType, false, Metadata.empty()), new StructField("int_column", DataTypes.IntegerType, false, Metadata.empty()), new StructField("string_column", DataTypes.StringType, false, Metadata.empty())});

    TestDefaultSparkRecordMerger() {
    }

    @Test
    void testMergerWithAvroRecord() {
        try (HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator(0L);){
            List records = dataGenerator.generateInserts("001", Integer.valueOf(2));
            DefaultSparkRecordMerger merger = new DefaultSparkRecordMerger();
            TypedProperties props = new TypedProperties();
            Schema recordSchema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
            Assertions.assertThrows(IllegalArgumentException.class, () -> merger.merge((HoodieRecord)records.get(0), recordSchema, (HoodieRecord)records.get(1), recordSchema, props));
        }
    }

    @Test
    void testMergerWithNewRecordAccepted() throws IOException {
        HoodieKey key = new HoodieKey(ANY_KEY, ANY_PARTITION);
        Row oldValue = TestDefaultSparkRecordMerger.getSpecificValue(key, "001", 1L, "file1", 1, "1");
        Row newValue = TestDefaultSparkRecordMerger.getSpecificValue(key, "002", 2L, "file2", 2, "2");
        HoodieSparkRecord oldRecord = new HoodieSparkRecord(InternalRow.apply((Seq)oldValue.toSeq()), SPARK_SCHEMA);
        HoodieSparkRecord newRecord = new HoodieSparkRecord(InternalRow.apply((Seq)newValue.toSeq()), SPARK_SCHEMA);
        DefaultSparkRecordMerger merger = new DefaultSparkRecordMerger();
        TypedProperties props = new TypedProperties();
        props.setProperty(HoodieTableConfig.PRECOMBINE_FIELD.key(), INT_COLUMN_NAME);
        Schema avroSchema = AvroConversionUtils.convertStructTypeToAvroSchema((DataType)SPARK_SCHEMA, (String)ANY_NAME, (String)ANY_NAMESPACE);
        Option merged = merger.merge((HoodieRecord)oldRecord, avroSchema, (HoodieRecord)newRecord, avroSchema, props);
        Assertions.assertEquals((Object)InternalRow.apply((Seq)newValue.toSeq()), (Object)((HoodieRecord)((Pair)merged.get()).getLeft()).getData());
    }

    @Test
    void testMergerWithOldRecordAccepted() throws IOException {
        HoodieKey key = new HoodieKey(ANY_KEY, ANY_PARTITION);
        Row oldValue = TestDefaultSparkRecordMerger.getSpecificValue(key, "001", 1L, "file1", 3, "1");
        Row newValue = TestDefaultSparkRecordMerger.getSpecificValue(key, "002", 2L, "file2", 2, "2");
        HoodieSparkRecord oldRecord = new HoodieSparkRecord(InternalRow.apply((Seq)oldValue.toSeq()), SPARK_SCHEMA);
        HoodieSparkRecord newRecord = new HoodieSparkRecord(InternalRow.apply((Seq)newValue.toSeq()), SPARK_SCHEMA);
        DefaultSparkRecordMerger merger = new DefaultSparkRecordMerger();
        TypedProperties props = new TypedProperties();
        props.setProperty(HoodieTableConfig.PRECOMBINE_FIELD.key(), INT_COLUMN_NAME);
        Schema avroSchema = AvroConversionUtils.convertStructTypeToAvroSchema((DataType)SPARK_SCHEMA, (String)ANY_NAME, (String)ANY_NAMESPACE);
        Option r = merger.merge((HoodieRecord)oldRecord, avroSchema, (HoodieRecord)newRecord, avroSchema, props);
        Assertions.assertEquals((Object)InternalRow.apply((Seq)oldValue.toSeq()), (Object)((HoodieRecord)((Pair)r.get()).getLeft()).getData());
    }

    @Test
    void testMergerWithNewRecordAsDelete() throws IOException {
        HoodieKey key = new HoodieKey(ANY_KEY, ANY_PARTITION);
        Row oldValue = TestDefaultSparkRecordMerger.getSpecificValue(key, "001", 1L, "file1", 1, "1");
        HoodieSparkRecord oldRecord = new HoodieSparkRecord(InternalRow.apply((Seq)oldValue.toSeq()), SPARK_SCHEMA);
        HoodieEmptyRecord newRecord = new HoodieEmptyRecord(key, HoodieRecord.HoodieRecordType.SPARK);
        DefaultSparkRecordMerger merger = new DefaultSparkRecordMerger();
        TypedProperties props = new TypedProperties();
        props.setProperty(HoodieTableConfig.PRECOMBINE_FIELD.key(), INT_COLUMN_NAME);
        Schema avroSchema = AvroConversionUtils.convertStructTypeToAvroSchema((DataType)SPARK_SCHEMA, (String)ANY_NAME, (String)ANY_NAMESPACE);
        Option r = merger.merge((HoodieRecord)oldRecord, avroSchema, (HoodieRecord)newRecord, avroSchema, props);
        Assertions.assertTrue((boolean)r.isEmpty());
    }

    @Test
    void testMergerWithOldRecordAsDelete() throws IOException {
        HoodieKey key = new HoodieKey(ANY_KEY, ANY_PARTITION);
        Row newValue = TestDefaultSparkRecordMerger.getSpecificValue(key, "001", 1L, "file1", 1, "1");
        HoodieEmptyRecord oldRecord = new HoodieEmptyRecord(key, HoodieRecord.HoodieRecordType.SPARK);
        HoodieSparkRecord newRecord = new HoodieSparkRecord(InternalRow.apply((Seq)newValue.toSeq()), SPARK_SCHEMA);
        DefaultSparkRecordMerger merger = new DefaultSparkRecordMerger();
        TypedProperties props = new TypedProperties();
        props.setProperty(HoodieTableConfig.PRECOMBINE_FIELD.key(), INT_COLUMN_NAME);
        Schema avroSchema = AvroConversionUtils.convertStructTypeToAvroSchema((DataType)SPARK_SCHEMA, (String)ANY_NAME, (String)ANY_NAMESPACE);
        Option r = merger.merge((HoodieRecord)oldRecord, avroSchema, (HoodieRecord)newRecord, avroSchema, props);
        Assertions.assertEquals((Object)InternalRow.apply((Seq)newValue.toSeq()), (Object)((HoodieRecord)((Pair)r.get()).getLeft()).getData());
    }

    static Row getSpecificValue(HoodieKey key, String commitTime, long seqNo, String filePath, int intValue, String stringValue) {
        Object[] values = new Object[]{commitTime, seqNo, key.getRecordKey(), key.getPartitionPath(), filePath, key.getRecordKey(), key.getPartitionPath(), intValue, stringValue};
        return new GenericRow(values);
    }
}

