/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import org.apache.hudi.HoodieDataSourceHelper$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.sources.Filter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A3A\u0001B\u0003\u0001\u0019!)q\u0003\u0001C\u00011!)!\u0004\u0001C\u00017!)1\t\u0001C\u0001\t\nQB+Z:u\u0011>|G-[3ECR\f7k\\;sG\u0016DU\r\u001c9fe*\u0011aaB\u0001\u0005QV$\u0017N\u0003\u0002\t\u0013\u00051\u0011\r]1dQ\u0016T\u0011AC\u0001\u0004_J<7\u0001A\n\u0004\u00015\u0019\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015+5\tQ!\u0003\u0002\u0017\u000b\t\u00192\u000b]1sW\u0006#\u0017\r\u001d;feN+\b\u000f]8si\u00061A(\u001b8jiz\"\u0012!\u0007\t\u0003)\u0001\tab\u00195fG.\u001cuN\u001c3ji&|g\u000e\u0006\u0003\u001d?9r\u0004C\u0001\b\u001e\u0013\tqrB\u0001\u0003V]&$\b\"\u0002\u0011\u0003\u0001\u0004\t\u0013A\u00024jYR,'\u000fE\u0002\u000fE\u0011J!aI\b\u0003\r=\u0003H/[8o!\t)C&D\u0001'\u0015\t9\u0003&A\u0004t_V\u00148-Z:\u000b\u0005%R\u0013aA:rY*\u00111fB\u0001\u0006gB\f'o[\u0005\u0003[\u0019\u0012aAR5mi\u0016\u0014\b\"B\u0018\u0003\u0001\u0004\u0001\u0014!C8viB,HoU3u!\r\t\u0004h\u000f\b\u0003eY\u0002\"aM\b\u000e\u0003QR!!N\u0006\u0002\rq\u0012xn\u001c;?\u0013\t9t\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003si\u00121aU3u\u0015\t9t\u0002\u0005\u00022y%\u0011QH\u000f\u0002\u0007'R\u0014\u0018N\\4\t\u000b}\u0012\u0001\u0019\u0001!\u0002\u0011\u0015D\b/Z2uK\u0012\u0004\"AD!\n\u0005\t{!aA!os\u0006!C/Z:u\u000bb$(/Y2u!J,G-[2bi\u0016\u001cx+\u001b;iS:|U\u000f\u001e9viN+G\u000fF\u0001\u001dQ\t\u0019a\t\u0005\u0002H\u001d6\t\u0001J\u0003\u0002J\u0015\u0006\u0019\u0011\r]5\u000b\u0005-c\u0015a\u00026va&$XM\u001d\u0006\u0003\u001b&\tQA[;oSRL!a\u0014%\u0003\tQ+7\u000f\u001e")
public class TestHoodieDataSourceHelper
implements SparkAdapterSupport {
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    private SparkAdapter sparkAdapter$lzycompute() {
        TestHoodieDataSourceHelper testHoodieDataSourceHelper = this;
        synchronized (testHoodieDataSourceHelper) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    public void checkCondition(Option<Filter> filter, Set<String> outputSet, Object expected) {
        Option actual = HoodieDataSourceHelper$.MODULE$.extractPredicatesWithinOutputSet((Filter)filter.get(), outputSet);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testExtractPredicatesWithinOutputSet() {
        Set dataColsWithNoPartitionCols = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "extra_col"}));
        Option expr1 = this.sparkAdapter().translateFilter(functions$.MODULE$.expr("(region='reg2' and id = 1) or region='reg1'").expr(), this.sparkAdapter().translateFilter$default$2());
        this.checkCondition((Option<Filter>)expr1, (Set<String>)dataColsWithNoPartitionCols, None$.MODULE$);
        Option expr2 = this.sparkAdapter().translateFilter(functions$.MODULE$.expr("region='reg2' and id = 1").expr(), this.sparkAdapter().translateFilter$default$2());
        Option expectedExpr2 = this.sparkAdapter().translateFilter(functions$.MODULE$.expr("id = 1").expr(), this.sparkAdapter().translateFilter$default$2());
        this.checkCondition((Option<Filter>)expr2, (Set<String>)dataColsWithNoPartitionCols, expectedExpr2);
        Option expr3 = this.sparkAdapter().translateFilter(functions$.MODULE$.expr("not region='reg2' or not id = 1").expr(), this.sparkAdapter().translateFilter$default$2());
        this.checkCondition((Option<Filter>)expr3, (Set<String>)dataColsWithNoPartitionCols, None$.MODULE$);
        Option expr4 = this.sparkAdapter().translateFilter(functions$.MODULE$.expr("not region='reg2' and not id = 1").expr(), this.sparkAdapter().translateFilter$default$2());
        Option expectedExpr4 = this.sparkAdapter().translateFilter(functions$.MODULE$.expr("not(id=1)").expr(), this.sparkAdapter().translateFilter$default$2());
        this.checkCondition((Option<Filter>)expr4, (Set<String>)dataColsWithNoPartitionCols, expectedExpr4);
    }

    public TestHoodieDataSourceHelper() {
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
    }
}

