/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.hudi.BaseHoodieTableFileIndex;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.HoodieFileIndex$;
import org.apache.hudi.ScalaAssertionSupport;
import org.apache.hudi.TestHoodieFileIndex;
import org.apache.hudi.TestHoodieFileIndex$;
import org.apache.hudi.TestHoodieFileIndex$TestCase$2$;
import org.apache.hudi.client.HoodieJavaWriteClient;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.TimestampKeyGeneratorConfig;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.hudi.util.JFunction$;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.NoopCache$;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.HoodieSparkSessionExtension;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.Tuple8;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\r%b\u0001B\u0013'\u00015BQ\u0001\u000f\u0001\u0005\u0002eB\u0011b\u000f\u0001A\u0002\u0003\u0007I\u0011\u0001\u001f\t\u0013\u0011\u0003\u0001\u0019!a\u0001\n\u0003)\u0005\"\u0003(\u0001\u0001\u0004\u0005\t\u0015)\u0003>\u0011\u001dy\u0005A1A\u0005\u0002ACa!\u0019\u0001!\u0002\u0013\t\u0006b\u00022\u0001\u0001\u0004%\t\u0001\u0015\u0005\bG\u0002\u0001\r\u0011\"\u0001e\u0011\u00191\u0007\u0001)Q\u0005#\")q\r\u0001C!Q\")1\u0010\u0001C!y\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001BBA\"\u0001\u0011\u0005A\u0010C\u0004\u0002N\u0001!\t!a\u0014\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!1\u0011\u0011\u0013\u0001\u0005\u0002qDq!!&\u0001\t\u0003\t9\nC\u0004\u0002<\u0002!\t!!0\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\"9!q\u0002\u0001\u0005\u0002\tE\u0001b\u0002B\u0018\u0001\u0011\u0005!\u0011\u0007\u0005\b\u0005\u0007\u0002A\u0011\u0001B#\u0011\u001d\u0011\u0019\u0006\u0001C\u0005\u0005+BqAa\u001a\u0001\t\u0003\u0011I\u0007\u0003\u0004\u0003\n\u0002!\t\u0001 \u0005\b\u0005\u001b\u0003A\u0011\u0002BH\u0011\u001d\u0011)\u000b\u0001C\u0005\u0005OCqA!-\u0001\t\u0013\u0011\u0019\fC\u0004\u0003@\u0002!IA!1\t\u000f\t5\u0007\u0001\"\u0003\u0003P\"a!q\u001e\u0001\u0011\u0002\u0003\u0005\t\u0011\"\u0001\u0003r\"a!Q\u001f\u0001\u0011\u0002\u0003\u0005\t\u0011\"\u0001\u0003x\u001e91q\u0001\u0014\t\u0002\r%aAB\u0013'\u0011\u0003\u0019Y\u0001\u0003\u00049E\u0011\u000511\u0003\u0005\b\u0003o\u0012C\u0011AB\u000b\u0005M!Vm\u001d;I_>$\u0017.\u001a$jY\u0016Le\u000eZ3y\u0015\t9\u0003&\u0001\u0003ik\u0012L'BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001]Q\u0002\"a\f\u001a\u000e\u0003AR!!\r\u0014\u0002\u0013Q,7\u000f^;uS2\u001c\u0018BA\u001a1\u0005eAun\u001c3jKN\u0003\u0018M]6DY&,g\u000e\u001e+fgR\u0014\u0015m]3\u0011\u0005U2T\"\u0001\u0014\n\u0005]2#!F*dC2\f\u0017i]:feRLwN\\*vaB|'\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0002\"!\u000e\u0001\u0002\u000bM\u0004\u0018M]6\u0016\u0003u\u0002\"A\u0010\"\u000e\u0003}R!\u0001Q!\u0002\u0007M\fHN\u0003\u0002<Q%\u00111i\u0010\u0002\r'B\f'o[*fgNLwN\\\u0001\ngB\f'o[0%KF$\"A\u0012'\u0011\u0005\u001dSU\"\u0001%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0003\tUs\u0017\u000e\u001e\u0005\b\u001b\u000e\t\t\u00111\u0001>\u0003\rAH%M\u0001\u0007gB\f'o\u001b\u0011\u0002\u0015\r|W.\\8o\u001fB$8/F\u0001R!\u0011\u0011v+W-\u000e\u0003MS!\u0001V+\u0002\u0013%lW.\u001e;bE2,'B\u0001,I\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00031N\u00131!T1q!\tQv,D\u0001\\\u0015\taV,\u0001\u0003mC:<'\"\u00010\u0002\t)\fg/Y\u0005\u0003An\u0013aa\u0015;sS:<\u0017aC2p[6|gn\u00149ug\u0002\n\u0011\"];fef|\u0005\u000f^:\u0002\u001bE,XM]=PaR\u001cx\fJ3r)\t1U\rC\u0004N\u0011\u0005\u0005\t\u0019A)\u0002\u0015E,XM]=PaR\u001c\b%A\u0011hKR\u001c\u0006/\u0019:l'\u0016\u001c8/[8o\u000bb$XM\\:j_:\u001c\u0018J\u001c6fGR|'\u000fF\u0001j!\rQw.]\u0007\u0002W*\u0011A.\\\u0001\u0005kRLGN\u0003\u0002oM\u000511m\\7n_:L!\u0001]6\u0003\r=\u0003H/[8o!\r\u0011h\u000f_\u0007\u0002g*\u0011A/^\u0001\tMVt7\r^5p]*\u0011A.X\u0005\u0003oN\u0014\u0001bQ8ogVlWM\u001d\t\u0003}eL!A_ \u0003-M\u0003\u0018M]6TKN\u001c\u0018n\u001c8FqR,gn]5p]N\fQa]3u+B$\u0012A\u0012\u0015\u0003\u0017y\u00042a`A\u0007\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011aA1qS*!\u0011qAA\u0005\u0003\u001dQW\u000f]5uKJT1!a\u0003+\u0003\u0015QWO\\5u\u0013\u0011\ty!!\u0001\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\nuKN$\b+\u0019:uSRLwN\\*dQ\u0016l\u0017\rF\u0002G\u0003+Aq!a\u0006\r\u0001\u0004\tI\"A\bqCJ$\u0018\u000e^5p]\u0016s7m\u001c3f!\r9\u00151D\u0005\u0004\u0003;A%a\u0002\"p_2,\u0017M\u001c\u0015\b\u0019\u0005\u0005\u0012\u0011GA\u001a!\u0011\t\u0019#!\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\t\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0003W\t)!\u0001\u0004qCJ\fWn]\u0005\u0005\u0003_\t)CA\u0006WC2,XmU8ve\u000e,\u0017\u0001\u00032p_2,\u0017M\\:-\t\u0005U\u0012qG\r\u0002\u0003e\t\u0001\u0001K\u0002\r\u0003w\u0001B!!\u0010\u0002@5\u0011\u0011\u0011F\u0005\u0005\u0003\u0003\nICA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\f\u0001\u0004^3tiB\u000b'o]3QCJ$\u0018\u000e^5p]Z\u000bG.^3tQ\ri\u0011q\t\t\u0004\u007f\u0006%\u0013\u0002BA&\u0003\u0003\u0011A\u0001V3ti\u0006IC/Z:u!\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\u001a{'OQ;jYRLenS3z\u000f\u0016tWM]1u_J$2ARA)\u0011\u001d\t\u0019F\u0004a\u0001\u0003+\nAb[3z\u000f\u0016tWM]1u_J\u0004B!a\u0016\u0002f9!\u0011\u0011LA1!\r\tY\u0006S\u0007\u0003\u0003;R1!a\u0018-\u0003\u0019a$o\\8u}%\u0019\u00111\r%\u0002\rA\u0013X\rZ3g\u0013\r\u0001\u0017q\r\u0006\u0004\u0003GB\u0005f\u0002\b\u0002l\u0005E\u00141\u000f\t\u0005\u0003G\ti'\u0003\u0003\u0002p\u0005\u0015\"\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,GFAA;C\t\t9(\u0001\flKf<UM\\3sCR|'\u000fU1sC6,G/\u001a:tQ\rq\u00111H\u0001)i\u0016\u001cH\u000fU1si&$\u0018n\u001c8TG\",W.\u0019$pe\u000e+8\u000f^8n\u0017\u0016Lx)\u001a8fe\u0006$xN\u001d\u000b\u0004\r\u0006}\u0004bBA*\u001f\u0001\u0007\u0011Q\u000b\u0015\b\u001f\u0005\u0005\u00121QAC\u0003\u001d\u0019HO]5oONdC!a\"\u0002\f\u0006\u0012\u0011\u0011R\u0001*_J<g&\u00199bG\",g\u0006[;eS:ZW-_4f]:\u001aUo\u001d;p[.+\u0017pR3oKJ\fGo\u001c:\"\u0005\u00055\u0015!L8sO:\n\u0007/Y2iK:BW\u000fZ5/W\u0016Lx-\u001a8/\u0007V\u001cHo\\7BmJ|7*Z=HK:,'/\u0019;pe\"\u001aq\"a\u000f\u0002MQ,7\u000f\u001e)beRLG/[8o'\u000eDW-\\1XSRDw.\u001e;LKf<UM\\3sCR|'\u000fK\u0002\u0011\u0003\u000f\nQ\u0005^3tiB\u000b'\u000f^5uS>t\u0007K];oK^KG\u000f\u001b)beRLG/[8o\u000b:\u001cw\u000eZ3\u0015\u000b\u0019\u000bI*a'\t\u000f\u0005]\u0011\u00031\u0001\u0002\u001a!9\u0011QT\tA\u0002\u0005e\u0011A\u00037jgRd\u0015M_5ms\":\u0011#!)\u0002r\u0005\u001d\u0006\u0003BA\u0012\u0003GKA!!*\u0002&\tI1i\u001d<T_V\u00148-\u001a\u0017\t\u0003S\u000bi+!-\u00026\u0006\u0012\u00111V\u0001\niJ,X\r\f;sk\u0016\f#!a,\u0002\u0015Q\u0014X/\u001a\u0017gC2\u001cX-\t\u0002\u00024\u0006Qa-\u00197tK2\"(/^3\"\u0005\u0005]\u0016a\u00034bYN,GFZ1mg\u0016D3!EA\u001e\u0003q!Xm\u001d;J]\u0012,\u0007PU3ge\u0016\u001c\b.Z:GS2,7\u000b\\5dKN$RARA`\u0003\u0007Dq!!1\u0013\u0001\u0004\t)&A\nmSN$\u0018N\\4N_\u0012,wJ^3se&$W\rC\u0004\u0002FJ\u0001\r!!\u0007\u0002!U\u001cX-T3uC\u0012\fG/\u0019+bE2,\u0007f\u0002\n\u0002\"\u0006E\u0014\u0011\u001a\u0017\t\u0003\u0017\fy-a5\u0002X\u0006\u0012\u0011QZ\u0001\nY\u0006T\u0018\u0010\f;sk\u0016\f#!!5\u0002\u00151\f'0\u001f\u0017gC2\u001cX-\t\u0002\u0002V\u0006QQ-Y4fe2\"(/^3\"\u0005\u0005e\u0017aC3bO\u0016\u0014HFZ1mg\u0016D3AEA\u001e\u00039\"Xm\u001d;QCJ$\u0018\u000e^5p]B\u0013XO\\3XSRDW*\u001e7uSBdW\rU1si&$\u0018n\u001c8D_2,XN\\:\u0015\u000f\u0019\u000b\t/a9\u0002f\"9\u0011\u0011Y\nA\u0002\u0005U\u0003bBAc'\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003O\u001c\u0002\u0019AA\r\u0003\u0005*g.\u00192mKB\u000b'\u000f^5uS>t\u0007+\u0019;i!J,g-\u001b=B]\u0006d\u0017p]5tQ\u001d\u0019\u0012\u0011UA9\u0003Wd\u0003#!<\u0002r\u0006U\u0018\u0011`A\u007f\u0005\u0003\u0011)A!\u0003\"\u0005\u0005=\u0018A\u00047bufdCO];fYQ\u0014X/Z\u0011\u0003\u0003g\fq\u0002\\1{s2\"(/^3-M\u0006d7/Z\u0011\u0003\u0003o\fq\u0002\\1{s22\u0017\r\\:fYQ\u0014X/Z\u0011\u0003\u0003w\f\u0001\u0003\\1{s22\u0017\r\\:fY\u0019\fGn]3\"\u0005\u0005}\u0018aD3bO\u0016\u0014H\u0006\u001e:vK2\"(/^3\"\u0005\t\r\u0011\u0001E3bO\u0016\u0014H\u0006\u001e:vK22\u0017\r\\:fC\t\u00119!\u0001\tfC\u001e,'\u000f\f4bYN,G\u0006\u001e:vK\u0006\u0012!1B\u0001\u0012K\u0006<WM\u001d\u0017gC2\u001cX\r\f4bYN,\u0007fA\n\u0002<\u0005\u0019E/Z:u!\u0006\u0014H/\u001b;j_:\u0004&/\u001e8f/&$\b.T;mi&\u0004H.\u001a)beRLG/[8o\u0007>dW/\u001c8t/&$\bnQ8na2,\u00070\u0012=qe\u0016\u001c8/[8o)\u00151%1\u0003B\u000b\u0011\u001d\t)\r\u0006a\u0001\u00033AqAa\u0006\u0015\u0001\u0004\tI\"A\rd_6\u0004H.\u001a=FqB\u0014Xm]:j_:\u0004Vo\u001d5E_^t\u0007f\u0002\u000b\u0002\"\u0006E$1\u0004\u0017\t\u0005;\u0011\tC!\n\u0003*\u0005\u0012!qD\u0001\fiJ,X\r\f\u0011gC2\u001cX-\t\u0002\u0003$\u0005aa-\u00197tK2\u0002c-\u00197tK\u0006\u0012!qE\u0001\u000biJ,X\r\f\u0011ueV,\u0017E\u0001B\u0016\u0003-1\u0017\r\\:fY\u0001\"(/^3)\u0007Q\tY$\u0001\u0014uKN$h)\u001b7f\u0019&\u001cH/\u001b8h!\u0006\u0014H/\u001b;j_:\u0004&/\u001a4jq\u0006s\u0017\r\\=tSN$2A\u0012B\u001a\u0011\u001d\t9/\u0006a\u0001\u00033As!FAQ\u0003c\u00129\u0004\f\u0003\u0003:\tu\u0012E\u0001B\u001e\u0003\u0011!(/^3\"\u0005\t}\u0012!\u00024bYN,\u0007fA\u000b\u0002<\u0005IC/Z:u\r&dW\rT5ti&twmV5uQB\u000b'\u000f^5uS>t\u0007K]3gSb\u0004&/\u001e8j]\u001e$RA\u0012B$\u0005\u0017BqA!\u0013\u0017\u0001\u0004\tI\"A\nf]\u0006\u0014G.Z'fi\u0006$\u0017\r^1UC\ndW\rC\u0004\u0002hZ\u0001\r!!\u0007)\u000fY\t\t+!\u001d\u0003P1B\u0011\u0011VAW\u0003c\u000b)\fK\u0002\u0017\u0003w\t\u0001%\u001a=ue\u0006\u001cG\u000fU1si&$\u0018n\u001c8QCRDgI]8n\r&dW\rU1uQR!\u0011Q\u000bB,\u0011\u001d\u0011If\u0006a\u0001\u00057\n\u0001BZ5mKB\u000bG\u000f\u001b\t\u0005\u0005;\u0012\u0019'\u0004\u0002\u0003`)\u0019!\u0011\r\u0014\u0002\u000fM$xN]1hK&!!Q\rB0\u0005-\u0019Fo\u001c:bO\u0016\u0004\u0016\r\u001e5\u0002SQ,7\u000f^)vKJL\b+\u0019:uSRLwN\u001c)bi\"\u001chi\u001c:OKN$X\r\u001a)beRLG/[8o)\u00151%1\u000eB8\u0011\u001d\u0011i\u0007\u0007a\u0001\u00033\tq\"^:f\u001b\u0016$\u0018MR5mK2K7\u000f\u001e\u0005\b\u0005cB\u0002\u0019AA+\u0003-\u0001\u0018M\u001d;ji&|gNQ=)\u000fa\t\t+!\u001d\u0003v1B!q\u000fB>\u0005\u007f\u0012\u0019)\t\u0002\u0003z\u0005QAO];fY\u0005t#ML2\"\u0005\tu\u0014a\u00034bYN,G&\u0019\u0018c]\r\f#A!!\u0002\rQ\u0014X/\u001a\u0017dC\t\u0011))A\u0004gC2\u001cX\rL2)\u0007a\tY$\u0001\u0011uKN$H)\u0019;b'.L\u0007\u000f]5oO^C\u0017\u000e\\3GS2,G*[:uS:<\u0007fA\r\u0002H\u0005I\u0011\r\u001e;sS\n,H/\u001a\u000b\u0005\u0005#\u0013\t\u000b\u0005\u0003\u0003\u0014\nuUB\u0001BK\u0015\u0011\u00119J!'\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0004\u00057{\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\t\t}%Q\u0013\u0002\u0013\u0003R$(/\u001b2vi\u0016\u0014VMZ3sK:\u001cW\rC\u0004\u0003$j\u0001\r!!\u0016\u0002\u0013A\f'\u000f^5uS>t\u0017a\u00027ji\u0016\u0014\u0018\r\u001c\u000b\u0005\u0005S\u0013y\u000b\u0005\u0003\u0003\u0014\n-\u0016\u0002\u0002BW\u0005+\u0013q\u0001T5uKJ\fG\u000eC\u0004\u0002rm\u0001\r!!\u0016\u00027\u001d,GOR5mK\u000e{WO\u001c;J]B\u000b'\u000f^5uS>t\u0007+\u0019;i)\u0011\u0011)La/\u0011\u0007\u001d\u00139,C\u0002\u0003:\"\u00131!\u00138u\u0011\u001d\u0011i\f\ba\u0001\u0003+\nQ\u0002]1si&$\u0018n\u001c8QCRD\u0017\u0001H4fi\u001aKG.Z\"pk:$\u0018J\u001c)beRLG/[8o!\u0006$\bn\u001d\u000b\u0005\u0005k\u0013\u0019\rC\u0004\u0003Fv\u0001\rAa2\u0002\u001dA\f'\u000f^5uS>t\u0007+\u0019;igB)qI!3\u0002V%\u0019!1\u001a%\u0003\u0015q\u0012X\r]3bi\u0016$g(A\tnC.,\u0007+\u0019:uSRLwN\u001c)bi\"$\u0002\"!\u0016\u0003R\n\u001d(1\u001e\u0005\b\u0005't\u0002\u0019\u0001Bk\u00039\u0001\u0018M\u001d;ji&|gNT1nKN\u0004bAa6\u0003b\u0006Uc\u0002\u0002Bm\u0005;tA!a\u0017\u0003\\&\t\u0011*C\u0002\u0003`\"\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003d\n\u0015(aA*fc*\u0019!q\u001c%\t\u000f\t%h\u00041\u0001\u0003V\u0006y\u0001/\u0019:uSRLwN\u001c,bYV,7\u000fC\u0004\u0003nz\u0001\r!!\u0007\u0002+!Lg/Z*us2,\u0007+\u0019:uSRLwN\\5oO\u0006\u0011\u0002O]8uK\u000e$X\r\u001a\u0013cCN,\u0007+\u0019;i)\rI&1\u001f\u0005\b\u001b~\t\t\u00111\u0001;\u0003Q\u0001(o\u001c;fGR,G\rJ7fi\u0006\u001cE.[3oiR!!\u0011`B\u0003!\u0011\u0011Yp!\u0001\u000e\u0005\tu(b\u0001B\u0000[\u0006)A/\u00192mK&!11\u0001B\u007f\u0005UAun\u001c3jKR\u000b'\r\\3NKR\f7\t\\5f]RDq!\u0014\u0011\u0002\u0002\u0003\u0007!(A\nUKN$\bj\\8eS\u00164\u0015\u000e\\3J]\u0012,\u0007\u0010\u0005\u00026EM\u0019!e!\u0004\u0011\u0007\u001d\u001by!C\u0002\u0004\u0012!\u0013a!\u00118z%\u00164GCAB\u0005)\t\u00199\u0002\u0005\u0004\u0004\u001a\r}11E\u0007\u0003\u00077Q1a!\bv\u0003\u0019\u0019HO]3b[&!1\u0011EB\u000e\u0005\u0019\u0019FO]3b[B!\u00111EB\u0013\u0013\u0011\u00199#!\n\u0003\u0013\u0005\u0013x-^7f]R\u001c\b")
public class TestHoodieFileIndex
extends HoodieSparkClientTestBase
implements ScalaAssertionSupport {
    private SparkSession spark;
    private final scala.collection.immutable.Map<String, String> commonOpts;
    private scala.collection.immutable.Map<String, String> queryOpts;

    public static Stream<Arguments> keyGeneratorParameters() {
        return TestHoodieFileIndex$.MODULE$.keyGeneratorParameters();
    }

    @Override
    public <T extends Throwable, R> T assertThrows(Class<T> expectedExceptionClass, Function0<R> f) {
        return (T)ScalaAssertionSupport.assertThrows$(this, expectedExceptionClass, f);
    }

    public /* synthetic */ String protected$basePath(TestHoodieFileIndex x$1) {
        return x$1.basePath;
    }

    public /* synthetic */ HoodieTableMetaClient protected$metaClient(TestHoodieFileIndex x$1) {
        return x$1.metaClient;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public scala.collection.immutable.Map<String, String> queryOpts() {
        return this.queryOpts;
    }

    public void queryOpts_$eq(scala.collection.immutable.Map<String, String> x$1) {
        this.queryOpts = x$1;
    }

    @Override
    public Option<Consumer<SparkSessionExtensions>> getSparkSessionExtensionsInjector() {
        return HoodieConversionUtils$.MODULE$.toJavaOption((scala.Option)new Some((Object)JFunction$.MODULE$.toJavaConsumer((Function1 & Serializable & scala.Serializable)receiver -> {
            TestHoodieFileIndex.$anonfun$getSparkSessionExtensionsInjector$1(receiver);
            return BoxedUnit.UNIT;
        })));
    }

    @BeforeEach
    public void setUp() {
        this.setTableName("hoodie_test");
        super.setUp();
        this.initPath();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.queryOpts_$eq((scala.collection.immutable.Map<String, String>)this.queryOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.basePath)}))));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPartitionSchema(boolean partitionEncode) {
        Properties props = new Properties();
        props.setProperty(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), String.valueOf(partitionEncode));
        this.initMetaClient(props);
        java.util.List records1 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(100));
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize(((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records1)).asScala()).toSeq(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), partitionEncode).mode(SaveMode.Overwrite).save(this.basePath);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieFileIndex fileIndex = new HoodieFileIndex(this.spark(), this.metaClient, (scala.Option)None$.MODULE$, this.queryOpts(), HoodieFileIndex$.MODULE$.apply$default$5(), HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        Assertions.assertEquals((Object)"partition", (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileIndex.partitionSchema().fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(","));
    }

    @Test
    public void testParsePartitionValues() {
        HoodieTableConfig tableConfig = this.metaClient.getTableConfig();
        tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.TIMESTAMP.name());
        tableConfig.setValue(HoodieTableConfig.PARTITION_FIELDS, "col1");
        .colon.colon fields = new .colon.colon((Object)new StructField("f1", DataTypes.DoubleType, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("col1", DataTypes.LongType, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        StructType schema = StructType$.MODULE$.apply((Seq)fields);
        String[] partitionColumns = (String[])((Object[])new String[]{"col1"});
        String partitionPath = "2023/10/28";
        HoodieFileIndex fileIndex = new HoodieFileIndex(this.spark(), this.metaClient, (scala.Option)new Some((Object)schema), this.queryOpts(), HoodieFileIndex$.MODULE$.apply$default$5(), HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        Object[] result = fileIndex.parsePartitionColumnValues(partitionColumns, partitionPath);
        Assertions.assertEquals((int)1, (int)result.length);
        Assertions.assertEquals((Object)UTF8String.fromString((String)partitionPath), (Object)result[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"keyGeneratorParameters"})
    public void testPartitionSchemaForBuiltInKeyGenerator(String keyGenerator) {
        java.util.List records1 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(100));
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize(((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records1)).asScala()).toSeq(), 2, ClassTag$.MODULE$.apply(String.class)));
        DataFrameWriter writer = inputDF1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(TimestampKeyGeneratorConfig.TIMESTAMP_TYPE_FIELD.key(), TimestampBasedAvroKeyGenerator.TimestampType.DATE_STRING.name()).option(TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT.key(), "yyyy/MM/dd").option(TimestampKeyGeneratorConfig.TIMESTAMP_OUTPUT_DATE_FORMAT.key(), "yyyy-MM-dd").mode(SaveMode.Overwrite);
        if (StringUtils.isNullOrEmpty((String)keyGenerator)) {
            writer.save(this.basePath);
        } else {
            writer.option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), keyGenerator).save(this.basePath);
        }
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieFileIndex fileIndex = new HoodieFileIndex(this.spark(), this.metaClient, (scala.Option)None$.MODULE$, this.queryOpts(), HoodieFileIndex$.MODULE$.apply$default$5(), HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        Assertions.assertEquals((Object)"partition", (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileIndex.partitionSchema().fields())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(","));
    }

    @ParameterizedTest
    @ValueSource(strings={"org.apache.hudi.keygen.CustomKeyGenerator", "org.apache.hudi.keygen.CustomAvroKeyGenerator"})
    public void testPartitionSchemaForCustomKeyGenerator(String keyGenerator) {
        java.util.List records1 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(100));
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize(((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records1)).asScala()).toSeq(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), keyGenerator).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partition:simple").mode(SaveMode.Overwrite).save(this.basePath);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieFileIndex fileIndex = new HoodieFileIndex(this.spark(), this.metaClient, (scala.Option)None$.MODULE$, this.queryOpts(), HoodieFileIndex$.MODULE$.apply$default$5(), HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        Assertions.assertEquals((Object)"partition", (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileIndex.partitionSchema().fields())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(","));
    }

    @Test
    public void testPartitionSchemaWithoutKeyGenerator() {
        HoodieTableMetaClient metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (Properties)HoodieTableMetaClient.newTableBuilder().fromMetaClient(this.metaClient).setRecordKeyFields("_row_key").setPartitionFields("partition_path").setTableName("hoodie_test").build());
        scala.collection.immutable.Map props = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition_path"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL())}));
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withEngineType(EngineType.JAVA).withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withProps((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)props).asJava()).build();
        HoodieJavaEngineContext context = new HoodieJavaEngineContext(HoodieTestUtils.getDefaultStorageConf());
        HoodieJavaWriteClient writeClient = new HoodieJavaWriteClient((HoodieEngineContext)context, writeConfig);
        String instantTime = HoodieTestTable.makeNewCommitTime();
        java.util.List records = this.dataGen.generateInsertsContainsAllPartitions(instantTime, Predef$.MODULE$.int2Integer(100));
        writeClient.startCommitWithTime(instantTime);
        writeClient.insert(records, instantTime);
        metaClient.reloadActiveTimeline();
        HoodieFileIndex fileIndex = new HoodieFileIndex(this.spark(), metaClient, (scala.Option)None$.MODULE$, this.queryOpts(), HoodieFileIndex$.MODULE$.apply$default$5(), HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        Assertions.assertEquals((Object)"partition_path", (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileIndex.partitionSchema().fields())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(","));
        writeClient.close();
    }

    @ParameterizedTest
    @CsvSource(value={"true,true", "true,false", "false,true", "false,false"})
    public void testPartitionPruneWithPartitionEncode(boolean partitionEncode, boolean listLazily) {
        Properties props = new Properties();
        props.setProperty(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), String.valueOf(partitionEncode));
        this.initMetaClient(props);
        String[] partitions = (String[])((Object[])new String[]{"2021/03/08", "2021/03/09", "2021/03/10", "2021/03/11", "2021/03/12"});
        HoodieTestDataGenerator newDataGen = new HoodieTestDataGenerator(partitions);
        java.util.List records1 = newDataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(100));
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize(((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)records1)).asScala()).toSeq(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), partitionEncode).mode(SaveMode.Overwrite).save(this.basePath);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        String listingMode = listLazily ? DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_MODE_LAZY() : DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_MODE_EAGER();
        scala.collection.immutable.Map opts = this.queryOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_MODE_OVERRIDE().key()), (Object)listingMode));
        HoodieFileIndex fileIndex = new HoodieFileIndex(this.spark(), this.metaClient, (scala.Option)None$.MODULE$, opts, HoodieFileIndex$.MODULE$.apply$default$5(), HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        EqualTo partitionFilter1 = new EqualTo((Expression)this.attribute("partition"), (Expression)this.literal("2021/03/08"));
        String partitionName = partitionEncode ? PartitionPathEncodeUtils.escapePathName((String)"2021/03/08") : "2021/03/08";
        Seq partitionAndFilesAfterPrune = fileIndex.listFiles((Seq)new .colon.colon((Object)partitionFilter1, (List)Nil$.MODULE$), (Seq)Nil$.MODULE$);
        Assertions.assertEquals((int)1, (int)partitionAndFilesAfterPrune.size());
        PartitionDirectory partitionDirectory = (PartitionDirectory)partitionAndFilesAfterPrune.apply(0);
        if (partitionDirectory == null) {
            throw new MatchError((Object)partitionDirectory);
        }
        InternalRow partitionValues = partitionDirectory.values();
        Seq filesInPartition = partitionDirectory.files();
        Tuple2 tuple2 = new Tuple2((Object)partitionValues, (Object)filesInPartition);
        InternalRow partitionValues2 = (InternalRow)tuple2._1();
        Seq filesInPartition2 = (Seq)tuple2._2();
        Assertions.assertEquals((Object)partitionValues2.toSeq((Seq)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$)).mkString(","), (Object)"2021/03/08");
        Assertions.assertEquals((int)this.getFileCountInPartitionPath(partitionName), (int)filesInPartition2.size());
        And partitionFilter2 = new And((Expression)new GreaterThanOrEqual((Expression)this.attribute("partition"), (Expression)this.literal("2021/03/08")), (Expression)new LessThan((Expression)this.attribute("partition"), (Expression)this.literal("2021/03/10")));
        List prunedPartitions = (List)((TraversableOnce)fileIndex.listFiles((Seq)new .colon.colon((Object)partitionFilter2, (List)Nil$.MODULE$), (Seq)Nil$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.values().toSeq((Seq)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$)).mkString(","), Seq$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertEquals((Object)new .colon.colon((Object)"2021/03/08", (List)new .colon.colon((Object)"2021/03/09", (List)Nil$.MODULE$)), (Object)prunedPartitions);
    }

    @ParameterizedTest
    @CsvSource(value={"lazy,true", "lazy,false", "eager,true", "eager,false"})
    public void testIndexRefreshesFileSlices(String listingModeOverride, boolean useMetadataTable) {
        Random r = new Random(57069);
        IndexedSeq tuples = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000).map((Function1 & Serializable & scala.Serializable)i -> TestHoodieFileIndex.$anonfun$testIndexRefreshesFileSlices$4(r, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map writeOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)Boolean.toString(useMetadataTable))})));
        SparkSession _spark = this.spark();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestHoodieFileIndex.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieFileIndex$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$))));
            }

            public Org_apache_hudi_TestHoodieFileIndex$$typecreator6$1(TestHoodieFileIndex $outer) {
            }
        }
        Dataset inputDF = _spark.implicits().localSeqToDatasetHolder((Seq)tuples, _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieFileIndex$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_row_key", "partition", "timestamp"}));
        inputDF.write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        scala.collection.immutable.Map readOpts = this.queryOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)Boolean.toString(useMetadataTable)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_MODE_OVERRIDE().key()), (Object)listingModeOverride)})));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieFileIndex fileIndexFirstWrite = new HoodieFileIndex(this.spark(), this.metaClient, (scala.Option)None$.MODULE$, readOpts, HoodieFileIndex$.MODULE$.apply$default$5(), HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        Seq listFilesAfterFirstWrite = fileIndexFirstWrite.listFiles((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        Seq distinctListOfCommitTimesAfterFirstWrite = TestHoodieFileIndex.getDistinctCommitTimeFromAllFilesInIndex$1(listFilesAfterFirstWrite);
        String firstWriteCommitTime = ((HoodieInstant)this.metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().get()).requestedTime();
        Assertions.assertEquals((int)1, (int)distinctListOfCommitTimesAfterFirstWrite.size(), (String)"Should have only one commit");
        Assertions.assertEquals((Object)firstWriteCommitTime, (Object)distinctListOfCommitTimesAfterFirstWrite.head(), (String)"All files should belong to the first existing commit");
        IndexedSeq nextBatch = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)i -> TestHoodieFileIndex.$anonfun$testIndexRefreshesFileSlices$5(r, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestHoodieFileIndex.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieFileIndex$$typecreator16$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$))));
            }

            public Org_apache_hudi_TestHoodieFileIndex$$typecreator16$1(TestHoodieFileIndex $outer) {
            }
        }
        _spark.implicits().localSeqToDatasetHolder((Seq)nextBatch, _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieFileIndex$$typecreator16$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_row_key", "partition", "timestamp"})).write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        fileIndexFirstWrite.refresh();
        Seq fileSlicesAfterSecondWrite = fileIndexFirstWrite.listFiles((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        Seq distinctListOfCommitTimesAfterSecondWrite = TestHoodieFileIndex.getDistinctCommitTimeFromAllFilesInIndex$1(fileSlicesAfterSecondWrite);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        String lastCommitTime = ((HoodieInstant)this.metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().get()).requestedTime();
        Assertions.assertEquals((int)1, (int)distinctListOfCommitTimesAfterSecondWrite.size(), (String)"All basefiles affected so all have same commit time");
        Assertions.assertEquals((Object)lastCommitTime, (Object)distinctListOfCommitTimesAfterSecondWrite.head(), (String)"All files should be of second commit after index refresh");
    }

    @ParameterizedTest
    @CsvSource(value={"lazy,true,true", "lazy,true,false", "lazy,false,true", "lazy,false,false", "eager,true,true", "eager,true,false", "eager,false,true", "eager,false,false"})
    public void testPartitionPruneWithMultiplePartitionColumns(String listingModeOverride, boolean useMetadataTable, boolean enablePartitionPathPrefixAnalysis) {
        HoodieException hoodieException;
        SparkSession _spark = this.spark();
        scala.collection.immutable.Map writerOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"version"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt,hh"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)Boolean.toString(useMetadataTable))})));
        scala.collection.immutable.Map readerOpts = this.queryOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)Boolean.toString(useMetadataTable)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_MODE_OVERRIDE().key()), (Object)listingModeOverride), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_PARTITION_PATH_PREFIX_ANALYSIS_ENABLED().key()), (Object)Boolean.toString(enablePartitionPathPrefixAnalysis))})));
        ObjectRef fileIndex = ObjectRef.create(null);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestHoodieFileIndex.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieFileIndex$$typecreator6$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_hudi_TestHoodieFileIndex$$typecreator6$2(TestHoodieFileIndex $outer) {
            }
        }
        Dataset inputDF1 = _spark.implicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> TestHoodieFileIndex.$anonfun$testPartitionPruneWithMultiplePartitionColumns$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieFileIndex$$typecreator6$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "price", "version", "dt", "hh"}));
        inputDF1.write().format("hudi").options((Map)writerOpts).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), "false").mode(SaveMode.Overwrite).save(this.basePath);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        fileIndex.elem = new HoodieFileIndex(this.spark(), this.metaClient, (scala.Option)None$.MODULE$, readerOpts, HoodieFileIndex$.MODULE$.apply$default$5(), HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        And partitionFilters = new And((Expression)new EqualTo((Expression)this.attribute("dt"), (Expression)this.literal("2021-03-01")), (Expression)new EqualTo((Expression)this.attribute("hh"), (Expression)this.literal("10")));
        Seq partitionAndFilesAfterPrune = ((HoodieFileIndex)fileIndex.elem).listFiles((Seq)new .colon.colon((Object)partitionFilters, (List)Nil$.MODULE$), (Seq)Nil$.MODULE$);
        Assertions.assertEquals((int)1, (int)partitionAndFilesAfterPrune.size());
        PartitionDirectory partitionDirectory = (PartitionDirectory)partitionAndFilesAfterPrune.head();
        if (partitionDirectory == null) {
            throw new MatchError((Object)partitionDirectory);
        }
        InternalRow partitionValues = partitionDirectory.values();
        Seq filesAfterPrune = partitionDirectory.files();
        Tuple2 tuple2 = new Tuple2((Object)partitionValues, (Object)filesAfterPrune);
        InternalRow partitionValues2 = (InternalRow)tuple2._1();
        Seq filesAfterPrune2 = (Seq)tuple2._2();
        Assertions.assertEquals((Object)"2021-03-01,10", (Object)partitionValues2.toSeq((Seq)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$)).mkString(","));
        Assertions.assertEquals((int)this.getFileCountInPartitionPath("2021-03-01/10"), (int)filesAfterPrune2.size());
        Dataset readDF = this.spark().read().format("hudi").options((Map)readerOpts).load();
        Assertions.assertEquals((long)10L, (long)readDF.count());
        Assertions.assertEquals((long)5L, (long)readDF.filter("dt = '2021-03-01' and hh = '10'").count());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestHoodieFileIndex.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieFileIndex$$typecreator16$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_hudi_TestHoodieFileIndex$$typecreator16$2(TestHoodieFileIndex $outer) {
            }
        }
        Dataset inputDF2 = _spark.implicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> TestHoodieFileIndex.$anonfun$testPartitionPruneWithMultiplePartitionColumns$2(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieFileIndex$$typecreator16$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "price", "version", "dt", "hh"}));
        inputDF2.write().format("hudi").options((Map)writerOpts).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), "false").mode(SaveMode.Overwrite).save(this.basePath);
        ((HoodieFileIndex)fileIndex.elem).refresh();
        And partitionFilter2 = new And((Expression)new EqualTo((Expression)this.attribute("dt"), (Expression)this.literal("2021/03/01")), (Expression)new EqualTo((Expression)this.attribute("hh"), (Expression)this.literal("10")));
        String string = listingModeOverride;
        String string2 = DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_MODE_LAZY();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            hoodieException = this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> ((HoodieFileIndex)fileIndex$1.elem).listFiles((Seq)new .colon.colon((Object)partitionFilter2, (List)Nil$.MODULE$), (Seq)Nil$.MODULE$));
        } else {
            Seq partitionAndFilesNoPruning = ((HoodieFileIndex)fileIndex.elem).listFiles((Seq)new .colon.colon((Object)partitionFilter2, (List)Nil$.MODULE$), (Seq)Nil$.MODULE$);
            Assertions.assertEquals((int)1, (int)partitionAndFilesNoPruning.size());
            Assertions.assertTrue((boolean)partitionAndFilesNoPruning.forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TestHoodieFileIndex.$anonfun$testPartitionPruneWithMultiplePartitionColumns$4(x$10))));
            Assertions.assertEquals((int)this.getFileCountInPartitionPaths((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021/03/01/10", "2021/03/02/10"})), (int)((SeqLike)partitionAndFilesNoPruning.flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.files(), Seq$.MODULE$.canBuildFrom())).length());
            Dataset readDF2 = this.spark().read().format("hudi").options((Map)readerOpts).load();
            Assertions.assertEquals((long)10L, (long)readDF2.count());
            Assertions.assertEquals((long)5L, (long)readDF2.filter("dt = '2021/03/01' and hh ='10'").count());
            hoodieException = BoxedUnit.UNIT;
        }
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(TestHoodieFileIndex.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieFileIndex$$typecreator26$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_hudi_TestHoodieFileIndex$$typecreator26$1(TestHoodieFileIndex $outer) {
            }
        }
        Dataset inputDF3 = _spark.implicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> TestHoodieFileIndex.$anonfun$testPartitionPruneWithMultiplePartitionColumns$6(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), _spark.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_hudi_TestHoodieFileIndex$$typecreator26$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "price", "version", "dt", "hh"}));
        inputDF3.write().format("hudi").options((Map)writerOpts).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), "true").mode(SaveMode.Overwrite).save(this.basePath);
        ((HoodieFileIndex)fileIndex.elem).refresh();
        And partitionFilters2 = new And((Expression)new EqualTo((Expression)this.attribute("dt"), (Expression)this.literal("2021/03/01")), (Expression)new EqualTo((Expression)this.attribute("hh"), (Expression)this.literal("10")));
        Seq partitionAndFilesAfterPrune2 = ((HoodieFileIndex)fileIndex.elem).listFiles((Seq)new .colon.colon((Object)partitionFilters2, (List)Nil$.MODULE$), (Seq)Nil$.MODULE$);
        Assertions.assertEquals((int)1, (int)partitionAndFilesAfterPrune2.size());
        PartitionDirectory partitionDirectory2 = (PartitionDirectory)partitionAndFilesAfterPrune2.head();
        if (partitionDirectory2 == null) {
            throw new MatchError((Object)partitionDirectory2);
        }
        InternalRow partitionValues3 = partitionDirectory2.values();
        Seq filesAfterPrune3 = partitionDirectory2.files();
        Tuple2 tuple22 = new Tuple2((Object)partitionValues3, (Object)filesAfterPrune3);
        InternalRow partitionValues4 = (InternalRow)tuple22._1();
        Seq filesAfterPrune4 = (Seq)tuple22._2();
        Assertions.assertEquals((Object)"2021/03/01,10", (Object)partitionValues4.toSeq((Seq)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$)).mkString(","));
        Assertions.assertEquals((int)this.getFileCountInPartitionPath("2021%2F03%2F01/10"), (int)filesAfterPrune4.size());
        Dataset readDF3 = this.spark().read().format("hudi").options((Map)readerOpts).load();
        Assertions.assertEquals((long)10L, (long)readDF3.count());
        Assertions.assertEquals((long)5L, (long)readDF3.filter("dt = '2021/03/01' and hh = '10'").count());
    }

    @ParameterizedTest
    @CsvSource(value={"true, false", "false, false", "true, true", "false, true"})
    public void testPartitionPruneWithMultiplePartitionColumnsWithComplexExpression(boolean useMetadataTable, boolean complexExpressionPushDown) {
        SparkSession _spark = this.spark();
        Seq partitionNames = (Seq)new .colon.colon((Object)"prefix", (List)new .colon.colon((Object)"dt", (List)new .colon.colon((Object)"hh", (List)new .colon.colon((Object)"country", (List)Nil$.MODULE$))));
        scala.collection.immutable.Map writerOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"version"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)partitionNames.mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)Boolean.toString(useMetadataTable))})));
        scala.collection.immutable.Map readerOpts = this.queryOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)Boolean.toString(useMetadataTable)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_MODE_OVERRIDE().key()), (Object)"lazy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_PARTITION_PATH_PREFIX_ANALYSIS_ENABLED().key()), (Object)"true")})));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestHoodieFileIndex.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieFileIndex$$typecreator6$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple8"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor()})));
            }

            public Org_apache_hudi_TestHoodieFileIndex$$typecreator6$3(TestHoodieFileIndex $outer) {
            }
        }
        Dataset inputDF1 = _spark.implicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> TestHoodieFileIndex.$anonfun$testPartitionPruneWithMultiplePartitionColumnsWithComplexExpression$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieFileIndex$$typecreator6$3(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "price", "version", "prefix", "dt", "hh", "country"}));
        inputDF1.write().format("hudi").options((Map)writerOpts).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), Boolean.toString(complexExpressionPushDown)).option(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), Boolean.toString(complexExpressionPushDown)).mode(SaveMode.Overwrite).save(this.basePath);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieFileIndex fileIndex = new HoodieFileIndex(this.spark(), this.metaClient, (scala.Option)None$.MODULE$, readerOpts, HoodieFileIndex$.MODULE$.apply$default$5(), HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        EqualTo partitionFilters = new EqualTo((Expression)this.attribute("hh"), (Expression)Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)5), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int()));
        Seq partitionAndFilesAfterPrune = fileIndex.listFiles((Seq)new .colon.colon((Object)partitionFilters, (List)Nil$.MODULE$), (Seq)Nil$.MODULE$);
        Assertions.assertEquals((int)1, (int)partitionAndFilesAfterPrune.size());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)fileIndex.areAllPartitionPathsCached()), (Object)BoxesRunTime.boxToBoolean((!complexExpressionPushDown ? 1 : 0) != 0));
        PartitionDirectory partitionDirectory = (PartitionDirectory)partitionAndFilesAfterPrune.head();
        if (partitionDirectory == null) {
            throw new MatchError((Object)partitionDirectory);
        }
        InternalRow partitionActualValues = partitionDirectory.values();
        Seq filesAfterPrune = partitionDirectory.files();
        Tuple2 tuple2 = new Tuple2((Object)partitionActualValues, (Object)filesAfterPrune);
        InternalRow partitionActualValues2 = (InternalRow)tuple2._1();
        Seq filesAfterPrune2 = (Seq)tuple2._2();
        Seq partitionExpectValues = (Seq)new .colon.colon((Object)"default", (List)new .colon.colon((Object)"2021-03-01", (List)new .colon.colon((Object)"5", (List)new .colon.colon((Object)"CN", (List)Nil$.MODULE$))));
        Assertions.assertEquals((Object)partitionExpectValues.mkString(","), (Object)partitionActualValues2.toSeq((Seq)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$)).mkString(","));
        Assertions.assertEquals((int)this.getFileCountInPartitionPath(this.makePartitionPath((Seq<String>)partitionNames, (Seq<String>)partitionExpectValues, complexExpressionPushDown)), (int)filesAfterPrune2.size());
        Dataset readDF = this.spark().read().format("hudi").options((Map)readerOpts).load();
        Assertions.assertEquals((long)10L, (long)readDF.count());
        Assertions.assertEquals((long)1L, (long)readDF.filter("hh = 5").count());
    }

    @ParameterizedTest
    @CsvSource(value={"true", "false"})
    public void testFileListingPartitionPrefixAnalysis(boolean enablePartitionPathPrefixAnalysis) {
        SparkSession _spark = this.spark();
        scala.collection.immutable.Map writerOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"version"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt,hh")})));
        scala.collection.immutable.Map readerOpts = this.queryOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_MODE_OVERRIDE().key()), (Object)"eager"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_PARTITION_PATH_PREFIX_ANALYSIS_ENABLED().key()), (Object)Boolean.toString(enablePartitionPathPrefixAnalysis))})));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestHoodieFileIndex.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieFileIndex$$typecreator6$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_hudi_TestHoodieFileIndex$$typecreator6$4(TestHoodieFileIndex $outer) {
            }
        }
        Dataset inputDF1 = _spark.implicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> TestHoodieFileIndex.$anonfun$testFileListingPartitionPrefixAnalysis$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieFileIndex$$typecreator6$4(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "price", "version", "dt", "hh"}));
        inputDF1.write().format("hudi").options((Map)writerOpts).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), "false").mode(SaveMode.Overwrite).save(this.basePath);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieFileIndex fileIndex = new HoodieFileIndex(this.spark(), this.metaClient, (scala.Option)None$.MODULE$, readerOpts, HoodieFileIndex$.MODULE$.apply$default$5(), HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        EqualTo partitionFilters = new EqualTo((Expression)this.attribute("dt"), (Expression)this.literal("2021/03/01"));
        Seq partitionAndFilesAfterPrune = fileIndex.listFiles((Seq)new .colon.colon((Object)partitionFilters, (List)Nil$.MODULE$), (Seq)Nil$.MODULE$);
        Assertions.assertEquals((int)1, (int)partitionAndFilesAfterPrune.size());
        Tuple2 tuple2 = ((GenericTraversableTemplate)partitionAndFilesAfterPrune.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PartitionDirectory partitionDirectory = x0$1;
            if (partitionDirectory != null) {
                InternalRow values = partitionDirectory.values();
                Seq files = partitionDirectory.files();
                return new Tuple2((Object)values.toSeq((Seq)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$)), (Object)files);
            }
            throw new MatchError((Object)partitionDirectory);
        }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionValuesSeq = (Seq)tuple2._1();
        Seq perPartitionFilesSeq = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionValuesSeq, (Object)perPartitionFilesSeq);
        Seq partitionValuesSeq2 = (Seq)tuple22._1();
        Seq perPartitionFilesSeq2 = (Seq)tuple22._2();
        int expectedListedFiles = enablePartitionPathPrefixAnalysis ? this.getFileCountInPartitionPaths((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2021/03/01/0", "2021/03/01/1", "2021/03/01/2"})) : fileIndex.allBaseFiles().length();
        Assertions.assertEquals((int)expectedListedFiles, (int)BoxesRunTime.unboxToInt((Object)((TraversableOnce)perPartitionFilesSeq2.map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        Dataset readDF = this.spark().read().format("hudi").options((Map)readerOpts).load();
        Assertions.assertEquals((long)10L, (long)readDF.count());
        Assertions.assertEquals((long)3L, (long)readDF.filter("hh = '1'").count());
        Assertions.assertEquals((long)5L, (long)readDF.filter("dt = '2021/03/01'").count());
        Assertions.assertEquals((long)1L, (long)readDF.filter("dt = '2021/03/01' and hh = '1'").count());
    }

    @ParameterizedTest
    @CsvSource(value={"true,true", "true,false", "false,true", "false,false"})
    public void testFileListingWithPartitionPrefixPruning(boolean enableMetadataTable, boolean enablePartitionPathPrefixAnalysis) {
        SparkSession _spark = this.spark();
        scala.collection.immutable.Map writerOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)Boolean.toString(enableMetadataTable)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"region_code,dt"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"price")})));
        scala.collection.immutable.Map readerOpts = this.queryOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)Boolean.toString(enableMetadataTable)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_MODE_OVERRIDE().key()), (Object)"eager"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_PARTITION_PATH_PREFIX_ANALYSIS_ENABLED().key()), (Object)Boolean.toString(enablePartitionPathPrefixAnalysis))})));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestHoodieFileIndex.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieFileIndex$$typecreator6$5
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieFileIndex$$typecreator6$5(TestHoodieFileIndex $outer) {
            }
        }
        Dataset inputDF1 = _spark.implicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)i -> TestHoodieFileIndex.$anonfun$testFileListingWithPartitionPrefixPruning$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieFileIndex$$typecreator6$5(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "price", "region_code", "dt"}));
        inputDF1.write().format("hudi").options((Map)writerOpts).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), "false").mode(SaveMode.Overwrite).save(this.basePath);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieTableMetadata metadata = HoodieTableMetadata.create((HoodieEngineContext)this.context, (HoodieStorage)this.metaClient.getStorage(), (HoodieMetadataConfig)HoodieMetadataConfig.newBuilder().enable(enableMetadataTable).build(), (String)this.metaClient.getBasePath().toString());
        Assertions.assertEquals((Object)new .colon.colon((Object)"1/2023/01/01", (List)new .colon.colon((Object)"1/2023/01/02", (List)Nil$.MODULE$)), (Object)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.getPartitionPathWithPathPrefixes((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"1", (List)Nil$.MODULE$)).asJava())).asScala()).sorted((Ordering)Ordering.String$.MODULE$));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1/2023/01/01", "1/2023/01/02", "10/2023/01/01", "10/2023/01/02", "100/2023/01/01", "100/2023/01/02", "2/2023/01/01", "2/2023/01/02", "20/2023/01/01", "20/2023/01/02", "200/2023/01/01", "200/2023/01/02"})), (Object)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.getPartitionPathWithPathPrefixes((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"", (List)Nil$.MODULE$)).asJava())).asScala()).sorted((Ordering)Ordering.String$.MODULE$));
        Assertions.assertEquals((Object)new .colon.colon((Object)"1/2023/01/01", (List)Nil$.MODULE$), (Object)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.getPartitionPathWithPathPrefixes((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"1/2023/01/01", (List)Nil$.MODULE$)).asJava())).asScala()).sorted((Ordering)Ordering.String$.MODULE$));
        HoodieFileIndex fileIndex = new HoodieFileIndex(this.spark(), this.metaClient, (scala.Option)None$.MODULE$, readerOpts, HoodieFileIndex$.MODULE$.apply$default$5(), HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        Dataset readDF = this.spark().read().format("hudi").options((Map)readerOpts).load();
        Seq testCases = (Seq)new .colon.colon((Object)new Tuple4((Object)new .colon.colon((Object)new EqualTo((Expression)this.attribute("region_code"), (Expression)this.literal("1")), (List)Nil$.MODULE$), (Object)"region_code = '1'", (Object)BoxesRunTime.boxToBoolean((boolean)enablePartitionPathPrefixAnalysis), (Object)new .colon.colon((Object)new Tuple2((Object)"1", (Object)"2023/01/01"), (List)new .colon.colon((Object)new Tuple2((Object)"1", (Object)"2023/01/02"), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)new Tuple4((Object)new .colon.colon((Object)new EqualTo((Expression)this.attribute("dt"), (Expression)this.literal("2023/01/01")), (List)Nil$.MODULE$), (Object)"dt = '2023/01/01'", (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"1", (Object)"2023/01/01"), new Tuple2((Object)"10", (Object)"2023/01/01"), new Tuple2((Object)"100", (Object)"2023/01/01"), new Tuple2((Object)"2", (Object)"2023/01/01"), new Tuple2((Object)"20", (Object)"2023/01/01"), new Tuple2((Object)"200", (Object)"2023/01/01")}))), (List)new .colon.colon((Object)new Tuple4((Object)new .colon.colon((Object)new EqualTo((Expression)this.attribute("dt"), (Expression)this.literal("2023/01/01")), (List)new .colon.colon((Object)new EqualTo((Expression)this.attribute("region_code"), (Expression)this.literal("1")), (List)Nil$.MODULE$)), (Object)"dt = '2023/01/01' and region_code = '1'", (Object)BoxesRunTime.boxToBoolean((boolean)enablePartitionPathPrefixAnalysis), (Object)new .colon.colon((Object)new Tuple2((Object)"1", (Object)"2023/01/01"), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new Tuple4((Object)new .colon.colon((Object)new EqualTo((Expression)this.attribute("region_code"), (Expression)this.literal("0")), (List)Nil$.MODULE$), (Object)"region_code = '0'", (Object)BoxesRunTime.boxToBoolean((boolean)enablePartitionPathPrefixAnalysis), (Object)Nil$.MODULE$), (List)Nil$.MODULE$))));
        testCases.foreach((Function1 & Serializable & scala.Serializable)testCase -> {
            TestHoodieFileIndex.$anonfun$testFileListingWithPartitionPrefixPruning$2(this, fileIndex, readDF, testCase);
            return BoxedUnit.UNIT;
        });
    }

    private String extractPartitionPathFromFilePath(StoragePath filePath) {
        String relativeFilePath = FSUtils.getRelativePartitionPath((StoragePath)this.metaClient.getBasePath(), (StoragePath)filePath);
        String[] names = relativeFilePath.split("/");
        String fileName = names[names.length - 1];
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(relativeFilePath)).stripSuffix(fileName))).stripSuffix("/");
    }

    @ParameterizedTest
    @CsvSource(value={"true,a.b.c", "false,a.b.c", "true,c", "false,c"})
    public void testQueryPartitionPathsForNestedPartition(boolean useMetaFileList, String partitionBy) {
        Dataset inputDF = this.spark().range(100L).withColumn("c", functions$.MODULE$.lit((Object)"c")).withColumn("b", functions$.MODULE$.struct("c", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).withColumn("a", functions$.MODULE$.struct("b", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
        inputDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), partitionBy).option(HoodieMetadataConfig.ENABLE.key(), useMetaFileList).mode(SaveMode.Overwrite).save(this.basePath);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieFileIndex fileIndex = new HoodieFileIndex(this.spark(), this.metaClient, (scala.Option)None$.MODULE$, this.queryOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)Boolean.toString(useMetaFileList))}))), HoodieFileIndex$.MODULE$.apply$default$5(), HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        Predef$.MODULE$.assert(((BaseHoodieTableFileIndex.PartitionPath)fileIndex.getAllQueryPartitionPaths().get((int)0)).path.equals("c"));
    }

    @Test
    public void testDataSkippingWhileFileListing() {
        LazyRef TestCase$module = new LazyRef();
        Random r = new Random(57069);
        IndexedSeq tuples = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000).map((Function1 & Serializable & scala.Serializable)i -> TestHoodieFileIndex.$anonfun$testDataSkippingWhileFileListing$1(r, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        SparkSession _spark = this.spark();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestHoodieFileIndex.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieFileIndex$$typecreator6$6
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_hudi_TestHoodieFileIndex$$typecreator6$6(TestHoodieFileIndex $outer) {
            }
        }
        Dataset inputDF = _spark.implicits().localSeqToDatasetHolder((Seq)tuples, _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieFileIndex$$typecreator6$6(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "inv_id", "str", "rand"}));
        scala.collection.immutable.Map writeMetadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true")}));
        scala.collection.immutable.Map opts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)"true")}))).$plus$plus((GenTraversableOnce)writeMetadataOpts);
        this.spark().sqlContext().setConf(HoodieFileIndex.DataSkippingFailureMode$.MODULE$.configName(), HoodieFileIndex.DataSkippingFailureMode$.MODULE$.Strict().value());
        inputDF.repartition(4).write().format("hudi").options((Map)opts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.key(), 102400L).mode(SaveMode.Overwrite).save(this.basePath);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        public class Org_apache_hudi_TestHoodieFileIndex$TestCase$1
        implements Product,
        scala.Serializable {
            private final boolean enableMetadata;
            private final boolean enableColumnStats;
            private final boolean enableDataSkipping;
            private final String columnStatsProcessingModeOverride;
            private final /* synthetic */ TestHoodieFileIndex $outer;

            public boolean enableMetadata() {
                return this.enableMetadata;
            }

            public boolean enableColumnStats() {
                return this.enableColumnStats;
            }

            public boolean enableDataSkipping() {
                return this.enableDataSkipping;
            }

            public String columnStatsProcessingModeOverride() {
                return this.columnStatsProcessingModeOverride;
            }

            public Org_apache_hudi_TestHoodieFileIndex$TestCase$1 copy(boolean enableMetadata, boolean enableColumnStats, boolean enableDataSkipping, String columnStatsProcessingModeOverride) {
                return new Org_apache_hudi_TestHoodieFileIndex$TestCase$1(this.$outer, enableMetadata, enableColumnStats, enableDataSkipping, columnStatsProcessingModeOverride);
            }

            public boolean copy$default$1() {
                return this.enableMetadata();
            }

            public boolean copy$default$2() {
                return this.enableColumnStats();
            }

            public boolean copy$default$3() {
                return this.enableDataSkipping();
            }

            public String copy$default$4() {
                return this.columnStatsProcessingModeOverride();
            }

            public String productPrefix() {
                return "TestCase";
            }

            public int productArity() {
                return 4;
            }

            public Object productElement(int x$1) {
                int n = x$1;
                switch (n) {
                    case 0: {
                        return BoxesRunTime.boxToBoolean((boolean)this.enableMetadata());
                    }
                    case 1: {
                        return BoxesRunTime.boxToBoolean((boolean)this.enableColumnStats());
                    }
                    case 2: {
                        return BoxesRunTime.boxToBoolean((boolean)this.enableDataSkipping());
                    }
                    case 3: {
                        return this.columnStatsProcessingModeOverride();
                    }
                }
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Org_apache_hudi_TestHoodieFileIndex$TestCase$1;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)(this.enableMetadata() ? 1231 : 1237));
                n = Statics.mix((int)n, (int)(this.enableColumnStats() ? 1231 : 1237));
                n = Statics.mix((int)n, (int)(this.enableDataSkipping() ? 1231 : 1237));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.columnStatsProcessingModeOverride()));
                return Statics.finalizeHash((int)n, (int)4);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Org_apache_hudi_TestHoodieFileIndex$TestCase$1)) return false;
                boolean bl = true;
                if (!bl) return false;
                Org_apache_hudi_TestHoodieFileIndex$TestCase$1 var4_3 = (Org_apache_hudi_TestHoodieFileIndex$TestCase$1)x$1;
                if (this.enableMetadata() != var4_3.enableMetadata()) return false;
                if (this.enableColumnStats() != var4_3.enableColumnStats()) return false;
                if (this.enableDataSkipping() != var4_3.enableDataSkipping()) return false;
                String string = this.columnStatsProcessingModeOverride();
                String string2 = var4_3.columnStatsProcessingModeOverride();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                if (!var4_3.canEqual(this)) return false;
                return true;
            }

            public Org_apache_hudi_TestHoodieFileIndex$TestCase$1(TestHoodieFileIndex $outer, boolean enableMetadata, boolean enableColumnStats, boolean enableDataSkipping, String columnStatsProcessingModeOverride) {
                this.enableMetadata = enableMetadata;
                this.enableColumnStats = enableColumnStats;
                this.enableDataSkipping = enableDataSkipping;
                this.columnStatsProcessingModeOverride = columnStatsProcessingModeOverride;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
        Org_apache_hudi_TestHoodieFileIndex$TestCase$1 var11_10 = this.TestCase$3(TestCase$module).apply(false, false, false, this.TestCase$3(TestCase$module).apply$default$4());
        Org_apache_hudi_TestHoodieFileIndex$TestCase$1 var12_11 = this.TestCase$3(TestCase$module).apply(false, false, true, this.TestCase$3(TestCase$module).apply$default$4());
        Org_apache_hudi_TestHoodieFileIndex$TestCase$1 var13_12 = this.TestCase$3(TestCase$module).apply(true, false, true, this.TestCase$3(TestCase$module).apply$default$4());
        Org_apache_hudi_TestHoodieFileIndex$TestCase$1 var14_13 = this.TestCase$3(TestCase$module).apply(false, true, true, this.TestCase$3(TestCase$module).apply$default$4());
        Org_apache_hudi_TestHoodieFileIndex$TestCase$1 var15_14 = this.TestCase$3(TestCase$module).apply(true, true, true, this.TestCase$3(TestCase$module).apply$default$4());
        Org_apache_hudi_TestHoodieFileIndex$TestCase$1 var16_15 = this.TestCase$3(TestCase$module).apply(true, true, true, "in-memory");
        Org_apache_hudi_TestHoodieFileIndex$TestCase$1 var17_16 = this.TestCase$3(TestCase$module).apply(true, true, true, "engine");
        List testCases = Nil$.MODULE$.$colon$colon((Object)var17_16).$colon$colon((Object)var16_15).$colon$colon((Object)var15_14).$colon$colon((Object)var14_13).$colon$colon((Object)var13_12).$colon$colon((Object)var12_11).$colon$colon((Object)var11_10);
        testCases.foreach((Function1 & Serializable & scala.Serializable)testCase -> {
            TestHoodieFileIndex.$anonfun$testDataSkippingWhileFileListing$2(this, testCase);
            return BoxedUnit.UNIT;
        });
    }

    private AttributeReference attribute(String partition) {
        String x$1 = partition;
        StringType$ x$2 = StringType$.MODULE$;
        boolean x$3 = true;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
        return new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6);
    }

    private Literal literal(String value) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestHoodieFileIndex.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieFileIndex$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_TestHoodieFileIndex$$typecreator1$1(TestHoodieFileIndex $outer) {
            }
        }
        return Literal$.MODULE$.create((Object)value, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieFileIndex$$typecreator1$1(null)));
    }

    private int getFileCountInPartitionPath(String partitionPath) {
        this.metaClient.reloadActiveTimeline();
        HoodieTimeline activeInstants = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        HoodieTableFileSystemView fileSystemView = new HoodieTableFileSystemView(this.metaClient, activeInstants);
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(fileSystemView.getAllBaseFiles(partitionPath).iterator()).asScala()).toSeq().length();
    }

    private int getFileCountInPartitionPaths(Seq<String> partitionPaths) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)partitionPaths.map((Function1 & Serializable & scala.Serializable)partitionPath -> BoxesRunTime.boxToInteger((int)this.getFileCountInPartitionPath(partitionPath)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private String makePartitionPath(Seq<String> partitionNames, Seq<String> partitionValues, boolean hiveStylePartitioning) {
        if (hiveStylePartitioning) {
            return ((TraversableOnce)((TraversableLike)partitionNames.zip(partitionValues, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return new StringBuilder(1).append(name).append("=").append(value).toString();
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom())).mkString("/");
        }
        return partitionValues.mkString("/");
    }

    public static final /* synthetic */ void $anonfun$getSparkSessionExtensionsInjector$1(SparkSessionExtensions receiver) {
        new HoodieSparkSessionExtension().apply(receiver);
    }

    private static final Seq getDistinctCommitTimeFromAllFilesInIndex$1(Seq files) {
        return (Seq)((SeqLike)((TraversableLike)((TraversableLike)files.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.files(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)fileStatus -> new HoodieBaseFile(fileStatus.getPath().toString()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getCommitTime(), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    public static final /* synthetic */ Tuple3 $anonfun$testIndexRefreshesFileSlices$4(Random r$1, int i) {
        return new Tuple3((Object)r$1.nextString(1000), (Object)BoxesRunTime.boxToInteger((int)r$1.nextInt(5)), (Object)r$1.nextString(1000));
    }

    public static final /* synthetic */ Tuple3 $anonfun$testIndexRefreshesFileSlices$5(Random r$1, int i) {
        return new Tuple3((Object)r$1.nextString(1000), (Object)BoxesRunTime.boxToInteger((int)i), (Object)r$1.nextString(1000));
    }

    public static final /* synthetic */ Tuple6 $anonfun$testPartitionPruneWithMultiplePartitionColumns$1(int i) {
        return new Tuple6((Object)BoxesRunTime.boxToInteger((int)i), (Object)new StringBuilder(1).append("a").append(i).toString(), (Object)BoxesRunTime.boxToInteger((int)(10 + i)), (Object)BoxesRunTime.boxToInteger((int)10000), (Object)new StringBuilder(9).append("2021-03-0").append(i % 2 + 1).toString(), (Object)"10");
    }

    public static final /* synthetic */ Tuple6 $anonfun$testPartitionPruneWithMultiplePartitionColumns$2(int i) {
        return new Tuple6((Object)BoxesRunTime.boxToInteger((int)i), (Object)new StringBuilder(1).append("a").append(i).toString(), (Object)BoxesRunTime.boxToInteger((int)(10 + i)), (Object)BoxesRunTime.boxToInteger((int)(100 * i + 10000)), (Object)new StringBuilder(9).append("2021/03/0").append(i % 2 + 1).toString(), (Object)"10");
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionPruneWithMultiplePartitionColumns$4(PartitionDirectory x$10) {
        return x$10.values().numFields() == 0;
    }

    public static final /* synthetic */ Tuple6 $anonfun$testPartitionPruneWithMultiplePartitionColumns$6(int i) {
        return new Tuple6((Object)BoxesRunTime.boxToInteger((int)i), (Object)new StringBuilder(1).append("a").append(i).toString(), (Object)BoxesRunTime.boxToInteger((int)(10 + i)), (Object)BoxesRunTime.boxToInteger((int)(100 * i + 10000)), (Object)new StringBuilder(9).append("2021/03/0").append(i % 2 + 1).toString(), (Object)"10");
    }

    public static final /* synthetic */ Tuple8 $anonfun$testPartitionPruneWithMultiplePartitionColumnsWithComplexExpression$1(int i) {
        return new Tuple8((Object)BoxesRunTime.boxToInteger((int)i), (Object)new StringBuilder(1).append("a").append(i).toString(), (Object)BoxesRunTime.boxToInteger((int)(10 + i)), (Object)BoxesRunTime.boxToInteger((int)10000), (Object)"default", (Object)new StringBuilder(9).append("2021-03-0").append(i % 2 + 1).toString(), (Object)BoxesRunTime.boxToInteger((int)(i % 6 + 1)), (Object)(i % 2 == 0 ? "CN" : "SG"));
    }

    public static final /* synthetic */ Tuple6 $anonfun$testFileListingPartitionPrefixAnalysis$1(int i) {
        return new Tuple6((Object)BoxesRunTime.boxToInteger((int)i), (Object)new StringBuilder(1).append("a").append(i).toString(), (Object)BoxesRunTime.boxToInteger((int)(10 + i)), (Object)BoxesRunTime.boxToInteger((int)10000), (Object)new StringBuilder(9).append("2021/03/0").append(i % 2 + 1).toString(), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)(i % 3))));
    }

    public static final /* synthetic */ Tuple5 $anonfun$testFileListingWithPartitionPrefixPruning$1(int i) {
        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)i), (Object)new StringBuilder(1).append("a").append(i).toString(), (Object)BoxesRunTime.boxToInteger((int)(10 + i)), (Object)new StringBuilder(0).append(i < 50 ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)2)).append(new StringOps(Predef$.MODULE$.augmentString("0")).$times(i % 3)).toString(), (Object)new StringBuilder(9).append("2023/01/0").append(i % 2 + 1).toString());
    }

    public static final /* synthetic */ void $anonfun$testFileListingWithPartitionPrefixPruning$2(TestHoodieFileIndex $this, HoodieFileIndex fileIndex$2, Dataset readDF$1, Tuple4 testCase) {
        Seq partitionAndFilesAfterPruning = fileIndex$2.listFiles((Seq)testCase._1(), (Seq)Nil$.MODULE$);
        Assertions.assertEquals((int)1, (int)partitionAndFilesAfterPruning.size());
        Tuple2 tuple2 = ((GenericTraversableTemplate)partitionAndFilesAfterPruning.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PartitionDirectory partitionDirectory = x0$1;
            if (partitionDirectory != null) {
                InternalRow values = partitionDirectory.values();
                Seq files = partitionDirectory.files();
                return new Tuple2((Object)values.toSeq((Seq)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$)), (Object)files);
            }
            throw new MatchError((Object)partitionDirectory);
        }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionValuesSeq = (Seq)tuple2._1();
        Seq perPartitionFilesSeq = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionValuesSeq, (Object)perPartitionFilesSeq);
        Seq partitionValuesSeq2 = (Seq)tuple22._1();
        Seq perPartitionFilesSeq2 = (Seq)tuple22._2();
        Seq partitionPaths = (Seq)((SeqLike)((SeqLike)((TraversableLike)perPartitionFilesSeq2.flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)file -> $this.extractPartitionPathFromFilePath(new StoragePath(file.getPath().toUri())), Seq$.MODULE$.canBuildFrom())).distinct()).sorted((Ordering)Ordering.String$.MODULE$);
        Seq expectedPartitionPaths = BoxesRunTime.unboxToBoolean((Object)testCase._3()) ? (Seq)((TraversableLike)testCase._4()).map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(1).append((String)e._1()).append("/").append(e._2()).toString(), Seq$.MODULE$.canBuildFrom()) : (Seq)((SeqLike)((SeqLike)fileIndex$2.allBaseFiles().map((Function1 & Serializable & scala.Serializable)file -> $this.extractPartitionPathFromFilePath(file.getPath()), Seq$.MODULE$.canBuildFrom())).distinct()).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertEquals((Object)expectedPartitionPaths, (Object)partitionPaths);
        Assertions.assertEquals((Object)testCase._4(), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readDF$1.filter((String)testCase._2()).select("region_code", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dt"})).distinct().collect())).map((Function1 & Serializable & scala.Serializable)row -> new Tuple2((Object)row.getString(0), (Object)row.getString(1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$)))).toSeq());
    }

    public static final /* synthetic */ Tuple4 $anonfun$testDataSkippingWhileFileListing$1(Random r$2, int i) {
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)(1000 - i)), (Object)r$2.nextString(5), (Object)BoxesRunTime.boxToInteger((int)r$2.nextInt(4)));
    }

    private final /* synthetic */ TestHoodieFileIndex$TestCase$2$ TestCase$lzycompute$1(LazyRef TestCase$module$1) {
        TestHoodieFileIndex$TestCase$2$ testHoodieFileIndex$TestCase$2$;
        LazyRef lazyRef = TestCase$module$1;
        synchronized (lazyRef) {
            testHoodieFileIndex$TestCase$2$ = TestCase$module$1.initialized() ? (TestHoodieFileIndex$TestCase$2$)((Object)TestCase$module$1.value()) : (TestHoodieFileIndex$TestCase$2$)((Object)TestCase$module$1.initialize((Object)new TestHoodieFileIndex$TestCase$2$(this)));
        }
        return testHoodieFileIndex$TestCase$2$;
    }

    private final TestHoodieFileIndex$TestCase$2$ TestCase$3(LazyRef TestCase$module$1) {
        if (TestCase$module$1.initialized()) {
            return (TestHoodieFileIndex$TestCase$2$)((Object)TestCase$module$1.value());
        }
        return this.TestCase$lzycompute$1(TestCase$module$1);
    }

    public static final /* synthetic */ void $anonfun$testDataSkippingWhileFileListing$2(TestHoodieFileIndex $this, TestCase.1 testCase) {
        scala.collection.immutable.Map readMetadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)Boolean.toString(testCase.enableMetadata())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)Boolean.toString(testCase.enableColumnStats())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)"true")}));
        scala.collection.immutable.Map props = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)$this.protected$basePath($this)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key()), (Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)Boolean.toString(testCase.enableMetadata())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)Boolean.toString(testCase.enableDataSkipping())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COLUMN_STATS_INDEX_PROCESSING_MODE_OVERRIDE.key()), (Object)testCase.columnStatsProcessingModeOverride())}))).$plus$plus((GenTraversableOnce)readMetadataOpts);
        HoodieFileIndex fileIndex = new HoodieFileIndex($this.spark(), $this.protected$metaClient($this), Option$.MODULE$.empty(), props, (FileStatusCache)NoopCache$.MODULE$, HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        Seq allFilesPartitions = fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        Assertions.assertEquals((int)10, (int)((PartitionDirectory)allFilesPartitions.head()).files().length());
        if (testCase.enableDataSkipping() && testCase.enableMetadata()) {
            String x$1 = "id";
            IntegerType$ x$2 = IntegerType$.MODULE$;
            boolean x$3 = false;
            Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
            EqualTo dataFilter = new EqualTo((Expression)new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)));
            Seq filteredPartitions = fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$));
            Assertions.assertEquals((int)1, (int)((PartitionDirectory)filteredPartitions.head()).files().length());
            return;
        }
    }

    public TestHoodieFileIndex() {
        ScalaAssertionSupport.$init$(this);
        this.commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
        this.queryOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_HOODIE_FILE_INDEX().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key()), (Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL())}));
    }
}

