/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.TimeZone;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.HoodieSparkWriterTestBase;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.MatchError;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00192Aa\u0001\u0003\u0001\u0017!)\u0001\u0003\u0001C\u0001#!)1\u0003\u0001C\u0001)\tYB+Z:u\u0011>|G-[3Ta\u0006\u00148nU9m/JLG/\u001a:Vi\u000eT!!\u0002\u0004\u0002\t!,H-\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u000f\u001b\u0005!\u0011BA\b\u0005\u0005eAun\u001c3jKN\u0003\u0018M]6Xe&$XM\u001d+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005\u0011\u0002CA\u0007\u0001\u0003!\"Xm\u001d;J]N,'\u000f\u001e#bi\u0006\u001cX\r^,ji\"$\u0016.\\3mS:,G+[7fu>tW-\u0016+D)\u0005)\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"\u0001B+oSRD#A\u0001\u000f\u0011\u0005u!S\"\u0001\u0010\u000b\u0005}\u0001\u0013aA1qS*\u0011\u0011EI\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0019\u0003\"A\u0003kk:LG/\u0003\u0002&=\t!A+Z:u\u0001")
public class TestHoodieSparkSqlWriterUtc
extends HoodieSparkWriterTestBase {
    @Test
    public void testInsertDatasetWithTimelineTimezoneUTC() {
        TimeZone defaultTimezone = TimeZone.getDefault();
        try {
            Map fooTableModifier = this.commonTableModifier().updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key(), (Object)"false").updated((Object)HoodieTableConfig.TIMELINE_TIMEZONE.key(), (Object)"UTC");
            Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
            StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
            List<Row> records = DataSourceTestUtils.generateRandomRows(100);
            Seq<Row> recordsSeq = this.convertRowListToSeq(records);
            SparkContext qual$1 = this.sc();
            Seq<Row> x$1 = recordsSeq;
            int x$2 = qual$1.parallelize$default$2();
            Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
            Instant beforeWriteInstant = Instant.now();
            TimeZone.setDefault(TimeZone.getTimeZone("Asia/Novosibirsk"));
            Tuple6 tuple6 = HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
            if (tuple6 == null) {
                throw new MatchError((Object)tuple6);
            }
            boolean success = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
            Option writeInstantTimeOpt = (Option)tuple6._2();
            HoodieTableConfig hoodieTableConfig = (HoodieTableConfig)tuple6._6();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)success), (Object)writeInstantTimeOpt, (Object)hoodieTableConfig);
            boolean success2 = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
            Option writeInstantTimeOpt2 = (Option)tuple3._2();
            HoodieTableConfig hoodieTableConfig2 = (HoodieTableConfig)tuple3._3();
            Assertions.assertTrue((boolean)success2);
            HoodieTimelineTimeZone hoodieTableTimelineTimezone = HoodieTimelineTimeZone.valueOf((String)hoodieTableConfig2.getString(HoodieTableConfig.TIMELINE_TIMEZONE));
            Assertions.assertEquals((Object)hoodieTableTimelineTimezone, (Object)HoodieTimelineTimeZone.UTC);
            DateTimeFormatter utcFormatter = new DateTimeFormatterBuilder().appendPattern("yyyyMMddHHmmss").appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter().withZone(ZoneId.of("UTC"));
            Instant writeInstant = Instant.from(utcFormatter.parse((CharSequence)writeInstantTimeOpt2.get()));
            Assertions.assertTrue((beforeWriteInstant.toEpochMilli() < writeInstant.toEpochMilli() ? 1 : 0) != 0, (String)new StringBuilder(111).append("writeInstant(").append(writeInstant.toEpochMilli()).append(") must always be greater than beforeWriteInstant(").append(beforeWriteInstant.toEpochMilli()).append(") if writeInstant was generated with UTC timezone").toString());
        }
        finally {
            TimeZone.setDefault(defaultTimezone);
        }
    }
}

