/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.List;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.HoodieSparkWriterTestBase;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001%4A!\u0002\u0004\u0001\u001b!)!\u0003\u0001C\u0001'!)Q\u0003\u0001C\u0001-!)\u0001\u0006\u0001C\u0001S!)Q\u000b\u0001C\u0001-\n\u0019C+Z:u)\u0006\u0014G.Z*dQ\u0016l\u0017MU3t_24XM],ji\"\u001c\u0006/\u0019:l'Fc%BA\u0004\t\u0003\u0011AW\u000fZ5\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\tI\u0002j\\8eS\u0016\u001c\u0006/\u0019:l/JLG/\u001a:UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tA\u0003\u0005\u0002\u0010\u0001\u00051C/Z:u)\u0006\u0014G.Z*dQ\u0016l\u0017MU3t_24XM]%o\u001b\u0016$\u0018\rZ1uCR\u000b'\r\\3\u0015\u0003]\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011A!\u00168ji\"\u0012!A\b\t\u0003?\u0019j\u0011\u0001\t\u0006\u0003C\t\n1!\u00199j\u0015\t\u0019C%A\u0004kkBLG/\u001a:\u000b\u0005\u0015R\u0011!\u00026v]&$\u0018BA\u0014!\u0005\u0011!Vm\u001d;\u0002/Q,7\u000f\u001e+bE2,7k\u00195f[\u0006\u0014Vm]8mm\u0016\u0014HcA\f+o!)1f\u0001a\u0001Y\u0005IA/\u00192mKRK\b/\u001a\t\u0003[Qr!A\f\u001a\u0011\u0005=JR\"\u0001\u0019\u000b\u0005Eb\u0011A\u0002\u001fs_>$h(\u0003\u000243\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019\u0014\u0004C\u00039\u0007\u0001\u0007A&\u0001\bcCN,g)\u001b7f\r>\u0014X.\u0019;)\t\rQ$i\u0011\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\n\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003\u007f\t\na\u0001]1sC6\u001c\u0018BA!=\u0005%\u00195O^*pkJ\u001cW-A\u0003wC2,X\r\f\u0004E\r\"SEJT\u0011\u0002\u000b\u0006)2i\u0014)Z?>sul\u0016*J)\u0016c\u0003/\u0019:rk\u0016$\u0018%A$\u0002#\r{\u0005+W0P\u001d~;&+\u0013+FY=\u00148-I\u0001J\u0003M\u0019u\nU-`\u001f:{vKU%U\u000b2Bg-\u001b7fC\u0005Y\u0015!F'F%\u001e+ul\u0014(`%\u0016\u000bE\t\f9beF,X\r^\u0011\u0002\u001b\u0006\tR*\u0012*H\u000b~{ej\u0018*F\u0003\u0012csN]2\"\u0003=\u000b1#T#S\u000f\u0016{vJT0S\u000b\u0006#E\u0006\u001b4jY\u0016D#aA)\u0011\u0005I\u001bV\"\u0001 \n\u0005Qs$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006q2o\u00195f[\u00064\u0016\r\\;bi&|gNQ1tK\u0012|e\u000eR1uC\u001aKG.\u001a\u000b\u0004/]\u000b\u0007\"\u0002-\u0005\u0001\u0004I\u0016AC7fi\u0006\u001cE.[3oiB\u0011!lX\u0007\u00027*\u0011A,X\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003=\u001a\taaY8n[>t\u0017B\u00011\\\u0005UAun\u001c3jKR\u000b'\r\\3NKR\f7\t\\5f]RDQA\u0019\u0003A\u00021\nAb]2iK6\f7\u000b\u001e:j]\u001eDC\u0001\u00013COB\u0011q$Z\u0005\u0003M\u0002\u00121\u0001V1hC\u0005A\u0017A\u00034v]\u000e$\u0018n\u001c8bY\u0002")
public class TestTableSchemaResolverWithSparkSQL
extends HoodieSparkWriterTestBase {
    @Test
    public void testTableSchemaResolverInMetadataTable() {
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        String tableName = this.hoodieFooTableName();
        Map fooTableModifier = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)((Object)this.tempPath().toAbsolutePath()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.avro.schema"), (Object)schema.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.SimpleKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.metadata.compact.max.delta.commits"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.ALLOW_OPERATION_METADATA_FIELD.key()), (Object)"true")}));
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        List<Row> records = DataSourceTestUtils.generateRandomRows(10);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$1 = this.sc();
        Seq<Row> x$1 = recordsSeq;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df1 = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, fooTableModifier, df1, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df1, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        String metadataTablePath = new StringBuilder(17).append(((Object)this.tempPath().toAbsolutePath()).toString()).append("/.hoodie/metadata").toString();
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)metadataTablePath);
        Optional latestInstant = metaClient.getActiveTimeline().getCommitsTimeline().getReverseOrderedInstants().findFirst();
        InstantFileNameGenerator instantFileNameGenerator = metaClient.getTimelineLayout().getInstantFileNameGenerator();
        Path path = new Path(new StringBuilder(8).append(metadataTablePath).append("/.hoodie").toString(), instantFileNameGenerator.getFileName((HoodieInstant)latestInstant.get()));
        FileSystem fs = path.getFileSystem(new Configuration());
        fs.delete(path, false);
        this.schemaValuationBasedOnDataFile(metaClient, HoodieMetadataRecord.getClassSchema().toString());
    }

    @ParameterizedTest
    @CsvSource(value={"COPY_ON_WRITE,parquet", "COPY_ON_WRITE,orc", "COPY_ON_WRITE,hfile", "MERGE_ON_READ,parquet", "MERGE_ON_READ,orc", "MERGE_ON_READ,hfile"})
    public void testTableSchemaResolver(String tableType, String baseFileFormat) {
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        String tableName = this.hoodieFooTableName();
        Map fooTableModifier = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)((Object)this.tempPath().toAbsolutePath()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.BASE_FILE_FORMAT.key()), (Object)baseFileFormat), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.avro.schema"), (Object)schema.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.SimpleKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.ALLOW_OPERATION_METADATA_FIELD.key()), (Object)"true")}));
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        List<Row> records = DataSourceTestUtils.generateRandomRows(10);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$1 = this.sc();
        Seq<Row> x$1 = recordsSeq;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df1 = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, fooTableModifier, df1, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)((Object)this.tempPath().toAbsolutePath()).toString());
        Assertions.assertTrue((boolean)new TableSchemaResolver(metaClient).hasOperationField());
        this.schemaValuationBasedOnDataFile(metaClient, schema.toString());
    }

    public void schemaValuationBasedOnDataFile(HoodieTableMetaClient metaClient, String schemaString) {
        metaClient.reloadActiveTimeline();
        Exception tableSchemaResolverParsingException = null;
        try {
            Schema schemaFromData = new TableSchemaResolver(metaClient).getTableAvroSchemaFromDataFile();
            StructType structFromData = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(HoodieAvroUtils.removeMetadataFields((Schema)schemaFromData));
            Schema schemeDesign = new Schema.Parser().parse(schemaString);
            StructType structDesign = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schemeDesign);
            Assertions.assertEquals((Object)structFromData, (Object)structDesign);
        }
        catch (Exception e) {
            tableSchemaResolverParsingException = e;
        }
        Predef$.MODULE$.assert(tableSchemaResolverParsingException == null);
    }
}

