/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.SparkFileFormatInternalRowReaderContext;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.read.CustomPayloadForTesting;
import org.apache.hudi.common.table.read.TestHoodieFileGroupReaderBase;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.spark.HoodieSparkKryoRegistrar$;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieInternalRowUtils$;
import org.apache.spark.sql.HoodieUnsafeUtils$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.execution.datasources.parquet.SparkParquetReader;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001\u0002\t\u0012\u0001yAQ!\r\u0001\u0005\u0002IB\u0011B\u000b\u0001A\u0002\u0003\u0007I\u0011\u0001\u001b\t\u0013e\u0002\u0001\u0019!a\u0001\n\u0003Q\u0004\"C\"\u0001\u0001\u0004\u0005\t\u0015)\u00036\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015\t\u0006\u0001\"\u0001F\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u00159\b\u0001\"\u0011y\u0011\u001d\t\t\u0003\u0001C!\u0003GAq!a\u0017\u0001\t\u0003\ni\u0006\u0003\u0004\u0002\u0002\u0002!\te\u001b\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u0019\t\t\n\u0001C\u0001\u000b\"9\u0011\u0011\u0013\u0001\u0005\n\u0005m%\u0001\t+fgRDun\u001c3jK\u001aKG.Z$s_V\u0004(+Z1eKJ|en\u00159be.T!AE\n\u0002\tI,\u0017\r\u001a\u0006\u0003)U\tQ\u0001^1cY\u0016T!AF\f\u0002\r\r|W.\\8o\u0015\tA\u0012$\u0001\u0003ik\u0012L'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001?5\u00022\u0001I\u0011$\u001b\u0005\t\u0012B\u0001\u0012\u0012\u0005u!Vm\u001d;I_>$\u0017.\u001a$jY\u0016<%o\\;q%\u0016\fG-\u001a:CCN,\u0007C\u0001\u0013,\u001b\u0005)#B\u0001\u0014(\u0003!\u0019\u0017\r^1msN$(B\u0001\u0015*\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Ue\tQa\u001d9be.L!\u0001L\u0013\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\t\u0003]=j\u0011aF\u0005\u0003a]\u00111c\u00159be.\fE-\u00199uKJ\u001cV\u000f\u001d9peR\fa\u0001P5oSRtD#A\u001a\u0011\u0005\u0001\u0002Q#A\u001b\u0011\u0005Y:T\"A\u0014\n\u0005a:#\u0001D*qCJ\\7+Z:tS>t\u0017!C:qCJ\\w\fJ3r)\tY\u0014\t\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0003V]&$\bb\u0002\"\u0004\u0003\u0003\u0005\r!N\u0001\u0004q\u0012\n\u0014AB:qCJ\\\u0007%A\u0003tKR,\b\u000fF\u0001<Q\t)q\t\u0005\u0002I\u001f6\t\u0011J\u0003\u0002K\u0017\u0006\u0019\u0011\r]5\u000b\u00051k\u0015a\u00026va&$XM\u001d\u0006\u0003\u001dn\tQA[;oSRL!\u0001U%\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hm\\<oQ\t11\u000b\u0005\u0002I)&\u0011Q+\u0013\u0002\n\u0003\u001a$XM]#bG\"\fabZ3u'R|'/Y4f\u0007>tg\rF\u0001Ya\tI\u0016\rE\u0002[;~k\u0011a\u0017\u0006\u00039^\tqa\u001d;pe\u0006<W-\u0003\u0002_7\n!2\u000b^8sC\u001e,7i\u001c8gS\u001e,(/\u0019;j_:\u0004\"\u0001Y1\r\u0001\u0011I!mBA\u0001\u0002\u0003\u0015\ta\u0019\u0002\u0004?\u0012\n\u0014C\u00013h!\taT-\u0003\u0002g{\t9aj\u001c;iS:<\u0007C\u0001\u001fi\u0013\tIWHA\u0002B]f\f1bZ3u\u0005\u0006\u001cX\rU1uQR\tA\u000e\u0005\u0002ni:\u0011aN\u001d\t\u0003_vj\u0011\u0001\u001d\u0006\u0003cv\ta\u0001\u0010:p_Rt\u0014BA:>\u0003\u0019\u0001&/\u001a3fM&\u0011QO\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ml\u0014AF4fi\"{w\u000eZ5f%\u0016\fG-\u001a:D_:$X\r\u001f;\u0015\re|\u00181AA\n!\rQXpI\u0007\u0002w*\u0011A0F\u0001\u0007K:<\u0017N\\3\n\u0005y\\(a\u0005%p_\u0012LWMU3bI\u0016\u00148i\u001c8uKb$\bBBA\u0001\u0013\u0001\u0007A.A\u0005uC\ndW\rU1uQ\"9\u0011QA\u0005A\u0002\u0005\u001d\u0011AC1we>\u001c6\r[3nCB!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000ee\tA!\u0019<s_&!\u0011\u0011CA\u0006\u0005\u0019\u00196\r[3nC\"9\u0011QC\u0005A\u0002\u0005]\u0011aC:u_J\fw-Z\"p]\u001a\u0004D!!\u0007\u0002\u001eA!!,XA\u000e!\r\u0001\u0017Q\u0004\u0003\f\u0003?\t\u0019\"!A\u0001\u0002\u000b\u00051MA\u0002`II\nQbY8n[&$Hk\u001c+bE2,GcB\u001e\u0002&\u00055\u0013\u0011\u000b\u0005\b\u0003OQ\u0001\u0019AA\u0015\u0003)\u0011XmY8sI2K7\u000f\u001e\t\u0007\u0003W\t)$!\u000f\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\tA!\u001e;jY*\u0011\u00111G\u0001\u0005U\u00064\u0018-\u0003\u0003\u00028\u00055\"\u0001\u0002'jgR\u0004D!a\u000f\u0002JA1\u0011QHA\"\u0003\u000fj!!a\u0010\u000b\u0007\u0005\u0005S#A\u0003n_\u0012,G.\u0003\u0003\u0002F\u0005}\"\u0001\u0004%p_\u0012LWMU3d_J$\u0007c\u00011\u0002J\u0011Y\u00111JA\u0013\u0003\u0003\u0005\tQ!\u0001d\u0005\ryFe\r\u0005\u0007\u0003\u001fR\u0001\u0019\u00017\u0002\u0013=\u0004XM]1uS>t\u0007bBA*\u0015\u0001\u0007\u0011QK\u0001\b_B$\u0018n\u001c8t!\u0019\tY#a\u0016mY&!\u0011\u0011LA\u0017\u0005\ri\u0015\r]\u0001\u001bm\u0006d\u0017\u000eZ1uKJ+7m\u001c:eg&sg)\u001b7f\u000fJ|W\u000f\u001d\u000b\fw\u0005}\u00131MA5\u0003[\n9\b\u0003\u0004\u0002b-\u0001\r\u0001\\\u0001\tE\u0006\u001cX\rU1uQ\"9\u0011QM\u0006A\u0002\u0005\u001d\u0014\u0001E1diV\fGNU3d_J$G*[:u!\u0015\tY#!\u000e$\u0011\u001d\tYg\u0003a\u0001\u0003\u000f\taa]2iK6\f\u0007bBA8\u0017\u0001\u0007\u0011\u0011O\u0001\nM&dWm\u00157jG\u0016\u0004B!!\u0010\u0002t%!\u0011QOA \u0005%1\u0015\u000e\\3TY&\u001cW\rC\u0004\u0002z-\u0001\r!a\u001f\u0002\u0017%\u001c8k[5q\u001b\u0016\u0014x-\u001a\t\u0004y\u0005u\u0014bAA@{\t9!i\\8mK\u0006t\u0017\u0001E4fi\u000e+8\u000f^8n!\u0006LHn\\1e\u0003I\t7o]3siJ+7m\u001c:eg\u0016\u000bX/\u00197\u0015\u000fm\n9)!#\u0002\u000e\"9\u00111N\u0007A\u0002\u0005\u001d\u0001BBAF\u001b\u0001\u00071%\u0001\u0005fqB,7\r^3e\u0011\u0019\ty)\u0004a\u0001G\u00051\u0011m\u0019;vC2\fA\u0003^3ti\u001e+Go\u0014:eKJLgn\u001a,bYV,\u0007f\u0001\b\u0002\u0016B\u0019\u0001*a&\n\u0007\u0005e\u0015J\u0001\u0003UKN$HcC\u001e\u0002\u001e\u0006\u0005\u0016QUAT\u0003WCa!a(\u0010\u0001\u0004I\u0018AE:qCJ\\'+Z1eKJ\u001cuN\u001c;fqRDa!a)\u0010\u0001\u0004\u0019\u0013a\u0001:po\"9\u0011QA\bA\u0002\u0005\u001d\u0001BBAU\u001f\u0001\u0007A.\u0001\bpe\u0012,'/\u001b8h\u0007>dW/\u001c8\t\u000f\u00055v\u00021\u0001\u00020\u0006)R\r\u001f9fGR,Gm\u0014:eKJLgn\u001a,bYV,\u0007\u0007BAY\u0003\u007f\u0003b!a-\u0002:\u0006uVBAA[\u0015\u0011\t9,!\r\u0002\t1\fgnZ\u0005\u0005\u0003w\u000b)L\u0001\u0006D_6\u0004\u0018M]1cY\u0016\u00042\u0001YA`\t-\t\t-a+\u0002\u0002\u0003\u0005)\u0011A2\u0003\u0007}#C\u0007")
public class TestHoodieFileGroupReaderOnSpark
extends TestHoodieFileGroupReaderBase<InternalRow>
implements SparkAdapterSupport {
    private SparkSession spark;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    private SparkAdapter sparkAdapter$lzycompute() {
        TestHoodieFileGroupReaderOnSpark testHoodieFileGroupReaderOnSpark = this;
        synchronized (testHoodieFileGroupReaderOnSpark) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @BeforeEach
    public void setup() {
        SparkConf sparkConf = new SparkConf();
        sparkConf.set("spark.app.name", this.getClass().getName());
        sparkConf.set("spark.master", "local[8]");
        sparkConf.set("spark.default.parallelism", "4");
        sparkConf.set("spark.sql.shuffle.partitions", "4");
        sparkConf.set("spark.driver.maxResultSize", "2g");
        sparkConf.set("spark.hadoop.mapred.output.compress", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "org.apache.hadoop.io.compress.GzipCodec");
        sparkConf.set("spark.hadoop.mapred.output.compression.type", "BLOCK");
        sparkConf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        sparkConf.set("spark.kryo.registrator", "org.apache.spark.HoodieSparkKryoRegistrar");
        sparkConf.set("spark.sql.extensions", "org.apache.spark.sql.hudi.HoodieSparkSessionExtension");
        sparkConf.set("spark.sql.parquet.enableVectorizedReader", "false");
        HoodieSparkKryoRegistrar$.MODULE$.register(sparkConf);
        this.spark_$eq(SparkSession$.MODULE$.builder().config(sparkConf).getOrCreate());
    }

    @AfterEach
    public void teardown() {
        if (this.spark() != null) {
            this.spark().stop();
            return;
        }
    }

    public StorageConfiguration<?> getStorageConf() {
        return HoodieTestUtils.getDefaultStorageConf().getInline();
    }

    public String getBasePath() {
        return this.tempDir.toAbsolutePath().toUri().toString();
    }

    public HoodieReaderContext<InternalRow> getHoodieReaderContext(String tablePath, Schema avroSchema, StorageConfiguration<?> storageConf) {
        SparkParquetReader reader = this.sparkAdapter().createParquetFileReader(false, this.spark().sessionState().conf(), Predef$.MODULE$.Map().empty(), (Configuration)storageConf.unwrapAs(Configuration.class));
        return new SparkFileFormatInternalRowReaderContext(reader, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
    }

    public void commitToTable(List<HoodieRecord<?>> recordList, String operation, java.util.Map<String, String> options) {
        List recs = RawTripTestPayload.recordsToStrings(recordList);
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(recs).asScala()).toList(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.write().format("hudi").options(options).option("hoodie.compact.inline", "false").option("hoodie.datasource.write.operation", operation).option("hoodie.datasource.write.table.type", "MERGE_ON_READ").mode(operation.equalsIgnoreCase(WriteOperationType.INSERT.value()) ? SaveMode.Overwrite : SaveMode.Append).save(this.getBasePath());
    }

    public void validateRecordsInFileGroup(String basePath, List<InternalRow> actualRecordList, Schema schema, FileSlice fileSlice, boolean isSkipMerge) {
        if (!isSkipMerge || fileSlice.getLogFiles().count() < 2L) {
            Dataset expectedDf = this.spark().read().format("hudi").option(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key(), "false").option(HoodieReaderConfig.MERGE_TYPE.key(), isSkipMerge ? "skip_merge" : "payload_combine").load(basePath).where(functions$.MODULE$.col(HoodieRecord.FILENAME_METADATA_FIELD).contains((Object)fileSlice.getFileId()));
            Assertions.assertEquals((long)expectedDf.count(), (long)actualRecordList.size());
            Dataset actualDf = HoodieUnsafeUtils$.MODULE$.createDataFrameFromInternalRows(this.spark(), ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(actualRecordList).asScala()).toSeq(), HoodieInternalRowUtils$.MODULE$.getCachedSchema(schema));
            Assertions.assertEquals((long)0L, (long)expectedDf.except(actualDf).count());
            Assertions.assertEquals((long)0L, (long)actualDf.except(expectedDf).count());
            return;
        }
    }

    public String getCustomPayload() {
        return CustomPayloadForTesting.class.getName();
    }

    public void assertRecordsEqual(Schema schema, InternalRow expected, InternalRow actual) {
        Assertions.assertEquals((int)expected.numFields(), (int)actual.numFields());
        StructType expectedStruct = (StructType)this.sparkAdapter().getAvroSchemaConverters().toSqlType(schema)._1();
        ((IterableLike)expected.toSeq(expectedStruct).zip((GenIterable)actual.toSeq(expectedStruct), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)converted -> {
            TestHoodieFileGroupReaderOnSpark.$anonfun$assertRecordsEqual$1(converted);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetOrderingValue() {
        SparkParquetReader reader = (SparkParquetReader)Mockito.mock(SparkParquetReader.class);
        SparkFileFormatInternalRowReaderContext sparkReaderContext = new SparkFileFormatInternalRowReaderContext(reader, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        String orderingFieldName = "col2";
        Schema avroSchema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"test\",\"namespace\": \"org.apache.hudi\",\"fields\": [{\"name\": \"col1\", \"type\": \"string\" },{\"name\": \"col2\", \"type\": \"long\" },{ \"name\": \"col3\", \"type\": [\"null\", \"string\"], \"default\": null}]}");
        InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"item", BoxesRunTime.boxToLong((long)1000L), "blue"}));
        scala.collection.immutable.Map metadataMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"_2"), (Object)BoxesRunTime.boxToLong((long)100L))}));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), (Object)sparkReaderContext.getOrderingValue(Option.empty(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)metadataMap).asJava(), avroSchema, Option.of((Object)orderingFieldName)));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)sparkReaderContext.getOrderingValue(Option.empty(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).asJava(), avroSchema, Option.of((Object)orderingFieldName)));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)sparkReaderContext.getOrderingValue(Option.of((Object)row), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).asJava(), avroSchema, Option.empty()));
        this.testGetOrderingValue((HoodieReaderContext<InternalRow>)sparkReaderContext, row, avroSchema, orderingFieldName, Predef$.MODULE$.long2Long(1000L));
        this.testGetOrderingValue((HoodieReaderContext<InternalRow>)sparkReaderContext, row, avroSchema, "col3", (Comparable<?>)UTF8String.fromString((String)"blue"));
        this.testGetOrderingValue((HoodieReaderContext<InternalRow>)sparkReaderContext, row, avroSchema, "non_existent_col", Predef$.MODULE$.int2Integer(0));
    }

    private void testGetOrderingValue(HoodieReaderContext<InternalRow> sparkReaderContext, InternalRow row, Schema avroSchema, String orderingColumn, Comparable<?> expectedOrderingValue) {
        HashMap metadataMap = new HashMap();
        Assertions.assertEquals(expectedOrderingValue, (Object)sparkReaderContext.getOrderingValue(Option.of((Object)row), metadataMap, avroSchema, Option.of((Object)orderingColumn)));
        Assertions.assertEquals(expectedOrderingValue, metadataMap.get("_2"));
    }

    public static final /* synthetic */ void $anonfun$assertRecordsEqual$1(Tuple2 converted) {
        Assertions.assertEquals((Object)converted._1(), (Object)converted._2());
    }

    public TestHoodieFileGroupReaderOnSpark() {
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
    }
}

