/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.util.Map;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.functional.TestBootstrapReadBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@Tag(value="functional")
public class TestBootstrapRead
extends TestBootstrapReadBase {
    private static Stream<Arguments> testArgs() {
        boolean fullTest = false;
        Stream.Builder<Arguments> b = Stream.builder();
        if (fullTest) {
            String[] bootstrapType = new String[]{"full", "metadata", "mixed"};
            Boolean[] dashPartitions = new Boolean[]{true, false};
            HoodieTableType[] tableType = new HoodieTableType[]{HoodieTableType.COPY_ON_WRITE, HoodieTableType.MERGE_ON_READ};
            Integer[] nPartitions = new Integer[]{0, 1, 2};
            for (HoodieTableType tt : tableType) {
                for (Boolean dash : dashPartitions) {
                    for (String bt : bootstrapType) {
                        for (Integer n : nPartitions) {
                            if ((bt.equals("mixed") || !dash.booleanValue()) && n <= 0) continue;
                            b.add(Arguments.of((Object[])new Object[]{bt, dash, tt, n}));
                        }
                    }
                }
            }
        } else {
            b.add(Arguments.of((Object[])new Object[]{"metadata", true, HoodieTableType.COPY_ON_WRITE, 0}));
            b.add(Arguments.of((Object[])new Object[]{"mixed", false, HoodieTableType.MERGE_ON_READ, 2}));
        }
        return b.build();
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testBootstrapFunctional(String bootstrapType, Boolean dashPartitions, HoodieTableType tableType, Integer nPartitions) {
        this.bootstrapType = bootstrapType;
        this.dashPartitions = dashPartitions;
        this.tableType = tableType;
        this.nPartitions = nPartitions;
        this.setupDirs();
        Map<String, String> options = this.setBootstrapOptions();
        Dataset bootstrapDf = this.sparkSession.emptyDataFrame();
        bootstrapDf.write().format("hudi").options(options).mode(SaveMode.Overwrite).save(this.bootstrapTargetPath);
        this.compareTables();
        this.verifyMetaColOnlyRead(0);
        options = this.basicOptions();
        this.doUpdate(options, "001");
        this.compareTables();
        this.verifyMetaColOnlyRead(1);
        this.doInsert(options, "002");
        this.compareTables();
        this.verifyMetaColOnlyRead(2);
    }
}

