/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.hudi.avro.model.DecimalWrapper;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SpillableMapUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieCreateHandle;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.io.storage.HoodieSeekingFileReader;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieMetadataWriteUtils;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestColStatsRecordWithMetadataRecord
extends HoodieSparkClientTestHarness {
    private static final Logger LOG = LoggerFactory.getLogger(TestColStatsRecordWithMetadataRecord.class);

    @BeforeEach
    public void setUp() throws Exception {
        this.initSparkContexts("TestHoodieCreateHandle");
        this.initPath();
        this.initHoodieStorage();
        this.initTestDataGenerator();
        this.initMetaClient();
        this.initTimelineService();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupResources();
    }

    @Test
    public void testColsStatsSerDe() throws Exception {
        AtomicInteger counter;
        Random random = new Random();
        HoodieWriteConfig cfg = this.getConfig();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);){
            this.writeData(client, InProcessTimeGenerator.createNewInstantTime(), 100, false);
        }
        String fileName = "file.parquet";
        String targetColNamePrefix = "col";
        ArrayList<Object> minMaxValues = new ArrayList<Object>();
        minMaxValues.add(Pair.of((Object)"abcdec", (Object)"zyxwvu"));
        minMaxValues.add(Pair.of((Object)new Utf8(StringUtils.getUTF8Bytes((String)"abcdec")), (Object)new Utf8(StringUtils.getUTF8Bytes((String)"zyxwvu"))));
        minMaxValues.add(Pair.of((Object)new Integer(-1000), (Object)new Integer(999999)));
        minMaxValues.add(Pair.of((Object)new Long(-100000L), (Object)Long.MAX_VALUE));
        minMaxValues.add(Pair.of((Object)false, (Object)true));
        minMaxValues.add(Pair.of((Object)new Double(0.123), (Object)new Double(10.123)));
        minMaxValues.add(Pair.of((Object)new Float(0.0123), (Object)new Float(200.123)));
        minMaxValues.add(Pair.of((Object)new Date(36000000L), (Object)new Date(216000000L)));
        minMaxValues.add(Pair.of((Object)LocalDate.ofEpochDay(36000000L), (Object)LocalDate.ofEpochDay(216000000L)));
        minMaxValues.add(Pair.of((Object)new Timestamp(36000000L), (Object)new Timestamp(216000000L)));
        minMaxValues.add(this.generateRandomMinMaxValue(random, (Functions.Function1<Random, Comparable>)(Functions.Function1 & Serializable)random1 -> new Timestamp(random1.nextInt(1000) * 60 * 60 * 1000)));
        byte[] bytes1 = new byte[10];
        byte[] bytes2 = new byte[10];
        random.nextBytes(bytes1);
        random.nextBytes(bytes2);
        ByteBuffer val1ByteBuffer = ByteBuffer.wrap(bytes1);
        ByteBuffer val2ByteBuffer = ByteBuffer.wrap(bytes2);
        ByteBuffer minValue = val1ByteBuffer;
        ByteBuffer maxValue = val2ByteBuffer;
        if (val1ByteBuffer.compareTo(val2ByteBuffer) >= 0) {
            minValue = val2ByteBuffer;
            maxValue = val1ByteBuffer;
        }
        minMaxValues.add(Pair.of((Object)minValue, (Object)maxValue));
        BigDecimal val1 = new BigDecimal(String.format(Locale.ENGLISH, "%5f", Float.valueOf(random.nextFloat())));
        BigDecimal val2 = new BigDecimal(String.format(Locale.ENGLISH, "%5f", Float.valueOf(random.nextFloat())));
        if (val1.compareTo(val2) > 0) {
            minMaxValues.add(Pair.of((Object)val2, (Object)val1));
        } else {
            minMaxValues.add(Pair.of((Object)val1, (Object)val2));
        }
        ArrayList columnRangeMetadata = new ArrayList();
        AtomicInteger finalCounter1 = counter = new AtomicInteger();
        minMaxValues.forEach(entry -> columnRangeMetadata.add(HoodieColumnRangeMetadata.create((String)fileName, (String)(targetColNamePrefix + "_" + finalCounter1.getAndIncrement()), (Comparable)((Comparable)entry.getKey()), (Comparable)((Comparable)entry.getValue()), (long)5L, (long)1000L, (long)123456L, (long)123456L)));
        List<HoodieRecord> columnStatsRecords = HoodieMetadataPayload.createColumnStatsRecords((String)"p1", columnRangeMetadata, (boolean)false).map(record -> record).collect(Collectors.toList());
        Collections.sort(columnStatsRecords, new Comparator<HoodieRecord<HoodieMetadataPayload>>(){

            @Override
            public int compare(HoodieRecord<HoodieMetadataPayload> o1, HoodieRecord<HoodieMetadataPayload> o2) {
                return o1.getRecordKey().compareTo(o2.getRecordKey());
            }
        });
        List expectedColumnStatsRecords = HoodieMetadataPayload.createColumnStatsRecords((String)"p1", columnRangeMetadata, (boolean)false).map(record -> record).collect(Collectors.toList());
        Collections.sort(expectedColumnStatsRecords, new Comparator<HoodieRecord<HoodieMetadataPayload>>(){

            @Override
            public int compare(HoodieRecord<HoodieMetadataPayload> o1, HoodieRecord<HoodieMetadataPayload> o2) {
                return o1.getRecordKey().compareTo(o2.getRecordKey());
            }
        });
        HoodieWriteConfig mdtWriteConfig = HoodieMetadataWriteUtils.createMetadataWriteConfig((HoodieWriteConfig)cfg, (HoodieFailedWritesCleaningPolicy)HoodieFailedWritesCleaningPolicy.EAGER);
        HoodieTableMetaClient mdtMetaClient = HoodieTableMetaClient.builder().setBasePath(mdtWriteConfig.getBasePath()).setConf(this.context.getStorageConf().newInstance()).build();
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)mdtWriteConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)mdtMetaClient);
        String newCommitTime = InProcessTimeGenerator.createNewInstantTime();
        HoodieCreateHandle handle = new HoodieCreateHandle(mdtWriteConfig, newCommitTime, (HoodieTable)table, MetadataPartitionType.COLUMN_STATS.getPartitionPath(), "col-stats-00001-0", (TaskContextSupplier)new PhoneyTaskContextSupplier());
        Schema writeSchema = new Schema.Parser().parse(mdtWriteConfig.getSchema());
        TypedProperties properties = new TypedProperties();
        columnStatsRecords.forEach(record -> handle.write(record, writeSchema, properties));
        WriteStatus writeStatus = (WriteStatus)handle.close().get(0);
        String filePath = writeStatus.getStat().getPath();
        StoragePath baseFilePath = new StoragePath(mdtMetaClient.getBasePath() + "/" + filePath);
        HoodieSeekingFileReader baseFileReader = (HoodieSeekingFileReader)HoodieIOFactory.getIOFactory((HoodieStorage)mdtMetaClient.getStorage()).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER, baseFilePath);
        ClosableIterator itr = baseFileReader.getRecordIterator();
        ArrayList<HoodieRecord> allRecords = new ArrayList<HoodieRecord>();
        while (itr.hasNext()) {
            GenericRecord genericRecord = (GenericRecord)((HoodieRecord)itr.next()).getData();
            HoodieRecord mdtRec = SpillableMapUtils.convertToHoodieRecordPayload((GenericRecord)genericRecord, (String)mdtWriteConfig.getPayloadClass(), (String)mdtWriteConfig.getPreCombineField(), (Pair)Pair.of((Object)mdtMetaClient.getTableConfig().getRecordKeyFieldProp(), (Object)mdtMetaClient.getTableConfig().getPartitionFieldProp()), (boolean)false, (Option)Option.of((Object)MetadataPartitionType.COLUMN_STATS.getPartitionPath()), (Option)Option.empty());
            allRecords.add(mdtRec);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)columnStatsRecords.size(), (int)allRecords.size());
        AtomicInteger finalCounter = counter = new AtomicInteger(0);
        allRecords.forEach(record -> {
            HoodieMetadataColumnStats actualColStatsMetadata = (HoodieMetadataColumnStats)((HoodieMetadataPayload)record.getData()).getColumnStatMetadata().get();
            HoodieMetadataColumnStats expectedColStatsMetadata = (HoodieMetadataColumnStats)((HoodieMetadataPayload)((HoodieRecord)expectedColumnStatsRecords.get(finalCounter.getAndIncrement())).getData()).getColumnStatMetadata().get();
            LOG.info("Validating " + expectedColStatsMetadata.getColumnName() + ", " + expectedColStatsMetadata.getMinValue().getClass().getSimpleName());
            if (expectedColStatsMetadata.getMinValue().getClass().getSimpleName().equals(DecimalWrapper.class.getSimpleName())) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)expectedColStatsMetadata.getMinValue().toString(), (Object)actualColStatsMetadata.getMinValue().toString());
                org.junit.jupiter.api.Assertions.assertEquals((Object)expectedColStatsMetadata.getMaxValue().toString(), (Object)actualColStatsMetadata.getMaxValue().toString());
            } else {
                org.junit.jupiter.api.Assertions.assertEquals((Object)expectedColStatsMetadata.getMinValue(), (Object)actualColStatsMetadata.getMinValue());
                org.junit.jupiter.api.Assertions.assertEquals((Object)expectedColStatsMetadata.getMaxValue(), (Object)actualColStatsMetadata.getMaxValue());
            }
        });
    }

    @Test
    public void testColsStatsMergeString() throws Exception {
        this.generateNColStatsEntriesAndValidateMerge((Functions.Function1<Random, Comparable>)(Functions.Function1 & Serializable)random -> {
            byte[] bytes = new byte[10];
            random.nextBytes(bytes);
            return new String(bytes, Charset.forName("UTF-8"));
        });
    }

    @Test
    public void testColsStatsMergeInt() throws Exception {
        this.generateNColStatsEntriesAndValidateMerge((Functions.Function1<Random, Comparable>)(Functions.Function1 & Serializable)random -> Integer.valueOf(random.nextInt()));
    }

    @Test
    public void testColsStatsMergeLong() throws Exception {
        this.generateNColStatsEntriesAndValidateMerge((Functions.Function1<Random, Comparable>)(Functions.Function1 & Serializable)random -> Long.valueOf(random.nextLong()));
    }

    @Test
    public void testColsStatsMergeDouble() throws Exception {
        this.generateNColStatsEntriesAndValidateMerge((Functions.Function1<Random, Comparable>)(Functions.Function1 & Serializable)random -> Double.valueOf(random.nextDouble()));
    }

    @Test
    public void testColsStatsMergeBoolean() throws Exception {
        this.generateNColStatsEntriesAndValidateMerge((Functions.Function1<Random, Comparable>)(Functions.Function1 & Serializable)random -> Boolean.valueOf(random.nextBoolean()));
    }

    @Test
    public void testColsStatsMergeFloat() throws Exception {
        this.generateNColStatsEntriesAndValidateMerge((Functions.Function1<Random, Comparable>)(Functions.Function1 & Serializable)random -> Float.valueOf(random.nextFloat()));
    }

    @Test
    public void testColsStatsMergeBytes() throws Exception {
        this.generateNColStatsEntriesAndValidateMerge((Functions.Function1<Random, Comparable>)(Functions.Function1 & Serializable)random -> {
            byte[] bytes = new byte[20];
            random.nextBytes(bytes);
            return ByteBuffer.wrap(bytes);
        });
    }

    @Test
    public void testColsStatsMergeDate() throws Exception {
        this.generateNColStatsEntriesAndValidateMerge((Functions.Function1<Random, Comparable>)(Functions.Function1 & Serializable)random -> new Date(random.nextInt(100) * 60 * 60 * 1000));
    }

    @Test
    public void testColsStatsMergeLocalDate() throws Exception {
        this.generateNColStatsEntriesAndValidateMerge((Functions.Function1<Random, Comparable>)(Functions.Function1 & Serializable)random -> LocalDate.ofEpochDay(random.nextInt(100) * 60 * 60 * 1000));
    }

    @Test
    public void testColsStatsMergeLocalTimestamp() throws Exception {
        this.generateNColStatsEntriesAndValidateMerge((Functions.Function1<Random, Comparable>)(Functions.Function1 & Serializable)random -> new Timestamp(random.nextInt(1000) * 60 * 60 * 1000));
    }

    @Test
    public void testColsStatsMergeBigDecimal() throws Exception {
        this.generateNColStatsEntriesAndValidateMerge((Functions.Function1<Random, Comparable>)(Functions.Function1 & Serializable)random -> new BigDecimal(String.format(Locale.ENGLISH, "%5f", Float.valueOf(random.nextFloat()))));
    }

    @Test
    public void testGetColumnRangeInPartition() {
        String relativePartitionPath = "relativePartitionPath";
        String fileName = "file1";
        String colName = "colA";
        long nullCount = 10L;
        long valueCount = 100L;
        long totalSize = 10000L;
        long totalUncompressedSize = 1000L;
        HoodieColumnRangeMetadata aIntegerVal = HoodieColumnRangeMetadata.create((String)fileName, (String)colName, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(1000), (long)nullCount, (long)valueCount, (long)totalSize, (long)totalUncompressedSize);
        HoodieColumnRangeMetadata bIntegerVal = HoodieColumnRangeMetadata.create((String)fileName, (String)colName, (Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(10000), (long)nullCount, (long)valueCount, (long)totalSize, (long)totalUncompressedSize);
        HoodieColumnRangeMetadata aLongVal = HoodieColumnRangeMetadata.create((String)fileName, (String)colName, (Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1000L), (long)nullCount, (long)valueCount, (long)totalSize, (long)totalUncompressedSize);
        HoodieColumnRangeMetadata bLongVal = HoodieColumnRangeMetadata.create((String)fileName, (String)colName, (Comparable)Long.valueOf(-1L), (Comparable)Long.valueOf(10000L), (long)nullCount, (long)valueCount, (long)totalSize, (long)totalUncompressedSize);
        HoodieColumnRangeMetadata aFloatVal = HoodieColumnRangeMetadata.create((String)fileName, (String)colName, (Comparable)new Float(1.0f), (Comparable)new Float(1000.0), (long)nullCount, (long)valueCount, (long)totalSize, (long)totalUncompressedSize);
        HoodieColumnRangeMetadata bFloatVal = HoodieColumnRangeMetadata.create((String)fileName, (String)colName, (Comparable)new Float(-1.0), (Comparable)new Float(10000.0), (long)nullCount, (long)valueCount, (long)totalSize, (long)totalUncompressedSize);
        HoodieColumnRangeMetadata aDoubleVal = HoodieColumnRangeMetadata.create((String)fileName, (String)colName, (Comparable)new Double(0.1), (Comparable)new Double(1000.0), (long)nullCount, (long)valueCount, (long)totalSize, (long)totalUncompressedSize);
        HoodieColumnRangeMetadata bDoubleVal = HoodieColumnRangeMetadata.create((String)fileName, (String)colName, (Comparable)new Double(-1.0), (Comparable)new Double(10000.0), (long)nullCount, (long)valueCount, (long)totalSize, (long)totalUncompressedSize);
        HoodieColumnRangeMetadata aStringVal = HoodieColumnRangeMetadata.create((String)fileName, (String)colName, (Comparable)((Object)new String("1")), (Comparable)((Object)new String("1000")), (long)nullCount, (long)valueCount, (long)totalSize, (long)totalUncompressedSize);
        HoodieColumnRangeMetadata bStringVal = HoodieColumnRangeMetadata.create((String)fileName, (String)colName, (Comparable)((Object)new String("-1")), (Comparable)((Object)new String("10000")), (long)nullCount, (long)valueCount, (long)totalSize, (long)totalUncompressedSize);
        HoodieColumnRangeMetadata actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aIntegerVal, (HoodieColumnRangeMetadata<Comparable>)bIntegerVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.INT);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)-1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)10000);
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aIntegerVal, (HoodieColumnRangeMetadata<Comparable>)bLongVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.INT);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)-1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)10000);
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aIntegerVal, (HoodieColumnRangeMetadata<Comparable>)bFloatVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.INT);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)-1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)10000);
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aIntegerVal, (HoodieColumnRangeMetadata<Comparable>)bDoubleVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.INT);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)-1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)10000);
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aIntegerVal, (HoodieColumnRangeMetadata<Comparable>)bStringVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.INT);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)-1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)10000);
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aLongVal, (HoodieColumnRangeMetadata<Comparable>)bLongVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.LONG);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)-1L);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)10000L);
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aLongVal, (HoodieColumnRangeMetadata<Comparable>)bIntegerVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.LONG);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)-1L);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)10000L);
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aLongVal, (HoodieColumnRangeMetadata<Comparable>)bFloatVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.LONG);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)-1L);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)10000L);
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aLongVal, (HoodieColumnRangeMetadata<Comparable>)bDoubleVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.LONG);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)-1L);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)10000L);
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aLongVal, (HoodieColumnRangeMetadata<Comparable>)bStringVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.LONG);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)-1L);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)10000L);
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aFloatVal, (HoodieColumnRangeMetadata<Comparable>)bFloatVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.FLOAT);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)new Float(-1.0f));
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)new Float(10000.0f));
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aFloatVal, (HoodieColumnRangeMetadata<Comparable>)bIntegerVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.FLOAT);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)new Float(-1.0f));
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)new Float(10000.0f));
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aFloatVal, (HoodieColumnRangeMetadata<Comparable>)bLongVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.FLOAT);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)new Float(-1.0f));
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)new Float(10000.0f));
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aFloatVal, (HoodieColumnRangeMetadata<Comparable>)bStringVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.FLOAT);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)new Float(-1.0f));
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)new Float(10000.0f));
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aDoubleVal, (HoodieColumnRangeMetadata<Comparable>)bDoubleVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.DOUBLE);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)new Double(-1.0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)new Double(10000.0));
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aDoubleVal, (HoodieColumnRangeMetadata<Comparable>)bIntegerVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.DOUBLE);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)new Double(-1.0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)new Double(10000.0));
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aDoubleVal, (HoodieColumnRangeMetadata<Comparable>)bLongVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.DOUBLE);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMinValue(), (Object)new Double(-1.0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getMaxValue(), (Object)new Double(10000.0));
        actualColumnRange = this.mergeAndAssert((HoodieColumnRangeMetadata<Comparable>)aDoubleVal, (HoodieColumnRangeMetadata<Comparable>)bStringVal, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize, Schema.Type.DOUBLE);
        org.junit.jupiter.api.Assertions.assertTrue((actualColumnRange.getMinValue().compareTo(new Double(-1.0)) == 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((actualColumnRange.getMaxValue().compareTo(new Double(10000.0)) == 0 ? 1 : 0) != 0);
    }

    private HoodieColumnRangeMetadata mergeAndAssert(HoodieColumnRangeMetadata<Comparable> aVal, HoodieColumnRangeMetadata<Comparable> bVal, String relativePartitionPath, String colName, long nullCount, long totalSize, long totalUncompressedSize, Schema.Type schemaType) {
        ArrayList<HoodieColumnRangeMetadata<Comparable>> fileColumnRanges = new ArrayList<HoodieColumnRangeMetadata<Comparable>>();
        fileColumnRanges.add(aVal);
        fileColumnRanges.add(bVal);
        HashMap<String, Schema> colsToIndexSchemaMap = new HashMap<String, Schema>();
        colsToIndexSchemaMap.put(colName, Schema.create((Schema.Type)schemaType));
        HoodieColumnRangeMetadata actualColumnRange = FileFormatUtils.getColumnRangeInPartition((String)relativePartitionPath, fileColumnRanges, colsToIndexSchemaMap);
        this.validateColumnRangeMetadata(actualColumnRange, relativePartitionPath, colName, nullCount, totalSize, totalUncompressedSize);
        return actualColumnRange;
    }

    private void validateColumnRangeMetadata(HoodieColumnRangeMetadata actualColumnRange, String relativePartitionPath, String colName, long nullCount, long totalSize, long totalUncompressedSize) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getFilePath(), (Object)relativePartitionPath);
        org.junit.jupiter.api.Assertions.assertEquals((Object)actualColumnRange.getColumnName(), (Object)colName);
        org.junit.jupiter.api.Assertions.assertEquals((long)actualColumnRange.getNullCount(), (long)(nullCount * 2L));
        org.junit.jupiter.api.Assertions.assertEquals((long)actualColumnRange.getTotalSize(), (long)(totalSize * 2L));
        org.junit.jupiter.api.Assertions.assertEquals((long)actualColumnRange.getTotalUncompressedSize(), (long)(totalUncompressedSize * 2L));
    }

    private void generateNColStatsEntriesAndValidateMerge(Functions.Function1<Random, Comparable> randomValueGenFunc) {
        String fileName = "abc.parquet";
        String colName = "colName";
        Random random = new Random();
        ArrayList<Pair> minMaxValues = new ArrayList<Pair>();
        ArrayList<Comparable> allMinValues = new ArrayList<Comparable>();
        ArrayList<Comparable> allMaxValues = new ArrayList<Comparable>();
        for (int i = 0; i < 50; ++i) {
            Pair<Comparable, Comparable> minMaxValue = this.generateRandomMinMaxValue(random, randomValueGenFunc);
            minMaxValues.add(Pair.of((Object)minMaxValue.getKey(), (Object)minMaxValue.getValue()));
            allMinValues.add((Comparable)minMaxValue.getKey());
            allMaxValues.add((Comparable)minMaxValue.getValue());
        }
        ArrayList columnRangeMetadata = new ArrayList();
        minMaxValues.forEach(entry -> columnRangeMetadata.add(HoodieColumnRangeMetadata.create((String)fileName, (String)colName, (Comparable)((Comparable)entry.getKey()), (Comparable)((Comparable)entry.getValue()), (long)5L, (long)1000L, (long)123456L, (long)123456L)));
        HoodieColumnRangeMetadata mergedColStatsRangeMetadata = (HoodieColumnRangeMetadata)columnRangeMetadata.stream().reduce((left, right) -> HoodieColumnRangeMetadata.merge((HoodieColumnRangeMetadata)left, (HoodieColumnRangeMetadata)right)).get();
        Comparable finalMin = this.getExpectedMinValue(allMinValues);
        Comparable finalMax = this.getExpectedMaxValue(allMaxValues);
        org.junit.jupiter.api.Assertions.assertEquals((Object)finalMin, (Object)mergedColStatsRangeMetadata.getMinValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)finalMax, (Object)mergedColStatsRangeMetadata.getMaxValue());
    }

    private Comparable getExpectedMinValue(List<Comparable> allValues) {
        return (Comparable)allValues.stream().reduce((left, right) -> {
            if (left.compareTo(right) < 0) {
                return left;
            }
            return right;
        }).get();
    }

    private Comparable getExpectedMaxValue(List<Comparable> allValues) {
        return (Comparable)allValues.stream().reduce((left, right) -> {
            if (left.compareTo(right) >= 0) {
                return left;
            }
            return right;
        }).get();
    }

    private Pair<Comparable, Comparable> generateRandomMinMaxValue(Random random, Functions.Function1<Random, Comparable> randomValueGenFunc) {
        Comparable value2;
        Comparable value1 = (Comparable)randomValueGenFunc.apply((Object)random);
        if (value1.compareTo(value2 = (Comparable)randomValueGenFunc.apply((Object)random)) > 0) {
            return Pair.of((Object)value2, (Object)value1);
        }
        return Pair.of((Object)value1, (Object)value2);
    }

    private List<WriteStatus> writeData(SparkRDDWriteClient client, String instant, int numRecords, boolean doCommit) {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        JavaRDD records = this.jsc.parallelize(this.dataGen.generateInserts(instant, Integer.valueOf(numRecords)), 2);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        client.startCommitWithTime(instant);
        List writeStatuses = client.upsert(records, instant).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        if (doCommit) {
            List writeStats = writeStatuses.stream().map(WriteStatus::getStat).collect(Collectors.toList());
            boolean committed = client.commitStats(instant, writeStats, Option.empty(), this.metaClient.getCommitActionType());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)committed);
        }
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return writeStatuses;
    }

    class PhoneyTaskContextSupplier
    extends TaskContextSupplier {
        PhoneyTaskContextSupplier() {
        }

        public Supplier<Integer> getPartitionIdSupplier() {
            return () -> 1;
        }

        public Supplier<Integer> getStageIdSupplier() {
            return () -> 1;
        }

        public Supplier<Long> getAttemptIdSupplier() {
            return () -> 1L;
        }

        public Option<String> getProperty(EngineProperty prop) {
            return Option.empty();
        }
    }
}

