/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.DefaultSparkRecordMerger;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.bootstrap.SparkParquetBootstrapDataProvider;
import org.apache.hudi.client.bootstrap.selector.FullRecordBootstrapModeSelector;
import org.apache.hudi.client.bootstrap.selector.MetadataOnlyBootstrapModeSelector;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.TestBootstrap;
import org.apache.hudi.functional.TestDataSourceForBootstrap$;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.EnumSource;
import scala.Function0;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t%g\u0001\u0002\u001c8\u0001\u0001CQa\u0012\u0001\u0005\u0002!C\u0011b\u0013\u0001A\u0002\u0003\u0007I\u0011\u0001'\t\u0013Q\u0003\u0001\u0019!a\u0001\n\u0003)\u0006\"C.\u0001\u0001\u0004\u0005\t\u0015)\u0003N\u0011\u001da\u0006A1A\u0005\u0002uCa\u0001\u001c\u0001!\u0002\u0013q\u0006bB7\u0001\u0005\u0004%\tA\u001c\u0005\u0007{\u0002\u0001\u000b\u0011B8\t\u0013y\u0004\u0001\u0019!a\u0001\n\u0003y\bbCA\u0001\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0007A!\"a\u0002\u0001\u0001\u0004\u0005\t\u0015)\u0003j\u0011)\tI\u0001\u0001a\u0001\u0002\u0004%\ta \u0005\f\u0003\u0017\u0001\u0001\u0019!a\u0001\n\u0003\ti\u0001\u0003\u0006\u0002\u0012\u0001\u0001\r\u0011!Q!\n%D1\"a\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0016!Y\u0011Q\u0005\u0001A\u0002\u0003\u0007I\u0011AA\u0014\u0011-\tY\u0003\u0001a\u0001\u0002\u0003\u0006K!a\u0006\t\u0013\u00055\u0002A1A\u0005\u0002\u0005=\u0002\u0002CA\"\u0001\u0001\u0006I!!\r\t\u0013\u0005\u0015\u0003A1A\u0005\u0002\u0005\u001d\u0003\u0002CA(\u0001\u0001\u0006I!!\u0013\t\u0013\u0005E\u0003A1A\u0005\u0002\u0005\u001d\u0003\u0002CA*\u0001\u0001\u0006I!!\u0013\t\u0011\u0005U\u0003A1A\u0005\u0002}Dq!a\u0016\u0001A\u0003%\u0011\u000e\u0003\u0005\u0002Z\u0001\u0011\r\u0011\"\u0001\u0000\u0011\u001d\tY\u0006\u0001Q\u0001\n%D\u0001\"!\u0018\u0001\u0005\u0004%\ta \u0005\b\u0003?\u0002\u0001\u0015!\u0003j\u0011!\t\t\u0007\u0001b\u0001\n\u0003y\bbBA2\u0001\u0001\u0006I!\u001b\u0005\t\u0003K\u0002!\u0019!C\u0001\u007f\"9\u0011q\r\u0001!\u0002\u0013I\u0007\u0002CA5\u0001\t\u0007I\u0011A@\t\u000f\u0005-\u0004\u0001)A\u0005S\"9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0004bBAU\u0001\u0011\u0005\u00111\u0016\u0005\b\u0003k\u0003A\u0011AAV\u0011\u001d\ty\f\u0001C\u0001\u0003\u0003DqA!\b\u0001\t\u0003\tY\u000bC\u0004\u0003\"\u0001!\t!a+\t\u000f\t\u0015\u0002\u0001\"\u0001\u0003(!9!q\b\u0001\u0005\u0002\u0005-\u0006b\u0002B\"\u0001\u0011\u0005\u00111\u0016\u0005\b\u0005\u000f\u0002A\u0011\u0001B%\u0011%\u00119\u0006AI\u0001\n\u0003\u0011I\u0006C\u0004\u0003p\u0001!\tA!\u001d\t\u000f\t5\u0005\u0001\"\u0001\u0003\u0010\u001e9!1S\u001c\t\u0002\tUeA\u0002\u001c8\u0011\u0003\u00119\n\u0003\u0004He\u0011\u0005!\u0011\u0014\u0005\b\u00057\u0013D\u0011\u0001BO\u0011\u001d\u0011\u0019M\rC\u0001\u0005\u000b\u0014!\u0004V3ti\u0012\u000bG/Y*pkJ\u001cWMR8s\u0005>|Go\u001d;sCBT!\u0001O\u001d\u0002\u0015\u0019,hn\u0019;j_:\fGN\u0003\u0002;w\u0005!\u0001.\u001e3j\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0005C\u0001&\u0001\u001b\u00059\u0014!B:qCJ\\W#A'\u0011\u00059\u0013V\"A(\u000b\u0005A\u000b\u0016aA:rY*\u00111jO\u0005\u0003'>\u0013Ab\u00159be.\u001cVm]:j_:\f\u0011b\u001d9be.|F%Z9\u0015\u0005YK\u0006C\u0001\"X\u0013\tA6I\u0001\u0003V]&$\bb\u0002.\u0004\u0003\u0003\u0005\r!T\u0001\u0004q\u0012\n\u0014AB:qCJ\\\u0007%\u0001\u0006d_6lwN\\(qiN,\u0012A\u0018\t\u0005?\u001aL\u0017N\u0004\u0002aIB\u0011\u0011mQ\u0007\u0002E*\u00111mP\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015\u001c\u0015A\u0002)sK\u0012,g-\u0003\u0002hQ\n\u0019Q*\u00199\u000b\u0005\u0015\u001c\u0005CA0k\u0013\tY\u0007N\u0001\u0004TiJLgnZ\u0001\fG>lWn\u001c8PaR\u001c\b%A\nta\u0006\u00148NU3d_J$G+\u001f9f\u001fB$8/F\u0001p!\u0011\u0001XO\u001e<\u000e\u0003ET!A]:\u0002\u0013%lW.\u001e;bE2,'B\u0001;D\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003OF\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\t1\fgn\u001a\u0006\u0002w\u0006!!.\u0019<b\u0013\tY\u00070\u0001\u000bta\u0006\u00148NU3d_J$G+\u001f9f\u001fB$8\u000fI\u0001\tE\u0006\u001cX\rU1uQV\t\u0011.\u0001\u0007cCN,\u0007+\u0019;i?\u0012*\u0017\u000fF\u0002W\u0003\u000bAqA\u0017\u0006\u0002\u0002\u0003\u0007\u0011.A\u0005cCN,\u0007+\u0019;iA\u000591O]2QCRD\u0017aC:sGB\u000bG\u000f[0%KF$2AVA\b\u0011\u001dQV\"!AA\u0002%\f\u0001b\u001d:d!\u0006$\b\u000eI\u0001\u0003MN,\"!a\u0006\u0011\t\u0005e\u0011\u0011E\u0007\u0003\u00037QA!a\u0005\u0002\u001e)\u0019\u0011qD\u001e\u0002\r!\fGm\\8q\u0013\u0011\t\u0019#a\u0007\u0003\u0015\u0019KG.Z*zgR,W.\u0001\u0004gg~#S-\u001d\u000b\u0004-\u0006%\u0002\u0002\u0003.\u0011\u0003\u0003\u0005\r!a\u0006\u0002\u0007\u0019\u001c\b%\u0001\bqCJ$\u0018\u000e^5p]B\u000bG\u000f[:\u0016\u0005\u0005E\u0002#BA\u001a\u0003{Ig\u0002BA\u001b\u0003sq1!YA\u001c\u0013\u0005!\u0015bAA\u001e\u0007\u00069\u0001/Y2lC\u001e,\u0017\u0002BA \u0003\u0003\u0012A\u0001T5ti*\u0019\u00111H\"\u0002\u001fA\f'\u000f^5uS>t\u0007+\u0019;ig\u0002\n!B\\;n%\u0016\u001cwN\u001d3t+\t\tI\u0005E\u0002C\u0003\u0017J1!!\u0014D\u0005\rIe\u000e^\u0001\f]Vl'+Z2pe\u0012\u001c\b%\u0001\tok6\u0014VmY8sIN,\u0006\u000fZ1uK\u0006\tb.^7SK\u000e|'\u000fZ:Va\u0012\fG/\u001a\u0011\u0002%Y,'/\u001b4jG\u0006$\u0018n\u001c8S_^\\U-_\u0001\u0014m\u0016\u0014\u0018NZ5dCRLwN\u001c*po.+\u0017\u0010I\u0001\u0010m\u0016\u0014\u0018NZ5dCRLwN\\\"pY\u0006\u0001b/\u001a:jM&\u001c\u0017\r^5p]\u000e{G\u000eI\u0001\u0018_JLw-\u001b8bYZ+'/\u001b4jG\u0006$\u0018n\u001c8WC2\f\u0001d\u001c:jO&t\u0017\r\u001c,fe&4\u0017nY1uS>tg+\u00197!\u0003Y)\b\u000fZ1uK\u00124VM]5gS\u000e\fG/[8o-\u0006d\u0017aF;qI\u0006$X\r\u001a,fe&4\u0017nY1uS>tg+\u00197!\u0003QiW\r^1eCR\fwJ\u001c7z'\u0016dWm\u0019;pe\u0006)R.\u001a;bI\u0006$\u0018m\u00148msN+G.Z2u_J\u0004\u0013A\u00054vY2\u0014VmY8sIN+G.Z2u_J\f1CZ;mYJ+7m\u001c:e'\u0016dWm\u0019;pe\u0002\n!\"\u001b8ji&\fG.\u001b>f)\r1\u0016\u0011\u000f\u0005\b\u0003g\"\u0003\u0019AA;\u0003\u001d!X-\u001c9ESJ\u0004B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(\u0001\u0003gS2,'bAA@u\u0006\u0019a.[8\n\t\u0005\r\u0015\u0011\u0010\u0002\u0005!\u0006$\b\u000e\u000b\u0003\u0002r\u0005\u001d\u0005\u0003BAE\u00037k!!a#\u000b\t\u00055\u0015qR\u0001\u0003S>TA!!%\u0002\u0014\u0006\u0019\u0011\r]5\u000b\t\u0005U\u0015qS\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\tI*P\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003;\u000bYIA\u0004UK6\u0004H)\u001b:)\u0007\u0011\n\t\u000b\u0005\u0003\u0002$\u0006\u0015VBAAH\u0013\u0011\t9+a$\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\u00051\u0006fA\u0013\u00020B!\u00111UAY\u0013\u0011\t\u0019,a$\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\n;fgRlU\r^1eCR\f'i\\8ugR\u0014\u0018\r]\"P/:{g\u000eU1si&$\u0018n\u001c8fI\"\u001aa%!/\u0011\t\u0005\r\u00161X\u0005\u0005\u0003{\u000byI\u0001\u0003UKN$\u0018\u0001\f;fgRlU\r^1eCR\f'i\\8ugR\u0014\u0018\r]\"P/\"Kg/Z*us2,\u0007+\u0019:uSRLwN\\3e)\u00151\u00161YAd\u0011\u0019\t)m\na\u0001S\u0006\t\"m\\8ugR\u0014\u0018\r]*fY\u0016\u001cGo\u001c:\t\u000f\u0005%w\u00051\u0001\u0002L\u0006Q!/Z2pe\u0012$\u0016\u0010]3\u0011\t\u00055\u0017q\u001e\b\u0005\u0003\u001f\fIO\u0004\u0003\u0002R\u0006\rh\u0002BAj\u0003?tA!!6\u0002^:!\u0011q[An\u001d\r\t\u0017\u0011\\\u0005\u0002}%\u0011A(P\u0005\u0003umJ1!!9:\u0003\u0019\u0019w.\\7p]&!\u0011Q]At\u0003\u0015iw\u000eZ3m\u0015\r\t\t/O\u0005\u0005\u0003W\fi/\u0001\u0007I_>$\u0017.\u001a*fG>\u0014HM\u0003\u0003\u0002f\u0006\u001d\u0018\u0002BAy\u0003g\u0014\u0001\u0003S8pI&,'+Z2pe\u0012$\u0016\u0010]3\u000b\t\u0005-\u0018Q\u001e\u0015\bO\u0005](q\u0001B\u0005!\u0011\tIPa\u0001\u000e\u0005\u0005m(\u0002BA\u007f\u0003\u007f\f\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0005\u0003\t\u0019*\u0001\u0004qCJ\fWn]\u0005\u0005\u0005\u000b\tYPA\u0005DgZ\u001cv.\u001e:dK\u0006)a/\u00197vK2\"!1\u0002B\bC\t\u0011i!\u0001)pe\u001et\u0013\r]1dQ\u0016t\u0003.\u001e3j]\rd\u0017.\u001a8u]\t|w\u000e^:ue\u0006\u0004hf]3mK\u000e$xN\u001d\u0018NKR\fG-\u0019;b\u001f:d\u0017PQ8piN$(/\u00199N_\u0012,7+\u001a7fGR|'\u000fL!W%>\u000b#A!\u0005\u0002\u001f>\u0014xML1qC\u000eDWM\f5vI&t3\r\\5f]Rt#m\\8ugR\u0014\u0018\r\u001d\u0018tK2,7\r^8s]\u0019+H\u000e\u001c*fG>\u0014HMQ8piN$(/\u00199N_\u0012,7+\u001a7fGR|'\u000fL*Q\u0003J[\u0005fA\u0014\u0003\u0016A!!q\u0003B\r\u001b\t\ty0\u0003\u0003\u0003\u001c\u0005}(!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006\u0019C/Z:u\u001b\u0016$\u0018\rZ1uC\n{w\u000e^:ue\u0006\u00048iT,QCJ$\u0018\u000e^5p]\u0016$\u0007f\u0001\u0015\u0002:\u0006\u0019D/Z:u\u001b\u0016$\u0018\rZ1uC\n{w\u000e^:ue\u0006\u0004Xj\u0014*QCJ$\u0018\u000e^5p]\u0016$\u0017J\u001c7j]\u0016\u001cE.^:uKJLgn\u001a\u0015\u0004S\u0005e\u0016!\u000e;fgRlU\r^1eCR\f'i\\8ugR\u0014\u0018\r]'P%B\u000b'\u000f^5uS>tW\rZ%oY&tWmQ8na\u0006\u001cG/[8o\u001f:$2A\u0016B\u0015\u0011\u001d\tIM\u000ba\u0001\u0003\u0017D3B\u000bB\u0017\u0005\u000f\u0011\u0019D!\u000e\u00038A!\u0011\u0011 B\u0018\u0013\u0011\u0011\t$a?\u0003\u0015\u0015sW/\\*pkJ\u001cWm\t\u0002\u0002L\u0006)a.Y7fg2\u0012!\u0011H\u0011\u0003\u0005w\tA!\u0011,S\u001f\"\u001a!F!\u0006\u0002GQ,7\u000f^'fi\u0006$\u0017\r^1C_>$8\u000f\u001e:ba6{%\u000bU1si&$\u0018n\u001c8fI\"\u001a1&!/\u0002?Q,7\u000f\u001e$vY2\u0014un\u001c;tiJ\f\u0007oQ(X!\u0006\u0014H/\u001b;j_:,G\rK\u0002-\u0003s\u000b1D];o\u0005>|Go\u001d;sCB\fe\u000e\u001a,fe&4\u0017pQ8n[&$HcB5\u0003L\t=#1\u000b\u0005\u0007\u0005\u001bj\u0003\u0019A5\u0002\u0013Q\f'\r\\3UsB,\u0007\u0002\u0003B)[A\u0005\t\u0019\u00010\u0002\u0013\u0015DHO]1PaR\u001c\bB\u0002B+[\u0001\u0007\u0011.\u0001\u000bc_>$8\u000f\u001e:ba.+\u0017pZ3o\u00072\f7o]\u0001&eVt'i\\8ugR\u0014\u0018\r]!oIZ+'/\u001b4z\u0007>lW.\u001b;%I\u00164\u0017-\u001e7uII*\"Aa\u0017+\u0007y\u0013if\u000b\u0002\u0003`A!!\u0011\rB6\u001b\t\u0011\u0019G\u0003\u0003\u0003f\t\u001d\u0014!C;oG\",7m[3e\u0015\r\u0011IgQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B7\u0005G\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m1XM]5gs&s7M]3nK:$\u0018\r\u001c,jK^\u0014Vm];miRYaKa\u001d\u0003x\tm$q\u0010BE\u0011\u0019\u0011)h\fa\u0001S\u0006Q\"m\\8ugR\u0014\u0018\r]\"p[6LG/\u00138ti\u0006tG\u000fV5nK\"1!\u0011P\u0018A\u0002%\fq\u0003\\1uKN$8i\\7nSRLen\u001d;b]R$\u0016.\\3\t\r\tut\u00061\u0001j\u0003u\u0011wn\u001c;tiJ\f\u0007oQ8n[&$8i\\7qY\u0016$\u0018n\u001c8US6,\u0007b\u0002BA_\u0001\u0007!1Q\u0001\u000eSN\u0004\u0016M\u001d;ji&|g.\u001a3\u0011\u0007\t\u0013))C\u0002\u0003\b\u000e\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0003\f>\u0002\rAa!\u0002-%\u001c\b*\u001b<f'RLH.\u001a)beRLG/[8oK\u0012\f\u0011cZ3u%\u0016\u001cwN\u001d3UsB,w\n\u001d;t)\rq&\u0011\u0013\u0005\b\u0003\u0013\u0004\u0004\u0019AAf\u0003i!Vm\u001d;ECR\f7k\\;sG\u00164uN\u001d\"p_R\u001cHO]1q!\tQ%g\u0005\u00023\u0003R\u0011!QS\u0001\u0005g>\u0014H\u000f\u0006\u0003\u0003 \n-\u0006#\u0002(\u0003\"\n\u0015\u0016b\u0001BR\u001f\n9A)\u0019;bg\u0016$\bc\u0001(\u0003(&\u0019!\u0011V(\u0003\u0007I{w\u000fC\u0004\u0003.R\u0002\rAa,\u0002\u0005\u00114\u0007\u0003\u0002BY\u0005{sAAa-\u0003<:!!Q\u0017B]\u001d\u0011\t)Na.\n\u0005-[\u0014B\u0001)R\u0013\r\tYdT\u0005\u0005\u0005\u007f\u0013\tMA\u0005ECR\fgI]1nK*\u0019\u00111H(\u0002\u0019\u0011\u0014x\u000e]'fi\u0006\u001cu\u000e\\:\u0015\t\t=&q\u0019\u0005\b\u0005[+\u0004\u0019\u0001BX\u0001")
public class TestDataSourceForBootstrap {
    private SparkSession spark;
    private final scala.collection.immutable.Map<String, String> commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.DELETE_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.BULKINSERT_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.FINALIZE_WRITE_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieBootstrapConfig.PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"false")}));
    private final scala.collection.immutable.Map<String, String> sparkRecordTypeOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.RECORD_MERGE_IMPL_CLASSES.key()), (Object)DefaultSparkRecordMerger.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT.key()), (Object)"parquet")}));
    private String basePath;
    private String srcPath;
    private FileSystem fs;
    private final List<String> partitionPaths = new .colon.colon((Object)"2020-04-01", (List)new .colon.colon((Object)"2020-04-02", (List)new .colon.colon((Object)"2020-04-03", (List)Nil$.MODULE$)));
    private final int numRecords;
    private final int numRecordsUpdate;
    private final String verificationRowKey;
    private final String verificationCol;
    private final String originalVerificationVal;
    private final String updatedVerificationVal;
    private final String metadataOnlySelector = MetadataOnlyBootstrapModeSelector.class.getCanonicalName();
    private final String fullRecordSelector = FullRecordBootstrapModeSelector.class.getCanonicalName();

    public static Dataset<Row> dropMetaCols(Dataset<Row> dataset) {
        return TestDataSourceForBootstrap$.MODULE$.dropMetaCols(dataset);
    }

    public static Dataset<Row> sort(Dataset<Row> dataset) {
        return TestDataSourceForBootstrap$.MODULE$.sort(dataset);
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public scala.collection.immutable.Map<String, String> sparkRecordTypeOpts() {
        return this.sparkRecordTypeOpts;
    }

    public String basePath() {
        return this.basePath;
    }

    public void basePath_$eq(String x$1) {
        this.basePath = x$1;
    }

    public String srcPath() {
        return this.srcPath;
    }

    public void srcPath_$eq(String x$1) {
        this.srcPath = x$1;
    }

    public FileSystem fs() {
        return this.fs;
    }

    public void fs_$eq(FileSystem x$1) {
        this.fs = x$1;
    }

    public List<String> partitionPaths() {
        return this.partitionPaths;
    }

    public int numRecords() {
        return this.numRecords;
    }

    public int numRecordsUpdate() {
        return this.numRecordsUpdate;
    }

    public String verificationRowKey() {
        return this.verificationRowKey;
    }

    public String verificationCol() {
        return this.verificationCol;
    }

    public String originalVerificationVal() {
        return this.originalVerificationVal;
    }

    public String updatedVerificationVal() {
        return this.updatedVerificationVal;
    }

    public String metadataOnlySelector() {
        return this.metadataOnlySelector;
    }

    public String fullRecordSelector() {
        return this.fullRecordSelector;
    }

    @BeforeEach
    public void initialize(@TempDir java.nio.file.Path tempDir) {
        SparkConf sparkConf = HoodieClientTestUtils.getSparkConfForTest((String)this.getClass().getSimpleName());
        this.spark_$eq(SparkSession$.MODULE$.builder().config(sparkConf).getOrCreate());
        this.basePath_$eq(new StringBuilder(5).append(((Object)tempDir.toAbsolutePath()).toString()).append("/base").toString());
        this.srcPath_$eq(new StringBuilder(4).append(((Object)tempDir.toAbsolutePath()).toString()).append("/src").toString());
        this.fs_$eq(HadoopFSUtils.getFs((String)this.basePath(), (Configuration)this.spark().sparkContext().hadoopConfiguration()));
    }

    @AfterEach
    public void tearDown() {
        if (this.spark() != null) {
            this.spark().stop();
            this.spark_$eq(null);
        }
        if (this.fs() != null) {
            this.fs().close();
            this.fs_$eq(null);
            return;
        }
    }

    @Test
    public void testMetadataBootstrapCOWNonPartitioned() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), Collections.emptyList(), jsc, this.spark().sqlContext());
        sourceDF.write().format("parquet").mode(SaveMode.Overwrite).save(this.srcPath());
        String bootstrapKeygenClass = NonpartitionedKeyGenerator.class.getName();
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)this.commonOpts().$minus((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key());
        String commitInstantTime1 = this.runBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)options.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)bootstrapKeygenClass)}))), bootstrapKeygenClass);
        String commitCompletionTime1 = DataSourceTestUtils.latestCommitCompletionTime(this.fs(), this.basePath());
        Predef$.MODULE$.assert(!this.fs().exists(new Path(this.basePath(), ".hoodie/.temp/00000000000001")));
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((Object)TestDataSourceForBootstrap$.MODULE$.sort(sourceDF).collectAsList(), (Object)TestDataSourceForBootstrap$.MODULE$.sort(TestDataSourceForBootstrap$.MODULE$.dropMetaCols((Dataset<Row>)hoodieROViewDF1)).collectAsList());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((Object)TestDataSourceForBootstrap$.MODULE$.sort(sourceDF).collectAsList(), (Object)TestDataSourceForBootstrap$.MODULE$.sort(TestDataSourceForBootstrap$.MODULE$.dropMetaCols((Dataset<Row>)hoodieROViewDF2)).collectAsList());
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), Collections.emptyList(), jsc, this.spark().sqlContext());
        updateDF.write().format("hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), bootstrapKeygenClass).mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime2 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF3 = this.spark().read().format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF3.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF3.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        Dataset hoodieROViewDF1WithBasePath = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1WithBasePath.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF1WithBasePath.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        this.verifyIncrementalViewResult(commitInstantTime1, commitInstantTime2, commitCompletionTime1, false, true);
    }

    @ParameterizedTest
    @CsvSource(value={"org.apache.hudi.client.bootstrap.selector.MetadataOnlyBootstrapModeSelector,AVRO", "org.apache.hudi.client.bootstrap.selector.FullRecordBootstrapModeSelector,SPARK"})
    public void testMetadataBootstrapCOWHiveStylePartitioned(String bootstrapSelector, HoodieRecord.HoodieRecordType recordType) {
        Dataset<Row> dataset;
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        sourceDF.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"datestr"})).format("parquet").mode(SaveMode.Overwrite).save(this.srcPath());
        scala.collection.immutable.Map readOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"datestr"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieBootstrapConfig.MODE_SELECTOR_CLASS_NAME.key()), (Object)bootstrapSelector)})));
        String commitInstantTime1 = this.runBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)readOpts.$plus$plus(this.getRecordTypeOpts(recordType)), SimpleKeyGenerator.class.getName());
        String commitCompletionTime1 = DataSourceTestUtils.latestCommitCompletionTime(this.fs(), this.basePath());
        Predef$.MODULE$.assert(!this.fs().exists(new Path(this.basePath(), ".hoodie/.temp/00000000000001")));
        String string = bootstrapSelector;
        String string2 = this.metadataOnlySelector();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            dataset = TestDataSourceForBootstrap$.MODULE$.sort(sourceDF);
        } else {
            String string4 = this.fullRecordSelector();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                dataset = TestDataSourceForBootstrap$.MODULE$.sort(sourceDF);
            } else {
                throw new MatchError((Object)string);
            }
        }
        Dataset<Row> expectedDF = dataset;
        Dataset hoodieROViewDF1 = this.spark().read().options((Map)readOpts).format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((Object)expectedDF.collectAsList(), (Object)TestDataSourceForBootstrap$.MODULE$.sort(TestDataSourceForBootstrap$.MODULE$.dropMetaCols((Dataset<Row>)hoodieROViewDF1)).collectAsList());
        Dataset hoodieROViewDF2 = this.spark().read().options((Map)readOpts).format("hudi").load(this.basePath());
        Assertions.assertEquals((Object)expectedDF.collectAsList(), (Object)TestDataSourceForBootstrap$.MODULE$.sort(TestDataSourceForBootstrap$.MODULE$.dropMetaCols((Dataset<Row>)hoodieROViewDF2)).collectAsList());
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        scala.collection.immutable.Map writeOpts = this.commonOpts().$plus$plus(this.getRecordTypeOpts(recordType));
        updateDF.write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "datestr").option(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), "true").mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime2 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF3 = this.spark().read().format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF3.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF3.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        Dataset hoodieROViewDF4 = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF4.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF3.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        this.verifyIncrementalViewResult(commitInstantTime1, commitInstantTime2, commitCompletionTime1, true, true);
    }

    @Test
    public void testMetadataBootstrapCOWPartitioned() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        sourceDF.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"datestr"})).mode(SaveMode.Overwrite).save(this.srcPath());
        scala.collection.immutable.Map writeOpts = this.commonOpts().$plus$plus(this.getRecordTypeOpts(HoodieRecord.HoodieRecordType.AVRO)).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"datestr")})));
        String commitInstantTime1 = this.runBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)writeOpts, SimpleKeyGenerator.class.getName());
        String commitCompletionTime1 = DataSourceTestUtils.latestCommitCompletionTime(this.fs(), this.basePath());
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((Object)TestDataSourceForBootstrap$.MODULE$.sort(sourceDF).collectAsList(), (Object)TestDataSourceForBootstrap$.MODULE$.sort(TestDataSourceForBootstrap$.MODULE$.dropMetaCols((Dataset<Row>)hoodieROViewDF1)).collectAsList());
        Dataset hoodieROViewWithBasePathDF1 = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((Object)TestDataSourceForBootstrap$.MODULE$.sort(sourceDF).collectAsList(), (Object)TestDataSourceForBootstrap$.MODULE$.sort(TestDataSourceForBootstrap$.MODULE$.dropMetaCols((Dataset<Row>)hoodieROViewWithBasePathDF1)).collectAsList());
        Dataset updateDf1 = hoodieROViewDF1.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)this.verificationRowKey())).withColumn(this.verificationCol(), functions$.MODULE$.lit((Object)this.updatedVerificationVal()));
        updateDf1.write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        hoodieROViewDF2.collect();
        Assertions.assertEquals((Object)this.updatedVerificationVal(), (Object)((Row)hoodieROViewDF2.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)this.verificationRowKey())).select(this.verificationCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0));
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF2 = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF2.write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime3 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        Assertions.assertEquals((int)2, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF3 = this.spark().read().format("hudi").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF3.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF3.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        Dataset hoodieROViewDF4 = this.spark().read().format("hudi").load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF4.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF4.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        this.verifyIncrementalViewResult(commitInstantTime1, commitInstantTime3, commitCompletionTime1, true, true);
    }

    @Test
    public void testMetadataBootstrapMORPartitionedInlineClustering() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        sourceDF.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"datestr"})).mode(SaveMode.Overwrite).save(this.srcPath());
        scala.collection.immutable.Map writeOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"datestr")})));
        String commitInstantTime1 = this.runBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)writeOpts, SimpleKeyGenerator.class.getName());
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1.count());
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF.write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(HoodieClusteringConfig.INLINE_CLUSTERING.key(), "true").option(HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS.key(), "1").option(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key(), "datestr").mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)2, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF2.count());
        Dataset hoodieROViewDFWithBasePath = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDFWithBasePath.count());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieRecord.HoodieRecordType.class, names={"AVRO"})
    public void testMetadataBootstrapMORPartitionedInlineCompactionOn(HoodieRecord.HoodieRecordType recordType) {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        sourceDF.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"datestr"})).mode(SaveMode.Overwrite).save(this.srcPath());
        scala.collection.immutable.Map writeOpts = this.commonOpts().$plus$plus(this.getRecordTypeOpts(recordType)).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"datestr")})));
        String commitInstantTime1 = this.runBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)writeOpts, SimpleKeyGenerator.class.getName());
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF1.count());
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF.write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(HoodieCompactionConfig.INLINE_COMPACT.key(), "true").option(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), "1").mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)2, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF2.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF2.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        Dataset hoodieROViewDFWithBasePath = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDFWithBasePath.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDFWithBasePath.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
    }

    @Test
    public void testMetadataBootstrapMORPartitioned() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        sourceDF.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"datestr"})).mode(SaveMode.Overwrite).save(this.srcPath());
        scala.collection.immutable.Map writeOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"datestr")})));
        String commitInstantTime1 = this.runBootstrapAndVerifyCommit(DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL(), (scala.collection.immutable.Map<String, String>)writeOpts, SimpleKeyGenerator.class.getName());
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((Object)TestDataSourceForBootstrap$.MODULE$.sort(sourceDF).collectAsList(), (Object)TestDataSourceForBootstrap$.MODULE$.sort(TestDataSourceForBootstrap$.MODULE$.dropMetaCols((Dataset<Row>)hoodieROViewDF1)).collectAsList());
        Dataset hoodieROViewDFWithBasePath = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(this.basePath());
        Assertions.assertEquals((Object)TestDataSourceForBootstrap$.MODULE$.sort(sourceDF).collectAsList(), (Object)TestDataSourceForBootstrap$.MODULE$.sort(TestDataSourceForBootstrap$.MODULE$.dropMetaCols((Dataset<Row>)hoodieROViewDFWithBasePath)).collectAsList());
        Dataset updateDf1 = hoodieROViewDF1.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)this.verificationRowKey())).withColumn(this.verificationCol(), functions$.MODULE$.lit((Object)this.updatedVerificationVal()));
        updateDf1.write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(this.basePath());
        hoodieROViewDF2.collect();
        Assertions.assertEquals((Object)this.originalVerificationVal(), (Object)((Row)hoodieROViewDF2.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)this.verificationRowKey())).select(this.verificationCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0));
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF2 = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF2.write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)2, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF3 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF3.count());
        Assertions.assertEquals((long)0L, (long)hoodieROViewDF3.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
    }

    @Test
    public void testFullBootstrapCOWPartitioned() {
        long timestamp = Instant.now().toEpochMilli();
        JavaSparkContext jsc = JavaSparkContext$.MODULE$.fromSparkContext(this.spark().sparkContext());
        Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(timestamp, 0, this.numRecords(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        sourceDF.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"datestr"})).mode(SaveMode.Overwrite).save(this.srcPath());
        scala.collection.immutable.Map writeOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"datestr")})));
        Dataset bootstrapDF = this.spark().emptyDataFrame();
        bootstrapDF.write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()).option(HoodieBootstrapConfig.BASE_PATH.key(), this.srcPath()).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), SimpleKeyGenerator.class.getName()).option(HoodieBootstrapConfig.MODE_SELECTOR_CLASS_NAME.key(), FullRecordBootstrapModeSelector.class.getName()).option(HoodieBootstrapConfig.FULL_BOOTSTRAP_INPUT_PROVIDER_CLASS_NAME.key(), SparkParquetBootstrapDataProvider.class.getName()).mode(SaveMode.Overwrite).save(this.basePath());
        String commitInstantTime1 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        String commitInstantCompletionTime1 = DataSourceTestUtils.latestCommitCompletionTime(this.fs(), this.basePath());
        Assertions.assertEquals((Object)"00000000000002", (Object)commitInstantTime1);
        Dataset hoodieROViewDF1 = this.spark().read().format("hudi").option(HoodieBootstrapConfig.DATA_QUERIES_ONLY.key(), "true").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((Object)TestDataSourceForBootstrap$.MODULE$.sort(sourceDF).collectAsList(), (Object)TestDataSourceForBootstrap$.MODULE$.sort(TestDataSourceForBootstrap$.MODULE$.dropMetaCols((Dataset<Row>)hoodieROViewDF1)).collectAsList());
        Dataset hoodieROViewDFWithBasePath = this.spark().read().format("hudi").option(HoodieBootstrapConfig.DATA_QUERIES_ONLY.key(), "true").load(this.basePath());
        Assertions.assertEquals((Object)TestDataSourceForBootstrap$.MODULE$.sort(sourceDF).collectAsList(), (Object)TestDataSourceForBootstrap$.MODULE$.sort(TestDataSourceForBootstrap$.MODULE$.dropMetaCols((Dataset<Row>)hoodieROViewDFWithBasePath)).collectAsList());
        long updateTimestamp = Instant.now().toEpochMilli();
        Dataset<Row> updateDF = TestBootstrap.generateTestRawTripDataset(updateTimestamp, 0, this.numRecordsUpdate(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitionPaths()).asJava(), jsc, this.spark().sqlContext());
        updateDF.write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime2 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)this.fs(), (String)this.basePath(), (String)commitInstantTime1).size());
        Dataset hoodieROViewDF2 = this.spark().read().format("hudi").option(HoodieBootstrapConfig.DATA_QUERIES_ONLY.key(), "true").load(new StringBuilder(2).append(this.basePath()).append("/*").toString());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieROViewDF2.count());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieROViewDF2.filter(new StringBuilder(13).append("timestamp == ").append(updateTimestamp).toString()).count());
        this.verifyIncrementalViewResult(commitInstantTime1, commitInstantTime2, commitInstantCompletionTime1, true, true);
    }

    public String runBootstrapAndVerifyCommit(String tableType, scala.collection.immutable.Map<String, String> extraOpts, String bootstrapKeygenClass) {
        Dataset bootstrapDF = this.spark().emptyDataFrame();
        bootstrapDF.write().format("hudi").options(extraOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType).option(HoodieBootstrapConfig.BASE_PATH.key(), this.srcPath()).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), bootstrapKeygenClass).mode(SaveMode.Overwrite).save(this.basePath());
        String commitInstantTime1 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs(), (String)this.basePath());
        String expectedBootstrapInstant = this.fullRecordSelector().equals(extraOpts.getOrElse((Object)HoodieBootstrapConfig.MODE_SELECTOR_CLASS_NAME.key(), (Function0 & Serializable & scala.Serializable)() -> (String)HoodieBootstrapConfig.MODE_SELECTOR_CLASS_NAME.defaultValue())) ? "00000000000002" : "00000000000001";
        Assertions.assertEquals((Object)expectedBootstrapInstant, (Object)commitInstantTime1);
        return commitInstantTime1;
    }

    public scala.collection.immutable.Map<String, String> runBootstrapAndVerifyCommit$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public void verifyIncrementalViewResult(String bootstrapCommitInstantTime, String latestCommitInstantTime, String bootstrapCommitCompletionTime, boolean isPartitioned, boolean isHiveStylePartitioned) {
        Dataset hoodieIncViewDF1 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), "000").option(DataSourceReadOptions$.MODULE$.END_COMMIT().key(), bootstrapCommitCompletionTime).load(this.basePath());
        Assertions.assertEquals((long)this.numRecords(), (long)hoodieIncViewDF1.count());
        Row[] countsPerCommit = (Row[])hoodieIncViewDF1.groupBy("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
        Assertions.assertEquals((int)1, (int)countsPerCommit.length);
        Assertions.assertEquals((Object)bootstrapCommitInstantTime, (Object)countsPerCommit[0].get(0));
        String startCompletionTime = HoodieInstantTimeGenerator.instantTimePlusMillis((String)bootstrapCommitCompletionTime, (long)1L);
        Dataset hoodieIncViewDF2 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), startCompletionTime).load(this.basePath());
        Assertions.assertEquals((long)this.numRecordsUpdate(), (long)hoodieIncViewDF2.count());
        countsPerCommit = (Row[])hoodieIncViewDF2.groupBy("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
        Assertions.assertEquals((int)1, (int)countsPerCommit.length);
        Assertions.assertEquals((Object)latestCommitInstantTime, (Object)countsPerCommit[0].get(0));
        if (isPartitioned) {
            String relativePartitionPath = isHiveStylePartitioned ? "/datestr=2020-04-02/*" : "/2020-04-02/*";
            Dataset hoodieIncViewDF3 = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), startCompletionTime).option(DataSourceReadOptions$.MODULE$.INCR_PATH_GLOB().key(), relativePartitionPath).load(this.basePath());
            Assertions.assertEquals((long)hoodieIncViewDF2.filter(functions$.MODULE$.col("_hoodie_partition_path").contains((Object)"2020-04-02")).count(), (long)hoodieIncViewDF3.count());
            return;
        }
    }

    public scala.collection.immutable.Map<String, String> getRecordTypeOpts(HoodieRecord.HoodieRecordType recordType) {
        HoodieRecord.HoodieRecordType hoodieRecordType = recordType;
        if (HoodieRecord.HoodieRecordType.SPARK.equals(hoodieRecordType)) {
            return this.sparkRecordTypeOpts();
        }
        return Predef$.MODULE$.Map().empty();
    }

    public TestDataSourceForBootstrap() {
        this.numRecords = 100;
        this.numRecordsUpdate = 10;
        this.verificationRowKey = "trip_0";
        this.verificationCol = "driver";
        this.originalVerificationVal = "driver_0";
        this.updatedVerificationVal = "driver_update";
    }
}

