/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieTimeGeneratorConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimeGenerator;
import org.apache.hudi.common.table.timeline.TimeGenerators;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.testutils.HoodieAdaptablePayloadDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestGlobalIndexEnableUpdatePartitions
extends SparkClientFunctionalTestHarness {
    public SparkConf conf() {
        return this.conf(SparkClientFunctionalTestHarness.getSparkSqlConf());
    }

    private static Stream<Arguments> getTableTypeAndIndexType() {
        return Stream.of(Arguments.of((Object[])new Object[]{HoodieTableType.COPY_ON_WRITE, HoodieIndex.IndexType.GLOBAL_SIMPLE}), Arguments.of((Object[])new Object[]{HoodieTableType.COPY_ON_WRITE, HoodieIndex.IndexType.GLOBAL_BLOOM}), Arguments.of((Object[])new Object[]{HoodieTableType.COPY_ON_WRITE, HoodieIndex.IndexType.RECORD_INDEX}), Arguments.of((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, HoodieIndex.IndexType.GLOBAL_SIMPLE}), Arguments.of((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, HoodieIndex.IndexType.GLOBAL_BLOOM}), Arguments.of((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, HoodieIndex.IndexType.RECORD_INDEX}));
    }

    private static Stream<Arguments> getTableTypeAndIndexTypeUpdateOrDelete() {
        return Stream.of(Arguments.of((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, HoodieIndex.IndexType.RECORD_INDEX, true}), Arguments.of((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, HoodieIndex.IndexType.RECORD_INDEX, false}));
    }

    @ParameterizedTest
    @MethodSource(value={"getTableTypeAndIndexType"})
    public void testPartitionChanges(HoodieTableType tableType, HoodieIndex.IndexType indexType) throws IOException {
        Class<DefaultHoodieRecordPayload> payloadClass = DefaultHoodieRecordPayload.class;
        HoodieWriteConfig writeConfig = this.getWriteConfig(payloadClass, indexType);
        HoodieTableMetaClient metaClient = this.getHoodieMetaClient(tableType, (Properties)writeConfig.getProps());
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(writeConfig);){
            int totalRecords = 4;
            String p1 = "p1";
            String p2 = "p2";
            String p3 = "p3";
            String p4 = "p4";
            String commitTimeAtEpoch0 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)0L);
            List insertsAtEpoch0 = HoodieAdaptablePayloadDataGenerator.getInserts((int)4, (String)"p1", (long)0L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch0);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(insertsAtEpoch0, 2), commitTimeAtEpoch0).collect());
            String commitTimeAtEpoch5 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)5L);
            List updatesAtEpoch5 = HoodieAdaptablePayloadDataGenerator.getUpdates((List)insertsAtEpoch0, (long)5L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch5);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(updatesAtEpoch5, 2), commitTimeAtEpoch5).collect());
            this.readTableAndValidate(metaClient, new int[]{0, 1, 2, 3}, "p1", 5L);
            String commitTimeAtEpoch6 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)6L);
            List updatesAtEpoch6 = HoodieAdaptablePayloadDataGenerator.getUpdates((List)updatesAtEpoch5, (String)"p2", (long)6L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch6);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(updatesAtEpoch6, 2), commitTimeAtEpoch6).collect());
            this.readTableAndValidate(metaClient, new int[]{0, 1, 2, 3}, "p2", 6L);
            String commitTimeAtEpoch7 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)7L);
            List updatesAtEpoch7 = HoodieAdaptablePayloadDataGenerator.getUpdates((List)updatesAtEpoch6, (String)"p3", (long)7L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch7);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(updatesAtEpoch7, 2), commitTimeAtEpoch7).collect());
            this.readTableAndValidate(metaClient, new int[]{0, 1, 2, 3}, "p3", 7L);
            String commitTimeAtEpoch8 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)8L);
            List updatesAtEpoch2 = HoodieAdaptablePayloadDataGenerator.getUpdates((List)insertsAtEpoch0, (String)"p4", (long)2L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch8);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(updatesAtEpoch2, 2), commitTimeAtEpoch8).collect());
            this.readTableAndValidate(metaClient, new int[]{0, 1, 2, 3}, "p3", 7L);
            String commitTimeAtEpoch9 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)9L);
            List updatesAtEpoch9 = HoodieAdaptablePayloadDataGenerator.getUpdates((List)updatesAtEpoch7, (String)"p1", (long)9L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch9);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(updatesAtEpoch9, 2), commitTimeAtEpoch9).collect());
            this.readTableAndValidate(metaClient, new int[]{0, 1, 2, 3}, "p1", 9L);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getTableTypeAndIndexTypeUpdateOrDelete"})
    public void testRollbacksWithPartitionUpdate(HoodieTableType tableType, HoodieIndex.IndexType indexType, boolean isUpsert) throws IOException {
        Class<DefaultHoodieRecordPayload> payloadClass = DefaultHoodieRecordPayload.class;
        HoodieWriteConfig writeConfig = this.getWriteConfig(payloadClass, indexType);
        TimeGenerator timeGenerator = TimeGenerators.getTimeGenerator((HoodieTimeGeneratorConfig)writeConfig.getTimeGeneratorConfig(), (StorageConfiguration)this.storageConf());
        HoodieTableMetaClient metaClient = this.getHoodieMetaClient(tableType, (Properties)writeConfig.getProps());
        int totalRecords = 8;
        String p1 = "p1";
        String p2 = "p2";
        String p3 = "p3";
        List insertsAtEpoch0 = HoodieAdaptablePayloadDataGenerator.getInserts((int)8, (String)"p1", (long)0L, payloadClass);
        List updatesAtEpoch5 = HoodieAdaptablePayloadDataGenerator.getUpdates(insertsAtEpoch0.subList(0, 4), (String)"p2", (long)5L, payloadClass);
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(writeConfig);){
            String commitTimeAtEpoch0 = TimelineUtils.generateInstantTime((boolean)false, (TimeGenerator)timeGenerator);
            client.startCommitWithTime(commitTimeAtEpoch0);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(insertsAtEpoch0, 2), commitTimeAtEpoch0).collect());
            String commitTimeAtEpoch5 = TimelineUtils.generateInstantTime((boolean)false, (TimeGenerator)timeGenerator);
            client.startCommitWithTime(commitTimeAtEpoch5);
            if (isUpsert) {
                Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(updatesAtEpoch5, 2), commitTimeAtEpoch5).collect());
                this.readTableAndValidate(metaClient, new int[]{4, 5, 6, 7}, "p1", 0L);
                this.readTableAndValidate(metaClient, new int[]{0, 1, 2, 3}, "p2", 5L);
            } else {
                Assertions.assertNoWriteErrors((List)client.delete(this.jsc().parallelize(updatesAtEpoch5.stream().map(hoodieRecord -> hoodieRecord.getKey()).collect(Collectors.toList()), 2), commitTimeAtEpoch5).collect());
                this.readTableAndValidate(metaClient, new int[]{4, 5, 6, 7}, "p1", 0L);
                this.readTableAndValidate(metaClient, new int[0], "p2", 0L);
            }
            String latestCompletedDeltaCommit = HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName((HoodieInstant)metaClient.reloadActiveTimeline().getCommitsAndCompactionTimeline().lastInstant().get());
            metaClient.getStorage().deleteFile(new StoragePath(metaClient.getBasePath() + "/.hoodie/timeline/" + latestCompletedDeltaCommit));
        }
        client = this.getHoodieWriteClient(writeConfig);
        var15_15 = null;
        try {
            String commitTimeAtEpoch10 = TimelineUtils.generateInstantTime((boolean)false, (TimeGenerator)timeGenerator);
            client.startCommitWithTime(commitTimeAtEpoch10);
            if (isUpsert) {
                Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(updatesAtEpoch5, 2), commitTimeAtEpoch10).collect());
                this.readTableAndValidate(metaClient, new int[]{4, 5, 6, 7}, "p1", 0L);
                this.readTableAndValidate(metaClient, new int[]{0, 1, 2, 3}, "p2", 5L);
            } else {
                Assertions.assertNoWriteErrors((List)client.delete(this.jsc().parallelize(updatesAtEpoch5.stream().map(hoodieRecord -> hoodieRecord.getKey()).collect(Collectors.toList()), 2), commitTimeAtEpoch10).collect());
                this.readTableAndValidate(metaClient, new int[]{4, 5, 6, 7}, "p1", 0L);
                this.readTableAndValidate(metaClient, new int[0], "p2", 0L);
            }
            String commitTimeAtEpoch15 = TimelineUtils.generateInstantTime((boolean)false, (TimeGenerator)timeGenerator);
            List updatesAtEpoch15 = HoodieAdaptablePayloadDataGenerator.getUpdates((List)updatesAtEpoch5, (String)"p3", (long)15L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch15);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(updatesAtEpoch15, 2), commitTimeAtEpoch15).collect());
            this.readTableAndValidate(metaClient, new int[]{4, 5, 6, 7}, "p1", 0L);
            this.readTableAndValidate(metaClient, new int[]{0, 1, 2, 3}, "p3", 15L);
            String commitTimeAtEpoch20 = TimelineUtils.generateInstantTime((boolean)false, (TimeGenerator)timeGenerator);
            List updatesAtEpoch20 = HoodieAdaptablePayloadDataGenerator.getUpdates(updatesAtEpoch5.subList(0, 2), (String)"p1", (long)20L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch20);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(updatesAtEpoch20, 1), commitTimeAtEpoch20).collect());
            HashMap<String, Long> expectedTsMap = new HashMap<String, Long>();
            Arrays.stream(new int[]{0, 1}).forEach(entry -> expectedTsMap.put(String.valueOf(entry), 20L));
            Arrays.stream(new int[]{4, 5, 6, 7}).forEach(entry -> expectedTsMap.put(String.valueOf(entry), 0L));
            this.readTableAndValidate(metaClient, new int[]{0, 1, 4, 5, 6, 7}, "p1", expectedTsMap);
            this.readTableAndValidate(metaClient, new int[]{2, 3}, "p3", 15L);
        }
        catch (Throwable throwable) {
            var15_15 = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (var15_15 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        var15_15.addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getTableTypeAndIndexType"})
    public void testUpdatePartitionsThenDelete(HoodieTableType tableType, HoodieIndex.IndexType indexType) throws IOException {
        Class<DefaultHoodieRecordPayload> payloadClass = DefaultHoodieRecordPayload.class;
        HoodieWriteConfig writeConfig = this.getWriteConfig(payloadClass, indexType);
        HoodieTableMetaClient metaClient = this.getHoodieMetaClient(tableType, (Properties)writeConfig.getProps());
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(writeConfig);){
            int totalRecords = 4;
            String p1 = "p1";
            String p2 = "p2";
            String commitTimeAtEpoch0 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)0L);
            List insertsAtEpoch0 = HoodieAdaptablePayloadDataGenerator.getInserts((int)4, (String)"p1", (long)0L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch0);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(insertsAtEpoch0, 2), commitTimeAtEpoch0).collect());
            String commitTimeAtEpoch5 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)5L);
            List updatesAtEpoch5 = HoodieAdaptablePayloadDataGenerator.getUpdates((List)insertsAtEpoch0, (long)5L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch5);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(updatesAtEpoch5, 2), commitTimeAtEpoch5).collect());
            this.readTableAndValidate(metaClient, new int[]{0, 1, 2, 3}, "p1", 5L);
            String commitTimeAtEpoch6 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)6L);
            List updatesAtEpoch6 = HoodieAdaptablePayloadDataGenerator.getUpdates((List)updatesAtEpoch5, (String)"p2", (long)6L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch6);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(updatesAtEpoch6, 2), commitTimeAtEpoch6).collect());
            this.readTableAndValidate(metaClient, new int[]{0, 1, 2, 3}, "p2", 6L);
            String commitTimeAtEpoch7 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)7L);
            List deletesAtEpoch7 = HoodieAdaptablePayloadDataGenerator.getDeletesWithNewPartition(insertsAtEpoch0.subList(0, 2), (String)"p2", (long)7L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch7);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(deletesAtEpoch7, 2), commitTimeAtEpoch7).collect());
            this.readTableAndValidate(metaClient, new int[]{2, 3}, "p2", 6L);
            String commitTimeAtEpoch8 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)8L);
            List deletesAtEpoch8 = HoodieAdaptablePayloadDataGenerator.getDeletesWithEmptyPayloadAndNewPartition(insertsAtEpoch0.subList(2, 3), (String)"unknown_pt");
            client.startCommitWithTime(commitTimeAtEpoch8);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(deletesAtEpoch8, 1), commitTimeAtEpoch8).collect());
            this.readTableAndValidate(metaClient, new int[]{3}, "p2", 6L);
            String commitTimeAtEpoch9 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)9L);
            List updatesAtEpoch9 = HoodieAdaptablePayloadDataGenerator.getUpdates((List)insertsAtEpoch0, (String)"p1", (long)9L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch9);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(updatesAtEpoch9, 2), commitTimeAtEpoch9).collect());
            this.readTableAndValidate(metaClient, new int[]{0, 1, 2, 3}, "p1", 9L);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getTableTypeAndIndexType"})
    public void testUdpateSubsetOfRecUpdates(HoodieTableType tableType, HoodieIndex.IndexType indexType) throws IOException {
        Class<DefaultHoodieRecordPayload> payloadClass = DefaultHoodieRecordPayload.class;
        HoodieWriteConfig writeConfig = this.getWriteConfig(payloadClass, indexType);
        HoodieTableMetaClient metaClient = this.getHoodieMetaClient(tableType, (Properties)writeConfig.getProps());
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(writeConfig);){
            int totalRecords = 4;
            String p1 = "p1";
            String p2 = "p2";
            List allInserts = HoodieAdaptablePayloadDataGenerator.getInserts((int)4, (String)"p1", (long)0L, payloadClass);
            String commitTimeAtEpoch0 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)0L);
            client.startCommitWithTime(commitTimeAtEpoch0);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(allInserts.subList(0, 2), 2), commitTimeAtEpoch0).collect());
            this.readTableAndValidate(metaClient, new int[]{0, 1}, "p1", 0L);
            String commitTimeAtEpoch5 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)5L);
            List updatesAtEpoch5 = HoodieAdaptablePayloadDataGenerator.getUpdates(allInserts.subList(0, 3), (long)5L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch5);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(updatesAtEpoch5, 2), commitTimeAtEpoch5).collect());
            this.readTableAndValidate(metaClient, new int[]{0, 1, 2}, "p1", this.getExpectedTsMap(new int[]{0, 1, 2}, new Long[]{5L, 5L, 5L}));
            String commitTimeAtEpoch10 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)10L);
            List updatesAtEpoch10 = HoodieAdaptablePayloadDataGenerator.getUpdates((List)allInserts, (long)10L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch10);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(updatesAtEpoch10, 2), commitTimeAtEpoch10).collect());
            this.readTableAndValidate(metaClient, new int[]{0, 1, 2, 3}, "p1", this.getExpectedTsMap(new int[]{0, 1, 2, 3}, new Long[]{10L, 10L, 10L, 10L}));
            String commitTimeAtEpoch20 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)20L);
            List updatesAtEpoch20 = HoodieAdaptablePayloadDataGenerator.getUpdates((List)allInserts, (String)"p2", (long)20L, payloadClass);
            client.startCommitWithTime(commitTimeAtEpoch20);
            Assertions.assertNoWriteErrors((List)client.upsert(this.jsc().parallelize(updatesAtEpoch20, 2), commitTimeAtEpoch20).collect());
            this.readTableAndValidate(metaClient, new int[]{0, 1, 2, 3}, "p2", 20L);
        }
    }

    private Map<String, Long> getExpectedTsMap(int[] recordKeys, Long[] expectedTses) {
        HashMap<String, Long> expectedTsMap = new HashMap<String, Long>();
        for (int i = 0; i < recordKeys.length; ++i) {
            expectedTsMap.put(String.valueOf(recordKeys[i]), expectedTses[i]);
        }
        return expectedTsMap;
    }

    private void readTableAndValidate(HoodieTableMetaClient metaClient, int[] expectedIds, String expectedPartition, long expectedTs) {
        HashMap<String, Long> expectedTsMap = new HashMap<String, Long>();
        Arrays.stream(expectedIds).forEach(entry -> expectedTsMap.put(String.valueOf(entry), expectedTs));
        this.readTableAndValidate(metaClient, expectedIds, expectedPartition, expectedTsMap);
    }

    private void readTableAndValidate(HoodieTableMetaClient metaClient, int[] expectedIds, String expectedPartition, Map<String, Long> expectedTsMap) {
        Dataset df = this.spark().read().format("hudi").load(metaClient.getBasePath().toString()).sort("id", new String[0]).select("_hoodie_record_key", new String[]{"_hoodie_partition_path", "id", "pt", "ts"}).cache();
        int expectedCount = expectedIds.length;
        Row[] allRows = (Row[])df.filter(String.format("pt = '%s'", expectedPartition)).collect();
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedCount, (int)allRows.length);
        for (int i = 0; i < expectedCount; ++i) {
            int expectedId = expectedIds[i];
            Row r = allRows[i];
            org.junit.jupiter.api.Assertions.assertEquals((Object)String.valueOf(expectedId), (Object)r.getString(0));
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedPartition, (Object)r.getString(1));
            org.junit.jupiter.api.Assertions.assertEquals((int)expectedId, (int)r.getInt(2));
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedPartition, (Object)r.getString(3));
            org.junit.jupiter.api.Assertions.assertEquals((Long)expectedTsMap.get(String.valueOf(expectedId)), (long)r.getLong(4));
        }
        df.unpersist();
    }

    private HoodieWriteConfig getWriteConfig(Class<?> payloadClass, HoodieIndex.IndexType indexType) {
        HoodieMetadataConfig.Builder metadataConfigBuilder = HoodieMetadataConfig.newBuilder();
        if (indexType == HoodieIndex.IndexType.RECORD_INDEX) {
            metadataConfigBuilder.enable(true).withEnableRecordIndex(true);
        } else {
            metadataConfigBuilder.enable(false);
        }
        return this.getConfigBuilder(true).withProperties(HoodieAdaptablePayloadDataGenerator.getKeyGenProps(payloadClass)).withParallelism(2, 2).withBulkInsertParallelism(2).withDeleteParallelism(2).withMetadataConfig(metadataConfigBuilder.build()).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(indexType).bloomIndexParallelism(2).withSimpleIndexParallelism(2).withGlobalSimpleIndexParallelism(2).withGlobalIndexReconcileParallelism(2).withGlobalBloomIndexUpdatePartitionPath(true).withGlobalSimpleIndexUpdatePartitionPath(true).withRecordIndexUpdatePartitionPath(true).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(4).build()).withSchema(HoodieAdaptablePayloadDataGenerator.SCHEMA_STR).withRecordMergeMode(RecordMergeMode.CUSTOM).withRecordMergeStrategyId("00000000-0000-0000-0000-000000000000").withPayloadConfig(HoodiePayloadConfig.newBuilder().fromProperties(HoodieAdaptablePayloadDataGenerator.getPayloadProps(payloadClass)).build()).build();
    }
}

