/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLayoutConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.table.action.commit.SparkBucketIndexPartitioner;
import org.apache.hudi.table.storage.HoodieStorageLayout;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r4A\u0001D\u0007\u0001-!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001a\u0001\n\u0003\u0011\u0003b\u0002\u0016\u0001\u0001\u0004%\ta\u000b\u0005\u0007i\u0001\u0001\u000b\u0015B\u0012\t\u000fU\u0002!\u0019!C\u0001m!1q\t\u0001Q\u0001\n]BQ\u0001\u0013\u0001\u0005B%CQ!\u0016\u0001\u0005B%CQA\u0017\u0001\u0005\u0002%CQa\u0018\u0001\u0005\u0002%CQ!\u0019\u0001\u0005\u0002%\u0013\u0001\u0005V3ti6{%\u000bR1uCN{WO]2f/&$\bNQ;dW\u0016$\u0018J\u001c3fq*\u0011abD\u0001\u000bMVt7\r^5p]\u0006d'B\u0001\t\u0012\u0003\u0011AW\u000fZ5\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u001f\u0005IA/Z:ukRLGn]\u0005\u00039e\u0011\u0011\u0004S8pI&,7\u000b]1sW\u000ec\u0017.\u001a8u)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011!D\u0001\u0006gB\f'o[\u000b\u0002GA\u0011A\u0005K\u0007\u0002K)\u0011aeJ\u0001\u0004gFd'BA\u0011\u0012\u0013\tISE\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0005ta\u0006\u00148n\u0018\u0013fcR\u0011AF\r\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0005+:LG\u000fC\u00044\u0007\u0005\u0005\t\u0019A\u0012\u0002\u0007a$\u0013'\u0001\u0004ta\u0006\u00148\u000eI\u0001\u000bG>lWn\u001c8PaR\u001cX#A\u001c\u0011\tajthP\u0007\u0002s)\u0011!hO\u0001\nS6lW\u000f^1cY\u0016T!\u0001\u0010\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002?s\t\u0019Q*\u00199\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015\u0001\u00027b]\u001eT\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G\u0003\n11\u000b\u001e:j]\u001e\f1bY8n[>tw\n\u001d;tA\u0005)1/\u001a;VaR\tA\u0006\u000b\u0002\b\u0017B\u0011AjU\u0007\u0002\u001b*\u0011ajT\u0001\u0004CBL'B\u0001)R\u0003\u001dQW\u000f]5uKJT!AU\n\u0002\u000b),h.\u001b;\n\u0005Qk%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u000b\u0002\t/B\u0011A\nW\u0005\u000336\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002!Q,7\u000f\u001e#pk\ndW-\u00138tKJ$\bFA\u0005]!\taU,\u0003\u0002_\u001b\n!A+Z:u\u0003a!Xm\u001d;D_VtGoV5uQ\n+8m[3u\u0013:$W\r\u001f\u0015\u0003\u0015q\u000b1\u0003^3ti&s7/\u001a:u\u001fZ,'o\u001e:ji\u0016D#a\u0003/")
public class TestMORDataSourceWithBucketIndex
extends HoodieSparkClientTestBase {
    private SparkSession spark = null;
    private final Map<String, String> commonOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.INDEX_TYPE.key()), (Object)HoodieIndex.IndexType.BUCKET.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.BUCKET_INDEX_NUM_BUCKETS.key()), (Object)"8"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieLayoutConfig.LAYOUT_TYPE.key()), (Object)HoodieStorageLayout.LayoutType.BUCKET.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieLayoutConfig.LAYOUT_PARTITIONER_CLASS_NAME.key()), (Object)SparkBucketIndexPartitioner.class.getName())}));

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    @BeforeEach
    public void setUp() {
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initHoodieStorage();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
    }

    @Test
    public void testDoubleInsert() {
        List records1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((HoodieStorage)this.storage, (String)this.basePath, (String)"000"));
        List records2 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("002", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(this.basePath);
        Assertions.assertEquals((long)200L, (long)hudiSnapshotDF1.count());
    }

    @Test
    public void testCountWithBucketIndex() {
        List records1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((HoodieStorage)this.storage, (String)this.basePath, (String)"000"));
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(this.basePath);
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.count());
        List records2 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(this.basePath);
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF2.count());
        String commit1Time = ((Row)hudiSnapshotDF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        String commit2Time = ((Row)hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0).toString();
        Assertions.assertEquals((long)hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count(), (long)1L);
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(commit2Time)).$greater((Object)commit1Time));
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF2.join(hudiSnapshotDF1, (Seq)new .colon.colon((Object)"_hoodie_record_key", (List)Nil$.MODULE$), "left").count());
        String[] partitionPaths = new String[]{"2020/01/10"};
        HoodieTestDataGenerator newDataGen = new HoodieTestDataGenerator(partitionPaths);
        List records4 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)newDataGen.generateInserts("004", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF4 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records4, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF4.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF4 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(this.basePath);
        Assertions.assertEquals((long)200L, (long)hudiSnapshotDF4.count());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF1.join(hudiSnapshotDF4, (Seq)new .colon.colon((Object)"_hoodie_record_key", (List)Nil$.MODULE$), "inner").count());
    }

    @Test
    public void testInsertOverwrite() {
        String[] partitionPaths = new String[]{"2020/01/10"};
        HoodieTestDataGenerator newDataGen = new HoodieTestDataGenerator(partitionPaths);
        List records1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)newDataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((HoodieStorage)this.storage, (String)this.basePath, (String)"000"));
        List records2 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)newDataGen.generateInserts("002", Predef$.MODULE$.int2Integer(20)))).asScala()).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiSnapshotDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(this.basePath);
        Assertions.assertEquals((long)20L, (long)hudiSnapshotDF1.count());
    }
}

