/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.MapLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\tEa\u0001\u0002\u000e\u001c\u0001\u0011BQa\u000b\u0001\u0005\u00021B\u0011b\f\u0001A\u0002\u0003\u0007I\u0011\u0001\u0019\t\u0013a\u0002\u0001\u0019!a\u0001\n\u0003I\u0004\"\u0003\"\u0001\u0001\u0004\u0005\t\u0015)\u00032\u0011%\u0019\u0005\u00011AA\u0002\u0013\u0005A\tC\u0005R\u0001\u0001\u0007\t\u0019!C\u0001%\"IA\u000b\u0001a\u0001\u0002\u0003\u0006K!\u0012\u0005\b+\u0002\u0011\r\u0011\"\u0001W\u0011\u0019)\u0007\u0001)A\u0005/\"9a\r\u0001b\u0001\n\u00031\u0006BB4\u0001A\u0003%q\u000bC\u0004i\u0001\u0001\u0007I\u0011A5\t\u0013\u0005%\u0001\u00011A\u0005\u0002\u0005-\u0001bBA\b\u0001\u0001\u0006KA\u001b\u0005\b\u0003#\u0001A\u0011IA\n\u0011\u001d\tY\u0003\u0001C!\u0003'Aq!!\u000e\u0001\t\u0003\t9\u0004C\u0004\u0002n\u0001!I!a\u001c\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\"I\u0011Q\u0018\u0001\u0012\u0002\u0013%\u0011q\u0018\u0005\b\u0003+\u0004A\u0011AAl\u0011\u001d\ti\u000e\u0001C\u0005\u0003?Dq!!9\u0001\t\u0013\t\u0019\u000fC\u0004\u0002t\u0002!\t!!>\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004\t9B+Z:u\u001b\u0016$\u0018\rZ1uCJ+7m\u001c:e\u0013:$W\r\u001f\u0006\u00039u\t!BZ;oGRLwN\\1m\u0015\tqr$\u0001\u0003ik\u0012L'B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001KA\u0011a%K\u0007\u0002O)\u0011\u0001&H\u0001\ni\u0016\u001cH/\u001e;jYNL!AK\u0014\u00033!{w\u000eZ5f'B\f'o[\"mS\u0016tG\u000fV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"A\f\u0001\u000e\u0003m\tQa\u001d9be.,\u0012!\r\t\u0003eYj\u0011a\r\u0006\u0003iU\n1a]9m\u0015\tys$\u0003\u00028g\ta1\u000b]1sWN+7o]5p]\u0006I1\u000f]1sW~#S-\u001d\u000b\u0003u\u0001\u0003\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012A!\u00168ji\"9\u0011iAA\u0001\u0002\u0004\t\u0014a\u0001=%c\u000511\u000f]1sW\u0002\n1\"\u001b8ti\u0006tG\u000fV5nKV\tQ\t\u0005\u0002G\u001f6\tqI\u0003\u0002I\u0013\u00061\u0011\r^8nS\u000eT!AS&\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002M\u001b\u0006!Q\u000f^5m\u0015\u0005q\u0015\u0001\u00026bm\u0006L!\u0001U$\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003=Ign\u001d;b]R$\u0016.\\3`I\u0015\fHC\u0001\u001eT\u0011\u001d\te!!AA\u0002\u0015\u000bA\"\u001b8ti\u0006tG\u000fV5nK\u0002\nA\"\\3uC\u0012\fG/Y(qiN,\u0012a\u0016\t\u00051v{v,D\u0001Z\u0015\tQ6,A\u0005j[6,H/\u00192mK*\u0011A\fP\u0001\u000bG>dG.Z2uS>t\u0017B\u00010Z\u0005\ri\u0015\r\u001d\t\u0003A\u000el\u0011!\u0019\u0006\u0003E6\u000bA\u0001\\1oO&\u0011A-\u0019\u0002\u0007'R\u0014\u0018N\\4\u0002\u001b5,G/\u00193bi\u0006|\u0005\u000f^:!\u0003)\u0019w.\\7p]>\u0003Ho]\u0001\fG>lWn\u001c8PaR\u001c\b%\u0001\u0007nKJ<W\r\u001a#g\u0019&\u001cH/F\u0001k!\rY7O\u001e\b\u0003YFt!!\u001c9\u000e\u00039T!a\\\u0012\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0014B\u0001:=\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001^;\u0003\t1K7\u000f\u001e\u0006\u0003er\u00022a^A\u0002\u001d\rA\u0018\u0011\u0001\b\u0003s~t!A\u001f@\u000f\u0005mlhBA7}\u0013\u0005\u0011\u0013B\u0001\u0011\"\u0013\tys$\u0003\u00025k%\u0011!oM\u0005\u0005\u0003\u000b\t9AA\u0005ECR\fgI]1nK*\u0011!oM\u0001\u0011[\u0016\u0014x-\u001a3EM2K7\u000f^0%KF$2AOA\u0007\u0011\u001d\tU\"!AA\u0002)\fQ\"\\3sO\u0016$GI\u001a'jgR\u0004\u0013!B:fiV\u0003H#\u0001\u001e)\u0007=\t9\u0002\u0005\u0003\u0002\u001a\u0005\u001dRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\"\u0005\r\u0012a\u00026va&$XM\u001d\u0006\u0004\u0003K\t\u0013!\u00026v]&$\u0018\u0002BA\u0015\u00037\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\t\u00020A!\u0011\u0011DA\u0019\u0013\u0011\t\u0019$a\u0007\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\b;fgR\u001cE.^:uKJLgnZ,ji\"\u0014VmY8sI&sG-\u001a=\u0015\u0007i\nI\u0004C\u0004\u0002<E\u0001\r!!\u0010\u0002\u0013Q\f'\r\\3UsB,\u0007\u0003BA \u0003\u0013j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0006[>$W\r\u001c\u0006\u0004\u0003\u000fj\u0012AB2p[6|g.\u0003\u0003\u0002L\u0005\u0005#a\u0004%p_\u0012LW\rV1cY\u0016$\u0016\u0010]3)\u000fE\ty%a\u0018\u0002bA!\u0011\u0011KA.\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013\u0001\u00039s_ZLG-\u001a:\u000b\t\u0005e\u0013qD\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005u\u00131\u000b\u0002\u000b\u000b:,XnU8ve\u000e,\u0017!\u0002<bYV,7EAA\u001fQ\r\t\u0012Q\r\t\u0005\u0003O\nI'\u0004\u0002\u0002X%!\u00111NA,\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u001bO\u0016$H*\u0019;fgR\u001cE.^:uKJLgnZ%ogR\fg\u000e\u001e\u000b\u0003\u0003c\u0002b!a\u001d\u0002x\u0005mTBAA;\u0015\ra\u0015QI\u0005\u0005\u0003s\n)H\u0001\u0004PaRLwN\u001c\t\u0005\u0003{\n9)\u0004\u0002\u0002\u0000)!\u0011\u0011QAB\u0003!!\u0018.\\3mS:,'\u0002BAC\u0003\u000b\nQ\u0001^1cY\u0016LA!!#\u0002\u0000\ti\u0001j\\8eS\u0016Len\u001d;b]R\fA\u0005Z8Xe&$X-\u00118e-\u0006d\u0017\u000eZ1uK\u0012\u000bG/Y!oIJ+7m\u001c:e\u0013:$W\r\u001f\u000b\nm\u0006=\u0015QUAU\u0003gCq!!%\u0014\u0001\u0004\t\u0019*\u0001\u0005ik\u0012Lw\n\u001d;t!!\t)*!(\u0002\"\u0006\u0005f\u0002BAL\u00033\u0003\"!\u001c\u001f\n\u0007\u0005mE(\u0001\u0004Qe\u0016$WMZ\u0005\u0004=\u0006}%bAANyA!\u0011QSAR\u0013\r!\u0017q\u0014\u0005\b\u0003O\u001b\u0002\u0019AAQ\u0003%y\u0007/\u001a:bi&|g\u000eC\u0004\u0002,N\u0001\r!!,\u0002\u0011M\fg/Z'pI\u0016\u00042AMAX\u0013\r\t\tl\r\u0002\t'\u00064X-T8eK\"I\u0011QW\n\u0011\u0002\u0003\u0007\u0011qW\u0001\tm\u0006d\u0017\u000eZ1uKB\u00191(!/\n\u0007\u0005mFHA\u0004C_>dW-\u00198\u0002]\u0011|wK]5uK\u0006sGMV1mS\u0012\fG/\u001a#bi\u0006\fe\u000e\u001a*fG>\u0014H-\u00138eKb$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u0003TC!a.\u0002D.\u0012\u0011Q\u0019\t\u0005\u0003\u000f\f\t.\u0004\u0002\u0002J*!\u00111ZAg\u0003%)hn\u00195fG.,GMC\u0002\u0002Pr\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019.!3\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\tdC2\u001cW\u000f\\1uK6+'oZ3e\t\u001a$2AOAm\u0011\u0019\tY.\u0006a\u0001m\u0006A\u0011N\u001c9vi\u00123\u0015'\u0001\bhKRLen\u001d;b]R$\u0016.\\3\u0015\u0005\u0005\u0005\u0016AD4fi^\u0013\u0018\u000e^3D_:4\u0017n\u001a\u000b\u0005\u0003K\f\t\u0010\u0005\u0003\u0002h\u00065XBAAu\u0015\r\tY/H\u0001\u0007G>tg-[4\n\t\u0005=\u0018\u0011\u001e\u0002\u0012\u0011>|G-[3Xe&$XmQ8oM&<\u0007bBAI/\u0001\u0007\u00111S\u0001 O\u0016$h)\u001b7f\u000fJ|W\u000f]\"pk:$hi\u001c:SK\u000e|'\u000fZ%oI\u0016DH\u0003BA|\u0003{\u00042aOA}\u0013\r\tY\u0010\u0010\u0002\u0005\u0019>tw\rC\u0004\u0002\u0000b\u0001\r!!:\u0002\u0017]\u0014\u0018\u000e^3D_:4\u0017nZ\u0001\u001dm\u0006d\u0017\u000eZ1uK\u0012\u000bG/Y!oIJ+7m\u001c:e\u0013:$\u0017nY3t)\rQ$Q\u0001\u0005\b\u0003#K\u0002\u0019AAJQ\u001d\u0001!\u0011BA0\u0005\u001f\u0001B!!\u0007\u0003\f%!!QBA\u000e\u0005\r!\u0016mZ\u0011\u00029\u0001")
public class TestMetadataRecordIndex
extends HoodieSparkClientTestBase {
    private SparkSession spark;
    private AtomicInteger instantTime;
    private final scala.collection.immutable.Map<String, String> metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key()), (Object)"true")}));
    private final scala.collection.immutable.Map<String, String> commonOpts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)"true")}))).$plus$plus(this.metadataOpts());
    private List<Dataset<Row>> mergedDfList = List$.MODULE$.empty();

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public AtomicInteger instantTime() {
        return this.instantTime;
    }

    public void instantTime_$eq(AtomicInteger x$1) {
        this.instantTime = x$1;
    }

    public scala.collection.immutable.Map<String, String> metadataOpts() {
        return this.metadataOpts;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public List<Dataset<Row>> mergedDfList() {
        return this.mergedDfList;
    }

    public void mergedDfList_$eq(List<Dataset<Row>> x$1) {
        this.mergedDfList = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.initPath();
        this.initSparkContexts();
        this.initHoodieStorage();
        this.initTestDataGenerator();
        this.setTableName("hoodie_test");
        this.initMetaClient();
        this.instantTime_$eq(new AtomicInteger(1));
        this.spark_$eq(this.sqlContext.sparkSession());
    }

    @AfterEach
    public void tearDown() {
        this.cleanupFileSystem();
        this.cleanupSparkContexts();
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testClusteringWithRecordIndex(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.INLINE_CLUSTERING.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS.key()), (Object)"2")})));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4());
        org.apache.hudi.common.util.Option<HoodieInstant> lastClusteringInstant = this.getLatestClusteringInstant();
        Assertions.assertTrue((boolean)lastClusteringInstant.isPresent());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4());
        Assertions.assertTrue((((HoodieInstant)this.getLatestClusteringInstant().get()).requestedTime().compareTo(((HoodieInstant)lastClusteringInstant.get()).requestedTime()) > 0 ? 1 : 0) != 0);
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts);
    }

    private org.apache.hudi.common.util.Option<HoodieInstant> getLatestClusteringInstant() {
        return this.metaClient.getActiveTimeline().getCompletedReplaceTimeline().lastInstant();
    }

    private Dataset<Row> doWriteAndValidateDataAndRecordIndex(scala.collection.immutable.Map<String, String> hudiOpts, String operation, SaveMode saveMode, boolean validate) {
        Dataset inputDF1;
        block2: {
            Buffer records1 = null;
            String string = operation;
            String string2 = DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String instantTime = this.getInstantTime();
                java.util.List records = RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates(instantTime, Predef$.MODULE$.int2Integer(20)));
                records.addAll(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts(instantTime, Predef$.MODULE$.int2Integer(20))));
                records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(records).asScala();
            } else {
                records1 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts(this.getInstantTime(), Predef$.MODULE$.int2Integer(100)))).asScala();
            }
            inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize(records1.toSeq(), 2, ClassTag$.MODULE$.apply(String.class)));
            inputDF1.write().format("org.apache.hudi").options(hudiOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), operation).mode(saveMode).save(this.basePath);
            this.calculateMergedDf((Dataset<Row>)inputDF1);
            if (!validate) break block2;
            this.validateDataAndRecordIndices(hudiOpts);
        }
        return inputDF1;
    }

    private boolean doWriteAndValidateDataAndRecordIndex$default$4() {
        return true;
    }

    public void calculateMergedDf(Dataset<Row> inputDF1) {
        Option prevDfOpt = this.mergedDfList().lastOption();
        if (prevDfOpt.isEmpty()) {
            this.mergedDfList_$eq((List<Dataset<Row>>)((List)this.mergedDfList().$colon$plus(inputDF1, List$.MODULE$.canBuildFrom())));
            return;
        }
        Dataset prevDf = (Dataset)prevDfOpt.get();
        Dataset prevDfOld = prevDf.join(inputDF1, prevDf.apply("_row_key").$eq$eq$eq((Object)inputDF1.apply("_row_key")).$amp$amp((Object)prevDf.apply("partition").$eq$eq$eq((Object)inputDF1.apply("partition"))), "leftanti");
        prevDfOld.show(500, false);
        Dataset unionDf = prevDfOld.union(inputDF1);
        unionDf.show(500, false);
        this.mergedDfList_$eq((List<Dataset<Row>>)((List)this.mergedDfList().$colon$plus((Object)unionDf, List$.MODULE$.canBuildFrom())));
    }

    private String getInstantTime() {
        return String.format("%03d", new Integer(this.instantTime().getAndIncrement()));
    }

    private HoodieWriteConfig getWriteConfig(scala.collection.immutable.Map<String, String> hudiOpts) {
        TypedProperties props = TypedProperties.fromMap((Map)((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(hudiOpts).asJava()));
        return HoodieWriteConfig.newBuilder().withProps((Map)props).withPath(this.basePath).build();
    }

    public long getFileGroupCountForRecordIndex(HoodieWriteConfig writeConfig) {
        HoodieTableMetadata tableMetadata = this.getHoodieTable(this.metaClient, writeConfig).getMetadataTable();
        return ((HoodieBackedTableMetadata)tableMetadata).getNumFileGroupsForPartition(MetadataPartitionType.RECORD_INDEX);
    }

    private void validateDataAndRecordIndices(scala.collection.immutable.Map<String, String> hudiOpts) {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieWriteConfig writeConfig = this.getWriteConfig(hudiOpts);
        HoodieBackedTableMetadata metadata = this.metadataWriter(writeConfig).getTableMetadata();
        Dataset readDf = this.spark().read().format("hudi").load(this.basePath);
        Row[] rowArr = (Row[])readDf.collect();
        Map recordIndexMap = metadata.readRecordIndex((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rowArr)).map((Function1 & Serializable & scala.Serializable)row -> row.getAs("_hoodie_record_key").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList()).asJava());
        Assertions.assertTrue((rowArr.length > 0 ? 1 : 0) != 0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rowArr)).foreach((Function1 & Serializable & scala.Serializable)row -> {
            TestMetadataRecordIndex.$anonfun$validateDataAndRecordIndices$2(recordIndexMap, writeConfig, row);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)rowArr.length, (int)recordIndexMap.keySet().size());
        int estimatedFileGroupCount = HoodieTableMetadataUtil.estimateFileGroupCount((MetadataPartitionType)MetadataPartitionType.RECORD_INDEX, (long)rowArr.length, (int)48, (int)writeConfig.getRecordIndexMinFileGroupCount(), (int)writeConfig.getRecordIndexMaxFileGroupCount(), (float)writeConfig.getRecordIndexGrowthFactor(), (int)writeConfig.getRecordIndexMaxFileGroupSizeBytes());
        Assertions.assertEquals((long)estimatedFileGroupCount, (long)this.getFileGroupCountForRecordIndex(writeConfig));
        Dataset prevDf = ((Dataset)this.mergedDfList().last()).drop("tip_history");
        Dataset nonMatchingRecords = readDf.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_commit_time", "_hoodie_commit_seqno", "_hoodie_record_key", "_hoodie_partition_path", "_hoodie_file_name", "tip_history"})).join(prevDf, prevDf.columns(), "leftanti");
        nonMatchingRecords.show(500, false);
        Assertions.assertEquals((long)0L, (long)nonMatchingRecords.count());
        readDf.show(500, false);
        prevDf.show(500, false);
        Assertions.assertEquals((long)readDf.count(), (long)prevDf.count());
    }

    public static final /* synthetic */ void $anonfun$validateDataAndRecordIndices$2(Map recordIndexMap$1, HoodieWriteConfig writeConfig$1, Row row) {
        String recordKey = (String)row.getAs("_hoodie_record_key");
        String partitionPath = (String)row.getAs("_hoodie_partition_path");
        String fileName = (String)row.getAs("_hoodie_file_name");
        java.util.List recordLocations = (java.util.List)recordIndexMap$1.get(recordKey);
        Assertions.assertFalse((boolean)recordLocations.isEmpty());
        HoodieRecordGlobalLocation recordLocation = (HoodieRecordGlobalLocation)recordLocations.get(0);
        Assertions.assertEquals((Object)partitionPath, (Object)recordLocation.getPartitionPath());
        if (!writeConfig$1.inlineClusteringEnabled() && !writeConfig$1.isAsyncClusteringEnabled()) {
            Assertions.assertTrue((boolean)fileName.contains(recordLocation.getFileId()), (String)new StringBuilder(18).append(fileName).append(" does not contain ").append(recordLocation.getFileId()).toString());
            return;
        }
    }
}

