/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.hudi.util.JavaScalaConverters$;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.functions$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableLike;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001\u0002\u000b\u0016\u0001yAQ!\n\u0001\u0005\u0002\u0019Bq\u0001\u0007\u0001C\u0002\u0013\u0005\u0011\u0006\u0003\u00043\u0001\u0001\u0006IA\u000b\u0005\bg\u0001\u0001\r\u0011\"\u00015\u0011\u001dy\u0004\u00011A\u0005\u0002\u0001Caa\u0012\u0001!B\u0013)\u0004b\u0002%\u0001\u0001\u0004%\t\u0001\u000e\u0005\b\u0013\u0002\u0001\r\u0011\"\u0001K\u0011\u0019a\u0005\u0001)Q\u0005k!)Q\n\u0001C!\u001d\")Q\u000b\u0001C\u0001-\")\u0011\u0010\u0001C\u0005u\"9\u0011q\u0002\u0001\u0005\n\u0005E\u0001bBA\u000b\u0001\u0011%\u0011q\u0003\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0003+Bq!a\u001b\u0001\t\u0013\ti\u0007C\u0004\u0002l\u0001!I!!\u001d\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000\t!C+Z:u\u001b\u0016$\u0018\rZ1uCR\u000b'\r\\3XSRD7\u000b]1sW\u0012\u000bG/Y*pkJ\u001cWM\u0003\u0002\u0017/\u0005Qa-\u001e8di&|g.\u00197\u000b\u0005aI\u0012\u0001\u00025vI&T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u00011C\u0001\u0001 !\t\u00013%D\u0001\"\u0015\t\u0011s#A\u0005uKN$X\u000f^5mg&\u0011A%\t\u0002!'B\f'o[\"mS\u0016tGOR;oGRLwN\\1m)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011\u0001\u0006A\u0007\u0002+U\t!\u0006\u0005\u0002,a5\tAF\u0003\u0002.]\u0005!A.\u00198h\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!\r\u0017\u0003\rM#(/\u001b8h\u0003\u0015AW\u000fZ5!\u0003aqwN\u001c)beRLG/[8oK\u0012\u001cu.\\7p]>\u0003Ho]\u000b\u0002kA!a'\u0010\u0016+\u001b\u00059$B\u0001\u001d:\u0003%IW.\\;uC\ndWM\u0003\u0002;w\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003q\nQa]2bY\u0006L!AP\u001c\u0003\u00075\u000b\u0007/\u0001\u000fo_:\u0004\u0016M\u001d;ji&|g.\u001a3D_6lwN\\(qiN|F%Z9\u0015\u0005\u0005+\u0005C\u0001\"D\u001b\u0005Y\u0014B\u0001#<\u0005\u0011)f.\u001b;\t\u000f\u0019+\u0011\u0011!a\u0001k\u0005\u0019\u0001\u0010J\u0019\u000239|g\u000eU1si&$\u0018n\u001c8fI\u000e{W.\\8o\u001fB$8\u000fI\u0001\u0016a\u0006\u0014H/\u001b;j_:,GmQ8n[>tw\n\u001d;t\u0003e\u0001\u0018M\u001d;ji&|g.\u001a3D_6lwN\\(qiN|F%Z9\u0015\u0005\u0005[\u0005b\u0002$\t\u0003\u0003\u0005\r!N\u0001\u0017a\u0006\u0014H/\u001b;j_:,GmQ8n[>tw\n\u001d;tA\u0005!1m\u001c8g)\u0005y\u0005C\u0001)T\u001b\u0005\t&B\u0001*\u001a\u0003\u0015\u0019\b/\u0019:l\u0013\t!\u0016KA\u0005Ta\u0006\u00148nQ8oM\u0006yA/Z:u%\u0016\fG-\u00192jY&$\u0018\u0010F\u0002B/rCQ\u0001W\u0006A\u0002e\u000bacY8na\u0006\u001cGOT;n\t\u0016dG/Y\"p[6LGo\u001d\t\u0003\u0005jK!aW\u001e\u0003\u0007%sG\u000fC\u0003^\u0017\u0001\u0007a,A\buKN$\b+\u0019:uSRLwN\\3e!\t\u0011u,\u0003\u0002aw\t9!i\\8mK\u0006t\u0007\u0006B\u0006c]>\u0004\"a\u00197\u000e\u0003\u0011T!!\u001a4\u0002\u0011A\u0014xN^5eKJT!a\u001a5\u0002\rA\f'/Y7t\u0015\tI'.A\u0004kkBLG/\u001a:\u000b\u0005-\\\u0012!\u00026v]&$\u0018BA7e\u0005%\u00195O^*pkJ\u001cW-A\u0003wC2,X\r\f\u0002qe\u0006\n\u0011/\u0001\u00042YQ\u0014X/Z\u0011\u0002g\u00069\u0011\u0007\f4bYN,\u0007FA\u0006v!\t1x/D\u0001g\u0013\tAhMA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\f\u0001D^1mS\u0012\fG/\u001a)beRLG/[8oK\u0012$\u0016M\u00197f)\t\t5\u0010C\u0003}\u0019\u0001\u0007Q0\u0001\u0005cCN,\u0007+\u0019;i!\rq\u00181\u0002\b\u0004\u007f\u0006\u001d\u0001cAA\u0001w5\u0011\u00111\u0001\u0006\u0004\u0003\u000bi\u0012A\u0002\u001fs_>$h(C\u0002\u0002\nm\na\u0001\u0015:fI\u00164\u0017bA\u0019\u0002\u000e)\u0019\u0011\u0011B\u001e\u00025Y\fG.\u001b3bi\u0016,f\u000eU1si&$\u0018n\u001c8fIR\u000b'\r\\3\u0015\u0007\u0005\u000b\u0019\u0002C\u0003}\u001b\u0001\u0007Q0\u0001\u0007qCJ\u001cXMU3d_J$7\u000f\u0006\u0003\u0002\u001a\u00055\u0002\u0003BA\u000e\u0003OqA!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C\t\u0016aA:rY&!\u0011QEA\u0010\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u000b\u0002,\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0005\u0003K\ty\u0002C\u0004\u000209\u0001\r!!\r\u0002\u000fI,7m\u001c:egB)\u00111GA\u001e{:!\u0011QGA\u001d\u001d\u0011\t\t!a\u000e\n\u0003qJ1!!\n<\u0013\u0011\ti$a\u0010\u0003\u0007M+\u0017OC\u0002\u0002&m\n1\u0003^3tiRKW.\u001a+sCZ,G.U;fef$\u0012!\u0011\u0015\u0004\u001f\u0005\u001d\u0003\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055\u0003.A\u0002ba&LA!!\u0015\u0002L\t!A+Z:u\u000319W\r\u001e$jY\u0016\u001c\u0018i](g)\u0019\t9&!\u001a\u0002hA1\u0011\u0011LA.\u0003?j\u0011!O\u0005\u0004\u0003;J$AB$f]N+G\u000fE\u0002C\u0003CJ1!a\u0019<\u0005\r\te.\u001f\u0005\u0006yB\u0001\r! \u0005\u0007\u0003S\u0002\u0002\u0019A?\u0002\u0013QLW.Z:uC6\u0004\u0018\u0001C4fi\u001aKG.Z:\u0015\t\u0005]\u0013q\u000e\u0005\u0006yF\u0001\r! \u000b\u0007\u0003/\n\u0019(!\u001e\t\u000bq\u0014\u0002\u0019A?\t\u000f\u0005]$\u00031\u0001\u0002z\u0005!q\u000e\u001d;t!\u0015q\u00181P?~\u0013\rq\u0014QB\u0001\u000fO\u0016$h)\u001b7fg\u001a\u0013x.\u001c$t)\u0011\t9&!!\t\u000f\u0005\r5\u00031\u0001\u0002\u0006\u0006QQ.\u001a;b\u00072LWM\u001c;\u0011\t\u0005\u001d\u0015\u0011S\u0007\u0003\u0003\u0013SA!a#\u0002\u000e\u0006)A/\u00192mK*\u0019\u0011qR\f\u0002\r\r|W.\\8o\u0013\u0011\t\u0019*!#\u0003+!{w\u000eZ5f)\u0006\u0014G.Z'fi\u0006\u001cE.[3oi\"2\u0001!a&o\u0003;\u0003B!!\u0013\u0002\u001a&!\u00111TA&\u0005\r!\u0016mZ\u0011\u0002-\u0001")
public class TestMetadataTableWithSparkDataSource
extends SparkClientFunctionalTestHarness {
    private final String hudi;
    private scala.collection.immutable.Map<String, String> nonPartitionedCommonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.delete.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
    private scala.collection.immutable.Map<String, String> partitionedCommonOpts = this.nonPartitionedCommonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition")})));

    public String hudi() {
        return this.hudi;
    }

    public scala.collection.immutable.Map<String, String> nonPartitionedCommonOpts() {
        return this.nonPartitionedCommonOpts;
    }

    public void nonPartitionedCommonOpts_$eq(scala.collection.immutable.Map<String, String> x$1) {
        this.nonPartitionedCommonOpts = x$1;
    }

    public scala.collection.immutable.Map<String, String> partitionedCommonOpts() {
        return this.partitionedCommonOpts;
    }

    public void partitionedCommonOpts_$eq(scala.collection.immutable.Map<String, String> x$1) {
        this.partitionedCommonOpts = x$1;
    }

    public SparkConf conf() {
        return this.conf(SparkClientFunctionalTestHarness.getSparkSqlConf());
    }

    @ParameterizedTest
    @CsvSource(value={"1,true", "1,false"})
    public void testReadability(int compactNumDeltaCommits, boolean testPartitioned) {
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
        scala.collection.immutable.Map metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true")}));
        scala.collection.immutable.Map<String, String> commonOpts = testPartitioned ? this.partitionedCommonOpts() : this.nonPartitionedCommonOpts();
        scala.collection.immutable.Map combinedOpts = commonOpts.$plus$plus((GenTraversableOnce)metadataOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)Integer.toString(compactNumDeltaCommits))})));
        java.util.List newRecords = dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100));
        Dataset<Row> newRecordsDF = this.parseRecords((Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)newRecords)).asScala()).toSeq());
        newRecordsDF.write().format(this.hudi()).options((Map)combinedOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
        java.util.List updatedRecords = dataGen.generateUpdates("002", newRecords);
        Dataset<Row> updatedRecordsDF = this.parseRecords((Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)updatedRecords)).asScala()).toSeq());
        updatedRecordsDF.write().format(this.hudi()).options((Map)combinedOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
        if (testPartitioned) {
            this.validatePartitionedTable(this.basePath());
            return;
        }
        this.validateUnPartitionedTable(this.basePath());
    }

    private void validatePartitionedTable(String basePath) {
        Dataset filesPartitionDF = this.spark().read().format(this.hudi()).load(new StringBuilder(23).append(basePath).append("/.hoodie/metadata/files").toString());
        filesPartitionDF.show();
        Assertions.assertEquals((long)4L, (long)filesPartitionDF.count());
        Seq expectedKeys = (Seq)new .colon.colon((Object)"2015/03/16", (List)new .colon.colon((Object)"2015/03/17", (List)new .colon.colon((Object)"2016/03/15", (List)new .colon.colon((Object)"__all_partitions__", (List)Nil$.MODULE$))));
        Seq keys = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesPartitionDF.select("key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertEquals((Object)expectedKeys, (Object)keys);
        Dataset colStatsDF = this.spark().read().format(this.hudi()).load(new StringBuilder(30).append(basePath).append("/.hoodie/metadata/column_stats").toString());
        colStatsDF.show();
        String partitionPathToTest = "2015/03/16";
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc());
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).build();
        HoodieBackedTableMetadata baseTableMetada = new HoodieBackedTableMetadata((HoodieEngineContext)engineContext, this.hoodieStorage(), metadataConfig, String.valueOf(basePath), false);
        java.util.List fileStatuses = baseTableMetada.getAllFilesInPartition(new StoragePath(new StringBuilder(1).append(basePath).append("/").append(partitionPathToTest).toString()));
        String fileName = ((StoragePathInfo)fileStatuses.get(0)).getPath().getName();
        ArrayList<Pair> partitionFileNamePair = new ArrayList<Pair>();
        partitionFileNamePair.add(Pair.of((Object)partitionPathToTest, (Object)fileName));
        java.util.Map colStatsRecords = baseTableMetada.getColumnStats(partitionFileNamePair, "begin_lat");
        Assertions.assertEquals((int)colStatsRecords.size(), (int)1);
        HoodieMetadataColumnStats metadataColStats = (HoodieMetadataColumnStats)colStatsRecords.get(partitionFileNamePair.get(0));
        java.util.List colRangeMetadataList = new ParquetUtils().readColumnStatsFromMetadata((HoodieStorage)new HoodieHadoopStorage(((StoragePathInfo)fileStatuses.get(0)).getPath(), HadoopFSUtils.getStorageConf((Configuration)this.jsc().hadoopConfiguration())), ((StoragePathInfo)fileStatuses.get(0)).getPath(), Collections.singletonList("begin_lat"));
        HoodieColumnRangeMetadata columnRangeMetadata = (HoodieColumnRangeMetadata)colRangeMetadataList.get(0);
        Assertions.assertEquals((Long)metadataColStats.getValueCount(), (long)columnRangeMetadata.getValueCount());
        Assertions.assertEquals((Long)metadataColStats.getTotalSize(), (long)columnRangeMetadata.getTotalSize());
        Assertions.assertEquals((Object)HoodieAvroUtils.unwrapAvroValueWrapper((Object)metadataColStats.getMaxValue()), (Object)columnRangeMetadata.getMaxValue());
        Assertions.assertEquals((Object)HoodieAvroUtils.unwrapAvroValueWrapper((Object)metadataColStats.getMinValue()), (Object)columnRangeMetadata.getMinValue());
        Assertions.assertEquals((Object)metadataColStats.getFileName(), (Object)fileName);
    }

    private void validateUnPartitionedTable(String basePath) {
        Dataset filesPartitionDF = this.spark().read().format(this.hudi()).load(new StringBuilder(23).append(basePath).append("/.hoodie/metadata/files").toString());
        filesPartitionDF.show();
        Assertions.assertEquals((long)2L, (long)filesPartitionDF.count());
        Seq expectedKeys = (Seq)new .colon.colon((Object)".", (List)new .colon.colon((Object)"__all_partitions__", (List)Nil$.MODULE$));
        Seq keys = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesPartitionDF.select("key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertEquals((Object)expectedKeys, (Object)keys);
        Dataset colStatsDF = this.spark().read().format(this.hudi()).load(new StringBuilder(30).append(basePath).append("/.hoodie/metadata/column_stats").toString());
        colStatsDF.show();
        String partitionPathToTest = "";
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc());
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).build();
        HoodieBackedTableMetadata baseTableMetada = new HoodieBackedTableMetadata((HoodieEngineContext)engineContext, this.hoodieStorage(), metadataConfig, String.valueOf(basePath), false);
        java.util.List allPartitionPaths = baseTableMetada.getAllPartitionPaths();
        Assertions.assertEquals((int)allPartitionPaths.size(), (int)1);
        Assertions.assertEquals(allPartitionPaths.get(0), (Object)"");
        java.util.List fileStatuses = baseTableMetada.getAllFilesInPartition(new StoragePath(new StringBuilder(1).append(basePath).append("/").toString()));
        String fileName = ((StoragePathInfo)fileStatuses.get(0)).getPath().getName();
        ArrayList<Pair> partitionFileNamePair = new ArrayList<Pair>();
        partitionFileNamePair.add(Pair.of((Object)partitionPathToTest, (Object)fileName));
        java.util.Map colStatsRecords = baseTableMetada.getColumnStats(partitionFileNamePair, "begin_lat");
        Assertions.assertEquals((int)colStatsRecords.size(), (int)1);
        HoodieMetadataColumnStats metadataColStats = (HoodieMetadataColumnStats)colStatsRecords.get(partitionFileNamePair.get(0));
        java.util.List colRangeMetadataList = new ParquetUtils().readColumnStatsFromMetadata((HoodieStorage)new HoodieHadoopStorage(((StoragePathInfo)fileStatuses.get(0)).getPath(), HadoopFSUtils.getStorageConf((Configuration)this.jsc().hadoopConfiguration())), ((StoragePathInfo)fileStatuses.get(0)).getPath(), Collections.singletonList("begin_lat"));
        HoodieColumnRangeMetadata columnRangeMetadata = (HoodieColumnRangeMetadata)colRangeMetadataList.get(0);
        Assertions.assertEquals((Long)metadataColStats.getValueCount(), (long)columnRangeMetadata.getValueCount());
        Assertions.assertEquals((Long)metadataColStats.getTotalSize(), (long)columnRangeMetadata.getTotalSize());
        Assertions.assertEquals((Object)HoodieAvroUtils.unwrapAvroValueWrapper((Object)metadataColStats.getMaxValue()), (Object)columnRangeMetadata.getMaxValue());
        Assertions.assertEquals((Object)HoodieAvroUtils.unwrapAvroValueWrapper((Object)metadataColStats.getMinValue()), (Object)columnRangeMetadata.getMinValue());
        Assertions.assertEquals((Object)metadataColStats.getFileName(), (Object)fileName);
    }

    private Dataset<Row> parseRecords(Seq<String> records) {
        return this.spark().read().json(this.spark().sparkContext().parallelize(records, 2, ClassTag$.MODULE$.apply(String.class)));
    }

    @Test
    public void testTimeTravelQuery() {
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
        scala.collection.immutable.Map metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)"MERGE_ON_READ"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"5")}));
        scala.collection.immutable.Map combinedOpts = this.partitionedCommonOpts().$plus$plus((GenTraversableOnce)metadataOpts);
        java.util.List newRecords = dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100));
        Dataset<Row> newRecordsDF = this.parseRecords((Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)newRecords)).asScala()).toSeq());
        newRecordsDF.write().format(this.hudi()).options((Map)combinedOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.storageConf()).setBasePath(new StringBuilder(17).append(this.basePath()).append("/.hoodie/metadata").toString()).build();
        HoodieActiveTimeline timelineT0 = metaClient.getActiveTimeline();
        Assertions.assertEquals((int)4, (int)timelineT0.countInstants());
        Assertions.assertEquals((Object)"deltacommit", (Object)((HoodieInstant)timelineT0.lastInstant().get()).getAction());
        String t0 = ((HoodieInstant)timelineT0.lastInstant().get()).requestedTime();
        GenSet<Object> filesT0 = this.getFiles(this.basePath());
        Assertions.assertEquals((int)3, (int)filesT0.size());
        HoodieTableMetaClient baseMetaClient = HoodieTableMetaClient.builder().setConf(this.storageConf()).setBasePath(this.basePath()).build();
        GenSet<Object> filesT0FS = this.getFilesFromFs(baseMetaClient);
        Assertions.assertEquals((int)3, (int)filesT0FS.size());
        Assertions.assertEquals((int)3, (int)((GenTraversableLike)filesT0.intersect(filesT0FS)).size());
        java.util.List updatedRecords = dataGen.generateUpdates("001", newRecords);
        Dataset<Row> updatedRecordsDF = this.parseRecords((Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)updatedRecords)).asScala()).toSeq());
        updatedRecordsDF.write().format(this.hudi()).options((Map)combinedOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
        HoodieActiveTimeline timelineT1 = metaClient.reloadActiveTimeline();
        Assertions.assertEquals((int)5, (int)timelineT1.countInstants());
        Assertions.assertEquals((Object)"deltacommit", (Object)((HoodieInstant)timelineT1.lastInstant().get()).getAction());
        String t1 = ((HoodieInstant)timelineT1.lastInstant().get()).requestedTime();
        GenSet<Object> filesT1 = this.getFiles(this.basePath());
        Assertions.assertEquals((int)6, (int)filesT1.size());
        Assertions.assertEquals((int)3, (int)((GenTraversableLike)filesT1.diff(filesT0)).size());
        GenSet<Object> filesT1FS = this.getFilesFromFs(baseMetaClient);
        Assertions.assertEquals((int)6, (int)filesT1FS.size());
        Assertions.assertEquals((int)6, (int)((GenTraversableLike)filesT1.intersect(filesT1FS)).size());
        GenSet<Object> filesT1travelT0 = this.getFilesAsOf(this.basePath(), t0);
        Assertions.assertEquals((int)3, (int)filesT1travelT0.size());
        Assertions.assertEquals((int)3, (int)((GenTraversableLike)filesT1travelT0.intersect(filesT0)).size());
        java.util.List updatedRecords2 = dataGen.generateUpdates("002", updatedRecords);
        Dataset<Row> updatedRecords2DF = this.parseRecords((Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)updatedRecords2)).asScala()).toSeq());
        updatedRecords2DF.write().format(this.hudi()).options((Map)combinedOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
        HoodieActiveTimeline timelineT2 = metaClient.reloadActiveTimeline();
        Assertions.assertEquals((int)7, (int)timelineT2.countInstants());
        Assertions.assertEquals((Object)"deltacommit", (Object)((HoodieInstant)timelineT2.getInstants().get(5)).getAction());
        Assertions.assertEquals((Object)"commit", (Object)((HoodieInstant)timelineT2.lastInstant().get()).getAction());
        String t2 = ((HoodieInstant)timelineT2.lastInstant().get()).requestedTime();
        GenSet<Object> filesT2 = this.getFiles(this.basePath());
        Assertions.assertEquals((int)9, (int)filesT2.size());
        Assertions.assertEquals((int)3, (int)((GenTraversableLike)filesT2.diff(filesT1)).size());
        GenSet<Object> filesT2FS = this.getFilesFromFs(baseMetaClient);
        Assertions.assertEquals((int)9, (int)filesT2FS.size());
        Assertions.assertEquals((int)9, (int)((GenTraversableLike)filesT2.intersect(filesT2FS)).size());
        GenSet<Object> filesT2travelT1 = this.getFilesAsOf(this.basePath(), t1);
        Assertions.assertEquals((int)6, (int)filesT2travelT1.size());
        Assertions.assertEquals((int)6, (int)((GenTraversableLike)filesT2travelT1.intersect(filesT1)).size());
        GenSet<Object> filesT2travelT0 = this.getFilesAsOf(this.basePath(), t0);
        Assertions.assertEquals((int)3, (int)filesT2travelT0.size());
        Assertions.assertEquals((int)3, (int)((GenTraversableLike)filesT2travelT0.intersect(filesT0)).size());
        java.util.List updatedRecords3 = dataGen.generateUpdates("003", updatedRecords2);
        Dataset<Row> updatedRecords3DF = this.parseRecords((Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)updatedRecords3)).asScala()).toSeq());
        updatedRecords3DF.write().format(this.hudi()).options((Map)combinedOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
        HoodieActiveTimeline timelineT3 = metaClient.reloadActiveTimeline();
        Assertions.assertEquals((int)8, (int)timelineT3.countInstants());
        Assertions.assertEquals((Object)"deltacommit", (Object)((HoodieInstant)timelineT3.lastInstant().get()).getAction());
        GenSet<Object> filesT3 = this.getFiles(this.basePath());
        Assertions.assertEquals((int)12, (int)filesT3.size());
        Assertions.assertEquals((int)3, (int)((GenTraversableLike)filesT3.diff(filesT2)).size());
        GenSet<Object> filesT3FS = this.getFilesFromFs(baseMetaClient);
        Assertions.assertEquals((int)12, (int)filesT3FS.size());
        Assertions.assertEquals((int)12, (int)((GenTraversableLike)filesT3.intersect(filesT3FS)).size());
        GenSet<Object> filesT3travelT2 = this.getFilesAsOf(this.basePath(), t2);
        Assertions.assertEquals((int)9, (int)filesT3travelT2.size());
        Assertions.assertEquals((int)9, (int)((GenTraversableLike)filesT3travelT2.intersect(filesT2)).size());
        GenSet<Object> filesT3travelT1 = this.getFilesAsOf(this.basePath(), t1);
        Assertions.assertEquals((int)6, (int)filesT3travelT1.size());
        Assertions.assertEquals((int)6, (int)((GenTraversableLike)filesT3travelT1.intersect(filesT1)).size());
        GenSet<Object> filesT3travelT0 = this.getFilesAsOf(this.basePath(), t0);
        Assertions.assertEquals((int)3, (int)filesT3travelT0.size());
        Assertions.assertEquals((int)3, (int)((GenTraversableLike)filesT3travelT0.intersect(filesT0)).size());
    }

    private GenSet<Object> getFilesAsOf(String basePath, String timestamp) {
        return this.getFiles(basePath, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key()), (Object)timestamp)}))));
    }

    private GenSet<Object> getFiles(String basePath) {
        return this.getFiles(basePath, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    private GenSet<Object> getFiles(String basePath, scala.collection.immutable.Map<String, String> opts) {
        return Predef$.MODULE$.genericArrayOps(this.spark().read().format(this.hudi()).options(opts).load(new StringBuilder(17).append(basePath).append("/.hoodie/metadata").toString()).where("type = 2").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.col("filesystemMetadata"))})).drop("value").rdd().map((Function1 & Serializable & scala.Serializable)r -> r.apply(0), ClassTag$.MODULE$.Any()).collect()).toSet();
    }

    private GenSet<Object> getFilesFromFs(HoodieTableMetaClient metaClient) {
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc());
        ArrayList files = new ArrayList();
        HoodieTableFileSystemView fsview = FileSystemViewManager.createInMemoryFileSystemView((HoodieEngineContext)engineContext, (HoodieTableMetaClient)metaClient, (HoodieMetadataConfig)HoodieMetadataConfig.newBuilder().enable(false).build());
        fsview.loadAllPartitions();
        JavaScalaConverters$.MODULE$.convertJavaListToScalaSeq(fsview.getAllFileGroups().collect(Collectors.toList())).foreach((Function1 & Serializable & scala.Serializable)fg -> {
            TestMetadataTableWithSparkDataSource.$anonfun$getFilesFromFs$1(files, fg);
            return BoxedUnit.UNIT;
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(files.toArray())).toSet();
    }

    public static final /* synthetic */ void $anonfun$getFilesFromFs$2(ArrayList files$1, FileSlice fileSlice) {
        Object object = fileSlice.getBaseFile().isPresent() ? BoxesRunTime.boxToBoolean((boolean)files$1.add(((BaseFile)fileSlice.getBaseFile().get()).getFileName())) : BoxedUnit.UNIT;
        JavaScalaConverters$.MODULE$.convertJavaListToScalaSeq(fileSlice.getLogFiles().collect(Collectors.toList())).foreach((Function1 & Serializable & scala.Serializable)logFile -> BoxesRunTime.boxToBoolean((boolean)files$1.add(logFile.getFileName())));
    }

    public static final /* synthetic */ void $anonfun$getFilesFromFs$1(ArrayList files$1, HoodieFileGroup fg) {
        JavaScalaConverters$.MODULE$.convertJavaListToScalaSeq(fg.getAllFileSlices().collect(Collectors.toList())).foreach((Function1 & Serializable & scala.Serializable)fileSlice -> {
            TestMetadataTableWithSparkDataSource.$anonfun$getFilesFromFs$2(files$1, fileSlice);
            return BoxedUnit.UNIT;
        });
    }

    public TestMetadataTableWithSparkDataSource() {
        this.hudi = "org.apache.hudi";
    }
}

