/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.HoodieFileIndex$;
import org.apache.hudi.PartitionStatsIndexSupport;
import org.apache.hudi.PartitionStatsIndexSupport$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.client.transaction.SimpleConcurrentFileWritesConflictResolutionStrategy;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.apache.hudi.functional.PartitionStatsIndexTestBase;
import org.apache.hudi.functional.TestPartitionStatsIndex$;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataFileSystemView;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.util.JFunction$;
import org.apache.hudi.util.JavaConversions$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BinaryOperator;
import org.apache.spark.sql.catalyst.expressions.BitwiseOr;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.hudi.DataSkippingUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\tuc\u0001B\u0012%\u00015BQA\r\u0001\u0005\u0002MBq!\u000e\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004@\u0001\u0001\u0006Ia\u000e\u0005\u0006\u0001\u0002!\t!\u0011\u0005\u0006'\u0002!\t!\u0011\u0005\u0006+\u0002!\tA\u0016\u0005\u0006c\u0002!\tA\u001d\u0005\u0006m\u0002!\t!\u0011\u0005\u0006q\u0002!\t!\u001f\u0005\u0006{\u0002!\t!\u0011\u0005\u0007\u007f\u0002!\t!!\u0001\t\r\u0005}\u0001\u0001\"\u0001B\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!!\f\u0001\t\u0003\ty\u0003\u0003\u0004\u00028\u0001!\t!\u0011\u0005\u0007\u0003w\u0001A\u0011A!\t\r\u0005}\u0002\u0001\"\u0001B\u0011\u0019\t\u0019\u0005\u0001C\u0001\u0003\"9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBAK\u0001\u0011%\u0011q\u0013\u0005\b\u0003C\u0003A\u0011AAR\u0011\u001d\ti\u000b\u0001C\u0001\u0003_Cq!a/\u0001\t\u0013\ti\fC\u0004\u0002J\u0002!I!a3\t\u000f\u0005=\u0007\u0001\"\u0003\u0002R\"I\u0011Q\u001c\u0001\u0012\u0002\u0013%\u0011q\u001c\u0005\b\u0003k\u0004A\u0011BA|\u0011%\u0011)\u0001AI\u0001\n\u0013\ty\u000eC\u0004\u0003\b\u0001!IA!\u0003\t\u0019\te\u0001\u0001%A\u0001\u0002\u0003%\tAa\u0007\b\u000f\t]B\u0005#\u0001\u0003:\u001911\u0005\nE\u0001\u0005wAaA\r\u0011\u0005\u0002\t\r\u0003bBA\u000eA\u0011\u0005!Q\t\u0002\u0018)\u0016\u001cH\u000fU1si&$\u0018n\u001c8Ti\u0006$8/\u00138eKbT!!\n\u0014\u0002\u0015\u0019,hn\u0019;j_:\fGN\u0003\u0002(Q\u0005!\u0001.\u001e3j\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\f\t\u0003_Aj\u0011\u0001J\u0005\u0003c\u0011\u00121\u0004U1si&$\u0018n\u001c8Ti\u0006$8/\u00138eKb$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u00015!\ty\u0003!\u0001\u0007tc2$V-\u001c9UC\ndW-F\u00018!\tAT(D\u0001:\u0015\tQ4(\u0001\u0003mC:<'\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}e\u0012aa\u0015;sS:<\u0017!D:rYR+W\u000e\u001d+bE2,\u0007%\u0001\u0013uKN$\b+\u0019:uSRLwN\\*uCR\u001cx+\u001b;i_V$8i\u001c7v[:\u001cF/\u0019;t)\u0005\u0011\u0005CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%\u0001B+oSRD#\u0001B%\u0011\u0005)\u000bV\"A&\u000b\u00051k\u0015aA1qS*\u0011ajT\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0001&&A\u0003kk:LG/\u0003\u0002S\u0017\n!A+Z:u\u0003\u0005\"Xm\u001d;QCJ$\u0018\u000e^5p]N#\u0018\r^:XSRDGj\\4jG\u0006dG+\u001f9fQ\t)\u0011*A\fuKN$\u0018J\u001c3fq&s\u0017\u000e^5bY&T\u0018\r^5p]R\u0011!i\u0016\u0005\u00061\u001a\u0001\r!W\u0001\ni\u0006\u0014G.\u001a+za\u0016\u0004\"AW0\u000e\u0003mS!\u0001X/\u0002\u000b5|G-\u001a7\u000b\u0005y3\u0013AB2p[6|g.\u0003\u0002a7\ny\u0001j\\8eS\u0016$\u0016M\u00197f)f\u0004X\r\u000b\u0003\u0007E*\\\u0007CA2i\u001b\u0005!'BA3g\u0003!\u0001(o\u001c<jI\u0016\u0014(BA4N\u0003\u0019\u0001\u0018M]1ng&\u0011\u0011\u000e\u001a\u0002\u000b\u000b:,XnU8ve\u000e,\u0017!\u0002<bYV,7%A-)\u0005\u0019i\u0007C\u00018p\u001b\u00051\u0017B\u00019g\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0014i\u0016\u001cH/\u00138eKb<\u0016\u000e\u001e5VaN,'\u000f\u001e\u000b\u0003\u0005NDQ\u0001W\u0004A\u0002eCCa\u00022kW\"\u0012q!\\\u0001\"i\u0016\u001cH/\u00138eKb<\u0016\u000e\u001e5VaN,'\u000f\u001e(p]B\u000b'\u000f^5uS>tW\r\u001a\u0015\u0003\u0011%\u000b!\u0004^3ti&sG-\u001a=VaN,'\u000f^!oIJ{G\u000e\u001c2bG.$\"A\u0011>\t\u000baK\u0001\u0019A-)\t%\u0011'n\u001b\u0015\u0003\u00135\f!\u0005^3tiB\u000b'\u000f^5uS>t7\u000b^1ug&sG-\u001a=GS2,\u0007K];oS:<\u0007F\u0001\u0006J\u0003\u0005\"Xm\u001d;QCJ$\u0018\u000e^5p]N#\u0018\r^:XSRDW*\u001e7uS^\u0013\u0018\u000e^3s)\u0015\u0011\u00151AA\u0003\u0011\u0015A6\u00021\u0001Z\u0011\u001d\t9a\u0003a\u0001\u0003\u0013\t\u0011\"^:f+B\u001cXM\u001d;\u0011\u0007\r\u000bY!C\u0002\u0002\u000e\u0011\u0013qAQ8pY\u0016\fg\u000e\u000b\u0004\f\u0003#Q\u0017q\u0003\t\u0004G\u0006M\u0011bAA\u000bI\naQ*\u001a;i_\u0012\u001cv.\u001e:dK2\u0012\u0011\u0011D\u0011\u0003\u00037\t1c];qa2LH+Z:u\u0003J<W/\\3oiND#aC7\u0002CQ,7\u000f\u001e)beRLG/[8o'R\fGo],ji\"\u0004\u0016M\u001d;ji&|gNQ=)\u00051I\u0015a\u000b;fgR\u0004\u0016M\u001d;ji&|gn\u0015;biN<\u0016\u000e\u001e5D_6\u0004\u0018m\u0019;j_:\fe\u000eZ\"mK\u0006t\u0017N\\4\u0015\u0007\t\u000b9\u0003C\u0003Y\u001b\u0001\u0007\u0011\f\u000b\u0003\u000eE*\\\u0007FA\u0007n\u0003\u0001\"Xm\u001d;QCJ$\u0018\u000e^5p]N#\u0018\r^:XSRD7\t\\;ti\u0016\u0014\u0018N\\4\u0015\u0007\t\u000b\t\u0004C\u0003Y\u001d\u0001\u0007\u0011\f\u000b\u0003\u000fE*\\\u0007F\u0001\bn\u0003u!Xm\u001d;QCJ$\u0018\u000e^5p]N#\u0018\r^:XSRD'+Z:u_J,\u0007FA\bJ\u0003\r\"Xm\u001d;QCJ$\u0018\u000e^5p]N#\u0018\r^:XSRDW\n\u0012+D_6\u0004\u0018m\u0019;j_:D#\u0001E%\u0002aQ,7\u000f\u001e)beRLG/[8o'R\fGo\u001d'p_.,\boU6jaB,GMR8s\u0007\u0016\u0014H/Y5o\r&dG/\u001a:tQ\t\t\u0012*A\u0016uKN$HK]1og2\fG/Z%oi>\u001cu\u000e\\;n]N#\u0018\r^:J]\u0012,\u0007PR5mi\u0016\u0014X\t\u001f9sQ\t\u0011\u0012*A\u0012wC2LG-\u0019;f\u0007>tG/Y5og:+H\u000e\\!oIZ\u000bG.^3GS2$XM]:\u0015\u000f\t\u000bY%a\u001a\u0002\u0012\"9\u0011QJ\nA\u0002\u0005=\u0013A\u00033bi\u00064\u0015\u000e\u001c;feB!\u0011\u0011KA2\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013aC3yaJ,7o]5p]NTA!!\u0017\u0002\\\u0005A1-\u0019;bYf\u001cHO\u0003\u0003\u0002^\u0005}\u0013aA:rY*\u0019\u0011\u0011\r\u0015\u0002\u000bM\u0004\u0018M]6\n\t\u0005\u0015\u00141\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007bBA5'\u0001\u0007\u00111N\u0001\fS:$W\r_3e\u0007>d7\u000f\u0005\u0004\u0002n\u0005u\u00141\u0011\b\u0005\u0003_\nIH\u0004\u0003\u0002r\u0005]TBAA:\u0015\r\t)\bL\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015K1!a\u001fE\u0003\u001d\u0001\u0018mY6bO\u0016LA!a \u0002\u0002\n\u00191+Z9\u000b\u0007\u0005mD\t\u0005\u0003\u0002\u0006\u00065e\u0002BAD\u0003\u0013\u00032!!\u001dE\u0013\r\tY\tR\u0001\u0007!J,G-\u001a4\n\u0007y\nyIC\u0002\u0002\f\u0012Cq!a%\u0014\u0001\u0004\tI!A\u0007fqB,7\r^3e-\u0006dW/Z\u0001\bY&$XM]1m)\u0011\tI*a(\u0011\t\u0005E\u00131T\u0005\u0005\u0003;\u000b\u0019FA\u0004MSR,'/\u00197\t\r)$\u0002\u0019AAB\u0003):WM\\3sCR,7i\u001c7Ti\u0006$8/\u0012=qe\u001a{'o\u0012:fCR,'\u000f\u001e5b]>\u0013X)];bYN$b!a\u0014\u0002&\u0006%\u0006bBAT+\u0001\u0007\u00111Q\u0001\bG>dg*Y7f\u0011\u001d\tY+\u0006a\u0001\u0003\u0007\u000b\u0001bY8m-\u0006dW/Z\u0001\u0015m\u0016\u0014\u0018NZ=Rk\u0016\u0014\u0018\u0010\u0015:fI&\u001c\u0017\r^3\u0015\u0007\t\u000b\t\fC\u0004\u00024Z\u0001\r!!.\u0002\u0011!,H-[(qiN\u0004\u0002\"!\"\u00028\u0006\r\u00151Q\u0005\u0005\u0003s\u000byIA\u0002NCB\f\u0011\"\u0019;ue&\u0014W\u000f^3\u0015\t\u0005}\u0016Q\u0019\t\u0005\u0003#\n\t-\u0003\u0003\u0002D\u0006M#AE!uiJL'-\u001e;f%\u00164WM]3oG\u0016Dq!a2\u0018\u0001\u0004\t\u0019)A\u0005qCJ$\u0018\u000e^5p]\u0006y1M]3bi\u0016$V-\u001c9UC\ndW\rF\u0002C\u0003\u001bDq!a-\u0019\u0001\u0004\t),A\twKJLg-\u001f$jY\u0016\u0004&/\u001e8j]\u001e$rAQAj\u0003/\fI\u000eC\u0004\u0002Vf\u0001\r!!.\u0002\t=\u0004Ho\u001d\u0005\b\u0003\u001bJ\u0002\u0019AA(\u0011%\tY.\u0007I\u0001\u0002\u0004\tI!A\btQ>,H\u000eZ*lSB4\u0015\u000e\\3t\u0003m1XM]5gs\u001aKG.\u001a)sk:Lgn\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u001d\u0016\u0005\u0003\u0013\t\u0019o\u000b\u0002\u0002fB!\u0011q]Ay\u001b\t\tIO\u0003\u0003\u0002l\u00065\u0018!C;oG\",7m[3e\u0015\r\ty\u000fR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAz\u0003S\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003]9W\r\u001e'bi\u0016\u001cH\u000fR1uC\u001aKG.Z:D_VtG\u000f\u0006\u0004\u0002z\u0006}(\u0011\u0001\t\u0004\u0007\u0006m\u0018bAA\u007f\t\n!Aj\u001c8h\u0011\u001d\t)n\u0007a\u0001\u0003kC\u0011Ba\u0001\u001c!\u0003\u0005\r!!\u0003\u0002\u001f%t7\r\\;eK2{wMR5mKN\f\u0011eZ3u\u0019\u0006$Xm\u001d;ECR\fg)\u001b7fg\u000e{WO\u001c;%I\u00164\u0017-\u001e7uII\nacZ3u)\u0006\u0014G.\u001a$jY\u0016\u001c\u0016p\u001d;f[ZKWm\u001e\u000b\u0005\u0005\u0017\u00119\u0002\u0005\u0003\u0003\u000e\tMQB\u0001B\b\u0015\r\u0011\tBJ\u0001\t[\u0016$\u0018\rZ1uC&!!Q\u0003B\b\u0005qAun\u001c3jK6+G/\u00193bi\u00064\u0015\u000e\\3TsN$X-\u001c,jK^Dq!!6\u001e\u0001\u0004\t),\u0001\u000bqe>$Xm\u0019;fI\u0012jW\r^1DY&,g\u000e\u001e\u000b\u0005\u0005;\u0011I\u0003\u0005\u0003\u0003 \t\u0015RB\u0001B\u0011\u0015\r\u0011\u0019#X\u0001\u0006i\u0006\u0014G.Z\u0005\u0005\u0005O\u0011\tCA\u000bI_>$\u0017.\u001a+bE2,W*\u001a;b\u00072LWM\u001c;\t\u0011\t-b$!AA\u0002Q\n1\u0001\u001f\u00132Q\u0019\u0001!q\u00066\u00036A\u0019!J!\r\n\u0007\tM2JA\u0002UC\u001e\f\u0013!J\u0001\u0018)\u0016\u001cH\u000fU1si&$\u0018n\u001c8Ti\u0006$8/\u00138eKb\u0004\"a\f\u0011\u0014\u0007\u0001\u0012i\u0004E\u0002D\u0005\u007fI1A!\u0011E\u0005\u0019\te.\u001f*fMR\u0011!\u0011\b\u000b\u0003\u0005\u000f\u0002bA!\u0013\u0003T\t]SB\u0001B&\u0015\u0011\u0011iEa\u0014\u0002\rM$(/Z1n\u0015\r\u0011\tfO\u0001\u0005kRLG.\u0003\u0003\u0003V\t-#AB*ue\u0016\fW\u000eE\u0002d\u00053J1Aa\u0017e\u0005%\t%oZ;nK:$8\u000f")
public class TestPartitionStatsIndex
extends PartitionStatsIndexTestBase {
    private final String sqlTempTable;

    public static Stream<Arguments> supplyTestArguments() {
        return TestPartitionStatsIndex$.MODULE$.supplyTestArguments();
    }

    public /* synthetic */ HoodieTableMetaClient protected$metaClient(TestPartitionStatsIndex x$1) {
        return x$1.metaClient;
    }

    public String sqlTempTable() {
        return this.sqlTempTable;
    }

    @Test
    public void testPartitionStatsWithoutColumnStats() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"false"));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndPartitionStats$default$4()), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestPartitionStatsIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
    }

    @Test
    public void testPartitionStatsWithLogicalType() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)HoodieTableType.MERGE_ON_READ.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COLUMN_STATS_INDEX_FOR_COLUMNS.key()), (Object)"current_date")})));
        List records = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition"})).format("hudi").options((Map)hudiOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(KeyGeneratorOptions.URL_ENCODE_PARTITIONING.key(), "true").mode(SaveMode.Overwrite).save(this.basePath);
        Dataset snapshot0 = this.spark().read().format("org.apache.hudi").options((Map)hudiOpts).load(this.basePath);
        Assertions.assertEquals((long)100L, (long)snapshot0.count());
        List updateRecords = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(50)))).asScala()).toList();
        Dataset updateDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)updateRecords, 2, ClassTag$.MODULE$.apply(String.class)));
        updateDF.write().format("hudi").options((Map)hudiOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        scala.collection.immutable.Map readOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")})));
        Dataset snapshot1 = this.spark().read().format("org.apache.hudi").options((Map)readOpts).load(this.basePath);
        EqualTo dataFilter = new EqualTo((Expression)this.attribute("current_date"), (Expression)Literal$.MODULE$.apply(((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])snapshot1.limit(1).collect())).head()).getAs("current_date")));
        this.verifyFilePruning((scala.collection.immutable.Map<String, String>)readOpts, (Expression)dataFilter, false);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testIndexInitialization(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndPartitionStats$default$4());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testIndexWithUpsert(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndPartitionStats$default$4());
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndPartitionStats$default$4());
    }

    @Test
    public void testIndexWithUpsertNonPartitioned() {
        scala.collection.immutable.Map hudiOpts = ((scala.collection.immutable.Map)this.commonOpts().$minus((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()));
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, false);
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, false);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Assertions.assertFalse((boolean)this.metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.PARTITION_STATS.getPartitionPath()));
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testIndexUpsertAndRollback(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndPartitionStats$default$4());
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndPartitionStats$default$4());
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndPartitionStats$default$4());
        this.rollbackLastInstant((scala.collection.immutable.Map<String, String>)hudiOpts);
        this.validateDataAndPartitionStats(this.validateDataAndPartitionStats$default$1());
    }

    @Test
    public void testPartitionStatsIndexFilePruning() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"));
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, false);
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, false);
        this.createTempTable((scala.collection.immutable.Map<String, String>)hudiOpts);
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts);
    }

    @ParameterizedTest
    @MethodSource(value={"supplyTestArguments"})
    public void testPartitionStatsWithMultiWriter(HoodieTableType tableType, boolean useUpsert) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key()), (Object)WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.key()), (Object)HoodieFailedWritesCleaningPolicy.LAZY.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key()), (Object)InProcessLockProvider.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieLockConfig.WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS_NAME.key()), (Object)SimpleConcurrentFileWritesConflictResolutionStrategy.class.getName())})));
        Buffer insertRecords = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts(this.getInstantTime(), Predef$.MODULE$.int2Integer(20)))).asScala();
        this.doWriteAndValidateDataAndPartitionStats((Buffer<String>)insertRecords, (scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, false);
        Buffer write1Records = insertRecords;
        Buffer write2Records = useUpsert ? insertRecords : (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts(this.getInstantTime(), Predef$.MODULE$.int2Integer(20)))).asScala();
        ExecutorService executor = Executors.newFixedThreadPool(2);
        ExecutionContextExecutor executorContext = ExecutionContext$.MODULE$.fromExecutor((Executor)executor);
        Function1<Buffer<String>, Object> function = new Function1<Buffer<String>, Object>(this, hudiOpts, useUpsert){
            private final /* synthetic */ TestPartitionStatsIndex $outer;
            private final scala.collection.immutable.Map hudiOpts$2;
            private final boolean useUpsert$1;

            public boolean apply$mcZD$sp(double v1) {
                return Function1.apply$mcZD$sp$((Function1)this, (double)v1);
            }

            public double apply$mcDD$sp(double v1) {
                return Function1.apply$mcDD$sp$((Function1)this, (double)v1);
            }

            public float apply$mcFD$sp(double v1) {
                return Function1.apply$mcFD$sp$((Function1)this, (double)v1);
            }

            public int apply$mcID$sp(double v1) {
                return Function1.apply$mcID$sp$((Function1)this, (double)v1);
            }

            public long apply$mcJD$sp(double v1) {
                return Function1.apply$mcJD$sp$((Function1)this, (double)v1);
            }

            public void apply$mcVD$sp(double v1) {
                Function1.apply$mcVD$sp$((Function1)this, (double)v1);
            }

            public boolean apply$mcZF$sp(float v1) {
                return Function1.apply$mcZF$sp$((Function1)this, (float)v1);
            }

            public double apply$mcDF$sp(float v1) {
                return Function1.apply$mcDF$sp$((Function1)this, (float)v1);
            }

            public float apply$mcFF$sp(float v1) {
                return Function1.apply$mcFF$sp$((Function1)this, (float)v1);
            }

            public int apply$mcIF$sp(float v1) {
                return Function1.apply$mcIF$sp$((Function1)this, (float)v1);
            }

            public long apply$mcJF$sp(float v1) {
                return Function1.apply$mcJF$sp$((Function1)this, (float)v1);
            }

            public void apply$mcVF$sp(float v1) {
                Function1.apply$mcVF$sp$((Function1)this, (float)v1);
            }

            public boolean apply$mcZI$sp(int v1) {
                return Function1.apply$mcZI$sp$((Function1)this, (int)v1);
            }

            public double apply$mcDI$sp(int v1) {
                return Function1.apply$mcDI$sp$((Function1)this, (int)v1);
            }

            public float apply$mcFI$sp(int v1) {
                return Function1.apply$mcFI$sp$((Function1)this, (int)v1);
            }

            public int apply$mcII$sp(int v1) {
                return Function1.apply$mcII$sp$((Function1)this, (int)v1);
            }

            public long apply$mcJI$sp(int v1) {
                return Function1.apply$mcJI$sp$((Function1)this, (int)v1);
            }

            public void apply$mcVI$sp(int v1) {
                Function1.apply$mcVI$sp$((Function1)this, (int)v1);
            }

            public boolean apply$mcZJ$sp(long v1) {
                return Function1.apply$mcZJ$sp$((Function1)this, (long)v1);
            }

            public double apply$mcDJ$sp(long v1) {
                return Function1.apply$mcDJ$sp$((Function1)this, (long)v1);
            }

            public float apply$mcFJ$sp(long v1) {
                return Function1.apply$mcFJ$sp$((Function1)this, (long)v1);
            }

            public int apply$mcIJ$sp(long v1) {
                return Function1.apply$mcIJ$sp$((Function1)this, (long)v1);
            }

            public long apply$mcJJ$sp(long v1) {
                return Function1.apply$mcJJ$sp$((Function1)this, (long)v1);
            }

            public void apply$mcVJ$sp(long v1) {
                Function1.apply$mcVJ$sp$((Function1)this, (long)v1);
            }

            public <A> Function1<A, Object> compose(Function1<A, Buffer<String>> g) {
                return Function1.compose$((Function1)this, g);
            }

            public <A> Function1<Buffer<String>, A> andThen(Function1<Object, A> g) {
                return Function1.andThen$((Function1)this, g);
            }

            public String toString() {
                return Function1.toString$((Function1)this);
            }

            public boolean apply(Buffer<String> records) {
                boolean bl;
                try {
                    this.$outer.doWriteAndValidateDataAndPartitionStats(records, (scala.collection.immutable.Map<String, String>)this.hudiOpts$2, this.useUpsert$1 ? DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL() : DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL(), SaveMode.Append, false);
                    bl = true;
                }
                catch (HoodieWriteConflictException hoodieWriteConflictException) {
                    bl = false;
                }
                catch (Throwable e) {
                    throw new Exception("Multi write failed", e);
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hudiOpts$2 = hudiOpts$2;
                this.useUpsert$1 = useUpsert$1;
                Function1.$init$((Function1)this);
            }
        };
        Future f1 = Future$.MODULE$.apply((Function0)((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestPartitionStatsIndex.$anonfun$testPartitionStatsWithMultiWriter$1((Function1)function, write1Records)), (ExecutionContext)executorContext);
        Future f2 = Future$.MODULE$.apply((Function0)((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestPartitionStatsIndex.$anonfun$testPartitionStatsWithMultiWriter$2((Function1)function, write2Records)), (ExecutionContext)executorContext);
        Await$.MODULE$.result((Awaitable)f1, Duration$.MODULE$.apply("5 minutes"));
        Await$.MODULE$.result((Awaitable)f2, Duration$.MODULE$.apply("5 minutes"));
        Assertions.assertTrue((BoxesRunTime.unboxToBoolean((Object)((Try)f1.value().get()).get()) || BoxesRunTime.unboxToBoolean((Object)((Try)f2.value().get()).get()) ? 1 : 0) != 0);
        executor.shutdownNow();
        if (useUpsert) {
            this.pollForTimeline(this.basePath, this.storageConf, 2);
            Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.hasPendingCommits()));
        } else {
            this.pollForTimeline(this.basePath, this.storageConf, 3);
            Assertions.assertTrue((boolean)this.checkIfCommitsAreConcurrent());
        }
        this.validateDataAndPartitionStats(this.validateDataAndPartitionStats$default$1());
    }

    @Test
    public void testPartitionStatsWithPartitionBy() {
        scala.collection.immutable.Map hudiOpts = (scala.collection.immutable.Map)this.commonOpts().$minus((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key());
        List records = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition"})).format("hudi").options((Map)hudiOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(KeyGeneratorOptions.URL_ENCODE_PARTITIONING.key(), "true").mode(SaveMode.Overwrite).save(this.basePath);
        Dataset snapshot0 = this.spark().read().format("org.apache.hudi").options((Map)hudiOpts).load(this.basePath).where("partition > '2015/03/16'");
        snapshot0.cache();
        Assertions.assertTrue((boolean)this.checkPartitionFilters(snapshot0.queryExecution().executedPlan().toString(), "partition.* > 2015/03/16"));
        Assertions.assertEquals((long)67L, (long)snapshot0.count());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testPartitionStatsWithCompactionAndCleaning(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEANER_COMMITS_RETAINED.key()), (Object)"1")})));
        HoodieTableType hoodieTableType = tableType;
        HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
        if (!(hoodieTableType != null ? !hoodieTableType.equals(hoodieTableType2) : hoodieTableType2 != null)) {
            hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT.key()), (Object)"0")})));
        }
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndPartitionStats$default$4());
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndPartitionStats$default$4());
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndPartitionStats$default$4());
        Option lastCleanInstant = this.getLatestMetaClient(false).getActiveTimeline().getCleanerTimeline().lastInstant();
        Assertions.assertTrue((boolean)lastCleanInstant.isPresent());
        HoodieTableType hoodieTableType3 = tableType;
        HoodieTableType hoodieTableType4 = HoodieTableType.MERGE_ON_READ;
        if (!(hoodieTableType3 != null ? !hoodieTableType3.equals(hoodieTableType4) : hoodieTableType4 != null)) {
            Option lastCompactionInstant = this.getLatestMetaClient(false).getActiveTimeline().getCommitTimeline().filterCompletedInstants().lastInstant();
            Assertions.assertTrue((boolean)lastCompactionInstant.isPresent());
        }
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndPartitionStats$default$4());
        this.validateDataAndPartitionStats(this.validateDataAndPartitionStats$default$1());
        this.createTempTable((scala.collection.immutable.Map<String, String>)hudiOpts);
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testPartitionStatsWithClustering(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.INLINE_CLUSTERING.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS.key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KeyGeneratorOptions.URL_ENCODE_PARTITIONING.key()), (Object)"true")})));
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndPartitionStats$default$4());
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndPartitionStats$default$4());
        Option<HoodieInstant> lastClusteringInstant = this.getLatestClusteringInstant();
        Assertions.assertTrue((boolean)this.getLatestClusteringInstant().isPresent());
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndPartitionStats$default$4());
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndPartitionStats$default$4());
        Assertions.assertTrue((((HoodieInstant)this.getLatestClusteringInstant().get()).requestedTime().compareTo(((HoodieInstant)lastClusteringInstant.get()).requestedTime()) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals(this.getLatestClusteringInstant(), (Object)this.metaClient.getActiveTimeline().lastInstant());
        this.rollbackLastInstant((scala.collection.immutable.Map<String, String>)hudiOpts);
        this.validateDataAndPartitionStats(this.validateDataAndPartitionStats$default$1());
        this.createTempTable((scala.collection.immutable.Map<String, String>)hudiOpts);
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts);
    }

    @Test
    public void testPartitionStatsWithRestore() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)HoodieTableType.MERGE_ON_READ.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key()), (Object)"true")})));
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndPartitionStats$default$4());
        Option firstCompletedInstant = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant();
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndPartitionStats$default$4());
        Assertions.assertTrue((boolean)this.metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        Assertions.assertTrue((boolean)this.metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.RECORD_INDEX.getPartitionPath()));
        SparkRDDWriteClient writeClient = new SparkRDDWriteClient((HoodieEngineContext)new HoodieSparkEngineContext(this.jsc), this.getWriteConfig((scala.collection.immutable.Map<String, String>)hudiOpts));
        writeClient.savepoint(((HoodieInstant)firstCompletedInstant.get()).requestedTime(), "testUser", "savepoint to first commit");
        String savepointTimestamp = ((HoodieInstant)this.metaClient.reloadActiveTimeline().getSavePointTimeline().filterCompletedInstants().lastInstant().get()).requestedTime();
        Assertions.assertEquals((Object)((HoodieInstant)firstCompletedInstant.get()).requestedTime(), (Object)savepointTimestamp);
        writeClient.restoreToSavepoint(savepointTimestamp);
        Assertions.assertTrue((boolean)this.metaClient.reloadActiveTimeline().getRestoreTimeline().lastInstant().isPresent());
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Assertions.assertFalse((boolean)this.metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.PARTITION_STATS.getPartitionPath()));
        Assertions.assertFalse((boolean)this.metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.COLUMN_STATS.getPartitionPath()));
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, false);
        Dataset latestDf = this.spark().read().format("hudi").options((Map)hudiOpts).load(this.basePath);
        PartitionStatsIndexSupport partitionStatsIndex = new PartitionStatsIndexSupport(this.spark(), latestDf.schema(), HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexPartitionStats(true).build(), this.metaClient, PartitionStatsIndexSupport$.MODULE$.$lessinit$greater$default$5());
        Seq<String> x$1 = this.targetColumnsToIndex();
        boolean x$2 = true;
        scala.Option x$3 = partitionStatsIndex.loadColumnStatsIndexRecords$default$2();
        java.util.List partitionStats = partitionStatsIndex.loadColumnStatsIndexRecords(x$1, x$3, x$2).collectAsList();
        Assertions.assertTrue((partitionStats.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPartitionStatsWithMDTCompaction() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"2")})));
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndPartitionStats$default$4());
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndPartitionStats$default$4());
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndPartitionStats$default$4());
        try (HoodieTableFileSystemView metadataTableFSView = ((HoodieBackedTableMetadata)this.getHoodieTable(this.metaClient, this.getWriteConfig((scala.collection.immutable.Map<String, String>)hudiOpts)).getMetadataTable()).getMetadataFileSystemView();){
            HoodieTimeline compactionTimeline = metadataTableFSView.getVisibleCommitsAndCompactionTimeline().filterCompletedAndCompactionInstants();
            Option lastCompactionInstant = compactionTimeline.filter(JavaConversions$.MODULE$.getPredicate((Function1 & Serializable & scala.Serializable)instant -> BoxesRunTime.boxToBoolean((boolean)TestPartitionStatsIndex.$anonfun$testPartitionStatsWithMDTCompaction$1(this, compactionTimeline, instant)))).lastInstant();
            Optional compactionBaseFile = metadataTableFSView.getAllBaseFiles(MetadataPartitionType.PARTITION_STATS.getPartitionPath()).filter(JavaConversions$.MODULE$.getPredicate((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)TestPartitionStatsIndex.$anonfun$testPartitionStatsWithMDTCompaction$2(lastCompactionInstant, f)))).findAny();
            Assertions.assertTrue((boolean)compactionBaseFile.isPresent());
        }
    }

    @Test
    public void testPartitionStatsLookupSkippedForCertainFilters() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)HoodieTableType.MERGE_ON_READ.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")})));
        this.doWriteAndValidateDataAndPartitionStats((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndPartitionStats$default$4());
        IsNull dataFilter = new IsNull((Expression)this.attribute("_row_key"));
        Seq indexedCols = (Seq)new .colon.colon((Object)"_row_key", (List)Nil$.MODULE$);
        this.validateContainsNullAndValueFilters((Expression)dataFilter, (Seq<String>)indexedCols, true);
        this.verifyFilePruning((scala.collection.immutable.Map<String, String>)hudiOpts, (Expression)dataFilter, false);
    }

    @Test
    public void testTranslateIntoColumnStatsIndexFilterExpr() {
        EqualTo dataFilter = new EqualTo((Expression)this.attribute("c1"), (Expression)this.literal("619sdc"));
        this.validateContainsNullAndValueFilters((Expression)dataFilter, (Seq<String>)((Seq)new .colon.colon((Object)"c1", (List)Nil$.MODULE$)), false);
        And dataFilter1 = new And((Expression)dataFilter, (Expression)new EqualTo((Expression)this.attribute("c2"), (Expression)this.literal("100")));
        this.validateContainsNullAndValueFilters((Expression)dataFilter1, (Seq<String>)((Seq)new .colon.colon((Object)"c1", (List)new .colon.colon((Object)"c2", (List)Nil$.MODULE$))), false);
        And dataFilter2 = new And((Expression)dataFilter, (Expression)new IsNull((Expression)this.attribute("c3")));
        this.validateContainsNullAndValueFilters((Expression)dataFilter2, (Seq<String>)((Seq)new .colon.colon((Object)"c1", (List)new .colon.colon((Object)"c2", (List)new .colon.colon((Object)"c3", (List)Nil$.MODULE$)))), true);
        And dataFilter3 = new And((Expression)dataFilter, (Expression)new IsNotNull((Expression)this.attribute("c4")));
        this.validateContainsNullAndValueFilters((Expression)dataFilter3, (Seq<String>)((Seq)new .colon.colon((Object)"c1", (List)new .colon.colon((Object)"c2", (List)new .colon.colon((Object)"c3", (List)new .colon.colon((Object)"c4", (List)Nil$.MODULE$))))), true);
        And dataFilter4 = new And((Expression)new Or((Expression)new EqualTo((Expression)this.attribute("c1"), (Expression)this.literal("619sdc")), (Expression)new And((Expression)new EqualTo((Expression)this.attribute("c2"), (Expression)this.literal("100")), (Expression)new EqualTo((Expression)this.attribute("c3"), (Expression)this.literal("200")))), (Expression)new EqualTo((Expression)this.attribute("c4"), (Expression)this.literal("300")));
        this.validateContainsNullAndValueFilters((Expression)dataFilter4, (Seq<String>)((Seq)new .colon.colon((Object)"c1", (List)new .colon.colon((Object)"c2", (List)new .colon.colon((Object)"c3", (List)new .colon.colon((Object)"c4", (List)Nil$.MODULE$))))), false);
        Or dataFilter5 = new Or((Expression)dataFilter4, (Expression)new And((Expression)new Or((Expression)new EqualTo((Expression)this.attribute("c1"), (Expression)this.literal("619sdc")), (Expression)new And((Expression)new EqualTo((Expression)this.attribute("c2"), (Expression)this.literal("100")), (Expression)new EqualTo((Expression)this.attribute("c3"), (Expression)this.literal("200")))), (Expression)new IsNotNull((Expression)this.attribute("c4"))));
        this.validateContainsNullAndValueFilters((Expression)dataFilter5, (Seq<String>)((Seq)new .colon.colon((Object)"c1", (List)new .colon.colon((Object)"c2", (List)new .colon.colon((Object)"c3", (List)new .colon.colon((Object)"c4", (List)Nil$.MODULE$))))), true);
        BitwiseOr dataFilter6 = new BitwiseOr((Expression)new EqualTo((Expression)this.attribute("c1"), (Expression)this.literal("619sdc")), (Expression)new EqualTo((Expression)this.attribute("c2"), (Expression)this.literal("100")));
        this.validateContainsNullAndValueFilters((Expression)dataFilter6, (Seq<String>)((Seq)new .colon.colon((Object)"c1", (List)new .colon.colon((Object)"c2", (List)new .colon.colon((Object)"c3", (List)new .colon.colon((Object)"c4", (List)Nil$.MODULE$))))), false);
        BinaryOperator largeFilter = (BinaryOperator)((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).map((Function1 & Serializable & scala.Serializable)i -> TestPartitionStatsIndex.$anonfun$testTranslateIntoColumnStatsIndexFilterExpr$1(this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).reduce((Function2)And$.MODULE$);
        IndexedSeq indexedColumns = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50).map((Function1 & Serializable & scala.Serializable)i -> TestPartitionStatsIndex.$anonfun$testTranslateIntoColumnStatsIndexFilterExpr$2(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.validateContainsNullAndValueFilters((Expression)largeFilter, (Seq<String>)indexedColumns, false);
        And largeFilter1 = new And((Expression)largeFilter, (Expression)new IsNull((Expression)this.attribute("c10")));
        this.validateContainsNullAndValueFilters((Expression)largeFilter1, (Seq<String>)indexedColumns, true);
        dataFilter = new Not((Expression)new IsNull((Expression)this.attribute("c1")));
        this.validateContainsNullAndValueFilters((Expression)dataFilter, (Seq<String>)((Seq)new .colon.colon((Object)"c1", (List)Nil$.MODULE$)), true);
        this.validateContainsNullAndValueFilters((Expression)dataFilter, (Seq<String>)((Seq)new .colon.colon((Object)"c2", (List)Nil$.MODULE$)), false);
        dataFilter = new Not((Expression)new IsNotNull((Expression)this.attribute("c2")));
        this.validateContainsNullAndValueFilters((Expression)dataFilter, (Seq<String>)((Seq)new .colon.colon((Object)"c2", (List)Nil$.MODULE$)), true);
        dataFilter = new Not((Expression)new EqualNullSafe((Expression)this.attribute("c3"), (Expression)Literal$.MODULE$.apply((Object)"value")));
        this.validateContainsNullAndValueFilters((Expression)dataFilter, (Seq<String>)((Seq)new .colon.colon((Object)"c3", (List)Nil$.MODULE$)), false);
        dataFilter = new Not((Expression)new Not((Expression)new IsNull((Expression)this.attribute("c1"))));
        this.validateContainsNullAndValueFilters((Expression)dataFilter, (Seq<String>)((Seq)new .colon.colon((Object)"c1", (List)Nil$.MODULE$)), true);
        dataFilter = new Not((Expression)new And((Expression)new IsNull((Expression)this.attribute("c1")), (Expression)new Or((Expression)new IsNotNull((Expression)this.attribute("c2")), (Expression)new EqualNullSafe((Expression)this.attribute("c3"), (Expression)this.literal("value")))));
        this.validateContainsNullAndValueFilters((Expression)dataFilter, (Seq<String>)((Seq)new .colon.colon((Object)"c1", (List)new .colon.colon((Object)"c2", (List)new .colon.colon((Object)"c3", (List)Nil$.MODULE$)))), true);
        this.validateContainsNullAndValueFilters((Expression)dataFilter, (Seq<String>)((Seq)Nil$.MODULE$), false);
    }

    public void validateContainsNullAndValueFilters(Expression dataFilter, Seq<String> indexedCols, boolean expectedValue) {
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectedValue), (Object)BoxesRunTime.boxToBoolean((boolean)DataSkippingUtils$.MODULE$.containsNullOrValueCountBasedFilters(dataFilter, indexedCols)));
    }

    private Literal literal(String value) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestPartitionStatsIndex.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestPartitionStatsIndex$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_functional_TestPartitionStatsIndex$$typecreator1$1(TestPartitionStatsIndex $outer) {
            }
        }
        return Literal$.MODULE$.create((Object)value, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestPartitionStatsIndex$$typecreator1$1(null)));
    }

    public Expression generateColStatsExprForGreaterthanOrEquals(String colName, String colValue) {
        GreaterThanOrEqual expectedExpr = new GreaterThanOrEqual((Expression)UnresolvedAttribute$.MODULE$.apply(new StringBuilder(9).append(colName).append("_maxValue").toString()), (Expression)this.literal(colValue));
        return new And((Expression)new LessThanOrEqual((Expression)UnresolvedAttribute$.MODULE$.apply(new StringBuilder(9).append(colName).append("_minValue").toString()), (Expression)this.literal(colValue)), (Expression)expectedExpr);
    }

    public void verifyQueryPredicate(scala.collection.immutable.Map<String, String> hudiOpts) {
        Row candidateRow = (Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.mergedDfList().last()).groupBy("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().limit(1).collect())).head();
        String rowKey = (String)candidateRow.getAs("_row_key");
        long count = candidateRow.getLong(1);
        EqualTo dataFilter = new EqualTo((Expression)this.attribute("_row_key"), (Expression)Literal$.MODULE$.apply((Object)rowKey));
        Assertions.assertEquals((long)count, (long)this.spark().sql(new StringBuilder(21).append("select * from ").append(this.sqlTempTable()).append(" where ").append(dataFilter.sql()).toString()).count());
        this.verifyFilePruning(hudiOpts, (Expression)dataFilter, this.verifyFilePruning$default$3());
        IsNotNull dataFilter1 = new IsNotNull((Expression)this.attribute("_row_key"));
        this.verifyFilePruning(hudiOpts, (Expression)dataFilter1, false);
    }

    private AttributeReference attribute(String partition) {
        String x$1 = partition;
        StringType$ x$2 = StringType$.MODULE$;
        boolean x$3 = true;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
        return new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6);
    }

    private void createTempTable(scala.collection.immutable.Map<String, String> hudiOpts) {
        Dataset readDf = this.spark().read().format("hudi").options(hudiOpts).load(this.basePath);
        readDf.createOrReplaceTempView(this.sqlTempTable());
    }

    private void verifyFilePruning(scala.collection.immutable.Map<String, String> opts, Expression dataFilter, boolean shouldSkipFiles) {
        scala.collection.immutable.Map commonOpts = opts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.basePath));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        SparkSession x$1 = this.spark();
        HoodieTableMetaClient x$2 = this.metaClient;
        None$ x$3 = None$.MODULE$;
        scala.collection.immutable.Map x$4 = commonOpts;
        boolean x$5 = true;
        FileStatusCache x$6 = HoodieFileIndex$.MODULE$.apply$default$5();
        boolean x$7 = HoodieFileIndex$.MODULE$.apply$default$7();
        HoodieFileIndex fileIndex = new HoodieFileIndex(x$1, x$2, (scala.Option)x$3, x$4, x$6, x$5, x$7);
        Seq filteredPartitionDirectories = fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$));
        int filteredFilesCount = ((SeqLike)filteredPartitionDirectories.flatMap((Function1 & Serializable & scala.Serializable)s -> s.files(), Seq$.MODULE$.canBuildFrom())).size();
        if (shouldSkipFiles) {
            Assertions.assertTrue(((long)filteredFilesCount <= this.getLatestDataFilesCount(opts, this.getLatestDataFilesCount$default$2()) ? 1 : 0) != 0);
        } else {
            Assertions.assertTrue(((long)filteredFilesCount == this.getLatestDataFilesCount(opts, this.getLatestDataFilesCount$default$2()) ? 1 : 0) != 0);
        }
        SparkSession x$8 = this.spark();
        HoodieTableMetaClient x$9 = this.metaClient;
        None$ x$10 = None$.MODULE$;
        scala.collection.immutable.Map x$11 = commonOpts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"false"));
        boolean x$12 = true;
        FileStatusCache x$13 = HoodieFileIndex$.MODULE$.apply$default$5();
        boolean x$14 = HoodieFileIndex$.MODULE$.apply$default$7();
        fileIndex = new HoodieFileIndex(x$8, x$9, (scala.Option)x$10, x$11, x$13, x$12, x$14);
        int filesCountWithNoSkipping = ((SeqLike)fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)s -> s.files(), Seq$.MODULE$.canBuildFrom())).size();
        Assertions.assertTrue((filteredFilesCount <= filesCountWithNoSkipping ? 1 : 0) != 0);
    }

    private boolean verifyFilePruning$default$3() {
        return true;
    }

    private long getLatestDataFilesCount(scala.collection.immutable.Map<String, String> opts, boolean includeLogFiles) {
        LongRef totalLatestDataFiles = LongRef.create((long)0L);
        this.getTableFileSystemView(opts).getAllLatestFileSlicesBeforeOrOn(((HoodieInstant)this.metaClient.getActiveTimeline().lastInstant().get()).requestedTime()).values().forEach(JFunction$.MODULE$.toJavaConsumer((Function1 & Serializable & scala.Serializable)slices -> {
            slices.forEach(JFunction$.MODULE$.toJavaConsumer((Function1 & Serializable & scala.Serializable)slice -> {
                totalLatestDataFiles$1.elem = totalLatestDataFiles$1.elem + ((includeLogFiles$1 ? slice.getLogFiles().count() : 0L) + (long)(slice.getBaseFile().isPresent() ? 1 : 0));
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }));
        return totalLatestDataFiles.elem;
    }

    private boolean getLatestDataFilesCount$default$2() {
        return true;
    }

    private HoodieMetadataFileSystemView getTableFileSystemView(scala.collection.immutable.Map<String, String> opts) {
        return new HoodieMetadataFileSystemView(this.metaClient, (HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieTableMetadata)this.metadataWriter(this.getWriteConfig(opts)).getTableMetadata());
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionStatsWithMultiWriter$1(Function1 function$1, Buffer write1Records$1) {
        return BoxesRunTime.unboxToBoolean((Object)function$1.apply((Object)write1Records$1));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionStatsWithMultiWriter$2(Function1 function$1, Buffer write2Records$1) {
        return BoxesRunTime.unboxToBoolean((Object)function$1.apply((Object)write2Records$1));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionStatsWithMDTCompaction$1(TestPartitionStatsIndex $this, HoodieTimeline compactionTimeline$1, HoodieInstant instant) {
        WriteOperationType writeOperationType = ((HoodieCommitMetadata)$this.protected$metaClient($this).getTimelineLayout().getCommitMetadataSerDe().deserialize(instant, (byte[])compactionTimeline$1.getInstantDetails(instant).get(), HoodieCommitMetadata.class)).getOperationType();
        WriteOperationType writeOperationType2 = WriteOperationType.COMPACT;
        return !(writeOperationType != null ? !writeOperationType.equals(writeOperationType2) : writeOperationType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionStatsWithMDTCompaction$2(Option lastCompactionInstant$1, HoodieBaseFile f) {
        return f.getCommitTime().equals(((HoodieInstant)lastCompactionInstant$1.get()).requestedTime());
    }

    public static final /* synthetic */ EqualTo $anonfun$testTranslateIntoColumnStatsIndexFilterExpr$1(TestPartitionStatsIndex $this, int i) {
        return new EqualTo((Expression)$this.attribute(new StringBuilder(1).append("c").append(i).toString()), (Expression)$this.literal("value"));
    }

    public static final /* synthetic */ String $anonfun$testTranslateIntoColumnStatsIndexFilterExpr$2(int i) {
        return new StringBuilder(1).append("c").append(i).toString();
    }

    public TestPartitionStatsIndex() {
        this.sqlTempTable = "hudi_tbl";
    }
}

