/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.HoodieFileIndex$;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.metadata.HoodieMetadataFileSystemView;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.util.JFunction$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@org.junit.jupiter.api.Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0007\u000f\u0001]AQa\t\u0001\u0005\u0002\u0011Bqa\n\u0001C\u0002\u0013\u0005\u0001\u0006\u0003\u00042\u0001\u0001\u0006I!\u000b\u0005\u0006e\u0001!\ta\r\u0005\u0006\u000b\u0002!IA\u0012\u0005\u0006+\u0002!IA\u0016\u0005\bm\u0002\t\n\u0011\"\u0003x\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000fA\u0001\"a\n\u0001#\u0003%Ia\u001e\u0005\b\u0003S\u0001A\u0011BA\u0016\u0011!\tI\u0004AI\u0001\n\u00139\bbBA\u001e\u0001\u0011%\u0011Q\b\u0002\u001f)\u0016\u001cH\u000fU1si&$\u0018n\u001c8Ti\u0006$8/\u00138eKb<\u0016\u000e\u001e5Tc2T!a\u0004\t\u0002\u0015\u0019,hn\u0019;j_:\fGN\u0003\u0002\u0012%\u0005!\u0001.\u001e3j\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033\u0005j\u0011A\u0007\u0006\u00037q\taaY8n[>t'BA\t\u001e\u0015\tqr$A\u0002tc2T!\u0001\t\n\u0002\u000bM\u0004\u0018M]6\n\u0005\tR\"A\u0006%p_\u0012LWm\u00159be.\u001c\u0016\u000f\u001c+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u0005q\u0011\u0001D:rYR+W\u000e\u001d+bE2,W#A\u0015\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001\u00027b]\u001eT\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\t11\u000b\u001e:j]\u001e\fQb]9m)\u0016l\u0007\u000fV1cY\u0016\u0004\u0013\u0001B5oSR$\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\u0005+:LG\u000f\u000b\u0002\u0005wA\u0011AhQ\u0007\u0002{)\u0011ahP\u0001\u0004CBL'B\u0001!B\u0003\u001dQW\u000f]5uKJT!A\u0011\u000b\u0002\u000b),h.\u001b;\n\u0005\u0011k$!\u0003\"fM>\u0014X-\u00117m\u0003y9(/\u001b;f\u0003:$g+\u00197jI\u0006$X\rU1si&$\u0018n\u001c8Ti\u0006$8\u000fF\u00025\u000fNCQ\u0001S\u0003A\u0002%\u000b\u0011\u0002^1cY\u0016t\u0015-\\3\u0011\u0005)\u000bfBA&P!\tae'D\u0001N\u0015\tqe#\u0001\u0004=e>|GOP\u0005\u0003!Z\na\u0001\u0015:fI\u00164\u0017B\u0001\u0019S\u0015\t\u0001f\u0007C\u0003U\u000b\u0001\u0007\u0011*A\u0005uC\ndW\rU1uQ\u0006\tb/\u001a:jMf4\u0015\u000e\\3QeVt\u0017N\\4\u0015\rQ:FLZ8u\u0011\u0015Af\u00011\u0001Z\u0003\u0011y\u0007\u000f^:\u0011\t)S\u0016*S\u0005\u00037J\u00131!T1q\u0011\u0015if\u00011\u0001_\u0003)!\u0017\r^1GS2$XM\u001d\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\f1\"\u001a=qe\u0016\u001c8/[8og*\u00111-H\u0001\tG\u0006$\u0018\r\\=ti&\u0011Q\r\u0019\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\"B4\u0007\u0001\u0004A\u0017AC7fi\u0006\u001cE.[3oiB\u0011\u0011.\\\u0007\u0002U*\u00111\u000e\\\u0001\u0006i\u0006\u0014G.\u001a\u0006\u00037AI!A\u001c6\u0003+!{w\u000eZ5f)\u0006\u0014G.Z'fi\u0006\u001cE.[3oi\")\u0001O\u0002a\u0001c\u00061\u0012n\u001d#bi\u0006\u001c6.\u001b9qS:<W\t\u001f9fGR,G\r\u0005\u00026e&\u00111O\u000e\u0002\b\u0005>|G.Z1o\u0011\u001d)h\u0001%AA\u0002E\f\u0001#[:O_N\u001b\u0017M\\#ya\u0016\u001cG/\u001a3\u00027Y,'/\u001b4z\r&dW\r\u0015:v]&tw\r\n3fM\u0006,H\u000e\u001e\u00136+\u0005A(FA9zW\u0005Q\bcA>\u0002\u00025\tAP\u0003\u0002~}\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u007fZ\n!\"\u00198o_R\fG/[8o\u0013\r\t\u0019\u0001 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\b<fe&4\u0017PR5mKB\u0013XO\\5oO\u0016C\bO]3tg&|gn\u001d\u000b\fi\u0005%\u00111BA\u0011\u0003G\t)\u0003C\u0003Y\u0011\u0001\u0007\u0011\fC\u0004\u0002\u000e!\u0001\r!a\u0004\u0002\u0017\u0011\fG/\u0019$jYR,'o\u001d\t\u0006\u0003#\tYB\u0018\b\u0005\u0003'\t9BD\u0002M\u0003+I\u0011aN\u0005\u0004\u000331\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003;\tyBA\u0002TKFT1!!\u00077\u0011\u00159\u0007\u00021\u0001i\u0011\u0015\u0001\b\u00021\u0001r\u0011\u001d)\b\u0002%AA\u0002E\faE^3sS\u001aLh)\u001b7f!J,h.\u001b8h\u000bb\u0004(/Z:tS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003]9W\r\u001e'bi\u0016\u001cH\u000fR1uC\u001aKG.Z:D_VtG\u000f\u0006\u0004\u0002.\u0005M\u0012q\u0007\t\u0004k\u0005=\u0012bAA\u0019m\t!Aj\u001c8h\u0011!\t)D\u0003I\u0001\u0002\u0004\t\u0018aD5oG2,H-\u001a'pO\u001aKG.Z:\t\u000b\u001dT\u0001\u0019\u00015\u0002C\u001d,G\u000fT1uKN$H)\u0019;b\r&dWm]\"pk:$H\u0005Z3gCVdG\u000fJ\u0019\u0002-\u001d,G\u000fV1cY\u00164\u0015\u000e\\3TsN$X-\u001c,jK^$B!a\u0010\u0002LA!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002FA\t\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003\u0013\n\u0019E\u0001\u000fI_>$\u0017.Z'fi\u0006$\u0017\r^1GS2,7+_:uK64\u0016.Z<\t\u000b\u001dd\u0001\u0019\u00015)\u000f\u0001\ty%!\u0016\u0002XA\u0019A(!\u0015\n\u0007\u0005MSHA\u0002UC\u001e\fQA^1mk\u0016\f\u0013a\u0004")
public class TestPartitionStatsIndexWithSql
extends HoodieSparkSqlTestBase {
    private final String sqlTempTable;

    public String sqlTempTable() {
        return this.sqlTempTable;
    }

    @BeforeAll
    public void init() {
        this.initQueryIndexConf();
    }

    private void writeAndValidatePartitionStats(String tableName, String tablePath) {
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(179).append("\n         | insert into ").append(tableName).append("\n         | values (1, 'a1', 1000, 10), (2, 'a2', 2000, 20), (3, 'a3', 3000, 30), (4, 'a4', 2000, 10), (5, 'a5', 3000, 20), (6, 'a6', 4000, 30)\n         | ").toString())).stripMargin());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        this.assertResult(tableName, metaClient.getTableConfig().getTableName(), Prettifier$.MODULE$.default(), new Position("TestPartitionStatsIndexWithSql.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.PARTITION_STATS.getPartitionPath()));
        this.spark().sql("set hoodie.metadata.enable=true");
        this.spark().sql("set hoodie.enable.data.skipping=true");
        this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        this.checkAnswer(new StringBuilder(49).append("select id, name, price, ts from ").append(tableName).append(" where price>3000").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", BoxesRunTime.boxToInteger((int)4000), BoxesRunTime.boxToInteger((int)30)}))}));
        this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set price = price + 1 where id = 6").toString());
        this.checkAnswer(new StringBuilder(49).append("select id, name, price, ts from ").append(tableName).append(" where price>3000").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", BoxesRunTime.boxToInteger((int)4001), BoxesRunTime.boxToInteger((int)30)}))}));
        String x$1 = "price";
        IntegerType$ x$2 = IntegerType$.MODULE$;
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
        this.verifyFilePruning((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}))), (Expression)new GreaterThan((Expression)new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3000))), HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient), true, this.verifyFilePruning$default$5());
        String x$7 = "price";
        IntegerType$ x$8 = IntegerType$.MODULE$;
        boolean x$9 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, (DataType)x$8, x$9, x$10);
        Seq x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, (DataType)x$8, x$9, x$10);
        this.verifyFilePruning((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}))), (Expression)new GreaterThan((Expression)new AttributeReference(x$7, (DataType)x$8, x$9, x$10, x$11, x$12), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3000))), HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient), false, this.verifyFilePruning$default$5());
    }

    private void verifyFilePruning(Map<String, String> opts, Expression dataFilter, HoodieTableMetaClient metaClient, boolean isDataSkippingExpected, boolean isNoScanExpected) {
        this.verifyFilePruningExpressions(opts, (Seq<Expression>)((Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)), metaClient, isDataSkippingExpected, isNoScanExpected);
    }

    private boolean verifyFilePruning$default$5() {
        return false;
    }

    private void verifyFilePruningExpressions(Map<String, String> opts, Seq<Expression> dataFilters, HoodieTableMetaClient metaClient, boolean isDataSkippingExpected, boolean isNoScanExpected) {
        Map commonOpts = opts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)metaClient.getBasePath().toString()));
        SparkSession x$1 = this.spark();
        HoodieTableMetaClient x$2 = metaClient;
        None$ x$3 = None$.MODULE$;
        Map x$4 = commonOpts;
        boolean x$5 = true;
        FileStatusCache x$6 = HoodieFileIndex$.MODULE$.apply$default$5();
        boolean x$7 = HoodieFileIndex$.MODULE$.apply$default$7();
        try (HoodieFileIndex fileIndex = new HoodieFileIndex(x$1, x$2, (Option)x$3, x$4, x$6, x$5, x$7);){
            Seq filteredPartitionDirectories = fileIndex.listFiles((Seq)Nil$.MODULE$, dataFilters);
            int filteredFilesCount = ((SeqLike)filteredPartitionDirectories.flatMap((Function1 & Serializable & scala.Serializable)s -> s.files(), Seq$.MODULE$.canBuildFrom())).size();
            HoodieTableMetaClient x$8 = metaClient;
            boolean x$9 = this.getLatestDataFilesCount$default$1();
            long latestDataFilesCount = this.getLatestDataFilesCount(x$9, x$8);
            if (isDataSkippingExpected) {
                Assertions.assertTrue(((long)filteredFilesCount < latestDataFilesCount ? 1 : 0) != 0);
                if (isNoScanExpected) {
                    Assertions.assertTrue((filteredFilesCount == 0 ? 1 : 0) != 0);
                } else {
                    Assertions.assertTrue((filteredFilesCount > 0 ? 1 : 0) != 0);
                }
            } else {
                Assertions.assertTrue(((long)filteredFilesCount == latestDataFilesCount ? 1 : 0) != 0);
            }
            SparkSession x$10 = this.spark();
            HoodieTableMetaClient x$11 = metaClient;
            None$ x$12 = None$.MODULE$;
            Map x$13 = commonOpts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"false"));
            boolean x$14 = true;
            FileStatusCache x$15 = HoodieFileIndex$.MODULE$.apply$default$5();
            boolean x$16 = HoodieFileIndex$.MODULE$.apply$default$7();
            fileIndex = new HoodieFileIndex(x$10, x$11, (Option)x$12, x$13, x$15, x$14, x$16);
            int filesCountWithNoSkipping = ((SeqLike)fileIndex.listFiles((Seq)Nil$.MODULE$, dataFilters).flatMap((Function1 & Serializable & scala.Serializable)s -> s.files(), Seq$.MODULE$.canBuildFrom())).size();
            Assertions.assertTrue(((long)filesCountWithNoSkipping == latestDataFilesCount ? 1 : 0) != 0);
        }
    }

    private boolean verifyFilePruningExpressions$default$5() {
        return false;
    }

    private long getLatestDataFilesCount(boolean includeLogFiles, HoodieTableMetaClient metaClient) {
        LongRef totalLatestDataFiles = LongRef.create((long)0L);
        try (HoodieMetadataFileSystemView fsView = this.getTableFileSystemView(metaClient);){
            fsView.getAllLatestFileSlicesBeforeOrOn(((HoodieInstant)metaClient.getActiveTimeline().lastInstant().get()).requestedTime()).values().forEach(JFunction$.MODULE$.toJavaConsumer((Function1 & Serializable & scala.Serializable)slices -> {
                slices.forEach(JFunction$.MODULE$.toJavaConsumer((Function1 & Serializable & scala.Serializable)slice -> {
                    totalLatestDataFiles$1.elem = totalLatestDataFiles$1.elem + ((includeLogFiles$1 ? slice.getLogFiles().count() : 0L) + (long)(slice.getBaseFile().isPresent() ? 1 : 0));
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            }));
        }
        return totalLatestDataFiles.elem;
    }

    private boolean getLatestDataFilesCount$default$1() {
        return true;
    }

    private HoodieMetadataFileSystemView getTableFileSystemView(HoodieTableMetaClient metaClient) {
        return new HoodieMetadataFileSystemView((HoodieEngineContext)new HoodieSparkEngineContext(new JavaSparkContext(this.spark().sparkContext())), metaClient, (HoodieTimeline)metaClient.getActiveTimeline(), HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexPartitionStats(true).build());
    }

    public static final /* synthetic */ void $anonfun$new$3(TestPartitionStatsIndexWithSql $this, String tableType$1, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(611).append("\n             | create table ").append(tableName).append(" using hudi\n             | partitioned by (dt)\n             | tblproperties(\n             |    type = '").append(tableType$1).append("',\n             |    primaryKey = 'id',\n             |    preCombineField = 'ts',\n             |    'hoodie.metadata.index.partition.stats.enable' = 'true',\n             |    'hoodie.metadata.index.column.stats.enable' = 'true',\n             |    'hoodie.metadata.index.column.stats.column.list' = 'name'\n             | )\n             | location '").append(tablePath).append("'\n             | AS\n             | select 1 as id, 'a1' as name, 10 as price, 1000 as ts, cast('2021-05-06' as date) as dt\n         ").toString())).stripMargin());
        $this.assertResult(WriteOperationType.BULK_INSERT, HoodieSparkSqlTestBase$.MODULE$.getLastCommitMetadata($this.spark(), tablePath).getOperationType(), Prettifier$.MODULE$.default(), new Position("TestPartitionStatsIndexWithSql.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        $this.checkAnswer(new StringBuilder(52).append("select id, name, price, ts, cast(dt as string) from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), "2021-05-06"}))}));
        String partitionValue = "2021-05-06";
        $this.spark().sql(new StringBuilder(56).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000, cast('").append(partitionValue).append("' as date))").toString());
        $this.checkAnswer(new StringBuilder(108).append("select _hoodie_record_key, _hoodie_partition_path, id, name, price, ts, cast(dt as string) from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", new StringBuilder(3).append("dt=").append(partitionValue).toString(), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", new StringBuilder(3).append("dt=").append(partitionValue).toString(), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.PARTITION_STATS.getPartitionPath()));
        $this.spark().sql(new StringBuilder(30).append("drop index partition_stats on ").append(tableName).toString());
        metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        Assertions.assertFalse((boolean)metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.PARTITION_STATS.getPartitionPath()));
    }

    public static final /* synthetic */ void $anonfun$new$6(TestPartitionStatsIndexWithSql $this, String tableType$2, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(611).append("\n             | create table ").append(tableName).append(" using hudi\n             | partitioned by (dt)\n             | tblproperties(\n             |    type = '").append(tableType$2).append("',\n             |    primaryKey = 'id',\n             |    preCombineField = 'ts',\n             |    'hoodie.metadata.index.partition.stats.enable' = 'true',\n             |    'hoodie.metadata.index.column.stats.enable' = 'true',\n             |    'hoodie.metadata.index.column.stats.column.list' = 'name'\n             | )\n             | location '").append(tablePath).append("'\n             | AS\n             | select 1 as id, 'a1' as name, 10 as price, 1000 as ts, cast('2021-05-06' as date) as dt\n         ").toString())).stripMargin());
        $this.assertResult(WriteOperationType.BULK_INSERT, HoodieSparkSqlTestBase$.MODULE$.getLastCommitMetadata($this.spark(), tablePath).getOperationType(), Prettifier$.MODULE$.default(), new Position("TestPartitionStatsIndexWithSql.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        $this.checkAnswer(new StringBuilder(52).append("select id, name, price, ts, cast(dt as string) from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), "2021-05-06"}))}));
        String partitionValue = "2021-05-06";
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        Map properties = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)properties.contains((Object)HoodieTableConfig.CREATE_SCHEMA.key())), Prettifier$.MODULE$.default(), new Position("TestPartitionStatsIndexWithSql.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        $this.assertResult("dt", properties.apply((Object)HoodieTableConfig.PARTITION_FIELDS.key()), Prettifier$.MODULE$.default(), new Position("TestPartitionStatsIndexWithSql.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        $this.assertResult("ts", properties.apply((Object)HoodieTableConfig.PRECOMBINE_FIELD.key()), Prettifier$.MODULE$.default(), new Position("TestPartitionStatsIndexWithSql.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        $this.assertResult(tableName, metaClient.getTableConfig().getTableName(), Prettifier$.MODULE$.default(), new Position("TestPartitionStatsIndexWithSql.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.PARTITION_STATS.getPartitionPath()));
        $this.spark().sql(new StringBuilder(56).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000, cast('").append(partitionValue).append("' as date))").toString());
        $this.checkAnswer(new StringBuilder(108).append("select _hoodie_record_key, _hoodie_partition_path, id, name, price, ts, cast(dt as string) from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", new StringBuilder(3).append("dt=").append(partitionValue).toString(), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", new StringBuilder(3).append("dt=").append(partitionValue).toString(), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(209).append("\n             |merge into ").append(tableName).append(" h0\n             |using (select 1 as id, 'a1' as name, 11 as price, 1001 as ts, '").append(partitionValue).append("' as dt) s0\n             |on h0.id = s0.id\n             |when matched then update set *\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(108).append("select _hoodie_record_key, _hoodie_partition_path, id, name, price, ts, cast(dt as string) from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", new StringBuilder(3).append("dt=").append(partitionValue).toString(), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001), partitionValue})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", new StringBuilder(3).append("dt=").append(partitionValue).toString(), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
        $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set price = price + 1 where id = 2").toString());
        $this.checkAnswer(new StringBuilder(108).append("select _hoodie_record_key, _hoodie_partition_path, id, name, price, ts, cast(dt as string) from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", new StringBuilder(3).append("dt=").append(partitionValue).toString(), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001), partitionValue})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", new StringBuilder(3).append("dt=").append(partitionValue).toString(), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
        $this.spark().sql(new StringBuilder(25).append("delete from ").append(tableName).append(" where id = 1").toString());
        $this.checkAnswer(new StringBuilder(108).append("select _hoodie_record_key, _hoodie_partition_path, id, name, price, ts, cast(dt as string) from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", new StringBuilder(3).append("dt=").append(partitionValue).toString(), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
    }

    public static final /* synthetic */ boolean $anonfun$new$10(PartitionDirectory p) {
        return p.files().size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$new$11(PartitionDirectory p) {
        return p.files().size() > 1;
    }

    public static final /* synthetic */ void $anonfun$new$9(TestPartitionStatsIndexWithSql $this, String tableType$3, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(685).append("\n             | create table ").append(tableName).append(" (\n             |    ts BIGINT,\n             |    uuid STRING,\n             |    rider STRING,\n             |    driver STRING,\n             |    city STRING,\n             |    state STRING\n             |) using hudi\n             | options(\n             |    type = '").append(tableType$3).append("',\n             |    primaryKey ='uuid',\n             |    preCombineField = 'ts',\n             |    hoodie.metadata.index.partition.stats.enable = 'true',\n             |    hoodie.metadata.index.column.stats.enable = 'true',\n             |    hoodie.metadata.index.column.stats.column.list = 'rider'\n             |)\n             |PARTITIONED BY (state)\n             |location '").append(tablePath).append("'\n         ").toString())).stripMargin());
        $this.spark().sql("set hoodie.parquet.small.file.limit=0");
        $this.spark().sql("set hoodie.parquet.max.file.size=1");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(267).append("\n             | insert into ").append(tableName).append("\n             | values (1695159649,'334e26e9-8355-45cc-97c6-c31daf0df330','rider-A','driver-K','san_francisco','california'), (1695091554,'e96c4396-3fad-413a-a942-4cb36106d721','rider-F','driver-M','sunnyvale','california')\n             | ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(119).append("INSERT INTO ").append(tableName).append(" VALUES (1695332066,'7a84095f-737f-40bc-b62f-6b69664712d2','rider-B','driver-L','new york city','new york')").toString());
        $this.spark().sql(new StringBuilder(117).append("INSERT INTO ").append(tableName).append(" VALUES (1695516137,'3eeb61f7-c2b0-4636-99bd-5d7a5a1d2c04','rider-D','driver-M','princeton','new jersey')").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(385).append("\n             | insert into ").append(tableName).append("\n             | values\n             | (1695516137,'e3cf430c-889d-4015-bc98-59bdce1e530c','rider-C','driver-P','houston','texas'),\n             | (1695332066,'1dced545-862b-4ceb-8b43-d2a568f6616b','rider-E','driver-O','austin','texas'),\n             | (1695516138,'e3cf430c-889d-4015-bc98-59bdce1e530d','rider-C','driver-P','houston','texas')\n             | ").toString())).stripMargin());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        $this.assertResult(tableName, metaClient.getTableConfig().getTableName(), Prettifier$.MODULE$.default(), new Position("TestPartitionStatsIndexWithSql.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.PARTITION_STATS.getPartitionPath()));
        HoodieFileIndex fileIndex = new HoodieFileIndex($this.spark(), metaClient, (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)metaClient.getBasePath().toString())})), HoodieFileIndex$.MODULE$.apply$default$5(), HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        Seq partitionFiles = fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        Assertions.assertTrue((partitionFiles.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestPartitionStatsIndexWithSql.$anonfun$new$10(p))) && partitionFiles.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestPartitionStatsIndexWithSql.$anonfun$new$11(p))) ? 1 : 0) != 0);
        $this.spark().sql("set hoodie.metadata.enable=true");
        $this.spark().sql("set hoodie.enable.data.skipping=true");
        $this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        $this.checkAnswer(new StringBuilder(61).append("select uuid, rider, city, state from ").append(tableName).append(" where rider > 'rider-D'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"1dced545-862b-4ceb-8b43-d2a568f6616b", (List)new .colon.colon((Object)"rider-E", (List)new .colon.colon((Object)"austin", (List)new .colon.colon((Object)"texas", (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"e96c4396-3fad-413a-a942-4cb36106d721", (List)new .colon.colon((Object)"rider-F", (List)new .colon.colon((Object)"sunnyvale", (List)new .colon.colon((Object)"california", (List)Nil$.MODULE$))))}));
        String x$1 = "rider";
        StringType$ x$2 = StringType$.MODULE$;
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
        $this.verifyFilePruning((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}))), (Expression)new GreaterThan((Expression)new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6), (Expression)Literal$.MODULE$.apply((Object)"rider-D")), HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient), true, $this.verifyFilePruning$default$5());
        String x$7 = "rider";
        StringType$ x$8 = StringType$.MODULE$;
        boolean x$9 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, (DataType)x$8, x$9, x$10);
        Seq x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, (DataType)x$8, x$9, x$10);
        String x$13 = "rider";
        StringType$ x$14 = StringType$.MODULE$;
        boolean x$15 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$17 = AttributeReference$.MODULE$.apply$default$5(x$13, (DataType)x$14, x$15, x$16);
        Seq x$18 = AttributeReference$.MODULE$.apply$default$6(x$13, (DataType)x$14, x$15, x$16);
        $this.verifyFilePruningExpressions((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}))), (Seq<Expression>)((Seq)new .colon.colon((Object)new IsNotNull((Expression)new AttributeReference(x$7, (DataType)x$8, x$9, x$10, x$11, x$12)), (List)new .colon.colon((Object)new GreaterThan((Expression)new AttributeReference(x$13, (DataType)x$14, x$15, x$16, x$17, x$18), (Expression)Literal$.MODULE$.apply((Object)"rider-D")), (List)Nil$.MODULE$))), HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient), true, $this.verifyFilePruningExpressions$default$5());
        String x$19 = "driver";
        StringType$ x$20 = StringType$.MODULE$;
        boolean x$21 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$23 = AttributeReference$.MODULE$.apply$default$5(x$19, (DataType)x$20, x$21, x$22);
        Seq x$24 = AttributeReference$.MODULE$.apply$default$6(x$19, (DataType)x$20, x$21, x$22);
        $this.verifyFilePruning((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}))), (Expression)new GreaterThan((Expression)new AttributeReference(x$19, (DataType)x$20, x$21, x$22, x$23, x$24), (Expression)Literal$.MODULE$.apply((Object)"driver-O")), HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient), false, $this.verifyFilePruning$default$5());
        String x$25 = "rider";
        StringType$ x$26 = StringType$.MODULE$;
        boolean x$27 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$28 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$29 = AttributeReference$.MODULE$.apply$default$5(x$25, (DataType)x$26, x$27, x$28);
        Seq x$30 = AttributeReference$.MODULE$.apply$default$6(x$25, (DataType)x$26, x$27, x$28);
        String x$31 = "driver";
        StringType$ x$32 = StringType$.MODULE$;
        boolean x$33 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$34 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$35 = AttributeReference$.MODULE$.apply$default$5(x$31, (DataType)x$32, x$33, x$34);
        Seq x$36 = AttributeReference$.MODULE$.apply$default$6(x$31, (DataType)x$32, x$33, x$34);
        $this.verifyFilePruning((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}))), (Expression)new And((Expression)new GreaterThan((Expression)new AttributeReference(x$25, (DataType)x$26, x$27, x$28, x$29, x$30), (Expression)Literal$.MODULE$.apply((Object)"rider-D")), (Expression)new GreaterThan((Expression)new AttributeReference(x$31, (DataType)x$32, x$33, x$34, x$35, x$36), (Expression)Literal$.MODULE$.apply((Object)"driver-O"))), HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient), true, $this.verifyFilePruning$default$5());
        String x$37 = "rider";
        StringType$ x$38 = StringType$.MODULE$;
        boolean x$39 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$40 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$41 = AttributeReference$.MODULE$.apply$default$5(x$37, (DataType)x$38, x$39, x$40);
        Seq x$42 = AttributeReference$.MODULE$.apply$default$6(x$37, (DataType)x$38, x$39, x$40);
        String x$43 = "driver";
        StringType$ x$44 = StringType$.MODULE$;
        boolean x$45 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$46 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$47 = AttributeReference$.MODULE$.apply$default$5(x$43, (DataType)x$44, x$45, x$46);
        Seq x$48 = AttributeReference$.MODULE$.apply$default$6(x$43, (DataType)x$44, x$45, x$46);
        $this.verifyFilePruning((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}))), (Expression)new Or((Expression)new GreaterThan((Expression)new AttributeReference(x$37, (DataType)x$38, x$39, x$40, x$41, x$42), (Expression)Literal$.MODULE$.apply((Object)"rider-D")), (Expression)new GreaterThan((Expression)new AttributeReference(x$43, (DataType)x$44, x$45, x$46, x$47, x$48), (Expression)Literal$.MODULE$.apply((Object)"driver-O"))), HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient), false, $this.verifyFilePruning$default$5());
        $this.checkAnswer(new StringBuilder(61).append("select uuid, rider, city, state from ").append(tableName).append(" where rider > 'rider-Z'").toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
        String x$49 = "rider";
        StringType$ x$50 = StringType$.MODULE$;
        boolean x$51 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$52 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$53 = AttributeReference$.MODULE$.apply$default$5(x$49, (DataType)x$50, x$51, x$52);
        Seq x$54 = AttributeReference$.MODULE$.apply$default$6(x$49, (DataType)x$50, x$51, x$52);
        $this.verifyFilePruning((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}))), (Expression)new GreaterThan((Expression)new AttributeReference(x$49, (DataType)x$50, x$51, x$52, x$53, x$54), (Expression)Literal$.MODULE$.apply((Object)"rider-Z")), HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient), true, true);
        $this.checkAnswer(new StringBuilder(61).append("select uuid, rider, city, state from ").append(tableName).append(" where rider < 'rider-Z'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"334e26e9-8355-45cc-97c6-c31daf0df330", (List)new .colon.colon((Object)"rider-A", (List)new .colon.colon((Object)"san_francisco", (List)new .colon.colon((Object)"california", (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"7a84095f-737f-40bc-b62f-6b69664712d2", (List)new .colon.colon((Object)"rider-B", (List)new .colon.colon((Object)"new york city", (List)new .colon.colon((Object)"new york", (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"e3cf430c-889d-4015-bc98-59bdce1e530c", (List)new .colon.colon((Object)"rider-C", (List)new .colon.colon((Object)"houston", (List)new .colon.colon((Object)"texas", (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"e3cf430c-889d-4015-bc98-59bdce1e530d", (List)new .colon.colon((Object)"rider-C", (List)new .colon.colon((Object)"houston", (List)new .colon.colon((Object)"texas", (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"3eeb61f7-c2b0-4636-99bd-5d7a5a1d2c04", (List)new .colon.colon((Object)"rider-D", (List)new .colon.colon((Object)"princeton", (List)new .colon.colon((Object)"new jersey", (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"1dced545-862b-4ceb-8b43-d2a568f6616b", (List)new .colon.colon((Object)"rider-E", (List)new .colon.colon((Object)"austin", (List)new .colon.colon((Object)"texas", (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"e96c4396-3fad-413a-a942-4cb36106d721", (List)new .colon.colon((Object)"rider-F", (List)new .colon.colon((Object)"sunnyvale", (List)new .colon.colon((Object)"california", (List)Nil$.MODULE$))))}));
        String x$55 = "rider";
        StringType$ x$56 = StringType$.MODULE$;
        boolean x$57 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$58 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$59 = AttributeReference$.MODULE$.apply$default$5(x$55, (DataType)x$56, x$57, x$58);
        Seq x$60 = AttributeReference$.MODULE$.apply$default$6(x$55, (DataType)x$56, x$57, x$58);
        $this.verifyFilePruning((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}))), (Expression)new LessThan((Expression)new AttributeReference(x$55, (DataType)x$56, x$57, x$58, x$59, x$60), (Expression)Literal$.MODULE$.apply((Object)"rider-Z")), HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient), false, $this.verifyFilePruning$default$5());
    }

    public static final /* synthetic */ void $anonfun$new$14(TestPartitionStatsIndexWithSql $this, String tableType$4, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(525).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price int,\n             |  ts long\n             |) using hudi\n             |partitioned by (ts)\n             |tblproperties (\n             |  type = '").append(tableType$4).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'price',\n             |  hoodie.metadata.index.partition.stats.enable = 'true',\n             |  hoodie.metadata.index.column.stats.enable = 'true'\n             |)\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.writeAndValidatePartitionStats(tableName, tablePath);
        $this.checkAnswer(new StringBuilder(173).append("select key, ColumnStatsMetadata.minValue.member1.value, ColumnStatsMetadata.maxValue.member1.value from hudi_metadata('").append(tableName).append("') where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).append(" and ColumnStatsMetadata.columnName='id'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=10", (String)"id"), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)4)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=20", (String)"id"), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)5)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=30", (String)"id"), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)6)}))}));
        $this.checkAnswer(new StringBuilder(175).append("select key, ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value from hudi_metadata('").append(tableName).append("') where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).append(" and ColumnStatsMetadata.columnName='name'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=10", (String)"name"), (List)new .colon.colon((Object)"a1", (List)new .colon.colon((Object)"a4", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=20", (String)"name"), (List)new .colon.colon((Object)"a2", (List)new .colon.colon((Object)"a5", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=30", (String)"name"), (List)new .colon.colon((Object)"a3", (List)new .colon.colon((Object)"a6", (List)Nil$.MODULE$)))}));
    }

    public static final /* synthetic */ void $anonfun$new$17(TestPartitionStatsIndexWithSql $this, String tableType$5, File tmp) {
        String tableName = new StringBuilder(13).append($this.generateTableName()).append("_tight_bound_").append(tableType$5).toString();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(599).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price int,\n             |  ts long\n             |) using hudi\n             |partitioned by (ts)\n             |tblproperties (\n             |  type = '").append(tableType$5).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'price',\n             |  hoodie.metadata.index.partition.stats.enable = 'true',\n             |  hoodie.metadata.index.column.stats.enable = 'true',\n             |  hoodie.metadata.index.column.stats.column.list = 'price'\n             |)\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(60).append("insert into ").append(tableName).append(" values (1, 'a1', 1000, 10), (2, 'a2', 1500, 10)").toString());
        $this.spark().sql(new StringBuilder(60).append("insert into ").append(tableName).append(" values (3, 'a3', 2000, 20), (4, 'a4', 2500, 20)").toString());
        $this.spark().sql(new StringBuilder(60).append("insert into ").append(tableName).append(" values (5, 'a5', 3000, 30), (6, 'a6', 3500, 30)").toString());
        $this.checkAnswer(new StringBuilder(176).append("select key, ColumnStatsMetadata.minValue.member1.value, ColumnStatsMetadata.maxValue.member1.value from hudi_metadata('").append(tableName).append("') where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).append(" and ColumnStatsMetadata.columnName='price'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=10", (String)"price"), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)1500)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=20", (String)"price"), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToInteger((int)2500)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=30", (String)"price"), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToInteger((int)3500)}))}));
        $this.spark().sql(new StringBuilder(37).append("update ").append(tableName).append(" set price = 4000 where id = 6").toString());
        $this.checkAnswer(new StringBuilder(210).append("select key, ColumnStatsMetadata.minValue.member1.value, ColumnStatsMetadata.maxValue.member1.value, ColumnStatsMetadata.isTightBound from hudi_metadata('").append(tableName).append("') where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).append(" and ColumnStatsMetadata.columnName='price'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=10", (String)"price"), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)1500), BoxesRunTime.boxToBoolean((boolean)true)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=20", (String)"price"), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToInteger((int)2500), BoxesRunTime.boxToBoolean((boolean)true)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=30", (String)"price"), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToInteger((int)4000), BoxesRunTime.boxToBoolean((boolean)true)}))}));
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        String x$61 = "price";
        IntegerType$ x$62 = IntegerType$.MODULE$;
        boolean x$63 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$64 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$65 = AttributeReference$.MODULE$.apply$default$5(x$61, (DataType)x$62, x$63, x$64);
        Seq x$66 = AttributeReference$.MODULE$.apply$default$6(x$61, (DataType)x$62, x$63, x$64);
        $this.verifyFilePruning((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}))), (Expression)new GreaterThan((Expression)new AttributeReference(x$61, (DataType)x$62, x$63, x$64, x$65, x$66), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3000))), metaClient, true, $this.verifyFilePruning$default$5());
        $this.spark().sql(new StringBuilder(25).append("delete from ").append(tableName).append(" where id = 6").toString());
        $this.checkAnswer(new StringBuilder(210).append("select key, ColumnStatsMetadata.minValue.member1.value, ColumnStatsMetadata.maxValue.member1.value, ColumnStatsMetadata.isTightBound from hudi_metadata('").append(tableName).append("') where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).append(" and ColumnStatsMetadata.columnName='price'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=10", (String)"price"), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)1500), BoxesRunTime.boxToBoolean((boolean)true)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=20", (String)"price"), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToInteger((int)2500), BoxesRunTime.boxToBoolean((boolean)true)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=30", (String)"price"), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToBoolean((boolean)true)}))}));
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        String x$67 = "price";
        IntegerType$ x$68 = IntegerType$.MODULE$;
        boolean x$69 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$70 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$71 = AttributeReference$.MODULE$.apply$default$5(x$67, (DataType)x$68, x$69, x$70);
        Seq x$72 = AttributeReference$.MODULE$.apply$default$6(x$67, (DataType)x$68, x$69, x$70);
        $this.verifyFilePruning((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}))), (Expression)new GreaterThan((Expression)new AttributeReference(x$67, (DataType)x$68, x$69, x$70, x$71, x$72), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3000))), metaClient, true, true);
    }

    public static final /* synthetic */ void $anonfun$new$19(TestPartitionStatsIndexWithSql $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(568).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price int,\n           |  ts long\n           |) using hudi\n           |partitioned by (ts)\n           |tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'price',\n           |  hoodie.metadata.index.partition.stats.enable = 'true',\n           |  hoodie.metadata.index.column.stats.enable = 'true',\n           |  hoodie.metadata.index.column.stats.column.list = 'price'\n           |)\n           |location '").append(tablePath).append("'\n           |").toString())).stripMargin());
        $this.writeAndValidatePartitionStats(tableName, tablePath);
        $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set price = price + 1 where id = 6").toString());
        $this.checkAnswer(new StringBuilder(49).append("select id, name, price, ts from ").append(tableName).append(" where price>3000").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", BoxesRunTime.boxToInteger((int)4002), BoxesRunTime.boxToInteger((int)30)}))}));
        $this.checkAnswer(new StringBuilder(176).append("select key, ColumnStatsMetadata.minValue.member1.value, ColumnStatsMetadata.maxValue.member1.value from hudi_metadata('").append(tableName).append("') where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).append(" and ColumnStatsMetadata.columnName='price'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=10", (String)"price"), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)2000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=20", (String)"price"), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToInteger((int)3000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=30", (String)"price"), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToInteger((int)4002)}))}));
        $this.spark().sql(new StringBuilder(14).append("refresh table ").append(tableName).toString());
        $this.spark().sql("set hoodie.compact.inline=false");
        $this.spark().sql("set hoodie.compact.inline.max.delta.commits=2");
        $this.spark().sql(new StringBuilder(23).append("schedule compaction on ").append(tableName).toString());
        Row[] compactionRows = (Row[])$this.spark().sql(new StringBuilder(19).append("show compaction on ").append(tableName).toString()).collect();
        String[] timestamps = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compactionRows)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertTrue((timestamps.length == 1 ? 1 : 0) != 0);
        $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set price = price + 1 where id = 6").toString());
        $this.checkAnswer(new StringBuilder(49).append("select id, name, price, ts from ").append(tableName).append(" where price>3000").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", BoxesRunTime.boxToInteger((int)4003), BoxesRunTime.boxToInteger((int)30)}))}));
        $this.spark().sql(new StringBuilder(14).append("refresh table ").append(tableName).toString());
        $this.spark().sql("set hoodie.metadata.index.partition.stats.enable=true");
        $this.spark().sql("set hoodie.metadata.index.column.stats.enable=true");
        $this.spark().sql("set hoodie.metadata.index.column.stats.column.list=price");
        $this.spark().sql(new StringBuilder(22).append("run compaction on ").append(tableName).append(" at ").append(timestamps[0]).toString());
        $this.checkAnswer(new StringBuilder(210).append("select key, ColumnStatsMetadata.minValue.member1.value, ColumnStatsMetadata.maxValue.member1.value, ColumnStatsMetadata.isTightBound from hudi_metadata('").append(tableName).append("') where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).append(" and ColumnStatsMetadata.columnName='price'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=10", (String)"price"), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToBoolean((boolean)true)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=20", (String)"price"), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToBoolean((boolean)true)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=30", (String)"price"), BoxesRunTime.boxToInteger((int)4003), BoxesRunTime.boxToInteger((int)4003), BoxesRunTime.boxToBoolean((boolean)true)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$24(TestPartitionStatsIndexWithSql $this, String tableType$6, boolean shouldCompact$1, File tmp) {
        BoxedUnit boxedUnit;
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(633).append("\n               |create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  price int,\n               |  ts long\n               |) using hudi\n               |partitioned by (ts)\n               |tblproperties (\n               |  type = '").append(tableType$6).append("',\n               |  primaryKey = 'id',\n               |  preCombineField = 'price',\n               |  hoodie.metadata.index.partition.stats.enable = 'true',\n               |  hoodie.metadata.index.column.stats.enable = 'true',\n               |  hoodie.metadata.index.column.stats.column.list = 'price'\n               |)\n               |location '").append(tablePath).append("'\n               |").toString())).stripMargin());
        String string = tableType$6;
        String string2 = "mor";
        if (!(string != null ? !string.equals(string2) : string2 != null) && shouldCompact$1) {
            $this.spark().sql("set hoodie.compact.inline=true");
            boxedUnit = $this.spark().sql("set hoodie.compact.inline.max.delta.commits=2");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        $this.spark().sql("set hoodie.metadata.enable=true");
        $this.spark().sql("set hoodie.enable.data.skipping=true");
        $this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        $this.writeAndValidatePartitionStats(tableName, tablePath);
        String string3 = tableType$6;
        String string4 = "mor";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null) && shouldCompact$1) {
            $this.checkAnswer(new StringBuilder(210).append("select key, ColumnStatsMetadata.minValue.member1.value, ColumnStatsMetadata.maxValue.member1.value, ColumnStatsMetadata.isTightBound from hudi_metadata('").append(tableName).append("') where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).append(" and ColumnStatsMetadata.columnName='price'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=10", (String)"price"), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToBoolean((boolean)true)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=20", (String)"price"), BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToBoolean((boolean)true)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=30", (String)"price"), BoxesRunTime.boxToInteger((int)3000), BoxesRunTime.boxToInteger((int)4001), BoxesRunTime.boxToBoolean((boolean)true)}))}));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$new$22(TestPartitionStatsIndexWithSql $this, String tableType) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)shouldCompact -> {
            $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestPartitionStatsIndexWithSql.$anonfun$new$24($this, tableType$6, shouldCompact, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public TestPartitionStatsIndexWithSql() {
        this.sqlTempTable = "hudi_tbl";
        this.test("Test drop partition stats index", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestPartitionStatsIndexWithSql.$anonfun$new$3($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestPartitionStatsIndexWithSql.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("Test partition stats index following insert, merge into, update and delete", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestPartitionStatsIndexWithSql.$anonfun$new$6($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestPartitionStatsIndexWithSql.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("Test partition stats index on string type field with insert and file pruning", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestPartitionStatsIndexWithSql.$anonfun$new$9($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestPartitionStatsIndexWithSql.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("Test partition stats index without configuring columns to index", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestPartitionStatsIndexWithSql.$anonfun$new$14($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestPartitionStatsIndexWithSql.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        this.test("Test partition stats index with tight bound", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestPartitionStatsIndexWithSql.$anonfun$new$17($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestPartitionStatsIndexWithSql.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
        this.test("Test partition stats index with inflight compaction", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestPartitionStatsIndexWithSql.$anonfun$new$19(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestPartitionStatsIndexWithSql.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
        this.test("Test partition stats index on int type field with update and file pruning", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestPartitionStatsIndexWithSql.$anonfun$new$22(this, tableType);
            return BoxedUnit.UNIT;
        }), new Position("TestPartitionStatsIndexWithSql.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
    }
}

