/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.transaction.PreferWriterConflictResolutionStrategy;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.apache.hudi.functional.RecordLevelIndexTestBase;
import org.apache.hudi.functional.TestRecordLevelIndex$;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.util.JavaConversions$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.functions$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Try;
import scala.util.Using;
import scala.util.Using$;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\tUb\u0001\u0002\u0010 \u0001!BQ!\f\u0001\u0005\u00029BQ\u0001\r\u0001\u0005\u0002EBQA\u0016\u0001\u0005\u0002]CQa\u0018\u0001\u0005\n\u0001DQ\u0001\u001c\u0001\u0005\u00025DQ!\u001d\u0001\u0005\u0002IDQA\u001e\u0001\u0005\u0002]Dq!!\u0007\u0001\t\u0003\tY\u0002C\u0004\u0002$\u0001!\t!!\n\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002BBA!\u0001\u0011\u0005q\u000bC\u0004\u0002F\u0001!\t!a\u0012\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\u0007\u0003[\u0002A\u0011A,\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0004bBAR\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003{\u0003A\u0011AA`\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Dq!!5\u0001\t\u0003\t\u0019\u000e\u0003\u0007\u0002\\\u0002\u0001\n\u0011!A\u0001\n\u0003\ti\u000e\u0003\u0007\u0002p\u0002\u0001\n\u0011!A\u0001\n\u0003\t\tpB\u0004\u0003\f}A\tA!\u0004\u0007\ryy\u0002\u0012\u0001B\b\u0011\u0019i3\u0004\"\u0001\u0003\u0018!9\u0011\u0011X\u000e\u0005\u0002\te!\u0001\u0006+fgR\u0014VmY8sI2+g/\u001a7J]\u0012,\u0007P\u0003\u0002!C\u0005Qa-\u001e8di&|g.\u00197\u000b\u0005\t\u001a\u0013\u0001\u00025vI&T!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO\u000e\u00011C\u0001\u0001*!\tQ3&D\u0001 \u0013\tasD\u0001\rSK\u000e|'\u000f\u001a'fm\u0016d\u0017J\u001c3fqR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A\u0018\u0011\u0005)\u0002\u0011!\u0006;fgR\u0014F*S%oSRL\u0017\r\\5{CRLwN\u001c\u000b\u0003ea\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012A!\u00168ji\")\u0011H\u0001a\u0001u\u0005IA/\u00192mKRK\b/\u001a\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nQ!\\8eK2T!aP\u0011\u0002\r\r|W.\\8o\u0013\t\tEHA\bI_>$\u0017.\u001a+bE2,G+\u001f9fQ\u0011\u00111i\u0014)\u0011\u0005\u0011kU\"A#\u000b\u0005\u0019;\u0015\u0001\u00039s_ZLG-\u001a:\u000b\u0005!K\u0015A\u00029be\u0006l7O\u0003\u0002K\u0017\u00069!.\u001e9ji\u0016\u0014(B\u0001'&\u0003\u0015QWO\\5u\u0013\tqUI\u0001\u0006F]Vl7k\\;sG\u0016\fQA^1mk\u0016\u001c\u0013A\u000f\u0015\u0003\u0005I\u0003\"a\u0015+\u000e\u0003\u001dK!!V$\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0014uKN$(\u000bT%J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8G_JluN]$m_\n\fG.\u00138eKb$\u0012A\r\u0015\u0003\u0007e\u0003\"AW/\u000e\u0003mS!\u0001X%\u0002\u0007\u0005\u0004\u0018.\u0003\u0002_7\n!A+Z:u\u0003E9W\r\u001e(fo&s7\u000f^1oiRKW.\u001a\u000b\u0002CB\u0011!-\u001b\b\u0003G\u001e\u0004\"\u0001\u001a\u001b\u000e\u0003\u0015T!AZ\u0014\u0002\rq\u0012xn\u001c;?\u0013\tAG'\u0001\u0004Qe\u0016$WMZ\u0005\u0003U.\u0014aa\u0015;sS:<'B\u000155\u00035!Xm\u001d;S\u0019&+\u0006o]3siR\u0011!G\u001c\u0005\u0006s\u0015\u0001\rA\u000f\u0015\u0005\u000b\r{\u0005\u000b\u000b\u0002\u0006%\u0006YB/Z:u%2KU\u000b]:feRtuN\u001c)beRLG/[8oK\u0012$\"AM:\t\u000be2\u0001\u0019\u0001\u001e)\t\u0019\u0019u\n\u0015\u0015\u0003\rI\u000bA\u0005^3tiJc\u0015JQ;mW&s7/\u001a:u)\",g.\u00138tKJ$xJ^3soJLG/\u001a\u000b\u0004eaL\b\"B\u001d\b\u0001\u0004Q\u0004\"\u0002>\b\u0001\u0004Y\u0018aD3oC\ndWMU8x/JLG/\u001a:\u0011\u0005Mb\u0018BA?5\u0005\u001d\u0011un\u001c7fC:DSaB@P\u0003\u000b\u00012\u0001RA\u0001\u0013\r\t\u0019!\u0012\u0002\n\u0007N48k\\;sG\u0016d\u0003\"a\u0002\u0002\f\u0005=\u00111C\u0011\u0003\u0003\u0013\t!cQ(Q3~{ejX,S\u0013R+E\u0006\u001e:vK\u0006\u0012\u0011QB\u0001\u0014\u0007>\u0003\u0016lX(O?^\u0013\u0016\nV#-M\u0006d7/Z\u0011\u0003\u0003#\t!#T#S\u000f\u0016{vJT0S\u000b\u0006#E\u0006\u001e:vK\u0006\u0012\u0011QC\u0001\u0014\u001b\u0016\u0013v)R0P\u001d~\u0013V)\u0011#-M\u0006d7/\u001a\u0015\u0003\u000fI\u000b\u0001\u0004^3tiJc\u0015*\u00169tKJ$\u0018I\u001c3S_2d'-Y2l)\r\u0011\u0014Q\u0004\u0005\u0006s!\u0001\rA\u000f\u0015\u0005\u0011\r{\u0005\u000b\u000b\u0002\t%\u00069C/Z:u%2K\u0005+\u0019:uS\u0006dG.\u001f$bS2,G-\u00169tKJ$\u0018I\u001c3S_2d'-Y2l)\r\u0011\u0014q\u0005\u0005\u0006s%\u0001\rA\u000f\u0015\u0005\u0013\r{\u0005\u000b\u000b\u0002\n%\u0006!D/Z:u%2K\u0005+\u0019:uS\u0006dG.\u001f$bS2,G-T3uC\u0012\fG/\u0019+bE2,7i\\7nSR\fe\u000e\u001a*pY2\u0014\u0017mY6\u0015\u0007I\n\t\u0004C\u0003:\u0015\u0001\u0007!\b\u000b\u0003\u000b\u0007>\u0003\u0006F\u0001\u0006S\u0003E!Xm\u001d;S\u0019&;\u0016\u000e\u001e5EK2,G/\u001a\u000b\u0004e\u0005m\u0002\"B\u001d\f\u0001\u0004Q\u0004\u0006B\u0006D\u001fBC#a\u0003*\u0002/Q,7\u000f\u001e*M\u0013^KG\u000f[#naRL\b+Y=m_\u0006$\u0007F\u0001\u0007Z\u0003)\"Xm\u001d;S\u0019&3uN\u001d#fY\u0016$Xm],ji\"Dun\u001c3jK&\u001bH)\u001a7fi\u0016$7i\u001c7v[:$2AMA%\u0011\u0015IT\u00021\u0001;Q\u0011i1i\u0014))\u00055\u0011\u0016A\u0007;fgR\u0014F*S,ji\"$U\r\\3uKB\u000b'\u000f^5uS>tGc\u0001\u001a\u0002T!)\u0011H\u0004a\u0001u!\"abQ(QQ\tq!+A\ruKN$(\u000bT%VaN,'\u000f^!oI\u0012\u0013x\u000e]%oI\u0016DHc\u0001\u001a\u0002^!)\u0011h\u0004a\u0001u!\"qbQ(QQ\ty!+A\u000buKN$(\u000bT%XSRDG\tV\"mK\u0006t\u0017N\\4\u0015\u0007I\n9\u0007C\u0003:!\u0001\u0007!\b\u000b\u0003\u0011\u0007>\u0003\u0006F\u0001\tS\u0003]!Xm\u001d;S\u0019&;\u0016\u000e\u001e5E)\u000e{W\u000e]1di&|g\u000e\u000b\u0002\u00123\u00069B/Z:u%2Ku+\u001b;i\tR\u001bE.^:uKJLgn\u001a\u000b\u0004e\u0005U\u0004\"B\u001d\u0013\u0001\u0004Q\u0004\u0006\u0002\nD\u001fBC#A\u0005*\u0002EQ,7\u000f\u001e*M\u0013^KG\u000f[(uQ\u0016\u0014X*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8t)\u0015\u0011\u0014qPAA\u0011\u0015I4\u00031\u0001b\u0011\u0019\t\u0019i\u0005a\u0001C\u00061R.\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8UsB,7\u000fK\u0003\u0014\u007f>\u000b9\t\f\u0007\u0002\n\u00065\u0015\u0011SAK\u00033\u000bi*\t\u0002\u0002\f\u0006Q2i\u0014)Z?>sul\u0016*J)\u0016c3i\u0014'V\u001b:{6\u000bV!U'\u0006\u0012\u0011qR\u0001\u001c\u0007>\u0003\u0016lX(O?^\u0013\u0016\nV#-\u00052{u*T0G\u00132#VIU*\"\u0005\u0005M\u0015\u0001K\"P!f{vJT0X%&#V\tL\"P\u0019VkejX*U\u0003R\u001b&H\u0011'P\u001f6{f)\u0013'U\u000bJ\u001b\u0016EAAL\u0003iiUIU$F?>suLU#B\t2\u001au\nT+N\u001d~\u001bF+\u0011+TC\t\tY*A\u000eN\u000bJ;UiX(O?J+\u0015\t\u0012\u0017C\u0019>{Uj\u0018$J\u0019R+%kU\u0011\u0003\u0003?\u000b\u0001&T#S\u000f\u0016{vJT0S\u000b\u0006#EfQ(M+6sul\u0015+B)NS$\tT(P\u001b~3\u0015\n\u0014+F%NC#a\u0005*\u0002)Q,7\u000f^#oC\ndW\rR5tC\ndWM\u0015'J)\u0015\u0011\u0014qUAU\u0011\u0015ID\u00031\u0001;\u0011\u0019\tY\u000b\u0006a\u0001w\u0006i\u0011n\u001d)beRLG/[8oK\u0012Dc\u0001FAX\u001f\u0006U\u0006c\u0001#\u00022&\u0019\u00111W#\u0003\u00195+G\u000f[8e'>,(oY3-\u0005\u0005]\u0016EAA]\u0003i!Xm\u001d;F]\u0006\u0014G.\u001a#jg\u0006\u0014G.\u001a*M\u0013B\u000b'/Y7tQ\t!\"+\u0001\ruKN$(\u000bT%XSRDW\n\u0012+D_6\u0004\u0018m\u0019;j_:$2AMAa\u0011\u0015IT\u00031\u0001;Q\u0011)2i\u0014))\u0005U\u0011\u0016A\u0006;fgR\u0014F*S,ji\"lE\tV\"mK\u0006t\u0017N\\4\u0015\u0007I\nY\rC\u0003:-\u0001\u0007!\b\u000b\u0003\u0017\u0007>\u0003\u0006F\u0001\fS\u0003Y!Xm\u001d;S\u0019&;\u0016\u000e\u001e5Nk2$\u0018n\u0016:ji\u0016\u0014Hc\u0001\u001a\u0002V\")\u0011h\u0006a\u0001u!\"qcQ(QQ\t9\"+A\tqe>$Xm\u0019;fI\u0012\"\u0017\r^1HK:$B!a8\u0002lB!\u0011\u0011]At\u001b\t\t\u0019OC\u0002\u0002fz\n\u0011\u0002^3tiV$\u0018\u000e\\:\n\t\u0005%\u00181\u001d\u0002\u0018\u0011>|G-[3UKN$H)\u0019;b\u000f\u0016tWM]1u_JD\u0001\"!<\u0019\u0003\u0003\u0005\raL\u0001\u0004q\u0012\n\u0014\u0001\u00069s_R,7\r^3eI5,G/Y\"mS\u0016tG\u000f\u0006\u0003\u0002t\u0006}\b\u0003BA{\u0003wl!!a>\u000b\u0007\u0005eh(A\u0003uC\ndW-\u0003\u0003\u0002~\u0006](!\u0006%p_\u0012LW\rV1cY\u0016lU\r^1DY&,g\u000e\u001e\u0005\t\u0003[L\u0012\u0011!a\u0001_!2\u0001Aa\u0001P\u0005\u0013\u00012A\u0017B\u0003\u0013\r\u00119a\u0017\u0002\u0004)\u0006<\u0017%\u0001\u0011\u0002)Q+7\u000f\u001e*fG>\u0014H\rT3wK2Le\u000eZ3y!\tQ3dE\u0002\u001c\u0005#\u00012a\rB\n\u0013\r\u0011)\u0002\u000e\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t5AC\u0001B\u000e!\u0019\u0011iBa\u000b\u000305\u0011!q\u0004\u0006\u0005\u0005C\u0011\u0019#\u0001\u0004tiJ,\u0017-\u001c\u0006\u0005\u0005K\u00119#\u0001\u0003vi&d'B\u0001B\u0015\u0003\u0011Q\u0017M^1\n\t\t5\"q\u0004\u0002\u0007'R\u0014X-Y7\u0011\u0007\u0011\u0013\t$C\u0002\u00034\u0015\u0013\u0011\"\u0011:hk6,g\u000e^:")
public class TestRecordLevelIndex
extends RecordLevelIndexTestBase {
    public static Stream<Arguments> testEnableDisableRLIParams() {
        return TestRecordLevelIndex$.MODULE$.testEnableDisableRLIParams();
    }

    public /* synthetic */ HoodieTestDataGenerator protected$dataGen(TestRecordLevelIndex x$1) {
        return x$1.dataGen;
    }

    public /* synthetic */ HoodieTableMetaClient protected$metaClient(TestRecordLevelIndex x$1) {
        return x$1.metaClient;
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIInitialization(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
    }

    @Test
    public void testRLIInitializationForMorGlobalIndex() {
        HoodieTableType tableType = HoodieTableType.MERGE_ON_READ;
        scala.collection.immutable.Map hudiOpts = (scala.collection.immutable.Map)this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key()), (Object)"1")).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key()), (Object)"1")).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.INDEX_TYPE.key()), (Object)"RECORD_INDEX")).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.RECORD_INDEX_UPDATE_PARTITION_PATH_ENABLE.key()), (Object)"true")).$minus((Object)HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key());
        HoodieTestDataGenerator dataGen1 = HoodieTestDataGenerator.createTestGeneratorFirstPartition();
        HoodieTestDataGenerator dataGen2 = HoodieTestDataGenerator.createTestGeneratorSecondPartition();
        String instantTime1 = this.getNewInstantTime();
        Seq latestBatch = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen1.generateInserts(instantTime1, Predef$.MODULE$.int2Integer(5)))).asScala()).toSeq();
        String operation = DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL();
        Dataset latestBatchDf = this.spark().read().json(this.spark().sparkContext().parallelize(latestBatch, 1, ClassTag$.MODULE$.apply(String.class)));
        latestBatchDf.cache();
        latestBatchDf.write().format("org.apache.hudi").options((Map)hudiOpts).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset<Row> deletedDf1 = this.calculateMergedDf((Dataset<Row>)latestBatchDf, operation, true);
        deletedDf1.cache();
        String instantTime2 = this.getNewInstantTime();
        Seq latestBatch2_1 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen1.generateUniqueUpdates(instantTime2, Predef$.MODULE$.int2Integer(3)))).asScala()).toSeq();
        Dataset latestBatchDf2_1 = this.spark().read().json(this.spark().sparkContext().parallelize(latestBatch2_1, 1, ClassTag$.MODULE$.apply(String.class)));
        Dataset latestBatchDf2_2 = latestBatchDf2_1.withColumn("partition", functions$.MODULE$.lit((Object)"2015/03/16")).withColumn("partition_path", functions$.MODULE$.lit((Object)"2015/03/16"));
        Seq latestBatch2_3 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen2.generateInserts(instantTime2, Predef$.MODULE$.int2Integer(2)))).asScala()).toSeq();
        Dataset latestBatchDf2_3 = this.spark().read().json(this.spark().sparkContext().parallelize(latestBatch2_3, 1, ClassTag$.MODULE$.apply(String.class)));
        Dataset latestBatchDf2Final = latestBatchDf2_3.union(latestBatchDf2_2);
        latestBatchDf2Final.cache();
        latestBatchDf2Final.write().format("org.apache.hudi").options((Map)hudiOpts).mode(SaveMode.Append).save(this.basePath);
        operation = DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL();
        Dataset<Row> deletedDf2 = this.calculateMergedDf((Dataset<Row>)latestBatchDf2Final, operation, true);
        deletedDf2.cache();
        scala.collection.immutable.Map hudiOpts2 = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key()), (Object)"1")).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key()), (Object)"1")).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.INDEX_TYPE.key()), (Object)"RECORD_INDEX")).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.RECORD_INDEX_UPDATE_PARTITION_PATH_ENABLE.key()), (Object)"true")).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key()), (Object)"true"));
        String instantTime3 = this.getNewInstantTime();
        Seq latestBatch3 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen2.generateUniqueUpdates(instantTime3, Predef$.MODULE$.int2Integer(2)))).asScala()).toSeq();
        Dataset latestBatchDf3 = this.spark().read().json(this.spark().sparkContext().parallelize(latestBatch3, 1, ClassTag$.MODULE$.apply(String.class)));
        latestBatchDf3.cache();
        latestBatchDf.write().format("org.apache.hudi").options((Map)hudiOpts2).mode(SaveMode.Append).save(this.basePath);
        Dataset<Row> deletedDf3 = this.calculateMergedDf((Dataset<Row>)latestBatchDf, operation, true);
        deletedDf3.cache();
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, deletedDf3);
    }

    private String getNewInstantTime() {
        return InProcessTimeGenerator.createNewInstantTime();
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIUpsert(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIUpsertNonPartitioned(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = ((scala.collection.immutable.Map)this.commonOpts().$minus((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
    }

    @ParameterizedTest
    @CsvSource(value={"COPY_ON_WRITE,true", "COPY_ON_WRITE,false", "MERGE_ON_READ,true", "MERGE_ON_READ,false"})
    public void testRLIBulkInsertThenInsertOverwrite(HoodieTableType tableType, boolean enableRowWriter) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key()), (Object)Boolean.toString(enableRowWriter))})));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_TABLE_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIUpsertAndRollback(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.rollbackLastInstant((scala.collection.immutable.Map<String, String>)hudiOpts);
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, this.validateDataAndRecordIndices$default$2());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIPartiallyFailedUpsertAndRollback(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.deleteLastCompletedCommitFromTimeline((scala.collection.immutable.Map<String, String>)hudiOpts);
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIPartiallyFailedMetadataTableCommitAndRollback(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.deleteLastCompletedCommitFromDataAndMetadataTimeline((scala.collection.immutable.Map<String, String>)hudiOpts);
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIWithDelete(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        Dataset<Row> insertDf = this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Dataset deleteDf = insertDf.limit(1);
        deleteDf.write().format("org.apache.hudi").options((Map)hudiOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset prevDf = (Dataset)this.mergedDfList().last();
        this.mergedDfList_$eq((List<Dataset<Row>>)((List)this.mergedDfList().$colon$plus((Object)prevDf.except(deleteDf), List$.MODULE$.canBuildFrom())));
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, (Dataset<Row>)deleteDf);
    }

    @Test
    public void testRLIWithEmptyPayload() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)HoodieTableType.MERGE_ON_READ.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()), (Object)"0")})));
        Dataset<Row> insertDf = this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Dataset deleteDf = insertDf.limit(2);
        deleteDf.cache();
        deleteDf.write().format("hudi").options((Map)hudiOpts).option("hoodie.datasource.write.payload.class", "org.apache.hudi.common.model.EmptyHoodieRecordPayload").mode(SaveMode.Append).save(this.basePath);
        Dataset prevDf = (Dataset)this.mergedDfList().last();
        this.mergedDfList_$eq((List<Dataset<Row>>)((List)this.mergedDfList().$colon$plus((Object)prevDf.except(deleteDf), List$.MODULE$.canBuildFrom())));
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, (Dataset<Row>)deleteDf);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIForDeletesWithHoodieIsDeletedColumn(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        Dataset<Row> insertDf = this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        insertDf.cache();
        Buffer deleteBatch = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueDeleteRecords(this.getNewInstantTime(), Predef$.MODULE$.int2Integer(1)))).asScala();
        Dataset deleteDf = this.spark().read().json(this.spark().sparkContext().parallelize(deleteBatch.toSeq(), 1, ClassTag$.MODULE$.apply(String.class)));
        deleteDf.cache();
        String recordKeyToDelete = (String)((Row)deleteDf.collectAsList().get(0)).getAs("_row_key");
        deleteDf.write().format("org.apache.hudi").options((Map)hudiOpts).mode(SaveMode.Append).save(this.basePath);
        Dataset prevDf = (Dataset)this.mergedDfList().last();
        this.mergedDfList_$eq((List<Dataset<Row>>)((List)this.mergedDfList().$colon$plus((Object)prevDf.filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)TestRecordLevelIndex.$anonfun$testRLIForDeletesWithHoodieIsDeletedColumn$1(recordKeyToDelete, row))), List$.MODULE$.canBuildFrom())));
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, (Dataset<Row>)deleteDf);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIWithDeletePartition(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        Dataset<Row> latestSnapshot = this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.getHoodieWriteClient(this.getWriteConfig((scala.collection.immutable.Map<String, String>)hudiOpts)), (Function1 & Serializable & scala.Serializable)client -> {
            TestRecordLevelIndex.$anonfun$testRLIWithDeletePartition$2(this, latestSnapshot, hudiOpts, client);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIUpsertAndDropIndex(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        HoodieWriteConfig writeConfig = this.getWriteConfig((scala.collection.immutable.Map<String, String>)hudiOpts);
        writeConfig.setSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        this.getHoodieWriteClient(writeConfig).dropIndex(Collections.singletonList(MetadataPartitionType.RECORD_INDEX.getPartitionPath()));
        Assertions.assertEquals((long)0L, (long)this.getFileGroupCountForRecordIndex(writeConfig));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((int)0, (int)this.metaClient.getTableConfig().getMetadataPartitionsInflight().size());
        Assertions.assertEquals((int)3, (int)this.metaClient.getTableConfig().getMetadataPartitions().size());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIWithDTCleaning(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEANER_COMMITS_RETAINED.key()), (Object)"1")})));
        HoodieTableType hoodieTableType = tableType;
        HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
        if (!(hoodieTableType != null ? !hoodieTableType.equals(hoodieTableType2) : hoodieTableType2 != null)) {
            hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"15")})));
        }
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        org.apache.hudi.common.util.Option lastCleanInstant = this.getLatestMetaClient(false).getActiveTimeline().getCleanerTimeline().lastInstant();
        Assertions.assertTrue((boolean)lastCleanInstant.isPresent());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Assertions.assertTrue((((HoodieInstant)this.getLatestMetaClient(false).getActiveTimeline().getCleanerTimeline().lastInstant().get()).requestedTime().compareTo(((HoodieInstant)lastCleanInstant.get()).requestedTime()) > 0 ? 1 : 0) != 0);
        Option rollbackedInstant = Option$.MODULE$.empty();
        while (true) {
            if (!rollbackedInstant.isEmpty()) {
                String string = ((HoodieInstant)rollbackedInstant.get()).getAction();
                String string2 = ActionType.clean.name();
                if (!(string == null ? string2 != null : !string.equals(string2))) break;
            }
            rollbackedInstant = Option$.MODULE$.apply((Object)this.rollbackLastInstant((scala.collection.immutable.Map<String, String>)hudiOpts));
        }
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, this.validateDataAndRecordIndices$default$2());
    }

    @Test
    public void testRLIWithDTCompaction() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)HoodieTableType.MERGE_ON_READ.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT.key()), (Object)"0")})));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        org.apache.hudi.common.util.Option<HoodieInstant> lastCompactionInstant = this.getLatestCompactionInstant();
        Assertions.assertTrue((boolean)lastCompactionInstant.isPresent());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Assertions.assertTrue((((HoodieInstant)this.getLatestCompactionInstant().get()).requestedTime().compareTo(((HoodieInstant)lastCompactionInstant.get()).requestedTime()) > 0 ? 1 : 0) != 0);
        lastCompactionInstant = this.getLatestCompactionInstant();
        Option rollbackedInstant = Option$.MODULE$.empty();
        while (true) {
            if (!rollbackedInstant.isEmpty()) {
                String string = ((HoodieInstant)rollbackedInstant.get()).requestedTime();
                String string2 = ((HoodieInstant)lastCompactionInstant.get()).requestedTime();
                if (!(string == null ? string2 != null : !string.equals(string2))) break;
            }
            rollbackedInstant = Option$.MODULE$.apply((Object)this.rollbackLastInstant((scala.collection.immutable.Map<String, String>)hudiOpts));
        }
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, this.validateDataAndRecordIndices$default$2());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIWithDTClustering(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.INLINE_CLUSTERING.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS.key()), (Object)"2")})));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        org.apache.hudi.common.util.Option<HoodieInstant> lastClusteringInstant = this.getLatestClusteringInstant();
        Assertions.assertTrue((boolean)lastClusteringInstant.isPresent());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Assertions.assertTrue((((HoodieInstant)this.getLatestClusteringInstant().get()).requestedTime().compareTo(((HoodieInstant)lastClusteringInstant.get()).requestedTime()) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals(this.getLatestClusteringInstant(), (Object)this.metaClient.getActiveTimeline().lastInstant());
        this.rollbackLastInstant((scala.collection.immutable.Map<String, String>)hudiOpts);
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, this.validateDataAndRecordIndices$default$2());
    }

    @ParameterizedTest
    @CsvSource(value={"COPY_ON_WRITE,COLUMN_STATS", "COPY_ON_WRITE,BLOOM_FILTERS", "COPY_ON_WRITE,COLUMN_STATS:BLOOM_FILTERS", "MERGE_ON_READ,COLUMN_STATS", "MERGE_ON_READ,BLOOM_FILTERS", "MERGE_ON_READ,COLUMN_STATS:BLOOM_FILTERS"})
    public void testRLIWithOtherMetadataPartitions(String tableType, String metadataPartitionTypes) {
        ObjectRef hudiOpts = ObjectRef.create(this.commonOpts());
        List metadataPartitions = ((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataPartitionTypes.split(":"))).toStream().map((Function1 & Serializable & scala.Serializable)p -> MetadataPartitionType.valueOf((String)p), Stream$.MODULE$.canBuildFrom())).toList();
        metadataPartitions.foreach((Function1 & Serializable & scala.Serializable)metadataPartition -> {
            TestRecordLevelIndex.$anonfun$testRLIWithOtherMetadataPartitions$2(hudiOpts, metadataPartition);
            return BoxedUnit.UNIT;
        });
        hudiOpts.elem = ((scala.collection.immutable.Map)hudiOpts.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Assertions.assertTrue((boolean)this.metadataWriter(this.getWriteConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem))).getEnabledPartitionTypes().containsAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)metadataPartitions).asJava()));
    }

    @ParameterizedTest
    @MethodSource(value={"testEnableDisableRLIParams"})
    public void testEnableDisableRLI(HoodieTableType tableType, boolean isPartitioned) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name())})));
        if (!isPartitioned) {
            hudiOpts = (scala.collection.immutable.Map)hudiOpts.$minus((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key());
        }
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        hudiOpts = hudiOpts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key()), (Object)"false"));
        this.metaClient.getTableConfig().setMetadataPartitionState(this.metaClient, MetadataPartitionType.RECORD_INDEX.getPartitionPath(), false);
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, false, this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        try {
            this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, this.validateDataAndRecordIndices$default$2());
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalStateException));
            Assertions.assertTrue((boolean)e.getMessage().contains("Record index is not initialized in MDT"));
        }
        hudiOpts = hudiOpts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key()), (Object)"true"));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, this.validateDataAndRecordIndices$default$2());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIWithMDTCompaction(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"1")})));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        HoodieTableFileSystemView metadataTableFSView = ((HoodieBackedTableMetadata)this.getHoodieTable(this.metaClient, this.getWriteConfig((scala.collection.immutable.Map<String, String>)hudiOpts)).getMetadataTable()).getMetadataFileSystemView();
        HoodieTimeline compactionTimeline = metadataTableFSView.getVisibleCommitsAndCompactionTimeline().filterCompletedAndCompactionInstants();
        org.apache.hudi.common.util.Option lastCompactionInstant = compactionTimeline.filter(JavaConversions$.MODULE$.getPredicate((Function1 & Serializable & scala.Serializable)instant -> BoxesRunTime.boxToBoolean((boolean)TestRecordLevelIndex.$anonfun$testRLIWithMDTCompaction$1(this, compactionTimeline, instant)))).lastInstant();
        Optional compactionBaseFile = metadataTableFSView.getAllBaseFiles(MetadataPartitionType.RECORD_INDEX.getPartitionPath()).filter(JavaConversions$.MODULE$.getPredicate((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)TestRecordLevelIndex.$anonfun$testRLIWithMDTCompaction$2(lastCompactionInstant, f)))).findAny();
        Assertions.assertTrue((boolean)compactionBaseFile.isPresent());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIWithMDTCleaning(HoodieTableType tableType) {
        ObjectRef hudiOpts = ObjectRef.create((Object)this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"1")}))));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        hudiOpts.elem = ((scala.collection.immutable.Map)hudiOpts.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEANER_FILE_VERSIONS_RETAINED.key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"4"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        Function0 & Serializable & scala.Serializable function = (Function0 & Serializable & scala.Serializable)() -> this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts$3.elem), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.executeFunctionNTimes(function, 5);
        Assertions.assertTrue((boolean)this.getMetadataMetaClient((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem)).getActiveTimeline().getCleanerTimeline().lastInstant().isPresent());
        this.rollbackLastInstant((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem));
        this.rollbackLastInstant((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem));
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem), this.validateDataAndRecordIndices$default$2());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIWithMultiWriter(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key()), (Object)"optimistic_concurrency_control"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.key()), (Object)"LAZY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key()), (Object)"org.apache.hudi.client.transaction.lock.FileSystemBasedLockProvider"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieLockConfig.WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS_NAME.key()), (Object)PreferWriterConflictResolutionStrategy.class.getName())})));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, false, this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        ExecutorService executor = Executors.newFixedThreadPool(2);
        ExecutionContextExecutor executorContext = ExecutionContext$.MODULE$.fromExecutor((Executor)executor);
        Function0.mcZ.sp function = new Function0.mcZ.sp(this, hudiOpts){
            private final /* synthetic */ TestRecordLevelIndex $outer;
            private final scala.collection.immutable.Map hudiOpts$4;

            public byte apply$mcB$sp() {
                return Function0.apply$mcB$sp$((Function0)this);
            }

            public char apply$mcC$sp() {
                return Function0.apply$mcC$sp$((Function0)this);
            }

            public double apply$mcD$sp() {
                return Function0.apply$mcD$sp$((Function0)this);
            }

            public float apply$mcF$sp() {
                return Function0.apply$mcF$sp$((Function0)this);
            }

            public int apply$mcI$sp() {
                return Function0.apply$mcI$sp$((Function0)this);
            }

            public long apply$mcJ$sp() {
                return Function0.apply$mcJ$sp$((Function0)this);
            }

            public short apply$mcS$sp() {
                return Function0.apply$mcS$sp$((Function0)this);
            }

            public void apply$mcV$sp() {
                Function0.apply$mcV$sp$((Function0)this);
            }

            public String toString() {
                return Function0.toString$((Function0)this);
            }

            public boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                boolean bl;
                try {
                    this.$outer.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)this.hudiOpts$4, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, false, this.$outer.doWriteAndValidateDataAndRecordIndex$default$5(), this.$outer.doWriteAndValidateDataAndRecordIndex$default$6());
                    bl = true;
                }
                catch (HoodieWriteConflictException hoodieWriteConflictException) {
                    bl = false;
                }
                catch (Throwable e) {
                    throw new Exception("Multi write failed", e);
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hudiOpts$4 = hudiOpts$4;
                Function0.$init$((Function0)this);
            }
        };
        Future f1 = Future$.MODULE$.apply((Function0)function, (ExecutionContext)executorContext);
        Future f2 = Future$.MODULE$.apply((Function0)function, (ExecutionContext)executorContext);
        Await$.MODULE$.result((Awaitable)f1, Duration$.MODULE$.apply("5 minutes"));
        Await$.MODULE$.result((Awaitable)f2, Duration$.MODULE$.apply("5 minutes"));
        Assertions.assertTrue((BoxesRunTime.unboxToBoolean((Object)((Try)f1.value().get()).get()) || BoxesRunTime.unboxToBoolean((Object)((Try)f2.value().get()).get()) ? 1 : 0) != 0);
        executor.shutdownNow();
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, this.validateDataAndRecordIndices$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$testRLIForDeletesWithHoodieIsDeletedColumn$1(String recordKeyToDelete$1, Row row) {
        String string = (String)row.getAs("_row_key");
        String string2 = recordKeyToDelete$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testRLIWithDeletePartition$2(TestRecordLevelIndex $this, Dataset latestSnapshot$1, scala.collection.immutable.Map hudiOpts$1, SparkRDDWriteClient client) {
        String commitTime = client.startCommit();
        client.startCommitWithTime(commitTime, "replacecommit");
        String deletingPartition = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.protected$dataGen($this).getPartitionPaths())).last();
        java.util.List<String> partitionList = Collections.singletonList(deletingPartition);
        client.deletePartitions(partitionList, commitTime);
        Dataset deletedDf = latestSnapshot$1.filter(new StringBuilder(12).append("partition = ").append(deletingPartition).toString());
        $this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts$1, (Dataset<Row>)deletedDf);
    }

    public static final /* synthetic */ void $anonfun$testRLIWithOtherMetadataPartitions$2(ObjectRef hudiOpts$2, MetadataPartitionType metadataPartition) {
        MetadataPartitionType metadataPartitionType = metadataPartition;
        MetadataPartitionType metadataPartitionType2 = MetadataPartitionType.COLUMN_STATS;
        if (!(metadataPartitionType != null ? !metadataPartitionType.equals(metadataPartitionType2) : metadataPartitionType2 != null)) {
            hudiOpts$2.elem = ((scala.collection.immutable.Map)hudiOpts$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true"));
            return;
        }
        MetadataPartitionType metadataPartitionType3 = metadataPartition;
        MetadataPartitionType metadataPartitionType4 = MetadataPartitionType.BLOOM_FILTERS;
        if (!(metadataPartitionType3 != null ? !metadataPartitionType3.equals(metadataPartitionType4) : metadataPartitionType4 != null)) {
            hudiOpts$2.elem = ((scala.collection.immutable.Map)hudiOpts$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_BLOOM_FILTER.key()), (Object)"true"));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testRLIWithMDTCompaction$1(TestRecordLevelIndex $this, HoodieTimeline compactionTimeline$1, HoodieInstant instant) {
        WriteOperationType writeOperationType = ((HoodieCommitMetadata)$this.protected$metaClient($this).getTimelineLayout().getCommitMetadataSerDe().deserialize(instant, (byte[])compactionTimeline$1.getInstantDetails(instant).get(), HoodieCommitMetadata.class)).getOperationType();
        WriteOperationType writeOperationType2 = WriteOperationType.COMPACT;
        return !(writeOperationType != null ? !writeOperationType.equals(writeOperationType2) : writeOperationType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testRLIWithMDTCompaction$2(org.apache.hudi.common.util.Option lastCompactionInstant$1, HoodieBaseFile f) {
        return f.getCommitTime().equals(((HoodieInstant)lastCompactionInstant$1.get()).requestedTime());
    }
}

