/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.HoodieFileIndex$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.client.transaction.SimpleConcurrentFileWritesConflictResolutionStrategy;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieMetadataIndexException;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.apache.hudi.functional.TestSecondaryIndexPruning$;
import org.apache.hudi.functional.TestSecondaryIndexPruning$$anon$1$;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataFileSystemView;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.hudi.util.JFunction$;
import org.apache.hudi.util.JavaConversions$;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Try;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\r=h\u0001\u0002'N\u0001YCQ!\u0018\u0001\u0005\u0002yCq!\u0019\u0001C\u0002\u0013\u0005!\r\u0003\u0004t\u0001\u0001\u0006Ia\u0019\u0005\bi\u0002\u0011\r\u0011\"\u0001c\u0011\u0019)\b\u0001)A\u0005G\"9a\u000f\u0001a\u0001\n\u00039\b\"CA\u0014\u0001\u0001\u0007I\u0011AA\u0015\u0011\u001d\t9\u0004\u0001Q!\naD\u0011\"!\u000f\u0001\u0001\u0004%\t!a\u000f\t\u0013\u0005-\u0003\u00011A\u0005\u0002\u00055\u0003\u0002CA)\u0001\u0001\u0006K!!\u0010\t\u0017\u0005M\u0003\u00011AA\u0002\u0013\u0005\u0011Q\u000b\u0005\f\u0003O\u0002\u0001\u0019!a\u0001\n\u0003\tI\u0007C\u0006\u0002n\u0001\u0001\r\u0011!Q!\n\u0005]\u0003bBA8\u0001\u0011\u0005\u0013\u0011\u000f\u0005\b\u0003w\u0002A\u0011AA?\u0011\u001d\t)\n\u0001C\u0001\u0003/Cq!!3\u0001\t\u0003\ti\bC\u0004\u0002N\u0002!\t!a4\t\u000f\t}\u0007\u0001\"\u0001\u0003b\"9!1\u001e\u0001\u0005\u0002\t5\bb\u0002B{\u0001\u0011\u0005!q\u001f\u0005\b\u0005\u007f\u0004A\u0011AA?\u0011\u001d\u0019\u0019\u0001\u0001C\u0001\u0003{Bqaa\u0002\u0001\t\u0003\ti\bC\u0004\u0004\f\u0001!\t!! \t\u000f\r=\u0001\u0001\"\u0001\u0002~!911\u0003\u0001\u0005\u0002\u0005u\u0004bBB\f\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u00077\u0001A\u0011AB\u000f\u0011\u001d\u0019)\u0003\u0001C\u0005\u0007OAqaa\r\u0001\t\u0003\ti\bC\u0004\u00048\u0001!\ta!\u000f\t\u000f\r\u0005\u0003\u0001\"\u0001\u0002~!91Q\t\u0001\u0005\u0002\u0005u\u0004bBB%\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0007\u001b\u0002A\u0011AA?\u0011\u001d\u0019\t\u0006\u0001C\u0005\u0007'Bqaa\u0017\u0001\t\u0013\u0019i\u0006C\u0004\u0004v\u0001!Iaa\u001e\t\u0013\r\r\u0005!%A\u0005\n\t\u0015\u0002bBBC\u0001\u0011%1q\u0011\u0005\b\u0007;\u0003A\u0011BBP\u0011\u001d\u0019y\u000b\u0001C\u0005\u0007cC\u0011ba0\u0001#\u0003%IA!\u0010\t\u000f\r\u0005\u0007\u0001\"\u0003\u0004D\"911\u001b\u0001\u0005\n\rUwaBAq\u001b\"\u0005\u00111\u001d\u0004\u0007\u00196C\t!!:\t\ru\u000bD\u0011AAw\r\u0019\ty/\r!\u0002r\"Q\u0011q`\u001a\u0003\u0016\u0004%\tA!\u0001\t\u0013\t\r1G!E!\u0002\u0013\u0001\bB\u0003B\u0003g\tU\r\u0011\"\u0001\u0003\b!Q!qB\u001a\u0003\u0012\u0003\u0006IA!\u0003\t\ru\u001bD\u0011\u0001B\t\u0011%\u0011YbMA\u0001\n\u0003\u0011i\u0002C\u0005\u0003$M\n\n\u0011\"\u0001\u0003&!I!1H\u001a\u0012\u0002\u0013\u0005!Q\b\u0005\n\u0005\u0003\u001a\u0014\u0011!C!\u0003wA\u0011Ba\u00114\u0003\u0003%\tA!\u0012\t\u0013\t53'!A\u0005\u0002\t=\u0003\"\u0003B-g\u0005\u0005I\u0011\tB.\u0011%\u0011IgMA\u0001\n\u0003\u0011Y\u0007C\u0005\u0003pM\n\t\u0011\"\u0011\u0003r!I!1O\u001a\u0002\u0002\u0013\u0005#Q\u000f\u0005\n\u0005o\u001a\u0014\u0011!C!\u0005s:\u0011B! 2\u0003\u0003E\tAa \u0007\u0013\u0005=\u0018'!A\t\u0002\t\u0005\u0005BB/F\t\u0003\u0011y\tC\u0005\u0003t\u0015\u000b\t\u0011\"\u0012\u0003v!I!\u0011S#\u0002\u0002\u0013\u0005%1\u0013\u0005\n\u00053+\u0015\u0011!CA\u00057C\u0011B!,F\u0003\u0003%IAa,\t\u000f\t]\u0016\u0007\"\u0001\u0003:\nIB+Z:u'\u0016\u001cwN\u001c3befLe\u000eZ3y!J,h.\u001b8h\u0015\tqu*\u0001\u0006gk:\u001cG/[8oC2T!\u0001U)\u0002\t!,H-\u001b\u0006\u0003%N\u000ba!\u00199bG\",'\"\u0001+\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00019\u0006C\u0001-\\\u001b\u0005I&B\u0001.P\u0003%!Xm\u001d;vi&d7/\u0003\u0002]3\n\u00013\u000b]1sW\u000ec\u0017.\u001a8u\rVt7\r^5p]\u0006dG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tq\f\u0005\u0002a\u00015\tQ*\u0001\u0007nKR\fG-\u0019;b\u001fB$8/F\u0001d!\u0011!W\u000e\u001d9\u000f\u0005\u0015\\\u0007C\u00014j\u001b\u00059'B\u00015V\u0003\u0019a$o\\8u})\t!.A\u0003tG\u0006d\u0017-\u0003\u0002mS\u00061\u0001K]3eK\u001aL!A\\8\u0003\u00075\u000b\u0007O\u0003\u0002mSB\u0011A-]\u0005\u0003e>\u0014aa\u0015;sS:<\u0017!D7fi\u0006$\u0017\r^1PaR\u001c\b%\u0001\u0006d_6lwN\\(qiN\f1bY8n[>tw\n\u001d;tA\u0005aQ.\u001a:hK\u0012$e\rT5tiV\t\u0001\u0010\u0005\u0003z}\u0006\raB\u0001>}\u001d\t170C\u0001k\u0013\ti\u0018.A\u0004qC\u000e\\\u0017mZ3\n\u0007}\f\tA\u0001\u0003MSN$(BA?j!\u0011\t)!!\t\u000f\t\u0005\u001d\u0011Q\u0004\b\u0005\u0003\u0013\t9B\u0004\u0003\u0002\f\u0005Ma\u0002BA\u0007\u0003#q1AZA\b\u0013\u0005!\u0016B\u0001*T\u0013\r\t)\"U\u0001\u0006gB\f'o[\u0005\u0005\u00033\tY\"A\u0002tc2T1!!\u0006R\u0013\ri\u0018q\u0004\u0006\u0005\u00033\tY\"\u0003\u0003\u0002$\u0005\u0015\"!\u0003#bi\u00064%/Y7f\u0015\ri\u0018qD\u0001\u0011[\u0016\u0014x-\u001a3EM2K7\u000f^0%KF$B!a\u000b\u00024A!\u0011QFA\u0018\u001b\u0005I\u0017bAA\u0019S\n!QK\\5u\u0011!\t)dBA\u0001\u0002\u0004A\u0018a\u0001=%c\u0005iQ.\u001a:hK\u0012$e\rT5ti\u0002\n\u0011\u0002^1cY\u0016t\u0015-\\3\u0016\u0005\u0005u\u0002\u0003BA \u0003\u0013j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0005Y\u0006twM\u0003\u0002\u0002H\u0005!!.\u0019<b\u0013\r\u0011\u0018\u0011I\u0001\u000ei\u0006\u0014G.\u001a(b[\u0016|F%Z9\u0015\t\u0005-\u0012q\n\u0005\n\u0003kQ\u0011\u0011!a\u0001\u0003{\t!\u0002^1cY\u0016t\u0015-\\3!\u0003)iW\r^1DY&,g\u000e^\u000b\u0003\u0003/\u0002B!!\u0017\u0002d5\u0011\u00111\f\u0006\u0005\u0003;\ny&A\u0003uC\ndWMC\u0002\u0002b=\u000baaY8n[>t\u0017\u0002BA3\u00037\u0012Q\u0003S8pI&,G+\u00192mK6+G/Y\"mS\u0016tG/\u0001\bnKR\f7\t\\5f]R|F%Z9\u0015\t\u0005-\u00121\u000e\u0005\n\u0003ki\u0011\u0011!a\u0001\u0003/\n1\"\\3uC\u000ec\u0017.\u001a8uA\u0005!1m\u001c8g)\t\t\u0019\b\u0005\u0003\u0002v\u0005]TBAA\u000e\u0013\u0011\tI(a\u0007\u0003\u0013M\u0003\u0018M]6D_:4\u0017\u0001\n;fgR\u001cVmY8oI\u0006\u0014\u00180\u00138eKb<\u0016\u000e\u001e5pkR\u0014VmY8sI&sG-\u001a=\u0015\u0005\u0005-\u0002f\u0001\t\u0002\u0002B!\u00111QAI\u001b\t\t)I\u0003\u0003\u0002\b\u0006%\u0015aA1qS*!\u00111RAG\u0003\u001dQW\u000f]5uKJT1!a$T\u0003\u0015QWO\\5u\u0013\u0011\t\u0019*!\"\u0003\tQ+7\u000f^\u0001\u001ei\u0016\u001cHoU3d_:$\u0017M]=J]\u0012,\u0007pV5uQ\u001aKG\u000e^3sgR!\u00111FAM\u0011\u001d\tY*\u0005a\u0001\u0003;\u000bq\u0002[8pI&,G+\u00192mKRK\b/\u001a\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*!\u00111UA0\u0003\u0015iw\u000eZ3m\u0013\u0011\t9+!)\u0003\u001f!{w\u000eZ5f)\u0006\u0014G.\u001a+za\u0016Ds!EAV\u0003w\u000bi\f\u0005\u0003\u0002.\u0006]VBAAX\u0015\u0011\t\t,a-\u0002\u0011A\u0014xN^5eKJTA!!.\u0002\n\u00061\u0001/\u0019:b[NLA!!/\u00020\nQQI\\;n'>,(oY3\u0002\u000bY\fG.^3$\u0005\u0005u\u0005fA\t\u0002BB!\u00111YAc\u001b\t\t\u0019,\u0003\u0003\u0002H\u0006M&!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006yB/Z:u\u0007J,\u0017\r^3B]\u0012$%o\u001c9TK\u000e|g\u000eZ1ss&sG-\u001a=)\u0007I\t\t)\u0001\u0013uKN$8+Z2p]\u0012\f'/_%oI\u0016D\bK];oS:<w+\u001b;i+B$\u0017\r^3t)\u0011\tY#!5\t\u000f\u0005M7\u00031\u0001\u0002V\u0006AA/Z:u\u0007\u0006\u001cX\rE\u0002\u0002XNr1!!71\u001d\u0011\tY.a8\u000f\t\u0005-\u0011Q\\\u0005\u0003!FK!AT(\u00023Q+7\u000f^*fG>tG-\u0019:z\u0013:$W\r\u001f)sk:Lgn\u001a\t\u0003AF\u001a2!MAt!\u0011\ti#!;\n\u0007\u0005-\u0018N\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003G\u0014acU3d_:$\u0017M]=J]\u0012,\u0007\u0010V3ti\u000e\u000b7/Z\n\bg\u0005\u001d\u00181_A}!\u0011\ti#!>\n\u0007\u0005]\u0018NA\u0004Qe>$Wo\u0019;\u0011\t\u00055\u00121`\u0005\u0004\u0003{L'\u0001D*fe&\fG.\u001b>bE2,\u0017!\u0003;bE2,G+\u001f9f+\u0005\u0001\u0018A\u0003;bE2,G+\u001f9fA\u0005i\u0011n\u001d)beRLG/[8oK\u0012,\"A!\u0003\u0011\t\u00055\"1B\u0005\u0004\u0005\u001bI'a\u0002\"p_2,\u0017M\\\u0001\u000fSN\u0004\u0016M\u001d;ji&|g.\u001a3!)\u0019\u0011\u0019Ba\u0006\u0003\u001aA\u0019!QC\u001a\u000e\u0003EBa!a@9\u0001\u0004\u0001\bb\u0002B\u0003q\u0001\u0007!\u0011B\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0003\u0014\t}!\u0011\u0005\u0005\t\u0003\u007fL\u0004\u0013!a\u0001a\"I!QA\u001d\u0011\u0002\u0003\u0007!\u0011B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u00119CK\u0002q\u0005SY#Aa\u000b\u0011\t\t5\"qG\u0007\u0003\u0005_QAA!\r\u00034\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005kI\u0017AC1o]>$\u0018\r^5p]&!!\u0011\bB\u0018\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yD\u000b\u0003\u0003\n\t%\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003HA!\u0011Q\u0006B%\u0013\r\u0011Y%\u001b\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005#\u00129\u0006\u0005\u0003\u0002.\tM\u0013b\u0001B+S\n\u0019\u0011I\\=\t\u0013\u0005Ub(!AA\u0002\t\u001d\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tu\u0003C\u0002B0\u0005K\u0012\t&\u0004\u0002\u0003b)\u0019!1M5\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003h\t\u0005$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\u0003\u0003n!I\u0011Q\u0007!\u0002\u0002\u0003\u0007!\u0011K\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!qI\u0001\ti>\u001cFO]5oOR\u0011\u0011QH\u0001\u0007KF,\u0018\r\\:\u0015\t\t%!1\u0010\u0005\n\u0003k\u0019\u0015\u0011!a\u0001\u0005#\nacU3d_:$\u0017M]=J]\u0012,\u0007\u0010V3ti\u000e\u000b7/\u001a\t\u0004\u0005+)5#B#\u0003\u0004\u0006e\b#\u0003BC\u0005\u0017\u0003(\u0011\u0002B\n\u001b\t\u00119IC\u0002\u0003\n&\fqA];oi&lW-\u0003\u0003\u0003\u000e\n\u001d%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!qP\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0005'\u0011)Ja&\t\r\u0005}\b\n1\u0001q\u0011\u001d\u0011)\u0001\u0013a\u0001\u0005\u0013\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u001e\n%\u0006CBA\u0017\u0005?\u0013\u0019+C\u0002\u0003\"&\u0014aa\u00149uS>t\u0007cBA\u0017\u0005K\u0003(\u0011B\u0005\u0004\u0005OK'A\u0002+va2,'\u0007C\u0005\u0003,&\u000b\t\u00111\u0001\u0003\u0014\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005c\u0003B!a\u0010\u00034&!!QWA!\u0005\u0019y%M[3di\u0006\u0019C/Z:u'\u0016\u001cwN\u001c3befLe\u000eZ3y!J,h.\u001b8h!\u0006\u0014\u0018-\\3uKJ\u001cHC\u0001B^!\u0019\u0011iLa2\u0003L6\u0011!q\u0018\u0006\u0005\u0005\u0003\u0014\u0019-\u0001\u0004tiJ,\u0017-\u001c\u0006\u0005\u0005\u000b\f)%\u0001\u0003vi&d\u0017\u0002\u0002Be\u0005\u007f\u0013aa\u0015;sK\u0006l\u0007\u0003BAW\u0005\u001bLAAa4\u00020\nI\u0011I]4v[\u0016tGo\u001d\u0015\b'\tM\u00171\u0018Bm!\u0011\tiK!6\n\t\t]\u0017q\u0016\u0002\r\u001b\u0016$\bn\u001c3T_V\u00148-\u001a\u0017\u0003\u00057\f#Aa.)\u0007M\t\t-A\u0015uKN$8+Z2p]\u0012\f'/_%oI\u0016Dx+\u001b;i!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;t\u0013:$W\r\u001f\u000b\u0005\u0003W\u0011\u0019\u000fC\u0004\u0002TR\u0001\r!!6)\u000fQ\u0011\u0019.a/\u0003h2\u0012!1\u001c\u0015\u0004)\u0005\u0005\u0017A\n;fgR\u001cVmY8oI\u0006\u0014\u00180\u00138eKb<\u0016\u000e\u001e5D_:\u001cWO\u001d:f]R<&/\u001b;fgR!\u00111\u0006Bx\u0011\u001d\ty0\u0006a\u0001\u0003;Cs!FAV\u0003w\u000bi\fK\u0002\u0016\u0003\u0003\f1\u0006^3tiN+7m\u001c8eCJL\u0018J\u001c3fq^KG\u000f[\"p[B\f7\r^5p]\u0006sGm\u00117fC:Lgn\u001a\u000b\u0005\u0003W\u0011I\u0010C\u0004\u0002\u0000Z\u0001\r!!()\u000fY\tY+a/\u0002>\"\u001aa#!1\u0002GQ,7\u000f^*fG>tG-\u0019:z\u0013:$W\r_,ji\"lE\tV\"p[B\f7\r^5p]\"\u001aq#!!\u0002YQ,7\u000f^*fG>tG-\u0019:z\u0013:$W\r_,ji\",e/\u001a8u)&lWm\u0014:eKJLgnZ'fe\u001e,\u0007f\u0001\r\u0002\u0002\u0006)C/Z:u'\u0016\u001cwN\u001c3befLe\u000eZ3y/&$\bnQ;ti>lW*\u001a:hK6{G-\u001a\u0015\u00043\u0005\u0005\u0015A\r;fgR\u001cVmY8oI\u0006\u0014\u00180\u00138eKb<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f+B$\u0017\r^3t\r>\u00148+Y7f%\u0016\u001cwN\u001d3)\u0007i\t\t)\u0001\u0013uKN$8+Z2p]\u0012\f'/_%oI\u0016Dx+\u001b;i\u001f:d\u0017\u0010R3mKR,Gj\\4tQ\rY\u0012\u0011Q\u0001-i\u0016\u001cHoU3d_:$\u0017M]=J]\u0012,\u0007pV5uQV\u0003H-\u0019;f\r>dGn\\<fI\nKH)\u001a7fi\u0016D3\u0001HAA\u0003}\"Xm\u001d;TK\u000e|g\u000eZ1ss&sG-\u001a=XSRD7+Y7f'\u0016\u001cwN\u001c3bef\\U-_+qI\u0006$Xm\u001d$pe6+H\u000e^5qY\u0016\u0014VmY8sIND3!HAA\u0003-\"Xm\u001d;TK\u000e|g\u000eZ1ss&sG-\u001a=XSRD7\t\\;ti\u0016\u0014\u0018N\\4B]\u0012\u001cE.Z1oS:<G\u0003BA\u0016\u0007?Aq!a@\u001f\u0001\u0004\ti\nK\u0004\u001f\u0003W\u000bY,!0)\u0007y\t\t-A\u000bd_:4\u0017N]7MCN$8i\\7nSR$\u0016\u0010]3\u0015\t\u0005-2\u0011\u0006\u0005\b\u0007Wy\u0002\u0019AB\u0017\u0003)\t7\r^5p]RK\b/\u001a\t\u0005\u0003?\u001by#\u0003\u0003\u00042\u0005\u0005&AC!di&|g\u000eV=qK\u0006IC/Z:u'\u0016\u001cwN\u001c3befLe\u000eZ3y/&$\bnU1wKB|\u0017N\u001c;B]\u0012\u0014Vm\u001d;pe\u0016D3\u0001IAA\u0003m!Xm\u001d;Va\u0012\fG/Z:SK&s7/\u001a:ug\u0012+G.\u001a;fgR!\u00111FB\u001e\u0011\u001d\tY*\ta\u0001\u0003;Cs!IAV\u0003w\u000bi\fK\u0002\"\u0003\u0003\f\u0001\u0006^3tiN+7m\u001c8eCJL\u0018J\u001c3fq^KG\u000f\u001b)sS6LG/\u001b<f\t\u0006$\u0018\rV=qKND3AIAA\u0003\t\"Xm\u001d;TK\u000e|g\u000eZ1ss&sG-\u001a=XSRD7i\\7qY\u0016DH+\u001f9fg\"\u001a1%!!\u0002EQ,7\u000f^*fG>tG-\u0019:z\u0013:$W\r_,ji\"tUm\u001d;fI\u001aKW\r\u001c3tQ\r!\u0013\u0011Q\u0001,i\u0016\u001cHoU3d_:$\u0017M]=J]\u0012,\u0007pV5uQB\u000b'\u000f^5bY2Lh)Y5mK\u0012\u001cu.\\7ji\"\u001aQ%!!\u0002K\u0011,G.\u001a;f\u0019\u0006\u001cHoQ8na2,G/\u001a3D_6l\u0017\u000e\u001e$s_6$\u0016.\\3mS:,GCBA\u0016\u0007+\u001aI\u0006\u0003\u0004\u0004X\u0019\u0002\raY\u0001\tQV$\u0017n\u00149ug\"9\u00111\u000b\u0014A\u0002\u0005]\u0013aC2iK\u000e\\\u0017I\\:xKJ$Baa\u0018\u0004rQ!\u00111FB1\u0011\u001d\u0019\u0019g\na\u0001\u0007K\nq!\u001a=qK\u000e$8\u000f\u0005\u0004\u0002.\r\u001d41N\u0005\u0004\u0007SJ'A\u0003\u001fsKB,\u0017\r^3e}A)\u0011p!\u001c\u0003R%!1qNA\u0001\u0005\r\u0019V-\u001d\u0005\u0007\u0007g:\u0003\u0019\u00019\u0002\u000bE,XM]=\u0002)Y,'/\u001b4z#V,'/\u001f)sK\u0012L7-\u0019;f)!\tYc!\u001f\u0004|\r}\u0004BBB,Q\u0001\u00071\r\u0003\u0004\u0004~!\u0002\r\u0001]\u0001\u000bG>dW/\u001c8OC6,\u0007\u0002CBAQA\u0005\t\u0019\u00019\u0002\u001d9|g.\u0012=jgR,g\u000e^&fs\u0006qb/\u001a:jMf\fV/\u001a:z!J,G-[2bi\u0016$C-\u001a4bk2$HeM\u0001\nCR$(/\u001b2vi\u0016$Ba!#\u0004\u001aB!11RBK\u001b\t\u0019iI\u0003\u0003\u0004\u0010\u000eE\u0015aC3yaJ,7o]5p]NTAaa%\u0002 \u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0004\u0018\u000e5%AE!uiJL'-\u001e;f%\u00164WM]3oG\u0016Daaa'+\u0001\u0004\u0001\u0018!\u00039beRLG/[8o\u0003E1XM]5gs\u001aKG.\u001a)sk:Lgn\u001a\u000b\u0007\u0003W\u0019\tk!*\t\r\r\r6\u00061\u0001d\u0003\u0011y\u0007\u000f^:\t\u000f\r\u001d6\u00061\u0001\u0004*\u0006QA-\u0019;b\r&dG/\u001a:\u0011\t\r-51V\u0005\u0005\u0007[\u001biI\u0001\u0006FqB\u0014Xm]:j_:\fqcZ3u\u0019\u0006$Xm\u001d;ECR\fg)\u001b7fg\u000e{WO\u001c;\u0015\r\rM6\u0011XB^!\u0011\tic!.\n\u0007\r]\u0016N\u0001\u0003M_:<\u0007BBBRY\u0001\u00071\rC\u0005\u0004>2\u0002\n\u00111\u0001\u0003\n\u0005y\u0011N\\2mk\u0012,Gj\\4GS2,7/A\u0011hKRd\u0015\r^3ti\u0012\u000bG/\u0019$jY\u0016\u001c8i\\;oi\u0012\"WMZ1vYR$#'\u0001\fhKR$\u0016M\u00197f\r&dWmU=ti\u0016lg+[3x)\u0011\u0019)m!5\u0011\t\r\u001d7QZ\u0007\u0003\u0007\u0013T1aa3P\u0003!iW\r^1eCR\f\u0017\u0002BBh\u0007\u0013\u0014A\u0004S8pI&,W*\u001a;bI\u0006$\u0018MR5mKNK8\u000f^3n-&,w\u000f\u0003\u0004\u0004$:\u0002\raY\u0001\u000fO\u0016$xK]5uK\u000e{gNZ5h)\u0011\u00199na9\u0011\t\re7q\\\u0007\u0003\u00077T1a!8P\u0003\u0019\u0019wN\u001c4jO&!1\u0011]Bn\u0005EAun\u001c3jK^\u0013\u0018\u000e^3D_:4\u0017n\u001a\u0005\u0007\u0007/z\u0003\u0019A2)\u000f\u0001\u00199/a/\u0004nB!\u00111QBu\u0013\u0011\u0019Y/!\"\u0003\u0007Q\u000bw-I\u0001O\u0001")
public class TestSecondaryIndexPruning
extends SparkClientFunctionalTestHarness {
    private final scala.collection.immutable.Map<String, String> metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key()), (Object)"true")}));
    private final scala.collection.immutable.Map<String, String> commonOpts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"record_key_col"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition_key_col"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_PAYLOAD_CLASS_NAME.key()), (Object)"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORD_MERGE_MODE().key()), (Object)RecordMergeMode.COMMIT_TIME_ORDERING.name())}))).$plus$plus(this.metadataOpts());
    private List<Dataset<Row>> mergedDfList = List$.MODULE$.empty();
    private String tableName = "hoodie_";
    private HoodieTableMetaClient metaClient;

    public static Stream<Arguments> testSecondaryIndexPruningParameters() {
        return TestSecondaryIndexPruning$.MODULE$.testSecondaryIndexPruningParameters();
    }

    public scala.collection.immutable.Map<String, String> metadataOpts() {
        return this.metadataOpts;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public List<Dataset<Row>> mergedDfList() {
        return this.mergedDfList;
    }

    public void mergedDfList_$eq(List<Dataset<Row>> x$1) {
        this.mergedDfList = x$1;
    }

    public String tableName() {
        return this.tableName;
    }

    public void tableName_$eq(String x$1) {
        this.tableName = x$1;
    }

    public HoodieTableMetaClient metaClient() {
        return this.metaClient;
    }

    public void metaClient_$eq(HoodieTableMetaClient x$1) {
        this.metaClient = x$1;
    }

    public SparkConf conf() {
        return this.conf(SparkClientFunctionalTestHarness.getSparkSqlConf());
    }

    @Test
    public void testSecondaryIndexWithoutRecordIndex() {
        this.tableName_$eq(new StringBuilder(32).append(this.tableName()).append("test_secondary_index_without_rli").toString());
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(616).append("\n         |create table ").append(this.tableName()).append(" (\n         |  ts bigint,\n         |  record_key_col string,\n         |  not_record_key_col string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(1, 'row1', 'abc', 'p1')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(2, 'row2', 'cde', 'p2')").toString());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(60).append("create index idx_not_record_key_col on ").append(this.tableName()).append(" (not_record_key_col)").toString()), ClassTag$.MODULE$.apply(HoodieMetadataIndexException.class), new Position("TestSecondaryIndexPruning.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testSecondaryIndexWithFilters(HoodieTableType hoodieTableType) {
        String tableType = hoodieTableType.name();
        boolean isPartitioned = true;
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")})));
        String sqlTableType = tableType.equals(HoodieTableType.COPY_ON_WRITE.name()) ? "cow" : "mor";
        this.tableName_$eq(new StringBuilder(33).append(this.tableName()).append("test_secondary_index_with_filters").append((Object)(isPartitioned ? "_partitioned" : "")).append(sqlTableType).toString());
        String partitionedByClause = isPartitioned ? "partitioned by(partition_key_col)" : "";
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(664).append("\n         |create table ").append(this.tableName()).append(" (\n         |  ts bigint,\n         |  record_key_col string,\n         |  not_record_key_col string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  type = '").append(sqlTableType).append("',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | ").append(partitionedByClause).append("\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(1, 'row1', 'abc', 'p1')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(2, 'row2', 'cde', 'p2')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(3, 'row3', 'def', 'p2')").toString());
        this.spark().sql(new StringBuilder(60).append("create index idx_not_record_key_col on ").append(this.tableName()).append(" (not_record_key_col)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        Predef$.MODULE$.assert(this.metaClient().getTableConfig().getMetadataPartitions().contains("secondary_index_idx_not_record_key_col"));
        this.checkAnswer(new StringBuilder(46).append("select key from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new StringBuilder(8).append("abc").append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("cde").append("$").append("row2").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("def").append("$").append("row3").toString(), (List)Nil$.MODULE$)}));
        this.spark().sql("set hoodie.metadata.enable=true");
        this.spark().sql("set hoodie.enable.data.skipping=true");
        this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        this.checkAnswer(new StringBuilder(103).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(this.tableName()).append(" where not_record_key_col = 'abc'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "row1", "abc", "p1"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "not_record_key_col", this.verifyQueryPredicate$default$3());
        this.spark().sql(new StringBuilder(28).append("create index idx_ts on ").append(this.tableName()).append(" (ts)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient()));
        Predef$.MODULE$.assert(this.metaClient().getTableConfig().getMetadataPartitions().contains("secondary_index_idx_ts"));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "ts", this.verifyQueryPredicate$default$3());
        this.checkAnswer(new StringBuilder(46).append("select key from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new StringBuilder(6).append("1").append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(6).append("2").append("$").append("row2").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(6).append("3").append("$").append("row3").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("abc").append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("cde").append("$").append("row2").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("def").append("$").append("row3").toString(), (List)Nil$.MODULE$)}));
        this.spark().sql(new StringBuilder(68).append("update ").append(this.tableName()).append(" set not_record_key_col = 'xyz' where record_key_col = 'row1'").toString());
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("xyz").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("cde").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("def").append("$").append("row3").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(6).append("1").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(6).append("2").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(6).append("3").append("$").append("row3").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.checkAnswer(new StringBuilder(100).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(this.tableName()).append(" where record_key_col = 'row1'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "row1", "xyz", "p1"}))}));
        this.checkAnswer(new StringBuilder(83).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(this.tableName()).append(" where ts = 1").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "row1", "xyz", "p1"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "not_record_key_col", "abc");
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "ts", this.verifyQueryPredicate$default$3());
    }

    @Test
    public void testCreateAndDropSecondaryIndex() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")})));
        this.tableName_$eq(new StringBuilder(48).append(this.tableName()).append("test_secondary_index_create_drop_partitioned_mor").toString());
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(700).append("\n         |create table ").append(this.tableName()).append(" (\n         |  ts bigint,\n         |  record_key_col string,\n         |  not_record_key_col string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  type = 'mor',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(1, 'row1', 'abc', 'p1')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(2, 'row2', 'cde', 'p2')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(3, 'row3', 'def', 'p2')").toString());
        this.spark().sql(new StringBuilder(60).append("create index idx_not_record_key_col on ").append(this.tableName()).append(" (not_record_key_col)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        this.checkAnswer(new StringBuilder(46).append("select key from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new StringBuilder(8).append("abc").append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("cde").append("$").append("row2").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("def").append("$").append("row3").toString(), (List)Nil$.MODULE$)}));
        this.spark().sql(new StringBuilder(37).append("drop index idx_not_record_key_col on ").append(this.tableName()).toString());
        this.metaClient_$eq(HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient()));
        Predef$.MODULE$.assert(!this.metaClient().getTableConfig().getMetadataPartitions().contains("secondary_index_idx_not_record_key_col"));
        Predef$.MODULE$.assert(this.spark().sql(new StringBuilder(44).append("select * from hudi_metadata('").append(this.basePath()).append("') where type=7").toString()).count() == 0L);
    }

    @ParameterizedTest
    @MethodSource(value={"testSecondaryIndexPruningParameters"})
    public void testSecondaryIndexPruningWithUpdates(SecondaryIndexTestCase testCase) {
        String tableType = testCase.tableType();
        boolean isPartitioned = testCase.isPartitioned();
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")})));
        String sqlTableType = tableType.equals(HoodieTableType.COPY_ON_WRITE.name()) ? "cow" : "mor";
        this.tableName_$eq(new StringBuilder(41).append(this.tableName()).append("test_secondary_index_pruning_with_updates").append((Object)(isPartitioned ? "_partitioned" : "")).append(sqlTableType).toString());
        String partitionedByClause = isPartitioned ? "partitioned by(partition_key_col)" : "";
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(641).append("\n         |create table ").append(this.tableName()).append(" (\n         |  ts bigint,\n         |  record_key_col string,\n         |  not_record_key_col string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | ").append(partitionedByClause).append("\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(1, 'row1', 'abc', 'p1')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(2, 'row2', 'cde', 'p2')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(3, 'row3', 'def', 'p2')").toString());
        this.spark().sql(new StringBuilder(60).append("create index idx_not_record_key_col on ").append(this.tableName()).append(" (not_record_key_col)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        this.checkAnswer(new StringBuilder(46).append("select key from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new StringBuilder(8).append("abc").append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("cde").append("$").append("row2").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("def").append("$").append("row3").toString(), (List)Nil$.MODULE$)}));
        this.spark().sql("set hoodie.metadata.enable=true");
        this.spark().sql("set hoodie.enable.data.skipping=true");
        this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        this.checkAnswer(new StringBuilder(103).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(this.tableName()).append(" where not_record_key_col = 'abc'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "row1", "abc", "p1"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "not_record_key_col", this.verifyQueryPredicate$default$3());
        this.spark().sql(new StringBuilder(68).append("update ").append(this.tableName()).append(" set not_record_key_col = 'xyz' where record_key_col = 'row1'").toString());
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("cde").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("def").append("$").append("row3").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("xyz").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.checkAnswer(new StringBuilder(100).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(this.tableName()).append(" where record_key_col = 'row1'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "row1", "xyz", "p1"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "not_record_key_col", "abc");
    }

    @ParameterizedTest
    @MethodSource(value={"testSecondaryIndexPruningParameters"})
    public void testSecondaryIndexWithPartitionStatsIndex(SecondaryIndexTestCase testCase) {
        String tableType = testCase.tableType();
        boolean isPartitioned = testCase.isPartitioned();
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")})));
        String sqlTableType = tableType.equals(HoodieTableType.COPY_ON_WRITE.name()) ? "cow" : "mor";
        this.tableName_$eq(new StringBuilder(47).append(this.tableName()).append("test_secondary_index_with_partition_stats_index").append((Object)(isPartitioned ? "_partitioned" : "")).append(sqlTableType).toString());
        String partitionedByClause = isPartitioned ? "partitioned by(partition_key_col)" : "";
        String partitionStatsEnable = isPartitioned ? new StringOps(Predef$.MODULE$.augmentString("\n         |'hoodie.metadata.index.partition.stats.enable' = 'true',\n         |'hoodie.metadata.index.column.stats.enable' = 'true',\n        ")).stripMargin() : "";
        String columnsToIndex = isPartitioned ? "'hoodie.metadata.index.column.stats.column.list' = 'name'," : "";
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(714).append("\n         |create table ").append(this.tableName()).append(" (\n         |  ts bigint,\n         |  name string,\n         |  record_key_col string,\n         |  secondary_key_col string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  type = '").append(sqlTableType).append("',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  ").append(partitionStatsEnable).append("\n         |  ").append(columnsToIndex).append("\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | ").append(partitionedByClause).append("\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql(new StringBuilder(53).append("insert into ").append(this.tableName()).append(" values(1, 'gandhi', 'row1', 'abc', 'p1')").toString());
        this.spark().sql(new StringBuilder(52).append("insert into ").append(this.tableName()).append(" values(2, 'nehru', 'row2', 'cde', 'p2')").toString());
        this.spark().sql(new StringBuilder(52).append("insert into ").append(this.tableName()).append(" values(3, 'patel', 'row3', 'def', 'p2')").toString());
        this.spark().sql(new StringBuilder(58).append("create index idx_secondary_key_col on ").append(this.tableName()).append(" (secondary_key_col)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        Predef$.MODULE$.assert(this.metaClient().getTableConfig().getMetadataPartitions().contains("secondary_index_idx_secondary_key_col"));
        this.checkAnswer(new StringBuilder(46).append("select key from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new StringBuilder(8).append("abc").append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("cde").append("$").append("row2").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("def").append("$").append("row3").toString(), (List)Nil$.MODULE$)}));
        this.spark().sql("set hoodie.metadata.enable=true");
        this.spark().sql("set hoodie.enable.data.skipping=true");
        this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        this.checkAnswer(new StringBuilder(101).append("select ts, record_key_col, secondary_key_col, partition_key_col from ").append(this.tableName()).append(" where secondary_key_col = 'abc'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "row1", "abc", "p1"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "secondary_key_col", this.verifyQueryPredicate$default$3());
        this.spark().sql(new StringBuilder(28).append("create index idx_ts on ").append(this.tableName()).append(" (ts)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient()));
        Predef$.MODULE$.assert(this.metaClient().getTableConfig().getMetadataPartitions().contains("secondary_index_idx_ts"));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "ts", this.verifyQueryPredicate$default$3());
        this.checkAnswer(new StringBuilder(46).append("select key from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new StringBuilder(6).append("1").append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(6).append("2").append("$").append("row2").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(6).append("3").append("$").append("row3").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("abc").append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("cde").append("$").append("row2").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("def").append("$").append("row3").toString(), (List)Nil$.MODULE$)}));
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testSecondaryIndexWithConcurrentWrites(HoodieTableType tableType) {
        String tableName = new StringBuilder(24).append("hudi_multi_writer_table_").append(tableType.name()).toString();
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key()), (Object)WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.key()), (Object)HoodieFailedWritesCleaningPolicy.LAZY.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT.key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key()), (Object)InProcessLockProvider.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieLockConfig.WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS_NAME.key()), (Object)SimpleConcurrentFileWritesConflictResolutionStrategy.class.getName())})));
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(712).append("\n         |CREATE TABLE ").append(tableName).append(" (\n         |  ts BIGINT,\n         |  record_key_col STRING,\n         |  not_record_key_col STRING,\n         |  partition_key_col STRING\n         |) USING hudi\n         | OPTIONS (\n         |  primaryKey = 'record_key_col',\n         |  preCombineField = 'ts',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | PARTITIONED BY (partition_key_col)\n         | LOCATION '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(1, 'row1', 'abc', 'p1')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(2, 'row2', 'cde', 'p2')").toString());
        this.spark().sql(new StringBuilder(60).append("create index idx_not_record_key_col on ").append(tableName).append(" (not_record_key_col)").toString());
        ExecutorService executor = Executors.newFixedThreadPool(2);
        ExecutionContextExecutor executorContext = ExecutionContext$.MODULE$.fromExecutor((Executor)executor);
        Function1.mcZI.sp function = new Function1.mcZI.sp(this, hudiOpts){
            private final /* synthetic */ TestSecondaryIndexPruning $outer;
            private final scala.collection.immutable.Map hudiOpts$1;

            public boolean apply$mcZD$sp(double v1) {
                return Function1.apply$mcZD$sp$((Function1)this, (double)v1);
            }

            public double apply$mcDD$sp(double v1) {
                return Function1.apply$mcDD$sp$((Function1)this, (double)v1);
            }

            public float apply$mcFD$sp(double v1) {
                return Function1.apply$mcFD$sp$((Function1)this, (double)v1);
            }

            public int apply$mcID$sp(double v1) {
                return Function1.apply$mcID$sp$((Function1)this, (double)v1);
            }

            public long apply$mcJD$sp(double v1) {
                return Function1.apply$mcJD$sp$((Function1)this, (double)v1);
            }

            public void apply$mcVD$sp(double v1) {
                Function1.apply$mcVD$sp$((Function1)this, (double)v1);
            }

            public boolean apply$mcZF$sp(float v1) {
                return Function1.apply$mcZF$sp$((Function1)this, (float)v1);
            }

            public double apply$mcDF$sp(float v1) {
                return Function1.apply$mcDF$sp$((Function1)this, (float)v1);
            }

            public float apply$mcFF$sp(float v1) {
                return Function1.apply$mcFF$sp$((Function1)this, (float)v1);
            }

            public int apply$mcIF$sp(float v1) {
                return Function1.apply$mcIF$sp$((Function1)this, (float)v1);
            }

            public long apply$mcJF$sp(float v1) {
                return Function1.apply$mcJF$sp$((Function1)this, (float)v1);
            }

            public void apply$mcVF$sp(float v1) {
                Function1.apply$mcVF$sp$((Function1)this, (float)v1);
            }

            public double apply$mcDI$sp(int v1) {
                return Function1.apply$mcDI$sp$((Function1)this, (int)v1);
            }

            public float apply$mcFI$sp(int v1) {
                return Function1.apply$mcFI$sp$((Function1)this, (int)v1);
            }

            public int apply$mcII$sp(int v1) {
                return Function1.apply$mcII$sp$((Function1)this, (int)v1);
            }

            public long apply$mcJI$sp(int v1) {
                return Function1.apply$mcJI$sp$((Function1)this, (int)v1);
            }

            public void apply$mcVI$sp(int v1) {
                Function1.apply$mcVI$sp$((Function1)this, (int)v1);
            }

            public boolean apply$mcZJ$sp(long v1) {
                return Function1.apply$mcZJ$sp$((Function1)this, (long)v1);
            }

            public double apply$mcDJ$sp(long v1) {
                return Function1.apply$mcDJ$sp$((Function1)this, (long)v1);
            }

            public float apply$mcFJ$sp(long v1) {
                return Function1.apply$mcFJ$sp$((Function1)this, (long)v1);
            }

            public int apply$mcIJ$sp(long v1) {
                return Function1.apply$mcIJ$sp$((Function1)this, (long)v1);
            }

            public long apply$mcJJ$sp(long v1) {
                return Function1.apply$mcJJ$sp$((Function1)this, (long)v1);
            }

            public void apply$mcVJ$sp(long v1) {
                Function1.apply$mcVJ$sp$((Function1)this, (long)v1);
            }

            public <A> Function1<A, Object> compose(Function1<A, Object> g) {
                return Function1.compose$((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen(Function1<Object, A> g) {
                return Function1.andThen$((Function1)this, g);
            }

            public String toString() {
                return Function1.toString$((Function1)this);
            }

            public boolean apply(int writerId) {
                return this.apply$mcZI$sp(writerId);
            }

            public boolean apply$mcZI$sp(int writerId) {
                boolean bl;
                try {
                    Seq data = writerId == 1 ? (Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()), (Object)new StringBuilder(3).append("row").append(writerId).toString(), (Object)new StringBuilder(7).append("value").append(writerId).append("_1").toString(), (Object)new StringBuilder(1).append("p").append(writerId).toString()), (List)Nil$.MODULE$) : (Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()), (Object)new StringBuilder(3).append("row").append(writerId).toString(), (Object)new StringBuilder(7).append("value").append(writerId).append("_2").toString(), (Object)new StringBuilder(1).append("p").append(writerId).toString()), (List)Nil$.MODULE$);
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror($anon$1.class.getClassLoader());
                    public final class Org_apache_hudi_functional_TestSecondaryIndexPruning$$anon$1$$typecreator1$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)))));
                        }

                        public Org_apache_hudi_functional_TestSecondaryIndexPruning$$anon$1$$typecreator1$1($anon$1 $outer) {
                        }
                    }
                    Dataset df = this.$outer.spark().createDataFrame(data, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestSecondaryIndexPruning$$anon$1$$typecreator1$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ts", "record_key_col", "not_record_key_col", "partition_key_col"}));
                    df.write().format("hudi").options((Map)this.hudiOpts$1).mode("append").save(this.$outer.basePath());
                    bl = true;
                }
                catch (HoodieWriteConflictException hoodieWriteConflictException) {
                    bl = false;
                }
                catch (Throwable e) {
                    throw new Exception("Multi write failed", e);
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hudiOpts$1 = hudiOpts$1;
                Function1.$init$((Function1)this);
            }
        };
        Future f1 = Future$.MODULE$.apply((Function0)((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestSecondaryIndexPruning.$anonfun$testSecondaryIndexWithConcurrentWrites$1((Function1)function)), (ExecutionContext)executorContext);
        Future f2 = Future$.MODULE$.apply((Function0)((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestSecondaryIndexPruning.$anonfun$testSecondaryIndexWithConcurrentWrites$2((Function1)function)), (ExecutionContext)executorContext);
        Await$.MODULE$.result((Awaitable)f1, Duration$.MODULE$.apply("5 minutes"));
        Await$.MODULE$.result((Awaitable)f2, Duration$.MODULE$.apply("5 minutes"));
        Assertions.assertTrue((BoxesRunTime.unboxToBoolean((Object)((Try)f1.value().get()).get()) || BoxesRunTime.unboxToBoolean((Object)((Try)f2.value().get()).get()) ? 1 : 0) != 0);
        executor.shutdownNow();
        this.checkAnswer(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(119).append("\n         |SELECT key, SecondaryIndexMetadata.isDeleted\n         |FROM hudi_metadata('").append(this.basePath()).append("')\n         |WHERE type=7\n       ").toString())).stripMargin(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(13).append("value1_1").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(13).append("value2_2").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testSecondaryIndexWithCompactionAndCleaning(HoodieTableType tableType) {
        BoxedUnit boxedUnit;
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEANER_COMMITS_RETAINED.key()), (Object)"1")})));
        HoodieTableType hoodieTableType = tableType;
        HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
        if (!(hoodieTableType != null ? !hoodieTableType.equals(hoodieTableType2) : hoodieTableType2 != null)) {
            hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT.key()), (Object)"0")})));
        }
        HoodieTableType hoodieTableType3 = tableType;
        HoodieTableType hoodieTableType4 = HoodieTableType.COPY_ON_WRITE;
        String sqlTableType = !(hoodieTableType3 != null ? !hoodieTableType3.equals(hoodieTableType4) : hoodieTableType4 != null) ? "cow" : "mor";
        this.tableName_$eq(new StringBuilder(43).append(this.tableName()).append("test_secondary_index_pruning_compact_clean_").append(sqlTableType).toString());
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(774).append("\n         |create table ").append(this.tableName()).append(" (\n         |  ts bigint,\n         |  record_key_col string,\n         |  not_record_key_col string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  type = '").append(sqlTableType).append("',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.clean.policy = 'KEEP_LATEST_COMMITS',\n         |  ").append(HoodieCleanConfig.CLEANER_COMMITS_RETAINED.key()).append(" = '1',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        HoodieTableType hoodieTableType5 = tableType;
        HoodieTableType hoodieTableType6 = HoodieTableType.MERGE_ON_READ;
        if (!(hoodieTableType5 != null ? !hoodieTableType5.equals(hoodieTableType6) : hoodieTableType6 != null)) {
            this.spark().sql("set hoodie.compact.inline=true");
            this.spark().sql("set hoodie.compact.inline.max.delta.commits=2");
            boxedUnit = this.spark().sql("set hoodie.metadata.compact.num.delta.commits=15");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(1, 'row1', 'abc', 'p1')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(2, 'row2', 'cde', 'p2')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(3, 'row3', 'def', 'p2')").toString());
        this.spark().sql(new StringBuilder(60).append("create index idx_not_record_key_col on ").append(this.tableName()).append(" (not_record_key_col)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        this.checkAnswer(new StringBuilder(46).append("select key from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new StringBuilder(8).append("abc").append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("cde").append("$").append("row2").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("def").append("$").append("row3").toString(), (List)Nil$.MODULE$)}));
        this.spark().sql("set hoodie.metadata.enable=true");
        this.spark().sql("set hoodie.enable.data.skipping=true");
        this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        this.checkAnswer(new StringBuilder(103).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(this.tableName()).append(" where not_record_key_col = 'abc'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "row1", "abc", "p1"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "not_record_key_col", this.verifyQueryPredicate$default$3());
        this.spark().sql(new StringBuilder(68).append("update ").append(this.tableName()).append(" set not_record_key_col = 'xyz' where record_key_col = 'row1'").toString());
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("cde").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("def").append("$").append("row3").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("xyz").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.checkAnswer(new StringBuilder(100).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(this.tableName()).append(" where record_key_col = 'row1'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "row1", "xyz", "p1"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "not_record_key_col", "abc");
    }

    @Test
    public void testSecondaryIndexWithMDTCompaction() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"2")})));
        String tableName = "test_secondary_index_with_mdt_compaction";
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(777).append("\n         |create table ").append(tableName).append(" (\n         |  ts bigint,\n         |  record_key_col string,\n         |  not_record_key_col string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  type = 'mor',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.clean.policy = 'KEEP_LATEST_COMMITS',\n         |  ").append(HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()).append(" = '2',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(1, 'row1', 'abc', 'p1')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(2, 'row2', 'cde', 'p2')").toString());
        this.spark().sql(new StringBuilder(60).append("create index idx_not_record_key_col on ").append(tableName).append(" (not_record_key_col)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(3, 'row3', 'def', 'p2')").toString());
        try (HoodieTableFileSystemView metadataTableFSView = ((HoodieBackedTableMetadata)HoodieSparkTable.create((HoodieWriteConfig)this.getWriteConfig((scala.collection.immutable.Map<String, String>)hudiOpts), (HoodieEngineContext)this.context()).getMetadataTable()).getMetadataFileSystemView();){
            HoodieTimeline compactionTimeline = metadataTableFSView.getVisibleCommitsAndCompactionTimeline().filterCompletedAndCompactionInstants();
            Option lastCompactionInstant = compactionTimeline.filter(JavaConversions$.MODULE$.getPredicate((Function1 & Serializable & scala.Serializable)instant -> BoxesRunTime.boxToBoolean((boolean)TestSecondaryIndexPruning.$anonfun$testSecondaryIndexWithMDTCompaction$1(this, compactionTimeline, instant)))).lastInstant();
            Optional compactionBaseFile = metadataTableFSView.getAllBaseFiles("secondary_index_idx_not_record_key_col").filter(JavaConversions$.MODULE$.getPredicate((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)TestSecondaryIndexPruning.$anonfun$testSecondaryIndexWithMDTCompaction$2(lastCompactionInstant, f)))).findAny();
            Assertions.assertTrue((boolean)compactionBaseFile.isPresent());
        }
        this.checkAnswer(new StringBuilder(46).append("select key from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new StringBuilder(8).append("abc").append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("cde").append("$").append("row2").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("def").append("$").append("row3").toString(), (List)Nil$.MODULE$)}));
        this.spark().sql("set hoodie.metadata.enable=true");
        this.spark().sql("set hoodie.enable.data.skipping=true");
        this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        this.checkAnswer(new StringBuilder(103).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(tableName).append(" where not_record_key_col = 'abc'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "row1", "abc", "p1"}))}));
    }

    @Test
    public void testSecondaryIndexWithEventTimeOrderingMerge() {
        String tableName = "test_secondary_index_with_event_time_ordering_merge";
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(623).append("\n         |CREATE TABLE ").append(tableName).append(" (\n         |  ts BIGINT,\n         |  record_key_col STRING,\n         |  not_record_key_col STRING,\n         |  partition_key_col STRING\n         |) USING hudi\n         | OPTIONS (\n         |  primaryKey = 'record_key_col',\n         |  type = 'mor',\n         |  preCombineField = 'ts',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true'\n         | )\n         | PARTITIONED BY (partition_key_col)\n         | LOCATION '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(1, 'row1', 'abc', 'p1')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(2, 'row2', 'cde', 'p2')").toString());
        this.spark().sql(new StringBuilder(60).append("create index idx_not_record_key_col on ").append(tableName).append(" (not_record_key_col)").toString());
        this.spark().sql(new StringBuilder(76).append("update ").append(tableName).append(" set not_record_key_col = 'xyz', ts = 3 where record_key_col = 'row1'").toString());
        this.checkAnswer(new StringBuilder(100).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(tableName).append(" where record_key_col = 'row1'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "row1", "xyz", "p1"}))}));
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("cde").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("xyz").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.spark().sql(new StringBuilder(76).append("update ").append(tableName).append(" set not_record_key_col = 'abc', ts = 4 where record_key_col = 'row1'").toString());
        this.checkAnswer(new StringBuilder(100).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(tableName).append(" where record_key_col = 'row1'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "row1", "abc", "p1"}))}));
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("cde").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("abc").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.spark().sql(new StringBuilder(76).append("update ").append(tableName).append(" set not_record_key_col = 'xyz', ts = 0 where record_key_col = 'row1'").toString());
        this.checkAnswer(new StringBuilder(100).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(tableName).append(" where record_key_col = 'row1'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "row1", "abc", "p1"}))}));
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("cde").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("abc").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
    }

    @Test
    public void testSecondaryIndexWithCustomMergeMode() {
        String tableName = "test_secondary_index_with_custom_merge";
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(988).append("\n         |CREATE TABLE ").append(tableName).append(" (\n         |  record_key_col BIGINT,\n         |  Op STRING,\n         |  replicadmstimestamp STRING,\n         |  not_record_key_col STRING\n         |) USING hudi\n         | OPTIONS (\n         |  primaryKey = 'record_key_col',\n         |  type = 'mor',\n         |  preCombineField = 'replicadmstimestamp',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.datasource.write.payload.class = 'org.apache.hudi.common.model.AWSDmsAvroPayload',\n         |  hoodie.datasource.write.keygenerator.class = 'org.apache.hudi.keygen.NonpartitionedKeyGenerator',\n         |  hoodie.write.record.merge.mode = 'CUSTOM',\n         |  hoodie.table.cdc.enabled = 'true',\n         |  hoodie.table.cdc.supplemental.logging.mode = 'data_before_after'\n         | )\n         | LOCATION '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? this.spark().sql("set spark.sql.defaultColumn.enabled=false") : BoxedUnit.UNIT;
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(277).append("|INSERT INTO ").append(tableName).append("(record_key_col, Op, replicadmstimestamp, not_record_key_col) VALUES\n          |    (1, 'I', '2023-06-14 15:46:06.953746', 'A'),\n          |    (2, 'I', '2023-06-14 15:46:07.953746', 'B'),\n          |    (3, 'I', '2023-06-14 15:46:08.953746', 'C');\n          |    ").toString())).stripMargin());
        this.spark().sql(new StringBuilder(60).append("create index idx_not_record_key_col on ").append(tableName).append(" (not_record_key_col)").toString());
        this.checkAnswer(new StringBuilder(72).append("select record_key_col, Op, replicadmstimestamp, not_record_key_col from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "I", "2023-06-14 15:46:06.953746", "A"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "I", "2023-06-14 15:46:07.953746", "B"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "I", "2023-06-14 15:46:08.953746", "C"}))}));
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(3).append("A").append("$").append("1").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(3).append("B").append("$").append("2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(3).append("C").append("$").append("3").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.spark().sql(new StringBuilder(45).append("update ").append(tableName).append(" set Op = 'D' where record_key_col = 3").toString());
        this.checkAnswer(new StringBuilder(72).append("select record_key_col, Op, replicadmstimestamp, not_record_key_col from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "I", "2023-06-14 15:46:06.953746", "A"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "I", "2023-06-14 15:46:07.953746", "B"}))}));
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(3).append("A").append("$").append("1").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(3).append("B").append("$").append("2").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
    }

    @Test
    public void testSecondaryIndexWithMultipleUpdatesForSameRecord() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"20")})));
        String tableName = "test_secondary_index_with_multiple_updates_same_record";
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(778).append("\n         |create table ").append(tableName).append(" (\n         |  ts bigint,\n         |  record_key_col string,\n         |  not_record_key_col string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  type = 'mor',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.clean.policy = 'KEEP_LATEST_COMMITS',\n         |  ").append(HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()).append(" = '20',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(1, 'row1', 'abc', 'p1')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(2, 'row2', 'abc', 'p2')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(3, 'row3', 'hjk', 'p2')").toString());
        this.spark().sql(new StringBuilder(60).append("create index idx_not_record_key_col on ").append(tableName).append(" (not_record_key_col)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("abc").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("abc").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("hjk").append("$").append("row3").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.spark().sql(new StringBuilder(68).append("update ").append(tableName).append(" set not_record_key_col = 'xyz' where record_key_col = 'row3'").toString());
        this.spark().sql(new StringBuilder(69).append("update ").append(tableName).append(" set not_record_key_col = 'xyz1' where record_key_col = 'row3'").toString());
        this.spark().sql(new StringBuilder(68).append("update ").append(tableName).append(" set not_record_key_col = 'xyz' where record_key_col = 'row3'").toString());
        this.spark().sql(new StringBuilder(69).append("update ").append(tableName).append(" set not_record_key_col = 'xyz2' where record_key_col = 'row3'").toString());
        this.spark().sql("set hoodie.metadata.enable=true");
        this.spark().sql("set hoodie.enable.data.skipping=true");
        this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        this.checkAnswer(new StringBuilder(113).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(tableName).append(" where not_record_key_col in ('xyz','xyz1')").toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
        this.checkAnswer(new StringBuilder(113).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(tableName).append(" where not_record_key_col in ('xyz','xyz2')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "row3", "xyz2", "p2"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "not_record_key_col", "xyz2");
    }

    @Test
    public void testSecondaryIndexWithOnlyDeleteLogs() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"20")})));
        String tableName = "test_secondary_index_with_only_delete";
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(778).append("\n         |create table ").append(tableName).append(" (\n         |  ts bigint,\n         |  record_key_col string,\n         |  not_record_key_col string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  type = 'mor',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.clean.policy = 'KEEP_LATEST_COMMITS',\n         |  ").append(HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()).append(" = '20',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(1, 'row1', 'abc', 'p1')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(2, 'row2', 'abc', 'p1')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(3, 'row3', 'hjk', 'p1')").toString());
        this.spark().sql(new StringBuilder(60).append("create index idx_not_record_key_col on ").append(tableName).append(" (not_record_key_col)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("abc").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("abc").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("hjk").append("$").append("row3").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.spark().sql(new StringBuilder(42).append("delete from ").append(tableName).append(" where record_key_col = 'row2'").toString());
        this.spark().sql("set hoodie.metadata.enable=true");
        this.spark().sql("set hoodie.enable.data.skipping=true");
        this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        this.checkAnswer(new StringBuilder(106).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(tableName).append(" where not_record_key_col in ('abc')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "row1", "abc", "p1"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "not_record_key_col", "abc");
    }

    @Test
    public void testSecondaryIndexWithUpdateFollowedByDelete() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"20")})));
        String tableName = "test_secondary_index_with_update_and_delete";
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(778).append("\n         |create table ").append(tableName).append(" (\n         |  ts bigint,\n         |  record_key_col string,\n         |  not_record_key_col string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  type = 'mor',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.clean.policy = 'KEEP_LATEST_COMMITS',\n         |  ").append(HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()).append(" = '20',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(1, 'row1', 'abc', 'p1')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(2, 'row2', 'def', 'p1')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(3, 'row3', 'hjk', 'p1')").toString());
        this.spark().sql(new StringBuilder(60).append("create index idx_not_record_key_col on ").append(tableName).append(" (not_record_key_col)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("abc").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("def").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("hjk").append("$").append("row3").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.spark().sql(new StringBuilder(68).append("update ").append(tableName).append(" set not_record_key_col = 'xyz' where record_key_col = 'row3'").toString());
        this.spark().sql(new StringBuilder(69).append("update ").append(tableName).append(" set not_record_key_col = 'xyz1' where record_key_col = 'row3'").toString());
        this.spark().sql(new StringBuilder(68).append("update ").append(tableName).append(" set not_record_key_col = 'xyz' where record_key_col = 'row2'").toString());
        this.spark().sql(new StringBuilder(42).append("delete from ").append(tableName).append(" where record_key_col = 'row2'").toString());
        this.spark().sql("set hoodie.metadata.enable=true");
        this.spark().sql("set hoodie.enable.data.skipping=true");
        this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        this.checkAnswer(new StringBuilder(113).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(tableName).append(" where not_record_key_col in ('xyz','xyz1')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "row3", "xyz1", "p1"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "not_record_key_col", "xyz1");
        this.checkAnswer(new StringBuilder(131).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(tableName).append(" where not_record_key_col in ('abc','def','hjk','xyz','xyz1')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "row1", "abc", "p1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "row3", "xyz1", "p1"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "not_record_key_col", this.verifyQueryPredicate$default$3());
    }

    @Test
    public void testSecondaryIndexWithSameSecondaryKeyUpdatesForMultipleRecords() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"20")})));
        String tableName = "test_secondary_index_with_same_sec_key";
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(778).append("\n         |create table ").append(tableName).append(" (\n         |  ts bigint,\n         |  record_key_col string,\n         |  not_record_key_col string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  type = 'mor',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.clean.policy = 'KEEP_LATEST_COMMITS',\n         |  ").append(HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()).append(" = '20',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(1, 'row1', 'abc', 'p1')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(2, 'row2', 'abc', 'p2')").toString());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(3, 'row3', 'hjk', 'p2')").toString());
        this.spark().sql(new StringBuilder(60).append("create index idx_not_record_key_col on ").append(tableName).append(" (not_record_key_col)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        Predef$.MODULE$.assert(this.metaClient().getTableConfig().getMetadataPartitions().contains("secondary_index_idx_not_record_key_col"));
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("abc").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("abc").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("hjk").append("$").append("row3").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.spark().sql(new StringBuilder(68).append("update ").append(tableName).append(" set not_record_key_col = 'def' where record_key_col = 'row1'").toString());
        this.spark().sql(new StringBuilder(68).append("update ").append(tableName).append(" set not_record_key_col = 'abc' where record_key_col = 'row3'").toString());
        this.spark().sql(new StringBuilder(68).append("update ").append(tableName).append(" set not_record_key_col = 'poc' where record_key_col = 'row2'").toString());
        this.spark().sql("set hoodie.metadata.enable=true");
        this.spark().sql("set hoodie.enable.data.skipping=true");
        this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        this.checkAnswer(new StringBuilder(106).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(tableName).append(" where not_record_key_col in ('abc')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "row3", "abc", "p2"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "not_record_key_col", "abc");
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testSecondaryIndexWithClusteringAndCleaning(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEANER_COMMITS_RETAINED.key()), (Object)"1")})));
        HoodieTableType hoodieTableType = tableType;
        HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
        if (!(hoodieTableType != null ? !hoodieTableType.equals(hoodieTableType2) : hoodieTableType2 != null)) {
            hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.INLINE_CLUSTERING.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS.key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT.key()), (Object)"0")})));
        }
        HoodieTableType hoodieTableType3 = tableType;
        HoodieTableType hoodieTableType4 = HoodieTableType.COPY_ON_WRITE;
        String sqlTableType = !(hoodieTableType3 != null ? !hoodieTableType3.equals(hoodieTableType4) : hoodieTableType4 != null) ? "cow" : "mor";
        this.tableName_$eq(new StringBuilder(43).append(this.tableName()).append("test_secondary_index_pruning_cluster_clean_").append(sqlTableType).toString());
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(774).append("\n         |create table ").append(this.tableName()).append(" (\n         |  ts bigint,\n         |  record_key_col string,\n         |  not_record_key_col string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  type = '").append(sqlTableType).append("',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.clean.policy = 'KEEP_LATEST_COMMITS',\n         |  ").append(HoodieCleanConfig.CLEANER_COMMITS_RETAINED.key()).append(" = '1',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql("set hoodie.clustering.inline=true");
        this.spark().sql("set hoodie.clustering.inline.max.commits=1");
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(1, 'row1', 'abc', 'p1')").toString());
        this.confirmLastCommitType(ActionType.replacecommit);
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(2, 'row2', 'cde', 'p2')").toString());
        this.confirmLastCommitType(ActionType.replacecommit);
        this.spark().sql(new StringBuilder(43).append("insert into ").append(this.tableName()).append(" values(3, 'row3', 'def', 'p2')").toString());
        this.confirmLastCommitType(ActionType.replacecommit);
        this.spark().sql(new StringBuilder(60).append("create index idx_not_record_key_col on ").append(this.tableName()).append(" (not_record_key_col)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient()));
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("abc").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("cde").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("def").append("$").append("row3").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.spark().sql("set hoodie.metadata.enable=true");
        this.spark().sql("set hoodie.enable.data.skipping=true");
        this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        this.checkAnswer(new StringBuilder(103).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(this.tableName()).append(" where not_record_key_col = 'abc'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "row1", "abc", "p1"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "not_record_key_col", this.verifyQueryPredicate$default$3());
        this.spark().sql(new StringBuilder(68).append("update ").append(this.tableName()).append(" set not_record_key_col = 'xyz' where record_key_col = 'row1'").toString());
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("cde").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("def").append("$").append("row3").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("xyz").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.checkAnswer(new StringBuilder(100).append("select ts, record_key_col, not_record_key_col, partition_key_col from ").append(this.tableName()).append(" where record_key_col = 'row1'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "row1", "xyz", "p1"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "not_record_key_col", this.verifyQueryPredicate$default$3());
        this.spark().sql(new StringBuilder(68).append("update ").append(this.tableName()).append(" set not_record_key_col = 'efg' where record_key_col = 'row2'").toString());
        this.confirmLastCommitType(ActionType.replacecommit);
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("def").append("$").append("row3").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("efg").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("xyz").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.spark().sql(new StringBuilder(68).append("update ").append(this.tableName()).append(" set not_record_key_col = 'fgh' where record_key_col = 'row2'").toString());
        this.confirmLastCommitType(ActionType.replacecommit);
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("def").append("$").append("row3").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("fgh").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("xyz").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.spark().sql(new StringBuilder(42).append("delete from ").append(this.tableName()).append(" where record_key_col = 'row3'").toString());
        this.confirmLastCommitType(ActionType.replacecommit);
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("fgh").append("$").append("row2").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("xyz").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
    }

    private void confirmLastCommitType(ActionType actionType) {
        this.metaClient_$eq(HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient()));
        java.util.List instants = this.metaClient().getActiveTimeline().getInstants();
        Assertions.assertFalse((boolean)instants.isEmpty());
        Assertions.assertTrue((boolean)((HoodieInstant)instants.get(instants.size() - 1)).getAction().equals(actionType.name()));
    }

    @Test
    public void testSecondaryIndexWithSavepointAndRestore() {
        String tableName = "test_secondary_index_with_savepoint_and_restore";
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")})));
        String sqlTableType = "mor";
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(697).append("\n         |create table ").append(tableName).append(" (\n         |  ts bigint,\n         |  record_key_col string,\n         |  not_record_key_col string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  type = '").append(sqlTableType).append("',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values(1, 'row1', 'abc', 'p1')").toString());
        this.spark().sql(new StringBuilder(60).append("create index idx_not_record_key_col on ").append(tableName).append(" (not_record_key_col)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        this.checkAnswer(new StringBuilder(46).append("select key from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new StringBuilder(8).append("abc").append("$").append("row1").toString(), (List)Nil$.MODULE$)}));
        Option firstCompletedInstant = this.metaClient().getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant();
        SparkRDDWriteClient writeClient = new SparkRDDWriteClient((HoodieEngineContext)new HoodieSparkEngineContext(this.jsc()), this.getWriteConfig((scala.collection.immutable.Map<String, String>)hudiOpts));
        writeClient.savepoint(((HoodieInstant)firstCompletedInstant.get()).requestedTime(), "testUser", "savepoint to first commit");
        String savepointTimestamp = ((HoodieInstant)this.metaClient().reloadActiveTimeline().getSavePointTimeline().filterCompletedInstants().lastInstant().get()).requestedTime();
        Assertions.assertEquals((Object)((HoodieInstant)firstCompletedInstant.get()).requestedTime(), (Object)savepointTimestamp);
        writeClient.restoreToSavepoint(savepointTimestamp);
        Assertions.assertTrue((boolean)this.metaClient().reloadActiveTimeline().getRestoreTimeline().lastInstant().isPresent());
        this.metaClient_$eq(HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient()));
        Assertions.assertFalse((boolean)this.metaClient().getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.PARTITION_STATS.getPartitionPath()));
        Assertions.assertTrue((this.metaClient().getIndexMetadata().isPresent() && ((HoodieIndexDefinition)((HoodieIndexMetadata)this.metaClient().getIndexMetadata().get()).getIndexDefinitions().get("secondary_index_idx_not_record_key_col")).getIndexType().equals("secondary_index") ? 1 : 0) != 0);
        this.spark().sql(new StringBuilder(68).append("update ").append(tableName).append(" set not_record_key_col = 'xyz' where record_key_col = 'row1'").toString());
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("xyz").append("$").append("row1").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testUpdatesReInsertsDeletes(HoodieTableType hoodieTableType) {
        String tableType = hoodieTableType.name();
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")})));
        String sqlTableType = tableType.equals(HoodieTableType.COPY_ON_WRITE.name()) ? "cow" : "mor";
        String tableName = new StringBuilder(31).append("test_updates_reinserts_deletes_").append(sqlTableType).toString();
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(738).append("\n         |CREATE TABLE ").append(tableName).append(" (\n         |    ts BIGINT,\n         |    id STRING,\n         |    rider STRING,\n         |    driver STRING,\n         |    fare DOUBLE,\n         |    city STRING,\n         |    state STRING\n         |) USING HUDI\n         | options(\n         |    primaryKey ='id',\n         |    type = '").append(sqlTableType).append("',\n         |    hoodie.metadata.enable = 'true',\n         |    hoodie.metadata.record.index.enable = 'true',\n         |    hoodie.datasource.write.recordkey.field = 'id',\n         |    hoodie.enable.data.skipping = 'true',\n         |    hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | PARTITIONED BY (city, state)\n         | location '").append(this.basePath()).append("'\n         |").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql("set hoodie.enable.data.skipping=true");
        this.spark().sql("set hoodie.metadata.enable=true");
        Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? this.spark().sql("set spark.sql.defaultColumn.enabled=false") : BoxedUnit.UNIT;
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(423).append("|INSERT INTO ").append(tableName).append("(ts, id, rider, driver, fare, city, state) VALUES\n          |    (1695159649,'trip1','rider-A','driver-K',19.10,'san_francisco','california'),\n          |    (1695091554,'trip2','rider-C','driver-M',27.70,'sunnyvale','california'),\n          |    (1695332066,'trip3','rider-E','driver-O',93.50,'austin','texas'),\n          |    (1695516137,'trip4','rider-F','driver-P',34.15,'houston','texas');\n          |    ").toString())).stripMargin());
        this.checkAnswer(new StringBuilder(54).append("select ts, id, rider, driver, fare, city, state from ").append(tableName).append(";").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1695159649), "trip1", "rider-A", "driver-K", BoxesRunTime.boxToDouble((double)19.1), "san_francisco", "california"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1695091554), "trip2", "rider-C", "driver-M", BoxesRunTime.boxToDouble((double)27.7), "sunnyvale", "california"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1695332066), "trip3", "rider-E", "driver-O", BoxesRunTime.boxToDouble((double)93.5), "austin", "texas"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1695516137), "trip4", "rider-F", "driver-P", BoxesRunTime.boxToDouble((double)34.15), "houston", "texas"}))}));
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        this.spark().sql(new StringBuilder(35).append("create index idx_rider_").append(tableName).append(" ON ").append(tableName).append(" (rider)").toString());
        this.checkAnswer(new StringBuilder(77).append("select ts, id, rider, driver, fare, city, state from ").append(tableName).append(" where rider = 'rider-E'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1695332066), "trip3", "rider-E", "driver-O", BoxesRunTime.boxToDouble((double)93.5), "austin", "texas"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "rider", this.verifyQueryPredicate$default$3());
        this.spark().sql(new StringBuilder(37).append("create index idx_driver_").append(tableName).append(" ON ").append(tableName).append(" (driver)").toString());
        this.checkAnswer(new StringBuilder(79).append("select ts, id, rider, driver, fare, city, state from ").append(tableName).append(" where driver = 'driver-P'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1695516137), "trip4", "rider-F", "driver-P", BoxesRunTime.boxToDouble((double)34.15), "houston", "texas"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "driver", this.verifyQueryPredicate$default$3());
        this.spark().sql(new StringBuilder(53).append("update ").append(tableName).append(" set rider = 'rider-E' where rider = 'rider-F'").toString());
        this.checkAnswer(new StringBuilder(77).append("select ts, id, rider, driver, fare, city, state from ").append(tableName).append(" where rider = 'rider-E'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1695332066), "trip3", "rider-E", "driver-O", BoxesRunTime.boxToDouble((double)93.5), "austin", "texas"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1695516137), "trip4", "rider-E", "driver-P", BoxesRunTime.boxToDouble((double)34.15), "houston", "texas"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "rider", this.verifyQueryPredicate$default$3());
        this.spark().sql(new StringBuilder(31).append("delete from ").append(tableName).append(" where id = 'trip4'").toString());
        this.checkAnswer(new StringBuilder(77).append("select ts, id, rider, driver, fare, city, state from ").append(tableName).append(" where rider = 'rider-E'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1695332066), "trip3", "rider-E", "driver-O", BoxesRunTime.boxToDouble((double)93.5), "austin", "texas"}))}));
        this.spark().sql(new StringBuilder(84).append("insert into ").append(tableName).append(" values(1695516137,'trip4','rider-G','driver-Q',34.15,'houston','texas')").toString());
        this.checkAnswer(new StringBuilder(80).append("select ts, id, rider, driver, fare, city, state from ").append(tableName).append(" where driver = 'driver-Q';").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1695516137), "trip4", "rider-G", "driver-Q", BoxesRunTime.boxToDouble((double)34.15), "houston", "texas"}))}));
        this.spark().sql(new StringBuilder(67).append("update ").append(tableName).append(" set rider = 'rider-E' where rider in ('rider-C','rider-G');").toString());
        this.checkAnswer(new StringBuilder(77).append("select ts, id, rider, driver, fare, city, state from ").append(tableName).append(" where rider = 'rider-E'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1695091554), "trip2", "rider-E", "driver-M", BoxesRunTime.boxToDouble((double)27.7), "sunnyvale", "california"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1695332066), "trip3", "rider-E", "driver-O", BoxesRunTime.boxToDouble((double)93.5), "austin", "texas"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1695516137), "trip4", "rider-E", "driver-Q", BoxesRunTime.boxToDouble((double)34.15), "houston", "texas"}))}));
        this.checkAnswer(new StringBuilder(79).append("select ts, id, rider, driver, fare, city, state from ").append(tableName).append(" where driver = 'driver-Q'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1695516137), "trip4", "rider-E", "driver-Q", BoxesRunTime.boxToDouble((double)34.15), "houston", "texas"}))}));
        this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)hudiOpts, "rider", this.verifyQueryPredicate$default$3());
    }

    @Test
    public void testSecondaryIndexWithPrimitiveDataTypes() {
        ObjectRef hudiOpts = ObjectRef.create(this.commonOpts());
        hudiOpts.elem = ((scala.collection.immutable.Map)hudiOpts.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key()), (Object)"false")})));
        this.tableName_$eq(new StringBuilder(46).append(this.tableName()).append("test_secondary_index_with_primitive_data_types").toString());
        this.spark().sql("set hoodie.metadata.index.partition.stats.enable=false");
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(862).append("\n         |create table ").append(this.tableName()).append(" (\n         |  ts bigint,\n         |  record_key_col string,\n         |  string_col string,\n         |  int_col int,\n         |  bigint_col bigint,\n         |  double_col double,\n         |  decimal_col decimal(10,2),\n         |  timestamp_col timestamp,\n         |  boolean_col boolean,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql(new StringBuilder(105).append("insert into ").append(this.tableName()).append(" values(1, 'row1', 'abc', 10, 100, 1.1, 100.01, timestamp('2023-01-01 12:00:00'), true, 'p1')").toString());
        this.spark().sql(new StringBuilder(106).append("insert into ").append(this.tableName()).append(" values(2, 'row2', 'def', 20, 200, 2.2, 200.02, timestamp('2023-01-02 12:00:00'), false, 'p1')").toString());
        Seq secondaryIndexColumns = (Seq)new .colon.colon((Object)"string_col", (List)new .colon.colon((Object)"int_col", (List)new .colon.colon((Object)"bigint_col", (List)new .colon.colon((Object)"double_col", (List)new .colon.colon((Object)"decimal_col", (List)new .colon.colon((Object)"timestamp_col", (List)new .colon.colon((Object)"boolean_col", (List)Nil$.MODULE$)))))));
        secondaryIndexColumns.foreach((Function1 & Serializable & scala.Serializable)col -> this.spark().sql(new StringBuilder(24).append("create index idx_").append((String)col).append(" on ").append(this.tableName()).append(" (").append((String)col).append(")").toString()));
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        secondaryIndexColumns.foreach((Function1 & Serializable & scala.Serializable)col -> {
            Predef$.MODULE$.assert(this.metaClient().getTableConfig().getMetadataPartitions().contains(new StringBuilder(20).append("secondary_index_idx_").append(col).toString()));
            return BoxedUnit.UNIT;
        });
        long timestampCol = ((Timestamp)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().sql(new StringBuilder(56).append("select timestamp_col from ").append(this.tableName()).append(" where record_key_col = 'row1'").toString()).collect())).head()).getAs(0)).getTime() * 1000L;
        this.checkAnswer(new StringBuilder(68).append("select key from hudi_metadata('").append(this.basePath()).append("') where type=7 AND key LIKE '%").append("$").append("row1'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new StringBuilder(8).append("abc").append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("1.1").append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(7).append("10").append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("100").append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(11).append("100.01").append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(5).append(timestampCol).append("$").append("row1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(9).append("true").append("$").append("row1").toString(), (List)Nil$.MODULE$)}));
        this.spark().sql("set hoodie.metadata.enable=true");
        this.spark().sql("set hoodie.enable.data.skipping=true");
        this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        secondaryIndexColumns.foreach((Function1 & Serializable & scala.Serializable)col -> {
            TestSecondaryIndexPruning.$anonfun$testSecondaryIndexWithPrimitiveDataTypes$3(this, hudiOpts, col);
            return BoxedUnit.UNIT;
        });
        this.spark().sessionState().conf().unsetConf("unset hoodie.metadata.index.partition.stats.enable");
    }

    @Test
    public void testSecondaryIndexWithComplexTypes() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")})));
        this.tableName_$eq(new StringBuilder(44).append(this.tableName()).append("test_secondary_index_with_complex_data_types").toString());
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(742).append("\n         |create table ").append(this.tableName()).append(" (\n         |  record_key_col string,\n         |  array_col array<int>,\n         |  map_col map<string, int>,\n         |  struct_col struct<field1:int, field2:string>,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql("set hoodie.parquet.small.file.limit=0");
        this.spark().sql(new StringBuilder(126).append("insert into ").append(this.tableName()).append(" values ('row1', array(1, 2, 3), map('key1', 10, 'key2', 20), named_struct('field1', 1, 'field2', 'value1'), 'p1')").toString());
        this.spark().sql(new StringBuilder(126).append("insert into ").append(this.tableName()).append(" values ('row2', array(4, 5, 6), map('key1', 30, 'key2', 40), named_struct('field1', 2, 'field2', 'value2'), 'p2')").toString());
        Seq secondaryIndexColumns = (Seq)new .colon.colon((Object)"struct_col", (List)new .colon.colon((Object)"array_col", (List)new .colon.colon((Object)"map_col", (List)Nil$.MODULE$)));
        secondaryIndexColumns.foreach((Function1 & Serializable & scala.Serializable)col -> Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(24).append("create index idx_").append((String)col).append(" on ").append(this.tableName()).append(" (").append((String)col).append(")").toString()), ClassTag$.MODULE$.apply(HoodieMetadataIndexException.class), new Position("TestSecondaryIndexPruning.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1575)));
    }

    @Test
    public void testSecondaryIndexWithNestedFields() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")})));
        this.tableName_$eq(new StringBuilder(39).append(this.tableName()).append("test_secondary_index_with_nested_fields").toString());
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(613).append("\n         |create table ").append(this.tableName()).append(" (\n         |  record_key_col string,\n         |  name struct<first_name:string, last_name:string>,\n         |  ts bigint\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | location '").append(this.basePath()).append("'\n      ").toString())).stripMargin());
        this.spark().sql(new StringBuilder(85).append("insert into ").append(this.tableName()).append(" values('id1', named_struct('first_name', 'John', 'last_name', 'Doe'), 1)").toString());
        this.spark().sql(new StringBuilder(87).append("insert into ").append(this.tableName()).append(" values('id2', named_struct('first_name', 'Jane', 'last_name', 'Smith'), 2)").toString());
        this.spark().sql(new StringBuilder(47).append("create index idx_last_name on ").append(this.tableName()).append(" (name.last_name)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        Predef$.MODULE$.assert(this.metaClient().getTableConfig().getMetadataPartitions().contains("secondary_index_idx_last_name"));
        this.checkAnswer(new StringBuilder(46).append("select key from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new StringBuilder(7).append("Doe").append("$").append("id1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(9).append("Smith").append("$").append("id2").toString(), (List)Nil$.MODULE$)}));
        this.checkAnswer(new StringBuilder(76).append("select record_key_col, name.last_name, ts from ").append(this.tableName()).append(" where name.last_name = 'Doe'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id1", "Doe", BoxesRunTime.boxToInteger((int)1)}))}));
        this.spark().sql(new StringBuilder(104).append("update ").append(this.tableName()).append(" set name = named_struct('first_name', 'John', 'last_name', 'Brown') where record_key_col = 'id1'").toString());
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(9).append("Brown").append("$").append("id1").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(9).append("Smith").append("$").append("id2").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.checkAnswer(new StringBuilder(78).append("select record_key_col, name.last_name, ts from ").append(this.tableName()).append(" where name.last_name = 'Brown'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id1", "Brown", BoxesRunTime.boxToInteger((int)1)}))}));
    }

    @Test
    public void testSecondaryIndexWithPartiallyFailedCommit() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")})));
        this.tableName_$eq(new StringBuilder(49).append(this.tableName()).append("test_secondary_index_with_partially_failed_commit").toString());
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(684).append("\n         |create table ").append(this.tableName()).append(" (\n         |  record_key_col string,\n         |  name string,\n         |  age int,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='record_key_col',\n         |  type = 'mor',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'record_key_col',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(this.basePath()).append("'\n       ").toString())).stripMargin());
        this.spark().sql(new StringBuilder(44).append("insert into ").append(this.tableName()).append(" values('id1', 'John', 30, 'p1')").toString());
        this.spark().sql(new StringBuilder(44).append("insert into ").append(this.tableName()).append(" values('id2', 'Jane', 25, 'p2')").toString());
        this.spark().sql(new StringBuilder(32).append("create index idx_name on ").append(this.tableName()).append(" (name)").toString());
        this.metaClient_$eq(HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf(HoodieTestUtils.getDefaultStorageConf()).build());
        Predef$.MODULE$.assert(this.metaClient().getTableConfig().getMetadataPartitions().contains("secondary_index_idx_name"));
        this.checkAnswer(new StringBuilder(46).append("select key from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new StringBuilder(8).append("John").append("$").append("id1").toString(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringBuilder(8).append("Jane").append("$").append("id2").toString(), (List)Nil$.MODULE$)}));
        this.spark().sql(new StringBuilder(58).append("update ").append(this.tableName()).append(" set name = 'John Doe' where record_key_col = 'id1'").toString());
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(12).append("John Doe").append("$").append("id1").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("Jane").append("$").append("id2").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.spark().sql(new StringBuilder(58).append("update ").append(this.tableName()).append(" set name = 'Jane Doe' where record_key_col = 'id2'").toString());
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(12).append("John Doe").append("$").append("id1").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(12).append("Jane Doe").append("$").append("id2").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        this.metaClient_$eq(HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient()));
        this.deleteLastCompletedCommitFromTimeline((scala.collection.immutable.Map<String, String>)hudiOpts, this.metaClient());
        this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(this.basePath()).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(12).append("John Doe").append("$").append("id1").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(8).append("Jane").append("$").append("id2").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
    }

    private void deleteLastCompletedCommitFromTimeline(scala.collection.immutable.Map<String, String> hudiOpts, HoodieTableMetaClient metaClient) {
        HoodieInstant lastInstant = (HoodieInstant)metaClient.reloadActiveTimeline().getCommitsTimeline().lastInstant().get();
        Assertions.assertTrue((boolean)this.hoodieStorage().deleteFile(new StoragePath(metaClient.getTimelinePath(), HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(lastInstant))));
        this.mergedDfList_$eq((List<Dataset<Row>>)this.mergedDfList().take(this.mergedDfList().size() - 1));
    }

    private void checkAnswer(String query, Seq<Seq<Object>> expects) {
        Assertions$.MODULE$.assertResult(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)expects.map((Function1 & Serializable & scala.Serializable)row -> Row$.MODULE$.apply(row), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Row.class)))).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), (Ordering)Ordering.String$.MODULE$), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().sql(query).collect())).sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), (Ordering)Ordering.String$.MODULE$), Prettifier$.MODULE$.default(), new Position("TestSecondaryIndexPruning.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1723));
    }

    private void verifyQueryPredicate(scala.collection.immutable.Map<String, String> hudiOpts, String columnName, String nonExistentKey) {
        this.mergedDfList_$eq((List<Dataset<Row>>)((List)this.mergedDfList().$colon$plus((Object)this.spark().read().format("hudi").options(hudiOpts).load(this.basePath()).repartition(1).cache(), List$.MODULE$.canBuildFrom())));
        String secondaryKey = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.mergedDfList().last()).limit(2).collect())).filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)TestSecondaryIndexPruning.$anonfun$verifyQueryPredicate$1(columnName, nonExistentKey, row))))).map((Function1 & Serializable & scala.Serializable)row -> row.getAs(columnName).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).head();
        EqualTo dataFilter = new EqualTo((Expression)this.attribute(columnName), (Expression)Literal$.MODULE$.apply((Object)secondaryKey));
        this.verifyFilePruning(hudiOpts, (Expression)dataFilter);
    }

    private String verifyQueryPredicate$default$3() {
        return "";
    }

    private AttributeReference attribute(String partition) {
        String x$1 = partition;
        StringType$ x$2 = StringType$.MODULE$;
        boolean x$3 = true;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
        return new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6);
    }

    private void verifyFilePruning(scala.collection.immutable.Map<String, String> opts, Expression dataFilter) {
        scala.collection.immutable.Map commonOpts = opts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.basePath()));
        this.metaClient_$eq(HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient()));
        SparkSession x$1 = this.spark();
        HoodieTableMetaClient x$2 = this.metaClient();
        None$ x$3 = None$.MODULE$;
        scala.collection.immutable.Map x$4 = commonOpts;
        boolean x$5 = true;
        FileStatusCache x$6 = HoodieFileIndex$.MODULE$.apply$default$5();
        boolean x$7 = HoodieFileIndex$.MODULE$.apply$default$7();
        HoodieFileIndex fileIndex = new HoodieFileIndex(x$1, x$2, (scala.Option)x$3, x$4, x$6, x$5, x$7);
        Seq filteredPartitionDirectories = fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$));
        int filteredFilesCount = ((SeqLike)filteredPartitionDirectories.flatMap((Function1 & Serializable & scala.Serializable)s -> s.files(), Seq$.MODULE$.canBuildFrom())).size();
        long latestDataFilesCount = this.getLatestDataFilesCount(opts, this.getLatestDataFilesCount$default$2());
        Assertions.assertTrue((filteredFilesCount > 0 && (long)filteredFilesCount < latestDataFilesCount ? 1 : 0) != 0);
        SparkSession x$8 = this.spark();
        HoodieTableMetaClient x$9 = this.metaClient();
        None$ x$10 = None$.MODULE$;
        scala.collection.immutable.Map x$11 = commonOpts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"false"));
        boolean x$12 = true;
        FileStatusCache x$13 = HoodieFileIndex$.MODULE$.apply$default$5();
        boolean x$14 = HoodieFileIndex$.MODULE$.apply$default$7();
        fileIndex = new HoodieFileIndex(x$8, x$9, (scala.Option)x$10, x$11, x$13, x$12, x$14);
        int filesCountWithNoSkipping = ((SeqLike)fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)s -> s.files(), Seq$.MODULE$.canBuildFrom())).size();
        Assertions.assertTrue(((long)filesCountWithNoSkipping == latestDataFilesCount ? 1 : 0) != 0);
        fileIndex.close();
    }

    private long getLatestDataFilesCount(scala.collection.immutable.Map<String, String> opts, boolean includeLogFiles) {
        LongRef totalLatestDataFiles = LongRef.create((long)0L);
        try (HoodieMetadataFileSystemView fsView = this.getTableFileSystemView(opts);){
            fsView.getAllLatestFileSlicesBeforeOrOn(((HoodieInstant)this.metaClient().getActiveTimeline().lastInstant().get()).requestedTime()).values().forEach(JFunction$.MODULE$.toJavaConsumer((Function1 & Serializable & scala.Serializable)slices -> {
                slices.forEach(JFunction$.MODULE$.toJavaConsumer((Function1 & Serializable & scala.Serializable)slice -> {
                    totalLatestDataFiles$1.elem = totalLatestDataFiles$1.elem + ((includeLogFiles$1 ? slice.getLogFiles().count() : 0L) + (long)(slice.getBaseFile().isPresent() ? 1 : 0));
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            }));
        }
        return totalLatestDataFiles.elem;
    }

    private boolean getLatestDataFilesCount$default$2() {
        return true;
    }

    private HoodieMetadataFileSystemView getTableFileSystemView(scala.collection.immutable.Map<String, String> opts) {
        return new HoodieMetadataFileSystemView(this.metaClient(), (HoodieTimeline)this.metaClient().getActiveTimeline(), (HoodieTableMetadata)new HoodieBackedTableMetadata((HoodieEngineContext)this.context(), this.metaClient().getStorage(), this.getWriteConfig(opts).getMetadataConfig(), this.metaClient().getBasePath().toString(), true));
    }

    private HoodieWriteConfig getWriteConfig(scala.collection.immutable.Map<String, String> hudiOpts) {
        TypedProperties props = TypedProperties.fromMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(hudiOpts).asJava()));
        return HoodieWriteConfig.newBuilder().withProps((java.util.Map)props).withPath(this.basePath()).build();
    }

    public static final /* synthetic */ boolean $anonfun$testSecondaryIndexWithConcurrentWrites$1(Function1 function$1) {
        return function$1.apply$mcZI$sp(1);
    }

    public static final /* synthetic */ boolean $anonfun$testSecondaryIndexWithConcurrentWrites$2(Function1 function$1) {
        return function$1.apply$mcZI$sp(2);
    }

    public static final /* synthetic */ boolean $anonfun$testSecondaryIndexWithMDTCompaction$1(TestSecondaryIndexPruning $this, HoodieTimeline compactionTimeline$1, HoodieInstant instant) {
        WriteOperationType writeOperationType = ((HoodieCommitMetadata)$this.metaClient().getTimelineLayout().getCommitMetadataSerDe().deserialize(instant, (byte[])compactionTimeline$1.getInstantDetails(instant).get(), HoodieCommitMetadata.class)).getOperationType();
        WriteOperationType writeOperationType2 = WriteOperationType.COMPACT;
        return !(writeOperationType != null ? !writeOperationType.equals(writeOperationType2) : writeOperationType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testSecondaryIndexWithMDTCompaction$2(Option lastCompactionInstant$1, HoodieBaseFile f) {
        return f.getCommitTime().equals(((HoodieInstant)lastCompactionInstant$1.get()).requestedTime());
    }

    public static final /* synthetic */ void $anonfun$testSecondaryIndexWithPrimitiveDataTypes$3(TestSecondaryIndexPruning $this, ObjectRef hudiOpts$2, String col) {
        Tuple2 tuple2;
        String string = col;
        if ("string_col".equals(string)) {
            tuple2 = new Tuple2((Object)new StringBuilder(8).append(col).append(" = 'abc'").toString(), (Object)"abc");
        } else if ("int_col".equals(string)) {
            tuple2 = new Tuple2((Object)new StringBuilder(5).append(col).append(" = 10").toString(), (Object)"10");
        } else if ("bigint_col".equals(string)) {
            tuple2 = new Tuple2((Object)new StringBuilder(6).append(col).append(" = 100").toString(), (Object)"100");
        } else if ("double_col".equals(string)) {
            tuple2 = new Tuple2((Object)new StringBuilder(6).append(col).append(" = 1.1").toString(), (Object)"1.1");
        } else if ("decimal_col".equals(string)) {
            tuple2 = new Tuple2((Object)new StringBuilder(9).append(col).append(" = 100.01").toString(), (Object)"100.01");
        } else if ("timestamp_col".equals(string)) {
            tuple2 = new Tuple2((Object)new StringBuilder(24).append(col).append(" = '2023-01-01 12:00:00'").toString(), (Object)"2023-01-01 12:00:00");
        } else if ("boolean_col".equals(string)) {
            tuple2 = new Tuple2((Object)new StringBuilder(7).append(col).append(" = true").toString(), (Object)"true");
        } else {
            throw new MatchError((Object)string);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String queryFilter = (String)tuple22._1();
        String value = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)queryFilter, (Object)value);
        String queryFilter2 = (String)tuple23._1();
        String value2 = (String)tuple23._2();
        $this.checkAnswer(new StringBuilder(101).append("select ts, record_key_col, cast(").append(col).append(" AS STRING), partition_key_col from ").append($this.tableName()).append(" where ").append(queryFilter2).append(" and record_key_col='row1'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "row1", value2, "p1"}))}));
        String string2 = col;
        String string3 = "timestamp_col";
        if (string2 == null ? string3 != null : !string2.equals(string3)) {
            $this.verifyQueryPredicate((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts$2.elem), col, $this.verifyQueryPredicate$default$3());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$verifyQueryPredicate$1(String columnName$1, String nonExistentKey$1, Row row) {
        return !row.getAs(columnName$1).toString().equals(nonExistentKey$1);
    }

    public static class SecondaryIndexTestCase
    implements Product,
    scala.Serializable {
        private final String tableType;
        private final boolean isPartitioned;

        public String tableType() {
            return this.tableType;
        }

        public boolean isPartitioned() {
            return this.isPartitioned;
        }

        public SecondaryIndexTestCase copy(String tableType, boolean isPartitioned) {
            return new SecondaryIndexTestCase(tableType, isPartitioned);
        }

        public String copy$default$1() {
            return this.tableType();
        }

        public boolean copy$default$2() {
            return this.isPartitioned();
        }

        public String productPrefix() {
            return "SecondaryIndexTestCase";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.tableType();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isPartitioned());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SecondaryIndexTestCase;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tableType()));
            n = Statics.mix((int)n, (int)(this.isPartitioned() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SecondaryIndexTestCase)) return false;
            boolean bl = true;
            if (!bl) return false;
            SecondaryIndexTestCase secondaryIndexTestCase = (SecondaryIndexTestCase)x$1;
            String string = this.tableType();
            String string2 = secondaryIndexTestCase.tableType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.isPartitioned() != secondaryIndexTestCase.isPartitioned()) return false;
            if (!secondaryIndexTestCase.canEqual(this)) return false;
            return true;
        }

        public SecondaryIndexTestCase(String tableType, boolean isPartitioned) {
            this.tableType = tableType;
            this.isPartitioned = isPartitioned;
            Product.$init$((Product)this);
        }
    }
}

