/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.functional.TestBootstrapReadBase;
import org.apache.hudi.util.JavaConversions;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class TestSparkParquetReader
extends TestBootstrapReadBase {
    @Test
    public void testReader() {
        this.dataGen = new HoodieTestDataGenerator(dashPartitionPaths);
        int n = 10;
        Dataset<Row> inserts = this.makeInsertDf("000", n);
        inserts.write().format("parquet").save(this.bootstrapBasePath);
        Dataset<Row> parquetReadRows = JavaConversions.createTestDataFrame(this.sparkSession, this.bootstrapBasePath);
        Dataset datasourceReadRows = this.sparkSession.read().format("parquet").load(this.bootstrapBasePath);
        Assertions.assertEquals((long)datasourceReadRows.count(), (long)n);
        Assertions.assertEquals((long)parquetReadRows.count(), (long)n);
        Assertions.assertEquals((long)datasourceReadRows.except(parquetReadRows).count(), (long)0L);
        Assertions.assertEquals((long)parquetReadRows.except(datasourceReadRows).count(), (long)0L);
    }
}

