/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.functional.TestSparkSqlWithCustomKeyGenerator$;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.hudi.util.SparkKeyGenUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0012%\u00015BQ!\u000f\u0001\u0005\u0002iBq!\u0010\u0001C\u0002\u0013%a\b\u0003\u0004F\u0001\u0001\u0006Ia\u0010\u0005\u0006\r\u0002!Ia\u0012\u0005\u0006S\u0002!IA\u001b\u0005\u0007\u007f\u0002!I!!\u0001\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n!9\u0011q\u0002\u0001\u0005\n\u0005E\u0001bBA\u0017\u0001\u0011%\u0011q\u0006\u0005\b\u0003s\u0001A\u0011BA\u001e\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!a\u001e\u0001\t\u0013\tI\bC\u0004\u0002~\u0001!I!a \b\u000f\u0005%E\u0005#\u0001\u0002\f\u001a11\u0005\nE\u0001\u0003\u001bCa!O\b\u0005\u0002\u0005m\u0005\"CAO\u001f\t\u0007I\u0011AAP\u0011!\t)k\u0004Q\u0001\n\u0005\u0005\u0006\"CAT\u001f\t\u0007I\u0011AAP\u0011!\tIk\u0004Q\u0001\n\u0005\u0005\u0006\"CAV\u001f\t\u0007I\u0011AAP\u0011!\tik\u0004Q\u0001\n\u0005\u0005\u0006\"CAX\u001f\t\u0007I\u0011AAP\u0011!\t\tl\u0004Q\u0001\n\u0005\u0005\u0006\"CAZ\u001f\t\u0007I\u0011AA[\u0011!\t)m\u0004Q\u0001\n\u0005]\u0006\"CAd\u001f\t\u0007I\u0011AAe\u0011!\tim\u0004Q\u0001\n\u0005-\u0007\"CAh\u001f\t\u0007I\u0011AAe\u0011!\t\tn\u0004Q\u0001\n\u0005-\u0007\"CAj\u001f\t\u0007I\u0011AAk\u0011!\tIn\u0004Q\u0001\n\u0005]\u0007bBAn\u001f\u0011\u0005\u0011Q\u001c\u0005\n\u0003?|\u0011\u0011!C\u0005\u0003C\u0014!\u0005V3tiN\u0003\u0018M]6Tc2<\u0016\u000e\u001e5DkN$x.\\&fs\u001e+g.\u001a:bi>\u0014(BA\u0013'\u0003)1WO\\2uS>t\u0017\r\u001c\u0006\u0003O!\nA\u0001[;eS*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0018\u0011\u0005=:T\"\u0001\u0019\u000b\u0005E\u0012\u0014AB2p[6|gN\u0003\u0002(g)\u0011A'N\u0001\u0004gFd'B\u0001\u001c)\u0003\u0015\u0019\b/\u0019:l\u0013\tA\u0004G\u0001\fI_>$\u0017.Z*qCJ\\7+\u001d7UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t1\b\u0005\u0002=\u00015\tA%A\u0002M\u001f\u001e+\u0012a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005*\nQa\u001d7gi)L!\u0001R!\u0003\r1{wmZ3s\u0003\u0011auj\u0012\u0011\u0002+Y\fG.\u001b3bi\u0016$6OR5fY\u0012\u001c6\r[3nCR!\u0001JT.^!\tIE*D\u0001K\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0005\u0011)f.\u001b;\t\u000b=#\u0001\u0019\u0001)\u0002\u0013Q\f'\r\\3QCRD\u0007CA)Y\u001d\t\u0011f\u000b\u0005\u0002T\u00156\tAK\u0003\u0002VY\u00051AH]8pizJ!a\u0016&\u0002\rA\u0013X\rZ3g\u0013\tI&L\u0001\u0004TiJLgn\u001a\u0006\u0003/*CQ\u0001\u0018\u0003A\u0002A\u000b\u0011BZ5fY\u0012t\u0015-\\3\t\u000by#\u0001\u0019A0\u0002\u0019\u0015D\b/Z2uK\u0012$\u0016\u0010]3\u0011\u0005\u00014gBA1e\u001b\u0005\u0011'BA2)\u0003\u0011\tgO]8\n\u0005\u0015\u0014\u0017AB*dQ\u0016l\u0017-\u0003\u0002hQ\n!A+\u001f9f\u0015\t)'-A\u0006uKN$\u0018J\\:feR\u001cH\u0003\u0002%l[jDQ\u0001\\\u0003A\u0002A\u000b\u0011\u0002^1cY\u0016t\u0015-\\3\t\u000b9,\u0001\u0019A8\u0002\u0013Q\u001cx)\u001a8Gk:\u001c\u0007\u0003B%qeBK!!\u001d&\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA:y\u001b\u0005!(BA;w\u0003\u0011a\u0017M\\4\u000b\u0003]\fAA[1wC&\u0011\u0011\u0010\u001e\u0002\b\u0013:$XmZ3s\u0011\u0015YX\u00011\u0001}\u0003A\u0001\u0018M\u001d;ji&|gnR3o\rVt7\rE\u0003J{J\u0004\u0006+\u0003\u0002\u007f\u0015\nIa)\u001e8di&|gNM\u0001\u0016i\u0016\u001cHOR5sgR\u0014v.\u001e8e\u0013:\u001cXM\u001d;t)\u0015A\u00151AA\u0003\u0011\u0015ag\u00011\u0001Q\u0011\u0015Yh\u00011\u0001}\u0003Y!Xm\u001d;TK\u000e|g\u000e\u001a*pk:$\u0017J\\:feR\u001cH#\u0002%\u0002\f\u00055\u0001\"\u00027\b\u0001\u0004\u0001\u0006\"B>\b\u0001\u0004a\u0018\u0001\b9sKB\f'/\u001a+bE2,w+\u001b;i\u0017\u0016Lx)\u001a8fe\u0006$xN\u001d\u000b\u000e\u0011\u0006M\u0011QCA\f\u00037\ty\"a\t\t\u000b1D\u0001\u0019\u0001)\t\u000b=C\u0001\u0019\u0001)\t\r\u0005e\u0001\u00021\u0001Q\u0003%!\u0018M\u00197f)f\u0004X\r\u0003\u0004\u0002\u001e!\u0001\r\u0001U\u0001\u0010W\u0016Lx)\u001a8DY\u0006\u001c8OT1nK\"1\u0011\u0011\u0005\u0005A\u0002A\u000bAc\u001e:ji\u0016\u0004\u0016M\u001d;ji&|gNR5fY\u0012\u001c\bbBA\u0013\u0011\u0001\u0007\u0011qE\u0001\u001ci&lWm\u001d;b[B\\U-_$f]\u0016\u0014\u0018\r^8s\u0007>tg-[4\u0011\u000bE\u000bI\u0003\u0015)\n\u0007\u0005-\"LA\u0002NCB\f!c\u0019:fCR,G+\u00192mK^KG\u000f[*rYR9\u0001*!\r\u00024\u0005U\u0002\"\u00027\n\u0001\u0004\u0001\u0006\"B(\n\u0001\u0004\u0001\u0006BBA\u001c\u0013\u0001\u0007\u0001+\u0001\u0005uE2\u0004&o\u001c9t\u0003Q\u0001(/\u001a9be\u0016\u0004\u0016M]9vKR\u001cv.\u001e:dKR)\u0001*!\u0010\u0002B!1\u0011q\b\u0006A\u0002A\u000bqb]8ve\u000e,G+\u00192mK:\u000bW.\u001a\u0005\b\u0003\u0007R\u0001\u0019AA#\u0003\u0011\u0011xn^:\u0011\u000b\u0005\u001d\u0013\u0011\u000b)\u000f\t\u0005%\u0013Q\n\b\u0004'\u0006-\u0013\"A&\n\u0007\u0005=#*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0013Q\u000b\u0002\u0004'\u0016\f(bAA(\u0015\u0006ya/\u00197jI\u0006$XMU3tk2$8\u000fF\u0006I\u00037\ni&a\u0018\u0002b\u0005\u0015\u0004\"\u00027\f\u0001\u0004\u0001\u0006\"\u0002\u001b\f\u0001\u0004\u0001\u0006\"B>\f\u0001\u0004a\bbBA2\u0017\u0001\u0007\u0011QI\u0001\u0012IJ|\u0007\u000f]3e!\u0006\u0014H/\u001b;j_:\u001c\bbBA4\u0017\u0001\u0007\u0011\u0011N\u0001\bKb\u0004Xm\u0019;t!\u0015I\u00151NA8\u0013\r\tiG\u0013\u0002\u000byI,\u0007/Z1uK\u0012t\u0004CBA$\u0003#\n\t\bE\u0002J\u0003gJ1!!\u001eK\u0005\r\te._\u0001\u0019O\u0016$8k\u001c:uK\u0012$\u0016M\u00197f!\u0006\u0014H/\u001b;j_:\u001cH\u0003BA#\u0003wBQ\u0001\u001c\u0007A\u0002A\u000b!C^1mS\u0012\fG/\u001a)beRLG/[8ogR9\u0001*!!\u0002\u0004\u0006\u0015\u0005\"\u00027\u000e\u0001\u0004\u0001\u0006bBA2\u001b\u0001\u0007\u0011Q\t\u0005\b\u0003\u000fk\u0001\u0019AA#\u0003I)\u0007\u0010]3di\u0016$\u0007+\u0019:uSRLwN\\:\u0002EQ+7\u000f^*qCJ\\7+\u001d7XSRD7)^:u_6\\U-_$f]\u0016\u0014\u0018\r^8s!\tatbE\u0003\u0010\u0003\u001f\u000b)\nE\u0002J\u0003#K1!a%K\u0005\u0019\te.\u001f*fMB\u0019\u0011*a&\n\u0007\u0005e%J\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002\f\u0006I2+S'Q\u0019\u0016{6*R-`\u000f\u0016sul\u0011'B'N{f*Q'F+\t\t\t\u000bE\u0002t\u0003GK!!\u0017;\u00025MKU\n\u0015'F?.+\u0015lX$F\u001d~\u001bE*Q*T?:\u000bU*\u0012\u0011\u0002C9{e\nU!S)&#\u0016j\u0014(F\t~[U)W0H\u000b:{6\tT!T'~s\u0015)T#\u0002E9{e\nU!S)&#\u0016j\u0014(F\t~[U)W0H\u000b:{6\tT!T'~s\u0015)T#!\u0003e\u0019Uk\u0015+P\u001b~[U)W0H\u000b:{6\tT!T'~s\u0015)T#\u00025\r+6\u000bV(N?.+\u0015lX$F\u001d~\u001bE*Q*T?:\u000bU*\u0012\u0011\u0002'\u0011\u000bE+R0G\u001fJk\u0015\tV0Q\u0003R#VI\u0015(\u0002)\u0011\u000bE+R0G\u001fJk\u0015\tV0Q\u0003R#VI\u0015(!\u0003I!6kX&F3~;UIT0D\u001f:3\u0015jR*\u0016\u0005\u0005]\u0006\u0003CA]\u0003\u0007\f\t+!)\u000e\u0005\u0005m&\u0002BA_\u0003\u007f\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005\u0005'*\u0001\u0006d_2dWm\u0019;j_:LA!a\u000b\u0002<\u0006\u0019BkU0L\u000bf{v)\u0012(`\u0007>se)S$TA\u0005\tBkU0U\u001f~\u001bFKU%O\u000f~3UKT\"\u0016\u0005\u0005-\u0007#B%qe\u0006\u0005\u0016A\u0005+T?R{ul\u0015+S\u0013:;uLR+O\u0007\u0002\n\u0011\u0003V*`\r>\u0013V*\u0011+U\u000bJ{f)\u0016(D\u0003I!6k\u0018$P%6\u000bE\u000bV#S?\u001a+fj\u0011\u0011\u0002;Q\u001bvLR(S\u001b\u0006#F+\u0012*`\rVs5iX,J)\"{fi\u0014*N\u0003R+\"!a6\u0011\r%k(\u000fUAQ\u0003y!6k\u0018$P%6\u000bE\u000bV#S?\u001a+fjQ0X\u0013RCuLR(S\u001b\u0006#\u0006%A\rhKR$\u0016.\\3ti\u0006l\u0007oS3z\u000f\u0016t7i\u001c8gS\u001e\u001cXCAA\u0014\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\r\bcA:\u0002f&\u0019\u0011q\u001d;\u0003\r=\u0013'.Z2u\u0001")
public class TestSparkSqlWithCustomKeyGenerator
extends HoodieSparkSqlTestBase {
    private final Logger LOG = LoggerFactory.getLogger((Class)this.getClass());

    public static Map<String, String> getTimestampKeyGenConfigs() {
        return TestSparkSqlWithCustomKeyGenerator$.MODULE$.getTimestampKeyGenConfigs();
    }

    public static Function2<Integer, String, String> TS_FORMATTER_FUNC_WITH_FORMAT() {
        return TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_FORMATTER_FUNC_WITH_FORMAT();
    }

    public static Function1<Integer, String> TS_FORMATTER_FUNC() {
        return TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_FORMATTER_FUNC();
    }

    public static Function1<Integer, String> TS_TO_STRING_FUNC() {
        return TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_TO_STRING_FUNC();
    }

    public static Map<String, String> TS_KEY_GEN_CONFIGS() {
        return TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_KEY_GEN_CONFIGS();
    }

    public static String DATE_FORMAT_PATTERN() {
        return TestSparkSqlWithCustomKeyGenerator$.MODULE$.DATE_FORMAT_PATTERN();
    }

    public static String CUSTOM_KEY_GEN_CLASS_NAME() {
        return TestSparkSqlWithCustomKeyGenerator$.MODULE$.CUSTOM_KEY_GEN_CLASS_NAME();
    }

    public static String NONPARTITIONED_KEY_GEN_CLASS_NAME() {
        return TestSparkSqlWithCustomKeyGenerator$.MODULE$.NONPARTITIONED_KEY_GEN_CLASS_NAME();
    }

    public static String SIMPLE_KEY_GEN_CLASS_NAME() {
        return TestSparkSqlWithCustomKeyGenerator$.MODULE$.SIMPLE_KEY_GEN_CLASS_NAME();
    }

    private Logger LOG() {
        return this.LOG;
    }

    private void validateTsFieldSchema(String tablePath, String fieldName, Schema.Type expectedType) {
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)tablePath);
        TableSchemaResolver schemaResolver = new TableSchemaResolver(metaClient);
        Schema nullableSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)expectedType)});
        Assertions.assertEquals((Object)nullableSchema, (Object)schemaResolver.getTableAvroSchema(true).getField(fieldName).schema());
    }

    private void testInserts(String tableName, Function1<Integer, String> tsGenFunc, Function2<Integer, String, String> partitionGenFunc) {
        String sourceTableName = new StringBuilder(8).append(tableName).append("_source1").toString();
        this.prepareParquetSource(sourceTableName, (Seq<String>)((Seq)new .colon.colon((Object)"(1, 'a1', 1.6, 1704121827, 'cat1')", (List)new .colon.colon((Object)"(2, 'a2', 10.8, 1704121827, 'cat1')", (List)new .colon.colon((Object)"(3, 'a3', 30.0, 1706800227, 'cat1')", (List)new .colon.colon((Object)"(4, 'a4', 103.4, 1701443427, 'cat2')", (List)new .colon.colon((Object)"(5, 'a5', 1999.0, 1704121827, 'cat2')", (List)new .colon.colon((Object)"(6, 'a6', 80.0, 1704121827, 'cat3')", (List)new .colon.colon((Object)"(7, 'a7', 1399.0, 1706800227, 'cat1')", (List)Nil$.MODULE$)))))))));
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(62).append("\n         | INSERT INTO ").append(tableName).append("\n         | SELECT * from ").append(sourceTableName).append("\n         | ").toString())).stripMargin());
        this.validateResults(tableName, new StringBuilder(57).append("SELECT id, name, cast(price as string), ts, segment from ").append(tableName).toString(), partitionGenFunc, (Seq<String>)((Seq)Nil$.MODULE$), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", "1.6", BoxesRunTime.boxToInteger((int)1704121827), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", "10.8", BoxesRunTime.boxToInteger((int)1704121827), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", "30.0", BoxesRunTime.boxToInteger((int)1706800227), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", "103.4", BoxesRunTime.boxToInteger((int)1701443427), "cat2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", "1999.0", BoxesRunTime.boxToInteger((int)1704121827), "cat2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", "80.0", BoxesRunTime.boxToInteger((int)1704121827), "cat3"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "a7", "1399.0", BoxesRunTime.boxToInteger((int)1706800227), "cat1"}))}));
    }

    private void testFirstRoundInserts(String tableName, Function2<Integer, String, String> partitionGenFunc) {
        String sourceTableName = new StringBuilder(8).append(tableName).append("_source1").toString();
        this.prepareParquetSource(sourceTableName, (Seq<String>)((Seq)new .colon.colon((Object)"(7, 'a7', 1399.0, 1706800227, 'cat1')", (List)Nil$.MODULE$)));
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(62).append("\n         | INSERT INTO ").append(tableName).append("\n         | SELECT * from ").append(sourceTableName).append("\n         | ").toString())).stripMargin());
        String sqlStr = new StringBuilder(57).append("SELECT id, name, cast(price as string), ts, segment from ").append(tableName).toString();
        this.validateResults(tableName, sqlStr, partitionGenFunc, (Seq<String>)((Seq)Nil$.MODULE$), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", "1.6", BoxesRunTime.boxToInteger((int)1704121827), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", "10.8", BoxesRunTime.boxToInteger((int)1704121827), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", "30.0", BoxesRunTime.boxToInteger((int)1706800227), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", "103.4", BoxesRunTime.boxToInteger((int)1701443427), "cat2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", "1999.0", BoxesRunTime.boxToInteger((int)1704121827), "cat2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", "80.0", BoxesRunTime.boxToInteger((int)1704121827), "cat3"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "a7", "1399.0", BoxesRunTime.boxToInteger((int)1706800227), "cat1"}))}));
    }

    private void testSecondRoundInserts(String tableName, Function2<Integer, String, String> partitionGenFunc) {
        String sourceTableName = new StringBuilder(8).append(tableName).append("_source2").toString();
        this.prepareParquetSource(sourceTableName, (Seq<String>)((Seq)new .colon.colon((Object)"(8, 'a8', 26.9, 1706800227, 'cat3')", (List)Nil$.MODULE$)));
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(62).append("\n         | INSERT INTO ").append(tableName).append("\n         | SELECT * from ").append(sourceTableName).append("\n         | ").toString())).stripMargin());
        String sqlStr = new StringBuilder(57).append("SELECT id, name, cast(price as string), ts, segment from ").append(tableName).toString();
        this.validateResults(tableName, sqlStr, partitionGenFunc, (Seq<String>)((Seq)Nil$.MODULE$), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", "1.6", BoxesRunTime.boxToInteger((int)1704121827), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", "10.8", BoxesRunTime.boxToInteger((int)1704121827), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", "30.0", BoxesRunTime.boxToInteger((int)1706800227), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", "103.4", BoxesRunTime.boxToInteger((int)1701443427), "cat2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", "1999.0", BoxesRunTime.boxToInteger((int)1704121827), "cat2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", "80.0", BoxesRunTime.boxToInteger((int)1704121827), "cat3"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "a7", "1399.0", BoxesRunTime.boxToInteger((int)1706800227), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "a8", "26.9", BoxesRunTime.boxToInteger((int)1706800227), "cat3"}))}));
    }

    private void prepareTableWithKeyGenerator(String tableName, String tablePath, String tableType, String keyGenClassName, String writePartitionFields, Map<String, String> timestampKeyGeneratorConfig) {
        Dataset df = this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("SELECT 1 as id, 'a1' as name, 1.6 as price, 1704121827 as ts, 'cat1' as segment\n         | UNION\n         | SELECT 2 as id, 'a2' as name, 10.8 as price, 1704121827 as ts, 'cat1' as segment\n         | UNION\n         | SELECT 3 as id, 'a3' as name, 30.0 as price, 1706800227 as ts, 'cat1' as segment\n         | UNION\n         | SELECT 4 as id, 'a4' as name, 103.4 as price, 1701443427 as ts, 'cat2' as segment\n         | UNION\n         | SELECT 5 as id, 'a5' as name, 1999.0 as price, 1704121827 as ts, 'cat2' as segment\n         | UNION\n         | SELECT 6 as id, 'a6' as name, 80.0 as price, 1704121827 as ts, 'cat3' as segment\n         |")).stripMargin());
        df.write().format("hudi").option("hoodie.datasource.write.table.type", tableType).option("hoodie.datasource.write.keygenerator.class", keyGenClassName).option("hoodie.datasource.write.partitionpath.field", writePartitionFields).option("hoodie.datasource.write.recordkey.field", "id").option("hoodie.datasource.write.precombine.field", "name").option("hoodie.table.name", tableName).option("hoodie.insert.shuffle.parallelism", "1").option("hoodie.upsert.shuffle.parallelism", "1").option("hoodie.bulkinsert.shuffle.parallelism", "1").options(timestampKeyGeneratorConfig).mode(SaveMode.Overwrite).save(tablePath);
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)tablePath);
        Assertions.assertEquals((Object)keyGenClassName, (Object)metaClient.getTableConfig().getKeyGeneratorClassName());
        if (TestSparkSqlWithCustomKeyGenerator$.MODULE$.CUSTOM_KEY_GEN_CLASS_NAME().equals(keyGenClassName)) {
            TypedProperties props = new TypedProperties();
            props.put((Object)"hoodie.datasource.write.partitionpath.field", (Object)writePartitionFields);
            timestampKeyGeneratorConfig.foreach((Function1 & Serializable & scala.Serializable)e -> props.put(e._1(), e._2()));
            Assertions.assertEquals((Object)SparkKeyGenUtils$.MODULE$.getPartitionColumns(Option$.MODULE$.apply((Object)TestSparkSqlWithCustomKeyGenerator$.MODULE$.CUSTOM_KEY_GEN_CLASS_NAME()), props), (Object)metaClient.getTableConfig().getPartitionFieldProp());
            return;
        }
        Assertions.assertEquals((Object)writePartitionFields, (Object)metaClient.getTableConfig().getPartitionFieldProp());
    }

    private void createTableWithSql(String tableName, String tablePath, String tblProps) {
        String tblPropsStatement = StringUtils.isNullOrEmpty((String)tblProps) ? "" : new StringBuilder(18).append("TBLPROPERTIES (\n").append(tblProps).append("\n)").toString();
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(83).append("\n         | CREATE TABLE ").append(tableName).append(" USING HUDI\n         | location '").append(tablePath).append("'\n         | ").append(tblPropsStatement).append("\n         | ").toString())).stripMargin());
    }

    private void prepareParquetSource(String sourceTableName, Seq<String> rows) {
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(127).append("CREATE TABLE ").append(sourceTableName).append("\n         | (id int, name string, price decimal(5, 1), ts int, segment string)\n         | USING PARQUET\n         |").toString())).stripMargin());
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(55).append("\n         | INSERT INTO ").append(sourceTableName).append(" values\n         | ").append(rows.mkString(", ")).append("\n         | ").toString())).stripMargin());
    }

    private void validateResults(String tableName, String sql, Function2<Integer, String, String> partitionGenFunc, Seq<String> droppedPartitions, Seq<Seq<Object>> expects) {
        this.checkAnswer(sql, (Seq<Seq<Object>>)((Seq)expects.map((Function1 & Serializable & scala.Serializable)e -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.apply(0), e.apply(1), e.apply(2), e.apply(3), e.apply(4)})), Seq$.MODULE$.canBuildFrom())));
        Seq expectedPartitions = (Seq)((SeqLike)((SeqLike)expects.map((Function1 & Serializable & scala.Serializable)e -> (String)partitionGenFunc.apply((Object)((Integer)e.apply(3)), (Object)((String)e.apply(4))), Seq$.MODULE$.canBuildFrom())).distinct()).sorted((Ordering)Ordering.String$.MODULE$);
        this.validatePartitions(tableName, droppedPartitions, (Seq<String>)expectedPartitions);
    }

    private Seq<String> getSortedTablePartitions(String tableName) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().sql(new StringBuilder(16).append("SHOW PARTITIONS ").append(tableName).toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> row.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).sorted((Ordering)Ordering.String$.MODULE$))).toSeq();
    }

    private void validatePartitions(String tableName, Seq<String> droppedPartitions, Seq<String> expectedPartitions) {
        Seq<String> actualPartitions = this.getSortedTablePartitions(tableName);
        if (expectedPartitions.size() == 1 && ((String)expectedPartitions.head()).isEmpty()) {
            Assertions.assertTrue((boolean)actualPartitions.isEmpty());
        } else {
            Assertions.assertEquals(expectedPartitions, actualPartitions);
        }
        droppedPartitions.foreach((Function1 & Serializable & scala.Serializable)dropped -> {
            TestSparkSqlWithCustomKeyGenerator.$anonfun$validatePartitions$1(actualPartitions, dropped);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$11(TestSparkSqlWithCustomKeyGenerator $this, Seq testParams$1, File tmp$1, String tableName) {
        $this.LOG().warn(new StringBuilder(25).append("Testing with parameters: ").append(testParams$1).toString());
        String tableType = (String)testParams$1.apply(0);
        String writePartitionFields = (String)testParams$1.apply(1);
        String dropPartitionStatement = (String)testParams$1.apply(2);
        String droppedPartition = (String)testParams$1.apply(3);
        Seq expectedPartitions = (Seq)testParams$1.apply(4);
        Function2 partitionGenFunc = (Function2)testParams$1.apply(5);
        String tablePath = new StringBuilder(1).append(tmp$1.getCanonicalPath()).append("/").append(tableName).toString();
        Map timestampKeyGeneratorConfig = writePartitionFields.contains("timestamp") ? TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_KEY_GEN_CONFIGS() : (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        String timestampKeyGenProps = timestampKeyGeneratorConfig.nonEmpty() ? new StringBuilder(2).append(", ").append(((TraversableOnce)timestampKeyGeneratorConfig.map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(5).append((String)e._1()).append(" = '").append(e._2()).append("'").toString(), Iterable$.MODULE$.canBuildFrom())).mkString(", ")).toString() : "";
        boolean useOlderPartitionFieldFormat = BoxesRunTime.unboxToBoolean((Object)testParams$1.apply(6));
        $this.prepareTableWithKeyGenerator(tableName, tablePath, tableType, TestSparkSqlWithCustomKeyGenerator$.MODULE$.CUSTOM_KEY_GEN_CLASS_NAME(), writePartitionFields, (Map<String, String>)timestampKeyGeneratorConfig);
        if (useOlderPartitionFieldFormat) {
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
            TypedProperties props = new TypedProperties();
            props.put((Object)HoodieTableConfig.PARTITION_FIELDS.key(), (Object)metaClient.getTableConfig().getPartitionFieldProp());
            HoodieTableConfig.update((HoodieStorage)metaClient.getStorage(), (StoragePath)metaClient.getMetaPath(), (Properties)props);
            metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
            Assertions.assertEquals((Object)metaClient.getTableConfig().getPartitionFieldProp(), (Object)HoodieTableConfig.getPartitionFieldPropForKeyGenerator((HoodieConfig)metaClient.getTableConfig()).orElse((Object)""));
        }
        $this.createTableWithSql(tableName, tablePath, new StringBuilder(48).append("hoodie.datasource.write.partitionpath.field = '").append(writePartitionFields).append("'").append(timestampKeyGenProps).toString());
        String sourceTableName = new StringBuilder(7).append(tableName).append("_source").toString();
        $this.prepareParquetSource(sourceTableName, (Seq<String>)((Seq)new .colon.colon((Object)"(7, 'a7', 1399.0, 1706800227, 'cat1')", (List)new .colon.colon((Object)"(8, 'a8', 26.9, 1706800227, 'cat3')", (List)new .colon.colon((Object)"(9, 'a9', 299.0, 1701443427, 'cat4')", (List)Nil$.MODULE$)))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n                   | INSERT INTO ").append(tableName).append("\n                   | SELECT * from ").append(tableName).append("_source\n                   | ").toString())).stripMargin());
        String sqlStr = new StringBuilder(57).append("SELECT id, name, cast(price as string), ts, segment from ").append(tableName).toString();
        $this.validateResults(tableName, sqlStr, (Function2<Integer, String, String>)partitionGenFunc, (Seq<String>)((Seq)Nil$.MODULE$), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", "1.6", BoxesRunTime.boxToInteger((int)1704121827), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", "10.8", BoxesRunTime.boxToInteger((int)1704121827), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", "30.0", BoxesRunTime.boxToInteger((int)1706800227), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", "103.4", BoxesRunTime.boxToInteger((int)1701443427), "cat2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", "1999.0", BoxesRunTime.boxToInteger((int)1704121827), "cat2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", "80.0", BoxesRunTime.boxToInteger((int)1704121827), "cat3"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "a7", "1399.0", BoxesRunTime.boxToInteger((int)1706800227), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "a8", "26.9", BoxesRunTime.boxToInteger((int)1706800227), "cat3"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), "a9", "299.0", BoxesRunTime.boxToInteger((int)1701443427), "cat4"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n                   | UPDATE ").append(tableName).append("\n                   | SET price = price + 10.0\n                   | WHERE id between 4 and 7\n                   | ").toString())).stripMargin());
        $this.validateResults(tableName, sqlStr, (Function2<Integer, String, String>)partitionGenFunc, (Seq<String>)((Seq)Nil$.MODULE$), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", "1.6", BoxesRunTime.boxToInteger((int)1704121827), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", "10.8", BoxesRunTime.boxToInteger((int)1704121827), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", "30.0", BoxesRunTime.boxToInteger((int)1706800227), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", "113.4", BoxesRunTime.boxToInteger((int)1701443427), "cat2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", "2009.0", BoxesRunTime.boxToInteger((int)1704121827), "cat2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", "90.0", BoxesRunTime.boxToInteger((int)1704121827), "cat3"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "a7", "1409.0", BoxesRunTime.boxToInteger((int)1706800227), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "a8", "26.9", BoxesRunTime.boxToInteger((int)1706800227), "cat3"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), "a9", "299.0", BoxesRunTime.boxToInteger((int)1701443427), "cat4"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1310).append("\n                   | MERGE INTO ").append(tableName).append(" as target\n                   | USING (\n                   |   SELECT 1 as id, 'a1' as name, 1.6 as price, 1704121827 as ts, 'cat1' as segment, 'delete' as flag\n                   |   UNION\n                   |   SELECT 2 as id, 'a2' as name, 11.9 as price, 1704121827 as ts, 'cat1' as segment, '' as flag\n                   |   UNION\n                   |   SELECT 6 as id, 'a6' as name, 99.0 as price, 1704121827 as ts, 'cat3' as segment, '' as flag\n                   |   UNION\n                   |   SELECT 8 as id, 'a8' as name, 24.9 as price, 1706800227 as ts, 'cat3' as segment, '' as flag\n                   |   UNION\n                   |   SELECT 10 as id, 'a10' as name, 888.8 as price, 1706800227 as ts, 'cat5' as segment, '' as flag\n                   | ) source\n                   | on target.id = source.id\n                   | WHEN MATCHED AND flag != 'delete' THEN UPDATE SET\n                   |   id = source.id, name = source.name, price = source.price, ts = source.ts, segment = source.segment\n                   | WHEN MATCHED AND flag = 'delete' THEN DELETE\n                   | WHEN NOT MATCHED THEN INSERT (id, name, price, ts, segment)\n                   |   values (source.id, source.name, source.price, source.ts, source.segment)\n                   | ").toString())).stripMargin());
        $this.validateResults(tableName, sqlStr, (Function2<Integer, String, String>)partitionGenFunc, (Seq<String>)((Seq)Nil$.MODULE$), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", "11.9", BoxesRunTime.boxToInteger((int)1704121827), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", "30.0", BoxesRunTime.boxToInteger((int)1706800227), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", "113.4", BoxesRunTime.boxToInteger((int)1701443427), "cat2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", "2009.0", BoxesRunTime.boxToInteger((int)1704121827), "cat2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", "99.0", BoxesRunTime.boxToInteger((int)1704121827), "cat3"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "a7", "1409.0", BoxesRunTime.boxToInteger((int)1706800227), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "a8", "24.9", BoxesRunTime.boxToInteger((int)1706800227), "cat3"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), "a9", "299.0", BoxesRunTime.boxToInteger((int)1701443427), "cat4"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), "a10", "888.8", BoxesRunTime.boxToInteger((int)1706800227), "cat5"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(90).append("\n                   | DELETE FROM ").append(tableName).append("\n                   | WHERE id = 7\n                   | ").toString())).stripMargin());
        $this.validateResults(tableName, sqlStr, (Function2<Integer, String, String>)partitionGenFunc, (Seq<String>)((Seq)Nil$.MODULE$), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", "11.9", BoxesRunTime.boxToInteger((int)1704121827), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", "30.0", BoxesRunTime.boxToInteger((int)1706800227), "cat1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", "113.4", BoxesRunTime.boxToInteger((int)1701443427), "cat2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", "2009.0", BoxesRunTime.boxToInteger((int)1704121827), "cat2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", "99.0", BoxesRunTime.boxToInteger((int)1704121827), "cat3"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "a8", "24.9", BoxesRunTime.boxToInteger((int)1706800227), "cat3"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), "a9", "299.0", BoxesRunTime.boxToInteger((int)1701443427), "cat4"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), "a10", "888.8", BoxesRunTime.boxToInteger((int)1706800227), "cat5"}))}));
        Assertions.assertTrue((boolean)$this.getSortedTablePartitions(tableName).contains((Object)droppedPartition));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(71).append("\n                   | ALTER TABLE ").append(tableName).append(" DROP PARTITION ").append(dropPartitionStatement).append("\n                   |").toString())).stripMargin());
        $this.validatePartitions(tableName, (Seq<String>)((Seq)new .colon.colon((Object)droppedPartition, (List)Nil$.MODULE$)), (Seq<String>)expectedPartitions);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(169).append("\n                   | INSERT OVERWRITE ").append(tableName).append("\n                   | SELECT 100 as id, 'a100' as name, 299.0 as price, 1706800227 as ts, 'cat10' as segment\n                   | ").toString())).stripMargin());
        $this.validateResults(tableName, sqlStr, (Function2<Integer, String, String>)partitionGenFunc, (Seq<String>)((Seq)Nil$.MODULE$), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)100), "a100", "299.0", BoxesRunTime.boxToInteger((int)1706800227), "cat10"}))}));
        $this.validateTsFieldSchema(tablePath, "ts", Schema.Type.INT);
        if (useOlderPartitionFieldFormat) {
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
            Assertions.assertEquals((Object)metaClient.getTableConfig().getPartitionFieldProp(), (Object)HoodieTableConfig.getPartitionFieldPropForKeyGenerator((HoodieConfig)metaClient.getTableConfig()).orElse((Object)""));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$new$4(TestSparkSqlWithCustomKeyGenerator $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"COPY_ON_WRITE", "ts:timestamp,segment:simple", "(ts=202401, segment='cat2')", "202401/cat2", Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"202312/cat2", "202312/cat4", "202401/cat1", "202401/cat3", "202402/cat1", "202402/cat3", "202402/cat5"})), (Function2 & Serializable & scala.Serializable)(ts, segment) -> new StringBuilder(1).append((String)TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_FORMATTER_FUNC().apply(ts)).append("/").append((String)segment).toString(), BoxesRunTime.boxToBoolean((boolean)false)}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"MERGE_ON_READ", "segment:simple", "(segment='cat3')", "cat3", Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cat1", "cat2", "cat4", "cat5"})), (Function2 & Serializable & scala.Serializable)(x$1, segment) -> segment, BoxesRunTime.boxToBoolean((boolean)false)}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"MERGE_ON_READ", "ts:timestamp", "(ts=202312)", "202312", new .colon.colon((Object)"202401", (List)new .colon.colon((Object)"202402", (List)Nil$.MODULE$)), (Function2 & Serializable & scala.Serializable)(ts, x$2) -> (String)TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_FORMATTER_FUNC().apply(ts), BoxesRunTime.boxToBoolean((boolean)false)}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"MERGE_ON_READ", "ts:timestamp,segment:simple", "(ts=202401, segment='cat2')", "202401/cat2", Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"202312/cat2", "202312/cat4", "202401/cat1", "202401/cat3", "202402/cat1", "202402/cat3", "202402/cat5"})), (Function2 & Serializable & scala.Serializable)(ts, segment) -> new StringBuilder(1).append((String)TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_FORMATTER_FUNC().apply(ts)).append("/").append((String)segment).toString(), BoxesRunTime.boxToBoolean((boolean)false)}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"MERGE_ON_READ", "ts:timestamp,segment:simple", "(ts=202401, segment='cat2')", "202401/cat2", Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"202312/cat2", "202312/cat4", "202401/cat1", "202401/cat3", "202402/cat1", "202402/cat3", "202402/cat5"})), (Function2 & Serializable & scala.Serializable)(ts, segment) -> new StringBuilder(1).append((String)TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_FORMATTER_FUNC().apply(ts)).append("/").append((String)segment).toString(), BoxesRunTime.boxToBoolean((boolean)true)}))), (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable & scala.Serializable)testParams -> {
            $this.withTable($this.generateTableName(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tableName -> {
                TestSparkSqlWithCustomKeyGenerator.$anonfun$new$11($this, testParams, tmp$1, tableName);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$16(TestSparkSqlWithCustomKeyGenerator $this, File tmp) {
        String tableNameNonPartitioned = $this.generateTableName();
        String tableNameSimpleKey = $this.generateTableName();
        String tableNameCustom1 = $this.generateTableName();
        String tableNameCustom2 = $this.generateTableName();
        String tablePathNonPartitioned = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableNameNonPartitioned).toString();
        String tablePathSimpleKey = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableNameSimpleKey).toString();
        String tablePathCustom1 = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableNameCustom1).toString();
        String tablePathCustom2 = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableNameCustom2).toString();
        String tableType = "MERGE_ON_READ";
        String writePartitionFields1 = "segment:simple";
        String writePartitionFields2 = "ts:timestamp,segment:simple";
        $this.prepareTableWithKeyGenerator(tableNameNonPartitioned, tablePathNonPartitioned, tableType, TestSparkSqlWithCustomKeyGenerator$.MODULE$.NONPARTITIONED_KEY_GEN_CLASS_NAME(), "", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        $this.prepareTableWithKeyGenerator(tableNameSimpleKey, tablePathSimpleKey, tableType, TestSparkSqlWithCustomKeyGenerator$.MODULE$.SIMPLE_KEY_GEN_CLASS_NAME(), "segment", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        $this.prepareTableWithKeyGenerator(tableNameCustom1, tablePathCustom1, tableType, TestSparkSqlWithCustomKeyGenerator$.MODULE$.CUSTOM_KEY_GEN_CLASS_NAME(), writePartitionFields1, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        $this.prepareTableWithKeyGenerator(tableNameCustom2, tablePathCustom2, tableType, TestSparkSqlWithCustomKeyGenerator$.MODULE$.CUSTOM_KEY_GEN_CLASS_NAME(), writePartitionFields2, TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_KEY_GEN_CONFIGS());
        $this.createTableWithSql(tableNameNonPartitioned, tablePathNonPartitioned, "");
        $this.createTableWithSql(tableNameSimpleKey, tablePathSimpleKey, "");
        $this.createTableWithSql(tableNameCustom1, tablePathCustom1, "");
        $this.createTableWithSql(tableNameCustom2, tablePathCustom2, new StringBuilder(50).append("hoodie.datasource.write.partitionpath.field = '").append(writePartitionFields2).append("', ").append(((TraversableOnce)TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_KEY_GEN_CONFIGS().map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(5).append((String)e._1()).append(" = '").append(e._2()).append("'").toString(), Iterable$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        Function2 & Serializable & scala.Serializable segmentPartitionFunc = (Function2 & Serializable & scala.Serializable)(x$3, segment) -> segment;
        Function2 & Serializable & scala.Serializable customPartitionFunc = (Function2 & Serializable & scala.Serializable)(ts, segment) -> new StringBuilder(1).append((String)TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_FORMATTER_FUNC().apply(ts)).append("/").append((String)segment).toString();
        $this.testFirstRoundInserts(tableNameNonPartitioned, (Function2<Integer, String, String>)(Function2 & Serializable & scala.Serializable)(x$4, x$5) -> "");
        $this.testFirstRoundInserts(tableNameSimpleKey, (Function2<Integer, String, String>)segmentPartitionFunc);
        $this.testFirstRoundInserts(tableNameCustom2, (Function2<Integer, String, String>)customPartitionFunc);
        String sourceTableName = new StringBuilder(7).append(tableNameCustom1).append("_source").toString();
        $this.prepareParquetSource(sourceTableName, (Seq<String>)((Seq)new .colon.colon((Object)"(7, 'a7', 1399.0, 1706800227, 'cat1')", (List)Nil$.MODULE$)));
        $this.testFirstRoundInserts(tableNameCustom1, (Function2<Integer, String, String>)segmentPartitionFunc);
        $this.testSecondRoundInserts(tableNameNonPartitioned, (Function2<Integer, String, String>)(Function2 & Serializable & scala.Serializable)(x$6, x$7) -> "");
        $this.testSecondRoundInserts(tableNameSimpleKey, (Function2<Integer, String, String>)segmentPartitionFunc);
        $this.testSecondRoundInserts(tableNameCustom2, (Function2<Integer, String, String>)customPartitionFunc);
        $this.validateTsFieldSchema(tablePathCustom1, "ts", Schema.Type.INT);
        $this.validateTsFieldSchema(tablePathCustom2, "ts", Schema.Type.INT);
    }

    public static final /* synthetic */ void $anonfun$new$25(TestSparkSqlWithCustomKeyGenerator $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        String tableType = "MERGE_ON_READ";
        String writePartitionFields = "segment:simple,ts:timestamp";
        String wrongWritePartitionFields = "segment:simple";
        Function2 & Serializable & scala.Serializable customPartitionFunc = (Function2 & Serializable & scala.Serializable)(ts, segment) -> new StringBuilder(1).append((String)segment).append("/").append(TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_FORMATTER_FUNC().apply(ts)).toString();
        $this.prepareTableWithKeyGenerator(tableName, tablePath, "MERGE_ON_READ", TestSparkSqlWithCustomKeyGenerator$.MODULE$.CUSTOM_KEY_GEN_CLASS_NAME(), writePartitionFields, TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_KEY_GEN_CONFIGS());
        $this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.createTableWithSql(tableName, tablePath, new StringBuilder(50).append("hoodie.datasource.write.partitionpath.field = '").append(wrongWritePartitionFields).append("', ").append(((TraversableOnce)TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_KEY_GEN_CONFIGS().map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(5).append((String)e._1()).append(" = '").append(e._2()).append("'").toString(), Iterable$.MODULE$.canBuildFrom())).mkString(", ")).toString()), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestSparkSqlWithCustomKeyGenerator.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        $this.createTableWithSql(tableName, tablePath, new StringBuilder(50).append("hoodie.datasource.write.partitionpath.field = '").append(writePartitionFields).append("', ").append(((TraversableOnce)TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_KEY_GEN_CONFIGS().map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(5).append((String)e._1()).append(" = '").append(e._2()).append("'").toString(), Iterable$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("ALTER TABLE ").append(tableName).append("\n               | SET TBLPROPERTIES (hoodie.datasource.write.partitionpath.field = '").append(wrongWritePartitionFields).append("')\n               | ").toString())).stripMargin());
        String sourceTableName = new StringBuilder(7).append(tableName).append("_source").toString();
        $this.prepareParquetSource(sourceTableName, (Seq<String>)((Seq)new .colon.colon((Object)"(7, 'a7', 1399.0, 1706800227, 'cat1')", (List)Nil$.MODULE$)));
        $this.assertThrows((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(86).append("\n                 | INSERT INTO ").append(tableName).append("\n                 | SELECT * from ").append(sourceTableName).append("\n                 | ").toString())).stripMargin()), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestSparkSqlWithCustomKeyGenerator.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("ALTER TABLE ").append(tableName).append("\n               | SET TBLPROPERTIES (hoodie.datasource.write.partitionpath.field = '").append(writePartitionFields).append("')\n               | ").toString())).stripMargin());
        $this.testFirstRoundInserts(tableName, (Function2<Integer, String, String>)customPartitionFunc);
        $this.validateTsFieldSchema(tablePath, "ts", Schema.Type.INT);
    }

    public static final /* synthetic */ void $anonfun$new$34(TestSparkSqlWithCustomKeyGenerator $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        String writePartitionFields = "ts:timestamp";
        String dateFormat = "yyyy/MM/dd";
        Function1 & Serializable & scala.Serializable tsGenFunc = (Function1 & Serializable & scala.Serializable)ts -> (String)TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_FORMATTER_FUNC_WITH_FORMAT().apply(ts, (Object)dateFormat);
        Function2 & Serializable & scala.Serializable customPartitionFunc = (Function2 & Serializable & scala.Serializable)(ts, x$8) -> (String)tsGenFunc.apply(ts);
        Map keyGenConfigs = TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_KEY_GEN_CONFIGS().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.keygen.timebased.output.dateformat"), (Object)dateFormat));
        $this.prepareTableWithKeyGenerator(tableName, tablePath, "MERGE_ON_READ", TestSparkSqlWithCustomKeyGenerator$.MODULE$.CUSTOM_KEY_GEN_CLASS_NAME(), writePartitionFields, (Map<String, String>)keyGenConfigs);
        $this.createTableWithSql(tableName, tablePath, new StringBuilder(50).append("hoodie.datasource.write.partitionpath.field = '").append(writePartitionFields).append("', ").append(((TraversableOnce)keyGenConfigs.map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(5).append((String)e._1()).append(" = '").append(e._2()).append("'").toString(), Iterable$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        $this.testFirstRoundInserts(tableName, (Function2<Integer, String, String>)customPartitionFunc);
        Assertions.assertEquals((long)7L, (long)$this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(50).append("\n               | SELECT * from ").append(tableName).append("\n               | ").toString())).stripMargin()).count());
        Dataset incrementalDF = $this.spark().read().format("hudi").option("hoodie.datasource.query.type", "incremental").option("hoodie.datasource.read.begin.instanttime", 0L).load(tablePath);
        incrementalDF.createOrReplaceTempView("tbl_incremental");
        Assertions.assertEquals((long)7L, (long)$this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n               | SELECT * from tbl_incremental\n               | ")).stripMargin()).count());
        $this.validateTsFieldSchema(tablePath, "ts", Schema.Type.INT);
    }

    public static final /* synthetic */ void $anonfun$new$41(TestSparkSqlWithCustomKeyGenerator $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        String writePartitionFields = "ts:timestamp";
        String dateFormat = "yyyy/MM/dd";
        Function1 & Serializable & scala.Serializable tsGenFunc = (Function1 & Serializable & scala.Serializable)ts -> (String)TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_FORMATTER_FUNC_WITH_FORMAT().apply(ts, (Object)dateFormat);
        Function2 & Serializable & scala.Serializable customPartitionFunc = (Function2 & Serializable & scala.Serializable)(ts, x$9) -> (String)tsGenFunc.apply(ts);
        Map keyGenConfigs = TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_KEY_GEN_CONFIGS().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.keygen.timebased.output.dateformat"), (Object)dateFormat));
        $this.prepareTableWithKeyGenerator(tableName, tablePath, "MERGE_ON_READ", TestSparkSqlWithCustomKeyGenerator$.MODULE$.CUSTOM_KEY_GEN_CLASS_NAME(), writePartitionFields, (Map<String, String>)keyGenConfigs);
        $this.createTableWithSql(tableName, tablePath, ((TraversableOnce)keyGenConfigs.map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(5).append((String)e._1()).append(" = '").append(e._2()).append("'").toString(), Iterable$.MODULE$.canBuildFrom())).mkString(", "));
        $this.testFirstRoundInserts(tableName, (Function2<Integer, String, String>)customPartitionFunc);
        Assertions.assertEquals((long)7L, (long)$this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(50).append("\n               | SELECT * from ").append(tableName).append("\n               | ").toString())).stripMargin()).count());
        Dataset incrementalDF = $this.spark().read().format("hudi").option("hoodie.datasource.query.type", "incremental").option("hoodie.datasource.read.begin.instanttime", 0L).load(tablePath);
        incrementalDF.createOrReplaceTempView("tbl_incremental");
        Assertions.assertEquals((long)7L, (long)$this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n               | SELECT * from tbl_incremental\n               | ")).stripMargin()).count());
        $this.validateTsFieldSchema(tablePath, "ts", Schema.Type.INT);
    }

    public static final /* synthetic */ void $anonfun$new$46(TestSparkSqlWithCustomKeyGenerator $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        String writePartitionFields = "ts:timestamp";
        String dateFormat = "yyyy/MM/dd";
        Function1 & Serializable & scala.Serializable tsGenFunc = (Function1 & Serializable & scala.Serializable)ts -> (String)TestSparkSqlWithCustomKeyGenerator$.MODULE$.TS_FORMATTER_FUNC_WITH_FORMAT().apply(ts, (Object)dateFormat);
        Function2 & Serializable & scala.Serializable customPartitionFunc = (Function2 & Serializable & scala.Serializable)(ts, x$10) -> new StringBuilder(3).append("ts=").append(tsGenFunc.apply(ts)).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(901).append("\n           |create table ").append(tableName).append(" (\n           |  `id` INT,\n           |  `name` STRING,\n           |  `price` DECIMAL(5, 1),\n           |  `ts` INT,\n           |  `segment` STRING\n           |) using hudi\n           |tblproperties (\n           |  'primaryKey' = 'id,name',\n           |  'type' = 'mor',\n           |  'preCombineField'='name',\n           |  'hoodie.datasource.write.keygenerator.class' = '").append(TestSparkSqlWithCustomKeyGenerator$.MODULE$.CUSTOM_KEY_GEN_CLASS_NAME()).append("',\n           |  'hoodie.datasource.write.partitionpath.field' = '").append(writePartitionFields).append("',\n           |  'hoodie.insert.shuffle.parallelism' = '1',\n           |  'hoodie.upsert.shuffle.parallelism' = '1',\n           |  'hoodie.bulkinsert.shuffle.parallelism' = '1',\n           |  'hoodie.keygen.timebased.timestamp.type' = 'SCALAR',\n           |  'hoodie.keygen.timebased.output.dateformat' = '").append(dateFormat).append("',\n           |  'hoodie.keygen.timebased.timestamp.scalar.time.unit' = 'seconds'\n           |)\n           location '").append(tablePath).append("'\n           ").toString())).stripMargin());
        $this.testInserts(tableName, (Function1<Integer, String>)tsGenFunc, (Function2<Integer, String, String>)customPartitionFunc);
        $this.validateTsFieldSchema(tablePath, "ts", Schema.Type.INT);
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
        Assertions.assertEquals((Object)KeyGeneratorType.CUSTOM.getClassName(), (Object)metaClient.getTableConfig().getKeyGeneratorClassName());
    }

    public static final /* synthetic */ void $anonfun$validatePartitions$1(Seq actualPartitions$1, String dropped) {
        Assertions.assertFalse((boolean)actualPartitions$1.contains((Object)dropped));
    }

    public TestSparkSqlWithCustomKeyGenerator() {
        this.test("Test Spark SQL DML with custom key generator", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false}))).foreach((Function1 & Serializable & scala.Serializable)extractPartition -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.EXTRACT_PARTITION_VALUES_FROM_PARTITION_PATH().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)extractPartition)))}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestSparkSqlWithCustomKeyGenerator.$anonfun$new$4($this, tmp);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("TestSparkSqlWithCustomKeyGenerator.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("Test table property isolation for partition path field config with custom key generator", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false}))).foreach((Function1 & Serializable & scala.Serializable)extractPartition -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.EXTRACT_PARTITION_VALUES_FROM_PARTITION_PATH().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)extractPartition)))}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestSparkSqlWithCustomKeyGenerator.$anonfun$new$16($this, tmp);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("TestSparkSqlWithCustomKeyGenerator.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        this.test("Test wrong partition path field write config with custom key generator", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false}))).foreach((Function1 & Serializable & scala.Serializable)extractPartition -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.EXTRACT_PARTITION_VALUES_FROM_PARTITION_PATH().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)extractPartition)))}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestSparkSqlWithCustomKeyGenerator.$anonfun$new$25($this, tmp);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("TestSparkSqlWithCustomKeyGenerator.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
        this.test("Test query with custom key generator", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false}))).foreach((Function1 & Serializable & scala.Serializable)extractPartition -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.EXTRACT_PARTITION_VALUES_FROM_PARTITION_PATH().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)extractPartition)))}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestSparkSqlWithCustomKeyGenerator.$anonfun$new$34($this, tmp);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("TestSparkSqlWithCustomKeyGenerator.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
        this.test("Test query with custom key generator without partition path field config", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false}))).foreach((Function1 & Serializable & scala.Serializable)extractPartition -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.EXTRACT_PARTITION_VALUES_FROM_PARTITION_PATH().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)extractPartition)))}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestSparkSqlWithCustomKeyGenerator.$anonfun$new$41($this, tmp);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("TestSparkSqlWithCustomKeyGenerator.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
        this.test("Test create table with custom key generator", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSparkSqlWithCustomKeyGenerator.$anonfun$new$46(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSparkSqlWithCustomKeyGenerator.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
    }
}

