/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Dataset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class TestWriteClient
extends HoodieSparkClientTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInertsWithEmptyCommitsHavingWriterSchemaAsNull() throws Exception {
        HoodieWriteConfig.Builder cfgBuilder = this.getConfigBuilder().withAutoCommit(false);
        this.addConfigsForPopulateMetaFields(cfgBuilder, false);
        this.metaClient = HoodieTestUtils.init((String)this.basePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ, (Properties)cfgBuilder.build().getProps());
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfgBuilder.build());){
            String firstCommit = "001";
            int numRecords = 200;
            JavaRDD result = this.insertFirstBatch(cfgBuilder.build(), client, firstCommit, "000", numRecords, SparkRDDWriteClient::insert, false, false, numRecords, HoodieTestUtils.INSTANT_GENERATOR);
            Assertions.assertTrue((boolean)client.commit(firstCommit, (Object)result), (String)"Commit should succeed");
            cfgBuilder = this.getConfigBuilder(null).withAutoCommit(false);
            this.addConfigsForPopulateMetaFields(cfgBuilder, false);
            client = this.getHoodieWriteClient(cfgBuilder.build());
            String secondCommit = "002";
            client.startCommitWithTime(secondCommit);
            JavaRDD emptyRdd = this.context.emptyRDD();
            result = client.insert(emptyRdd, secondCommit);
            Assertions.assertTrue((boolean)client.commit(secondCommit, (Object)result), (String)"Commit should succeed");
            HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc, this.basePath);
            HoodieActiveTimeline timeline = metaClient.getActiveTimeline();
            HoodieCommitMetadata metadata = (HoodieCommitMetadata)metaClient.getCommitMetadataSerDe().deserialize((HoodieInstant)timeline.lastInstant().get(), (byte[])timeline.getInstantDetails((HoodieInstant)timeline.lastInstant().get()).get(), HoodieCommitMetadata.class);
            Assertions.assertTrue((boolean)((String)metadata.getExtraMetadata().get("schema")).isEmpty());
            TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(metaClient);
            Assertions.assertEquals((Object)Schema.parse((String)"{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}"), (Object)tableSchemaResolver.getTableAvroSchema(false));
            Dataset df = this.sparkSession.read().format("hudi").load(this.basePath);
            Assertions.assertEquals((int)numRecords, (int)df.collectAsList().size());
        }
    }
}

