/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional.cdc;

import java.io.Serializable;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.cdc.HoodieCDCSupplementalLoggingMode;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.cdc.HoodieCDCTestBase;
import org.apache.hudi.functional.cdc.TestCDCStreamingSuite$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y2Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)q\u0003\u0001C\u00011\t)B+Z:u\u0007\u0012\u001b5\u000b\u001e:fC6LgnZ*vSR,'BA\u0003\u0007\u0003\r\u0019Gm\u0019\u0006\u0003\u000f!\t!BZ;oGRLwN\\1m\u0015\tI!\"\u0001\u0003ik\u0012L'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\t%\u00111\u0003\u0002\u0002\u0012\u0011>|G-[3D\t\u000e#Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u0017!\t\t\u0002!\u0001\u0007dI\u000e\u001cFO]3b[&tw\r\u0006\u0002\u001a?A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t!QK\\5u\u0011\u0015\u0001#\u00011\u0001\"\u0003-awnZ4j]\u001elu\u000eZ3\u0011\u0005\tBS\"A\u0012\u000b\u0005\u0015!#BA\u0013'\u0003\u0015!\u0018M\u00197f\u0015\t9\u0003\"\u0001\u0004d_6lwN\\\u0005\u0003S\r\u0012\u0001\u0005S8pI&,7\tR\"TkB\u0004H.Z7f]R\fG\u000eT8hO&tw-T8eK\"\"!aK\u001c9!\taS'D\u0001.\u0015\tqs&\u0001\u0005qe>4\u0018\u000eZ3s\u0015\t\u0001\u0014'\u0001\u0004qCJ\fWn\u001d\u0006\u0003eM\nqA[;qSR,'O\u0003\u00025\u0019\u0005)!.\u001e8ji&\u0011a'\f\u0002\u000b\u000b:,XnU8ve\u000e,\u0017!\u0002<bYV,7%A\u0011)\u0005\tQ\u0004CA\u001e=\u001b\u0005y\u0013BA\u001f0\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e")
public class TestCDCStreamingSuite
extends HoodieCDCTestBase {
    @ParameterizedTest
    @EnumSource(value=HoodieCDCSupplementalLoggingMode.class)
    public void cdcStreaming(HoodieCDCSupplementalLoggingMode loggingMode) {
        scala.collection.immutable.Map commonOptions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.delete.shuffle.parallelism"), (Object)"1")}));
        SparkSession _spark = this.spark();
        String userToCountryTblPath = new StringBuilder(22).append(this.basePath).append("/user_to_country_table").toString();
        String countryToPopulationTblPath = new StringBuilder(28).append(this.basePath).append("/country_to_population_table").toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCDCStreamingSuite.class.getClassLoader());
        public final class Org_apache_hudi_functional_cdc_TestCDCStreamingSuite$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Org_apache_hudi_functional_cdc_TestCDCStreamingSuite$$typecreator6$1(TestCDCStreamingSuite $outer) {
            }
        }
        Dataset userToCountryDF = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"US", (Object)"1000"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"US", (Object)"1000"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"China", (Object)"1000"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"Singapore", (Object)"1000"), (List)Nil$.MODULE$)))), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_cdc_TestCDCStreamingSuite$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"userid", "country", "ts"}));
        userToCountryDF.write().format("hudi").options((Map)commonOptions).option(HoodieTableConfig.CDC_ENABLED.key(), "true").option(HoodieTableConfig.CDC_SUPPLEMENTAL_LOGGING_MODE.key(), loggingMode.name()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "userid").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(HoodieWriteConfig.TBL_NAME.key(), "user_to_country").save(userToCountryTblPath);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestCDCStreamingSuite.class.getClassLoader());
        public final class Org_apache_hudi_functional_cdc_TestCDCStreamingSuite$$typecreator16$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Org_apache_hudi_functional_cdc_TestCDCStreamingSuite$$typecreator16$1(TestCDCStreamingSuite $outer) {
            }
        }
        Dataset countryToPopulationDF = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)"US", (Object)BoxesRunTime.boxToInteger((int)200), (Object)"1000"), (List)new .colon.colon((Object)new Tuple3((Object)"China", (Object)BoxesRunTime.boxToInteger((int)50), (Object)"1000"), (List)new .colon.colon((Object)new Tuple3((Object)"Singapore", (Object)BoxesRunTime.boxToInteger((int)20), (Object)"1000"), (List)Nil$.MODULE$))), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_functional_cdc_TestCDCStreamingSuite$$typecreator16$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"country", "population", "ts"}));
        countryToPopulationDF.write().format("hudi").options((Map)commonOptions).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "country").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(HoodieWriteConfig.TBL_NAME.key(), "country_to_population").save(countryToPopulationTblPath);
        HoodieTableMetaClient userToCountryMetaClient = this.createMetaClient(this.spark(), userToCountryTblPath);
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(TestCDCStreamingSuite.class.getClassLoader());
        public final class Org_apache_hudi_functional_cdc_TestCDCStreamingSuite$$typecreator21$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$))));
            }

            public Org_apache_hudi_functional_cdc_TestCDCStreamingSuite$$typecreator21$1(TestCDCStreamingSuite $outer) {
            }
        }
        MemoryStream inputData = new MemoryStream(100, this.spark().sqlContext(), MemoryStream$.MODULE$.$lessinit$greater$default$3(), _spark.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_hudi_functional_cdc_TestCDCStreamingSuite$$typecreator21$1(null))));
        Dataset df = inputData.toDS().toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"userid", "country", "ts"}));
        StreamingQuery stream1 = df.writeStream().format("hudi").foreachBatch((Function2 & Serializable & scala.Serializable)(batch, id) -> {
            TestCDCStreamingSuite.$anonfun$cdcStreaming$1(commonOptions, userToCountryTblPath, batch, BoxesRunTime.unboxToLong((Object)id));
            return BoxedUnit.UNIT;
        }).start();
        Expression dec = functions$.MODULE$.typedLit((Object)BoxesRunTime.boxToInteger((int)-1), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int()).expr();
        Expression inc = functions$.MODULE$.typedLit((Object)BoxesRunTime.boxToInteger((int)1), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int()).expr();
        Expression zero = functions$.MODULE$.typedLit((Object)BoxesRunTime.boxToInteger((int)0), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int()).expr();
        If beforeCntExpr = new If(functions$.MODULE$.isnull(functions$.MODULE$.col("bcountry")).expr(), zero, dec);
        If afterCntExpr = new If(functions$.MODULE$.isnull(functions$.MODULE$.col("acountry")).expr(), zero, inc);
        StreamingQuery stream2 = this.spark().readStream().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.INCREMENTAL_FORMAT().key(), DataSourceReadOptions$.MODULE$.INCREMENTAL_FORMAT_CDC_VAL()).load(userToCountryTblPath).writeStream().format("hudi").foreachBatch((Function2 & Serializable & scala.Serializable)(batch, id) -> {
            TestCDCStreamingSuite.$anonfun$cdcStreaming$2(this, countryToPopulationTblPath, beforeCntExpr, afterCntExpr, commonOptions, batch, BoxesRunTime.unboxToLong((Object)id));
            return BoxedUnit.UNIT;
        }).start();
        inputData.addData((TraversableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"US", (Object)"1100"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"US", (Object)"1100"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)5), (Object)"US", (Object)"1100"), (List)Nil$.MODULE$))));
        stream1.processAllAvailable();
        stream2.processAllAvailable();
        Dataset detailOutput1 = this.spark().read().format("hudi").load(userToCountryTblPath);
        Predef$.MODULE$.assert(detailOutput1.where("country = 'US'").count() == 5L);
        String ucTs1 = ((HoodieInstant)userToCountryMetaClient.reloadActiveTimeline().lastInstant().get()).requestedTime();
        Dataset<Row> ucDdcData1 = this.cdcDataFrame(userToCountryTblPath, Long.toString(new StringOps(Predef$.MODULE$.augmentString(ucTs1)).toLong() - 1L), null);
        ucDdcData1.show(false);
        this.assertCDCOpCnt(ucDdcData1, 1L, 2L, 0L);
        Seq countryRes1 = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"China", BoxesRunTime.boxToInteger((int)50)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Singapore", BoxesRunTime.boxToInteger((int)20)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US", BoxesRunTime.boxToInteger((int)205)})), (List)Nil$.MODULE$)));
        Dataset currentCP = this.spark().read().format("hudi").load(countryToPopulationTblPath).select("country", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"population"})).sort("country", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        QueryTest$.MODULE$.checkAnswer(currentCP, countryRes1, QueryTest$.MODULE$.checkAnswer$default$3());
        inputData.addData((TraversableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"Singapore", (Object)"1200"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)7), (Object)"Canada", (Object)"1200"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)8), (Object)"Singapore", (Object)"1200"), (List)Nil$.MODULE$))));
        stream1.processAllAvailable();
        stream2.processAllAvailable();
        String ts2 = ((HoodieInstant)userToCountryMetaClient.reloadActiveTimeline().lastInstant().get()).requestedTime();
        Dataset<Row> cdcData2 = this.cdcDataFrame(userToCountryTblPath, Long.toString(new StringOps(Predef$.MODULE$.augmentString(ts2)).toLong() - 1L), null);
        cdcData2.show(false);
        this.assertCDCOpCnt(cdcData2, 2L, 1L, 0L);
        Seq countryRes2 = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Canada", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"China", BoxesRunTime.boxToInteger((int)50)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Singapore", BoxesRunTime.boxToInteger((int)22)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"US", BoxesRunTime.boxToInteger((int)204)})), (List)Nil$.MODULE$))));
        currentCP = this.spark().read().format("hudi").load(countryToPopulationTblPath).select("country", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"population"})).sort("country", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        QueryTest$.MODULE$.checkAnswer(currentCP, countryRes2, QueryTest$.MODULE$.checkAnswer$default$3());
        stream1.stop();
        stream2.stop();
    }

    public static final /* synthetic */ void $anonfun$cdcStreaming$1(scala.collection.immutable.Map commonOptions$1, String userToCountryTblPath$1, Dataset batch, long id) {
        batch.write().format("hudi").options((Map)commonOptions$1).option(HoodieTableConfig.CDC_ENABLED.key(), "true").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "userid").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(HoodieWriteConfig.TBL_NAME.key(), "user_to_country").mode(SaveMode.Append).save(userToCountryTblPath$1);
    }

    public static final /* synthetic */ void $anonfun$cdcStreaming$2(TestCDCStreamingSuite $this, String countryToPopulationTblPath$1, If beforeCntExpr$1, If afterCntExpr$1, scala.collection.immutable.Map commonOptions$1, Dataset batch, long id) {
        Dataset current = $this.spark().read().format("hudi").load(countryToPopulationTblPath$1);
        batch.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.get_json_object(functions$.MODULE$.col("before"), "$.country").as("bcountry"), functions$.MODULE$.get_json_object(functions$.MODULE$.col("after"), "$.country").as("acountry"), functions$.MODULE$.get_json_object(functions$.MODULE$.col("after"), "$.ts").as("ts")})).withColumn("bcnt", new Column((Expression)beforeCntExpr$1)).withColumn("acnt", new Column((Expression)afterCntExpr$1)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("bcountry").as("country"), functions$.MODULE$.col("bcnt").as("cnt"), functions$.MODULE$.col("ts")})), functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("acountry").as("country"), functions$.MODULE$.col("acnt").as("cnt"), functions$.MODULE$.col("ts")}))})))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("col.country").as("country"), functions$.MODULE$.col("col.cnt").as("cnt"), functions$.MODULE$.col("col.ts").as("ts")})).where("country is not null").groupBy("country", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cnt"), (Object)"sum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ts"), (Object)"max")})).join(current, (Seq)new .colon.colon((Object)"country", (List)Nil$.MODULE$), "left").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("country"), new Column((Expression)new Add(functions$.MODULE$.col("sum(cnt)").expr(), (Expression)new If(functions$.MODULE$.isnull(functions$.MODULE$.col("population")).expr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), functions$.MODULE$.col("population").expr()), Add$.MODULE$.apply$default$3())).as("population"), functions$.MODULE$.col("max(ts)").as("ts")})).write().format("hudi").options((Map)commonOptions$1).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "country").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(HoodieWriteConfig.TBL_NAME.key(), "country_to_population").mode(SaveMode.Append).save(countryToPopulationTblPath$1);
    }
}

