/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import junit.framework.TestCase;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.testutils.KeyGeneratorTestUtilities;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestComplexKeyGenerator
extends KeyGeneratorTestUtilities {
    private TypedProperties getCommonProps(boolean getComplexRecordKey) {
        TypedProperties properties = new TypedProperties();
        if (getComplexRecordKey) {
            properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key, pii_col");
        } else {
            properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key");
        }
        properties.put((Object)KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
        return properties;
    }

    private TypedProperties getPropertiesWithoutPartitionPathProp() {
        return this.getCommonProps(false);
    }

    private TypedProperties getPropertiesWithoutRecordKeyProp() {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp");
        return properties;
    }

    private TypedProperties getWrongRecordKeyFieldProps() {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp");
        properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_wrong_key");
        return properties;
    }

    private TypedProperties getProps() {
        TypedProperties properties = this.getCommonProps(true);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp,ts_ms");
        return properties;
    }

    @Test
    public void testNullPartitionPathFields() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ComplexKeyGenerator(this.getPropertiesWithoutPartitionPathProp()));
    }

    @Test
    public void testNullRecordKeyFields() {
        GenericRecord record = TestComplexKeyGenerator.getRecord();
        Assertions.assertThrows(HoodieKeyException.class, () -> {
            ComplexKeyGenerator keyGenerator = new ComplexKeyGenerator(this.getPropertiesWithoutRecordKeyProp());
            keyGenerator.getRecordKey(record);
        });
    }

    @Test
    public void testWrongRecordKeyField() {
        ComplexKeyGenerator keyGenerator = new ComplexKeyGenerator(this.getWrongRecordKeyFieldProps());
        Assertions.assertThrows(HoodieKeyException.class, () -> keyGenerator.getRecordKey(TestComplexKeyGenerator.getRecord()));
    }

    @Test
    public void testHappyFlow() {
        ComplexKeyGenerator keyGenerator = new ComplexKeyGenerator(this.getProps());
        GenericRecord record = TestComplexKeyGenerator.getRecord();
        HoodieKey key = keyGenerator.getKey(record);
        Assertions.assertEquals((Object)key.getRecordKey(), (Object)"_row_key:key1,pii_col:pi");
        Assertions.assertEquals((Object)key.getPartitionPath(), (Object)"timestamp=4357686/ts_ms=2020-03-21");
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)keyGenerator.getRecordKey(row), (Object)"_row_key:key1,pii_col:pi");
        Assertions.assertEquals((Object)keyGenerator.getPartitionPath(row), (Object)"timestamp=4357686/ts_ms=2020-03-21");
        InternalRow internalRow = KeyGeneratorTestUtilities.getInternalRow(row);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"timestamp=4357686/ts_ms=2020-03-21"), (Object)keyGenerator.getPartitionPath(internalRow, row.schema()));
    }

    @Test
    public void testSingleValueKeyGenerator() {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "_row_key");
        properties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "timestamp");
        ComplexKeyGenerator compositeKeyGenerator = new ComplexKeyGenerator(properties);
        TestCase.assertEquals((int)compositeKeyGenerator.getRecordKeyFieldNames().size(), (int)1);
        TestCase.assertEquals((int)compositeKeyGenerator.getPartitionPathFields().size(), (int)1);
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        GenericRecord record = (GenericRecord)dataGenerator.generateGenericRecords(1).get(0);
        String rowKey = record.get("_row_key").toString();
        String partitionPath = record.get("timestamp").toString();
        HoodieKey hoodieKey = compositeKeyGenerator.getKey(record);
        TestCase.assertEquals((String)rowKey, (String)hoodieKey.getRecordKey());
        TestCase.assertEquals((String)partitionPath, (String)hoodieKey.getPartitionPath());
        Row row = KeyGeneratorTestUtilities.getRow(record, HoodieTestDataGenerator.AVRO_SCHEMA, AvroConversionUtils.convertAvroSchemaToStructType((Schema)HoodieTestDataGenerator.AVRO_SCHEMA));
        Assertions.assertEquals((Object)partitionPath, (Object)compositeKeyGenerator.getPartitionPath(row));
        InternalRow internalRow = KeyGeneratorTestUtilities.getInternalRow(row);
        Assertions.assertEquals((Object)UTF8String.fromString((String)partitionPath), (Object)compositeKeyGenerator.getPartitionPath(internalRow, row.schema()));
    }

    @Test
    public void testMultipleValueKeyGenerator() {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "_row_key,timestamp");
        properties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "rider,driver");
        ComplexKeyGenerator compositeKeyGenerator = new ComplexKeyGenerator(properties);
        TestCase.assertEquals((int)compositeKeyGenerator.getRecordKeyFieldNames().size(), (int)2);
        TestCase.assertEquals((int)compositeKeyGenerator.getPartitionPathFields().size(), (int)2);
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        GenericRecord record = (GenericRecord)dataGenerator.generateGenericRecords(1).get(0);
        String rowKey = "_row_key:" + record.get("_row_key").toString() + ",timestamp" + ":" + record.get("timestamp").toString();
        String partitionPath = record.get("rider").toString() + "/" + record.get("driver").toString();
        HoodieKey hoodieKey = compositeKeyGenerator.getKey(record);
        TestCase.assertEquals((String)rowKey, (String)hoodieKey.getRecordKey());
        TestCase.assertEquals((String)partitionPath, (String)hoodieKey.getPartitionPath());
        Row row = KeyGeneratorTestUtilities.getRow(record, HoodieTestDataGenerator.AVRO_SCHEMA, AvroConversionUtils.convertAvroSchemaToStructType((Schema)HoodieTestDataGenerator.AVRO_SCHEMA));
        Assertions.assertEquals((Object)partitionPath, (Object)compositeKeyGenerator.getPartitionPath(row));
        InternalRow internalRow = KeyGeneratorTestUtilities.getInternalRow(row);
        Assertions.assertEquals((Object)UTF8String.fromString((String)partitionPath), (Object)compositeKeyGenerator.getPartitionPath(internalRow, row.schema()));
    }

    @Test
    public void testMultipleValueKeyGeneratorNonPartitioned() {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "_row_key,timestamp");
        properties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "");
        ComplexKeyGenerator compositeKeyGenerator = new ComplexKeyGenerator(properties);
        TestCase.assertEquals((int)compositeKeyGenerator.getRecordKeyFieldNames().size(), (int)2);
        TestCase.assertEquals((int)compositeKeyGenerator.getPartitionPathFields().size(), (int)0);
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        GenericRecord record = (GenericRecord)dataGenerator.generateGenericRecords(1).get(0);
        String rowKey = "_row_key:" + record.get("_row_key").toString() + ",timestamp" + ":" + record.get("timestamp").toString();
        String partitionPath = "";
        HoodieKey hoodieKey = compositeKeyGenerator.getKey(record);
        TestCase.assertEquals((String)rowKey, (String)hoodieKey.getRecordKey());
        TestCase.assertEquals((String)partitionPath, (String)hoodieKey.getPartitionPath());
        Row row = KeyGeneratorTestUtilities.getRow(record, HoodieTestDataGenerator.AVRO_SCHEMA, AvroConversionUtils.convertAvroSchemaToStructType((Schema)HoodieTestDataGenerator.AVRO_SCHEMA));
        Assertions.assertEquals((Object)partitionPath, (Object)compositeKeyGenerator.getPartitionPath(row));
        InternalRow internalRow = KeyGeneratorTestUtilities.getInternalRow(row);
        Assertions.assertEquals((Object)UTF8String.fromString((String)partitionPath), (Object)compositeKeyGenerator.getPartitionPath(internalRow, row.schema()));
    }
}

