/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.CustomAvroKeyGenerator;
import org.apache.hudi.keygen.CustomKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.testutils.KeyGeneratorTestUtilities;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCustomKeyGenerator
extends KeyGeneratorTestUtilities {
    private TypedProperties getCommonProps(boolean getComplexRecordKey, boolean useKeyGeneratorClassName) {
        TypedProperties properties = new TypedProperties();
        if (getComplexRecordKey) {
            properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key, pii_col");
        } else {
            properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key");
        }
        if (useKeyGeneratorClassName) {
            properties.put((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), (Object)CustomKeyGenerator.class.getName());
        } else {
            properties.put((Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key(), (Object)KeyGeneratorType.CUSTOM.name());
        }
        properties.put((Object)KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
        return properties;
    }

    private TypedProperties getPropertiesForSimpleKeyGen(boolean useKeyGeneratorClassName) {
        TypedProperties properties = this.getCommonProps(false, useKeyGeneratorClassName);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp:simple");
        return properties;
    }

    private TypedProperties getImproperPartitionFieldFormatProp(boolean useKeyGeneratorClassName) {
        TypedProperties properties = this.getCommonProps(false, useKeyGeneratorClassName);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp");
        return properties;
    }

    private TypedProperties getInvalidPartitionKeyTypeProps(boolean useKeyGeneratorClassName) {
        TypedProperties properties = this.getCommonProps(false, useKeyGeneratorClassName);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp:dummy");
        return properties;
    }

    private TypedProperties getComplexRecordKeyWithSimplePartitionProps(boolean useKeyGeneratorClassName) {
        TypedProperties properties = this.getCommonProps(true, useKeyGeneratorClassName);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp:simple");
        return properties;
    }

    private TypedProperties getComplexRecordKeyAndPartitionPathProps(boolean useKeyGeneratorClassName) {
        TypedProperties properties = this.getCommonProps(true, useKeyGeneratorClassName);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp:simple,ts_ms:timestamp");
        this.populateNecessaryPropsForTimestampBasedKeyGen(properties);
        return properties;
    }

    private TypedProperties getPropsWithoutRecordKeyFieldProps(boolean useKeyGeneratorClassName) {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp:simple");
        if (useKeyGeneratorClassName) {
            properties.put((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), (Object)CustomKeyGenerator.class.getName());
        } else {
            properties.put((Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key(), (Object)KeyGeneratorType.CUSTOM.name());
        }
        return properties;
    }

    private void populateNecessaryPropsForTimestampBasedKeyGen(TypedProperties properties) {
        properties.put((Object)"hoodie.deltastreamer.keygen.timebased.timestamp.type", (Object)"DATE_STRING");
        properties.put((Object)"hoodie.deltastreamer.keygen.timebased.input.dateformat", (Object)"yyyy-MM-dd");
        properties.put((Object)"hoodie.deltastreamer.keygen.timebased.output.dateformat", (Object)"yyyyMMdd");
    }

    private TypedProperties getPropertiesForTimestampBasedKeyGen(boolean useKeyGeneratorClassName) {
        TypedProperties properties = this.getCommonProps(false, useKeyGeneratorClassName);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"ts_ms:timestamp");
        this.populateNecessaryPropsForTimestampBasedKeyGen(properties);
        return properties;
    }

    private TypedProperties getPropertiesForNonPartitionedKeyGen(boolean useKeyGeneratorClassName) {
        TypedProperties properties = this.getCommonProps(false, useKeyGeneratorClassName);
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"");
        return properties;
    }

    private String stackTraceToString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    @Test
    public void testSimpleKeyGeneratorWithKeyGeneratorClass() throws IOException {
        this.testSimpleKeyGenerator(this.getPropertiesForSimpleKeyGen(true));
    }

    @Test
    public void testSimpleKeyGeneratorWithKeyGeneratorType() throws IOException {
        this.testSimpleKeyGenerator(this.getPropertiesForSimpleKeyGen(false));
    }

    public void testSimpleKeyGenerator(TypedProperties props) throws IOException {
        BuiltinKeyGenerator keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        GenericRecord record = TestCustomKeyGenerator.getRecord();
        HoodieKey key = keyGenerator.getKey(record);
        Assertions.assertEquals((Object)"key1", (Object)key.getRecordKey());
        Assertions.assertEquals((Object)"timestamp=4357686", (Object)key.getPartitionPath());
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)"key1", (Object)keyGenerator.getRecordKey(row));
        Assertions.assertEquals((Object)"timestamp=4357686", (Object)keyGenerator.getPartitionPath(row));
        InternalRow internalRow = KeyGeneratorTestUtilities.getInternalRow(row);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"timestamp=4357686"), (Object)keyGenerator.getPartitionPath(internalRow, row.schema()));
    }

    @Test
    public void testTimestampBasedKeyGeneratorWithKeyGeneratorClass() throws IOException {
        this.testTimestampBasedKeyGenerator(this.getPropertiesForTimestampBasedKeyGen(true));
    }

    @Test
    public void testTimestampBasedKeyGeneratorWithKeyGeneratorType() throws IOException {
        this.testTimestampBasedKeyGenerator(this.getPropertiesForTimestampBasedKeyGen(false));
    }

    @Test
    public void testCustomKeyGeneratorPartitionType() {
        HoodieTableConfig tableConfig = new HoodieTableConfig();
        tableConfig.setValue(HoodieTableConfig.PARTITION_FIELDS.key(), "random:simple,ts_ms:timestamp");
        Object[] partitionTypes = CustomAvroKeyGenerator.getPartitionTypes((HoodieTableConfig)tableConfig).toArray();
        Assertions.assertArrayEquals((Object[])new CustomAvroKeyGenerator.PartitionKeyType[]{CustomAvroKeyGenerator.PartitionKeyType.SIMPLE, CustomAvroKeyGenerator.PartitionKeyType.TIMESTAMP}, (Object[])partitionTypes);
        Pair partitionFieldAndType = CustomAvroKeyGenerator.getPartitionFieldAndKeyType((String)"random:simple");
        Assertions.assertEquals((Object)Pair.of((Object)"random", (Object)Option.of((Object)CustomAvroKeyGenerator.PartitionKeyType.SIMPLE)), (Object)partitionFieldAndType);
    }

    @Test
    public void testCustomKeyGeneratorTimestampFieldsAPI() {
        HoodieTableConfig tableConfig = new HoodieTableConfig();
        tableConfig.setValue(HoodieTableConfig.PARTITION_FIELDS.key(), "simple1:simple,ts1:timestamp,ts2:timestamp");
        Object[] timestampFields = ((List)CustomAvroKeyGenerator.getTimestampFields((HoodieTableConfig)tableConfig).get()).toArray();
        Assertions.assertArrayEquals((Object[])new String[]{"ts1", "ts2"}, (Object[])timestampFields);
        tableConfig.setValue(HoodieTableConfig.PARTITION_FIELDS.key(), "simple1,ts1,ts2");
        Option timestampFieldsOpt = CustomAvroKeyGenerator.getTimestampFields((HoodieTableConfig)tableConfig);
        Assertions.assertTrue((boolean)timestampFieldsOpt.isEmpty());
        tableConfig.setValue(HoodieTableConfig.PARTITION_FIELDS.key(), "simple1:simple,simple2:simple,simple3:simple");
        timestampFields = ((List)CustomAvroKeyGenerator.getTimestampFields((HoodieTableConfig)tableConfig).get()).toArray();
        Assertions.assertEquals((int)0, (int)timestampFields.length);
    }

    public void testTimestampBasedKeyGenerator(TypedProperties props) throws IOException {
        BuiltinKeyGenerator keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        GenericRecord record = TestCustomKeyGenerator.getRecord();
        HoodieKey key = keyGenerator.getKey(record);
        Assertions.assertEquals((Object)"key1", (Object)key.getRecordKey());
        Assertions.assertEquals((Object)"ts_ms=20200321", (Object)key.getPartitionPath());
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)"key1", (Object)keyGenerator.getRecordKey(row));
        Assertions.assertEquals((Object)"ts_ms=20200321", (Object)keyGenerator.getPartitionPath(row));
        InternalRow internalRow = KeyGeneratorTestUtilities.getInternalRow(row);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"ts_ms=20200321"), (Object)keyGenerator.getPartitionPath(internalRow, row.schema()));
    }

    @Test
    public void testNonPartitionedKeyGeneratorWithKeyGeneratorClass() throws IOException {
        this.testNonPartitionedKeyGenerator(this.getPropertiesForNonPartitionedKeyGen(true));
    }

    @Test
    public void testNonPartitionedKeyGeneratorWithKeyGeneratorType() throws IOException {
        this.testNonPartitionedKeyGenerator(this.getPropertiesForNonPartitionedKeyGen(false));
    }

    public void testNonPartitionedKeyGenerator(TypedProperties props) throws IOException {
        BuiltinKeyGenerator keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        GenericRecord record = TestCustomKeyGenerator.getRecord();
        HoodieKey key = keyGenerator.getKey(record);
        Assertions.assertEquals((Object)key.getRecordKey(), (Object)"key1");
        Assertions.assertTrue((boolean)key.getPartitionPath().isEmpty());
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)keyGenerator.getRecordKey(row), (Object)"key1");
        Assertions.assertTrue((boolean)keyGenerator.getPartitionPath(row).isEmpty());
        InternalRow internalRow = KeyGeneratorTestUtilities.getInternalRow(row);
        Assertions.assertEquals((int)0, (int)keyGenerator.getPartitionPath(internalRow, row.schema()).numBytes());
    }

    @Test
    public void testInvalidPartitionKeyTypeWithKeyGeneratorClass() {
        this.testInvalidPartitionKeyType(this.getInvalidPartitionKeyTypeProps(true));
    }

    @Test
    public void testInvalidPartitionKeyTypeWithKeyGeneratorType() {
        this.testInvalidPartitionKeyType(this.getInvalidPartitionKeyTypeProps(false));
    }

    public void testInvalidPartitionKeyType(TypedProperties props) {
        BuiltinKeyGenerator keyGenerator;
        try {
            keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
            keyGenerator.getKey(TestCustomKeyGenerator.getRecord());
            Assertions.fail((String)"should fail when invalid PartitionKeyType is provided!");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)TestCustomKeyGenerator.getNestedConstructorErrorCause(e).getMessage().contains("No enum constant org.apache.hudi.keygen.CustomAvroKeyGenerator.PartitionKeyType.DUMMY"));
        }
        try {
            keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
            GenericRecord record = TestCustomKeyGenerator.getRecord();
            Row row = KeyGeneratorTestUtilities.getRow(record);
            keyGenerator.getPartitionPath(row);
            Assertions.fail((String)"should fail when invalid PartitionKeyType is provided!");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)TestCustomKeyGenerator.getNestedConstructorErrorCause(e).getMessage().contains("No enum constant org.apache.hudi.keygen.CustomAvroKeyGenerator.PartitionKeyType.DUMMY"));
        }
    }

    @Test
    public void testNoRecordKeyFieldPropWithKeyGeneratorClass() {
        this.testNoRecordKeyFieldProp(true);
    }

    @Test
    public void testNoRecordKeyFieldPropWithKeyGeneratorType() {
        this.testNoRecordKeyFieldProp(false);
    }

    public void testNoRecordKeyFieldProp(boolean useKeyGeneratorClassName) {
        CustomKeyGenerator keyGenerator;
        TypedProperties propsWithoutRecordKeyFieldProps = this.getPropsWithoutRecordKeyFieldProps(useKeyGeneratorClassName);
        try {
            keyGenerator = new CustomKeyGenerator(propsWithoutRecordKeyFieldProps);
            keyGenerator.getKey(TestCustomKeyGenerator.getRecord());
            Assertions.fail((String)"should fail when record key field is not provided!");
        }
        catch (Exception e) {
            if (useKeyGeneratorClassName) {
                Assertions.assertTrue((boolean)e.getMessage().contains("Unable to find field names for record key in cfg"));
            }
            Assertions.assertTrue((boolean)this.stackTraceToString(e).contains("Unable to find field names for record key in cfg"));
        }
        try {
            keyGenerator = new CustomKeyGenerator(propsWithoutRecordKeyFieldProps);
            GenericRecord record = TestCustomKeyGenerator.getRecord();
            Row row = KeyGeneratorTestUtilities.getRow(record);
            keyGenerator.getRecordKey(row);
            Assertions.fail((String)"should fail when record key field is not provided!");
        }
        catch (Exception e) {
            if (useKeyGeneratorClassName) {
                Assertions.assertTrue((boolean)e.getMessage().contains("All of the values for ([]) were either null or empty"));
            }
            Assertions.assertTrue((boolean)this.stackTraceToString(e).contains("All of the values for ([]) were either null or empty"));
        }
    }

    @Test
    public void testPartitionFieldsInImproperFormatWithKeyGeneratorClass() {
        this.testPartitionFieldsInImproperFormat(this.getImproperPartitionFieldFormatProp(true));
    }

    @Test
    public void testPartitionFieldsInImproperFormatWithKeyGeneratorType() {
        this.testPartitionFieldsInImproperFormat(this.getImproperPartitionFieldFormatProp(false));
    }

    public void testPartitionFieldsInImproperFormat(TypedProperties props) {
        BuiltinKeyGenerator keyGenerator;
        try {
            keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
            keyGenerator.getKey(TestCustomKeyGenerator.getRecord());
            Assertions.fail((String)"should fail when partition key field is provided in improper format!");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)TestCustomKeyGenerator.getNestedConstructorErrorCause(e).getMessage().contains("Unable to find field names for partition path in proper format"));
        }
        try {
            keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
            GenericRecord record = TestCustomKeyGenerator.getRecord();
            Row row = KeyGeneratorTestUtilities.getRow(record);
            keyGenerator.getPartitionPath(row);
            Assertions.fail((String)"should fail when partition key field is provided in improper format!");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)TestCustomKeyGenerator.getNestedConstructorErrorCause(e).getMessage().contains("Unable to find field names for partition path in proper format"));
        }
    }

    @Test
    public void testComplexRecordKeyWithSimplePartitionPathWithKeyGeneratorClass() throws IOException {
        this.testComplexRecordKeyWithSimplePartitionPath(this.getComplexRecordKeyWithSimplePartitionProps(true));
    }

    @Test
    public void testComplexRecordKeyWithSimplePartitionPathWithKeyGeneratorType() throws IOException {
        this.testComplexRecordKeyWithSimplePartitionPath(this.getComplexRecordKeyWithSimplePartitionProps(false));
    }

    public void testComplexRecordKeyWithSimplePartitionPath(TypedProperties props) throws IOException {
        BuiltinKeyGenerator keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        GenericRecord record = TestCustomKeyGenerator.getRecord();
        HoodieKey key = keyGenerator.getKey(record);
        Assertions.assertEquals((Object)"_row_key:key1,pii_col:pi", (Object)key.getRecordKey());
        Assertions.assertEquals((Object)"timestamp=4357686", (Object)key.getPartitionPath());
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)"_row_key:key1,pii_col:pi", (Object)keyGenerator.getRecordKey(row));
        Assertions.assertEquals((Object)"timestamp=4357686", (Object)keyGenerator.getPartitionPath(row));
        InternalRow internalRow = KeyGeneratorTestUtilities.getInternalRow(row);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"timestamp=4357686"), (Object)keyGenerator.getPartitionPath(internalRow, row.schema()));
    }

    @Test
    public void testComplexRecordKeysWithComplexPartitionPathWithKeyGeneratorClass() throws IOException {
        this.testComplexRecordKeysWithComplexPartitionPath(this.getComplexRecordKeyAndPartitionPathProps(true));
    }

    @Test
    public void testComplexRecordKeysWithComplexPartitionPathWithKeyGeneratorType() throws IOException {
        this.testComplexRecordKeysWithComplexPartitionPath(this.getComplexRecordKeyAndPartitionPathProps(false));
    }

    public void testComplexRecordKeysWithComplexPartitionPath(TypedProperties props) throws IOException {
        BuiltinKeyGenerator keyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        GenericRecord record = TestCustomKeyGenerator.getRecord();
        HoodieKey key = keyGenerator.getKey(record);
        Assertions.assertEquals((Object)"_row_key:key1,pii_col:pi", (Object)key.getRecordKey());
        Assertions.assertEquals((Object)"timestamp=4357686/ts_ms=20200321", (Object)key.getPartitionPath());
        Row row = KeyGeneratorTestUtilities.getRow(record);
        Assertions.assertEquals((Object)"_row_key:key1,pii_col:pi", (Object)keyGenerator.getRecordKey(row));
        Assertions.assertEquals((Object)"timestamp=4357686/ts_ms=20200321", (Object)keyGenerator.getPartitionPath(row));
        InternalRow internalRow = KeyGeneratorTestUtilities.getInternalRow(row);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"timestamp=4357686/ts_ms=20200321"), (Object)keyGenerator.getPartitionPath(internalRow, row.schema()));
    }

    private static Throwable getNestedConstructorErrorCause(Exception e) {
        return e.getCause().getCause();
    }
}

