/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.factory;

import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.CustomKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieSparkKeyGeneratorFactory {
    @Test
    public void testInferKeyGeneratorTypeFromWriteConfig() {
        Assertions.assertEquals((Object)KeyGeneratorType.NON_PARTITION, (Object)HoodieSparkKeyGeneratorFactory.inferKeyGeneratorTypeFromWriteConfig((TypedProperties)new TypedProperties()));
        TypedProperties props = this.getCommonProps();
        Assertions.assertEquals((Object)KeyGeneratorType.SIMPLE, (Object)HoodieSparkKeyGeneratorFactory.inferKeyGeneratorTypeFromWriteConfig((TypedProperties)props));
        props.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key,ts");
        Assertions.assertEquals((Object)KeyGeneratorType.COMPLEX, (Object)HoodieSparkKeyGeneratorFactory.inferKeyGeneratorTypeFromWriteConfig((TypedProperties)props));
        props.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"");
        Assertions.assertEquals((Object)KeyGeneratorType.NON_PARTITION, (Object)HoodieSparkKeyGeneratorFactory.inferKeyGeneratorTypeFromWriteConfig((TypedProperties)props));
    }

    @Test
    public void testKeyGeneratorFactory() {
        TypedProperties props = this.getCommonProps();
        props.put((Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key(), (Object)KeyGeneratorType.CUSTOM.name());
        props.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"field:simple");
        KeyGenerator keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        Assertions.assertEquals((Object)CustomKeyGenerator.class.getName(), (Object)keyGenerator.getClass().getName());
        props = this.getCommonProps();
        props.put((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), (Object)SimpleKeyGenerator.class.getName());
        KeyGenerator keyGenerator2 = HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        Assertions.assertEquals((Object)SimpleKeyGenerator.class.getName(), (Object)keyGenerator2.getClass().getName());
        props.put((Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key(), (Object)KeyGeneratorType.CUSTOM.name());
        KeyGenerator keyGenerator3 = HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
        Assertions.assertEquals((Object)SimpleKeyGenerator.class.getName(), (Object)keyGenerator3.getClass().getName());
        TypedProperties props2 = this.getCommonProps();
        props2.put((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), (Object)TestHoodieSparkKeyGeneratorFactory.class.getName());
        Assertions.assertThrows(HoodieException.class, () -> HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props2));
        TypedProperties props3 = this.getCommonProps();
        props3.put((Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key(), (Object)"wrong_type");
        Assertions.assertThrows(HoodieKeyGeneratorException.class, () -> HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props3));
        TypedProperties props4 = this.getCommonProps();
        Assertions.assertEquals((Object)SimpleKeyGenerator.class.getName(), (Object)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props4).getClass().getName());
        props4.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key,ts");
        Assertions.assertEquals((Object)ComplexKeyGenerator.class.getName(), (Object)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props4).getClass().getName());
        props4.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"");
        Assertions.assertEquals((Object)NonpartitionedKeyGenerator.class.getName(), (Object)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props4).getClass().getName());
    }

    private TypedProperties getCommonProps() {
        TypedProperties properties = new TypedProperties();
        properties.put((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), (Object)"_row_key");
        properties.put((Object)KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
        properties.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"timestamp");
        return properties;
    }
}

