/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import com.codahale.metrics.Counter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.versioning.v1.InstantComparatorV1;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.SparkHoodieBloomIndexHelper;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.compact.strategy.CompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.PartitionRegexBasedCompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.SmallBoundedIOCompactionStrategy;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestHoodieCompactor
extends HoodieSparkClientTestHarness {
    private HoodieTableMetaClient metaClient;

    @BeforeEach
    public void setUp() throws Exception {
        this.initSparkContexts();
        this.initPath();
        this.storage = HoodieStorageUtils.getStorage((String)this.basePath, (StorageConfiguration)this.storageConf);
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        this.initTestDataGenerator();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupResources();
    }

    public HoodieWriteConfig getConfig() {
        return this.getConfig(1);
    }

    public HoodieWriteConfig getConfig(int numCommitsBeforeCompaction) {
        return this.getConfigBuilder().withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(numCommitsBeforeCompaction).build()).withMetricsConfig(TestHoodieCompactor.getMetricsConfig()).build();
    }

    private static HoodieMetricsConfig getMetricsConfig() {
        return HoodieMetricsConfig.newBuilder().on(true).withReporterType("INMEMORY").build();
    }

    private long getCompactionMetricCount(String metric) {
        HoodieMetrics metrics = this.writeClient.getMetrics();
        String metricName = metrics.getMetricsName("compaction", metric + ".counter");
        SortedMap counters = metrics.getMetrics().getRegistry().getCounters();
        return counters.containsKey(metricName) ? ((Counter)counters.get(metricName)).getCount() : 0L;
    }

    public HoodieWriteConfig.Builder getConfigBuilder() {
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x100000L).withInlineCompaction(Boolean.valueOf(false)).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x100000L).parquetMaxFileSize(0x100000L).orcMaxFileSize(0x100000L).build()).withMemoryConfig(HoodieMemoryConfig.newBuilder().withMaxDFSStreamBufferSize(0x100000).build()).forTable("test-trip-table").withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build());
    }

    @Test
    public void testCompactionOnCopyOnWriteFail() throws Exception {
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE);
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(this.getConfig());){
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)this.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
            String compactionInstantTime = writeClient.createNewInstantTime();
            Assertions.assertThrows(HoodieNotSupportedException.class, () -> this.lambda$testCompactionOnCopyOnWriteFail$0((HoodieTable)table, compactionInstantTime));
            Assertions.assertEquals((long)0L, (long)this.getCompactionMetricCount(HoodieTimeline.REQUESTED_COMPACTION_SUFFIX));
            Assertions.assertEquals((long)0L, (long)this.getCompactionMetricCount(HoodieTimeline.COMPLETED_COMPACTION_SUFFIX));
        }
    }

    @Test
    public void testCompactionEmpty() {
        HoodieWriteConfig config = this.getConfig();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)this.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(config);){
            String newCommitTime = writeClient.startCommit();
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(100));
            JavaRDD recordsRDD = this.jsc.parallelize(records, 1);
            writeClient.insert(recordsRDD, newCommitTime).collect();
            String compactionInstantTime = writeClient.createNewInstantTime();
            Option plan = table.scheduleCompaction((HoodieEngineContext)this.context, compactionInstantTime, Option.empty());
            Assertions.assertFalse((boolean)plan.isPresent(), (String)"If there is nothing to compact, result will be empty");
            Assertions.assertEquals((long)0L, (long)this.getCompactionMetricCount(HoodieTimeline.REQUESTED_COMPACTION_SUFFIX));
            Assertions.assertEquals((long)0L, (long)this.getCompactionMetricCount(HoodieTimeline.COMPLETED_COMPACTION_SUFFIX));
        }
    }

    @Test
    public void testScheduleCompactionWithInflightInstant() {
        HoodieWriteConfig config = this.getConfig();
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(config);){
            String newCommitTime = "100";
            writeClient.startCommitWithTime(newCommitTime);
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(100));
            JavaRDD recordsRDD = this.jsc.parallelize(records, 1);
            writeClient.insert(recordsRDD, newCommitTime).collect();
            newCommitTime = "102";
            writeClient.startCommitWithTime(newCommitTime);
            this.metaClient.getActiveTimeline().transitionRequestedToInflight(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "deltacommit", newCommitTime), Option.empty());
            String compactionTime = "101";
            writeClient.scheduleCompactionAtInstant(compactionTime, Option.empty());
        }
    }

    @Test
    public void testNeedCompactionCondition() throws Exception {
        HoodieWriteConfig config = this.getConfig(3);
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(config);){
            String newCommitTime = "100";
            writeClient.startCommitWithTime(newCommitTime);
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(100));
            JavaRDD recordsRDD = this.jsc.parallelize(records, 1);
            writeClient.insert(recordsRDD, newCommitTime).collect();
            this.updateRecords(config, "101", records);
            newCommitTime = "102";
            writeClient.startCommitWithTime(newCommitTime);
            this.metaClient.getActiveTimeline().transitionRequestedToInflight(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "deltacommit", newCommitTime), Option.empty());
            String compactionTime = "107";
            Assertions.assertFalse((boolean)writeClient.scheduleCompactionAtInstant(compactionTime, Option.empty()));
        }
    }

    @Test
    public void testWriteStatusContentsAfterCompaction() throws Exception {
        HoodieWriteConfig config = this.getConfigBuilder().withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(1).build()).withMetricsConfig(TestHoodieCompactor.getMetricsConfig()).build();
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(config);){
            int i;
            String newCommitTime = "100";
            writeClient.startCommitWithTime(newCommitTime);
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(1000));
            JavaRDD recordsRDD = this.jsc.parallelize(records, 1);
            writeClient.insert(recordsRDD, newCommitTime).collect();
            for (i = 1; i < 5; ++i) {
                newCommitTime = String.format("10%s", i);
                this.updateRecords(config, newCommitTime, records);
                this.assertLogFilesNumEqualsTo(config, i);
            }
            HoodieWriteMetadata result = this.compact(writeClient, String.format("10%s", i));
            this.verifyCompaction(result);
            Assertions.assertEquals((long)1L, (long)this.getCompactionMetricCount(HoodieTimeline.REQUESTED_COMPACTION_SUFFIX));
            Assertions.assertEquals((long)1L, (long)this.getCompactionMetricCount(HoodieTimeline.COMPLETED_COMPACTION_SUFFIX));
        }
    }

    @Test
    public void testSpillingWhenCompaction() throws Exception {
        HoodieWriteConfig config = this.getConfigBuilder().withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(1).build()).withMemoryConfig(HoodieMemoryConfig.newBuilder().withMaxMemoryMaxSize(1L, 1L).build()).withMetricsConfig(TestHoodieCompactor.getMetricsConfig()).build();
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(config);){
            String newCommitTime = writeClient.createNewInstantTime();
            writeClient.startCommitWithTime(newCommitTime);
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(100));
            JavaRDD recordsRDD = this.jsc.parallelize(records, 1);
            writeClient.insert(recordsRDD, newCommitTime).collect();
            for (int i = 1; i < 5; i += 2) {
                newCommitTime = writeClient.createNewInstantTime();
                this.updateRecords(config, newCommitTime, records);
                this.assertLogFilesNumEqualsTo(config, 1);
                HoodieWriteMetadata result = this.compact(writeClient, writeClient.createNewInstantTime());
                this.verifyCompaction(result);
                Assertions.assertEquals((long)(i / 2 + 1), (long)this.getCompactionMetricCount(HoodieTimeline.REQUESTED_COMPACTION_SUFFIX));
                Assertions.assertEquals((long)(i / 2 + 1), (long)this.getCompactionMetricCount(HoodieTimeline.COMPLETED_COMPACTION_SUFFIX));
            }
        }
    }

    private static Stream<Arguments> regexTestParameters() {
        Object[][] data = new Object[][]{{".*", Arrays.asList("2015/03/16", "2015/03/17", "2016/03/15")}, {"2017/.*/.*", Collections.emptyList()}, {"2015/03/.*", Arrays.asList("2015/03/16", "2015/03/17")}, {"2016/.*/.*", Arrays.asList("2016/03/15")}};
        return Stream.of(data).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"regexTestParameters"})
    public void testCompactionSpecifyPartition(String regex, List<String> expectedCompactedPartition) throws Exception {
        HoodieCompactionConfig.Builder builder = HoodieCompactionConfig.newBuilder().withCompactionStrategy(new CompactionStrategy[]{new PartitionRegexBasedCompactionStrategy()}).withMaxNumDeltaCommitsBeforeCompaction(1);
        builder.withCompactionSpecifyPartitionPathRegex(regex);
        HoodieWriteConfig config = this.getConfigBuilder().withCompactionConfig(builder.build()).withMetricsConfig(TestHoodieCompactor.getMetricsConfig()).build();
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(config);){
            String newCommitTime = writeClient.createNewInstantTime();
            writeClient.startCommitWithTime(newCommitTime);
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(10));
            JavaRDD recordsRDD = this.jsc.parallelize(records, 1);
            writeClient.insert(recordsRDD, newCommitTime).collect();
            newCommitTime = writeClient.createNewInstantTime();
            this.updateRecords(config, newCommitTime, records);
            this.assertLogFilesNumEqualsTo(config, 1);
            String compactionInstant = writeClient.createNewInstantTime();
            boolean scheduled = writeClient.scheduleCompactionAtInstant(compactionInstant, Option.empty());
            if (expectedCompactedPartition.isEmpty()) {
                Assertions.assertFalse((boolean)scheduled);
                return;
            }
            HoodieWriteMetadata result = this.compact(writeClient, compactionInstant);
            Assertions.assertTrue((boolean)result.getWriteStats().isPresent());
            List stats = (List)result.getWriteStats().get();
            Assertions.assertEquals((int)expectedCompactedPartition.size(), (int)stats.size());
            expectedCompactedPartition.forEach(expectedPartition -> Assertions.assertTrue((boolean)stats.stream().anyMatch(stat -> stat.getPartitionPath().contentEquals((CharSequence)expectedPartition))));
        }
    }

    @Test
    public void testPartitionsForIncrCompaction() throws Exception {
        HoodieWriteConfig config = this.getConfigBuilder().withIncrementalTableServiceEnabled(true).withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy(new CompactionStrategy[]{new SmallBoundedIOCompactionStrategy()}).withMaxNumDeltaCommitsBeforeCompaction(2).build()).build();
        String[] partitions = new String[]{"20250115"};
        HoodieWriteConfig config2 = this.getConfigBuilder().withIncrementalTableServiceEnabled(true).withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(2).build()).build();
        String[] partitions2 = new String[]{"20250116"};
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(config);){
            this.prepareRecords(writeClient, config, partitions);
            this.prepareRecords(writeClient, config, partitions);
            this.compact(writeClient, writeClient.createNewInstantTime());
            HoodieCompactionPlan compactionPlan1 = this.getLatestCompactionPlan();
            List affectedPartitions = compactionPlan1.getOperations().stream().map(HoodieCompactionOperation::getPartitionPath).collect(Collectors.toList());
            Assertions.assertTrue((boolean)affectedPartitions.contains(partitions[0]));
            List missingPartitions = compactionPlan1.getMissingSchedulePartitions();
            Assertions.assertTrue((boolean)missingPartitions.contains(partitions[0]));
        }
        writeClient = this.getHoodieWriteClient(config2);
        var6_6 = null;
        try {
            this.prepareRecords(writeClient, config2, partitions2);
            this.prepareRecords(writeClient, config2, partitions2);
            this.compact(writeClient, writeClient.createNewInstantTime());
            HoodieCompactionPlan compactionPlan2 = this.getLatestCompactionPlan();
            List affectedPartitions2 = compactionPlan2.getOperations().stream().map(HoodieCompactionOperation::getPartitionPath).collect(Collectors.toList());
            Assertions.assertTrue((boolean)affectedPartitions2.contains(partitions[0]));
            Assertions.assertTrue((boolean)affectedPartitions2.contains(partitions2[0]));
            List missingPartitions2 = compactionPlan2.getMissingSchedulePartitions();
            Assertions.assertTrue((boolean)missingPartitions2.isEmpty());
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (writeClient != null) {
                if (var6_6 != null) {
                    try {
                        writeClient.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    writeClient.close();
                }
            }
        }
    }

    private void prepareRecords(SparkRDDWriteClient writeClient, HoodieWriteConfig config, String[] partitions) throws Exception {
        this.initTestDataGenerator(partitions);
        String newCommitTime = writeClient.createNewInstantTime();
        writeClient.startCommitWithTime(newCommitTime);
        List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(100));
        JavaRDD recordsRDD = this.jsc.parallelize(records, 1);
        writeClient.insert(recordsRDD, newCommitTime).collect();
        newCommitTime = writeClient.createNewInstantTime();
        this.updateRecords(config, newCommitTime, records);
    }

    private HoodieCompactionPlan getLatestCompactionPlan() {
        this.metaClient.reloadActiveTimeline();
        Option latestCompactionInstant = this.metaClient.getActiveTimeline().getCommitTimeline().lastInstant();
        HoodieInstant compactionPlanInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", ((HoodieInstant)latestCompactionInstant.get()).requestedTime(), InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        Option details = this.metaClient.getActiveTimeline().readCompactionPlanAsBytes(compactionPlanInstant);
        return CompactionUtils.getCompactionPlan((HoodieTableMetaClient)this.metaClient, (Option)details);
    }

    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }

    private void updateRecords(HoodieWriteConfig config, String newCommitTime, List<HoodieRecord> records) throws IOException {
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context);
        List updatedRecords = this.dataGen.generateUpdates(newCommitTime, records);
        JavaRDD updatedRecordsRDD = this.jsc.parallelize(updatedRecords, 1);
        HoodieBloomIndex index = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)SparkHoodieBloomIndexHelper.getInstance());
        JavaRDD updatedTaggedRecordsRDD = this.tagLocation((HoodieIndex)index, updatedRecordsRDD, (HoodieTable)table);
        this.writeClient.startCommitWithTime(newCommitTime);
        this.writeClient.upsertPreppedRecords(updatedTaggedRecordsRDD, newCommitTime).collect();
        this.metaClient.reloadActiveTimeline();
    }

    private void assertLogFilesNumEqualsTo(HoodieWriteConfig config, int expected) {
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context);
        for (String partitionPath : this.dataGen.getPartitionPaths()) {
            List groupedLogFiles = table.getSliceView().getLatestFileSlices(partitionPath).collect(Collectors.toList());
            for (FileSlice fileSlice : groupedLogFiles) {
                Assertions.assertEquals((long)expected, (long)fileSlice.getLogFiles().count(), (String)("There should be " + expected + " log file written for every data file"));
            }
        }
    }

    private HoodieWriteMetadata compact(SparkRDDWriteClient writeClient, String compactionInstantTime) {
        writeClient.scheduleCompactionAtInstant(compactionInstantTime, Option.empty());
        HoodieWriteMetadata compactMetadata = writeClient.compact(compactionInstantTime);
        return compactMetadata;
    }

    private void verifyCompaction(HoodieWriteMetadata compactionMetadata) {
        Assertions.assertTrue((boolean)compactionMetadata.getWriteStats().isPresent());
        List stats = (List)compactionMetadata.getWriteStats().get();
        Assertions.assertEquals((int)this.dataGen.getPartitionPaths().length, (int)stats.size());
        for (String partitionPath : this.dataGen.getPartitionPaths()) {
            Assertions.assertTrue((boolean)stats.stream().anyMatch(stat -> stat.getPartitionPath().contentEquals(partitionPath)));
        }
        stats.forEach(stat -> {
            HoodieWriteStat.RuntimeStats runtimeStats = stat.getRuntimeStats();
            Assertions.assertNotNull((Object)runtimeStats);
            Assertions.assertEquals((long)0L, (long)runtimeStats.getTotalCreateTime());
            Assertions.assertTrue((runtimeStats.getTotalUpsertTime() > 0L ? 1 : 0) != 0);
            Assertions.assertTrue((runtimeStats.getTotalScanTime() > 0L ? 1 : 0) != 0);
        });
    }

    private /* synthetic */ void lambda$testCompactionOnCopyOnWriteFail$0(HoodieTable table, String compactionInstantTime) throws Throwable {
        table.scheduleCompaction((HoodieEngineContext)this.context, compactionInstantTime, Option.empty());
        table.compact((HoodieEngineContext)this.context, compactionInstantTime);
    }
}

