/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.lang.reflect.InvocationTargetException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.hudi.testutils.SparkDatasetTestUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.StructType;
import scala.Function1;

public class KeyGeneratorTestUtilities {
    public static final String NESTED_COL_SCHEMA = "{\"type\":\"record\", \"name\":\"nested_col\",\"fields\": [{\"name\": \"prop1\",\"type\": [\"null\", \"string\"]},{\"name\": \"prop2\", \"type\": \"long\"}]}";
    public static final String EXAMPLE_SCHEMA = "{\"type\": \"record\",\"name\": \"testrec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"ts_ms\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\"},{\"name\": \"nested_col\",\"type\": [\"null\", {\"type\":\"record\", \"name\":\"nested_col\",\"fields\": [{\"name\": \"prop1\",\"type\": [\"null\", \"string\"]},{\"name\": \"prop2\", \"type\": \"long\"}]}]}]}";
    public static final String TEST_STRUCTNAME = "test_struct_name";
    public static final String TEST_RECORD_NAMESPACE = "test_record_namespace";
    public static Schema schema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"testrec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"ts_ms\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\"},{\"name\": \"nested_col\",\"type\": [\"null\", {\"type\":\"record\", \"name\":\"nested_col\",\"fields\": [{\"name\": \"prop1\",\"type\": [\"null\", \"string\"]},{\"name\": \"prop2\", \"type\": \"long\"}]}]}]}");
    public static StructType structType = AvroConversionUtils.convertAvroSchemaToStructType((Schema)schema);

    public static GenericRecord getRecord() {
        return KeyGeneratorTestUtilities.getRecord(KeyGeneratorTestUtilities.getNestedColRecord("val1", 10L));
    }

    public static GenericRecord getNestedColRecord(String prop1Value, Long prop2Value) {
        GenericData.Record nestedColRecord = new GenericData.Record(new Schema.Parser().parse(NESTED_COL_SCHEMA));
        nestedColRecord.put("prop1", (Object)prop1Value);
        nestedColRecord.put("prop2", (Object)prop2Value);
        return nestedColRecord;
    }

    public static GenericRecord getRecord(GenericRecord nestedColRecord) {
        GenericData.Record record = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA));
        record.put("timestamp", (Object)4357686L);
        record.put("_row_key", (Object)"key1");
        record.put("ts_ms", (Object)"2020-03-21");
        record.put("pii_col", (Object)"pi");
        record.put("nested_col", (Object)nestedColRecord);
        return record;
    }

    public static Row getRow(GenericRecord record) {
        return KeyGeneratorTestUtilities.getRow(record, schema, structType);
    }

    public static Row getRow(GenericRecord record, Schema schema, StructType structType) {
        Function1 converterFn = AvroConversionUtils.createConverterToRow((Schema)schema, (StructType)structType);
        Row row = (Row)converterFn.apply((Object)record);
        int fieldCount = structType.fieldNames().length;
        Object[] values = new Object[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            values[i] = row.get(i);
        }
        return new GenericRowWithSchema(values, structType);
    }

    public static InternalRow getInternalRow(Row row) {
        try {
            return KeyGeneratorTestUtilities.getInternalRow(row, (ExpressionEncoder<Row>)KeyGeneratorTestUtilities.getEncoder(row.schema()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception thrown while converting Row to InternalRow", e);
        }
    }

    private static ExpressionEncoder getEncoder(StructType schema) {
        return SparkAdapterSupport$.MODULE$.sparkAdapter().getCatalystExpressionUtils().getEncoder(schema);
    }

    public static InternalRow getInternalRow(Row row, ExpressionEncoder<Row> encoder) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        return SparkDatasetTestUtils.serializeRow(encoder, (Row)row);
    }
}

