/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.hudi.benchmark.HoodieBenchmark;
import org.apache.spark.hudi.benchmark.HoodieBenchmark$;
import org.apache.spark.hudi.benchmark.HoodieBenchmarkBase;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.hudi.HoodieSparkSessionExtension;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class BoundInMemoryExecutorBenchmark$
extends HoodieBenchmarkBase {
    public static BoundInMemoryExecutorBenchmark$ MODULE$;
    private final SparkSession spark;
    private final int recordNumber;

    static {
        new BoundInMemoryExecutorBenchmark$();
    }

    public SparkSession spark() {
        return this.spark;
    }

    public int recordNumber() {
        return this.recordNumber;
    }

    public SparkSession getSparkSession() {
        return SparkSession$.MODULE$.builder().master("local[*]").appName(this.getClass().getCanonicalName()).withExtensions((Function1)new HoodieSparkSessionExtension()).config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.kryo.registrator", "org.apache.spark.HoodieSparkKryoRegistrar").config("spark.sql.catalog.spark_catalog", "org.apache.spark.sql.hudi.catalog.HoodieCatalog").config("spark.sql.session.timeZone", "CTT").config(this.sparkConf()).getOrCreate();
    }

    public SparkConf sparkConf() {
        SparkConf sparkConf = new SparkConf();
        return sparkConf;
    }

    private Dataset<Row> createDataFrame(int number) {
        StructType schema = new StructType().add("c1", (DataType)IntegerType$.MODULE$).add("c2", (DataType)StringType$.MODULE$);
        RDD rdd = this.spark().sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), number), 2, ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)item -> BoundInMemoryExecutorBenchmark$.$anonfun$createDataFrame$1(BoxesRunTime.unboxToInt((Object)item)), ClassTag$.MODULE$.apply(Row.class));
        return this.spark().createDataFrame(rdd, schema);
    }

    private void cowTableDisruptorExecutorBenchmark(String tableName) {
        Dataset<Row> df = this.createDataFrame(this.recordNumber());
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)f -> {
            BoundInMemoryExecutorBenchmark$.$anonfun$cowTableDisruptorExecutorBenchmark$1(tableName, df, f);
            return BoxedUnit.UNIT;
        });
    }

    private String cowTableDisruptorExecutorBenchmark$default$1() {
        return "executorBenchmark";
    }

    @Override
    public void afterAll() {
        this.spark().stop();
    }

    @Override
    public void runBenchmarkSuite(String[] mainArgs) {
        this.cowTableDisruptorExecutorBenchmark(this.cowTableDisruptorExecutorBenchmark$default$1());
    }

    public static final /* synthetic */ Row $anonfun$createDataFrame$1(int item) {
        Integer c1 = item;
        String c2 = "abc";
        return RowFactory.create((Object[])new Object[]{c1, c2});
    }

    public static final /* synthetic */ void $anonfun$cowTableDisruptorExecutorBenchmark$1(String tableName$1, Dataset df$1, File f) {
        HoodieBenchmark benchmark = new HoodieBenchmark("COW Ingestion", MODULE$.recordNumber(), 5, HoodieBenchmark$.MODULE$.$lessinit$greater$default$4(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$5(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$6(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("BoundInMemory Executor", benchmark.addCase$default$2(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> {
            String finalTableName = new StringBuilder(0).append(tableName$1).append(Random$.MODULE$.nextInt(10000)).toString();
            df$1.write().format("hudi").mode(SaveMode.Overwrite).option("hoodie.datasource.write.recordkey.field", "c1").option("hoodie.datasource.write.partitionpath.field", "c2").option("hoodie.table.name", finalTableName).option("hoodie.metadata.enable", "false").option("hoodie.clean.automatic", "false").option("hoodie.bulkinsert.sort.mode", "NONE").option("hoodie.insert.shuffle.parallelism", "2").option("hoodie.datasource.write.operation", "bulk_insert").option("hoodie.datasource.write.row.writer.enable", "false").option("hoodie.bulkinsert.shuffle.parallelism", "4").option("hoodie.upsert.shuffle.parallelism", "2").option("hoodie.delete.shuffle.parallelism", "2").option("hoodie.populate.meta.fields", "false").option("hoodie.table.keygenerator.class", "org.apache.hudi.keygen.SimpleKeyGenerator").save(new Path(f.getCanonicalPath(), finalTableName).toUri().toString());
        });
        benchmark.addCase("Simple Executor", benchmark.addCase$default$2(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> {
            String finalTableName = new StringBuilder(0).append(tableName$1).append(Random$.MODULE$.nextInt(10000)).toString();
            df$1.write().format("hudi").mode(SaveMode.Overwrite).option("hoodie.datasource.write.recordkey.field", "c1").option("hoodie.datasource.write.partitionpath.field", "c2").option("hoodie.table.name", finalTableName).option("hoodie.metadata.enable", "false").option("hoodie.clean.automatic", "false").option("hoodie.bulkinsert.sort.mode", "NONE").option("hoodie.insert.shuffle.parallelism", "2").option("hoodie.datasource.write.operation", "bulk_insert").option("hoodie.datasource.write.row.writer.enable", "false").option("hoodie.bulkinsert.shuffle.parallelism", "4").option("hoodie.upsert.shuffle.parallelism", "2").option("hoodie.delete.shuffle.parallelism", "2").option("hoodie.write.executor.type", "SIMPLE").option("hoodie.populate.meta.fields", "false").option("hoodie.table.keygenerator.class", "org.apache.hudi.keygen.SimpleKeyGenerator").save(new Path(f.getCanonicalPath(), finalTableName).toUri().toString());
        });
        benchmark.addCase("Disruptor Executor", benchmark.addCase$default$2(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> {
            String finalTableName = new StringBuilder(0).append(tableName$1).append(Random$.MODULE$.nextInt(10000)).toString();
            df$1.write().format("hudi").mode(SaveMode.Overwrite).option("hoodie.datasource.write.recordkey.field", "c1").option("hoodie.datasource.write.partitionpath.field", "c2").option("hoodie.table.name", finalTableName).option("hoodie.metadata.enable", "false").option("hoodie.clean.automatic", "false").option("hoodie.bulkinsert.sort.mode", "NONE").option("hoodie.insert.shuffle.parallelism", "2").option("hoodie.datasource.write.operation", "bulk_insert").option("hoodie.datasource.write.row.writer.enable", "false").option("hoodie.bulkinsert.shuffle.parallelism", "4").option("hoodie.upsert.shuffle.parallelism", "2").option("hoodie.delete.shuffle.parallelism", "2").option("hoodie.write.executor.type", "DISRUPTOR").option("hoodie.populate.meta.fields", "false").option("hoodie.table.keygenerator.class", "org.apache.hudi.keygen.SimpleKeyGenerator").save(new Path(f.getCanonicalPath(), finalTableName).toUri().toString());
        });
        benchmark.run();
    }

    private BoundInMemoryExecutorBenchmark$() {
        MODULE$ = this;
        this.spark = this.getSparkSession();
        this.recordNumber = 10000000;
    }
}

