/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DummyActiveAction;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.client.timeline.versioning.v2.LSMTimelineWriter;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.LSMTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.v2.CompletionTimeQueryViewV2;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieJavaTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.hudi.benchmark.HoodieBenchmark;
import org.apache.spark.hudi.benchmark.HoodieBenchmark$;
import org.apache.spark.hudi.benchmark.HoodieBenchmarkBase;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class LSMTimelineReadBenchmark$
extends HoodieBenchmarkBase {
    public static LSMTimelineReadBenchmark$ MODULE$;

    static {
        new LSMTimelineReadBenchmark$();
    }

    private void readArchivedInstantsBenchmark() {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)f -> {
            LSMTimelineReadBenchmark$.$anonfun$readArchivedInstantsBenchmark$1(f);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void runBenchmarkSuite(String[] mainArgs) {
        this.readArchivedInstantsBenchmark();
    }

    public static final /* synthetic */ void $anonfun$readArchivedInstantsBenchmark$1(File f2) {
        String tableName = "testTable";
        String tablePath = new Path(f2.getCanonicalPath(), tableName).toUri().toString();
        HoodieTableMetaClient metaClient = HoodieTestUtils.init((StorageConfiguration)HoodieTestUtils.getDefaultStorageConf(), (String)tablePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (String)tableName);
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(tablePath).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).withMarkersType("DIRECT").build();
        HoodieJavaEngineContext engineContext = new HoodieJavaEngineContext(HoodieTestUtils.getDefaultStorageConf());
        LSMTimelineWriter writer = LSMTimelineWriter.getInstance((HoodieWriteConfig)writeConfig, (HoodieTable)HoodieJavaTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)engineContext));
        long startTs = System.currentTimeMillis();
        String startInstant = new StringBuilder(0).append(startTs + 1L).toString();
        int commitsNum = 260000;
        int batchSize = 10;
        ArrayList instantBuffer = new ArrayList();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), commitsNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String instantTime = new StringBuilder(0).append(startTs + (long)i).toString();
            String completionTime = new StringBuilder(0).append(startTs + (long)i + 1000L).toString();
            String action = i % 2 == 0 ? "delta_commit" : "commit";
            HoodieInstant instant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, action, instantTime, completionTime);
            HoodieCommitMetadata metadata = HoodieTestTable.of((HoodieTableMetaClient)metaClient).createCommitMetadata(instantTime, WriteOperationType.INSERT, Arrays.asList((Object[])new String[]{"par1", "par2"}), 10, false);
            byte[] serializedMetadata = (byte[])TimelineMetadataUtils.serializeCommitMetadata((CommitMetadataSerDe)metaClient.getTimelineLayout().getCommitMetadataSerDe(), (HoodieCommitMetadata)metadata).get();
            instantBuffer.add(new DummyActiveAction(instant, serializedMetadata));
            if (i % batchSize == 0) {
                writer.write((List)instantBuffer, Option.empty(), Option.empty());
                writer.compactAndClean((HoodieEngineContext)engineContext);
                instantBuffer.clear();
                return;
            }
        });
        HoodieBenchmark benchmark = new HoodieBenchmark("pref load archived instants", commitsNum, 3, HoodieBenchmark$.MODULE$.$lessinit$greater$default$4(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$5(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$6(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("read slim instants", benchmark.addCase$default$2(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> HoodieTestUtils.TIMELINE_FACTORY.createArchivedTimeline(metaClient));
        benchmark.addCase("read instants with commit metadata", benchmark.addCase$default$2(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> HoodieTestUtils.TIMELINE_FACTORY.createArchivedTimeline(metaClient, startInstant));
        Function<String, String> earliestStartTimeFunc = new Function<String, String>(){

            public <V> Function<V, String> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super String, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public String apply(String s) {
                return new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString(s)).toLong() - 1000L).toString();
            }
        };
        benchmark.addCase("read start time", benchmark.addCase$default$2(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> new CompletionTimeQueryViewV2(metaClient).getInstantTimes(new StringBuilder(0).append(startTs + 1L + 1000L).toString(), new StringBuilder(0).append(startTs + (long)commitsNum + 1000L).toString(), earliestStartTimeFunc));
        benchmark.run();
        long totalSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(LSMTimeline.latestSnapshotManifest((HoodieTableMetaClient)metaClient, (StoragePath)metaClient.getArchivePath()).getFiles()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)f.getFileLen()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("Total file size in bytes: ").append(totalSize).toString());
    }

    private LSMTimelineReadBenchmark$() {
        MODULE$ = this;
    }
}

