/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.ColumnStatsIndexHelper;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.sort.SpaceCurveSortingHelper;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.benchmark.SpaceCurveOptimizeBenchmark$;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@Tag(value="functional")
public final class SpaceCurveOptimizeBenchmark$
extends HoodieSparkSqlTestBase {
    public static SpaceCurveOptimizeBenchmark$ MODULE$;

    static {
        new SpaceCurveOptimizeBenchmark$();
    }

    public void evalSkippingPercent(String tableName, String co1, String co2, int value1, int value2) {
        Dataset sourceTableDF = this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString());
        Seq orderedColsTypes = (Seq)new .colon.colon((Object)new StructField(co1, (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField(co2, (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        Tuple4[] colStatsIndexTable = (Tuple4[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ColumnStatsIndexHelper.buildColumnStatsTableFor(this.spark(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceTableDF.inputFiles())).toSeq()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(orderedColsTypes).asJava()).collect())).map((Function1 & Serializable & scala.Serializable)f -> new Tuple4((Object)BoxesRunTime.boxToInteger((int)f.getInt(1)), (Object)BoxesRunTime.boxToInteger((int)f.getInt(2)), (Object)BoxesRunTime.boxToInteger((int)f.getInt(4)), (Object)BoxesRunTime.boxToInteger((int)f.getInt(5))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple4.class)));
        IntRef hits = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])colStatsIndexTable)).foreach((Function1 & Serializable & scala.Serializable)fileStatRow -> {
            SpaceCurveOptimizeBenchmark$.$anonfun$evalSkippingPercent$2(value1, value2, hits, fileStatRow);
            return BoxedUnit.UNIT;
        });
        double p = (double)hits.elem / (double)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])colStatsIndexTable)).size();
        Predef$.MODULE$.println((Object)new StringBuilder(91).append("For table ").append(tableName).append(" with query filter: ").append(co1).append(" = ").append(value1).append(" or ").append(co2).append(" = ").append(value2).append(" we can achieve skipping percent ").append(1.0 - p).append(" (w/ total files ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])colStatsIndexTable)).size()).append(")").toString());
    }

    @Test
    @Disabled
    public void runNormalTableSkippingBenchMark() {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)f -> {
            SpaceCurveOptimizeBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table_z_sort_byMap", "table_z_sort_bySample", "table_hilbert_sort_byMap", "table_hilbert_sort_bySample"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SpaceCurveOptimizeBenchmark$.MODULE$.prepareInterTypeTable(new Path(f.getAbsolutePath()), 1000000, SpaceCurveOptimizeBenchmark$.MODULE$.prepareInterTypeTable$default$3(), SpaceCurveOptimizeBenchmark$.MODULE$.prepareInterTypeTable$default$4(), SpaceCurveOptimizeBenchmark$.MODULE$.prepareInterTypeTable$default$5());
                SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_z_sort_byMap", "c1_int", "c2_int", 500000, 500000);
                SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_z_sort_bySample", "c1_int", "c2_int", 500000, 500000);
                SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_hilbert_sort_byMap", "c1_int", "c2_int", 500000, 500000);
                SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_hilbert_sort_bySample", "c1_int", "c2_int", 500000, 500000);
            });
            return BoxedUnit.UNIT;
        });
    }

    @Test
    @Disabled
    public void runSkewTableSkippingBenchMark() {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)f -> {
            SpaceCurveOptimizeBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table_z_sort_byMap_skew", "table_z_sort_bySample_skew", "table_hilbert_sort_byMap_skew", "table_hilbert_sort_bySample_skew"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SpaceCurveOptimizeBenchmark$.MODULE$.prepareInterTypeTable(new Path(f.getAbsolutePath()), 1000000, 10000, 1000000, true);
                SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_z_sort_byMap_skew", "c1_int", "c2_int", 5000, 500000);
                SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_z_sort_bySample_skew", "c1_int", "c2_int", 5000, 500000);
                SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_hilbert_sort_byMap_skew", "c1_int", "c2_int", 5000, 500000);
                SpaceCurveOptimizeBenchmark$.MODULE$.evalSkippingPercent("table_hilbert_sort_bySample_skew", "c1_int", "c2_int", 5000, 500000);
            });
            return BoxedUnit.UNIT;
        });
    }

    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            tableNames.foreach((Function1 & Serializable & scala.Serializable)viewName -> BoxesRunTime.boxToBoolean((boolean)SpaceCurveOptimizeBenchmark$.$anonfun$withTempTable$1(viewName)));
        }
    }

    public void prepareInterTypeTable(Path tablePath, int numRows, int col1Range, int col2Range, boolean skewed) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_sql_execution_benchmark_SpaceCurveOptimizeBenchmark$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_execution_benchmark_SpaceCurveOptimizeBenchmark$$typecreator5$1() {
            }
        }
        Dataset df = this.spark().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$1 -> new Tuple2.mcII.sp(Random$.MODULE$.nextInt(col1Range), Random$.MODULE$.nextInt(col2Range)), this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_benchmark_SpaceCurveOptimizeBenchmark$$typecreator5$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1_int", "c2_int"}));
        Dataset dfOptimizeByMap = SpaceCurveSortingHelper.orderDataFrameByMappingValues((Dataset)df, (HoodieClusteringConfig.LayoutOptimizationStrategy)HoodieClusteringConfig.LayoutOptimizationStrategy.ZORDER, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"c1_int", (List)new .colon.colon((Object)"c2_int", (List)Nil$.MODULE$))).asJava()), (int)200);
        Dataset dfOptimizeBySample = SpaceCurveSortingHelper.orderDataFrameBySamplingValues((Dataset)df, (HoodieClusteringConfig.LayoutOptimizationStrategy)HoodieClusteringConfig.LayoutOptimizationStrategy.ZORDER, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"c1_int", (List)new .colon.colon((Object)"c2_int", (List)Nil$.MODULE$))).asJava()), (int)200);
        Dataset dfHilbertOptimizeByMap = SpaceCurveSortingHelper.orderDataFrameByMappingValues((Dataset)df, (HoodieClusteringConfig.LayoutOptimizationStrategy)HoodieClusteringConfig.LayoutOptimizationStrategy.HILBERT, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"c1_int", (List)new .colon.colon((Object)"c2_int", (List)Nil$.MODULE$))).asJava()), (int)200);
        Dataset dfHilbertOptimizeBySample = SpaceCurveSortingHelper.orderDataFrameBySamplingValues((Dataset)df, (HoodieClusteringConfig.LayoutOptimizationStrategy)HoodieClusteringConfig.LayoutOptimizationStrategy.HILBERT, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"c1_int", (List)new .colon.colon((Object)"c2_int", (List)Nil$.MODULE$))).asJava()), (int)200);
        this.saveAsTable((Dataset<Row>)dfOptimizeByMap, tablePath, skewed ? "z_sort_byMap_skew" : "z_sort_byMap");
        this.saveAsTable((Dataset<Row>)dfOptimizeBySample, tablePath, skewed ? "z_sort_bySample_skew" : "z_sort_bySample");
        this.saveAsTable((Dataset<Row>)dfHilbertOptimizeByMap, tablePath, skewed ? "hilbert_sort_byMap_skew" : "hilbert_sort_byMap");
        this.saveAsTable((Dataset<Row>)dfHilbertOptimizeBySample, tablePath, skewed ? "hilbert_sort_bySample_skew" : "hilbert_sort_bySample");
    }

    public int prepareInterTypeTable$default$3() {
        return 1000000;
    }

    public int prepareInterTypeTable$default$4() {
        return 1000000;
    }

    public boolean prepareInterTypeTable$default$5() {
        return false;
    }

    public void saveAsTable(Dataset<Row> df, Path savePath, String suffix) {
        df.write().mode("overwrite").save(new Path(savePath, suffix).toString());
        this.spark().read().parquet(new Path(savePath, suffix).toString()).createOrReplaceTempView(new StringBuilder(6).append("table_").append(suffix).toString());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$evalSkippingPercent$2(int value1$1, int value2$1, IntRef hits$1, Tuple4 fileStatRow) {
        if (BoxesRunTime.unboxToInt((Object)fileStatRow._1()) <= value1$1 && BoxesRunTime.unboxToInt((Object)fileStatRow._2()) >= value1$1 || BoxesRunTime.unboxToInt((Object)fileStatRow._3()) <= value2$1 && BoxesRunTime.unboxToInt((Object)fileStatRow._4()) >= value2$1) {
            ++hits$1.elem;
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$withTempTable$1(String viewName) {
        return MODULE$.spark().catalog().dropTempView(viewName);
    }

    private SpaceCurveOptimizeBenchmark$() {
        MODULE$ = this;
    }
}

