/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.index;

import java.io.File;
import java.io.Serializable;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.hudi.command.CreateIndexCommand;
import org.apache.spark.sql.hudi.command.CreateIndexCommand$;
import org.apache.spark.sql.hudi.command.DropIndexCommand;
import org.apache.spark.sql.hudi.command.ShowIndexesCommand;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001}2Aa\u0001\u0003\u0001'!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0005?\tyA+Z:u\u0013:$W\r_*z]R\f\u0007P\u0003\u0002\u0006\r\u0005)\u0011N\u001c3fq*\u0011q\u0001C\u0001\bG>lW.\u00198e\u0015\tI!\"\u0001\u0003ik\u0012L'BA\u0006\r\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001b9\tQa\u001d9be.T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"\u0001\u0004d_6lwN\\\u0005\u00033Y\u0011a\u0003S8pI&,7\u000b]1sWN\u000bH\u000eV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u0003\u0011\tQ#Y:tKJ$H+\u00192mK&#WM\u001c;jM&,'\u000f\u0006\u0003!MAj\u0004CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#\u0001B+oSRDQa\n\u0002A\u0002!\nAbY1uC2|w\rV1cY\u0016\u0004\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\u000f\r\fG/\u00197pO*\u0011QFC\u0001\tG\u0006$\u0018\r\\=ti&\u0011qF\u000b\u0002\r\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\u0005\u0006c\t\u0001\rAM\u0001\u0015Kb\u0004Xm\u0019;fI\u0012\u000bG/\u00192bg\u0016t\u0015-\\3\u0011\u0005MRdB\u0001\u001b9!\t)$%D\u00017\u0015\t9$#\u0001\u0004=e>|GOP\u0005\u0003s\t\na\u0001\u0015:fI\u00164\u0017BA\u001e=\u0005\u0019\u0019FO]5oO*\u0011\u0011H\t\u0005\u0006}\t\u0001\rAM\u0001\u0012Kb\u0004Xm\u0019;fIR\u000b'\r\\3OC6,\u0007")
public class TestIndexSyntax
extends HoodieSparkSqlTestBase {
    private void assertTableIdentifier(CatalogTable catalogTable, String expectedDatabaseName, String expectedTableName) {
        this.assertResult(new Some((Object)expectedDatabaseName), catalogTable.identifier().database(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        this.assertResult(expectedTableName, catalogTable.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
    }

    public static final /* synthetic */ void $anonfun$new$2(TestIndexSyntax $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String databaseName = "default";
            String tableName = $this.generateTableName();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(375).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append((String)tableType).append("',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by(ts)\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
            ParserInterface sqlParser = $this.spark().sessionState().sqlParser();
            Analyzer analyzer = $this.spark().sessionState().analyzer();
            LogicalPlan logicalPlan = sqlParser.parsePlan(new StringBuilder(26).append("show indexes from default.").append(tableName).toString());
            LogicalPlan resolvedLogicalPlan = analyzer.execute(logicalPlan);
            $this.assertTableIdentifier(((ShowIndexesCommand)resolvedLogicalPlan).table(), databaseName, tableName);
            logicalPlan = sqlParser.parsePlan(new StringBuilder(70).append("create index idx_name on ").append(tableName).append(" using lucene (name) options(block_size=1024)").toString());
            resolvedLogicalPlan = analyzer.execute(logicalPlan);
            $this.assertTableIdentifier(((CreateIndexCommand)resolvedLogicalPlan).table(), databaseName, tableName);
            $this.assertResult("idx_name", ((CreateIndexCommand)resolvedLogicalPlan).indexName(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            $this.assertResult("lucene", ((CreateIndexCommand)resolvedLogicalPlan).indexType(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)((CreateIndexCommand)resolvedLogicalPlan).ignoreIfExists()), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            $this.assertResult(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"block_size"), (Object)"1024")})), ((CreateIndexCommand)resolvedLogicalPlan).options(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            logicalPlan = sqlParser.parsePlan(new StringBuilder(107).append("create index if not exists idx_price on ").append(tableName).append(" using lucene (price options(order='desc')) options(block_size=512)").toString());
            resolvedLogicalPlan = analyzer.execute(logicalPlan);
            $this.assertTableIdentifier(((CreateIndexCommand)resolvedLogicalPlan).table(), databaseName, tableName);
            $this.assertResult("idx_price", ((CreateIndexCommand)resolvedLogicalPlan).indexName(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            $this.assertResult("lucene", ((CreateIndexCommand)resolvedLogicalPlan).indexType(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            $this.assertResult(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"order"), (Object)"desc")})), ((Tuple2)((CreateIndexCommand)resolvedLogicalPlan).columns().head())._2(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            $this.assertResult(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"block_size"), (Object)"512")})), ((CreateIndexCommand)resolvedLogicalPlan).options(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            logicalPlan = sqlParser.parsePlan(new StringBuilder(33).append("drop index if exists idx_name on ").append(tableName).toString());
            resolvedLogicalPlan = analyzer.execute(logicalPlan);
            $this.assertTableIdentifier(((DropIndexCommand)resolvedLogicalPlan).table(), databaseName, tableName);
            $this.assertResult("idx_name", ((DropIndexCommand)resolvedLogicalPlan).indexName(), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            return $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)((DropIndexCommand)resolvedLogicalPlan).ignoreIfNotExists()), Prettifier$.MODULE$.default(), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        });
    }

    public static final /* synthetic */ void $anonfun$new$6(TestIndexSyntax $this, File tmp$2, String tableType) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(424).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append(tableType).append("',\n             |  preCombineField = 'ts',\n             |  hoodie.metadata.enable = 'true'\n             | )\n             | partitioned by(ts)\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
        $this.checkException(new StringBuilder(28).append("create index idx_ts on ").append(tableName).append(" (id)").toString(), "Record index should be named as record_index");
        $this.checkException(new StringBuilder(34).append("create index record_index on ").append(tableName).append(" (ts)").toString(), "Input columns should match configured record key columns: id");
        $this.checkException(new StringBuilder(37).append("create index record_index on ").append(tableName).append(" (id,ts)").toString(), "Index can be created either on all record key columns or a non record key column");
        $this.spark().sql(new StringBuilder(34).append("create index record_index on ").append(tableName).append(" (id)").toString());
        $this.spark().sql(new StringBuilder(27).append("drop index record_index on ").append(tableName).toString());
        $this.spark().sql(new StringBuilder(52).append("create index record_index on ").append(tableName).append(" using record_index(id)").toString());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getMetadataPartitions().contains("record_index"));
    }

    public static final /* synthetic */ void $anonfun$new$5(TestIndexSyntax $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestIndexSyntax.$anonfun$new$6($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$9(TestIndexSyntax $this, File tmp$3, String tableType) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp$3.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(430).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | options (\n             |  primaryKey ='id,price',\n             |  type = '").append(tableType).append("',\n             |  preCombineField = 'ts',\n             |  hoodie.metadata.enable = 'true'\n             | )\n             | partitioned by(ts)\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
        $this.checkException(new StringBuilder(37).append("create index record_index on ").append(tableName).append(" (price)").toString(), "Index can be only be created on all record key columns. Configured record key fields Set(id, price). Input columns: Set(price)");
        $this.checkException(new StringBuilder(37).append("create index record_index on ").append(tableName).append(" (id,ts)").toString(), "Index can be created either on all record key columns or a non record key column");
        $this.spark().sql(new StringBuilder(40).append("create index record_index on ").append(tableName).append(" (id,price)").toString());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getMetadataPartitions().contains("record_index"));
    }

    public static final /* synthetic */ void $anonfun$new$8(TestIndexSyntax $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestIndexSyntax.$anonfun$new$9($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public TestIndexSyntax() {
        this.test("Test Create/Drop/Show/Refresh Index", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestIndexSyntax.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.test("Test Create and Drop Index Syntax with Simple record key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestIndexSyntax.$anonfun$new$5(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("Test Create and Drop Index Syntax with Complex record key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestIndexSyntax.$anonfun$new$8(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("Test matchesRecordKeys API", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            HoodieTableConfig tableConfig = new HoodieTableConfig();
            tableConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS, "rk1");
            ObjectRef colNames = ObjectRef.create((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rk1"}))));
            Assertions.assertTrue((boolean)CreateIndexCommand$.MODULE$.matchesRecordKeys((Set)colNames.elem, tableConfig));
            colNames.elem = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}));
            Assertions.assertFalse((boolean)CreateIndexCommand$.MODULE$.matchesRecordKeys((Set)colNames.elem, tableConfig));
            colNames.elem = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            Assertions.assertFalse((boolean)CreateIndexCommand$.MODULE$.matchesRecordKeys((Set)colNames.elem, tableConfig));
            colNames.elem = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rk1", "col1"}));
            this.checkException(() -> CreateIndexCommand$.MODULE$.matchesRecordKeys((Set)colNames$1.elem, tableConfig), "Index can be created either on all record key columns or a non record key column");
            tableConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS, "rk1,rk2");
            colNames.elem = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rk1", "rk2"}));
            Assertions.assertTrue((boolean)CreateIndexCommand$.MODULE$.matchesRecordKeys((Set)colNames.elem, tableConfig));
            colNames.elem = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rk1"}));
            this.checkException(() -> CreateIndexCommand$.MODULE$.matchesRecordKeys((Set)colNames$1.elem, tableConfig), "Index can be only be created on all record key columns. Configured record key fields Set(rk1, rk2). Input columns: Set(rk1)");
            colNames.elem = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            Assertions.assertFalse((boolean)CreateIndexCommand$.MODULE$.matchesRecordKeys((Set)colNames.elem, tableConfig));
            colNames.elem = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}));
            Assertions.assertFalse((boolean)CreateIndexCommand$.MODULE$.matchesRecordKeys((Set)colNames.elem, tableConfig));
            colNames.elem = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1", "col2"}));
            Assertions.assertFalse((boolean)CreateIndexCommand$.MODULE$.matchesRecordKeys((Set)colNames.elem, tableConfig));
            colNames.elem = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rk1", "col1"}));
            this.checkException(() -> CreateIndexCommand$.MODULE$.matchesRecordKeys((Set)colNames$1.elem, tableConfig), "Index can be created either on all record key columns or a non record key column");
            colNames.elem = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rk1", "rk2", "col1"}));
            this.checkException(() -> CreateIndexCommand$.MODULE$.matchesRecordKeys((Set)colNames$1.elem, tableConfig), "Index can be created either on all record key columns or a non record key column");
        }, new Position("TestIndexSyntax.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
    }
}

