/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.index;

import java.io.File;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.avro.model.HoodieWriteStat;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.SecondaryIndexKeyUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\b\u0011\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001A\u0002\u0013\u00051\u0006C\u00049\u0001\u0001\u0007I\u0011A\u001d\t\r\t\u0003\u0001\u0015)\u0003-\u0011\u001d\u0019\u0005A1A\u0005\u0002\u0011Caa\u0015\u0001!\u0002\u0013)\u0005b\u0002+\u0001\u0005\u0004%\t\u0001\u0012\u0005\u0007+\u0002\u0001\u000b\u0011B#\t\u000bY\u0003A\u0011B,\t\u000fU\u0004\u0011\u0013!C\u0005m\"9\u00111\u0001\u0001\u0005\n\u0005\u0015\u0001\"CA\u0010\u0001E\u0005I\u0011BA\u0011\u0011\u001d\t)\u0003\u0001C\u0005\u0003OAq!!\u000b\u0001\t\u0013\tYC\u0001\nUKN$8+Z2p]\u0012\f'/_%oI\u0016D(BA\t\u0013\u0003\u0015Ig\u000eZ3y\u0015\t\u0019B#A\u0004d_6l\u0017M\u001c3\u000b\u0005U1\u0012\u0001\u00025vI&T!a\u0006\r\u0002\u0007M\fHN\u0003\u0002\u001a5\u0005)1\u000f]1sW*\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r\"\u0012AB2p[6|g.\u0003\u0002&E\t1\u0002j\\8eS\u0016\u001c\u0006/\u0019:l'FdG+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u0002!\u0005Y\u0011N\\:uC:$H+[7f+\u0005a\u0003CA\u00177\u001b\u0005q#BA\u00181\u0003\u0019\tGo\\7jG*\u0011\u0011GM\u0001\u000bG>t7-\u001e:sK:$(BA\u001a5\u0003\u0011)H/\u001b7\u000b\u0003U\nAA[1wC&\u0011qG\f\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002\u001f%t7\u000f^1oiRKW.Z0%KF$\"A\u000f!\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u000e\t\t\u00111\u0001-\u0003\rAH%M\u0001\rS:\u001cH/\u00198u)&lW\rI\u0001\r[\u0016$\u0018\rZ1uC>\u0003Ho]\u000b\u0002\u000bB!a)\u0014)Q\u001d\t95\n\u0005\u0002Iy5\t\u0011J\u0003\u0002K=\u00051AH]8pizJ!\u0001\u0014\u001f\u0002\rA\u0013X\rZ3g\u0013\tquJA\u0002NCBT!\u0001\u0014\u001f\u0011\u0005\u0019\u000b\u0016B\u0001*P\u0005\u0019\u0019FO]5oO\u0006iQ.\u001a;bI\u0006$\u0018m\u00149ug\u0002\n!bY8n[>tw\n\u001d;t\u0003-\u0019w.\\7p]>\u0003Ho\u001d\u0011\u0002O1|\u0017\rZ%oSRL\u0017\r\u001c\"bi\u000eD\u0017I\u001c3De\u0016\fG/Z*fG>tG-\u0019:z\u0013:$W\r\u001f\u000b\u00061~\u000b7-\u001c\t\u00053z\u0003\u0006+D\u0001[\u0015\tYF,A\u0005j[6,H/\u00192mK*\u0011Q\fP\u0001\u000bG>dG.Z2uS>t\u0017B\u0001([\u0011\u0015\u0001\u0017\u00021\u0001Q\u0003%!\u0018M\u00197f\u001d\u0006lW\rC\u0003c\u0013\u0001\u0007\u0001+\u0001\u0005cCN,\u0007+\u0019;i\u0011\u0015!\u0017\u00021\u0001f\u0003\u001d!\u0017\r^1HK:\u0004\"AZ6\u000e\u0003\u001dT!\u0001[5\u0002\u0013Q,7\u000f^;uS2\u001c(BA\u0012k\u0015\t)\"$\u0003\u0002mO\n9\u0002j\\8eS\u0016$Vm\u001d;ECR\fw)\u001a8fe\u0006$xN\u001d\u0005\b]&\u0001\n\u00111\u0001p\u0003)qW/\\%og\u0016\u0014Ho\u001d\t\u0003aNl\u0011!\u001d\u0006\u0003eR\nA\u0001\\1oO&\u0011A/\u001d\u0002\b\u0013:$XmZ3s\u0003Ebw.\u00193J]&$\u0018.\u00197CCR\u001c\u0007.\u00118e\u0007J,\u0017\r^3TK\u000e|g\u000eZ1ss&sG-\u001a=%I\u00164\u0017-\u001e7uIQ*\u0012a\u001e\u0016\u0003_b\\\u0013!\u001f\t\u0003u~l\u0011a\u001f\u0006\u0003yv\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005yd\u0014AC1o]>$\u0018\r^5p]&\u0019\u0011\u0011A>\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\fwC2LG-\u0019;f'\u0016\u001cwN\u001c3befLe\u000eZ3y)%Q\u0014qAA\u0005\u0003\u0017\t)\u0002C\u0003c\u0017\u0001\u0007\u0001\u000bC\u0003a\u0017\u0001\u0007\u0001\u000bC\u0004\u0002\u000e-\u0001\r!a\u0004\u0002\u0015I,7m\u001c:e\u0017\u0016L8\u000f\u0005\u0003<\u0003#\u0001\u0016bAA\ny\t)\u0011I\u001d:bs\"I\u0011qC\u0006\u0011\u0002\u0003\u0007\u0011\u0011D\u0001\u000eQ\u0006\u001cH)\u001a7fi\u0016\\U-_:\u0011\u0007m\nY\"C\u0002\u0002\u001eq\u0012qAQ8pY\u0016\fg.\u0001\u0011wC2LG-\u0019;f'\u0016\u001cwN\u001c3befLe\u000eZ3yI\u0011,g-Y;mi\u0012\"TCAA\u0012U\r\tI\u0002_\u0001\u000fO\u0016$\u0018J\\:uC:$H+[7f+\u0005\u0001\u0016\u0001G2sK\u0006$X\rV3naR\u000b'\r\\3B]\u0012Len]3siR1\u0011QFA\u001f\u0003\u007f\u0001B!a\f\u000289!\u0011\u0011GA\u001a\u001b\u00051\u0012bAA\u001b-\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001d\u0003w\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005Ub\u0003C\u0003a\u001d\u0001\u0007\u0001\u000bC\u0003c\u001d\u0001\u0007\u0001\u000b")
public class TestSecondaryIndex
extends HoodieSparkSqlTestBase {
    private AtomicInteger instantTime = new AtomicInteger(1);
    private final scala.collection.immutable.Map<String, String> metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key()), (Object)"true")}));
    private final scala.collection.immutable.Map<String, String> commonOpts = ((scala.collection.immutable.MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition_path"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.INLINE_CLUSTERING.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key()), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_PAYLOAD_CLASS_NAME.key()), (Object)"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORD_MERGE_MODE().key()), (Object)RecordMergeMode.COMMIT_TIME_ORDERING.name())}))).$plus$plus(this.metadataOpts());

    public AtomicInteger instantTime() {
        return this.instantTime;
    }

    public void instantTime_$eq(AtomicInteger x$1) {
        this.instantTime = x$1;
    }

    public scala.collection.immutable.Map<String, String> metadataOpts() {
        return this.metadataOpts;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    private scala.collection.immutable.Map<String, String> loadInitialBatchAndCreateSecondaryIndex(String tableName, String basePath, HoodieTestDataGenerator dataGen, Integer numInserts) {
        Buffer initialRecords = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts(this.getInstantTime(), numInserts, true))).asScala();
        Dataset initialDf = this.spark().read().json(this.spark().sparkContext().parallelize(initialRecords.toSeq(), 2, ClassTag$.MODULE$.apply(String.class)));
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)"MERGE_ON_READ"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)tableName)})));
        initialDf.write().format("hudi").options((Map)hudiOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(basePath);
        this.spark().sql(new StringBuilder(36).append("CREATE TABLE ").append(tableName).append(" USING hudi LOCATION '").append(basePath).append("'").toString());
        this.spark().sql(new StringBuilder(34).append("create index idx_rider on ").append(tableName).append(" (rider)").toString());
        return hudiOpts;
    }

    private Integer loadInitialBatchAndCreateSecondaryIndex$default$4() {
        return Predef$.MODULE$.int2Integer(50);
    }

    private void validateSecondaryIndex(String basePath, String tableName, String[] recordKeys, boolean hasDeleteKeys) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])recordKeys)).foreach((Function1 & Serializable & scala.Serializable)key -> {
            TestSecondaryIndex.$anonfun$validateSecondaryIndex$1(this, basePath, hasDeleteKeys, tableName, key);
            return BoxedUnit.UNIT;
        });
    }

    private boolean validateSecondaryIndex$default$4() {
        return false;
    }

    private String getInstantTime() {
        return String.format("%03d", new Integer(this.instantTime().incrementAndGet()));
    }

    private Dataset<Row> createTempTableAndInsert(String tableName, String basePath) {
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(748).append("\n         |create table ").append(tableName).append(" (\n         |  ts bigint,\n         |  id string,\n         |  rider string,\n         |  driver string,\n         |  fare int,\n         |  city string,\n         |  state string\n         |) using hudi\n         | options (\n         |  primaryKey ='id',\n         |  type = 'mor',\n         |  preCombineField = 'ts',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.metadata.index.secondary.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = 'id',\n         |  hoodie.datasource.write.payload.class = \"org.apache.hudi.common.model.OverwriteWithLatestAvroPayload\"\n         | )\n         | partitioned by(state)\n         | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        return this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(293).append("\n         | insert into ").append(tableName).append("\n         | values\n         | (1695159649087, '334e26e9-8355-45cc-97c6-c31daf0df330', 'rider-A', 'driver-K', 19, 'san_francisco', 'california'),\n         | (1695091554787, 'e96c4396-3fad-413a-a942-4cb36106d720', 'rider-B', 'driver-M', 27, 'austin', 'texas')\n         | ").toString())).stripMargin());
    }

    public static final /* synthetic */ void $anonfun$new$3(TestSecondaryIndex $this, File tmp$1, String tableType) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp$1.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(670).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append(tableType).append("',\n             |  preCombineField = 'ts',\n             |  hoodie.metadata.enable = 'true',\n             |  hoodie.metadata.record.index.enable = 'true',\n             |  hoodie.metadata.index.secondary.enable = 'true',\n             |  hoodie.datasource.write.payload.class = 'org.apache.hudi.common.model.OverwriteWithLatestAvroPayload'\n             | )\n             | partitioned by(ts)\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(21).append("DROP TABLE if exists ").append(tableName).toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(127).append("CREATE TABLE ").append(tableName).append(" USING hudi options (\n             |     hoodie.metadata.record.index.enable = 'true'\n             | ) LOCATION '").append(basePath).append("'").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
        $this.checkAnswer(new StringBuilder(26).append("show indexes from default.").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"column_stats", (List)new .colon.colon((Object)"column_stats", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"partition_stats", (List)new .colon.colon((Object)"partition_stats", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"record_index", (List)new .colon.colon((Object)"record_index", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)))}));
        $this.checkException(new StringBuilder(44).append("create index idx_name_price on ").append(tableName).append(" (name,price)").toString(), "Only one column can be indexed for functional or secondary index.");
        $this.spark().sql(new StringBuilder(32).append("create index idx_name on ").append(tableName).append(" (name)").toString());
        $this.checkAnswer(new StringBuilder(26).append("show indexes from default.").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"column_stats", (List)new .colon.colon((Object)"column_stats", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"partition_stats", (List)new .colon.colon((Object)"partition_stats", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"secondary_index_idx_name", (List)new .colon.colon((Object)"secondary_index", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"record_index", (List)new .colon.colon((Object)"record_index", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)))}));
        $this.spark().sql(new StringBuilder(34).append("create index idx_price on ").append(tableName).append(" (price)").toString());
        $this.checkException(new StringBuilder(34).append("create index idx_price on ").append(tableName).append(" (price)").toString(), "Index already exists: idx_price");
        $this.checkAnswer(new StringBuilder(18).append("show indexes from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"column_stats", (List)new .colon.colon((Object)"column_stats", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"partition_stats", (List)new .colon.colon((Object)"partition_stats", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"secondary_index_idx_name", (List)new .colon.colon((Object)"secondary_index", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"secondary_index_idx_price", (List)new .colon.colon((Object)"secondary_index", (List)new .colon.colon((Object)"price", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"record_index", (List)new .colon.colon((Object)"record_index", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)))}));
        $this.checkAnswer(new StringBuilder(23).append("drop index idx_name on ").append(tableName).toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
        $this.checkAnswer(new StringBuilder(18).append("show indexes from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"column_stats", (List)new .colon.colon((Object)"column_stats", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"partition_stats", (List)new .colon.colon((Object)"partition_stats", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"secondary_index_idx_price", (List)new .colon.colon((Object)"secondary_index", (List)new .colon.colon((Object)"price", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"record_index", (List)new .colon.colon((Object)"record_index", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)))}));
        $this.checkException(new StringBuilder(23).append("drop index idx_name on ").append(tableName).toString(), "Index does not exist: idx_name");
        $this.spark().sql(new StringBuilder(32).append("create index idx_name on ").append(tableName).append(" (name)").toString());
        $this.checkAnswer(new StringBuilder(23).append("drop index idx_name on ").append(tableName).toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
        $this.checkAnswer(new StringBuilder(18).append("show indexes from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"column_stats", (List)new .colon.colon((Object)"column_stats", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"partition_stats", (List)new .colon.colon((Object)"partition_stats", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"secondary_index_idx_price", (List)new .colon.colon((Object)"secondary_index", (List)new .colon.colon((Object)"price", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"record_index", (List)new .colon.colon((Object)"record_index", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)))}));
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        Assertions.assertFalse((boolean)new StringOps(Predef$.MODULE$.augmentString((String)metaClient.getTableConfig().getRelativeIndexDefinitionPath().get())).contains((Object)metaClient.getBasePath()));
        Assertions.assertTrue((boolean)metaClient.getIndexDefinitionPath().contains(metaClient.getBasePath().toString()));
        HoodieIndexDefinition indexDefinition = ((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().values().stream().filter(indexDefn -> indexDefn.getIndexType().equals("secondary_index")).findFirst().get();
        metaClient.getTableConfig().setMetadataPartitionState(metaClient, indexDefinition.getIndexName(), false);
        $this.checkAnswer(new StringBuilder(24).append("drop index idx_price on ").append(tableName).toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
        $this.checkAnswer(new StringBuilder(18).append("show indexes from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"column_stats", (List)new .colon.colon((Object)"column_stats", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"partition_stats", (List)new .colon.colon((Object)"partition_stats", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"record_index", (List)new .colon.colon((Object)"record_index", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)))}));
        $this.checkAnswer(new StringBuilder(27).append("drop index record_index on ").append(tableName).toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
        $this.checkAnswer(new StringBuilder(27).append("drop index column_stats on ").append(tableName).toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
        $this.checkAnswer(new StringBuilder(30).append("drop index partition_stats on ").append(tableName).toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
        $this.checkAnswer(new StringBuilder(18).append("show indexes from ").append(tableName).toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
        $this.checkException(new StringBuilder(24).append("drop index idx_price on ").append(tableName).toString(), "Index does not exist: idx_price");
        $this.checkExceptionContain(new StringBuilder(46).append("create index idx_price_1 on ").append(tableName).append(" (field_not_exist)").toString(), "Missing field field_not_exist");
    }

    public static final /* synthetic */ void $anonfun$new$2(TestSecondaryIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSecondaryIndex.$anonfun$new$3($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$6(TestSecondaryIndex $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.createTempTableAndInsert(tableName, basePath);
        Dataset metadataDF = $this.spark().sql(new StringBuilder(46).append("select key from hudi_metadata('").append(basePath).append("') where type=5").toString());
        long $org_scalatest_assert_macro_left = metadataDF.count();
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSecondaryIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        Set $org_scalatest_assert_macro_left2 = metaClient.getTableConfig().getMetadataPartitions();
        String $org_scalatest_assert_macro_right2 = "record_index";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSecondaryIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        $this.spark().sql(new StringBuilder(32).append("create index idx_city on ").append(tableName).append(" (city)").toString());
        metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        Set $org_scalatest_assert_macro_left3 = metaClient.getTableConfig().getMetadataPartitions();
        String $org_scalatest_assert_macro_right3 = "secondary_index_idx_city";
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSecondaryIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        Set $org_scalatest_assert_macro_left4 = metaClient.getTableConfig().getMetadataPartitions();
        String $org_scalatest_assert_macro_right4 = "record_index";
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSecondaryIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        $this.checkAnswer(new StringBuilder(80).append("select key, SecondaryIndexMetadata.isDeleted from hudi_metadata('").append(basePath).append("') where type=7").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(43).append("austin").append("$").append("e96c4396-3fad-413a-a942-4cb36106d720").toString(), BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(50).append("san_francisco").append("$").append("334e26e9-8355-45cc-97c6-c31daf0df330").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$8(TestSecondaryIndex $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.createTempTableAndInsert(tableName, basePath);
        Dataset metadataDF = $this.spark().sql(new StringBuilder(46).append("select key from hudi_metadata('").append(basePath).append("') where type=5").toString());
        long $org_scalatest_assert_macro_left = metadataDF.count();
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSecondaryIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        Set $org_scalatest_assert_macro_left2 = metaClient.getTableConfig().getMetadataPartitions();
        String $org_scalatest_assert_macro_right2 = "record_index";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSecondaryIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        $this.checkException(new StringBuilder(38).append("create index idx_city on ").append(tableName).append(" (city,state)").toString(), "Only one column can be indexed for functional or secondary index.");
    }

    public static final /* synthetic */ void $anonfun$new$10(TestSecondaryIndex $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
        scala.collection.immutable.Map<String, String> hudiOpts = $this.loadInitialBatchAndCreateSecondaryIndex(tableName, basePath, dataGen, $this.loadInitialBatchAndCreateSecondaryIndex$default$4());
        String[] initialKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(29).append("select _row_key from ").append(tableName).append(" limit 5").toString()).collect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.validateSecondaryIndex(basePath, tableName, initialKeys, $this.validateSecondaryIndex$default$4());
        long initialRecordsCount = $this.spark().sql(new StringBuilder(21).append("select _row_key from ").append(tableName).toString()).count();
        Buffer updateRecords = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueUpdates($this.getInstantTime(), Predef$.MODULE$.int2Integer(10), "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\", \"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}"))).asScala();
        Dataset updateDf = $this.spark().read().json($this.spark().sparkContext().parallelize(updateRecords.toSeq(), 2, ClassTag$.MODULE$.apply(String.class)));
        updateDf.write().format("hudi").options(hudiOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(basePath);
        String[] updateKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])updateDf.select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.validateSecondaryIndex(basePath, tableName, updateKeys, $this.validateSecondaryIndex$default$4());
        updateRecords = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueUpdates($this.getInstantTime(), Predef$.MODULE$.int2Integer(10), "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\", \"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}"))).asScala();
        updateDf = $this.spark().read().json($this.spark().sparkContext().parallelize(updateRecords.toSeq(), 2, ClassTag$.MODULE$.apply(String.class)));
        updateDf.write().format("hudi").options(hudiOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(basePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        Assertions.assertTrue((boolean)metaClient.getActiveTimeline().getCommitTimeline().filterCompletedInstants().lastInstant().isPresent());
        updateKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])updateDf.select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.validateSecondaryIndex(basePath, tableName, updateKeys, $this.validateSecondaryIndex$default$4());
        Assertions.assertEquals((long)initialRecordsCount, (long)$this.spark().sql(new StringBuilder(21).append("select _row_key from ").append(tableName).toString()).count());
        updateRecords = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueUpdates($this.getInstantTime(), Predef$.MODULE$.int2Integer(10), "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\", \"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}"))).asScala();
        updateDf = $this.spark().read().json($this.spark().sparkContext().parallelize(updateRecords.toSeq(), 2, ClassTag$.MODULE$.apply(String.class)));
        updateDf.write().format("hudi").options(hudiOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(basePath);
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        Assertions.assertTrue((boolean)metaClient.getActiveTimeline().getCompletedReplaceTimeline().lastInstant().isPresent());
        updateKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])updateDf.select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.validateSecondaryIndex(basePath, tableName, updateKeys, $this.validateSecondaryIndex$default$4());
        String[] deleteKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])initialKeys)).take(1);
        Dataset deleteDf = $this.spark().read().format("hudi").load(basePath).filter(new StringBuilder(16).append("_row_key in ('").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deleteKeys)).mkString("','")).append("')").toString());
        deleteDf.write().format("hudi").options(hudiOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(basePath);
        $this.validateSecondaryIndex(basePath, tableName, deleteKeys, true);
        String[] nonDeletedKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])initialKeys)).diff((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])deleteKeys));
        $this.validateSecondaryIndex(basePath, tableName, nonDeletedKeys, $this.validateSecondaryIndex$default$4());
        Buffer finalUpdateRecords = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueUpdates($this.getInstantTime(), Predef$.MODULE$.int2Integer(10), "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\", \"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}"))).asScala();
        Dataset finalUpdateDf = $this.spark().read().json($this.spark().sparkContext().parallelize(finalUpdateRecords.toSeq(), 2, ClassTag$.MODULE$.apply(String.class)));
        finalUpdateDf.write().format("hudi").options(hudiOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(basePath);
        String[] finalUpdateKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])finalUpdateDf.select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.validateSecondaryIndex(basePath, tableName, nonDeletedKeys, $this.validateSecondaryIndex$default$4());
        $this.validateSecondaryIndex(basePath, tableName, finalUpdateKeys, $this.validateSecondaryIndex$default$4());
        dataGen.close();
    }

    public static final /* synthetic */ void $anonfun$new$18(TestSecondaryIndex $this, File tmp$2, String operationType) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName).toString();
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
        scala.collection.immutable.Map<String, String> hudiOpts = $this.loadInitialBatchAndCreateSecondaryIndex(tableName, basePath, dataGen, $this.loadInitialBatchAndCreateSecondaryIndex$default$4());
        String[] initialKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(29).append("select _row_key from ").append(tableName).append(" limit 5").toString()).collect())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.validateSecondaryIndex(basePath, tableName, initialKeys, $this.validateSecondaryIndex$default$4());
        Buffer records = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueUpdates($this.getInstantTime(), Predef$.MODULE$.int2Integer(10), "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\", \"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}"))).asScala();
        Dataset df = $this.spark().read().json($this.spark().sparkContext().parallelize(records.toSeq(), 2, ClassTag$.MODULE$.apply(String.class)));
        $this.checkException(() -> df.write().format("hudi").options((Map)hudiOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), operationType).mode(SaveMode.Append).save(basePath), new StringBuilder(45).append("Can not perform operation ").append(WriteOperationType.fromValue((String)operationType)).append(" on secondary index").toString());
        df.write().format("hudi").options(hudiOpts).option(HoodieMetadataConfig.SECONDARY_INDEX_ENABLE_PROP.key(), "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), operationType).mode(SaveMode.Append).save(basePath);
        dataGen.close();
    }

    public static final /* synthetic */ void $anonfun$new$17(TestSecondaryIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)WriteOperationType.INSERT_OVERWRITE.value(), (List)new .colon.colon((Object)WriteOperationType.INSERT_OVERWRITE_TABLE.value(), (List)new .colon.colon((Object)WriteOperationType.DELETE_PARTITION.value(), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)operationType -> {
            TestSecondaryIndex.$anonfun$new$18($this, tmp, operationType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$27(String deleteFileId$1, HoodieWriteStat x$10) {
        String string = x$10.getFileId();
        String string2 = deleteFileId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$22(TestSecondaryIndex $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
        int numInserts = 5;
        scala.collection.immutable.Map<String, String> hudiOpts = $this.loadInitialBatchAndCreateSecondaryIndex(tableName, basePath, dataGen, Predef$.MODULE$.int2Integer(numInserts));
        String[] initialKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(29).append("select _row_key from ").append(tableName).append(" limit 5").toString()).collect())).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.validateSecondaryIndex(basePath, tableName, initialKeys, $this.validateSecondaryIndex$default$4());
        Buffer updateRecords = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueUpdates($this.getInstantTime(), Predef$.MODULE$.int2Integer(1), "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\", \"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}"))).asScala();
        Dataset updateDf = $this.spark().read().json($this.spark().sparkContext().parallelize(updateRecords.toSeq(), 1, ClassTag$.MODULE$.apply(String.class)));
        String[] updateKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])updateDf.select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String recordKeyToUpdate = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])updateKeys)).head();
        String initialSecondaryKey = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(64).append("SELECT key FROM hudi_metadata('").append(basePath).append("') WHERE type=7 AND key LIKE '%").append("$").append(recordKeyToUpdate).append("'").toString()).collect())).map((Function1 & Serializable & scala.Serializable)indexKey -> SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)indexKey.getString(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).head();
        updateDf.write().format("hudi").options(hudiOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(basePath);
        $this.validateSecondaryIndex(basePath, tableName, updateKeys, $this.validateSecondaryIndex$default$4());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        HoodieInstant firstInstant = (HoodieInstant)metaClient.reloadActiveTimeline().filterCompletedInstants().firstInstant().get();
        scala.collection.immutable.Map readOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")})));
        Dataset timeTravelDF = $this.spark().read().format("hudi").options((Map)readOpts).option("as.of.instant", firstInstant.requestedTime()).load(basePath);
        Assertions.assertEquals((long)numInserts, (long)timeTravelDF.count());
        Assertions.assertEquals((long)1L, (long)timeTravelDF.where(new StringBuilder(13).append("_row_key = '").append(recordKeyToUpdate).append("'").toString()).count());
        String secondaryKey = ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timeTravelDF.where(new StringBuilder(13).append("_row_key = '").append(recordKeyToUpdate).append("'").toString()).select("rider", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).head()).getString(0);
        Assertions.assertEquals((Object)initialSecondaryKey, (Object)secondaryKey);
        Dataset deleteDf = $this.spark().read().format("hudi").load(basePath).filter(new StringBuilder(16).append("_row_key in ('").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])updateKeys)).mkString("','")).append("')").toString());
        String deleteFileId = ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deleteDf.select("_hoodie_file_name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).head()).getString(0);
        deleteDf.write().format("hudi").options(hudiOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(basePath);
        $this.validateSecondaryIndex(basePath, tableName, updateKeys, true);
        HoodieCommitMetadata firstCommitMetadata = TimelineMetadataUtils.deserializeCommitMetadata((byte[])((byte[])metaClient.reloadActiveTimeline().getInstantDetails(firstInstant).get()));
        Map partitionToWriteStats = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(firstCommitMetadata.getPartitionToWriteStats()).asScala()).mapValues((Function1 & Serializable & scala.Serializable)x$9 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$9).asScala()).toList());
        Option matchingPath = ((IterableLike)partitionToWriteStats.values().flatten((Function1)Predef$.MODULE$.$conforms())).find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TestSecondaryIndex.$anonfun$new$27(deleteFileId, x$10))).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.getPath());
        Assertions.assertTrue((boolean)matchingPath.isDefined());
        StoragePath dataFile = new StoragePath(basePath, (String)matchingPath.get());
        HoodieStorage storage = metaClient.getStorage();
        storage.deleteFile(dataFile);
        storage.createNewFile(dataFile);
        $this.checkExceptionContain(() -> $this.spark().read().format("hudi").options((Map)readOpts).option("as.of.instant", firstInstant.requestedTime()).load(basePath).count(), new StringBuilder(22).append(dataFile.toString()).append(" is not a Parquet file").toString());
        dataGen.close();
    }

    public static final /* synthetic */ void $anonfun$new$31(TestSecondaryIndex $this, File tmp) {
        String tableName = new StringBuilder(15).append($this.generateTableName()).append("_si_auto_keygen").toString();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(737).append("\n           CREATE TABLE ").append(tableName).append(" (\n           |    ts LONG,\n           |    id STRING,\n           |    rider STRING,\n           |    driver STRING,\n           |    fare DOUBLE,\n           |    dateDefault STRING,\n           |    date STRING,\n           |    city STRING,\n           |    state STRING\n           |) USING HUDI\n           |options(\n           |    type = 'mor',\n           |    hoodie.metadata.enable = 'true',\n           |    hoodie.enable.data.skipping = 'true',\n           |    hoodie.metadata.record.index.enable = 'true',\n           |    hoodie.datasource.write.payload.class = 'org.apache.hudi.common.model.OverwriteWithLatestAvroPayload'\n           |)\n           |PARTITIONED BY (state)\n           |location '").append(basePath).append("'\n           |").toString())).stripMargin());
        $this.spark().sql("set hoodie.parquet.small.file.limit=0");
        Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? $this.spark().sql("set spark.sql.defaultColumn.enabled=false") : BoxedUnit.UNIT;
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(350).append("\n           |INSERT INTO ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n           |  (1695414520,'trip2','rider-C','driver-M',27.70,'2024-11-30 01:30:40', '2024-11-30', 'sunnyvale','california'),\n           |  (1699349649,'trip5','rider-A','driver-Q',3.32, '2019-11-30 01:30:40', '2019-11-30', 'san_diego','texas')\n           |").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(32).append("CREATE INDEX idx_city on ").append(tableName).append(" (city)").toString());
        String[] expectedSecondaryKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(37).append("SELECT _hoodie_record_key, city from ").append(tableName).toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> SecondaryIndexKeyUtils.constructSecondaryIndexKey((String)row.getString(1), (String)row.getString(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] actualSecondaryKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(65).append("SELECT key FROM hudi_metadata('").append(basePath).append("') WHERE type=7 AND key LIKE '%").append("$").append("%'").toString()).collect())).map((Function1 & Serializable & scala.Serializable)indexKey -> indexKey.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertEquals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedSecondaryKeys)).toSet(), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])actualSecondaryKeys)).toSet());
        $this.spark().sql(new StringBuilder(58).append("UPDATE ").append(tableName).append(" SET city = 'san_francisco' WHERE rider = 'rider-C'").toString());
        expectedSecondaryKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(37).append("SELECT _hoodie_record_key, city from ").append(tableName).toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> SecondaryIndexKeyUtils.constructSecondaryIndexKey((String)row.getString(1), (String)row.getString(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        actualSecondaryKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(65).append("SELECT key FROM hudi_metadata('").append(basePath).append("') WHERE type=7 AND key LIKE '%").append("$").append("%'").toString()).collect())).map((Function1 & Serializable & scala.Serializable)indexKey -> indexKey.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertEquals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedSecondaryKeys)).toSet(), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])actualSecondaryKeys)).toSet());
    }

    public static final /* synthetic */ void $anonfun$validateSecondaryIndex$1(TestSecondaryIndex $this, String basePath$3, boolean hasDeleteKeys$1, String tableName$1, String key) {
        String[] secondaryKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(64).append("SELECT key FROM hudi_metadata('").append(basePath$3).append("') WHERE type=7 AND key LIKE '%").append("$").append(key).append("'").toString()).collect())).map((Function1 & Serializable & scala.Serializable)indexKey -> SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)indexKey.getString(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        if (hasDeleteKeys$1) {
            Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])secondaryKeys)).isEmpty());
            return;
        }
        Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])secondaryKeys)).nonEmpty(), (String)new StringBuilder(39).append("Secondary index entry missing for key: ").append(key).toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])secondaryKeys)).foreach((Function1 & Serializable & scala.Serializable)secKey -> {
            long $org_scalatest_assert_macro_left = $this.spark().sql(new StringBuilder(41).append("SELECT _row_key FROM ").append(tableName$1).append(" WHERE _row_key = '").append(key).append("'").toString()).count();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(80).append("Record key '").append(key).append("' with secondary key '").append((String)secKey).append("' should be present in the data but is missing").toString(), Prettifier$.MODULE$.default(), new Position("TestSecondaryIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
        });
    }

    public TestSecondaryIndex() {
        this.test("Test Create/Show/Drop Secondary Index with External Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSecondaryIndex.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSecondaryIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("Test Secondary Index Creation With hudi_metadata TVF", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSecondaryIndex.$anonfun$new$6(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSecondaryIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.test("Test Secondary Index Creation Failure For Multiple Fields", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSecondaryIndex.$anonfun$new$8(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSecondaryIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
        this.test("Test Secondary Index With Updates Compaction Clustering Deletes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSecondaryIndex.$anonfun$new$10(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSecondaryIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        this.test("Test Secondary Index With Overwrite and Delete Partition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSecondaryIndex.$anonfun$new$17(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSecondaryIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        this.test("Test Secondary Index With Time Travel Query", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSecondaryIndex.$anonfun$new$22(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSecondaryIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
        this.test("Test Secondary Index With Auto Record Key Generation", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSecondaryIndex.$anonfun$new$31(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSecondaryIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
    }
}

