/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.common;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.Assertions;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;

public final class HoodieSparkSqlTestBase$
implements scala.Serializable {
    public static HoodieSparkSqlTestBase$ MODULE$;
    private final Pattern NAME_FORMAT_0_X;

    static {
        new HoodieSparkSqlTestBase$();
    }

    public final Pattern NAME_FORMAT_0_X() {
        return this.NAME_FORMAT_0_X;
    }

    public HoodieCommitMetadata getLastCommitMetadata(SparkSession spark, String tablePath) {
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)spark, (String)tablePath);
        return (HoodieCommitMetadata)((Pair)metaClient.getActiveTimeline().getLastCommitMetadataWithValidData().get()).getRight();
    }

    public HoodieCleanMetadata getLastCleanMetadata(SparkSession spark, String tablePath) {
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)spark, (String)tablePath);
        HoodieInstant cleanInstant = (HoodieInstant)metaClient.reloadActiveTimeline().getCleanerTimeline().filterCompletedInstants().lastInstant().get();
        return TimelineMetadataUtils.deserializeHoodieCleanMetadata((byte[])((byte[])metaClient.getActiveTimeline().getInstantDetails(cleanInstant).get()));
    }

    public void validateTableConfig(HoodieStorage storage, String basePath, Map<String, String> expectedConfigs, Seq<String> nonExistentConfigs) {
        HoodieTableConfig tableConfig = HoodieTableConfig.loadFromHoodieProps((HoodieStorage)storage, (String)basePath);
        expectedConfigs.foreach((Function1 & Serializable & scala.Serializable)e -> {
            HoodieSparkSqlTestBase$.$anonfun$validateTableConfig$1(tableConfig, e);
            return BoxedUnit.UNIT;
        });
        nonExistentConfigs.foreach((Function1 & Serializable & scala.Serializable)e -> {
            HoodieSparkSqlTestBase$.$anonfun$validateTableConfig$2(tableConfig, e);
            return BoxedUnit.UNIT;
        });
    }

    public boolean org$apache$spark$sql$hudi$common$HoodieSparkSqlTestBase$$checkMessageContains(Throwable e, String text) {
        return e.getMessage().trim().contains(text.trim());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$validateTableConfig$1(HoodieTableConfig tableConfig$1, Tuple2 e) {
        Assertions.assertEquals((Object)e._2(), (Object)tableConfig$1.getString((String)e._1()), (String)new StringBuilder(32).append("Table config ").append(e._1()).append(" should be ").append(e._2()).append(" but is ").append(tableConfig$1.getString((String)e._1())).toString());
    }

    public static final /* synthetic */ void $anonfun$validateTableConfig$2(HoodieTableConfig tableConfig$1, String e) {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(tableConfig$1.contains(e)), (String)new StringBuilder(42).append(e).append(" should not be present in the table config").toString());
    }

    private HoodieSparkSqlTestBase$() {
        MODULE$ = this;
        this.NAME_FORMAT_0_X = Pattern.compile("^(\\d+)(\\.\\w+)(\\.\\D+)?$");
    }
}

