/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.common;

import java.io.File;
import java.io.Serializable;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DefaultSparkRecordMerger;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.ExceptionUtil;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.index.inmemory.HoodieInMemoryHashIndex;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.log4j.Level;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.util.Utils$;
import org.joda.time.DateTimeZone;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r-g\u0001\u0002\u001b6\u0001\tCQa\u0016\u0001\u0005\u0002aCqa\u0017\u0001C\u0002\u0013%A\f\u0003\u0004d\u0001\u0001\u0006I!\u0018\u0005\tI\u0002A)\u0019!C\u0005K\"AA\b\u0001EC\u0002\u0013Ea\u000eC\u0004t\u0001\u0001\u0007I\u0011\u0002;\t\u0011}\u0004\u0001\u0019!C\u0005\u0003\u0003Aq!a\u0005\u0001A\u0003&Q\u000fC\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0003\u0002\u0018!I\u0011\u0011\b\u0001A\u0002\u0013%\u00111\b\u0005\t\u0003\u007f\u0001\u0001\u0015)\u0003\u0002\u001a!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBA'\u0001\u0011E\u0011q\n\u0005\b\u0003#\u0002A\u0011CA*\u0011\u001d\ty\u0006\u0001C\t\u0003CBq!a\u001a\u0001\t#\nI\u0007C\u0004\u0002(\u0002!\t\"!+\t\u000f\u0005-\u0006\u0001\"\u0015\u0002P!9\u0011Q\u0016\u0001\u0005\u0012\u0005=\u0006bBAW\u0001\u0011E\u00111\u001a\u0005\b\u0003C\u0004A\u0011CAr\u0011\u001d\ti\u000f\u0001C\t\u0003_Dq!a?\u0001\t#\ti\u0010C\u0004\u0002|\u0002!\tB!\u0002\t\u000f\tm\u0001\u0001\"\u0005\u0003\u001e!9!Q\u0005\u0001\u0005\u0012\t\u001d\u0002b\u0002B\u0013\u0001\u0011E!q\u0006\u0005\b\u0005o\u0001A\u0011\u0003B\u001d\u0011\u001d\u0011\u0019\u0005\u0001C\t\u0005\u000bBqAa\u0011\u0001\t#\u0011y\u0005C\u0004\u0003`\u0001!\tB!\u0019\t\u000f\tm\u0004\u0001\"\u0001\u0003~!9!1\u0011\u0001\u0005\u0012\t\u0015\u0005b\u0002BE\u0001\u0011E!1\u0012\u0005\b\u0005/\u0003A\u0011\u0003BM\u0011\u001d\u0011y\f\u0001C\t\u0005\u0003DqAa3\u0001\t#\u0011i\rC\u0004\u0003Z\u0002!\tBa7\t\u000f\t\u001d\b\u0001\"\u0005\u0003j\"I1Q\u0005\u0001\u0012\u0002\u0013E1q\u0005\u0005\n\u0007{\u0001\u0011\u0013!C\t\u0007\u007f9qaa\u00116\u0011\u0003\u0019)E\u0002\u00045k!\u00051q\t\u0005\u0007/.\"\ta!\u0016\t\u0013\r]3F1A\u0005\u0006\re\u0003\u0002CB4W\u0001\u0006iaa\u0017\t\u000f\r%4\u0006\"\u0001\u0004l!911P\u0016\u0005\u0002\ru\u0004bBBIW\u0011\u000511\u0013\u0005\b\u0007_[C\u0011BBY\u0011%\u0019\tmKA\u0001\n\u0013\u0019\u0019M\u0001\fI_>$\u0017.Z*qCJ\\7+\u001d7UKN$()Y:f\u0015\t1t'\u0001\u0004d_6lwN\u001c\u0006\u0003qe\nA\u0001[;eS*\u0011!hO\u0001\u0004gFd'B\u0001\u001f>\u0003\u0015\u0019\b/\u0019:l\u0015\tqt(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0001\u0006\u0019qN]4\u0004\u0001M\u0019\u0001aQ*\u0011\u0005\u0011\u0003fBA#N\u001d\t15J\u0004\u0002H\u00156\t\u0001J\u0003\u0002J\u0003\u00061AH]8pizJ\u0011\u0001Q\u0005\u0003\u0019~\n\u0011b]2bY\u0006$Xm\u001d;\n\u00059{\u0015a\u00029bG.\fw-\u001a\u0006\u0003\u0019~J!!\u0015*\u0003\u0011\u0019+hnU;ji\u0016T!AT(\u0011\u0005Q+V\"A(\n\u0005Y{%!\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]!mY\u00061A(\u001b8jiz\"\u0012!\u0017\t\u00035\u0002i\u0011!N\u0001\u0004\u0019>;U#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001|\u0014!B:mMRR\u0017B\u00012`\u0005\u0019aunZ4fe\u0006!AjT$!\u00039\u0019\b/\u0019:l/\u0006\u0014X\rS8vg\u0016,\u0012A\u001a\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\f!![8\u000b\u0003-\fAA[1wC&\u0011Q\u000e\u001b\u0002\u0005\r&dW-F\u0001p!\t\u0001\u0018/D\u0001:\u0013\t\u0011\u0018H\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0004uC\ndW-\u00133\u0016\u0003U\u0004\"A^?\u000e\u0003]T!\u0001_=\u0002\r\u0005$x.\\5d\u0015\tQ80\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001 6\u0002\tU$\u0018\u000e\\\u0005\u0003}^\u0014Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018a\u0003;bE2,\u0017\nZ0%KF$B!a\u0001\u0002\u0010A!\u0011QAA\u0006\u001b\t\t9A\u0003\u0002\u0002\n\u0005)1oY1mC&!\u0011QBA\u0004\u0005\u0011)f.\u001b;\t\u0011\u0005Eq!!AA\u0002U\f1\u0001\u001f\u00132\u0003!!\u0018M\u00197f\u0013\u0012\u0004\u0013!C3yiJ\f7i\u001c8g+\t\tI\u0002\u0005\u0005\u0002\u001c\u0005\u0015\u0012\u0011FA\u0015\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012!C5n[V$\u0018M\u00197f\u0015\u0011\t\u0019#a\u0002\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002(\u0005u!aA'baB!\u00111FA\u001a\u001d\u0011\ti#a\f\u0011\u0007\u001d\u000b9!\u0003\u0003\u00022\u0005\u001d\u0011A\u0002)sK\u0012,g-\u0003\u0003\u00026\u0005]\"AB*ue&twM\u0003\u0003\u00022\u0005\u001d\u0011!D3yiJ\f7i\u001c8g?\u0012*\u0017\u000f\u0006\u0003\u0002\u0004\u0005u\u0002\"CA\t\u0015\u0005\u0005\t\u0019AA\r\u0003))\u0007\u0010\u001e:b\u0007>tg\rI\u0001\ngB\f'o[\"p]\u001a$\"!!\u0012\u0011\t\u0005\u001d\u0013\u0011J\u0007\u0002w%\u0019\u00111J\u001e\u0003\u0013M\u0003\u0018M]6D_:4\u0017AE5oSR\fV/\u001a:z\u0013:$W\r_\"p]\u001a$\"!a\u0001\u0002\u0017]LG\u000f\u001b+f[B$\u0015N\u001d\u000b\u0005\u0003\u0007\t)\u0006C\u0004\u0002X9\u0001\r!!\u0017\u0002\u0003\u0019\u0004r!!\u0002\u0002\\\u0019\f\u0019!\u0003\u0003\u0002^\u0005\u001d!!\u0003$v]\u000e$\u0018n\u001c82\u0003M9W\r\u001e+bE2,7\u000b^8sC\u001e,\u0007+\u0019;i)\u0011\tI#a\u0019\t\u000f\u0005\u0015t\u00021\u0001\u0002*\u0005IA/\u00192mK:\u000bW.Z\u0001\u0005i\u0016\u001cH\u000f\u0006\u0004\u0002l\u0005M\u0015q\u0013\u000b\u0005\u0003[\n\u0019\t\u0006\u0003\u0002\u0004\u0005=\u0004bBA9!\u0001\u000f\u00111O\u0001\u0004a>\u001c\b\u0003BA;\u0003\u007fj!!a\u001e\u000b\t\u0005e\u00141P\u0001\u0007g>,(oY3\u000b\u0007\u0005ut(A\u0005tG\u0006d\u0017m\u0019;jG&!\u0011\u0011QA<\u0005!\u0001vn]5uS>t\u0007\u0002CAC!\u0011\u0005\r!a\"\u0002\u000fQ,7\u000f\u001e$v]B1\u0011QAAE\u0003\u001bKA!a#\u0002\b\tAAHY=oC6,g\b\u0005\u0003\u0002\u0006\u0005=\u0015\u0002BAI\u0003\u000f\u00111!\u00118z\u0011\u001d\t)\n\u0005a\u0001\u0003S\t\u0001\u0002^3ti:\u000bW.\u001a\u0005\b\u00033\u0003\u0002\u0019AAN\u0003!!Xm\u001d;UC\u001e\u001c\bCBA\u0003\u0003;\u000b\t+\u0003\u0003\u0002 \u0006\u001d!A\u0003\u001fsKB,\u0017\r^3e}A\u0019A+a)\n\u0007\u0005\u0015vJA\u0002UC\u001e\f\u0011cZ3oKJ\fG/\u001a+bE2,g*Y7f+\t\tI#\u0001\u0005bMR,'/\u00117m\u0003-\u0019\u0007.Z2l\u0003:\u001cx/\u001a:\u0015\t\u0005E\u0016\u0011\u001a\u000b\u0005\u0003\u0007\t\u0019\fC\u0004\u00026N\u0001\r!a.\u0002\u000f\u0015D\b/Z2ugB1\u0011QAAO\u0003s\u0003b!a/\u0002D\u00065e\u0002BA_\u0003\u0003t1aRA`\u0013\t\tI!C\u0002O\u0003\u000fIA!!2\u0002H\n\u00191+Z9\u000b\u00079\u000b9\u0001\u0003\u0004;'\u0001\u0007\u0011\u0011\u0006\u000b\u0005\u0003\u001b\f\t\u000e\u0006\u0003\u0002\u0004\u0005=\u0007bBA[)\u0001\u0007\u0011q\u0017\u0005\b\u0003'$\u0002\u0019AAk\u0003\u0015\t'O]1z!\u0019\t)!a6\u0002\\&!\u0011\u0011\\A\u0004\u0005\u0015\t%O]1z!\r\u0001\u0018Q\\\u0005\u0004\u0003?L$a\u0001*po\u0006a2\r[3dW:+7\u000f^3e\u000bb\u001cW\r\u001d;j_:\u001cuN\u001c;bS:\u001cH\u0003BAs\u0003W$B!a\u0001\u0002h\"9\u0011\u0011^\u000bA\u0002\u0005%\u0012\u0001C3se>\u0014Xj]4\t\ri*\u0002\u0019AA\u0015\u0003=\u0019\u0007.Z2l\u000bb\u001cW\r\u001d;j_:\u001cH\u0003BAy\u0003s$B!a\u0001\u0002t\"9\u0011Q\u001f\fA\u0002\u0005]\u0018!C3se>\u0014Xj]4t!\u0019\tY,a1\u0002*!1!H\u0006a\u0001\u0003S\tab\u00195fG.,\u0005pY3qi&|g\u000e\u0006\u0003\u0002\u0000\n\rA\u0003BA\u0002\u0005\u0003Aq!!;\u0018\u0001\u0004\tI\u0003\u0003\u0004;/\u0001\u0007\u0011\u0011\u0006\u000b\u0005\u0005\u000f\u0011Y\u0001\u0006\u0003\u0002\u0004\t%\u0001bBAu1\u0001\u0007\u0011\u0011\u0006\u0005\b\u0005\u001bA\u0002\u0019\u0001B\b\u0003!\u0011XO\u001c8bE2,\u0007\u0003\u0002B\t\u0005/i!Aa\u0005\u000b\u0007\tU!.\u0001\u0003mC:<\u0017\u0002\u0002B\r\u0005'\u0011\u0001BU;o]\u0006\u0014G.Z\u0001\u0015G\",7m\u001b(fgR,G-\u0012=dKB$\u0018n\u001c8\u0015\t\t}!1\u0005\u000b\u0005\u0003\u0007\u0011\t\u0003C\u0004\u0002jf\u0001\r!!\u000b\t\riJ\u0002\u0019AA\u0015\u0003U\u0019\u0007.Z2l\u000bb\u001cW\r\u001d;j_:\u001cuN\u001c;bS:$BA!\u000b\u0003.Q!\u00111\u0001B\u0016\u0011\u001d\tIO\u0007a\u0001\u0003SAqA!\u0004\u001b\u0001\u0004\u0011y\u0001\u0006\u0003\u00032\tUB\u0003BA\u0002\u0005gAq!!;\u001c\u0001\u0004\tI\u0003\u0003\u0004;7\u0001\u0007\u0011\u0011F\u0001\u0014G\",7m[#yG\u0016\u0004H/[8o\u001b\u0006$8\r\u001b\u000b\u0005\u0005w\u0011\t\u0005\u0006\u0003\u0002\u0004\tu\u0002b\u0002B 9\u0001\u0007\u0011\u0011F\u0001\u000eKJ\u0014xN]'tOJ+w-\u001a=\t\rib\u0002\u0019AA\u0015\u0003-:W\r^#ya\u0016\u001cG/\u001a3V]J,7o\u001c7wK\u0012\u001cu\u000e\\;n]\u0016C8-\u001a9uS>tW*Z:tC\u001e,GCBA\u0015\u0005\u000f\u0012Y\u0005C\u0004\u0003Ju\u0001\r!!\u000b\u0002\u0015\r|G.^7o\u001d\u0006lW\rC\u0004\u0003Nu\u0001\r!!\u000b\u0002\u001fQ\f'oZ3u)\u0006\u0014G.\u001a(b[\u0016$b!!\u000b\u0003R\tM\u0003b\u0002B%=\u0001\u0007\u0011\u0011\u0006\u0005\b\u0005+r\u0002\u0019\u0001B,\u0003=1\u0017.\u001a7e\u001d\u0006lW\rV;qY\u0016\u001c\bCBA^\u0003\u0007\u0014I\u0006\u0005\u0006\u0002\u0006\tm\u0013\u0011FA\u0015\u0003SIAA!\u0018\u0002\b\t1A+\u001e9mKN\n1C^1mS\u0012\fG/\u001a+bE2,7k\u00195f[\u0006$b!a\u0001\u0003d\t\u0015\u0004bBA3?\u0001\u0007\u0011\u0011\u0006\u0005\b\u0005Oz\u0002\u0019\u0001B5\u0003Q)\u0007\u0010]3di\u0016$7\u000b\u001e:vGR4\u0015.\u001a7egB1\u00111\u0018B6\u0005_JAA!\u001c\u0002H\n!A*[:u!\u0011\u0011\tHa\u001e\u000e\u0005\tM$b\u0001B;s\u0005)A/\u001f9fg&!!\u0011\u0010B:\u0005-\u0019FO];di\u001aKW\r\u001c3\u0002+\u0011\u0014x\u000e\u001d+za\u0016d\u0015\u000e^3sC2\u0004&/\u001a4jqR!\u0011Q\u0012B@\u0011\u001d\u0011\t\t\ta\u0001\u0003\u001b\u000bQA^1mk\u0016\fq\"\u001a=ue\u0006\u001cGOU1x-\u0006dW/\u001a\u000b\u0005\u0003\u001b\u00139\tC\u0004\u0003\u0002\u0006\u0002\r!!$\u0002\u0015\u0015D\u0018n\u001d;t!\u0006$\b\u000e\u0006\u0003\u0003\u000e\nM\u0005\u0003BA\u0003\u0005\u001fKAA!%\u0002\b\t9!i\\8mK\u0006t\u0007b\u0002BKE\u0001\u0007\u0011\u0011F\u0001\tM&dW\rU1uQ\u0006Yq/\u001b;i'Fc5i\u001c8g+\u0011\u0011YJa)\u0015\t\tu%1\u0017\u000b\u0005\u0005?\u0013y\u000b\u0005\u0003\u0003\"\n\rF\u0002\u0001\u0003\b\u0005K\u001b#\u0019\u0001BT\u0005\u0005!\u0016\u0003\u0002BU\u0003\u001b\u0003B!!\u0002\u0003,&!!QVA\u0004\u0005\u001dqu\u000e\u001e5j]\u001eD\u0001\"a\u0016$\t\u0003\u0007!\u0011\u0017\t\u0007\u0003\u000b\tIIa(\t\u000f\tU6\u00051\u0001\u00038\u0006)\u0001/Y5sgB1\u0011QAAO\u0005s\u0003\u0002\"!\u0002\u0003<\u0006%\u0012\u0011F\u0005\u0005\u0005{\u000b9A\u0001\u0004UkBdWMM\u0001\no&$\b\u000eV1cY\u0016$BAa1\u0003JR!\u00111\u0001Bc\u0011\u001d\t9\u0006\na\u0001\u0005\u000f\u0004\u0002\"!\u0002\u0002\\\u0005%\u00121\u0001\u0005\b\u0003K\"\u0003\u0019AA\u0015\u0003e9\u0018\u000e\u001e5Ta\u0006\u00148nU9m'\u0016\u001c8/[8o\u0007>tg-[4\u0015\t\t='Q\u001b\u000b\u0005\u0003\u0007\u0011\t\u000e\u0003\u0005\u0002X\u0015\"\t\u0019\u0001Bj!\u0019\t)!!#\u0002\u0004!9!q[\u0013A\u0002\t]\u0016\u0001E2p]\u001aLwMT1nKZ\u000bG.^3t\u0003\u0019:\u0018\u000e\u001e5Ta\u0006\u00148nU9m'\u0016\u001c8/[8o\u0007>tg-[4XSRD7i\u001c8eSRLwN\u001c\u000b\u0005\u0005;\u0014\t\u000f\u0006\u0003\u0002\u0004\t}\u0007\u0002CA,M\u0011\u0005\rAa5\t\u000f\t]g\u00051\u0001\u0003dB1\u0011QAAO\u0005K\u0004\u0002\"!\u0002\u0003<\ne&QR\u0001\u000fo&$\bNU3d_J$G+\u001f9f)\u0019\u0011YOa<\u0004\u001cQ!\u00111\u0001Bw\u0011!\t9f\nCA\u0002\tM\u0007\"\u0003ByOA\u0005\t\u0019\u0001Bz\u0003-\u0011XmY8sIRK\b/Z:\u0011\r\u0005m\u00161\u0019B{!\u0011\u00119p!\u0006\u000f\t\te8q\u0002\b\u0005\u0005w\u001cIA\u0004\u0003\u0003~\u000e\u0015a\u0002\u0002B\u0000\u0007\u0007q1ARB\u0001\u0013\tqt(\u0003\u00029{%\u0019aga\u0002\u000b\u0005aj\u0014\u0002BB\u0006\u0007\u001b\tQ!\\8eK2T1ANB\u0004\u0013\u0011\u0019\tba\u0005\u0002\u0019!{w\u000eZ5f%\u0016\u001cwN\u001d3\u000b\t\r-1QB\u0005\u0005\u0007/\u0019IB\u0001\tI_>$\u0017.\u001a*fG>\u0014H\rV=qK*!1\u0011CB\n\u0011%\u0019ib\nI\u0001\u0002\u0004\u0019y\"\u0001\u0007sK\u000e|'\u000fZ\"p]\u001aLw\r\u0005\u0005\u0002,\r\u0005\"Q_B\u0012\u0013\u0011\t9#a\u000e\u0011\u0011\u0005-2\u0011EA\u0015\u0003S\t\u0001d^5uQJ+7m\u001c:e)f\u0004X\r\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019IC\u000b\u0003\u0003t\u000e-2FAB\u0017!\u0011\u0019yc!\u000f\u000e\u0005\rE\"\u0002BB\u001a\u0007k\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\r]\u0012qA\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u001e\u0007c\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003a9\u0018\u000e\u001e5SK\u000e|'\u000f\u001a+za\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0007\u0003RCaa\b\u0004,\u00051\u0002j\\8eS\u0016\u001c\u0006/\u0019:l'FdG+Z:u\u0005\u0006\u001cX\r\u0005\u0002[WM)1f!\u0013\u0004PA!\u0011QAB&\u0013\u0011\u0019i%a\u0002\u0003\r\u0005s\u0017PU3g!\u0011\t)a!\u0015\n\t\rM\u0013q\u0001\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0007\u000b\nqBT!N\u000b~3uJU'B)~\u0003t\fW\u000b\u0003\u00077\u0002Ba!\u0018\u0004d5\u00111q\f\u0006\u0004\u0007CZ\u0018!\u0002:fO\u0016D\u0018\u0002BB3\u0007?\u0012q\u0001U1ui\u0016\u0014h.\u0001\tO\u00036+uLR(S\u001b\u0006#v\fM0YA\u0005)r-\u001a;MCN$8i\\7nSRlU\r^1eCR\fGCBB7\u0007k\u001a9\b\u0005\u0003\u0004p\rETBAB\n\u0013\u0011\u0019\u0019ha\u0005\u0003)!{w\u000eZ5f\u0007>lW.\u001b;NKR\fG-\u0019;b\u0011\u0015at\u00061\u0001p\u0011\u001d\u0019Ih\fa\u0001\u0003S\t\u0011\u0002^1cY\u0016\u0004\u0016\r\u001e5\u0002)\u001d,G\u000fT1ti\u000ecW-\u00198NKR\fG-\u0019;b)\u0019\u0019yh!$\u0004\u0010B!1\u0011QBE\u001b\t\u0019\u0019I\u0003\u0003\u0004\f\r\u0015%\u0002BBD\u0007\u000f\tA!\u0019<s_&!11RBB\u0005MAun\u001c3jK\u000ecW-\u00198NKR\fG-\u0019;b\u0011\u0015a\u0004\u00071\u0001p\u0011\u001d\u0019I\b\ra\u0001\u0003S\t1C^1mS\u0012\fG/\u001a+bE2,7i\u001c8gS\u001e$\"\"a\u0001\u0004\u0016\u000e\r6qUBV\u0011\u001d\u00199*\ra\u0001\u00073\u000bqa\u001d;pe\u0006<W\r\u0005\u0003\u0004\u001c\u000e}UBABO\u0015\u0011\u00199ja\u0002\n\t\r\u00056Q\u0014\u0002\u000e\u0011>|G-[3Ti>\u0014\u0018mZ3\t\u000f\r\u0015\u0016\u00071\u0001\u0002*\u0005A!-Y:f!\u0006$\b\u000eC\u0004\u0004*F\u0002\raa\t\u0002\u001f\u0015D\b/Z2uK\u0012\u001cuN\u001c4jONDqa!,2\u0001\u0004\t90\u0001\no_:,\u00050[:uK:$8i\u001c8gS\u001e\u001c\u0018\u0001F2iK\u000e\\W*Z:tC\u001e,7i\u001c8uC&t7\u000f\u0006\u0004\u0003\u000e\u000eM6Q\u0018\u0005\b\u0007k\u0013\u0004\u0019AB\\\u0003\u0005)\u0007\u0003BA^\u0007sKAaa/\u0002H\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\b\u0007\u007f\u0013\u0004\u0019AA\u0015\u0003\u0011!X\r\u001f;\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007\u000b\u0004BA!\u0005\u0004H&!1\u0011\u001aB\n\u0005\u0019y%M[3di\u0002")
public class HoodieSparkSqlTestBase
extends AnyFunSuite
implements BeforeAndAfterAll {
    private File sparkWareHouse;
    private SparkSession spark;
    private final Logger LOG;
    private AtomicInteger tableId;
    private Map<String, String> extraConf;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private volatile byte bitmap$0;

    public static void validateTableConfig(HoodieStorage hoodieStorage, String string, Map<String, String> map, Seq<String> seq) {
        HoodieSparkSqlTestBase$.MODULE$.validateTableConfig(hoodieStorage, string, map, seq);
    }

    public static HoodieCleanMetadata getLastCleanMetadata(SparkSession sparkSession, String string) {
        return HoodieSparkSqlTestBase$.MODULE$.getLastCleanMetadata(sparkSession, string);
    }

    public static HoodieCommitMetadata getLastCommitMetadata(SparkSession sparkSession, String string) {
        return HoodieSparkSqlTestBase$.MODULE$.getLastCommitMetadata(sparkSession, string);
    }

    public static Pattern NAME_FORMAT_0_X() {
        return HoodieSparkSqlTestBase$.MODULE$.NAME_FORMAT_0_X();
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    private Logger LOG() {
        return this.LOG;
    }

    /*
     * WARNING - void declaration
     */
    private File sparkWareHouse$lzycompute() {
        HoodieSparkSqlTestBase hoodieSparkSqlTestBase = this;
        synchronized (hoodieSparkSqlTestBase) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                File dir = Utils$.MODULE$.createTempDir();
                Utils$.MODULE$.deleteRecursively(dir);
                this.sparkWareHouse = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sparkWareHouse;
    }

    private File sparkWareHouse() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.sparkWareHouse$lzycompute();
        }
        return this.sparkWareHouse;
    }

    private SparkSession spark$lzycompute() {
        HoodieSparkSqlTestBase hoodieSparkSqlTestBase = this;
        synchronized (hoodieSparkSqlTestBase) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.spark = SparkSession$.MODULE$.builder().config("spark.sql.warehouse.dir", this.sparkWareHouse().getCanonicalPath()).config("spark.sql.session.timeZone", "UTC").config("hoodie.insert.shuffle.parallelism", "4").config("hoodie.upsert.shuffle.parallelism", "4").config("hoodie.delete.shuffle.parallelism", "4").config(this.sparkConf()).getOrCreate();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.spark;
    }

    public SparkSession spark() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.spark$lzycompute();
        }
        return this.spark;
    }

    private AtomicInteger tableId() {
        return this.tableId;
    }

    private void tableId_$eq(AtomicInteger x$1) {
        this.tableId = x$1;
    }

    private Map<String, String> extraConf() {
        return this.extraConf;
    }

    private void extraConf_$eq(Map<String, String> x$1) {
        this.extraConf = x$1;
    }

    public SparkConf sparkConf() {
        SparkConf conf = HoodieClientTestUtils.getSparkConfForTest((String)"Hoodie SQL Test");
        conf.setAll(this.extraConf());
        return conf;
    }

    public void initQueryIndexConf() {
        this.extraConf_$eq((Map<String, String>)this.extraConf().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieFileIndex.DataSkippingFailureMode$.MODULE$.configName()), (Object)HoodieFileIndex.DataSkippingFailureMode$.MODULE$.Strict().value())}))));
    }

    public void withTempDir(Function1<File, BoxedUnit> f) {
        File tempDir = Utils$.MODULE$.createTempDir();
        try {
            f.apply((Object)tempDir);
        }
        finally {
            Utils$.MODULE$.deleteRecursively(tempDir);
        }
    }

    public String getTableStoragePath(String tableName) {
        return new File(this.sparkWareHouse(), tableName).getCanonicalPath();
    }

    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, testTags, (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            try {
                object = testFun.apply();
            }
            finally {
                SessionCatalog catalog = this.spark().sessionState().catalog();
                catalog.listDatabases().foreach((Function1 & Serializable & scala.Serializable)db -> {
                    HoodieSparkSqlTestBase.$anonfun$test$2(catalog, db);
                    return BoxedUnit.UNIT;
                });
            }
            return object;
        }, (Position)pos);
    }

    public String generateTableName() {
        return new StringBuilder(1).append("h").append(this.tableId().incrementAndGet()).toString();
    }

    public void afterAll() {
        Utils$.MODULE$.deleteRecursively(this.sparkWareHouse());
        this.spark().stop();
    }

    public void checkAnswer(String sql, Seq<Seq<Object>> expects) {
        this.assertResult(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)expects.map((Function1 & Serializable & scala.Serializable)row -> Row$.MODULE$.apply(row), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Row.class)))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), (Ordering)Ordering.String$.MODULE$), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().sql(sql).collect())).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), (Ordering)Ordering.String$.MODULE$), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
    }

    public void checkAnswer(Row[] array, Seq<Seq<Object>> expects) {
        this.assertResult(((TraversableOnce)expects.map((Function1 & Serializable & scala.Serializable)row -> Row$.MODULE$.apply(row), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Row.class)), array, Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
    }

    public void checkNestedExceptionContains(String sql, String errorMsg) {
        Dataset dataset;
        boolean hasException = false;
        try {
            dataset = this.spark().sql(sql);
        }
        catch (Throwable e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                if (!t.getMessage().trim().contains(errorMsg.trim())) continue;
                hasException = true;
            }
            if (!hasException) {
                e.printStackTrace(System.err);
            }
            dataset = BoxedUnit.UNIT;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
    }

    public void checkExceptions(String sql, Seq<String> errorMsgs) {
        Dataset dataset;
        boolean hasException = false;
        try {
            dataset = this.spark().sql(sql);
        }
        catch (Throwable e) {
            this.assertResult(BoxesRunTime.boxToBoolean((boolean)errorMsgs.contains((Object)e.getMessage().split("\n")[0])), BoxesRunTime.boxToBoolean((boolean)true), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            hasException = true;
            dataset = BoxedUnit.UNIT;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
    }

    public void checkException(String sql, String errorMsg) {
        Dataset dataset;
        boolean hasException = false;
        try {
            dataset = this.spark().sql(sql);
        }
        catch (Throwable e) {
            this.assertResult(errorMsg.trim(), e.getMessage().trim(), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            hasException = true;
            dataset = BoxedUnit.UNIT;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
    }

    public void checkException(Runnable runnable, String errorMsg) {
        boolean hasException = false;
        try {
            runnable.run();
        }
        catch (Throwable e) {
            this.assertResult(errorMsg.trim(), e.getMessage().trim(), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            hasException = true;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
    }

    public void checkNestedException(String sql, String errorMsg) {
        Dataset dataset;
        boolean hasException = false;
        try {
            dataset = this.spark().sql(sql);
        }
        catch (Throwable e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                if (!errorMsg.trim().equals(t.getMessage().trim())) continue;
                hasException = true;
            }
            dataset = BoxedUnit.UNIT;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
    }

    public void checkExceptionContain(Runnable runnable, String errorMsg) {
        boolean hasException = false;
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && (HoodieSparkSqlTestBase$.MODULE$.org$apache$spark$sql$hudi$common$HoodieSparkSqlTestBase$$checkMessageContains(throwable2 = throwable3, errorMsg) || HoodieSparkSqlTestBase$.MODULE$.org$apache$spark$sql$hudi$common$HoodieSparkSqlTestBase$$checkMessageContains(ExceptionUtil.getRootCause((Throwable)throwable2), errorMsg))) {
                hasException = true;
            }
            if (throwable3 != null) {
                Throwable throwable4 = throwable3;
                throw this.fail(new StringBuilder(43).append("Exception should contain: ").append(errorMsg).append(", error message: ").append(throwable4.getMessage()).toString(), throwable4, new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            }
            throw throwable;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
    }

    public void checkExceptionContain(String sql, String errorMsg) {
        Dataset dataset;
        boolean hasException = false;
        try {
            dataset = this.spark().sql(sql);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && (HoodieSparkSqlTestBase$.MODULE$.org$apache$spark$sql$hudi$common$HoodieSparkSqlTestBase$$checkMessageContains(throwable2 = throwable3, errorMsg) || HoodieSparkSqlTestBase$.MODULE$.org$apache$spark$sql$hudi$common$HoodieSparkSqlTestBase$$checkMessageContains(ExceptionUtil.getRootCause((Throwable)throwable2), errorMsg))) {
                hasException = true;
                dataset = BoxedUnit.UNIT;
            }
            if (throwable3 != null) {
                Throwable throwable4 = throwable3;
                throw this.fail(new StringBuilder(43).append("Exception should contain: ").append(errorMsg).append(", error message: ").append(throwable4.getMessage()).toString(), throwable4, new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            }
            throw throwable;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
    }

    public void checkExceptionMatch(String sql, String errorMsgRegex) {
        Dataset dataset;
        boolean hasException = false;
        try {
            dataset = this.spark().sql(sql);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && ExceptionUtil.getRootCause((Throwable)(throwable2 = throwable3)).getMessage().matches(errorMsgRegex)) {
                hasException = true;
                dataset = BoxedUnit.UNIT;
            }
            if (throwable3 != null) {
                Throwable throwable4 = throwable3;
                throw this.fail(new StringBuilder(49).append("Exception should match pattern: ").append(errorMsgRegex).append(", error message: ").append(ExceptionUtil.getRootCause((Throwable)throwable4).getMessage()).toString(), throwable4, new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            }
            throw throwable;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
    }

    public String getExpectedUnresolvedColumnExceptionMessage(String columnName, String targetTableName) {
        Tuple3[] targetTableFields = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().sql(new StringBuilder(14).append("select * from ").append(targetTableName).toString()).schema().fields())).map((Function1 & Serializable & scala.Serializable)e -> new Tuple3((Object)e.name(), (Object)targetTableName, (Object)new StringBuilder(23).append("spark_catalog.default.").append(targetTableName).append(".").append(e.name()).toString()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        return this.getExpectedUnresolvedColumnExceptionMessage(columnName, (Seq<Tuple3<String, String, String>>)Predef$.MODULE$.wrapRefArray((Object[])targetTableFields));
    }

    public String getExpectedUnresolvedColumnExceptionMessage(String columnName, Seq<Tuple3<String, String, String>> fieldNameTuples) {
        String fieldNames = ((TraversableOnce)((TraversableLike)fieldNameTuples.sortBy((Function1 & Serializable & scala.Serializable)e -> new Tuple2(e._1(), e._2()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$))).map((Function1 & Serializable & scala.Serializable)e -> (String)e._3(), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
        if (HoodieSparkUtils$.MODULE$.gteqSpark3_5()) {
            return new StringBuilder(134).append("[UNRESOLVED_COLUMN.WITH_SUGGESTION] A column or function parameter with name ").append(columnName).append(" cannot be resolved. Did you mean one of the following? ").append(fieldNames).append(".").toString();
        }
        return new StringBuilder(47).append("cannot resolve ").append(columnName).append(" in MERGE command given columns ").append(fieldNames).append((Object)(HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? "." : "")).toString();
    }

    public void validateTableSchema(String tableName, List<StructField> expectedStructFields) {
        this.assertResult(expectedStructFields, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString()).schema().fields())).filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlTestBase.$anonfun$validateTableSchema$1(e))), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
    }

    public Object dropTypeLiteralPrefix(Object value) {
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(string)).stripPrefix("DATE"))).stripPrefix("TIMESTAMP"))).stripPrefix("X");
        }
        return value;
    }

    public Object extractRawValue(Object value) {
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString((String)this.dropTypeLiteralPrefix(string))).stripPrefix("'"))).stripSuffix("'");
        }
        return value;
    }

    public boolean existsPath(String filePath) {
        Path path = new Path(filePath);
        FileSystem fs = HadoopFSUtils.getFs((String)filePath, (Configuration)this.spark().sparkContext().hadoopConfiguration());
        return fs.exists(path);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        Object object;
        SQLConf conf = this.spark().sessionState().conf();
        Seq currentValues = (Seq)((TraversableLike)pairs.unzip((Function1)Predef$.MODULE$.$conforms())._1()).map((Function1 & Serializable & scala.Serializable)k -> {
            if (conf.contains(k)) {
                return new Some((Object)conf.getConfString(k));
            }
            return None$.MODULE$;
        }, Seq$.MODULE$.canBuildFrom());
        pairs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HoodieSparkSqlTestBase.$anonfun$withSQLConf$2(conf, x0$1);
            return BoxedUnit.UNIT;
        });
        try {
            object = f.apply();
        }
        finally {
            ((IterableLike)((IterableLike)pairs.unzip((Function1)Predef$.MODULE$.$conforms())._1()).zip((GenIterable)currentValues, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                HoodieSparkSqlTestBase.$anonfun$withSQLConf$3(conf, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        return (T)object;
    }

    public void withTable(String tableName, Function1<String, BoxedUnit> f) {
        try {
            f.apply((Object)tableName);
        }
        finally {
            this.spark().sql(new StringBuilder(27).append("drop table if exists ").append(tableName).append(" purge").toString());
        }
    }

    public void withSparkSqlSessionConfig(Seq<Tuple2<String, String>> configNameValues, Function0<BoxedUnit> f) {
        this.withSparkSqlSessionConfigWithCondition((Seq<Tuple2<Tuple2<String, String>, Object>>)((Seq)configNameValues.map((Function1 & Serializable & scala.Serializable)e -> new Tuple2(e, (Object)BoxesRunTime.boxToBoolean((boolean)true)), Seq$.MODULE$.canBuildFrom())), f);
    }

    public void withSparkSqlSessionConfigWithCondition(Seq<Tuple2<Tuple2<String, String>, Object>> configNameValues, Function0<BoxedUnit> f) {
        try {
            configNameValues.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    boolean condition = tuple2._2$mcZ$sp();
                    if (tuple22 != null) {
                        String configName = (String)tuple22._1();
                        String configValue = (String)tuple22._2();
                        if (condition) {
                            return this.spark().sql(new StringBuilder(5).append("set ").append(configName).append("=").append(configValue).toString());
                        }
                        return BoxedUnit.UNIT;
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            f.apply$mcV$sp();
        }
        finally {
            configNameValues.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x0$2;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    String configName = (String)tuple2._1();
                    return this.spark().sql(new StringBuilder(6).append("reset ").append(configName).toString());
                }
                throw new MatchError((Object)tuple22);
            });
        }
    }

    public void withRecordType(Seq<HoodieRecord.HoodieRecordType> recordTypes, Map<HoodieRecord.HoodieRecordType, Map<String, String>> recordConfig, Function0<BoxedUnit> f) {
        recordTypes.foreach((Function1 & Serializable & scala.Serializable)recordType -> {
            HoodieSparkSqlTestBase.$anonfun$withRecordType$1(this, recordConfig, f, recordType);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<HoodieRecord.HoodieRecordType> withRecordType$default$1() {
        return (Seq)new .colon.colon((Object)HoodieRecord.HoodieRecordType.AVRO, (List)new .colon.colon((Object)HoodieRecord.HoodieRecordType.SPARK, (List)Nil$.MODULE$));
    }

    public Map<HoodieRecord.HoodieRecordType, Map<String, String>> withRecordType$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ void $anonfun$test$2(SessionCatalog catalog$1, String db) {
        catalog$1.listTables(db).foreach((Function1 & Serializable & scala.Serializable)table -> {
            catalog$1.dropTable(table, true, true);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$validateTableSchema$1(StructField e) {
        return !HoodieRecord.HOODIE_META_COLUMNS_WITH_OPERATION.contains(e.name());
    }

    public static final /* synthetic */ void $anonfun$withSQLConf$2(SQLConf conf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            conf$1.setConfString(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$withSQLConf$3(SQLConf conf$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                conf$1.setConfString(key, value);
                return;
            }
        }
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (None$.MODULE$.equals(option)) {
                conf$1.unsetConf(key);
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$withRecordType$1(HoodieSparkSqlTestBase $this, Map recordConfig$1, Function0 f$1, HoodieRecord.HoodieRecordType recordType) {
        Tuple2 tuple2;
        HoodieRecord.HoodieRecordType hoodieRecordType = recordType;
        Tuple2 tuple22 = tuple2 = HoodieRecord.HoodieRecordType.SPARK.equals(hoodieRecordType) ? new Tuple2((Object)DefaultSparkRecordMerger.class.getName(), (Object)"parquet") : new Tuple2((Object)HoodieAvroRecordMerger.class.getName(), (Object)"avro");
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String merger = (String)tuple2._1();
        String format = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)merger, (Object)format);
        String merger2 = (String)tuple23._1();
        String format2 = (String)tuple23._2();
        Map config = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.RECORD_MERGE_IMPL_CLASSES.key()), (Object)merger2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT.key()), (Object)format2)}))).$plus$plus((GenTraversableOnce)recordConfig$1.getOrElse((Object)recordType, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()));
        $this.withSQLConf((Seq<Tuple2<String, String>>)config.toList(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            f$1.apply$mcV$sp();
            HoodieInMemoryHashIndex.clear();
        });
    }

    public HoodieSparkSqlTestBase() {
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        org.apache.log4j.Logger.getRootLogger().setLevel(Level.WARN);
        this.LOG = LoggerFactory.getLogger((Class)this.getClass());
        System.setProperty("spark.testing", "true");
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.UTC);
        TimeZone.setDefault(DateTimeUtils$.MODULE$.getTimeZone("UTC"));
        this.tableId = new AtomicInteger(0);
        this.extraConf = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }
}

