/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.common;

import java.io.File;
import java.io.Serializable;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.RowDataSourceScanExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t4AAB\u0004\u0001)!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C\u0005E!)A\b\u0001C\u0005{!)Q\t\u0001C\u0005\r\"9a\u000bAI\u0001\n\u00139&a\t+fgRtUm\u001d;fIN\u001b\u0007.Z7b!J,h.\u001b8h\u001fB$\u0018.\\5{CRLwN\u001c\u0006\u0003\u0011%\taaY8n[>t'B\u0001\u0006\f\u0003\u0011AW\u000fZ5\u000b\u00051i\u0011aA:rY*\u0011abD\u0001\u0006gB\f'o\u001b\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001)\u0012\u0004\u0005\u0002\u0017/5\tq!\u0003\u0002\u0019\u000f\t1\u0002j\\8eS\u0016\u001c\u0006/\u0019:l'FdG+Z:u\u0005\u0006\u001cX\r\u0005\u0002\u001b95\t1D\u0003\u0002\u000b\u001f%\u0011Qd\u0007\u0002\u0014'B\f'o[!eCB$XM]*vaB|'\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"A\u0006\u0001\u0002\u000f\u0015D\b\u000f\\1j]R\u00111\u0005\r\t\u0003I5r!!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\u001a\u0012A\u0002\u001fs_>$hHC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013&\u0001\u0004Qe\u0016$WMZ\u0005\u0003]=\u0012aa\u0015;sS:<'B\u0001\u0017*\u0011\u0015\t$\u00011\u00013\u0003\u0011\u0001H.\u00198\u0011\u0005MRT\"\u0001\u001b\u000b\u0005U2\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003oa\nQ\u0001\u001d7b]NT!!O\u0006\u0002\u0011\r\fG/\u00197zgRL!a\u000f\u001b\u0003\u00171{w-[2bYBc\u0017M\\\u0001\fKb,7-\u001e;f!2\fg\u000e\u0006\u0002?\tB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011iC\u0001\nKb,7-\u001e;j_:L!a\u0011!\u0003\u0013M\u0003\u0018M]6QY\u0006t\u0007\"B\u0019\u0004\u0001\u0004\u0011\u0014!I2sK\u0006$X\rV1cY\u0016<\u0016\u000e\u001e5OKN$X\rZ*ueV\u001cGoU2iK6\fG#B$L\u001b>\u000b\u0006C\u0001%J\u001b\u0005I\u0013B\u0001&*\u0005\u0011)f.\u001b;\t\u000b1#\u0001\u0019A\u0012\u0002\u0013Q\f'\r\\3UsB,\u0007\"\u0002(\u0005\u0001\u0004\u0019\u0013!\u0003;bE2,g*Y7f\u0011\u0015\u0001F\u00011\u0001$\u0003%!\u0018M\u00197f!\u0006$\b\u000eC\u0004S\tA\u0005\t\u0019A*\u0002\t=\u0004Ho\u001d\t\u0005IQ\u001b3%\u0003\u0002V_\t\u0019Q*\u00199\u0002W\r\u0014X-\u0019;f)\u0006\u0014G.Z,ji\"tUm\u001d;fIN#(/^2u'\u000eDW-\\1%I\u00164\u0017-\u001e7uIQ*\u0012\u0001\u0017\u0016\u0003'f[\u0013A\u0017\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005}K\u0013AC1o]>$\u0018\r^5p]&\u0011\u0011\r\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class TestNestedSchemaPruningOptimization
extends HoodieSparkSqlTestBase
implements SparkAdapterSupport {
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    private SparkAdapter sparkAdapter$lzycompute() {
        TestNestedSchemaPruningOptimization testNestedSchemaPruningOptimization = this;
        synchronized (testNestedSchemaPruningOptimization) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    private String explain(LogicalPlan plan) {
        LogicalPlan explainCommand = this.sparkAdapter().getCatalystPlanUtils().createExplainCommand(plan, true);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.executePlan(explainCommand).executeCollect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
    }

    private SparkPlan executePlan(LogicalPlan plan) {
        return this.spark().sessionState().executePlan(plan, this.spark().sessionState().executePlan$default$2()).executedPlan();
    }

    private void createTableWithNestedStructSchema(String tableType, String tableName, String tablePath, Map<String, String> opts) {
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(343).append("\n         |CREATE TABLE ").append(tableName).append(" USING HUDI TBLPROPERTIES (\n         |  type = '").append(tableType).append("',\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts',\n         |  hoodie.populate.meta.fields = 'false'\n         |  ").append((Object)(opts.nonEmpty() ? new StringBuilder(1).append(",").append(((TraversableOnce)opts.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(7).append("'").append(k).append("' = '").append(v).append("'").toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",")).toString() : "")).append("\n         |)\n         |LOCATION '").append(tablePath).append("'\n         |AS SELECT 1 AS id, named_struct('name', 'a1', 'price', 10) AS item, 123456 AS ts\n             ").toString())).stripMargin());
    }

    private Map<String, String> createTableWithNestedStructSchema$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ long $anonfun$new$3(TestNestedSchemaPruningOptimization $this, File tmp$1, String tableType) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$1.getCanonicalPath()).append("/").append(tableName).toString();
        $this.createTableWithNestedStructSchema(tableType, tableName, tablePath, $this.createTableWithNestedStructSchema$default$4());
        Dataset selectDF = $this.spark().sql(new StringBuilder(26).append("SELECT id, item.name FROM ").append(tableName).toString());
        StructType expectedSchema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("item", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
        String expectedReadSchemaClause = "ReadSchema: struct<id:int,item:struct<name:string>>";
        String hint = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(599).append("\n             |Following is expected to be present in the plan (where ReadSchema has properly pruned nested structs, which\n             |is an optimization performed by NestedSchemaPruning rule):\n             |\n             |== Physical Plan ==\n             |*(1) Project [id#45, item#46.name AS name#55]\n             |+- FileScan parquet default.h0[id#45,item#46] Batched: false, DataFilters: [], Format: Parquet, Location: HoodieFileIndex(1 paths)[file:/private/var/folders/kb/cnff55vj041g2nnlzs5ylqk00000gn/T/spark-7137..., PartitionFilters: [], PushedFilters: [], ").append(expectedReadSchemaClause).append("\n             |]\n             |").toString())).stripMargin();
        $this.spark().sessionState().conf().setConf(SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        boolean bl = false;
        ProjectExec projectExec = null;
        SparkPlan sparkPlan = selectDF.queryExecution().executedPlan();
        if (sparkPlan instanceof ProjectExec) {
            bl = true;
            projectExec = (ProjectExec)sparkPlan;
            SparkPlan fileScan = projectExec.child();
            if (fileScan instanceof FileSourceScanExec) {
                FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)fileScan;
                Option tableIdentifier = fileSourceScanExec.tableIdentifier();
                StructType requiredSchema = fileSourceScanExec.requiredSchema();
                Assertions.assertEquals((Object)tableName, (Object)((TableIdentifier)tableIdentifier.get()).table());
                Assertions.assertEquals((Object)expectedSchema, (Object)requiredSchema, (String)hint);
                return selectDF.count();
            }
        }
        if (!bl) throw new MatchError((Object)sparkPlan);
        SparkPlan dataScan = projectExec.child();
        if (!(dataScan instanceof RowDataSourceScanExec)) throw new MatchError((Object)sparkPlan);
        RowDataSourceScanExec rowDataSourceScanExec = (RowDataSourceScanExec)dataScan;
        String explainedPlan = $this.explain(selectDF.queryExecution().logical());
        Assertions.assertTrue((boolean)explainedPlan.contains(expectedReadSchemaClause));
        Option tableIdentifier = rowDataSourceScanExec.tableIdentifier();
        StructType requiredSchema = rowDataSourceScanExec.requiredSchema();
        Assertions.assertEquals((Object)tableName, (Object)((TableIdentifier)tableIdentifier.get()).table());
        Assertions.assertEquals((Object)expectedSchema, (Object)requiredSchema, (String)hint);
        return selectDF.count();
    }

    public static final /* synthetic */ void $anonfun$new$2(TestNestedSchemaPruningOptimization $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> BoxesRunTime.boxToLong((long)TestNestedSchemaPruningOptimization.$anonfun$new$3($this, tmp, tableType)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ long $anonfun$new$6(TestNestedSchemaPruningOptimization $this, File tmp$2, String tableType) {
        Tuple2 tuple2;
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName).toString();
        String string = tableType;
        if ("cow".equals(string)) {
            tuple2 = new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.key()), (Object)"true")})), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.key()), (Object)"true")})));
        } else {
            if (!"mor".equals(string)) throw new MatchError((Object)string);
            tuple2 = new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_PAYLOAD_CLASS_NAME.key()), (Object)"org.apache.hudi.common.model.DefaultHoodieRecordPayload")})), (Object)Predef$.MODULE$.Map().empty());
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        Map writeOpts = (Map)tuple22._1();
        Map readOpts = (Map)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)writeOpts, (Object)readOpts);
        Map writeOpts2 = (Map)tuple23._1();
        Map readOpts2 = (Map)tuple23._2();
        $this.createTableWithNestedStructSchema(tableType, tableName, tablePath, (Map<String, String>)writeOpts2);
        Dataset selectDF = (Dataset)$this.withSQLConf((Seq<Tuple2<String, String>>)readOpts2.toSeq(), (Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(26).append("SELECT id, item.name FROM ").append(tableName).toString()));
        StructType expectedSchema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("item", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
        String expectedReadSchemaClause = "ReadSchema: struct<id:int,item:struct<name:string,price:int>>";
        $this.spark().sessionState().conf().setConf(SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        boolean bl = false;
        ProjectExec projectExec = null;
        SparkPlan sparkPlan = selectDF.queryExecution().executedPlan();
        if (sparkPlan instanceof ProjectExec) {
            bl = true;
            projectExec = (ProjectExec)sparkPlan;
            SparkPlan fileScan = projectExec.child();
            if (fileScan instanceof FileSourceScanExec) {
                FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)fileScan;
                Option tableIdentifier = fileSourceScanExec.tableIdentifier();
                StructType requiredSchema = fileSourceScanExec.requiredSchema();
                Assertions.assertEquals((Object)tableName, (Object)((TableIdentifier)tableIdentifier.get()).table());
                Assertions.assertEquals((Object)expectedSchema, (Object)requiredSchema);
                return selectDF.count();
            }
        }
        if (!bl) throw new MatchError((Object)sparkPlan);
        SparkPlan dataScan = projectExec.child();
        if (!(dataScan instanceof RowDataSourceScanExec)) throw new MatchError((Object)sparkPlan);
        RowDataSourceScanExec rowDataSourceScanExec = (RowDataSourceScanExec)dataScan;
        String explainedPlan = $this.explain(selectDF.queryExecution().logical());
        Assertions.assertTrue((boolean)explainedPlan.contains(expectedReadSchemaClause));
        Option tableIdentifier = rowDataSourceScanExec.tableIdentifier();
        Assertions.assertEquals((Object)tableName, (Object)((TableIdentifier)tableIdentifier.get()).table());
        return selectDF.count();
    }

    public static final /* synthetic */ void $anonfun$new$5(TestNestedSchemaPruningOptimization $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"mor", (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)tableType -> BoxesRunTime.boxToLong((long)TestNestedSchemaPruningOptimization.$anonfun$new$6($this, tmp, tableType)));
    }

    public TestNestedSchemaPruningOptimization() {
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
        this.test("Test NestedSchemaPruning optimization successful", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestNestedSchemaPruningOptimization.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestNestedSchemaPruningOptimization.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("Test NestedSchemaPruning optimization unsuccessful", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestNestedSchemaPruningOptimization.$anonfun$new$5(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestNestedSchemaPruningOptimization.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
    }
}

