/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.common;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001I2Aa\u0001\u0003\u0001#!)A\u0004\u0001C\u0001;!)q\u0004\u0001C\u0001A\tYA+Z:u'Fd7i\u001c8g\u0015\t)a!\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f!\tA\u0001[;eS*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0005\f\u0011\u0005M!R\"\u0001\u0003\n\u0005U!!A\u0006%p_\u0012LWm\u00159be.\u001c\u0016\u000f\u001c+fgR\u0014\u0015m]3\u0011\u0005]QR\"\u0001\r\u000b\u0005eq\u0011!C:dC2\fG/Z:u\u0013\tY\u0002D\u0001\bCK\u001a|'/Z!oI\u00063G/\u001a:\u0002\rqJg.\u001b;?)\u0005q\u0002CA\n\u0001\u0003\u0019\u0019X\r^#omR\u0019\u0011E\f\u0019\u0011\u0005\tZcBA\u0012*!\t!s%D\u0001&\u0015\t1\u0003#\u0001\u0004=e>|GO\u0010\u0006\u0002Q\u0005)1oY1mC&\u0011!fJ\u0001\u0007!J,G-\u001a4\n\u00051j#AB*ue&twM\u0003\u0002+O!)qF\u0001a\u0001C\u0005\u00191.Z=\t\u000bE\u0012\u0001\u0019A\u0011\u0002\u000bY\fG.^3")
public class TestSqlConf
extends HoodieSparkSqlTestBase
implements BeforeAndAfter {
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    @Override
    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public String setEnv(String key, String value) {
        Field field = System.getenv().getClass().getDeclaredField("m");
        field.setAccessible(true);
        Map map = (Map)field.get(System.getenv());
        return map.put(key, value);
    }

    public static final /* synthetic */ void $anonfun$new$2(TestSqlConf $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = tmp.getCanonicalPath();
        String partitionVal = "2021";
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(354).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  year string\n           |) using hudi\n           | partitioned by (year)\n           | location '").append(tablePath).append("'\n           | options (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(40).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000, ").append(partitionVal).append(")").toString());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
        $this.spark().sql(new StringBuilder(40).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000, ").append(partitionVal).append(")").toString());
        String commitCompletionTime2 = ((HoodieInstant)metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().get()).getCompletionTime();
        $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, year from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), partitionVal})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), partitionVal}))}));
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)Files.exists(Paths.get(new StringBuilder(1).append(tablePath).append("/").append(partitionVal).toString(), new String[0]), new LinkOption[0])), Prettifier$.MODULE$.default(), new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        $this.assertResult(HoodieTableType.MERGE_ON_READ, new HoodieTableConfig(HoodieStorageUtils.getStorage((String)tablePath, (StorageConfiguration)HoodieTestUtils.getDefaultStorageConf()), new StoragePath(tablePath, ".hoodie"), RecordMergeMode.COMMIT_TIME_ORDERING, null, null).getTableType(), Prettifier$.MODULE$.default(), new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        DFSPropertiesConfiguration.addToGlobalProps((String)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), (String)DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL());
        DFSPropertiesConfiguration.addToGlobalProps((String)DataSourceReadOptions$.MODULE$.START_COMMIT().key(), (String)commitCompletionTime2);
        $this.spark().catalog().refreshTable(tableName);
        $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, year from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), partitionVal}))}));
        $this.spark().sql(new StringBuilder(26).append("delete from ").append(tableName).append(" where year = ").append(partitionVal).toString());
        long cnt = $this.spark().sql(new StringBuilder(28).append("select * from ").append(tableName).append(" where year = ").append(partitionVal).toString()).count();
        $this.assertResult(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToLong((long)cnt), Prettifier$.MODULE$.default(), new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        $this.spark().sql(new StringBuilder(45).append("alter table ").append(tableName).append(" change column price price string").toString());
    }

    public TestSqlConf() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.test("Test Hudi Conf", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSqlConf.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String testPropsFilePath = new File("src/test/resources/external-config").getAbsolutePath();
            this.setEnv("HUDI_CONF_DIR", testPropsFilePath);
            DFSPropertiesConfiguration.refreshGlobalProps();
        }, new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DFSPropertiesConfiguration.clearGlobalProps(), new Position("TestSqlConf.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
    }
}

