/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.ddl;

import java.io.File;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001E2Aa\u0001\u0003\u0001#!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;\tqA+Z:u\u00032$XM\u001d+bE2,'BA\u0003\u0007\u0003\r!G\r\u001c\u0006\u0003\u000f!\tA\u0001[;eS*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0019\taaY8n[>t\u0017BA\f\u0015\u0005YAun\u001c3jKN\u0003\u0018M]6Tc2$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u001b!\tY\u0002!D\u0001\u0005\u0003M1\u0018\r\\5eCR,G+\u00192mKN\u001b\u0007.Z7b)\tqB\u0005\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0003V]&$\b\"B\u0013\u0003\u0001\u00041\u0013!\u0003;bE2,\u0007+\u0019;i!\t9cF\u0004\u0002)YA\u0011\u0011\u0006I\u0007\u0002U)\u00111\u0006E\u0001\u0007yI|w\u000e\u001e \n\u00055\u0002\u0013A\u0002)sK\u0012,g-\u0003\u00020a\t11\u000b\u001e:j]\u001eT!!\f\u0011")
public class TestAlterTable
extends HoodieSparkSqlTestBase {
    public void validateTableSchema(String tablePath) {
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)tablePath);
        Schema schema = new TableSchemaResolver(metaClient).getTableAvroSchema(false);
        Assertions.assertFalse((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieRecord.HOODIE_META_COLUMNS.contains(f.name()))), (String)"Metadata fields should be excluded from the table schema");
    }

    public static final /* synthetic */ void $anonfun$new$2(TestAlterTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = $this.generateTableName();
            String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(348).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | tblproperties (\n             |  type = '").append((String)tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(57).append("alter table ").append(tableName).append(" change column id id int comment 'primary id'").toString());
            CatalogTable catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(tableName));
            $this.assertResult("primary id", catalogTable.schema().apply(catalogTable.schema().fieldIndex("id")).getComment().get(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            $this.validateTableSchema(tablePath);
            $this.spark().sql(new StringBuilder(65).append("alter table ").append(tableName).append(" change column name name string comment 'name column'").toString());
            $this.spark().sessionState().catalog().refreshTable(new TableIdentifier(tableName));
            catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(tableName));
            $this.assertResult("primary id", catalogTable.schema().apply(catalogTable.schema().fieldIndex("id")).getComment().get(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            $this.assertResult("name column", catalogTable.schema().apply(catalogTable.schema().fieldIndex("name")).getComment().get(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            $this.validateTableSchema(tablePath);
            String newTableName = new StringBuilder(2).append(tableName).append("_1").toString();
            $this.spark().sql(new StringBuilder(23).append("alter table ").append(tableName).append(" rename to ").append(newTableName).toString());
            $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)$this.spark().sessionState().catalog().tableExists(new TableIdentifier(tableName))), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)$this.spark().sessionState().catalog().tableExists(new TableIdentifier(newTableName))), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
            $this.assertResult(newTableName, metaClient.getTableConfig().getTableName(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            $this.validateTableSchema(tablePath);
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(newTableName).append(" values(1, 'a1', 10, 1000)").toString());
            $this.spark().sql(new StringBuilder(37).append("alter table ").append(newTableName).append(" add columns(ext0 string)").toString());
            catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(newTableName));
            $this.assertResult(new .colon.colon((Object)"id", (List)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"price", (List)new .colon.colon((Object)"ts", (List)new .colon.colon((Object)"ext0", (List)Nil$.MODULE$))))), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])HoodieSqlCommonUtils$.MODULE$.removeMetaFields(catalogTable.schema()).fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null}))}));
            $this.validateTableSchema(tablePath);
            $this.checkExceptionContain(new StringBuilder(39).append("alter table ").append(newTableName).append(" change column id id bigint").toString(), "ALTER TABLE CHANGE COLUMN is not supported for changing column 'id' with type 'IntegerType' to 'id' with type 'LongType'");
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(newTableName).append(" values(2, 'a2', 12, 1000, 'e0')").toString());
            $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000), "e0"}))}));
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(287).append("\n             |merge into ").append(newTableName).append(" t0\n             |using (\n             |  select 1 as id, 'a1' as name, 12 as price, 1001 as ts, 'e0' as ext0\n             |) s0\n             |on t0.id = s0.id\n             |when matched then update set *\n             |when not matched then insert *\n           ").toString())).stripMargin());
            $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1001), "e0"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000), "e0"}))}));
            $this.spark().sql(new StringBuilder(48).append("update ").append(newTableName).append(" set price = 10, ext0 = null where id = 1").toString());
            $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000), "e0"}))}));
            $this.spark().sql(new StringBuilder(48).append("update ").append(newTableName).append(" set price = 10, ext0 = null where id = 2").toString());
            $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null}))}));
            $this.spark().sql(new StringBuilder(25).append("delete from ").append(newTableName).append(" where id = 1").toString());
            $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null}))}));
            String partitionedTable = $this.generateTableName();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(411).append("\n             |create table ").append(partitionedTable).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  dt string\n             |) using hudi\n             | location '").append(tmp.getCanonicalPath()).append("/").append(partitionedTable).append("'\n             | tblproperties (\n             |  type = '").append((String)tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by (dt)\n       ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(52).append("insert into ").append(partitionedTable).append(" values(1, 'a1', 10, 1000, '2021-07-25')").toString());
            $this.spark().sql(new StringBuilder(37).append("alter table ").append(partitionedTable).append(" add columns(ext0 double)").toString());
            $this.checkAnswer(new StringBuilder(42).append("select id, name, price, ts, dt, ext0 from ").append(partitionedTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-07-25", null}))}));
            $this.spark().sql(new StringBuilder(55).append("insert into ").append(partitionedTable).append(" values(2, 'a2', 10, 1000, 1, '2021-07-25')").toString());
            $this.checkAnswer(new StringBuilder(54).append("select id, name, price, ts, dt, ext0 from ").append(partitionedTable).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-07-25", null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-07-25", BoxesRunTime.boxToDouble((double)1.0)}))}));
            String tableName2 = $this.generateTableName();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(740).append("\n             |create table ").append(tableName2).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName2).append("'\n             | tblproperties (\n             |  type = '").append((String)tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  `hoodie.index.type`='BUCKET',\n             |  `hoodie.index.bucket.engine`='SIMPLE',\n             |  `hoodie.bucket.index.num.buckets`='2',\n             |  `hoodie.bucket.index.hash.field`='id',\n             |  `hoodie.storage.layout.type`='BUCKET',\n             |  `hoodie.storage.layout.partitioner.class`='org.apache.hudi.table.action.commit.SparkBucketIndexPartitioner'\n             | )\n       ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName2).append(" values(1, 'a1', 10, 1000)").toString());
            $this.spark().sql(new StringBuilder(55).append("alter table ").append(tableName2).append(" add columns(dt string comment 'data time')").toString());
            $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName2).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null}))}));
            return (Seq)$this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.schema.on.read.enable"), (Object)"true")}), (Function0 & Serializable & scala.Serializable)() -> {
                $this.spark().sql(new StringBuilder(55).append("alter table ").append(tableName2).append(" add columns(hh string comment 'hour time')").toString());
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null, null}));
            });
        });
    }

    public static final /* synthetic */ void $anonfun$new$8(TestAlterTable $this, File tmp$2, String tableType) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(662).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  hoodie.metadata.enable = 'false',\n             |  hoodie.clean.commits.retained = '100',\n             |  hoodie.clustering.inline = 'true',\n             |  hoodie.clustering.inline.max.commits = '1',\n             |  hoodie.keep.max.commits = '300',\n             |  hoodie.keep.min.commits = '200'\n             | )\n       ").toString())).stripMargin());
        SparkRDDWriteClient client = HoodieCLIUtils$.MODULE$.createHoodieWriteClient($this.spark(), tablePath, Predef$.MODULE$.Map().empty(), Option$.MODULE$.apply((Object)tableName));
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
        String firstInstant = client.createNewInstantTime();
        client.startCommitWithTime(firstInstant, "commit");
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)client.getConfig(), (HoodieEngineContext)client.getEngineContext());
        HoodieActiveTimeline timeLine = hoodieTable.getActiveTimeline();
        HoodieInstant requested = hoodieTable.getInstantGenerator().createNewInstant(HoodieInstant.State.REQUESTED, "commit", firstInstant);
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        metadata.setOperationType(WriteOperationType.ALTER_SCHEMA);
        timeLine.transitionRequestedToInflight(requested, TimelineMetadataUtils.serializeCommitMetadata((CommitMetadataSerDe)hoodieTable.getMetaClient().getTimelineLayout().getCommitMetadataSerDe(), (HoodieCommitMetadata)metadata));
        $this.spark().sql(new StringBuilder(57).append("alter table ").append(tableName).append(" change column id id int comment 'primary id'").toString());
        CatalogTable catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(tableName));
        $this.assertResult("primary id", catalogTable.schema().apply(catalogTable.schema().fieldIndex("id")).getComment().get(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        $this.validateTableSchema(tablePath);
        metaClient.reloadActiveTimeline();
        int rollbackCount = metaClient.getActiveTimeline().getRollbackTimeline().countInstants();
        Assertions.assertTrue((rollbackCount == 0 ? 1 : 0) != 0, (String)"Executing ALTER TABLE commands won't trigger a rollback service.");
        JavaSparkContext jsc = new JavaSparkContext($this.spark().sparkContext());
        client.commit(firstInstant, (Object)jsc.emptyRDD());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 20, 2000)").toString());
        $this.spark().sql(new StringBuilder(68).append("alter table ").append(tableName).append(" set TBLPROPERTIES (hoodie.clean.commits.retained = '1')").toString());
        $this.spark().sql(new StringBuilder(49).append("alter table ").append(tableName).append(" change column id id int comment 'pk'").toString());
        catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(tableName));
        $this.assertResult("pk", catalogTable.schema().apply(catalogTable.schema().fieldIndex("id")).getComment().get(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        $this.validateTableSchema(tablePath);
        metaClient.reloadActiveTimeline();
        int cleanCount = metaClient.getActiveTimeline().getCleanerTimeline().countInstants();
        Assertions.assertTrue((cleanCount == 0 ? 1 : 0) != 0, (String)"Executing ALTER TABLE commands won't trigger a clean service.");
        $this.spark().sql(new StringBuilder(63).append("alter table ").append(tableName).append("  set TBLPROPERTIES (hoodie.keep.max.commits = '3')").toString());
        $this.spark().sql(new StringBuilder(63).append("alter table ").append(tableName).append("  set TBLPROPERTIES (hoodie.keep.min.commits = '2')").toString());
        $this.spark().sql(new StringBuilder(57).append("alter table ").append(tableName).append(" change column id id int comment 'primary id'").toString());
        catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(tableName));
        $this.assertResult("primary id", catalogTable.schema().apply(catalogTable.schema().fieldIndex("id")).getComment().get(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        metaClient.getArchivedTimeline().reload();
        int archiveCount = metaClient.getArchivedTimeline().countInstants();
        Assertions.assertTrue((archiveCount == 0 ? 1 : 0) != 0, (String)"Executing ALTER TABLE commands won't trigger an archive service.");
    }

    public static final /* synthetic */ void $anonfun$new$7(TestAlterTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestAlterTable.$anonfun$new$8($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$10(TestAlterTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = $this.generateTableName();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(321).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  type = '").append((String)tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
            String newTableName = new StringBuilder(2).append(tableName).append("_1").toString();
            Option oldLocation = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(tableName)).properties().get((Object)"path");
            $this.spark().sql(new StringBuilder(23).append("alter table ").append(tableName).append(" rename to ").append(newTableName).toString());
            Option newLocation = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(newTableName)).properties().get((Object)"path");
            Assertion assertion = oldLocation.nonEmpty() ? $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)newLocation.equals((Object)oldLocation)), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338)) : $this.assertResult(None$.MODULE$, newLocation, Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            String locTableName = new StringBuilder(4).append(tableName).append("_loc").toString();
            String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(locTableName).toString();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(348).append("\n             |create table ").append(locTableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | tblproperties (\n             |  type = '").append((String)tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
            String newLocTableName = new StringBuilder(2).append(locTableName).append("_1").toString();
            Option oldLocation2 = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(locTableName)).properties().get((Object)"path");
            $this.spark().sql(new StringBuilder(23).append("alter table ").append(locTableName).append(" rename to ").append(newLocTableName).toString());
            Option newLocation2 = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(newLocTableName)).properties().get((Object)"path");
            if (oldLocation2.nonEmpty()) {
                Path oldLocation2Path = new Path(new StringOps(Predef$.MODULE$.augmentString((String)oldLocation2.get())).stripPrefix("file:"));
                Path newLocation2Path = new Path(new StringOps(Predef$.MODULE$.augmentString((String)newLocation2.get())).stripPrefix("file:"));
                return $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)newLocation2Path.equals((Object)oldLocation2Path)), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
            }
            return $this.assertResult(None$.MODULE$, newLocation2, Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
        });
    }

    public static final /* synthetic */ void $anonfun$new$14(TestAlterTable $this, File tmp$4, String tableType) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$4.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(600).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  hoodie.write.concurrency.mode='optimistic_concurrency_control',\n             |  hoodie.clean.failed.writes.policy='LAZY',\n             |  hoodie.write.lock.provider='org.apache.hudi.client.transaction.lock.FileSystemBasedLockProvider'\n             | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(57).append("alter table ").append(tableName).append(" change column id id int comment 'primary id'").toString());
        CatalogTable catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(tableName));
        $this.assertResult("primary id", catalogTable.schema().apply(catalogTable.schema().fieldIndex("id")).getComment().get(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
        $this.spark().sql(new StringBuilder(65).append("alter table ").append(tableName).append(" change column name name string comment 'name column'").toString());
        $this.spark().sessionState().catalog().refreshTable(new TableIdentifier(tableName));
        catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(tableName));
        $this.assertResult("primary id", catalogTable.schema().apply(catalogTable.schema().fieldIndex("id")).getComment().get(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        $this.assertResult("name column", catalogTable.schema().apply(catalogTable.schema().fieldIndex("name")).getComment().get(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
        String newTableName = new StringBuilder(2).append(tableName).append("_1").toString();
        $this.spark().sql(new StringBuilder(23).append("alter table ").append(tableName).append(" rename to ").append(newTableName).toString());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)$this.spark().sessionState().catalog().tableExists(new TableIdentifier(tableName))), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)$this.spark().sessionState().catalog().tableExists(new TableIdentifier(newTableName))), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
        $this.assertResult(newTableName, metaClient.getTableConfig().getTableName(), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(newTableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(37).append("alter table ").append(newTableName).append(" add columns(ext0 string)").toString());
        catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(newTableName));
        $this.assertResult(new .colon.colon((Object)"id", (List)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"price", (List)new .colon.colon((Object)"ts", (List)new .colon.colon((Object)"ext0", (List)Nil$.MODULE$))))), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])HoodieSqlCommonUtils$.MODULE$.removeMetaFields(catalogTable.schema()).fields())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
        $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null}))}));
        $this.checkExceptionContain(new StringBuilder(39).append("alter table ").append(newTableName).append(" change column id id bigint").toString(), "ALTER TABLE CHANGE COLUMN is not supported for changing column 'id' with type 'IntegerType' to 'id' with type 'LongType'");
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(newTableName).append(" values(2, 'a2', 12, 1000, 'e0')").toString());
        $this.checkAnswer(new StringBuilder(38).append("select id, name, price, ts, ext0 from ").append(newTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000), "e0"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$13(TestAlterTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestAlterTable.$anonfun$new$14($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Assertion $anonfun$new$18(TestAlterTable $this, File tmp$5, boolean cleanEnable) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$5.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(467).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | tblproperties (\n             |  type = 'cow',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  hoodie.clean.trigger.strategy = 'NUM_COMMITS',\n             |  hoodie.clean.commits.retained = '3'\n             | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set name = 'a2' where id = 1").toString());
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set name = 'a3' where id = 1").toString());
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set name = 'a4' where id = 1").toString());
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.clean.automatic"), (Object)Boolean.toString(cleanEnable))}), (Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(37).append("alter table ").append(tableName).append(" add columns(ext0 string)").toString()));
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
        int cnt = metaClient.getActiveTimeline().countInstants();
        if (cleanEnable) {
            return $this.assertResult(BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)cnt), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
        }
        return $this.assertResult(BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)cnt), Prettifier$.MODULE$.default(), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
    }

    public static final /* synthetic */ void $anonfun$new$17(TestAlterTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)cleanEnable -> TestAlterTable.$anonfun$new$18($this, tmp, BoxesRunTime.unboxToBoolean((Object)cleanEnable)));
    }

    public TestAlterTable() {
        this.test("Test Alter Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestAlterTable.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("Test Alter table With Disable Clean Rollback And Archive", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestAlterTable.$anonfun$new$7(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("Test Alter Rename Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestAlterTable.$anonfun$new$10(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        this.test("Test Alter Table With OCC", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestAlterTable.$anonfun$new$13(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        this.test("Test Alter Table With Spark Sql Conf", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestAlterTable.$anonfun$new$17(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
    }
}

