/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.ddl;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase$;
import org.apache.spark.sql.hudi.ddl.TestCreateTable$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m1AAA\u0002\u0001!!)q\u0003\u0001C\u00011\tyA+Z:u\u0007J,\u0017\r^3UC\ndWM\u0003\u0002\u0005\u000b\u0005\u0019A\r\u001a7\u000b\u0005\u00199\u0011\u0001\u00025vI&T!\u0001C\u0005\u0002\u0007M\fHN\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I)R\"A\n\u000b\u0005Q)\u0011AB2p[6|g.\u0003\u0002\u0017'\t1\u0002j\\8eS\u0016\u001c\u0006/\u0019:l'FdG+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0007\u0001")
public class TestCreateTable
extends HoodieSparkSqlTestBase {
    public static final /* synthetic */ void $anonfun$new$7(TestCreateTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(294).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | tblproperties (\n           |  primaryKey = 'id,name',\n           |  type = 'cow'\n           | )\n           | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin());
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
        $this.assertResult(tableName, table.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        $this.assertResult("hudi", table.provider().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        $this.assertResult(CatalogTableType$.MODULE$.EXTERNAL(), table.tableType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        $this.assertResult(((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> new StructField(x$3, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))), table.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        $this.assertResult(table.properties().apply((Object)"type"), "cow", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        $this.assertResult(table.properties().apply((Object)"primaryKey"), "id,name", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        $this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(350).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           |) using hudi\n           | partitioned by (dt)\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  type = 'mor'\n           | )\n           | location '").append(tmp.getCanonicalPath()).append("/h0'\n       ").toString())).stripMargin());
        CatalogTable table2 = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
        $this.assertResult(table2.properties().apply((Object)"type"), "mor", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        $this.assertResult(table2.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        $this.assertResult(new .colon.colon((Object)"dt", (List)Nil$.MODULE$), table2.partitionColumnNames(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        $this.assertResult(HoodieParquetRealtimeInputFormat.class.getCanonicalName(), table2.storage().inputFormat().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        String tableName3 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(86).append("\n           |create table ").append(tableName3).append("\n           |using hudi\n           |location '").append(tmp.getCanonicalPath()).append("/h0'\n         ").toString())).stripMargin());
        CatalogTable table3 = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName3));
        $this.assertResult(table3.properties().apply((Object)"type"), "mor", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        $this.assertResult(table3.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        $this.assertResult(((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> new StructField(x$4, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("dt", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))))), table3.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
    }

    public static final /* synthetic */ void $anonfun$new$11(TestCreateTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.assertThrows((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(312).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  primaryKey = 'id1',\n             |  type = 'cow'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        $this.assertThrows((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(352).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts1',\n             |  type = 'cow'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        $this.assertThrows((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(352).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  type = 'cow1'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
    }

    public static final /* synthetic */ void $anonfun$new$17(TestCreateTable $this, File tmp$2, String tableType) {
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(275).append("\n             | create table ").append(tableName1).append(" using hudi\n             | tblproperties(\n             |    primaryKey = 'id',\n             |    type = '").append(tableType).append("'\n             | )\n             | location '").append(tmp$2.getCanonicalPath()).append("/").append(tableName1).append("'\n             | AS\n             | select 1 as id, 'a1' as name, 10 as price, 1000 as ts\n       ").toString())).stripMargin());
        $this.assertResult(WriteOperationType.BULK_INSERT, HoodieSparkSqlTestBase$.MODULE$.getLastCommitMetadata($this.spark(), new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName1).toString()).getOperationType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        String tableName2 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(320).append("\n             | create table ").append(tableName2).append(" using hudi\n             | partitioned by (dt)\n             | tblproperties(\n             |    primaryKey = 'id',\n             |    type = '").append(tableType).append("'\n             | )\n             | location '").append(tmp$2.getCanonicalPath()).append("/").append(tableName2).append("'\n             | AS\n             | select 1 as id, 'a1' as name, 10 as price, '2021-04-01' as dt\n         ").toString())).stripMargin());
        $this.assertResult(WriteOperationType.BULK_INSERT, HoodieSparkSqlTestBase$.MODULE$.getLastCommitMetadata($this.spark(), new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName2).toString()).getOperationType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, dt from ").append(tableName2).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-04-01"}))}));
        String tableName3 = $this.generateTableName();
        $this.assertThrows((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(362).append("\n               | create table ").append(tableName3).append(" using hudi\n               | partitioned by (dt)\n               | tblproperties(\n               |    primaryKey = 'id',\n               |    type = '").append(tableType).append("'\n               | )\n               | location '").append(tmp$2.getCanonicalPath()).append("/").append(tableName3).append("'\n               | AS\n               | select null as id, 'a1' as name, 10 as price, '2021-05-07' as dt\n               |\n             ").toString())).stripMargin()), ClassTag$.MODULE$.apply(Exception.class), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(363).append("\n             | create table ").append(tableName3).append(" using hudi\n             | partitioned by (dt)\n             | tblproperties(\n             |    primaryKey = 'id',\n             |    type = '").append(tableType).append("'\n             | )\n             | location '").append(tmp$2.getCanonicalPath()).append("/").append(tableName3).append("'\n             | AS\n             | select cast('2021-05-06 00:00:00' as timestamp) as dt, 1 as id, 'a1' as name, 10 as\n             | price\n         ").toString())).stripMargin());
        $this.assertResult(WriteOperationType.BULK_INSERT, HoodieSparkSqlTestBase$.MODULE$.getLastCommitMetadata($this.spark(), new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName3).toString()).getOperationType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        $this.checkAnswer(new StringBuilder(48).append("select id, name, price, cast(dt as string) from ").append(tableName3).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-05-06 00:00:00"}))}));
        String tableName4 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(349).append("\n             | create table ").append(tableName4).append(" using hudi\n             | partitioned by (dt)\n             | tblproperties(\n             |    primaryKey = 'id',\n             |    type = '").append(tableType).append("'\n             | )\n             | location '").append(tmp$2.getCanonicalPath()).append("/").append(tableName4).append("'\n             | AS\n             | select cast('2021-05-06' as date) as dt, 1 as id, 'a1' as name, 10 as\n             | price\n         ").toString())).stripMargin());
        $this.assertResult(WriteOperationType.BULK_INSERT, HoodieSparkSqlTestBase$.MODULE$.getLastCommitMetadata($this.spark(), new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName4).toString()).getOperationType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        $this.checkAnswer(new StringBuilder(48).append("select id, name, price, cast(dt as string) from ").append(tableName4).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-05-06"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$16(TestCreateTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestCreateTable.$anonfun$new$17($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$23(TestCreateTable $this, String sourceTable$1, String tableType$2, String targetTable) {
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(85).append("\n                 |create table ").append(targetTable).append("\n                 |like ").append(sourceTable$1).append("\n                 |using hudi").toString())).stripMargin());
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(targetTable));
        $this.assertResult(targetTable, table.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
        $this.assertResult("hudi", table.provider().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        $this.assertResult(CatalogTableType$.MODULE$.MANAGED(), table.tableType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        $this.assertResult(((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> new StructField(x$5, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))), table.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
        $this.assertResult(tableType$2, table.properties().apply((Object)"type"), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        $this.assertResult("id,name", table.properties().apply((Object)"primaryKey"), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
        $this.assertThrows((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(91).append("\n                   |create table ").append(targetTable).append("\n                   |like ").append(sourceTable$1).append("\n                   |using hudi").toString())).stripMargin()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n                 |create table if not exists ").append(targetTable).append("\n                 |like ").append(sourceTable$1).append("\n                 |using hudi").toString())).stripMargin());
    }

    public static final /* synthetic */ void $anonfun$new$26(TestCreateTable $this, String sourceTable$1, File tmp$3, String targetTable) {
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("\n                 |create table ").append(targetTable).append("\n                 |like ").append(sourceTable$1).append("\n                 |using hudi\n                 |location '").append(tmp$3.getCanonicalPath()).append("/").append(targetTable).append("'").toString())).stripMargin());
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(targetTable));
        $this.assertResult(CatalogTableType$.MODULE$.EXTERNAL(), table.tableType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
    }

    public static final /* synthetic */ void $anonfun$new$27(TestCreateTable $this, String sourceTable$1, String targetTable) {
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n                 |create table ").append(targetTable).append("\n                 |like ").append(sourceTable$1).append("\n                 |using hudi\n                 |tblproperties (primaryKey = 'id')").toString())).stripMargin());
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(targetTable));
        $this.assertResult("id", table.properties().apply((Object)"primaryKey"), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
    }

    public static final /* synthetic */ void $anonfun$new$22(TestCreateTable $this, String tableType$2, File tmp$3, String sourceTable) {
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(328).append("\n               |create table ").append(sourceTable).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts long\n               |) using hudi\n               | tblproperties (\n               |  primaryKey = 'id,name',\n               |  type = '").append(tableType$2).append("'\n               | )\n               | location '").append(tmp$3.getCanonicalPath()).append("/").append(sourceTable).append("'").toString())).stripMargin());
        $this.withTable($this.generateTableName(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)targetTable -> {
            TestCreateTable.$anonfun$new$23($this, sourceTable, tableType$2, targetTable);
            return BoxedUnit.UNIT;
        });
        $this.withTable($this.generateTableName(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)targetTable -> {
            TestCreateTable.$anonfun$new$26($this, sourceTable, tmp$3, targetTable);
            return BoxedUnit.UNIT;
        });
        $this.withTable($this.generateTableName(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)targetTable -> {
            TestCreateTable.$anonfun$new$27($this, sourceTable, targetTable);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$20(TestCreateTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            $this.withTable($this.generateTableName(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sourceTable -> {
                TestCreateTable.$anonfun$new$22($this, tableType, tmp$3, sourceTable);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$30(TestCreateTable $this, String sourceTable$2, String targetTable) {
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(200).append("\n               |create table ").append(targetTable).append("\n               |like ").append(sourceTable$2).append("\n               |using hudi\n               |tblproperties (\n               | primaryKey = 'id,name',\n               | type = 'cow'\n               |)").toString())).stripMargin());
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(targetTable));
        $this.assertResult(targetTable, table.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
        $this.assertResult("hudi", table.provider().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
        $this.assertResult(CatalogTableType$.MODULE$.MANAGED(), table.tableType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 523));
        $this.assertResult(((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> new StructField(x$6, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))), table.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
        $this.assertResult(BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)table.properties().size()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
        $this.assertResult("cow", table.properties().apply((Object)"type"), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
        $this.assertResult("id,name", table.properties().apply((Object)"primaryKey"), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
        $this.assertResult("hudi", table.properties().apply((Object)"provider"), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
    }

    public static final /* synthetic */ void $anonfun$new$29(TestCreateTable $this, File tmp$4, String sourceTable) {
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(287).append("\n             |create table ").append(sourceTable).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using parquet\n             | tblproperties (\n             |  non.hoodie.property='value'\n             | )\n             | location '").append(tmp$4.getCanonicalPath()).append("/").append(sourceTable).append("'").toString())).stripMargin());
        $this.withTable($this.generateTableName(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)targetTable -> {
            TestCreateTable.$anonfun$new$30($this, sourceTable, targetTable);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$33(TestCreateTable $this, File tmp) {
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(227).append("\n           | create table ").append(tableName1).append(" using hudi\n           | tblproperties(\n           |    type = 'cow'\n           | )\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName1).append("'\n           | AS\n           | select 1 as id, 'a1' as name, 10 as price, 1000 as ts\n       ").toString())).stripMargin());
        $this.assertResult(WriteOperationType.BULK_INSERT, HoodieSparkSqlTestBase$.MODULE$.getLastCommitMetadata($this.spark(), new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName1).toString()).getOperationType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 558));
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        String tableName2 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(270).append("\n           | create table ").append(tableName2).append(" using hudi\n           | partitioned by (dt)\n           | tblproperties(\n           |    type = 'cow'\n           | )\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName2).append("'\n           | AS\n           | select 1 as id, 'a1' as name, 10 as price, '2021-04-01' as dt\n         ").toString())).stripMargin());
        $this.assertResult(WriteOperationType.BULK_INSERT, HoodieSparkSqlTestBase$.MODULE$.getLastCommitMetadata($this.spark(), new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName2).toString()).getOperationType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580));
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, dt from ").append(tableName2).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-04-01"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$36(TestCreateTable $this, File tmp) {
        String parentPath = tmp.getCanonicalPath();
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringBuilder(11).append("set ").append(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key()).append("=upsert").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(300).append("\n           |create table ").append(tableName1).append(" (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts',\n           |  type = 'mor'\n           | )\n           | location '").append(parentPath).append("/").append(tableName1).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(35).append("insert into ").append(tableName1).append(" values (1, 'a1', 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("insert into ").append(tableName1).append(" values (1, 'a2', 1100)").toString());
        String roTableName1 = new StringBuilder(3).append(tableName1).append("_ro").toString();
        String rtTableName1 = new StringBuilder(3).append(tableName1).append("_rt").toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(178).append("\n           |create table ").append(roTableName1).append("\n           |using hudi\n           |tblproperties (\n           | 'hoodie.query.as.ro.table' = 'true'\n           |)\n           |location '").append(parentPath).append("/").append(tableName1).append("'\n           |").toString())).stripMargin());
        CatalogTable roCatalogTable = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(roTableName1));
        $this.assertResult(roCatalogTable.properties().apply((Object)"type"), "mor", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
        $this.assertResult(roCatalogTable.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
        $this.assertResult(roCatalogTable.properties().apply((Object)"preCombineField"), "ts", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
        $this.assertResult(roCatalogTable.storage().properties().apply((Object)"hoodie.query.as.ro.table"), "true", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
        $this.checkAnswer(new StringBuilder(25).append("select id, name, ts from ").append(roTableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(179).append("\n           |create table ").append(rtTableName1).append("\n           |using hudi\n           |tblproperties (\n           | 'hoodie.query.as.ro.table' = 'false'\n           |)\n           |location '").append(parentPath).append("/").append(tableName1).append("'\n           |").toString())).stripMargin());
        CatalogTable rtCatalogTable = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(rtTableName1));
        $this.assertResult(rtCatalogTable.properties().apply((Object)"type"), "mor", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686));
        $this.assertResult(rtCatalogTable.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 687));
        $this.assertResult(rtCatalogTable.properties().apply((Object)"preCombineField"), "ts", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
        $this.assertResult(rtCatalogTable.storage().properties().apply((Object)"hoodie.query.as.ro.table"), "false", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
        $this.checkAnswer(new StringBuilder(25).append("select id, name, ts from ").append(rtTableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToInteger((int)1100)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$38(TestCreateTable $this, File tmp) {
        String parentPath = tmp.getCanonicalPath();
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(298).append("\n           |create table ").append(tableName1).append(" (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts',\n           |  type = 'cow'\n           | )\n           | location '").append(parentPath).append("/").append(tableName1).append("'\n     ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(35).append("insert into ").append(tableName1).append(" values (1, 'a1', 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("insert into ").append(tableName1).append(" values (1, 'a2', 1100)").toString());
        String roTableName1 = new StringBuilder(3).append(tableName1).append("_ro").toString();
        $this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(178).append("\n           |create table ").append(roTableName1).append("\n           |using hudi\n           |tblproperties (\n           | 'hoodie.query.as.ro.table' = 'true'\n           |)\n           |location '").append(parentPath).append("/").append(tableName1).append("'\n           |").toString())).stripMargin(), "Creating ro/rt table should only apply to a mor table.");
        String tableName2 = $this.generateTableName();
        String rtTableName2 = new StringBuilder(3).append(tableName2).append("_rt").toString();
        $this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(178).append("\n           |create table ").append(rtTableName2).append("\n           |using hudi\n           |tblproperties (\n           | 'hoodie.query.as.ro.table' = 'true'\n           |)\n           |location '").append(parentPath).append("/").append(tableName2).append("'\n           |").toString())).stripMargin(), "Creating ro/rt table need the existence of the base table.");
        String tableName3 = $this.generateTableName();
        $this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(348).append("\n           | create table ").append(tableName3).append(" using hudi\n           | tblproperties(\n           |    primaryKey = 'id',\n           |    preCombineField = 'ts',\n           |    type = 'mor',\n           |    'hoodie.query.as.ro.table' = 'true'\n           | )\n           | location '").append(parentPath).append("/").append(tableName3).append("'\n           | AS\n           | select 1 as id, 'a1' as name, 1000 as ts\n           | ").toString())).stripMargin(), "Not support CTAS for the ro/rt table");
    }

    public static final /* synthetic */ void $anonfun$new$40(TestCreateTable $this, String tableType) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(494).append("\n           | create table ").append(tableName).append(" using hudi\n           | partitioned by (dt)\n           | tblproperties(\n           |    hoodie.database.name = \"databaseName\",\n           |    hoodie.table.name = \"tableName\",\n           |    primaryKey = 'id',\n           |    preCombineField = 'ts',\n           |    hoodie.datasource.write.operation = 'upsert',\n           |    type = '").append(tableType).append("'\n           | )\n           | AS\n           | select 1 as id, 'a1' as name, 10 as price, '2021-04-01' as dt, 1000 as ts\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-04-01"}))}));
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
        Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.DATABASE_NAME.key()));
        Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.NAME.key()));
        Assertions.assertFalse((boolean)table.properties().contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
        String tablePath = (String)table.storage().properties().apply((Object)"path");
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
        Map tableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        $this.assertResult("default", tableConfig.apply((Object)HoodieTableConfig.DATABASE_NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 795));
        $this.assertResult(tableName, tableConfig.apply((Object)HoodieTableConfig.NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 796));
        Assertions.assertFalse((boolean)tableConfig.contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
    }

    public static final /* synthetic */ void $anonfun$new$42(TestCreateTable $this, String tableType) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(488).append("\n           | create table ").append(tableName).append(" using hudi\n           | partitioned by (dt)\n           | options(\n           |    hoodie.database.name = \"databaseName\",\n           |    hoodie.table.name = \"tableName\",\n           |    primaryKey = 'id',\n           |    preCombineField = 'ts',\n           |    hoodie.datasource.write.operation = 'upsert',\n           |    type = '").append(tableType).append("'\n           | )\n           | AS\n           | select 1 as id, 'a1' as name, 10 as price, '2021-04-01' as dt, 1000 as ts\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-04-01"}))}));
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
        Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.DATABASE_NAME.key()));
        Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.NAME.key()));
        Assertions.assertFalse((boolean)table.properties().contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
        String tablePath = (String)table.storage().properties().apply((Object)"path");
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
        Map tableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        $this.assertResult("default", tableConfig.apply((Object)HoodieTableConfig.DATABASE_NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 831));
        $this.assertResult(tableName, tableConfig.apply((Object)HoodieTableConfig.NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 832));
        Assertions.assertFalse((boolean)tableConfig.contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
    }

    public static final /* synthetic */ void $anonfun$new$46(TestCreateTable $this, File tmp$5, String partitionValue) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$5.getCanonicalPath()).append("/").append(tableName).toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCreateTable.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_ddl_TestCreateTable$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_spark_sql_hudi_ddl_TestCreateTable$$typecreator6$1(TestCreateTable $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)partitionValue), (List)Nil$.MODULE$), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_ddl_TestCreateTable$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), new StringBuilder(9).append("original_").append(tableName).toString()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "dt").option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
        $this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(114).append("\n             |create table ").append(tableName).append(" using hudi\n             |partitioned by (dt)\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin(), "It is not allowed to specify partition columns when the table schema is not defined.");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n             |create table ").append(tableName).append(" using hudi\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, value, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
        Map properties = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)properties.contains((Object)HoodieTableConfig.CREATE_SCHEMA.key())), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 908));
        $this.assertResult("dt", properties.apply((Object)HoodieTableConfig.PARTITION_FIELDS.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 909));
        $this.assertResult("ts", properties.apply((Object)HoodieTableConfig.PRECOMBINE_FIELD.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 910));
        $this.assertResult("hudi_database", metaClient.getTableConfig().getDatabaseName(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 911));
        $this.assertResult(new StringBuilder(9).append("original_").append(tableName).toString(), metaClient.getTableConfig().getTableName(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 912));
        $this.spark().sql(new StringBuilder(42).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000, '").append(partitionValue).append("')").toString());
        $this.checkAnswer(new StringBuilder(92).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", partitionValue, BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", partitionValue, BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(209).append("\n             |merge into ").append(tableName).append(" h0\n             |using (select 1 as id, 'a1' as name, 11 as value, 1001 as ts, '").append(partitionValue).append("' as dt) s0\n             |on h0.id = s0.id\n             |when matched then update set *\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(92).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", partitionValue, BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001), partitionValue})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", partitionValue, BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
        $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set value = value + 1 where id = 2").toString());
        $this.checkAnswer(new StringBuilder(92).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", partitionValue, BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001), partitionValue})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", partitionValue, BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
        $this.spark().sql(new StringBuilder(25).append("delete from ").append(tableName).append(" where id = 1").toString());
        $this.checkAnswer(new StringBuilder(92).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", partitionValue, BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000), partitionValue}))}));
    }

    public static final /* synthetic */ void $anonfun$new$45(TestCreateTable $this, File tmp) {
        String databaseName = "hudi_database";
        $this.spark().sql(new StringBuilder(30).append("create database if not exists ").append(databaseName).toString());
        $this.spark().sql(new StringBuilder(4).append("use ").append(databaseName).toString());
        ((IterableLike)new .colon.colon((Object)"2021-08-02", (List)new .colon.colon((Object)"2021/08/02", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)partitionValue -> {
            TestCreateTable.$anonfun$new$46($this, tmp, partitionValue);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$49(TestCreateTable $this, File tmp$6, String day) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$6.getCanonicalPath()).append("/").append(tableName).toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCreateTable.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_ddl_TestCreateTable$$typecreator16$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_spark_sql_hudi_ddl_TestCreateTable$$typecreator16$1(TestCreateTable $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)day, (Object)BoxesRunTime.boxToInteger((int)12)), (List)Nil$.MODULE$), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_ddl_TestCreateTable$$typecreator16$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "day", "hh"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "day,hh").option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), "true").option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n             |create table ").append(tableName).append(" using hudi\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(41).append("select id, name, value, ts, day, hh from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)}))}));
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
        Map properties = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)properties.contains((Object)HoodieTableConfig.CREATE_SCHEMA.key())), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 979));
        $this.assertResult("day,hh", properties.apply((Object)HoodieTableConfig.PARTITION_FIELDS.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 980));
        $this.assertResult("ts", properties.apply((Object)HoodieTableConfig.PRECOMBINE_FIELD.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 981));
        String escapedPathPart = PartitionPathEncodeUtils.escapePathName((String)day);
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000, '").append(day).append("', 12)").toString());
        $this.checkAnswer(new StringBuilder(97).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, day, hh from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", new StringBuilder(3).append(escapedPathPart).append("/12").toString(), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", new StringBuilder(3).append(escapedPathPart).append("/12").toString(), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(220).append("\n             |merge into ").append(tableName).append(" h0\n             |using (select 1 as id, 'a1' as name, 11 as value, 1001 as ts, '").append(day).append("' as day, 12 as hh) s0\n             |on h0.id = s0.id\n             |when matched then update set *\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(97).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, day, hh from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", new StringBuilder(3).append(escapedPathPart).append("/12").toString(), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001), day, BoxesRunTime.boxToInteger((int)12)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", new StringBuilder(3).append(escapedPathPart).append("/12").toString(), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)}))}));
        $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set value = value + 1 where id = 2").toString());
        $this.checkAnswer(new StringBuilder(97).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, day, hh from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", new StringBuilder(3).append(escapedPathPart).append("/12").toString(), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001), day, BoxesRunTime.boxToInteger((int)12)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", new StringBuilder(3).append(escapedPathPart).append("/12").toString(), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)}))}));
        $this.spark().sql(new StringBuilder(25).append("delete from ").append(tableName).append(" where id = 1").toString());
        $this.checkAnswer(new StringBuilder(97).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts, day, hh from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", new StringBuilder(3).append(escapedPathPart).append("/12").toString(), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000), day, BoxesRunTime.boxToInteger((int)12)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$48(TestCreateTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"2021-08-02", (List)new .colon.colon((Object)"2021/08/02", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)day -> {
            TestCreateTable.$anonfun$new$49($this, tmp, day);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$51(TestCreateTable $this, File tmp) {
        String tableName = $this.generateTableName();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCreateTable.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_ddl_TestCreateTable$$typecreator26$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_sql_hudi_ddl_TestCreateTable$$typecreator26$1(TestCreateTable $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000)), (List)Nil$.MODULE$), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_ddl_TestCreateTable$$typecreator26$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "").option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tmp.getCanonicalPath());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(74).append("\n           |create table ").append(tableName).append(" using hudi\n           |location '").append(tmp.getCanonicalPath()).append("'\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, value, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)}))}));
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tmp.getCanonicalPath());
        Map properties = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)properties.contains((Object)HoodieTableConfig.CREATE_SCHEMA.key())), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1047));
        $this.assertResult("ts", properties.apply((Object)HoodieTableConfig.PRECOMBINE_FIELD.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1048));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000)").toString());
        $this.checkAnswer(new StringBuilder(88).append("select _hoodie_record_key, _hoodie_partition_path, id, name, value, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "", BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "", BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(189).append("\n           |merge into ").append(tableName).append(" h0\n           |using (select 1 as id, 'a1' as name, 11 as value, 1001 as ts) s0\n           |on h0.id = s0.id\n           |when matched then update set *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, value, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set value = value + 1 where id = 2").toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, value, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(25).append("delete from ").append(tableName).append(" where id = 1").toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, value, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    private final Assertion checkKeyGenerator$1(String targetGenerator, String tableName) {
        String tablePath = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName)).location().getPath();
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)tablePath);
        String realKeyGenerator = metaClient.getTableConfig().getKeyGeneratorClassName();
        return this.assertResult(targetGenerator, realKeyGenerator, Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1184));
    }

    public static final /* synthetic */ void $anonfun$new$59(TestCreateTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(414).append("\n             |CREATE TABLE ").append(tableName).append(" USING hudi\n             | LOCATION '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n             | TBLPROPERTIES (\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | AS SELECT * FROM (\n             |  SELECT 1 as id, 'a1' as name, 10 as price, 1000 as ts\n             |  UNION ALL\n             |  SELECT 1 as id, 'a1' as name, 11 as price, 1001 as ts\n             | )\n       ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1001)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$65(TestCreateTable $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = String.valueOf(tmp.getCanonicalPath());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(326).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  type = 'cow',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(11).append("drop table ").append(tableName).toString())).stripMargin());
        org.apache.hudi.common.util.Option tableSchemaAfterCreate1 = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath).getTableConfig().getTableCreateSchema();
        $this.spark().newSession().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(326).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  type = 'cow',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        org.apache.hudi.common.util.Option tableSchemaAfterCreate2 = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath).getTableConfig().getTableCreateSchema();
        $this.assertResult(tableSchemaAfterCreate1.get(), tableSchemaAfterCreate2.get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1381));
    }

    public static final /* synthetic */ void $anonfun$new$68(TestCreateTable $this, String tableType$3, String tableName) {
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(379).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  primaryKey ='id',\n             |  type = '").append(tableType$3).append("',\n             |  preCombineField = 'ts',\n             |  hoodie.table.base.file.format = 'PARQUET'\n             | )\n       ").toString())).stripMargin());
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
        $this.assertResult(table.storage().serde().get(), "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1405));
        $this.assertResult(table.storage().inputFormat().get(), tableType$3.equals("mor") ? "org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat" : "org.apache.hudi.hadoop.HoodieParquetInputFormat", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1406));
        $this.assertResult(table.storage().outputFormat().get(), "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1409));
    }

    public static final /* synthetic */ void $anonfun$new$69(TestCreateTable $this, String tableName) {
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(354).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | tblproperties (\n           |  primaryKey ='id',\n           |  type = 'cow',\n           |  preCombineField = 'ts',\n           |  hoodie.table.base.file.format = 'ORC'\n           | )\n       ").toString())).stripMargin());
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
        $this.assertResult(table.storage().serde().get(), "org.apache.hadoop.hive.ql.io.orc.OrcSerde", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1431));
        $this.assertResult(table.storage().inputFormat().get(), "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1432));
        $this.assertResult(table.storage().outputFormat().get(), "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1433));
    }

    public static final /* synthetic */ void $anonfun$new$72(TestCreateTable $this, String tableType$4, String tableName) {
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(366).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  hoodie.table.recordkey.fields ='id',\n             |  hoodie.table.type = '").append(tableType$4).append("',\n             |  hoodie.table.precombine.field = 'ts'\n             | )\n       ").toString())).stripMargin());
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply($this.spark(), TableIdentifier$.MODULE$.apply(tableName));
        $this.assertResult(new String[]{"id"}, hoodieCatalogTable.primaryKeys(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1455));
        $this.assertResult(tableType$4, hoodieCatalogTable.tableTypeName(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1456));
        $this.assertResult("ts", hoodieCatalogTable.preCombineKey().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1457));
    }

    public static final /* synthetic */ void $anonfun$new$74(TestCreateTable $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = String.valueOf(tmp.getCanonicalPath());
        $this.assertThrows((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(427).append("\n             | create table ").append(tableName).append(" (\n             |    ts BIGINT,\n             |    id STRING,\n             |    rider STRING,\n             |    driver STRING,\n             |    fare DOUBLE,\n             |    city STRING,\n             |    state STRING\n             |) using hudi\n             | options(\n             |    primaryKey ='id'\n             |)\n             |PARTITIONED BY (state, city)\n             |location '").append(tablePath).append("';\n       ").toString())).stripMargin()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1467));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(399).append("\n           | create table ").append(tableName).append(" (\n           |    ts BIGINT,\n           |    id STRING,\n           |    rider STRING,\n           |    driver STRING,\n           |    fare DOUBLE,\n           |    city STRING,\n           |    state STRING\n           |) using hudi\n           | options(\n           |    primaryKey ='id'\n           |)\n           |PARTITIONED BY (city, state)\n           |location '").append(tablePath).append("';\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(83).append("insert into ").append(tableName).append(" values(1695332066,'trip3','rider-E','driver-O',93.50,'austin','texas')").toString());
        $this.checkAnswer(new StringBuilder(53).append("select ts, id, rider, driver, fare, city, state from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1695332066), "trip3", "rider-E", "driver-O", BoxesRunTime.boxToDouble((double)93.5), "austin", "texas"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$77(TestCreateTable $this, File tmp) {
        String parentPath = tmp.getCanonicalPath();
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(298).append("\n           |create table ").append(tableName1).append(" (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts',\n           |  type = 'cow'\n           | )\n           | location '").append(parentPath).append("/").append(tableName1).append("'\n     ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(35).append("insert into ").append(tableName1).append(" values (1, 'a1', 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("insert into ").append(tableName1).append(" values (1, 'a2', 1100)").toString());
        $this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName1).toString());
        $this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(311).append("\n           |create table ").append(tableName1).append(" (\n           |  id int,\n           |  name map<string, string>,\n           |  ts long\n           |) using hudi\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts',\n           |  type = 'cow'\n           | )\n           | location '").append(parentPath).append("/").append(tableName1).append("'\n     ").toString())).stripMargin(), "Failed to create catalog table in metastore");
    }

    public static final /* synthetic */ void $anonfun$new$81(TestCreateTable $this, File tmp$7, String tableType) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp$7.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(401).append("\n               |create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts long\n               |) using hudi\n               | options (\n               |  primaryKey ='id',\n               |  type = '").append(tableType).append("',\n               |  preCombineField = 'ts'\n               | )\n               | partitioned by(ts)\n               | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a2', 10, 1000)").toString());
        $this.checkAnswer(new StringBuilder(21).append("select id, name from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2"}))}));
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        String tableName2 = $this.generateTableName();
        String basePath2 = new StringBuilder(1).append(tmp$7.getCanonicalPath()).append("/").append(tableName2).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(877).append("\n               |create table ").append(tableName2).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  segment string,\n               |  ts long\n               |) using hudi\n               | options (\n               |  primaryKey ='id',\n               |  type = '").append(tableType).append("',\n               |  preCombineField = 'ts',\n               |  'hoodie.datasource.write.partitionpath.field' = 'segment:simple,ts:timestamp',\n               |  'hoodie.datasource.write.keygenerator.class' = 'org.apache.hudi.keygen.CustomKeyGenerator',\n               |  'hoodie.keygen.timebased.timestamp.type' = 'SCALAR',\n               |  'hoodie.keygen.timebased.output.dateformat' = 'YYYY',\n               |  'hoodie.keygen.timebased.timestamp.scalar.time.unit' = 'seconds'\n               | )\n               | partitioned by(segment,ts)\n               | location '").append(basePath2).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName2).append(" values(1, 'a1', 10, 'seg1', 1000)").toString());
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName2).append(" values(1, 'a2', 10, 'seg1', 1000)").toString());
        $this.checkAnswer(new StringBuilder(21).append("select id, name from ").append(tableName2).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2"}))}));
        $this.checkAnswer(new StringBuilder(41).append("select id, name, price, segment, ts from ").append(tableName2).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)10.0), "seg1", BoxesRunTime.boxToInteger((int)1000)}))}));
        String tableName3 = $this.generateTableName();
        String basePath3 = new StringBuilder(1).append(tmp$7.getCanonicalPath()).append("/").append(tableName3).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(882).append("\n               |create table ").append(tableName3).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  segment string,\n               |  ts long\n               |) using hudi\n               | options (\n               |  primaryKey ='id',\n               |  type = '").append(tableType).append("',\n               |  preCombineField = 'segment',\n               |  'hoodie.datasource.write.partitionpath.field' = 'segment:simple,ts:timestamp',\n               |  'hoodie.datasource.write.keygenerator.class' = 'org.apache.hudi.keygen.CustomKeyGenerator',\n               |  'hoodie.keygen.timebased.timestamp.type' = 'SCALAR',\n               |  'hoodie.keygen.timebased.output.dateformat' = 'YYYY',\n               |  'hoodie.keygen.timebased.timestamp.scalar.time.unit' = 'seconds'\n               | )\n               | partitioned by(segment,ts)\n               | location '").append(basePath3).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName3).append(" values(1, 'a1', 10, 'seg1', 1000)").toString());
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName3).append(" values(1, 'a2', 10, 'seg1', 1000)").toString());
        $this.checkAnswer(new StringBuilder(21).append("select id, name from ").append(tableName3).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2"}))}));
        $this.checkAnswer(new StringBuilder(41).append("select id, name, price, segment, ts from ").append(tableName3).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)10.0), "seg1", BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$80(TestCreateTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestCreateTable.$anonfun$new$81($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public TestCreateTable() {
        this.test("Test Create Managed Hoodie Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String databaseName = "hudi_database";
            this.spark().sql(new StringBuilder(30).append("create database if not exists ").append(databaseName).toString());
            this.spark().sql(new StringBuilder(4).append("use ").append(databaseName).toString());
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(415).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using hudi\n         | tblproperties (\n         |   hoodie.database.name = \"databaseName\",\n         |   hoodie.table.name = \"tableName\",\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts',\n         |   hoodie.datasource.write.operation = 'upsert'\n         | )\n       ").toString())).stripMargin());
            CatalogTable table = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
            this.assertResult(tableName, table.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            this.assertResult("hudi", table.provider().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            this.assertResult(CatalogTableType$.MODULE$.MANAGED(), table.tableType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            this.assertResult(((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> new StructField(x$1, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))), table.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.DATABASE_NAME.key()));
            Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.NAME.key()));
            Assertions.assertFalse((boolean)table.properties().contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
            String tablePath = (String)table.storage().properties().apply((Object)"path");
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)tablePath);
            HoodieTableConfig tableConfig = metaClient.getTableConfig();
            this.assertResult(databaseName, tableConfig.getDatabaseName(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            this.assertResult(tableName, tableConfig.getTableName(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(tableConfig.contains(DataSourceWriteOptions$.MODULE$.OPERATION().key())));
            org.apache.hudi.common.util.Option schemaOpt = tableConfig.getTableCreateSchema();
            Assertions.assertTrue((boolean)schemaOpt.isPresent(), (String)"Table create schema should be persisted");
            Assertions.assertFalse((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((Schema)schemaOpt.get()).getFields()).asScala()).exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieRecord.HOODIE_META_COLUMNS.contains(f.name()))), (String)"Table create schema should not include metadata fields");
            return this.spark().sql("use default");
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("Test Create Hoodie Table With Options", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(463).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long,\n         |  dt string\n         | ) using hudi\n         | partitioned by (dt)\n         | options (\n         |   hoodie.database.name = \"databaseName\",\n         |   hoodie.table.name = \"tableName\",\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts',\n         |   hoodie.datasource.write.operation = 'upsert'\n         | )\n       ").toString())).stripMargin());
            CatalogTable table = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
            this.assertResult(table.properties().apply((Object)"type"), "cow", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            this.assertResult(table.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            this.assertResult(table.properties().apply((Object)"preCombineField"), "ts", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            this.assertResult(tableName, table.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            this.assertResult("hudi", table.provider().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            this.assertResult(CatalogTableType$.MODULE$.MANAGED(), table.tableType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            this.assertResult(((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> new StructField(x$2, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("dt", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))))), table.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.DATABASE_NAME.key()));
            Assertions.assertFalse((boolean)table.properties().contains((Object)HoodieTableConfig.NAME.key()));
            Assertions.assertFalse((boolean)table.properties().contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
            String tablePath = (String)table.storage().properties().apply((Object)"path");
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)tablePath);
            Map tableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
            this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)tableConfig.contains((Object)HoodieTableConfig.CREATE_SCHEMA.key())), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            this.assertResult("dt", tableConfig.apply((Object)HoodieTableConfig.PARTITION_FIELDS.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            this.assertResult("id", tableConfig.apply((Object)HoodieTableConfig.RECORDKEY_FIELDS.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            this.assertResult("ts", tableConfig.apply((Object)HoodieTableConfig.PRECOMBINE_FIELD.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            this.assertResult(KeyGeneratorType.SIMPLE.name(), tableConfig.apply((Object)HoodieTableConfig.KEY_GENERATOR_TYPE.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            this.assertResult("default", tableConfig.apply((Object)HoodieTableConfig.DATABASE_NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            this.assertResult(tableName, tableConfig.apply((Object)HoodieTableConfig.NAME.key()), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            Assertions.assertFalse((boolean)tableConfig.contains((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()));
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("Test Create External Hoodie Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$7(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("Test Table Column Validate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$11(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        this.test("Test Create Table As Select", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$16(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        this.test("Test create table like", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestCreateTable.$anonfun$new$20(this, tmp);
                return BoxedUnit.UNIT;
            });
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                this.withTable(this.generateTableName(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sourceTable -> {
                    TestCreateTable.$anonfun$new$29($this, tmp, sourceTable);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
        this.test("Test Create Table As Select With Auto record key gen", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$33(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543));
        this.test("Test Create Table As Select For existing table path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String tableName1 = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(230).append("\n         |create table ").append(tableName1).append(" (\n         |  id int,\n         |  name string,\n         |  ts long\n         |) using hudi\n         | tblproperties (\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts'\n         |)\n         |").toString())).stripMargin());
            URI tableLocation = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName1)).location();
            this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName1).toString());
            String tableName2 = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(247).append("\n         |create table ").append(tableName2).append(" (\n         |  id int,\n         |  name string,\n         |  ts long\n         |) using hudi\n         | tblproperties (\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts'\n         |)\n         |location '").append(tableLocation).append("'\n     ").toString())).stripMargin());
            this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(84).append("\n         |create table ").append(tableName1).append("\n         |using hudi\n         |as select * from ").append(tableName2).append("\n         |").toString())).stripMargin(), "Can not create the managed table");
            return this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)this.existsPath(tableLocation.toString())), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
        this.test("Test Create ro/rt Table In The Right Way", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestCreateTable.$anonfun$new$36(this, tmp);
                return BoxedUnit.UNIT;
            });
            this.spark().sessionState().conf().unsetConf(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key());
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
        this.test("Test Create ro/rt Table In The Wrong Way", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$38(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 697));
        this.test("Test Create Table As Select With Tblproperties For Filter Props", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestCreateTable.$anonfun$new$40(this, tableType);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
        this.test("Test Create Table As Select With Options For Filter Props", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestCreateTable.$anonfun$new$42(this, tableType);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
        this.test("Test Create Table As Select when 'spark.sql.datetime.java8API.enabled' enables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            try {
                this.spark().conf().set("spark.sql.datetime.java8API.enabled", true);
                String tableName = this.generateTableName();
                this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(263).append("\n           |create table ").append(tableName).append("\n           |using hudi\n           |partitioned by(dt)\n           |options(type = 'cow', primaryKey = 'id')\n           |as\n           |select 1 as id, 'a1' as name, 10 as price, cast('2021-05-07 00:00:00' as timestamp) as dt\n           |").toString())).stripMargin());
                this.checkAnswer(new StringBuilder(48).append("select id, name, price, cast(dt as string) from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-05-07 00:00:00"}))}));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                this.spark().conf().set("spark.sql.datetime.java8API.enabled", false);
            }
            return boxedUnit;
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 837));
        this.test("Test Create Table From Existing Hoodie Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$45(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 864));
        this.test("Test Create Table From Existing Hoodie Table For Multi-Level Partitioned Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$48(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 947));
        this.test("Test Create Table From Existing Hoodie Table For None Partitioned Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$51(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1018));
        this.test("Test Create Table Existing In Catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(170).append("\n         |create table ").append(tableName).append(" (\n         | id int,\n         | name string,\n         | price double\n         |) using hudi\n         |tblproperties(primaryKey = 'id')\n         |").toString())).stripMargin());
            this.spark().sql(new StringBuilder(35).append("alter table ").append(tableName).append(" add columns(ts bigint)").toString());
            return this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(184).append("\n         |create table if not exists ").append(tableName).append(" (\n         | id int,\n         | name string,\n         | price double\n         |) using hudi\n         |tblproperties(primaryKey = 'id')\n         |").toString())).stripMargin());
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1082));
        this.test("Test create table with comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(307).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using hudi\n         | comment \"This is a simple hudi table\"\n         | tblproperties (\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts'\n         | )\n       ").toString())).stripMargin());
            String shown = ((Row)this.spark().sql(new StringBuilder(18).append("show create table ").append(tableName).toString()).head()).getString(0);
            return this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)shown.contains("COMMENT 'This is a simple hudi table'")), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1127));
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1110));
        this.test("Test CTAS using an illegal definition -- a COW table with compaction enabled.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(269).append("\n         | create table ").append(tableName).append(" using hudi\n         | tblproperties(\n         |    primaryKey = 'id',\n         |    type = 'cow',\n         |    hoodie.compact.inline='true'\n         | )\n         | AS\n         | select 1 as id, 'a1' as name, 10 as price, 1000 as ts\n         |").toString())).stripMargin(), "Compaction is not supported on a CopyOnWrite table");
            String dbPath = this.spark().sessionState().catalog().getDatabaseMetadata("default").locationUri().getPath();
            String tablePath = new StringBuilder(1).append(dbPath).append("/").append(tableName).toString();
            return this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)this.existsPath(tablePath)), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1145));
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1130));
        this.test("Test Create Non-Hudi Table(Parquet Table)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String databaseName = "test_database";
            this.spark().sql(new StringBuilder(30).append("create database if not exists ").append(databaseName).toString());
            this.spark().sql(new StringBuilder(4).append("use ").append(databaseName).toString());
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using parquet\n       ").toString())).stripMargin());
            CatalogTable table = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
            this.assertResult(tableName, table.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1165));
            this.assertResult("parquet", table.provider().get(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1166));
            this.assertResult(CatalogTableType$.MODULE$.MANAGED(), table.tableType(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1167));
            this.assertResult(new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("price", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), table.schema().fields(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1174));
            return this.spark().sql("use default");
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1148));
        this.test("Test Infer KegGenClazz", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(307).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using hudi\n         | comment \"This is a simple hudi table\"\n         | tblproperties (\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts'\n         | )\n       ").toString())).stripMargin());
            this.checkKeyGenerator$1("org.apache.hudi.keygen.NonpartitionedKeyGenerator", tableName);
            this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(338).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using hudi\n         | comment \"This is a simple hudi table\"\n         | partitioned by (ts)\n         | tblproperties (\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts'\n         | )\n       ").toString())).stripMargin());
            this.checkKeyGenerator$1("org.apache.hudi.keygen.SimpleKeyGenerator", tableName);
            this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(343).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using hudi\n         | comment \"This is a simple hudi table\"\n         | partitioned by (ts)\n         | tblproperties (\n         |   primaryKey = 'id,name',\n         |   preCombineField = 'ts'\n         | )\n       ").toString())).stripMargin());
            this.checkKeyGenerator$1("org.apache.hudi.keygen.ComplexKeyGenerator", tableName);
            return this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1179));
        this.test("Test CTAS not de-duplicating (by default)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$59(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1246));
        this.test("Test init HoodieCatalogTable class for non-Hudi table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         | ) using parquet\n       ").toString())).stripMargin());
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])this.spark().sql(new StringBuilder(43).append("call show_commits(table => '").append(tableName).append("', limit => 10)").toString()).collect(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1284));
            Assertions.assertTrue((boolean)exception.getMessage().contains(new StringBuilder(20).append(tableName).append(" is not a Hudi table").toString()));
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1273));
        this.test("Test hoodie table schema consistency for non-Avro data types", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(267).append("\n         | create table ").append(tableName).append(" (\n         |  id tinyint,\n         |  name varchar(10),\n         |  price double,\n         |  ts long\n         | ) using hudi\n         | tblproperties (\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts'\n         | )\n       ").toString())).stripMargin());
            CatalogTable table = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
            HoodieCatalogTable hoodieCatalogTable = new HoodieCatalogTable(this.spark(), table);
            Option hoodieSchema = HoodieSqlCommonUtils$.MODULE$.getTableSqlSchema(hoodieCatalogTable.metaClient(), true);
            return this.assertResult(hoodieSchema.get(), table.schema(), Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1308));
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1290));
        this.test("Test Create Hoodie Table With Options in different case", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(463).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long,\n         |  dt string\n         | ) using hudi\n         | partitioned by (dt)\n         | options (\n         |   hoodie.database.name = \"databaseName\",\n         |   hoodie.table.name = \"tableName\",\n         |   PRIMARYKEY = 'id',\n         |   precombineField = 'ts',\n         |   hoodie.datasource.write.operation = 'upsert'\n         | )\n       ").toString())).stripMargin());
            CatalogTable table = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
            this.assertResult(table.properties().apply((Object)"type"), "cow", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1332));
            this.assertResult(table.properties().apply((Object)"primaryKey"), "id", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1333));
            return this.assertResult(table.properties().apply((Object)"preCombineField"), "ts", Prettifier$.MODULE$.default(), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1334));
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1311));
        this.test("Test Create Hoodie Table with existing hoodie.properties", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$65(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1337));
        this.test("Test Create Hoodie Table with base file format", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
                this.withTable(this.generateTableName(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tableName -> {
                    TestCreateTable.$anonfun$new$68($this, tableType, tableName);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            this.withTable(this.generateTableName(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tableName -> {
                TestCreateTable.$anonfun$new$69(this, tableName);
                return BoxedUnit.UNIT;
            });
        }, new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1385));
        this.test("Test Create Hoodie Table with table configs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"COPY_ON_WRITE", (List)new .colon.colon((Object)"MERGE_ON_READ", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTable(this.generateTableName(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tableName -> {
                TestCreateTable.$anonfun$new$72($this, tableType, tableName);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1437));
        this.test("Test Create Hoodie Table With Multiple Partitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$74(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1462));
        this.test("Test Create Table In Inconsistent Schemes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$77(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1512));
        this.test("Test Create Table with Same Value for Partition and Precombine", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.parquet.small.file.limit"), (Object)"0")}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCreateTable.$anonfun$new$80(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestCreateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1554));
    }
}

