/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.ddl;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.DefaultSparkRecordMerger;
import org.apache.hudi.QuickstartUtils;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.inmemory.HoodieInMemoryHashIndex;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0006\r\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005BQ\u0001\n\u0001\u0005\u0002\u0015BQ!\u0010\u0001\u0005\u0002yBQa\u0013\u0001\u0005\n1CQa\u0018\u0001\u0005\n\u0001DQ\u0001\u001b\u0001\u0005\u0002%DQa\u001d\u0001\u0005\u0002QDqA\u001e\u0001C\u0002\u0013\u0005q\u000fC\u0004\u0002\u0010\u0001\u0001\u000b\u0011\u0002=\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014\tiA+Z:u'B\f'o[\u001aE\t2S!!\u0004\b\u0002\u0007\u0011$GN\u0003\u0002\u0010!\u0005!\u0001.\u001e3j\u0015\t\t\"#A\u0002tc2T!a\u0005\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005U1\u0012AB1qC\u000eDWMC\u0001\u0018\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\u001d\u000511m\\7n_:L!a\b\u000f\u0003-!{w\u000eZ5f'B\f'o[*rYR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\u0012\u0011\u0005\r\u0002Q\"\u0001\u0007\u0002!\r\u0014X-\u0019;f)\u0016\u001cHOU3tk2$HC\u0001\u00141!\r9#\u0006L\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t)\u0011I\u001d:bsB\u0011QFL\u0007\u0002!%\u0011q\u0006\u0005\u0002\u0004%><\b\"B\u0019\u0003\u0001\u0004\u0011\u0014!\u0003;bE2,g*Y7f!\t\u0019$H\u0004\u00025qA\u0011Q\u0007K\u0007\u0002m)\u0011q\u0007G\u0001\u0007yI|w\u000e\u001e \n\u0005eB\u0013A\u0002)sK\u0012,g-\u0003\u0002<y\t11\u000b\u001e:j]\u001eT!!\u000f\u0015\u0002=\r\u0014X-\u0019;f\u0003:$\u0007K]3qCJ,\u0007+\u0019:uSRLwN\u001c+bE2,G#B C\r\u001eK\u0005CA\u0014A\u0013\t\t\u0005F\u0001\u0003V]&$\b\"B\n\u0004\u0001\u0004\u0019\u0005CA\u0017E\u0013\t)\u0005C\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u00032\u0007\u0001\u0007!\u0007C\u0003I\u0007\u0001\u0007!'A\u0005uC\ndW\rU1uQ\")!j\u0001a\u0001e\u0005IA/\u00192mKRK\b/Z\u0001\u001aO\u0016$X\t\u001f9fGR,GMU8xgN+7m\u001c8e)&lW\r\u0006\u0002N5B\u0019aj\u0015,\u000f\u0005=\u000bfBA\u001bQ\u0013\u0005I\u0013B\u0001*)\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001V+\u0003\u0007M+\u0017O\u0003\u0002SQA\u0019ajU,\u0011\u0005\u001dB\u0016BA-)\u0005\r\te.\u001f\u0005\u00067\u0012\u0001\r\u0001X\u0001\u000eM2|\u0017\r\u001e+p\t>,(\r\\3\u0011\u0005\u001dj\u0016B\u00010)\u0005\u001d\u0011un\u001c7fC:\f\u0011bZ3u\t>,(\r\\3\u0015\u0007\u0005$g\r\u0005\u0002(E&\u00111\r\u000b\u0002\u0007\t>,(\r\\3\t\u000b\u0015,\u0001\u0019\u0001\u001a\u0002\u000bY\fG.^3\t\u000b\u001d,\u0001\u0019\u0001/\u0002!\r|gN^3si\u001a\u0013x.\u001c$m_\u0006$\u0018A\u0006<bY&$\u0017\r^3J]R,'O\\1m'\u000eDW-\\1\u0015\t}RGN\u001c\u0005\u0006W\u001a\u0001\rAM\u0001\tE\u0006\u001cX\rU1uQ\")QN\u0002a\u00019\u0006a\u0011n\u001d#s_B\u001cu\u000e\\;n]\")qN\u0002a\u0001a\u0006\u00112-\u001e:sK:$X*\u0019=D_2,XN\\%e!\t9\u0013/\u0003\u0002sQ\t\u0019\u0011J\u001c;\u0002\u001d\u001d,G/T1y\u0007>dW/\u001c8JIR\u0011\u0001/\u001e\u0005\u0006W\u001e\u0001\rAM\u0001\ngB\f'o[(qiN,\u0012\u0001\u001f\t\u0007sz\f\t!!\u0001\u000e\u0003iT!a\u001f?\u0002\u0013%lW.\u001e;bE2,'BA?)\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u007fj\u00141!T1q!\u0011\t\u0019!!\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\tA\u0001\\1oO*\u0011\u00111B\u0001\u0005U\u00064\u0018-C\u0002<\u0003\u000b\t!b\u001d9be.|\u0005\u000f^:!\u0003M9W\r^,sSR,'OU3bI\u0016\u0014x\n\u001d;t)\u0019\t)\"a\b\u0002NA9q%a\u0006\u0002\u001c\u0005m\u0011bAA\rQ\t1A+\u001e9mKJ\u0002RaMA\u000feIJ!a \u001f\t\u000f\u0005\u0005\"\u00021\u0001\u0002$\u0005Q!/Z2pe\u0012$\u0016\u0010]3\u0011\t\u0005\u0015\u0012q\t\b\u0005\u0003O\t\tE\u0004\u0003\u0002*\u0005mb\u0002BA\u0016\u0003oqA!!\f\u000269!\u0011qFA\u001a\u001d\r)\u0014\u0011G\u0005\u0002/%\u0011QCF\u0005\u0003\u001fQI1!HA\u001d\u0015\tyA#\u0003\u0003\u0002>\u0005}\u0012!B7pI\u0016d'bA\u000f\u0002:%!\u00111IA#\u00031Aun\u001c3jKJ+7m\u001c:e\u0015\u0011\ti$a\u0010\n\t\u0005%\u00131\n\u0002\u0011\u0011>|G-[3SK\u000e|'\u000f\u001a+za\u0016TA!a\u0011\u0002F!9\u0011q\n\u0006A\u0002\u0005m\u0011aA8qi\u0002")
public class TestSpark3DDL
extends HoodieSparkSqlTestBase {
    private final scala.collection.immutable.Map<String, String> sparkOpts;

    public Row[] createTestResult(String tableName) {
        return (Row[])this.spark().sql(new StringBuilder(26).append("select * from ").append(tableName).append(" order by id").toString()).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_commit_time", "_hoodie_commit_seqno", "_hoodie_record_key", "_hoodie_partition_path", "_hoodie_file_name"})).collect();
    }

    public void createAndPreparePartitionTable(SparkSession spark, String tableName, String tablePath, String tableType) {
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(417).append("\n         |create table ").append(tableName).append(" (\n         |  id int, comb int, col0 int, col1 bigint, col2 float, col3 double, col4 decimal(10,4), col5 string, col6 date, col7 timestamp, col8 boolean, col9 binary, par date\n         |) using hudi\n         | location '").append(tablePath).append("'\n         | options (\n         |  type = '").append(tableType).append("',\n         |  primaryKey = 'id',\n         |  preCombineField = 'comb'\n         | )\n         | partitioned by (par)\n             ").toString())).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(788).append("\n         | insert into ").append(tableName).append(" values\n         | (1,1,11,100001,101.01,1001.0001,100001.0001,'a000001',DATE'2021-12-25',TIMESTAMP'2021-12-25 12:01:01',true,X'a01',TIMESTAMP'2021-12-25'),\n         | (2,2,12,100002,102.02,1002.0002,100002.0002,'a000002',DATE'2021-12-25',TIMESTAMP'2021-12-25 12:02:02',true,X'a02',TIMESTAMP'2021-12-25'),\n         | (3,3,13,100003,103.03,1003.0003,100003.0003,'a000003',DATE'2021-12-25',TIMESTAMP'2021-12-25 12:03:03',false,X'a03',TIMESTAMP'2021-12-25'),\n         | (4,4,14,100004,104.04,1004.0004,100004.0004,'a000004',DATE'2021-12-26',TIMESTAMP'2021-12-26 12:04:04',true,X'a04',TIMESTAMP'2021-12-26'),\n         | (5,5,15,100005,105.05,1005.0005,100005.0005,'a000005',DATE'2021-12-26',TIMESTAMP'2021-12-26 12:05:05',false,X'a05',TIMESTAMP'2021-12-26')\n         |").toString())).stripMargin());
    }

    private Seq<Seq<Object>> getExpectedRowsSecondTime(boolean floatToDouble) {
        return (Seq)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)100001L), "101.01", BoxesRunTime.boxToDouble((double)1001.0001), new BigDecimal("100001.00010000"), "a000001", Date.valueOf("2021-12-25"), Timestamp.valueOf("2021-12-25 12:01:01"), BoxesRunTime.boxToBoolean((boolean)true), Date.valueOf("2021-12-25")}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToLong((long)100002L), Double.toString(this.getDouble("102.02", floatToDouble)), BoxesRunTime.boxToDouble((double)1002.0002), new BigDecimal("100002.00020000"), "a000002", Date.valueOf("2021-12-25"), Timestamp.valueOf("2021-12-25 12:02:02"), BoxesRunTime.boxToBoolean((boolean)true), Date.valueOf("2021-12-25")}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)13), BoxesRunTime.boxToLong((long)100003L), Double.toString(this.getDouble("103.03", floatToDouble)), BoxesRunTime.boxToDouble((double)1003.0003), new BigDecimal("100003.00030000"), "a000003", Date.valueOf("2021-12-25"), Timestamp.valueOf("2021-12-25 12:03:03"), BoxesRunTime.boxToBoolean((boolean)false), Date.valueOf("2021-12-25")}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), null, BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)14), BoxesRunTime.boxToLong((long)100004L), "104.04", BoxesRunTime.boxToDouble((double)1004.0004), new BigDecimal("100004.00040000"), "a000004", Date.valueOf("2021-12-26"), Timestamp.valueOf("2021-12-26 12:04:04"), BoxesRunTime.boxToBoolean((boolean)true), Date.valueOf("2021-12-26")}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)15), BoxesRunTime.boxToLong((long)100005L), "105.05", BoxesRunTime.boxToDouble((double)1005.0005), new BigDecimal("100005.00050000"), "a000005", Date.valueOf("2021-12-26"), Timestamp.valueOf("2021-12-26 12:05:05"), BoxesRunTime.boxToBoolean((boolean)false), Date.valueOf("2021-12-26")}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)15), BoxesRunTime.boxToLong((long)100005L), "105.05", BoxesRunTime.boxToDouble((double)1005.0005), new BigDecimal("100005.00050000"), "a000005", Date.valueOf("2021-12-26"), Timestamp.valueOf("2021-12-26 12:05:05"), BoxesRunTime.boxToBoolean((boolean)false), Date.valueOf("2021-12-26")}))), (List)Nil$.MODULE$))))));
    }

    private double getDouble(String value, boolean convertFromFloat) {
        if (convertFromFloat) {
            return new StringOps(Predef$.MODULE$.augmentString(value)).toFloat();
        }
        return new StringOps(Predef$.MODULE$.augmentString(value)).toDouble();
    }

    public void validateInternalSchema(String basePath, boolean isDropColumn, int currentMaxColumnId) {
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)basePath);
        InternalSchema schema = (InternalSchema)new TableSchemaResolver(metaClient).getTableInternalSchemaFromCommitMetadata().get();
        HoodieInstant lastInstant = (HoodieInstant)metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().get();
        long $org_scalatest_assert_macro_left = schema.schemaId();
        long $org_scalatest_assert_macro_right = new StringOps(Predef$.MODULE$.augmentString(lastInstant.requestedTime())).toLong();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
        if (isDropColumn) {
            int $org_scalatest_assert_macro_left2 = schema.getMaxColumnId();
            int $org_scalatest_assert_macro_right2 = currentMaxColumnId;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 581));
            return;
        }
        int $org_scalatest_assert_macro_left3 = schema.getMaxColumnId();
        int $org_scalatest_assert_macro_right3 = currentMaxColumnId + 1;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583));
    }

    public int getMaxColumnId(String basePath) {
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)basePath);
        return ((InternalSchema)new TableSchemaResolver(metaClient).getTableInternalSchemaFromCommitMetadata().get()).getMaxColumnId();
    }

    public scala.collection.immutable.Map<String, String> sparkOpts() {
        return this.sparkOpts;
    }

    public Tuple2<scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>> getWriterReaderOpts(HoodieRecord.HoodieRecordType recordType, scala.collection.immutable.Map<String, String> opt) {
        HoodieRecord.HoodieRecordType hoodieRecordType = recordType;
        if (HoodieRecord.HoodieRecordType.SPARK.equals(hoodieRecordType)) {
            return new Tuple2((Object)opt.$plus$plus(this.sparkOpts()), this.sparkOpts());
        }
        return new Tuple2(opt, (Object)Predef$.MODULE$.Map().empty());
    }

    public static final /* synthetic */ void $anonfun$new$4(TestSpark3DDL $this, File tmp$1, String tableType) {
        String tableName = $this.generateTableName();
        String tablePath = String.valueOf(new Path(tmp$1.getCanonicalPath(), tableName).toUri().toString());
        $this.spark().sql(new StringBuilder(11).append("set ").append(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key()).append("=upsert").toString());
        $this.spark().sql("set hoodie.schema.on.read.enable=true");
        $this.spark().sql("set hoodie.metadata.index.column.stats.enable=false");
        $this.spark().sql("set spark.sql.storeAssignmentPolicy=legacy");
        $this.createAndPreparePartitionTable($this.spark(), tableName, tablePath, tableType);
        $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col6 type String").toString());
        $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(30).append("select col6 from ").append(tableName).append(" where id = 1").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"2021-12-25", (List)Nil$.MODULE$)}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(181).append("\n             | insert into ").append(tableName).append(" values\n             | (1,1,13.0,100001,101.01,1001.0001,100001.0001,'a000001','2021-12-26','2021-12-25 12:01:01',true,'a01','2021-12-25')\n             |").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(40).append("alter table ").append(tableName).append(" alter column col6 type date").toString());
        $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(52).append("select col6 from ").append(tableName).append(" where id = 1 or id = 5 order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)Date.valueOf("2021-12-26"), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)Date.valueOf("2021-12-26"), (List)Nil$.MODULE$)}));
        $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col0 type double").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(313).append("\n             | insert into ").append(tableName).append(" values\n             | (1,1,13.0,100001,101.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n             | (6,1,14.0,100001,101.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25')\n             |").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col0 type decimal(16, 4)").toString());
        $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(52).append("select col0 from ").append(tableName).append(" where id = 1 or id = 6 order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new BigDecimal("13.0000"), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new BigDecimal("14.0000"), (List)Nil$.MODULE$)}));
        $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col2 type double").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(313).append("\n             | insert into ").append(tableName).append(" values\n             | (1,1,13.0,100001,901.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n             | (6,1,14.0,100001,601.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25')\n             |").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col2 type decimal(16, 4)").toString());
        $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(58).append("select col0, col2 from ").append(tableName).append(" where id = 1 or id = 6 order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new BigDecimal("13.0000"), (List)new .colon.colon((Object)new BigDecimal("901.0100"), (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)new BigDecimal("14.0000"), (List)new .colon.colon((Object)new BigDecimal("601.0100"), (List)Nil$.MODULE$))}));
        $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col1 type double").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(183).append("\n             | insert into ").append(tableName).append(" values\n             | (1,1,13.0,700001.0,901.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25')\n             |").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col1 type decimal(16, 4)").toString());
        $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(64).append("select col0, col2, col1 from ").append(tableName).append(" where id = 1 or id = 6 order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new BigDecimal("13.0000"), (List)new .colon.colon((Object)new BigDecimal("901.0100"), (List)new .colon.colon((Object)new BigDecimal("700001.0000"), (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)new BigDecimal("14.0000"), (List)new .colon.colon((Object)new BigDecimal("601.0100"), (List)new .colon.colon((Object)new BigDecimal("100001.0000"), (List)Nil$.MODULE$)))}));
        $this.spark().sessionState().catalog().dropTable(TableIdentifier$.MODULE$.apply(tableName), true, true);
        $this.spark().sessionState().catalog().refreshTable(TableIdentifier$.MODULE$.apply(tableName));
        $this.spark().sessionState().conf().unsetConf(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key());
        $this.spark().sessionState().conf().unsetConf("spark.sql.storeAssignmentPolicy");
    }

    public static final /* synthetic */ void $anonfun$new$3(TestSpark3DDL $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$4($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
        $this.spark().sessionState().conf().unsetConf("unset hoodie.metadata.index.column.stats.enable");
    }

    public static final /* synthetic */ void $anonfun$new$7(TestSpark3DDL $this, File tmp$2, String tableType) {
        String tableName = $this.generateTableName();
        String tablePath = String.valueOf(new Path(tmp$2.getCanonicalPath(), tableName).toUri().toString());
        $this.spark().sql("set hoodie.schema.on.read.enable=true");
        $this.spark().sql("set spark.sql.storeAssignmentPolicy=legacy");
        $this.createAndPreparePartitionTable($this.spark(), tableName, tablePath, tableType);
        $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col2 type double").toString());
        $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col2 type decimal(16, 4)").toString());
        $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col2 type String").toString());
        $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(30).append("select col2 from ").append(tableName).append(" where id = 1").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"101.01", (List)Nil$.MODULE$)}));
        $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col1 type double").toString());
        $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col1 type decimal(16, 4)").toString());
        $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col1 type String").toString());
        $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(30).append("select col1 from ").append(tableName).append(" where id = 1").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"100001", (List)Nil$.MODULE$)}));
        $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col0 type double").toString());
        $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col0 type decimal(16, 4)").toString());
        $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col0 type String").toString());
        $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(30).append("select col0 from ").append(tableName).append(" where id = 1").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"11", (List)Nil$.MODULE$)}));
        $this.spark().sessionState().conf().unsetConf("spark.sql.storeAssignmentPolicy");
    }

    public static final /* synthetic */ void $anonfun$new$6(TestSpark3DDL $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$7($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$10(TestSpark3DDL $this, File tmp$3, String tableType) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$3.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql("set hoodie.schema.on.read.enable=true");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(348).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(40).append("alter table ").append(tableName).append(" add columns(new_col string)").toString());
        CatalogTable catalogTable = $this.spark().sessionState().catalog().getTableMetadata(new TableIdentifier(tableName));
        $this.assertResult(new .colon.colon((Object)"id", (List)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"price", (List)new .colon.colon((Object)"ts", (List)new .colon.colon((Object)"new_col", (List)Nil$.MODULE$))))), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])HoodieSqlCommonUtils$.MODULE$.removeMetaFields(catalogTable.schema()).fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        $this.checkAnswer(new StringBuilder(41).append("select id, name, price, ts, new_col from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null}))}));
        $this.spark().sql("set hoodie.schema.on.read.enable=false");
        $this.spark().sql(new StringBuilder(14).append("refresh table ").append(tableName).toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(2, 'a2', 12, 2000, 'e0')").toString());
        $this.checkAnswer(new StringBuilder(41).append("select id, name, price, ts, new_col from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)2000), "e0"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$9(TestSpark3DDL $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$10($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$16(CatalogTable meta$1, String x$2) {
        return meta$1.properties().contains((Object)x$2);
    }

    public static final /* synthetic */ boolean $anonfun$new$17(CatalogTable unsetMeta$1, String x$3) {
        return unsetMeta$1.properties().contains((Object)x$3);
    }

    public static final /* synthetic */ void $anonfun$new$19(TestSpark3DDL $this, String tableName$1, String col) {
        $this.checkException(new StringBuilder(25).append("alter table ").append(tableName$1).append(" drop column ").append(col).toString(), "cannot support apply changes for primaryKey/CombineKey/partitionKey");
        $this.checkException(new StringBuilder(31).append("alter table ").append(tableName$1).append(" rename column ").append(col).append(" to ").append(col).append(col).toString(), "cannot support apply changes for primaryKey/CombineKey/partitionKey");
    }

    public static final /* synthetic */ boolean $anonfun$new$20(StructField p) {
        return p.name().equals("col1_new");
    }

    public static final /* synthetic */ boolean $anonfun$new$21(StructField p) {
        return p.name().equals("col9");
    }

    public static final /* synthetic */ void $anonfun$new$14(TestSpark3DDL $this, File tmp$4, String args) {
        BoxedUnit boxedUnit;
        Object object;
        String[] argArray = new StringOps(Predef$.MODULE$.augmentString(args)).split(',');
        String tableType = argArray[0];
        boolean runCompaction = "compaction".equals(argArray[1]);
        boolean runClustering = "clustering".equals(argArray[1]);
        boolean isMor = "mor".equals(tableType);
        Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(runCompaction, "runCompaction", Prettifier$.MODULE$.default());
        Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(runClustering, "runClustering", Prettifier$.MODULE$.default());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "||", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bar$bar((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        String tableName = $this.generateTableName();
        String tablePath = String.valueOf(new Path(tmp$4.getCanonicalPath(), tableName).toUri().toString());
        $this.spark().sql("set hoodie.compact.inline=false");
        $this.spark().sql("set hoodie.compact.schedule.inline=false");
        $this.spark().sql("set hoodie.schema.on.read.enable=true");
        $this.spark().sql("set hoodie.metadata.index.column.stats.enable=false");
        $this.spark().sql(new StringBuilder(11).append("set ").append(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key()).append("=upsert").toString());
        $this.spark().sql("set spark.sql.storeAssignmentPolicy=legacy");
        $this.createAndPreparePartitionTable($this.spark(), tableName, tablePath, tableType);
        $this.spark().sql(new StringBuilder(94).append("alter table ").append(tableName).append(" set tblproperties(comment='it is a hudi table', 'key1'='value1', 'key2'='value2')").toString());
        CatalogTable meta = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((String)meta.comment().get()).equals("it is a hudi table"), "meta.comment.get.equals(\"it is a hudi table\")", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        Seq $org_scalatest_assert_macro_left2 = (Seq)((TraversableLike)new .colon.colon((Object)"key1", (List)new .colon.colon((Object)"key2", (List)Nil$.MODULE$))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestSpark3DDL.$anonfun$new$16(meta, x$2)));
        int $org_scalatest_assert_macro_right2 = 2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        $this.spark().sql(new StringBuilder(57).append("alter table ").append(tableName).append(" unset tblproperties(comment, 'key1', 'key2')").toString());
        CatalogTable unsetMeta = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName));
        Seq $org_scalatest_assert_macro_left3 = (Seq)((TraversableLike)new .colon.colon((Object)"key1", (List)new .colon.colon((Object)"key2", (List)Nil$.MODULE$))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TestSpark3DDL.$anonfun$new$17(unsetMeta, x$3)));
        int $org_scalatest_assert_macro_right3 = 0;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        Option $org_scalatest_assert_macro_left4 = unsetMeta.comment();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        $this.checkException(new StringBuilder(44).append("Alter table ").append(tableName).append(" add columns(col_new1 int first)").toString(), "forbid adjust top-level columns position by using through first syntax");
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS.subList(0, HoodieRecord.HOODIE_META_COLUMNS.size() - 2)).asScala()).foreach((Function1 & Serializable & scala.Serializable)f -> {
            $this.checkException(new StringBuilder(45).append("Alter table ").append(tableName).append(" add columns(col_new1 int after ").append(f).append(")").toString(), "forbid adjust the position of ordinary columns between meta columns");
            return BoxedUnit.UNIT;
        });
        ((IterableLike)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"comb", (List)new .colon.colon((Object)"par", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)col -> {
            TestSpark3DDL.$anonfun$new$19($this, tableName, col);
            return BoxedUnit.UNIT;
        });
        $this.checkExceptions(new StringBuilder(39).append("alter table ").append(tableName).append(" rename column col0 to col9").toString(), (Seq<String>)((Seq)new .colon.colon((Object)"cannot rename column: col0 to a existing name", (List)new .colon.colon((Object)"Cannot rename column, because col9 already exists in root", (List)Nil$.MODULE$))));
        $this.checkExceptions(new StringBuilder(39).append("alter table ").append(tableName).append(" rename column col0 to COL9").toString(), (Seq<String>)((Seq)new .colon.colon((Object)"cannot rename column: col0 to a existing name", (List)new .colon.colon((Object)"Cannot rename column, because COL9 already exists in root", (List)Nil$.MODULE$))));
        $this.checkExceptions(new StringBuilder(40).append("alter table ").append(tableName).append(" add columns(col9 int first)").toString(), (Seq<String>)((Seq)new .colon.colon((Object)"cannot add column: col9 which already exist", (List)new .colon.colon((Object)"Cannot add column, because col9 already exists in root", (List)Nil$.MODULE$))));
        $this.checkExceptions(new StringBuilder(40).append("alter table ").append(tableName).append(" add columns(COL9 int first)").toString(), (Seq<String>)((Seq)new .colon.colon((Object)"cannot add column: COL9 which already exist", (List)new .colon.colon((Object)"Cannot add column, because COL9 already exists in root", (List)Nil$.MODULE$))));
        $this.spark().sql(new StringBuilder(91).append("alter table ").append(tableName).append(" add columns(col1_new int comment 'add new columns col1_new after id' after id)").toString());
        $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col9 comment 'col9 desc'").toString());
        StructType schema = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName)).schema();
        String $org_scalatest_assert_macro_left5 = (String)((StructField)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)schema.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestSpark3DDL.$anonfun$new$20(p)))).asJava()).get(0)).getComment().get();
        String $org_scalatest_assert_macro_right4 = "add new columns col1_new after id";
        String string = $org_scalatest_assert_macro_left5;
        String string2 = $org_scalatest_assert_macro_right4;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
        String $org_scalatest_assert_macro_left6 = (String)((StructField)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)schema.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestSpark3DDL.$anonfun$new$21(p)))).asJava()).get(0)).getComment().get();
        String $org_scalatest_assert_macro_right5 = "col9 desc";
        String string3 = $org_scalatest_assert_macro_left6;
        String string4 = $org_scalatest_assert_macro_right5;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
        $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col2 type double").toString());
        $this.checkAnswer(new StringBuilder(66).append("select id, col1_new, col2 from ").append(tableName).append(" where id = 1 or id = 2 order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToDouble((double)$this.getDouble("101.01", isMor))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToDouble((double)$this.getDouble("102.02", isMor))}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(314).append("\n             | insert into ").append(tableName).append(" values\n             | (1,3,1,11,100001,101.01,1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n             | (6,6,5,15,100005,105.05,1005.0005,100005.0005,'a000005','2021-12-26','2021-12-26 12:05:05',false,'a05','2021-12-26')\n             |").toString())).stripMargin());
        Seq allExpectedRows = (Seq)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)100001L), BoxesRunTime.boxToDouble((double)101.01), BoxesRunTime.boxToDouble((double)1001.0001), new BigDecimal("100001.0001"), "a000001", Date.valueOf("2021-12-25"), Timestamp.valueOf("2021-12-25 12:01:01"), BoxesRunTime.boxToBoolean((boolean)true), Date.valueOf("2021-12-25")}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToLong((long)100002L), BoxesRunTime.boxToDouble((double)$this.getDouble("102.02", isMor)), BoxesRunTime.boxToDouble((double)1002.0002), new BigDecimal("100002.0002"), "a000002", Date.valueOf("2021-12-25"), Timestamp.valueOf("2021-12-25 12:02:02"), BoxesRunTime.boxToBoolean((boolean)true), Date.valueOf("2021-12-25")}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)13), BoxesRunTime.boxToLong((long)100003L), BoxesRunTime.boxToDouble((double)$this.getDouble("103.03", isMor)), BoxesRunTime.boxToDouble((double)1003.0003), new BigDecimal("100003.0003"), "a000003", Date.valueOf("2021-12-25"), Timestamp.valueOf("2021-12-25 12:03:03"), BoxesRunTime.boxToBoolean((boolean)false), Date.valueOf("2021-12-25")}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), null, BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)14), BoxesRunTime.boxToLong((long)100004L), BoxesRunTime.boxToDouble((double)104.04), BoxesRunTime.boxToDouble((double)1004.0004), new BigDecimal("100004.0004"), "a000004", Date.valueOf("2021-12-26"), Timestamp.valueOf("2021-12-26 12:04:04"), BoxesRunTime.boxToBoolean((boolean)true), Date.valueOf("2021-12-26")}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), null, BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)15), BoxesRunTime.boxToLong((long)100005L), BoxesRunTime.boxToDouble((double)105.05), BoxesRunTime.boxToDouble((double)1005.0005), new BigDecimal("100005.0005"), "a000005", Date.valueOf("2021-12-26"), Timestamp.valueOf("2021-12-26 12:05:05"), BoxesRunTime.boxToBoolean((boolean)false), Date.valueOf("2021-12-26")}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)15), BoxesRunTime.boxToLong((long)100005L), BoxesRunTime.boxToDouble((double)105.05), BoxesRunTime.boxToDouble((double)1005.0005), new BigDecimal("100005.0005"), "a000005", Date.valueOf("2021-12-26"), Timestamp.valueOf("2021-12-26 12:05:05"), BoxesRunTime.boxToBoolean((boolean)false), Date.valueOf("2021-12-26")}))), (List)Nil$.MODULE$))))));
        $this.checkAnswer(new StringBuilder(90).append("select id, col1_new, comb, col0, col1, col2, col3, col4, col5, ").append("col6, col7, col8, par from ").append(tableName).toString(), (Seq<Seq<Object>>)allExpectedRows);
        if (runCompaction) {
            String string5 = tableType;
            String string6 = "mor";
            object = !(string5 != null ? !string5.equals(string6) : string6 != null) ? $this.spark().sql(new StringBuilder(23).append("schedule compaction on ").append(tableName).toString()) : BoxedUnit.UNIT;
        } else if (runClustering) {
            Assertions.assertEquals((long)0L, (long)$this.spark().sql(new StringBuilder(24).append("CALL show_clustering('").append(tableName).append("')").toString()).count());
            $this.spark().sql(new StringBuilder(50).append("CALL run_clustering(table => '").append(tableName).append("', op => 'schedule')").toString());
            $this.spark().sql(new StringBuilder(49).append("CALL run_clustering(table => '").append(tableName).append("', op => 'execute')").toString());
            Row[] clusteringRows = (Row[])$this.spark().sql(new StringBuilder(24).append("CALL show_clustering('").append(tableName).append("')").toString()).collect();
            $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)clusteringRows.length), Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            String[] states = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clusteringRows)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getString(2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            object = $this.assertResult(HoodieInstant.State.COMPLETED.name(), states[0], Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        } else {
            object = BoxedUnit.UNIT;
        }
        $this.checkAnswer(new StringBuilder(90).append("select id, col1_new, comb, col0, col1, col2, col3, col4, col5, ").append("col6, col7, col8, par from ").append(tableName).toString(), (Seq<Seq<Object>>)allExpectedRows);
        $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column col4 type decimal(18, 8)").toString());
        $this.checkAnswer(new StringBuilder(90).append("select id, col1_new, comb, col0, col1, col2, col3, col4, col5, ").append("col6, col7, col8, par from ").append(tableName).toString(), (Seq<Seq<Object>>)allExpectedRows);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(182).append("\n             | insert into ").append(tableName).append(" values\n             | (5,6,5,15,100005,105.05,1005.0005,100005.0005,'a000005','2021-12-26','2021-12-26 12:05:05',false,'a05','2021-12-26')\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(76).append("select id, col1_new, col4 from ").append(tableName).append(" ").append("where id = 1 or id = 6 or id = 2 order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), new BigDecimal("100001.00010000")})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, new BigDecimal("100002.00020000")})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)6), new BigDecimal("100005.00050000")}))}));
        $this.spark().sql(new StringBuilder(42).append("alter table ").append(tableName).append(" alter column col2 type string").toString());
        $this.checkAnswer(new StringBuilder(66).append("select id, col1_new, col2 from ").append(tableName).append(" where id = 1 or id = 2 order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), "101.01"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, Double.toString($this.getDouble("102.02", isMor && runClustering))}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(318).append("\n             | insert into ").append(tableName).append(" values\n             | (1,3,1,11,100001,'101.01',1001.0001,100001.0001,'a000001','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n             | (6,6,5,15,100005,'105.05',1005.0005,100005.0005,'a000005','2021-12-26','2021-12-26 12:05:05',false,'a05','2021-12-26')\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(90).append("select id, col1_new, comb, col0, col1, col2, col3, col4, col5, ").append("col6, col7, col8, par from ").append(tableName).toString(), $this.getExpectedRowsSecondTime(isMor && runClustering));
        if (runCompaction) {
            String string7 = tableType;
            String string8 = "mor";
            Object object2 = !(string7 != null ? !string7.equals(string8) : string8 != null) ? $this.spark().sql(new StringBuilder(24).append("schedule compaction  on ").append(tableName).toString()) : BoxedUnit.UNIT;
            String string9 = tableType;
            String string10 = "mor";
            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                Row[] compactionRows = (Row[])$this.spark().sql(new StringBuilder(28).append("show compaction on ").append(tableName).append(" limit 10").toString()).collect();
                String[] timestamps = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compactionRows)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)timestamps.length), Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
                $this.spark().sql(new StringBuilder(22).append("run compaction on ").append(tableName).append(" at ").append(timestamps[1]).toString());
                boxedUnit = $this.spark().sql(new StringBuilder(22).append("run compaction on ").append(tableName).append(" at ").append(timestamps[0]).toString());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (runClustering) {
            $this.spark().sql(new StringBuilder(50).append("CALL run_clustering(table => '").append(tableName).append("', op => 'schedule')").toString());
            $this.spark().sql(new StringBuilder(49).append("CALL run_clustering(table => '").append(tableName).append("', op => 'execute')").toString());
            Row[] clusteringRows = (Row[])$this.spark().sql(new StringBuilder(24).append("CALL show_clustering('").append(tableName).append("')").toString()).collect();
            $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)clusteringRows.length), Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
            String[] states = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clusteringRows)).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getString(2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            $this.assertResult(HoodieInstant.State.COMPLETED.name(), states[0], Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
            boxedUnit = $this.assertResult(HoodieInstant.State.COMPLETED.name(), states[1], Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        $this.checkAnswer(new StringBuilder(90).append("select id, col1_new, comb, col0, col1, col2, col3, col4, col5, ").append("col6, col7, col8, par from ").append(tableName).toString(), $this.getExpectedRowsSecondTime(isMor));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(453).append("\n             | insert into ").append(tableName).append(" values\n             | (1,3,1,11,100001,'101.01',1001.0001,100009.0001,'a000008','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n             | (11,3,1,11,100001,'101.01',1001.0001,100011.0001,'a000008','2021-12-25','2021-12-25 12:01:01',true,'a01','2021-12-25'),\n             | (6,6,5,15,100005,'105.05',1005.0005,100007.0005,'a000009','2021-12-26','2021-12-26 12:05:05',false,'a05','2021-12-26')\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(87).append("select id, col1_new, col2 from ").append(tableName).append(" ").append("where id = 1 or id = 6 or id = 2 or id = 11 order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), "101.01"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)3), "101.01"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, Double.toString($this.getDouble("102.02", isMor))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)6), "105.05"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$13(TestSpark3DDL $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow,clustering", (List)new .colon.colon((Object)"mor,compaction", (List)new .colon.colon((Object)"mor,clustering", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)args -> {
            TestSpark3DDL.$anonfun$new$14($this, tmp, args);
            return BoxedUnit.UNIT;
        });
        $this.spark().sessionState().conf().unsetConf("spark.sql.storeAssignmentPolicy");
        $this.spark().sessionState().conf().unsetConf(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key());
        $this.spark().sessionState().conf().unsetConf("unset hoodie.metadata.index.column.stats.enable");
    }

    public static final /* synthetic */ void $anonfun$new$28(TestSpark3DDL $this, File tmp$5, String tableType) {
        String tableName = $this.generateTableName();
        String tablePath = String.valueOf(new Path(tmp$5.getCanonicalPath(), tableName).toUri().toString());
        $this.spark().sql("set hoodie.schema.on.read.enable=true");
        $this.spark().sql(new StringBuilder(11).append("set ").append(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key()).append("=upsert").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(398).append("\n             |create table ").append(tableName).append(" (\n             |  id int, comb int, `\u540d\u5b57` string, col9 string, `\u6210\u7ee9` int, `\u8eab\u9ad8` float, `\u4f53\u91cd` double, `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` date, par date\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | options (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'comb'\n             | )\n             | partitioned by (par)\n             ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(139).append("\n             | insert into ").append(tableName).append(" values\n             | (1,3,'\u674e\u660e', '\u8bfb\u4e66', 100,180.0001,99.0001,DATE'2021-12-25', DATE'2021-12-26')\n             |").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(44).append("alter table ").append(tableName).append(" rename column col9 to `\u7231\u597d_Best`").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(139).append("\n             | insert into ").append(tableName).append(" values\n             | (1,3,'\u674e\u660e', '\u8bfb\u4e66', 100,180.0001,99.0001,DATE'2021-12-26', DATE'2021-12-26')\n             |").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(47).append("alter table ").append(tableName).append(" alter column `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` type string ").toString());
        $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(21).append("select `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` from ").append(tableName).toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"2021-12-26", (List)Nil$.MODULE$)}));
        $this.spark().sql(new StringBuilder(45).append("alter table ").append(tableName).append(" alter column `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` type date ").toString());
        $this.spark().sql(new StringBuilder(21).append("select `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` from ").append(tableName).toString()).collect();
        $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(21).append("select `\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4` from ").append(tableName).toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)Date.valueOf("2021-12-26"), (List)Nil$.MODULE$)}));
    }

    public static final /* synthetic */ void $anonfun$new$27(TestSpark3DDL $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$28($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
        $this.spark().sessionState().conf().unsetConf(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key());
    }

    public static final /* synthetic */ void $anonfun$new$31(TestSpark3DDL $this, File tmp$6, String tableType) {
        String tableName = $this.generateTableName();
        String tablePath = String.valueOf(new Path(tmp$6.getCanonicalPath(), tableName).toUri().toString());
        $this.spark().sql("set hoodie.schema.on.read.enable=true");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(348).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | options (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(18).append("show create table ").append(tableName).toString()).show(false);
        $this.spark().sql(new StringBuilder(42).append("insert into ").append(tableName).append(" values (1, 'jack', 0.9, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("update ").append(tableName).append(" set price = 1.9  where id =  1").toString());
        $this.spark().sql(new StringBuilder(38).append("alter table ").append(tableName).append(" alter column id type long").toString());
        $this.checkAnswer($this.createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", BoxesRunTime.boxToDouble((double)1.9), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(67).append("alter table ").append(tableName).append(" add columns(ext1 string comment 'add ext1' after name)").toString());
        $this.spark().sql(new StringBuilder(50).append("insert into ").append(tableName).append(" values (2, 'jack', 'exx1', 0.9, 1000)").toString());
        $this.checkAnswer($this.createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", null, BoxesRunTime.boxToDouble((double)1.9), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "jack", "exx1", BoxesRunTime.boxToDouble((double)0.9), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(44).append("alter table ").append(tableName).append(" rename column price to newprice").toString());
        $this.checkAnswer($this.createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", null, BoxesRunTime.boxToDouble((double)1.9), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "jack", "exx1", BoxesRunTime.boxToDouble((double)0.9), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(41).append("update ").append(tableName).append(" set ext1 =  'haha' where id =  1 ").toString());
        $this.checkAnswer($this.createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", "haha", BoxesRunTime.boxToDouble((double)1.9), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "jack", "exx1", BoxesRunTime.boxToDouble((double)0.9), BoxesRunTime.boxToInteger((int)1000)}))}));
        int maxColumnId = $this.getMaxColumnId(tablePath);
        $this.spark().sql(new StringBuilder(33).append("alter table ").append(tableName).append(" drop column newprice").toString());
        $this.checkAnswer($this.createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", "haha", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "jack", "exx1", BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.validateInternalSchema(tablePath, true, maxColumnId);
        maxColumnId = $this.getMaxColumnId(tablePath);
        $this.spark().sql(new StringBuilder(80).append("alter table ").append(tableName).append(" add columns(newprice string comment 'add newprice back' after ext1)").toString());
        $this.checkAnswer($this.createTestResult(tableName), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "jack", "haha", null, BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "jack", "exx1", null, BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.validateInternalSchema(tablePath, false, maxColumnId);
    }

    public static final /* synthetic */ void $anonfun$new$30(TestSpark3DDL $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$31($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$34(TestSpark3DDL $this, File tmp$7, String tableType) {
        String tableName = $this.generateTableName();
        String tablePath = String.valueOf(new Path(tmp$7.getCanonicalPath(), tableName).toUri().toString());
        $this.spark().sql("set hoodie.schema.on.read.enable=true");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(327).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string not null,\n             |  ts long\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | options (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(44).append("alter table ").append(tableName).append(" alter column name drop not null").toString());
        $this.spark().sql(new StringBuilder(34).append("insert into ").append(tableName).append(" values(1, null, 1000)").toString());
        $this.checkAnswer(new StringBuilder(25).append("select id, name, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$33(TestSpark3DDL $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$34($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$37(TestSpark3DDL $this, File tmp$8, String tableType) {
        String tableName = $this.generateTableName();
        String tablePath = String.valueOf(new Path(tmp$8.getCanonicalPath(), tableName).toUri().toString());
        $this.spark().sql("set hoodie.schema.on.read.enable=true");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(347).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  col1 string,\n             |  col2 string,\n             |  ts long\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | options (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(18).append("show create table ").append(tableName).toString()).show(false);
        $this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values (1, 'aaa', 'bbb', 1000)").toString());
        $this.spark().sql(new StringBuilder(29).append("alter table ").append(tableName).append(" drop column col1").toString());
        $this.spark().sql(new StringBuilder(39).append("alter table ").append(tableName).append(" rename column col2 to col1").toString());
        $this.spark().sql(new StringBuilder(36).append("insert into ").append(tableName).append(" values (2, 'aaa', 1000)").toString());
        $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(29).append("select col1 from ").append(tableName).append(" order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"bbb", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"aaa", (List)Nil$.MODULE$)}));
    }

    public static final /* synthetic */ void $anonfun$new$36(TestSpark3DDL $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$37($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$44(TestSpark3DDL $this, File tmp$10, String tableType) {
        String tableName = $this.generateTableName();
        String tablePath = String.valueOf(new Path(tmp$10.getCanonicalPath(), tableName).toUri().toString());
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
        String schema = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
        List records1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInsertsAsPerSchema("001", Predef$.MODULE$.int2Integer(1000), schema))).asScala()).toList();
        Dataset inputDF1 = $this.spark().read().json($this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        Dataset orgStringDf = inputDF1.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"city_to_state", "distance_in_meters", "drivers"})).withColumn("tip_history", functions$.MODULE$.arrays_zip((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("tip_history.currency")})));
        $this.spark().sql("set hoodie.schema.on.read.enable=true");
        scala.collection.immutable.Map hudiOptions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TABLE_NAME), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE_OPT_KEY()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD_OPT_KEY()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD_OPT_KEY()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD_OPT_KEY()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.schema.on.read.enable"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING_OPT_KEY()), (Object)"true")}));
        Tuple2<scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>> tuple2 = $this.getWriterReaderOpts(HoodieRecord.HoodieRecordType.SPARK, (scala.collection.immutable.Map<String, String>)hudiOptions);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map writeOpt = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map readOpt = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeOpt, (Object)readOpt);
        scala.collection.immutable.Map writeOpt2 = (scala.collection.immutable.Map)tuple22._1();
        scala.collection.immutable.Map readOpt2 = (scala.collection.immutable.Map)tuple22._2();
        orgStringDf.write().format("org.apache.hudi").option(DataSourceWriteOptions$.MODULE$.OPERATION_OPT_KEY(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).options((Map)writeOpt2).mode(SaveMode.Overwrite).save(tablePath);
        Dataset oldView = $this.spark().read().format("hudi").options((Map)readOpt2).option(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key(), "false").load(tablePath);
        oldView.show(5, false);
        List records2 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUpdatesAsPerSchema("002", Predef$.MODULE$.int2Integer(100), schema))).asScala()).toList();
        Dataset inputD2 = $this.spark().read().json($this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        Dataset updatedStringDf = inputD2.drop("fare").drop("height");
        String checkRowKey = (String)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(inputD2.select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collectAsList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getString(0), Buffer$.MODULE$.canBuildFrom())).head();
        updatedStringDf.write().format("org.apache.hudi").options((Map)writeOpt2).option(DataSourceWriteOptions$.MODULE$.OPERATION_OPT_KEY(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option("hoodie.datasource.write.reconcile.schema", "true").mode(SaveMode.Append).save(tablePath);
        $this.spark().read().format("hudi").options((Map)readOpt2).option(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key(), "false").load(tablePath).registerTempTable("newView");
        Tuple5[] checkResult = (Tuple5[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(102).append("select tip_history.amount,city_to_state,distance_in_meters,fare,height from newView where _row_key='").append(checkRowKey).append("' ").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> new Tuple5((Object)BoxesRunTime.boxToBoolean((boolean)row.isNullAt(0)), (Object)BoxesRunTime.boxToBoolean((boolean)row.isNullAt(1)), (Object)BoxesRunTime.boxToBoolean((boolean)row.isNullAt(2)), (Object)BoxesRunTime.boxToBoolean((boolean)row.isNullAt(3)), (Object)BoxesRunTime.boxToBoolean((boolean)row.isNullAt(4))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple5.class)));
        $this.assertResult(new Tuple5((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)true)), checkResult[0], Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 796));
        $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(49).append("select fare,height from newView where _row_key='").append(checkRowKey).append("'").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null, null}))}));
    }

    public static final /* synthetic */ void $anonfun$new$43(TestSpark3DDL $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"COPY_ON_WRITE", (List)new .colon.colon((Object)"MERGE_ON_READ", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$44($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$50(StructField x$9) {
        String string = x$9.name();
        String string2 = "fare";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$49(TestSpark3DDL $this, File tmp$11, String tableType) {
        String tableName = $this.generateTableName();
        String tablePath = String.valueOf(new Path(tmp$11.getCanonicalPath(), tableName).toUri().toString());
        QuickstartUtils.DataGenerator dataGen = new QuickstartUtils.DataGenerator();
        Seq inserts = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(QuickstartUtils.convertToStringList((java.util.List)dataGen.generateInserts(Predef$.MODULE$.int2Integer(10)))).asScala()).toSeq();
        Dataset df = $this.spark().read().json($this.spark().sparkContext().parallelize(inserts, 2, ClassTag$.MODULE$.apply(String.class))).withColumn("ts", functions$.MODULE$.lit((Object)"20240404000000"));
        df.write().format("hudi").options(QuickstartUtils.getQuickstartWriteConfigs()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE_OPT_KEY(), tableType).option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD_OPT_KEY(), "ts").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD_OPT_KEY(), "uuid").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD_OPT_KEY(), "partitionpath").option("hoodie.schema.on.read.enable", "true").option(DataSourceWriteOptions$.MODULE$.TABLE_NAME().key(), tableName).mode("overwrite").save(tablePath);
        Seq updates = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(QuickstartUtils.convertToStringList((java.util.List)dataGen.generateUpdates(Predef$.MODULE$.int2Integer(10)))).asScala()).toSeq();
        Dataset dfUpdate = $this.spark().read().json($this.spark().sparkContext().parallelize(updates, 2, ClassTag$.MODULE$.apply(String.class))).withColumn("fare", functions$.MODULE$.expr("cast(fare as string)")).withColumn("addColumn", functions$.MODULE$.lit((Object)"new")).withColumn("ts", functions$.MODULE$.lit((Object)"20240404000005"));
        dfUpdate.drop("begin_lat").write().format("hudi").options(QuickstartUtils.getQuickstartWriteConfigs()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE_OPT_KEY(), tableType).option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD_OPT_KEY(), "ts").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD_OPT_KEY(), "uuid").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD_OPT_KEY(), "partitionpath").option("hoodie.schema.on.read.enable", "true").option("hoodie.datasource.write.reconcile.schema", "true").option(DataSourceWriteOptions$.MODULE$.TABLE_NAME().key(), tableName).mode("append").save(tablePath);
        $this.spark().sql("set hoodie.schema.on.read.enable=true");
        Dataset snapshotDF = $this.spark().read().format("hudi").load(tablePath);
        $this.assertResult(StringType$.MODULE$, ((StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])snapshotDF.schema().fields())).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TestSpark3DDL.$anonfun$new$50(x$9))))).head()).dataType(), Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 859));
        $this.assertResult("addColumn", ((StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])snapshotDF.schema().fields())).last()).name(), Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 860));
        String checkRowKey = (String)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(dfUpdate.select("fare", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collectAsList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getString(0), Buffer$.MODULE$.canBuildFrom())).head();
        snapshotDF.createOrReplaceTempView("hudi_trips_snapshot");
        $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(62).append("select fare, addColumn from  hudi_trips_snapshot where fare = ").append(checkRowKey).toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)checkRowKey, (List)new .colon.colon((Object)"new", (List)Nil$.MODULE$))}));
        $this.spark().sql("select * from  hudi_trips_snapshot").show(false);
        Seq overwrite = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(QuickstartUtils.convertToStringList((java.util.List)dataGen.generateInserts(Predef$.MODULE$.int2Integer(10)))).asScala()).toSeq();
        Dataset dfOverWrite = $this.spark().read().json($this.spark().sparkContext().parallelize(overwrite, 2, ClassTag$.MODULE$.apply(String.class))).filter("partitionpath = 'americas/united_states/san_francisco'").withColumn("ts", functions$.MODULE$.lit((Object)"20240404000010")).withColumn("fare", functions$.MODULE$.expr("cast(fare as string)"));
        dfOverWrite.write().format("hudi").options(QuickstartUtils.getQuickstartWriteConfigs()).option("hoodie.datasource.write.operation", "insert_overwrite").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD_OPT_KEY(), "ts").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD_OPT_KEY(), "uuid").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD_OPT_KEY(), "partitionpath").option("hoodie.schema.on.read.enable", "true").option("hoodie.datasource.write.reconcile.schema", "true").option(DataSourceWriteOptions$.MODULE$.TABLE_NAME().key(), tableName).mode("append").save(tablePath);
        $this.spark().read().format("hudi").load(tablePath).show(false);
        Seq updatesAgain = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(QuickstartUtils.convertToStringList((java.util.List)dataGen.generateUpdates(Predef$.MODULE$.int2Integer(10)))).asScala()).toSeq();
        Dataset dfAgain = $this.spark().read().json($this.spark().sparkContext().parallelize(updatesAgain, 2, ClassTag$.MODULE$.apply(String.class))).withColumn("fare", functions$.MODULE$.expr("cast(fare as string)")).withColumn("ts", functions$.MODULE$.lit((Object)"20240404000015"));
        dfAgain.write().format("hudi").options(QuickstartUtils.getQuickstartWriteConfigs()).option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD_OPT_KEY(), "ts").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD_OPT_KEY(), "uuid").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD_OPT_KEY(), "partitionpath").option("hoodie.schema.on.read.enable", "true").option("hoodie.datasource.write.reconcile.schema", "true").option(DataSourceWriteOptions$.MODULE$.TABLE_NAME().key(), tableName).mode("append").save(tablePath);
        $this.spark().read().format("hudi").load(tablePath).createOrReplaceTempView("hudi_trips_snapshot1");
        String checkKey = (String)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(dfAgain.select("fare", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collectAsList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.getString(0), Buffer$.MODULE$.canBuildFrom())).head();
        $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(63).append("select fare, addColumn from  hudi_trips_snapshot1 where fare = ").append(checkKey).toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)checkKey, (List)new .colon.colon(null, (List)Nil$.MODULE$))}));
    }

    public static final /* synthetic */ void $anonfun$new$48(TestSpark3DDL $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"COPY_ON_WRITE", (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestSpark3DDL.$anonfun$new$49($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$54(TestSpark3DDL $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"COPY_ON_WRITE", (List)new .colon.colon((Object)"MERGE_ON_READ", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = $this.generateTableName();
            String tablePath = String.valueOf(new Path(tmp.getCanonicalPath(), tableName).toUri().toString());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(440).append("\n             | create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  struct_col struct<f0: int, f1: string>,\n             |  ts long\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | options (\n             |  type = '").append((String)tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by (ts)\n             ").toString())).stripMargin());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(103).append("\n             | insert into ").append(tableName).append("\n             | values (1, 'a1', 10, struct(1, 'f_1'), 1000)\n              ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString());
            $this.spark().sql("set hoodie.schema.on.read.enable=true");
            $this.spark().sql(new StringBuilder(49).append("alter table ").append(tableName).append(" add columns(date_to_string_col date)").toString());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(122).append("\n             | insert into ").append(tableName).append("\n             | values (2, 'a2', 20, struct(2, 'f_2'), date '2023-03-22', 1001)\n              ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(56).append("alter table ").append(tableName).append(" alter column date_to_string_col type string").toString());
            return $this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$new$58(TestSpark3DDL $this, String tableType$1, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(368).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price float,\n             |  ts long\n             |) using hudi\n             | location '").append(tmp.getCanonicalPath()).append("'\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  type = '").append(tableType$1).append("',\n             |  preCombineField = 'ts'\n             |  ").append((Object)(tableType$1.equals("mor") ? ", hoodie.index.type = 'INMEMORY'" : "")).append("\n             | )\n           ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" values (1, 'a1', 10.024, 1000)").toString());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)tableType$1.equals("mor")), BoxesRunTime.boxToBoolean((boolean)DataSourceTestUtils.isLogFileOnly(tmp.getCanonicalPath())), Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 981));
        $this.spark().sql("set hoodie.schema.on.read.enable=true");
        $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column price type decimal(4, 2)").toString());
        $this.spark().sql(new StringBuilder(48).append("select id, name, cast(price as string), ts from ").append(tableName).toString());
        HoodieInMemoryHashIndex.clear();
    }

    public static final /* synthetic */ void $anonfun$new$61(TestSpark3DDL $this, String tableType$2, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(369).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tmp.getCanonicalPath()).append("'\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  type = '").append(tableType$2).append("',\n             |  preCombineField = 'ts'\n             |  ").append((Object)(tableType$2.equals("mor") ? ", hoodie.index.type = 'INMEMORY'" : "")).append("\n             | )\n           ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(319).append("insert into ").append(tableName).append(" values ").append("(1, 'a1', 10.024, 1000),").append("(2, 'a2', 10.025, 1000),").append("(3, 'a3', 10.026, 1000),").append("(4, 'a4', -10.024, 1000),").append("(5, 'a5', -10.025, 1000),").append("(6, 'a6', -10.026, 1000),").append("(7, 'a7', 10.034, 1000),").append("(8, 'a8', 10.035, 1000),").append("(9, 'a9', 10.036, 1000),").append("(10, 'a10', -10.034, 1000),").append("(11, 'a11', -10.035, 1000),").append("(12, 'a12', -10.036, 1000)").toString());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)tableType$2.equals("mor")), BoxesRunTime.boxToBoolean((boolean)DataSourceTestUtils.isLogFileOnly(tmp.getCanonicalPath())), Prettifier$.MODULE$.default(), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1035));
        $this.spark().sql("set hoodie.schema.on.read.enable=true");
        $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column price type decimal(4, 2)").toString());
        $this.checkAnswer(new StringBuilder(60).append("select id, name, cast(price as string), ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", "10.02", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", "10.03", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", "10.03", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", "-10.02", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", "-10.03", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", "-10.03", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "a7", "10.03", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "a8", "10.04", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), "a9", "10.04", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), "a10", "-10.03", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), "a11", "-10.04", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12), "a12", "-10.04", BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(50).append("alter table ").append(tableName).append(" alter column price type decimal(4, 2)").toString());
        $this.checkAnswer(new StringBuilder(60).append("select id, name, cast(price as string), ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", "10.02", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", "10.03", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", "10.03", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", "-10.02", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", "-10.03", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", "-10.03", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "a7", "10.03", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "a8", "10.04", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), "a9", "10.04", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), "a10", "-10.03", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), "a11", "-10.04", BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12), "a12", "-10.04", BoxesRunTime.boxToInteger((int)1000)}))}));
        HoodieInMemoryHashIndex.clear();
    }

    public static final /* synthetic */ void $anonfun$new$64(TestSpark3DDL $this, String tableType$3, String tableName) {
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(373).append("\n             |create table ").append(tableName).append(" (\n             | id int,\n             | name string,\n             | ts bigint,\n             | region string,\n             | dt date\n             |) using hudi\n             |tblproperties (\n             | primaryKey = 'id',\n             | type = '").append(tableType$3).append("',\n             | preCombineField = 'ts'\n             |)\n             |partitioned by (region, dt)").toString())).stripMargin());
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.read.extract.partition.values.from.path"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.schema.on.read.enable"), (Object)"true")}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.spark().sql(new StringBuilder(79).append("insert into ").append(tableName).append(" partition (region='reg1', dt='2023-10-01') ").append("select 1, 'name1', 1000").toString());
            $this.checkAnswer(new StringBuilder(73).append("select id, name, ts, region, cast(dt as string) from ").append(tableName).append(" where region='reg1'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "name1", BoxesRunTime.boxToInteger((int)1000), "reg1", "2023-10-01"}))}));
            $this.spark().sql(new StringBuilder(38).append("alter table ").append(tableName).append(" add columns(price double)").toString());
            $this.checkAnswer(new StringBuilder(73).append("select id, name, ts, region, cast(dt as string) from ").append(tableName).append(" where region='reg1'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "name1", BoxesRunTime.boxToInteger((int)1000), "reg1", "2023-10-01"}))}));
            $this.checkAnswer(new StringBuilder(86).append("select id, name, ts, region, cast(dt as string) from ").append(tableName).append(" where not(region='reg2' or id=2)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "name1", BoxesRunTime.boxToInteger((int)1000), "reg1", "2023-10-01"}))}));
        });
    }

    public TestSpark3DDL() {
        this.test("Test alter column types", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$3(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("Test alter column types 2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$6(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.test("Test Enable and Disable Schema on read", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$9(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("Test alter table properties and add rename drop column with table services", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$13(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        this.test("Test Chinese table ", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$27(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        this.test("Test alter column by add rename and drop", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$30(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
        this.test("Test alter column nullability", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$33(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 592));
        this.test("Test alter column multiple times", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$36(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 619));
        this.test("Test alter column with complex schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION())), (Object)"upsert"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.schema.on.read.enable"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.parquet.enableNestedColumnVectorizedReader"), (Object)"false")}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String tableName = $this.generateTableName();
                String tablePath = String.valueOf(new Path(tmp.getCanonicalPath(), tableName).toUri().toString());
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(446).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  members map<String, struct<n:string, a:int>>,\n             |  user struct<name:string, age:int, score: int>,\n             |  ts long\n             |) using hudi\n             | location '").append(tablePath).append("'\n             | options (\n             |  type = 'mor',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             ").toString())).stripMargin());
                $this.spark().sql(new StringBuilder(47).append("alter table ").append(tableName).append(" alter column members.value.a first").toString());
                $this.spark().sql(new StringBuilder(122).append("insert into ").append(tableName).append(" values(1, 'jack', map('k1', struct(100, 'v1'), 'k2', struct(200, 'v2')), struct('jackStruct', 29, 100), 1000)").toString());
                $this.spark().sql(new StringBuilder(40).append("alter table ").append(tableName).append(" rename column user to userx").toString());
                $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(49).append("select ts, userx.score, id, userx.age, name from ").append(tableName).toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)100), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)29), "jack"}))}));
                $this.spark().sql(new StringBuilder(56).append("alter table ").append(tableName).append(" drop columns(name, userx.name, userx.score)").toString());
                $this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString()).show(false);
                $this.spark().sql(new StringBuilder(186).append("alter table ").append(tableName).append(" add columns(name string comment 'add name back' after userx,").append(" userx.name string comment 'add userx.name back' first, userx.score int comment 'add userx.score back' after age)").toString());
                $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(42).append("select name, userx.name, userx.score from ").append(tableName).toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null, null, null}))}));
                $this.spark().sql(new StringBuilder(131).append("insert into ").append(tableName).append(" values(2 , map('k1', struct(100, 'v1'), 'k2', struct(200, 'v2')), struct('jackStructNew', 291 , 101), 'jacknew', 1000)").toString());
                $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(71).append("select name, userx.name as uxname, userx.score as uxs from ").append(tableName).append(" order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null, null, null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"jacknew", "jackStructNew", BoxesRunTime.boxToInteger((int)101)}))}));
                $this.spark().sql(new StringBuilder(45).append("alter table ").append(tableName).append(" alter column userx.age type long").toString());
                $this.spark().sql(new StringBuilder(32).append("select userx.age, id, name from ").append(tableName).toString());
                $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(44).append("select userx.age, id, name from ").append(tableName).append(" order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)29), BoxesRunTime.boxToInteger((int)1), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)291), BoxesRunTime.boxToInteger((int)2), "jacknew"}))}));
                $this.spark().sql(new StringBuilder(46).append("alter table ").append(tableName).append(" add columns(mxp map<String, int>)").toString());
                $this.spark().sql(new StringBuilder(144).append("insert into ").append(tableName).append(" values(2, map('k1', struct(100, 'v1'), 'k2', struct(200, 'v2')), struct('jackStructNew', 291 , 101), 'jacknew', 1000, map('t1', 9))").toString());
                $this.spark().sql(new StringBuilder(47).append("alter table ").append(tableName).append(" alter column mxp.value type double").toString());
                $this.spark().sql(new StringBuilder(145).append("insert into ").append(tableName).append(" values(2, map('k1', struct(100, 'v1'), 'k2', struct(200, 'v2')), struct('jackStructNew', 291 , 101), 'jacknew', 1000, map('t1', 10))").toString());
                $this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString()).show(false);
                $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(28).append("select mxp from ").append(tableName).append(" order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null})), (Seq)new .colon.colon((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t1"), (Object)BoxesRunTime.boxToDouble((double)10.0))}))), (List)Nil$.MODULE$)}));
                $this.spark().sql(new StringBuilder(41).append("alter table ").append(tableName).append(" rename column members to mem").toString());
                $this.spark().sql(new StringBuilder(44).append("alter table ").append(tableName).append(" rename column mem.value.n to nn").toString());
                $this.spark().sql(new StringBuilder(38).append("alter table ").append(tableName).append(" rename column userx to us").toString());
                $this.spark().sql(new StringBuilder(41).append("alter table ").append(tableName).append(" rename column us.age to age1").toString());
                $this.spark().sql(new StringBuilder(145).append("insert into ").append(tableName).append(" values(2, map('k1', struct(100, 'v1'), 'k2', struct(200, 'v2')), struct('jackStructNew', 291 , 101), 'jacknew', 1000, map('t1', 10))").toString());
                $this.spark().sql(new StringBuilder(46).append("select mem.value.nn, us.age1 from ").append(tableName).append(" order by id").toString()).show();
                $this.checkAnswer((Row[])$this.spark().sql(new StringBuilder(46).append("select mem.value.nn, us.age1 from ").append(tableName).append(" order by id").toString()).collect(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)29)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)291)}))}));
            });
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 655));
        this.test("Test schema auto evolution complex", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$43(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 742));
        this.sparkOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.RECORD_MERGE_IMPL_CLASSES.key()), (Object)DefaultSparkRecordMerger.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT.key()), (Object)"parquet")}));
        this.test("Test schema auto evolution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$48(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
        this.test("Test DATE to STRING conversions when vectorized reading is not enabled", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestSpark3DDL.$anonfun$new$54(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 911));
        this.test("Test FLOAT to DECIMAL schema evolution (lost in scale)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestSpark3DDL.$anonfun$new$58($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 957));
        this.test("Test DOUBLE or STRING to DECIMAL schema evolution (lost in scale)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestSpark3DDL.$anonfun$new$61($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 995));
        this.test("Test extract partition values from path when schema evolution is enabled", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTable(this.generateTableName(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tableName -> {
                TestSpark3DDL.$anonfun$new$64($this, tableType, tableName);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestSpark3DDL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1078));
    }
}

